package co.pixelbeard.theanfieldwrap.utils;

import android.content.Context;
import android.content.DialogInterface;

import co.pixelbeard.theanfieldwrap.dialog.DeviceLimitDialog;
import co.pixelbeard.theanfieldwrap.dialog.SingleButtonDialog;
import co.pixelbeard.theanfieldwrap.dialog.twoButton.TwoButtonDialog;
import co.pixelbeard.theanfieldwrap.dialog.twoButton.TwoButtonDialogListener;

public class DialogUtils {

    public static void showTwoButtonDialog(String title, String body, Context context, TwoButtonDialogListener listener) {
        if (context != null) {
            TwoButtonDialog dialog = new TwoButtonDialog(title, body, context, listener);
            dialog.setCanceledOnTouchOutside(false);
            dialog.show();
        }
    }

    public static void showSingleButtonDialog(String title, String body, Context context, DialogInterface.OnDismissListener dismissListener) {
        if (context != null) {
            SingleButtonDialog dialog = new SingleButtonDialog(title, body, null, context);
            if (dismissListener != null) {
                dialog.setOnDismissListener(dismissListener);
            }
            dialog.show();
        }
    }

    public static void showSingleButtonDialogCustomButton(String title, String body, String buttonText, Context context, DialogInterface.OnDismissListener dismissListener) {
        if (context != null) {
            SingleButtonDialog dialog = new SingleButtonDialog(title, body, buttonText, context);
            if (dismissListener != null) {
                dialog.setOnDismissListener(dismissListener);
            }
            dialog.show();
        }
    }

    public static void showDeviceLimitDialog(Context context, TwoButtonDialogListener listener) {
        if (context != null) {
            DeviceLimitDialog deviceLimitDialog = new DeviceLimitDialog(context, listener);
            deviceLimitDialog.show();
        }
    }

}
