package co.pixelbeard.theanfieldwrap.utils;

import android.Manifest;
import android.app.Activity;
import android.content.Context;
import android.content.pm.PackageManager;

import androidx.core.app.ActivityCompat;

/**
 * Created by Michael Stoddart
 * 12/08/2018.
 */
public class PermissionUtils {

    public static int REQUEST_READ_PHONE_STATE_CODE = 99;


    public static boolean checkReadPhoneStatePermission(Context mContext) {
        int result = mContext.checkCallingOrSelfPermission(Manifest.permission.READ_PHONE_STATE);
        return result == PackageManager.PERMISSION_GRANTED;
    }

    public static void requestReadPhoneStatePermission(Activity activity) {
        ActivityCompat.requestPermissions(activity, new String[]{Manifest.permission.READ_PHONE_STATE}, REQUEST_READ_PHONE_STATE_CODE);
    }


}

