package co.pixelbeard.theanfieldwrap.videoDetails;

import co.pixelbeard.theanfieldwrap.data.Video;
import co.pixelbeard.theanfieldwrap.utils.BasePresenter;
import co.pixelbeard.theanfieldwrap.utils.BaseView;

public interface VideoDetailContract {

    interface View extends BaseView<Presenter> {
        void setVideo(Video video);

        void setVideoPurchased(boolean isPurchased);

        void showErrorDialog(String message);

        void showBalanceTooLowDialog();

        void updateWalletBalance(int balance);
    }

    interface Presenter extends BasePresenter {
        void recordAnalytic(String type, String variable, String secondVar);

        void getVideoById(String id);

        void purchaseItem(String id);

        void checkWalletBalance();
    }
}