package co.pixelbeard.theanfieldwrap.wallet.viewholders;

import android.text.Html;
import android.view.View;
import android.widget.TextView;

import androidx.annotation.NonNull;

import com.google.gson.Gson;
import com.makeramen.roundedimageview.RoundedImageView;

import butterknife.BindView;
import butterknife.ButterKnife;
import co.pixelbeard.theanfieldwrap.R;
import co.pixelbeard.theanfieldwrap.data.Podcast;
import co.pixelbeard.theanfieldwrap.data.Transaction;
import co.pixelbeard.theanfieldwrap.podcasts.OnPodcastSelectedListener;
import co.pixelbeard.theanfieldwrap.utils.DateUtils;
import co.pixelbeard.theanfieldwrap.utils.FontUtils;
import co.pixelbeard.theanfieldwrap.utils.GlideApp;

public class WalletPodcastViewHolder extends BaseWalletViewHolder {

    @BindView(R.id.img_podcast)
    RoundedImageView imgPodcast;
    @BindView(R.id.txt_podcast)
    TextView txtPodcast;
    @BindView(R.id.txt_purchase_date)
    TextView txtPurchaseDate;
    @BindView(R.id.txt_podcast_title)
    TextView txtPodcastTitle;

    private OnPodcastSelectedListener mListener;


    public WalletPodcastViewHolder(@NonNull View itemView, OnPodcastSelectedListener listener) {
        super(itemView);

        ButterKnife.bind(this, itemView);

        this.mListener = listener;

        txtPodcast.setTypeface(FontUtils.getInstance().getDinProBlack());
        txtPodcastTitle.setTypeface(FontUtils.getInstance().getDinAlternateBold());
        txtPurchaseDate.setTypeface(FontUtils.getInstance().getDinAlternateBold());

    }

    @Override
    public void bindView(Transaction transaction) {
        super.bindView(transaction);

        Podcast podcast = new Gson().fromJson(transaction.getContentObject(), Podcast.class);

        if (podcast != null) {
            GlideApp.with(itemView.getContext()).load(podcast.getThumbnail()).placeholder(R.drawable.ic_placeholder_podcast_small).into(imgPodcast);

            txtPodcastTitle.setText(Html.fromHtml(podcast.getTitle()));
            txtPurchaseDate.setText(DateUtils.getDateddMMYYYY(transaction.getEntryDate()));
            itemView.setOnClickListener(v -> mListener.onPodcastSelected(podcast));
        }
    }
}
