package co.pixelbeard.theanfieldwrap.writingDetails.viewholders;

import android.view.View;
import android.widget.ImageView;

import androidx.annotation.NonNull;

import butterknife.BindView;
import butterknife.ButterKnife;
import co.pixelbeard.theanfieldwrap.R;
import co.pixelbeard.theanfieldwrap.utils.GlideApp;

public class ContentImageViewHolder extends BaseContentViewHolder {

    @BindView(R.id.img_image_content)
    ImageView imgImageContent;

    public ContentImageViewHolder(@NonNull View itemView) {
        super(itemView);

        ButterKnife.bind(this, itemView);


    }

    @Override
    public void bindView(String content) {
        super.bindView(content);

        GlideApp.with(itemView.getContext())
                .load(content)
                .placeholder(R.drawable.ic_placeholder_writing_large)
                .into(imgImageContent);
    }
}
