package co.pixelbeard.theanfieldwrap.splash;

import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.robolectric.Robolectric;
import org.robolectric.RobolectricTestRunner;
import org.robolectric.annotation.Config;

import co.pixelbeard.theanfieldwrap.data.source.DataRepository;
import co.pixelbeard.theanfieldwrap.data.source.local.LocalRepository;
import co.pixelbeard.theanfieldwrap.data.source.remote.RemoteRepository;

import static org.mockito.Mockito.verify;

/**
 * Created by Michael Stoddart
 * 17/12/2018.
 */
@RunWith(RobolectricTestRunner.class)
@Config(sdk = 28)
public class SplashActivityTest {


    private SplashActivity activity;

    private SplashPresenter presenter;
    private DataRepository repository;

    @Mock
    private SplashContract.View mSplashView;

    @Mock
    private RemoteRepository remoteRepository;

    @Mock
    private LocalRepository localRepository;


    @Before
    public void setup() {


        MockitoAnnotations.initMocks(this);

        activity = Robolectric.setupActivity(SplashActivity.class);
        remoteRepository = Mockito.mock(RemoteRepository.class);
        localRepository = Mockito.mock(LocalRepository.class);

        repository = new DataRepository(localRepository, remoteRepository);


        presenter = new SplashPresenter(activity, repository);

        activity.setPresenter(presenter);


    }


    @Test
    public void presenterIsSetToView() {
        presenter = new SplashPresenter(mSplashView, repository);
        verify(activity).setPresenter(presenter);
    }
}
