<?php
defined('BASEPATH') OR exit('No direct script access allowed');

$route['default_controller'] = 'front/hello_world';
$route['404_override'] = '';
$route['translate_uri_dashes'] = FALSE;

/* Hello World START */
$route['api/hello'] = 'MobileAPI/hello_world';
$route['api/admin/hello'] = 'AdminAPI/hello_world';
$route['hello'] = 'front/hello_world';
$route['admin'] = 'admin/hello_world';
/* Hello World END */

$route[LOGIN_PAGE] = 'examples/login';

/* Extra Admin Calls */
$route['api/admin/tokens/award/(:num)/(:num)/(:num)'] = 'AdminAPI/awardTokensToUsers/$1/$2/$3';

/* User Services Requests Start */
$route['api/users/login'] = 'MobileAPI/loginTheUser';
$route['api/users/logout'] = 'MobileAPI/logoutTheUser';
$route['api/users/register'] = 'MobileAPI/registerTheUser';
$route['api/users/activate'] = 'MobileAPI/activateTheUser';
$route['api/users/recover'] = 'MobileAPI/recoverTheUser';
$route['api/users/reset'] = 'MobileAPI/resetTheUsersPassword';
$route['api/users/password'] = 'MobileAPI/changeTheUsersPassword';
$route['api/users/update'] = 'MobileAPI/updateUsersDetails';
$route['api/users/update/email'] = 'MobileAPI/updateUsersEmail';
$route['api/users/avatar/upload'] = 'MobileAPI/updateUsersAvatar';
$route['api/users/email/check'] = 'MobileAPI/checkIfEmailExists';
$route['api/users/username/check'] = 'MobileAPI/checkIfUsernameExists';
$route['api/token/generate'] = 'MobileAPI/generateToken';
$route['api/users/register/guest'] = 'MobileAPI/registerTheGuestUser';
$route['api/users/register/guest/convert'] = 'MobileAPI/convertTheGuestUserToFullAccount';
$route['api/auth/check'] = 'MobileAPI/checkAuthCode';
$route['api/users/activation/resend'] = 'MobileAPI/resendActivationCode';
$route['api/users/subscription/check'] = 'MobileAPI/checkSubscriptionForUser';
$route['api/users/preferences/(:any)'] = 'MobileAPI/updateNotificationPreferencesForUser/$1';
$route['api/users/preferences'] = 'MobileAPI/getNotificationPreferencesForUser';
$route['api/users/amember/associate'] = 'MobileAPI/associateExistingAMemberAccountWithUser';
$route['api/users/notifications/associate'] = 'MobileAPI/associateNotificationTokenWithUser';

/* Subscription Requests */
$route['api/users/subscriptions'] = 'MobileAPI/checkUsersCurrentSubscription';
$route['api/system/webhooks/paypal/events'] = 'SubscriptionsAPI/handlePayPalEvent';
$route['api/system/connections/braintree'] = 'SubscriptionsAPI/helloBraintree';
$route['api/system/connections/paypal/gateway'] = 'SubscriptionsAPI/createClientToken';
$route['api/system/connections/paypal/gateway/purchase/test'] = 'SubscriptionsAPI/testPurchase';
$route['api/system/connections/paypal/customer/create'] = 'SubscriptionsAPI/createNewCustomer';
$route['checkout/payment'] = 'front/checkout_payment';
$route['checkout/subscriptions'] = 'front/checkout_subscriptions';
$route['checkout/checkout'] = 'front/checkout_checkout';
$route['checkout/response/(:any)'] = 'front/checkout_response/$1';
$route['checkout/customer/create'] = 'front/create_customer_with_nonce';
$route['api/checkout/sub/plans'] = 'SubscriptionsAPI/get_plans';
$route['api/checkout/complete'] = 'SubscriptionsAPI/complete_checkout';
$route['api/checkout/customer/create'] = 'SubscriptionsAPI/api_create_customer';
$route['api/checkout/customer/find'] = 'SubscriptionsAPI/api_find_customer';
$route['api/checkout/sub/info'] = 'SubscriptionsAPI/api_get_sub_info';
$route['api/checkout/sub/info'] = 'SubscriptionsAPI/api_get_sub_info';
$route['api/checkout/invoice/create'] = 'SubscriptionsAPI/create_new_invoice';

$route['api/free-subscriptions'] = 'SubscriptionsAPI/getFreeSubscriptions';
$route['api/user/activate-subscription'] = 'SubscriptionsAPI/activateUserSubscription';

/* Admin Requests */
$route['api/admin/users/search'] = 'AdminAPI/adminSearchUsers';
$route['api/admin/users/update'] = 'AdminAPI/adminUpdateUsersDetails';
$route['api/admin/users/add'] = 'AdminAPI/adminRegisterUser';
$route['api/admin/users/page/(:num)/auth/(:num)'] = 'AdminAPI/getUsersPaginated/$1/$2';
$route['api/admin/user/(:num)'] = 'AdminAPI/getUser/$1';
$route['api/admin/user/(:num)/edit'] = 'AdminAPI/editUser/$1';
$route['api/admin/user/devices/remove'] = 'AdminAPI/unlinkDeviceByID';
$route['api/admin/notifications/list'] = 'AdminAPI/getSentNotifications';
$route['api/admin/notifications/send'] = 'AdminAPI/sendNewBespokeNotificationToUsers';
$route['api/admin/tokens/generate/test'] = 'AdminAPI/testGenerationOfTokensAtSameTime';
$route['api/admin/users/subscribed/(:any)'] = 'AdminAPI/getSubscribersForNotificationType/$1';
$route['api/admin/password/check'] = 'AdminAPI/checkPasswordEncryption';
// $route['api/admin/free-subscription/update'] = 'AdminAPI/updateFreeSubscriptionDuration';
// $route['api/admin/free-subscription/duration'] = 'AdminAPI/getFreeSubscriptionDuration';


/* Admin Requests */

/* webhooks requests */
$route['api/admin/webhooks/users/update/amember'] = 'AdminAPI/updateUserFromAMemberWebhook';
/* webhooks requests */

/* User Services Requests End */

/* Analytics Requests Start */
$route['api/admin/analytics/page/(:num)/limit/(:num)'] = 'AdminAPI/getAnalytics/$1/$2';
$route['api/admin/analytics/page/(:num)/limit/(:num)/user/(:any)'] = 'AdminAPI/getAnalyticsForUser/$1/$2/$3';
$route['api/admin/analytics/page/(:num)/limit/(:num)/type/(:any)'] = 'AdminAPI/getAnalyticsForType/$1/$2/$3';
$route['api/admin/analytics/types'] = 'AdminAPI/getAnalyticsTypes';
$route['api/admin/analytics/export'] = 'AdminAPI/exportCSVUsingParams';
$route['api/admin/analytics/count'] = 'AdminAPI/countForAnalyticsType';
$route['api/admin/analytics/marketplace'] = 'AdminAPI/getMarketplaceStats';
$route['api/admin/analytics/users'] = 'AdminAPI/getUsersStats';
$route['api/admin/analytics/articles/views'] = 'AdminAPI/getTopViewedArticles';
$route['api/admin/analytics/podcasts/views'] = 'AdminAPI/getTopViewedPodcasts';
$route['api/admin/analytics/videos/views'] = 'AdminAPI/getTopViewedVideos';
$route['api/analytics/record'] = 'MobileAPI/recordAnalyticPoint';
$route['api/admin/analytics/link'] = 'AdminAPI/displayDownloadLink';

/* Analytics Requests End */

/* Debug Requests Start */
$route['api/admin/notifications/podcasts/new'] = 'AdminAPI/sendNewPodcastNotificationToUsers';
/* Debug Requests End */

/* Wallet Requests Start */
$route['api/users/wallet'] = 'MobileAPI/getWalletForUser';
$route['api/users/wallet/purchase'] = 'MobileAPI/purchaseProduct';
$route['api/users/wallet/orders'] = 'MobileAPI/getOrdersForUser';
$route['api/users/wallet/credit'] = 'MobileAPI/creditUserAccount';
/* Wallet Requests End */

/* Device Management Start */
$route['api/users/devices'] = 'MobileAPI/getDevicesForUser';
$route['api/users/devices/remove'] = 'MobileAPI/unlinkDeviceForUser';
/* Device Management Start */

/* Wordpress Requests Start */
/* Admin */
$route['api/admin/feed/podcasts/(:num)'] = 'MobileAPI/getPodcastFeedFromWordpress/$1';
$route['api/admin/feed/writing/(:num)'] = 'MobileAPI/getWritingFeedFromWordpress/$1';
$route['api/admin/feed/videos/(:num)'] = 'MobileAPI/getVideosFeedFromWordpress/$1';
$route['api/admin/feed/youtube/videos'] = 'MobileAPI/getVideosFeedFromYoutube';
/* User */
$route['api/feed/podcasts/(:num)/limit/(:num)'] = 'MobileAPI/getPodcastFeed/$1/$2';
$route['api/feed/podcast/(:num)'] = 'MobileAPI/getPodcastByID/$1';
$route['api/feed/videos/(:num)/limit/(:num)'] = 'MobileAPI/getVideosFeed/$1/$2';
$route['api/feed/video/(:any)'] = 'MobileAPI/getVideoByID/$1';
$route['api/feed/writing/(:num)/limit/(:num)'] = 'MobileAPI/getWritingFeed/$1/$2';
$route['api/feed/article/(:num)'] = 'MobileAPI/getArticleByID/$1';
/* Wordpress Requests End */

$route['api/feed/article/(:num)'] = 'MobileAPI/getArticleByID/$1';
