//
//  SkeletonTableViewProtocols.swift
//  SkeletonView-iOS
//
//  Created by Juanpe Catalán on 06/11/2017.
//  Copyright © 2017 SkeletonView. All rights reserved.
//

import UIKit

public protocol SkeletonTableViewDataSource: UITableViewDataSource {
    func numSections(in collectionSkeletonView: UITableView) -> Int
    func collectionSkeletonView(_ skeletonView: UITableView, numberOfRowsInSection section: Int) -> Int
    func collectionSkeletonView(_ skeletonView: UITableView, cellIdentifierForRowAt indexPath: IndexPath) -> ReusableCellIdentifier
}

public extension SkeletonTableViewDataSource {
    
    func collectionSkeletonView(_ skeletonView: UITableView, numberOfRowsInSection section: Int) -> Int {
        return skeletonView.estimatedNumberOfRows
    }
    
    func numSections(in collectionSkeletonView: UITableView) -> Int { return 1 }

    /// Keeping the misspelled version around until it can be deprecated
    /// Right now, it just calls the new correctly spelled method and returns its result
    @available(*, deprecated, renamed: "collectionSkeletonView(_:cellIdentifierForRowAt:)")
    func collectionSkeletonView(_ skeletonView: UITableView, cellIdenfierForRowAt indexPath: IndexPath) -> ReusableCellIdentifier {
        return collectionSkeletonView(skeletonView, cellIdentifierForRowAt: indexPath)
    }
}

public protocol SkeletonTableViewDelegate: UITableViewDelegate {
}
