//
//  AppDelegate.swift
//  TAW
//
//  Created by Andrew Steven on 14/12/2018.
//  Copyright © 2018 PixelBeard. All rights reserved.
//

import UIKit
import IQKeyboardManagerSwift
import OneSignal
import Firebase
import AVKit
import RealmSwift
import StoreKit
import FBSDKCoreKit

@UIApplicationMain
class AppDelegate: UIResponder, UIApplicationDelegate  {

    var window: UIWindow?
    
    var avplayer: AVPlayer?
    
    var backgroundSessionCompletionHandler: (() -> Void)?

    func application(_ application: UIApplication,
                     didFinishLaunchingWithOptions launchOptions: [UIApplication.LaunchOptionsKey: Any]?) -> Bool {
        // Override point for customization after application launch.
        
//         TestFairy.begin("8f17913e60b6c2d5e0d7c365b2c1b158eba3c11d")
        FBSDKCoreKit.ApplicationDelegate.shared.application(application, didFinishLaunchingWithOptions: launchOptions)
        if #available(iOS 13.0, *) {
            window?.overrideUserInterfaceStyle = .light
        } 
        
        let audioSession = AVAudioSession.sharedInstance()
        do {
            try audioSession.setCategory(AVAudioSession.Category.playback, mode: AVAudioSession.Mode.spokenAudio)
        } catch {
            print("Setting category to AVAudioSessionCategoryPlayback failed.")
        }
        
        // Keyboard Support via IQKeyboardManager
        IQKeyboardManager.shared.enable = true
        IQKeyboardManager.shared.toolbarTintColor = UIColor(red: 237/255, green: 28/255, blue: 36/255, alpha: 1.0)
        
//        let friendlyName = UIDevice.current.name
//        print("Friendly name: \(friendlyName)")

        if LocalStorage.shared.uuid == nil {
            if let deviceId = UIDevice.current.identifierForVendor?.uuidString {
                LocalStorage.shared.uuid = deviceId
            }
        }
        
        IAPClient.shared.getInAppPurchaseTiers()
        
        let notificationOpenedBlock: OSHandleNotificationActionBlock = { result in
            
            // This block gets called when the user reacts to a notification received
            let payload: OSNotificationPayload? = result?.notification.payload
            
            // Need to get the product_id so that I can push the user to the relevant product view
            if let additionalData = payload!.additionalData {
//                print("push notification data = \(additionalData)")

                if let postId = additionalData["post_id"] as? String, let type = additionalData["type"] as? String {
                    if LocalStorage.shared.loggedIn {
                        if type == "podcast" {
                            // Get podcast using post_id
                            self.getPodcast(postId: postId)
                        } else if type == "video" {
                            // Get video using post_id
                            self.getVideo(postId: postId)
                        } else if type == "article" {
                            // Get article using post_id
                            self.getArticle(postId: postId)
                        }
                    }
                }
            }
        }
        
        let onesignalInitSettings = [kOSSettingsKeyAutoPrompt: false]
        
        // Replace 'YOUR_APP_ID' with your OneSignal App ID.
        OneSignal.initWithLaunchOptions(launchOptions,
                                        appId: "b85c6195-a943-4a17-8f3e-187c7132276b",
                                        handleNotificationAction: notificationOpenedBlock,
                                        settings: onesignalInitSettings)
        
        OneSignal.inFocusDisplayType = OSNotificationDisplayType.notification
        
        PBAppStoreReviewer.incrementAppOpened()
        
        FirebaseApp.configure()
        Crashlytics.sharedInstance().debugMode = false
        
        // Run any migrations needed to update Realm models to the latest values
        self.applyRealmMigrations()
        
        return true
    }

    func applicationDidBecomeActive(application: UIApplication) {
        // Call the 'activate' method to log an app event for use
        // in analytics and advertising reporting.
        AppEvents.activateApp()
    }
    
    private func applyRealmMigrations() {
        
        let config = Realm.Configuration(
            // Set the new schema version. This must be greater than the previously used
            // version (if you've never set a schema version before, the version is 0).
            schemaVersion: 5,
            
            // Set the block which will be called automatically when opening a Realm with
            // a schema version lower than the one set above
            migrationBlock: { migration, oldSchemaVersion in
                // We haven’t migrated anything yet, so oldSchemaVersion == 0
                if (oldSchemaVersion < 1) {
     
                }
                
                if (oldSchemaVersion < 2) {

                }
                
                if (oldSchemaVersion < 3) {
                    
                }
                
                if (oldSchemaVersion < 4) {
                    
                }

                if (oldSchemaVersion < 5) {

                }
        })
        
        // Tell Realm to use this new configuration object for the default Realm
        Realm.Configuration.defaultConfiguration = config
        
        // Now that we've told Realm how to handle the schema change, opening the file
        // will automatically perform the migration
        let realm = try! Realm()
    }
    
    private func getPodcast(postId: String) {
        APIClient.getPodcastById(postId: postId) { (jsonResponse, error) in
            if jsonResponse["success"] as? Bool == true {
                if let podcastData = jsonResponse["podcast"] as? [String: Any] {
                    if let podcast = Podcast(JSON: podcastData) {
                        self.showPodcastView(podcast: podcast)
                    }
                }
            }
        }
    }
    
    private func showPodcastView(podcast: Podcast) {
        let storyboard = UIStoryboard(name: "Main", bundle: nil)
        if let tawVC = storyboard.instantiateViewController(withIdentifier: "podcastDetailVC") as? TAWPodcastDetailViewController {
            tawVC.podcast = podcast
            if let root = self.window?.rootViewController as? UITabBarController {
                if let nav = root.selectedViewController as? UINavigationController {
                    nav.pushViewController(tawVC, animated: true)
                }
            }
        }
    }
    
    private func getVideo(postId: String) {
        APIClient.getVideoById(postId: postId) { (jsonResponse, error) in
            if jsonResponse["success"] as? Bool == true {
                if let videoData = jsonResponse["video"] as? [String: Any] {
                    if let video = Video(JSON: videoData) {
                        self.showVideoView(video: video)
                    }
                }
            }
        }
    }
    
    private func showVideoView(video: Video) {
        let storyboard = UIStoryboard(name: "Main", bundle: nil)
        if let tawVC = storyboard.instantiateViewController(withIdentifier: "videoDetailVC") as? TAWVideoDetailViewController {
            tawVC.video = video
            if let root = self.window?.rootViewController as? UITabBarController {
                if let nav = root.selectedViewController as? UINavigationController {
                    nav.pushViewController(tawVC, animated: true)
                }
            }
        }
    }
    
    private func getArticle(postId: String) {
        APIClient.getArticleById(postId: postId) { (jsonResponse, error) in
            if jsonResponse["success"] as? Bool == true {
                if let articleData = jsonResponse["article"] as? [String: Any] {
                    if let article = Writing(JSON: articleData) {
                        self.showArticleView(article: article)
                    }
                }
            }
        }
    }
    
    private func showArticleView(article: Writing) {
        let storyboard = UIStoryboard(name: "Main", bundle: nil)
        if let tawVC = storyboard.instantiateViewController(withIdentifier: "articleDetailVC") as? TAWWritingDetailViewController {
            tawVC.writing = article
            if let root = self.window?.rootViewController as? UITabBarController {
                if let nav = root.selectedViewController as? UINavigationController {
                    nav.pushViewController(tawVC, animated: true)
                }
            }
        }
    }

    func application(_ application: UIApplication, open url: URL, sourceApplication: String?, annotation: Any) -> Bool {

        if sourceApplication == "com.facebook.Facebook" {
            return FBSDKCoreKit.ApplicationDelegate.shared.application(application, open: url, sourceApplication: sourceApplication, annotation: annotation)
        }

        return true
    }
    
    func application(_ application: UIApplication,
                     supportedInterfaceOrientationsFor window: UIWindow?) -> UIInterfaceOrientationMask {
        if let rootViewController = self.topViewControllerWith(rootViewController: window?.rootViewController) {
            if rootViewController.responds(to: Selector(("canRotate"))) {
                // Unlock landscape view orientations for this view controller
                return .allButUpsideDown
            }
        }
        
        // Only allow portrait (standard behaviour)
        return .portrait
    }
    
    private func topViewControllerWith(rootViewController: UIViewController!) -> UIViewController? {
        if rootViewController == nil { return nil }
        if rootViewController.isKind(of: UITabBarController.self) {
            return topViewControllerWith(rootViewController: (rootViewController as? UITabBarController)?.selectedViewController)
        } else if rootViewController.isKind(of: UINavigationController.self) {
            return topViewControllerWith(rootViewController: (rootViewController as? UINavigationController)?.visibleViewController)
        } else if rootViewController.presentedViewController != nil {
            return topViewControllerWith(rootViewController: rootViewController.presentedViewController)
        }
        return rootViewController
    }

    func application(_ application: UIApplication,
                     handleEventsForBackgroundURLSession identifier: String,
                     completionHandler: @escaping () -> Void) {
        backgroundSessionCompletionHandler = completionHandler
    }

    func applicationWillResignActive(_ application: UIApplication) {
        // Sent when the application is about to move from active to inactive state.
        // This can occur for certain types of temporary interruptions
    }

    func applicationDidEnterBackground(_ application: UIApplication) {
        
        if var topController = UIApplication.shared.keyWindow?.rootViewController {
            while let presentedViewController = topController.presentedViewController {
                topController = presentedViewController
            }
            
            if let root = self.window?.rootViewController as? UITabBarController {
                if let nav = root.selectedViewController as? UINavigationController {
                    if let viewController = nav.visibleViewController {
                        let name = String(describing: viewController.self)
                        APIClient.recordAnalytic(.userBackgroundedApp, variable: name, secondaryVariable: "1")
                        
                        if let playerViewController = viewController as? AVPlayerViewController {
                            // If presenting video with AVPlayerViewController
                            self.avplayer = playerViewController.player
                            playerViewController.player = nil
                        }
                    }
                }
            }
        }
    }

    func applicationWillEnterForeground(_ application: UIApplication) {
        // Called as part of the transition from the background to the active state;
        // here you can undo many of the changes made on entering the background.
        
        if var topController = UIApplication.shared.keyWindow?.rootViewController {
            while let presentedViewController = topController.presentedViewController {
                topController = presentedViewController
            }

            if let root = self.window?.rootViewController as? UITabBarController {
                if let nav = root.selectedViewController as? UINavigationController {
                    if let viewController = nav.visibleViewController {

                        if let playerViewController = viewController as? AVPlayerViewController {
                            // If presenting video with AVPlayerViewController
                            playerViewController.player = self.avplayer
                        }
                    }
                }
            }
        }
    }

    func applicationDidBecomeActive(_ application: UIApplication) {
        // Restart any tasks that were paused (or not yet started) while the application was inactive.
        // If the application was previously in the background, optionally refresh the user interface.
    }

    func applicationWillTerminate(_ application: UIApplication) {
        // Called when the application is about to terminate.

//        if let podcast = PBAudioPlayer.shared.podcast {
//            let podcastId: String = podcast.postId
//            let elapsedTime: Double = PBAudioPlayer.shared.elapsedTime
//            let preview: Bool = PBAudioPlayer.shared.isPreview
//            
//            if !preview {
//                let storedData: [String: Any?] = [
//                    "podcast_id": podcastId,
//                    "elapsed": elapsedTime,
//                    "preview": preview
//                ]
//                UserDefaults.standard.set(storedData, forKey: "restorePodcast")
//            }
//        }
    }
}
