//
//  Constants.swift
//  The Anfield Wrap
//
//  Created by Andrew Steven on 20/06/2018.
//  Copyright © 2018 PixelBeard. All rights reserved.
//

import Foundation
import UIKit
import Alamofire

class Connectivity {
    class var isConnectedToInternet: Bool {
        return NetworkReachabilityManager()!.isReachable
    }
}

struct TAW {
    
    struct ProductionServer {
      //  static let baseURL = "https://api-taw.pixelbeard.co/api/"
        static let apiToken = "43380617cb5c9fd35f84e277e97be08d"
        static let baseURL = "http://taw-dev-be.studiographene.xyz/api/"
        
    }
    
    struct Urls {
        static let termsOfService = "https://www.theanfieldwrap.com/taw-player/terms-of-service/"
        static let privacyPolicy = "https://www.theanfieldwrap.com/privacy/"
        static let help = "https://taw.helpscoutdocs.com/"
    }
    
    struct Fonts {
        static let textFieldTitleFont = UIFont(name: "DINAlternate-Bold", size: 12)
        static let textFieldTextFont = UIFont(name: "DINAlternate-Bold", size: 16)
        
        static let dinPro22 = UIFont(name: "DINPro-Black", size: 22)
        static let dinPro24 = UIFont(name: "DINPro-Black", size: 24)
        static let dinPro29 = UIFont(name: "DINPro-Black", size: 29)
        
        static let dinAlternate8 = UIFont(name: "DINAlternate-Bold", size: 8)
        static let dinAlternate10 = UIFont(name: "DINAlternate-Bold", size: 10)
        static let dinAlternate14 = UIFont(name: "DINAlternate-Bold", size: 14)
        static let dinAlternate16 = UIFont(name: "DINAlternate-Bold", size: 16)
        static let dinAlternate17 = UIFont(name: "DINAlternate-Bold", size: 17)
        static let dinAlternate18 = UIFont(name: "DINAlternate-Bold", size: 18)
        static let dinAlternate21 = UIFont(name: "DINAlternate-Bold", size: 21)
        static let dinAlternate27 = UIFont(name: "DINAlternate-Bold", size: 27)
        
        static let unitedSans13 = UIFont(name: "UnitedSansReg-Heavy", size: 13)
        
        static let arialRegular14 = UIFont(name: "ArialMT", size: 14)
        static let arialRegular16 = UIFont(name: "ArialMT", size: 16)
        
//        static let dinCondensed11 = UIFont(name: "DINCondensed-Bold", size: 13)
    }
    
    struct Colors {
        
        static let redButtonColor = UIColor(red: 237/255, green: 28/255, blue: 36/255, alpha: 1.0)
        static let greyButtonColor = UIColor(red: 234/255, green: 219/255, blue: 220/255, alpha: 1.0)
        static let pullToRefreshColor = UIColor(red: 160/255, green: 162/255, blue: 171/255, alpha: 1.0)
        
        static let textFieldTitleColor = UIColor(red: 0/255, green: 0/255, blue: 0/255, alpha: 1.0)
        static let textFieldTextColor = UIColor(red: 0/255, green: 0/255, blue: 0/255, alpha: 1.0)
        static let textFieldLineColor = UIColor.black
        static let textFieldHighlightedLineColor = UIColor(red: 237/255, green: 28/255, blue: 36/255, alpha: 1.0)
        static let textFieldErrorColor = UIColor(red: 237/255, green: 28/255, blue: 36/255, alpha: 1.0)
    }
}

enum HTTPHeaderField: String {
    case authentication = "user-api-token"
    case contentType = "Content-Type"
    case acceptType = "Accept"
    case acceptEncoding = "Accept-Encoding"
    case apiToken = "api-token"
}

enum ContentType: String {
    case json = "application/json"
}

enum AppAnalytic: String {
    case downloadedPodcast = "DownloadedPodcast"
    case viewedPodcastPost = "ViewedPodcastPost"
    case playedOnlinePodcast = "PlayedOnlinePodcast"
    case playedDownloadedPodcast = "PlayedDownloadedPodcast"
    case stoppedOnlinePodcast = "StoppedOnlinePodcast"
    case stoppedDownloadedPodcast = "StoppedDownloadedPodcast"
    case viewedWritingArticle = "ViewedWritingArticle"
    case stoppedViewingWritingArticle = "StoppedViewingWritingArticle"
    case viewedVideoArticle = "ViewedVideoArticle"
    case stoppedViewingVideoArticle = "StoppedViewingVideoArticle"
    case playedVideo = "PlayedVideo"
    case stoppedVideo = "StoppedVideo"
    case maximisedPlayer = "MaximisedPlayer"
    case minimisedPlayer = "MinimisedPlayer"
    case skippedForwardPlayer = "SkippedForwardPlayer"
    case skippedBackwardsPlayer = "SkippedBackwardsPlayer"
    case castedVideo = "CastedVideo"
    case userBackgroundedApp = "UserBackgroundedApp"
}

public extension UIDevice {
    
    static let isSmallDevice: Bool = {
        if UIDevice.modelName.contains("iPod Touch") ||
            UIDevice.modelName.contains("iPhone 4") ||
            UIDevice.modelName.contains("iPhone 5") ||
            UIDevice.modelName == "iPhone SE"  ||
            UIDevice.modelName == "Simulator iPhone SE"
            {
            return true
        }
        return false
    }()
    
    static let modelName: String = {
        var systemInfo = utsname()
        uname(&systemInfo)
        let machineMirror = Mirror(reflecting: systemInfo.machine)
        let identifier = machineMirror.children.reduce("") { identifier, element in
            guard let value = element.value as? Int8, value != 0 else { return identifier }
            return identifier + String(UnicodeScalar(UInt8(value)))
        }
        
        func mapToDevice(identifier: String) -> String { // swiftlint:disable:this cyclomatic_complexity
            #if os(iOS)
            switch identifier {
            case "iPod5,1":
                return "iPod Touch 5"
            case "iPod7,1":
                return "iPod Touch 6"
            case "iPhone3,1", "iPhone3,2", "iPhone3,3":
                return "iPhone 4"
            case "iPhone4,1":
                return "iPhone 4s"
            case "iPhone5,1", "iPhone5,2":
                return "iPhone 5"
            case "iPhone5,3", "iPhone5,4":
                return "iPhone 5c"
            case "iPhone6,1", "iPhone6,2":
                return "iPhone 5s"
            case "iPhone7,2":
                return "iPhone 6"
            case "iPhone7,1":
                return "iPhone 6 Plus"
            case "iPhone8,1":
                return "iPhone 6s"
            case "iPhone8,2":
                return "iPhone 6s Plus"
            case "iPhone9,1", "iPhone9,3":
                return "iPhone 7"
            case "iPhone9,2", "iPhone9,4":
                return "iPhone 7 Plus"
            case "iPhone8,4":
                return "iPhone SE"
            case "iPhone10,1", "iPhone10,4":
                return "iPhone 8"
            case "iPhone10,2", "iPhone10,5":
                return "iPhone 8 Plus"
            case "iPhone10,3", "iPhone10,6":
                return "iPhone X"
            case "iPhone11,2":
                return "iPhone XS"
            case "iPhone11,4", "iPhone11,6":
                return "iPhone XS Max"
            case "iPhone11,8":
                return "iPhone XR"
            case "iPad2,1", "iPad2,2", "iPad2,3", "iPad2,4":
                return "iPad 2"
            case "iPad3,1", "iPad3,2", "iPad3,3":
                return "iPad 3"
            case "iPad3,4", "iPad3,5", "iPad3,6":
                return "iPad 4"
            case "iPad4,1", "iPad4,2", "iPad4,3":
                return "iPad Air"
            case "iPad5,3", "iPad5,4":
                return "iPad Air 2"
            case "iPad6,11", "iPad6,12":
                return "iPad 5"
            case "iPad7,5", "iPad7,6":
                return "iPad 6"
            case "iPad2,5", "iPad2,6", "iPad2,7":
                return "iPad Mini"
            case "iPad4,4", "iPad4,5", "iPad4,6":
                return "iPad Mini 2"
            case "iPad4,7", "iPad4,8", "iPad4,9":
                return "iPad Mini 3"
            case "iPad5,1", "iPad5,2":
                return "iPad Mini 4"
            case "iPad6,3", "iPad6,4":
                return "iPad Pro (9.7-inch)"
            case "iPad6,7", "iPad6,8":
                return "iPad Pro (12.9-inch)"
            case "iPad7,1", "iPad7,2":
                return "iPad Pro (12.9-inch) (2nd generation)"
            case "iPad7,3", "iPad7,4":
                return "iPad Pro (10.5-inch)"
            case "iPad8,1", "iPad8,2", "iPad8,3", "iPad8,4":
                return "iPad Pro (11-inch)"
            case "iPad8,5", "iPad8,6", "iPad8,7", "iPad8,8":
                return "iPad Pro (12.9-inch) (3rd generation)"
            case "AppleTV5,3":
                return "Apple TV"
            case "AppleTV6,2":
                return "Apple TV 4K"
            case "AudioAccessory1,1":
                return "HomePod"
            case "i386", "x86_64":
                let device = mapToDevice(identifier: ProcessInfo().environment["SIMULATOR_MODEL_IDENTIFIER"] ?? "iOS")
                return "Simulator \(device)"
            default:
                return identifier
            }
            #elseif os(tvOS)
            switch identifier {
            case "AppleTV5,3":
                return "Apple TV 4"
            case "AppleTV6,2":
                return "Apple TV 4K"
            case "i386", "x86_64":
                return "Apple TV Simulator"
            default: return identifier
            }
            #endif
        }
        
        return mapToDevice(identifier: identifier)
    }()
    
}

extension UILabel {
    
    // Pass value for any one of both parameters and see result
    func setLineSpacing(lineSpacing: CGFloat = 0.0, lineHeightMultiple: CGFloat = 0.0) {
        
        guard let labelText = self.text else { return }
        
        let paragraphStyle = NSMutableParagraphStyle()
        paragraphStyle.lineSpacing = lineSpacing
        paragraphStyle.lineHeightMultiple = lineHeightMultiple
        
        let attributedString: NSMutableAttributedString
        if let labelattributedText = self.attributedText {
            attributedString = NSMutableAttributedString(attributedString: labelattributedText)
        } else {
            attributedString = NSMutableAttributedString(string: labelText)
        }
        
        // Line spacing attribute
        attributedString.addAttribute(NSAttributedString.Key.paragraphStyle,
                                      value: paragraphStyle,
                                      range: NSMakeRange(0, attributedString.length))
        
        self.attributedText = attributedString
    }
}

extension String {
    
    func height(withConstrainedWidth width: CGFloat,
                font: UIFont, lineSpacing: CGFloat = 0,
                lineHeightMultiple: CGFloat = 0.0) -> CGFloat {
        
        let paragraphStyle = NSMutableParagraphStyle()
        paragraphStyle.lineSpacing = lineSpacing
        paragraphStyle.lineHeightMultiple = lineHeightMultiple
        
        let constraintRect = CGSize(width: width, height: .greatestFiniteMagnitude)
        let boundingBox = self.boundingRect(with: constraintRect,
                                            options: .usesLineFragmentOrigin,
                                            attributes: [NSAttributedString.Key.font: font,
                                                         NSAttributedString.Key.paragraphStyle: paragraphStyle],
                                            context: nil)
        
        return ceil(boundingBox.height)
    }
    
    func width(withConstrainedHeight height: CGFloat, font: UIFont) -> CGFloat {
        let constraintRect = CGSize(width: .greatestFiniteMagnitude, height: height)
        let boundingBox = self.boundingRect(with: constraintRect,
                                            options: .usesLineFragmentOrigin,
                                            attributes: [NSAttributedString.Key.font: font],
                                            context: nil)
        
        return ceil(boundingBox.width)
    }
}

extension NSAttributedString {
    func height(withConstrainedWidth width: CGFloat) -> CGFloat {
        let constraintRect = CGSize(width: width, height: .greatestFiniteMagnitude)
        let boundingBox = boundingRect(with: constraintRect,
                                       options: .usesLineFragmentOrigin,
                                       context: nil)
        
        return ceil(boundingBox.height)
    }
    
    func width(withConstrainedHeight height: CGFloat) -> CGFloat {
        let constraintRect = CGSize(width: .greatestFiniteMagnitude,
                                    height: height)
        let boundingBox = boundingRect(with: constraintRect,
                                       options: .usesLineFragmentOrigin,
                                       context: nil)
        return ceil(boundingBox.width)
    }
}
