//
//  PBAppStoreReviewer.swift
//  TAW
//
//  Created by Andrew Steven on 13/02/2019.
//  Copyright © 2019 PixelBeard. All rights reserved.
//

import Foundation
import StoreKit

struct PBAppStoreReviewer {
    
    static let appOpenedCount = "app_opened_count"
    static let keyActivityCount = "key_activity_count"
    
    static let opened10 = "app_opened_10_times"
    static let opened25 = "app_opened_25_times"
    static let opened50 = "app_opened_50_times"
    
    static let activity2 = "key_activity_2_times"
    static let activity5 = "key_activity_5_times"
    static let activity10 = "key_activity_10_times"
    
    static func incrementAppOpened() {
        
        guard var count = UserDefaults.standard.value(forKey: appOpenedCount) as? Int else {
            UserDefaults.standard.set(1, forKey: appOpenedCount)
            UserDefaults.standard.set(false, forKey: opened10)
            UserDefaults.standard.set(false, forKey: opened25)
            UserDefaults.standard.set(false, forKey: opened50)
            return
        }
        count += 1
        UserDefaults.standard.set(count, forKey: appOpenedCount)
    }
    
    static func incrementKeyActivity() {
        
        guard var count = UserDefaults.standard.value(forKey: keyActivityCount) as? Int else {
            UserDefaults.standard.set(1, forKey: keyActivityCount)
            UserDefaults.standard.set(false, forKey: activity2)
            UserDefaults.standard.set(false, forKey: activity5)
            UserDefaults.standard.set(false, forKey: activity10)
            return
        }
        count += 1
        UserDefaults.standard.set(count, forKey: keyActivityCount)
    }
    
    static func checkAppOpenedAndAskForReview() {
        
        guard let openedCount = UserDefaults.standard.value(forKey: appOpenedCount) as? Int else {
            UserDefaults.standard.set(1, forKey: appOpenedCount)
            return
        }
        print("APP HAS BEEN OPENED \(openedCount) TIMES")
        switch openedCount {
        case 10:
            if UserDefaults.standard.value(forKey: opened10) as? Bool == false {
                PBAppStoreReviewer().requestReview()
                UserDefaults.standard.setValue(true, forKey: opened10)
            }
        case 25:
            if UserDefaults.standard.value(forKey: opened25) as? Bool == false {
                PBAppStoreReviewer().requestReview()
                UserDefaults.standard.setValue(true, forKey: opened25)
            }
        case 50:
            if UserDefaults.standard.value(forKey: opened50) as? Bool == false {
                PBAppStoreReviewer().requestReview()
                UserDefaults.standard.setValue(true, forKey: opened50)
            }
        default:
            print("App has been opened \(openedCount) times!")
            break
        }
    }
    
    static func checkKeyActivityAndAskForReview() {
        
        guard let activityCount = UserDefaults.standard.value(forKey: keyActivityCount) as? Int else {
            UserDefaults.standard.set(0, forKey: keyActivityCount)
            return
        }
        print("USER HAS LISTENED TO \(activityCount) PODCASTS")
        switch activityCount {
        case 2:
            if UserDefaults.standard.value(forKey: activity2) as? Bool == false {
                PBAppStoreReviewer().requestReview()
                UserDefaults.standard.setValue(true, forKey: activity2)
            }
        case 5:
            if UserDefaults.standard.value(forKey: activity5) as? Bool == false {
                PBAppStoreReviewer().requestReview()
                UserDefaults.standard.setValue(true, forKey: activity5)
            }
        case 10:
            if UserDefaults.standard.value(forKey: activity10) as? Bool == false {
                PBAppStoreReviewer().requestReview()
                UserDefaults.standard.setValue(true, forKey: activity10)
            }
        default:
            print("User has completed key activity \(activityCount) times!")
            break
        }
    }
    
    static func reviewApp() {
        PBAppStoreReviewer().requestReview()
    }

    fileprivate func requestReview() {
        SKStoreReviewController.requestReview()
    }
}
