//
//  TAWTabBarController.swift
//  TAW
//
//  Created by Andrew Steven on 14/12/2018.
//  Copyright © 2018 PixelBeard. All rights reserved.
//

import UIKit
import OneSignal
import Crashlytics

class TAWTabBarController: UITabBarController {
    
    // MARK: - Variables -
    
    var indicatorView = UIView()
    
    // MARK: - Life cycle -

    override func viewDidLoad() {
        super.viewDidLoad()
        
        self.indicatorView = UIView(frame: CGRect(x: 0, y: 0, width: 20, height: 2))
        self.indicatorView.backgroundColor = UIColor(red: 237/255,
                                                     green: 28/255,
                                                     blue: 36/255,
                                                     alpha: 1.0)
        
        self.indicatorView.center = CGPoint(x: self.view.frame.size.width/8,
                                            y: (76/2) + 15)
        
        self.tabBar.addSubview(self.indicatorView)
        
        if LocalStorage.shared.loggedIn {
            if let user = LocalStorage.shared.user {
                Crashlytics.sharedInstance().setUserName(user.username)
                Crashlytics.sharedInstance().setUserIdentifier("Auth Token: \(user.authToken!)")
                Crashlytics.sharedInstance().setUserEmail(user.guest ? "Guest" : user.email)
            }
        }
    }
    
    override func viewDidAppear(_ animated: Bool) {
        super.viewDidAppear(animated)
        
        if !LocalStorage.shared.loggedIn {
            self.showLogin()
        } else if LocalStorage.shared.loggedIn &&
            LocalStorage.shared.firstLaunch {
            
            // Display alert asking to allow for push notifications
            let topView = UIApplication.shared.keyWindow?.subviews.last
            let alertView = TAWAlertView.shared
            alertView.delegate = self
            alertView.showAlertView(inView: topView!, alertStyle: .notifications)
            LocalStorage.shared.firstLaunch = false
        } else {
            // Check device is still valid
        }
    }
    
    override func viewWillLayoutSubviews() {
        super.viewWillLayoutSubviews()
        
        var tabFrame = self.tabBar.frame
        tabFrame.size.height = 76
        tabFrame.origin.y = self.view.frame.size.height - 76
        self.tabBar.frame = tabFrame
        
        if UIDevice.current.userInterfaceIdiom == UIUserInterfaceIdiom.phone {
            
            switch Int(UIScreen.main.nativeBounds.size.height) {
            case 2436, 2688, 1792:
                for item in self.tabBar.items! {
                    item.imageInsets = UIEdgeInsets(top: 15, left: 0, bottom: -15, right: 0)
                }
                
            default:
                for item in self.tabBar.items! {
                    item.imageInsets = UIEdgeInsets(top: 0, left: 0, bottom: 0, right: 0)
                }
            }
        }
    }
    
    // MARK: - Button actions -
    
    func showLogin() {
        performSegue(withIdentifier: "showLogin", sender: nil)
        self.selectedIndex = 0
        self.indicatorView.center = CGPoint(x: (self.tabBar.frame.size.width/8),
                                            y: (76/2) + 15)
    }
    
    override func tabBar(_ tabBar: UITabBar, didSelect item: UITabBarItem) {
        UIView.animate(withDuration: 0.3) {
            let multiplier: CGFloat = CGFloat((item.tag * 2) + 1)
            self.indicatorView.center = CGPoint(x: (self.tabBar.frame.size.width/8) * multiplier,
                                                y: (76/2) + 15)
        }
    }

    private func associateOneSignalWithDevice(_ oneSignalId: String) {
        
        let params = [
            "device_token": oneSignalId
        ]
        
        APIClient.associateDeviceToken(parameters: params) { (jsonResponse, error) in
            print("Associate Device Token Response: \(jsonResponse["message"] as! String)")
        }
    }
}

extension TAWTabBarController: TAWAlertViewDelegate {
    func didTapLogout() {
        // Do nothing
    }

    func accountCreated() {
        // Do nothing
    }
    
    
    func acceptedNotifications() {
        // Show the prompt for push notifications at this point
        OneSignal.promptForPushNotifications(userResponse: { accepted in
            print("User accepted notifications: \(accepted)")
//            LocalStorage.shared.firstLaunch = false
            
            var oneSignalId = LocalStorage.shared.oneSignalId
            if oneSignalId == nil {
                if let existingId = OneSignal.getPermissionSubscriptionState().subscriptionStatus.userId {
                    LocalStorage.shared.oneSignalId = existingId
                    oneSignalId = existingId
                } else {
                    oneSignalId = ""
                }
            }
            
            if oneSignalId!.count > 0 {
                self.associateOneSignalWithDevice(oneSignalId!)
            }
        })
    }
    
    func unlinkAccount() {
        // Do nothing
    }
}
