//
//  TokenPack.swift
//  TAW
//
//  Created by Andrew Steven on 27/02/2019.
//  Copyright © 2019 PixelBeard. All rights reserved.
//

import Foundation
import ObjectMapper
import RealmSwift

class TokenPack: Object, Mappable {
    
    @objc dynamic var tokenValue = ""
    @objc dynamic var priceValue = ""
    @objc dynamic var packDescription = ""
    
    required convenience init?(map: Map) {
        self.init()
    }
    
    func mapping(map: Map) {
        tokenValue <- map["token_value"]
        priceValue <- map["price_value"]
        packDescription <- map["description"]
    }
    
    var title: String {
        if tokenValue == "1" {
            return "\(tokenValue) TOKEN"
        }
        return "\(tokenValue) TOKENS"
    }
    
    var buyTitle: String {
        return "BUY FOR £\(priceValue)"
    }
}
