//
//  Transaction.swift
//  TAW
//
//  Created by Andrew Steven on 21/02/2019.
//  Copyright © 2019 PixelBeard. All rights reserved.
//

import Foundation
import ObjectMapper
import RealmSwift

class Transaction: Object, Mappable {
    
    @objc dynamic var value = ""
    @objc dynamic var entryDate = ""
    @objc dynamic var transactionType = ""
    @objc dynamic var purchaseType = ""
    @objc dynamic var title = ""
//    @objc dynamic var credit: Credit?
    @objc dynamic var podcast: Podcast?
    @objc dynamic var video: Video?
    
    required convenience init?(map: Map) {
        self.init()
    }
    
    func mapping(map: Map) {
        value <- map["value"]
        entryDate <- map["entry_date"]
        transactionType <- map["transaction_type"]
        purchaseType <- map["type"]
        if transactionType == "credit" {
            title <- map["title"]
        }
        else {
            title <- map["object.title"]
            if purchaseType == "podcast" {
                podcast <- map["object"]
            }
            else if purchaseType == "video" {
                video <- map["object"]
            }
        }
    }
    
    var formattedDate: String {
        
        let dateFormatter = DateFormatter()
        dateFormatter.dateFormat = "yyyy-MM-dd HH:mm:ss"
        dateFormatter.locale = Locale(identifier: NSLocale.current.identifier)
        dateFormatter.timeZone = TimeZone(abbreviation: "UTC")
        let date = dateFormatter.date(from: self.entryDate)
        
        dateFormatter.locale = Locale(identifier: NSLocale.current.identifier)
        dateFormatter.timeZone = TimeZone.current
        dateFormatter.dateFormat = "dd MMM yyyy"
        return dateFormatter.string(from: date!)
    }
}
