//
//  Writing.swift
//  TAW
//
//  Created by Andrew Steven on 31/01/2019.
//  Copyright © 2019 PixelBeard. All rights reserved.
//

import Foundation
import ObjectMapper
import RealmSwift

class Writing: Object, Mappable {
    
    @objc dynamic var postId: String = ""
    @objc dynamic var title: String = ""
    @objc dynamic var content: String = ""
    @objc dynamic var createdDate: String = ""
    @objc dynamic var featured: Bool = false
    @objc dynamic var author: String = ""
    @objc dynamic var thumbnailImage: String = ""
    @objc dynamic var mediumImage: String = ""
    @objc dynamic var largeImage: String = ""
    
    required convenience init?(map: Map) {
        self.init()
    }
    
    func mapping(map: Map) {
        postId <- map["post_id"]
        title <- map["title"]
        content <- map["content"]
        createdDate <- map["created_date"]
        featured <- map["featured"]
        author <- map["author"]
        thumbnailImage <- map["thumbnail_image"]
        mediumImage <- map["medium_image"]
        largeImage <- map["large_image"]
    }
    
    var formattedDate: String {
        
        let dateFormatter = DateFormatter()
        dateFormatter.dateFormat = "yyyy-MM-dd HH:mm:ss"
        dateFormatter.locale = Locale(identifier: NSLocale.current.identifier)
        dateFormatter.timeZone = TimeZone(abbreviation: "UTC")
        let date = dateFormatter.date(from: self.createdDate)
        
        dateFormatter.locale = Locale(identifier: NSLocale.current.identifier)
        dateFormatter.timeZone = TimeZone.current
        dateFormatter.dateFormat = "dd MMM yyyy"
        return dateFormatter.string(from: date!)
    }
}
