//
//  TAWDevicesTableViewCell.swift
//  TAW
//
//  Created by Andrew Steven on 25/02/2019.
//  Copyright © 2019 PixelBeard. All rights reserved.
//

import UIKit

protocol TAWDevicesTableViewCellDelegate: class {
    func deleteDevice(_ device: Device)
}

class TAWDevicesTableViewCell: UITableViewCell {
    
    @IBOutlet weak var deviceNameLabel: UILabel!
    @IBOutlet weak var currentDeviceLabel: UILabel!
    @IBOutlet weak var lastUsedLabel: UILabel!
    @IBOutlet weak var deleteButton: UIButton!
    
    var device: Device?
    weak var delegate: TAWDevicesTableViewCellDelegate?
    override func awakeFromNib() {
        super.awakeFromNib()
    }

    override func setSelected(_ selected: Bool, animated: Bool) {
        super.setSelected(selected, animated: animated)
    }
    
    override func prepareForReuse() {
        self.device = nil
        self.deviceNameLabel.text = ""
        self.lastUsedLabel.text = ""
        self.deleteButton.isHidden = true
        self.currentDeviceLabel.isHidden = true
    }

    func setDevice(_ device: Device) {
        self.device = device
        self.deviceNameLabel.text = device.deviceName
        self.currentDeviceLabel.isHidden = device.deviceIdentifier != LocalStorage.shared.uuid
        self.lastUsedLabel.text = "Last Used: \(device.formattedDate)"
        self.deleteButton.isHidden = device.deviceIdentifier == LocalStorage.shared.uuid
    }
    
    @IBAction func deleteDevice() {
        if let device = self.device {
            self.delegate?.deleteDevice(device)
        }
    }
}
