//
//  TAWPurchasesTableViewCell.swift
//  TAW
//
//  Created by Andrew Steven on 18/12/2018.
//  Copyright © 2018 PixelBeard. All rights reserved.
//

import UIKit
import Kingfisher

class TAWPurchasesTableViewCell: UITableViewCell {

    @IBOutlet weak var typeLabel: UILabel!
    @IBOutlet weak var dateLabel: UILabel!
    @IBOutlet weak var durationLabel: UILabel!
    @IBOutlet weak var titleLabel: UILabel!
    @IBOutlet weak var purchaseImageView: UIImageView!
    
    var transaction: Transaction?
    
    override func awakeFromNib() {
        super.awakeFromNib()
    }

    override func setSelected(_ selected: Bool, animated: Bool) {
        super.setSelected(selected, animated: animated)
    }
    
    override func prepareForReuse() {
        
        self.transaction = nil
        self.purchaseImageView.image = UIImage(named: "placeholder_podcasts")
        self.typeLabel.text = ""
        self.dateLabel.text = ""
        self.durationLabel.text = ""
        self.titleLabel.text = ""
    }
    
    func setTransaction(_ transaction: Transaction) {
        
        self.transaction = transaction
        
        typeLabel.text = self.transaction?.transactionType.uppercased()
        if self.transaction?.transactionType == "purchase" {
            typeLabel.text = self.transaction?.purchaseType.uppercased()
            
            if self.transaction?.purchaseType == "podcast" {
                if let image = self.transaction?.podcast?.mediumImage {
                    self.purchaseImageView.kf.setImage(with: URL(string: image), placeholder: UIImage(named: "placeholder_podcasts"), options: [.transition(.fade(0.2))])
                }
                durationLabel.text = self.transaction?.podcast?.duration
            }
            else if self.transaction?.purchaseType == "video" {
                if let image = self.transaction?.video?.mediumImage {
                    self.purchaseImageView.kf.setImage(with: URL(string: image), placeholder: UIImage(named: "placeholder_podcasts"), options: [.transition(.fade(0.2))])
                }
                durationLabel.text = ""
            }
            
        }
        else if self.transaction?.transactionType == "credit" {
            self.purchaseImageView.image = UIImage(named: "placeholder_token")
            durationLabel.text = ""
        }
        
        dateLabel.text = self.transaction?.formattedDate
        let titleText = self.transaction?.title
        
        DispatchQueue.main.async {
            self.titleLabel.text = titleText?.htmlDecoded
        }
        
    }
}
