//
//  TAWSettingsSwitchTableViewCell.swift
//  TAW
//
//  Created by Andrew Steven on 20/03/2019.
//  Copyright © 2019 PixelBeard. All rights reserved.
//

import UIKit

class TAWSettingsSwitchTableViewCell: UITableViewCell {

    @IBOutlet weak var titleLabel: UILabel!
    @IBOutlet weak var settingsSwitch: PBSwitch!
    
    var notification: [String: String] = [:]
    
    override func awakeFromNib() {
        super.awakeFromNib()
    }

    override func setSelected(_ selected: Bool, animated: Bool) {
        super.setSelected(selected, animated: animated)
    }
    
    override func prepareForReuse() {
        
        self.notification = [:]
        self.titleLabel.text = ""
        self.settingsSwitch.removeTarget(self,
                                         action: #selector(self.toggleNotificationPreference),
                                         for: .valueChanged)
    }
    
    func setNotificationSetting(_ notification: [String: String]) {
        
        self.notification = notification
        self.titleLabel.text = self.notification["key"]!.uppercased()
        let value = self.notification["value"]
        let bool = value!.toBool()
        self.settingsSwitch.setOn(on: bool, animated: true)
        DispatchQueue.main.asyncAfter(deadline: DispatchTime.now() + 0.7) {
            self.settingsSwitch.addTarget(self,
                                          action: #selector(self.toggleNotificationPreference),
                                          for: .valueChanged)
        }
    }
    
    @objc private func toggleNotificationPreference() {

        let type = self.notification["key"]!
        let params = [ "value": self.settingsSwitch.isOn ]
        
        APIClient.updateNotificationPreference(type: type, parameters: params) { (jsonResponse, _) in
            if jsonResponse["success"] as? Bool == true {
                print("Podcast preference updated successfully")
            } else {
                let message = jsonResponse["message"] as? String ?? ""
                print("Update Notification Preference Error: \(message)")
                self.settingsSwitch.setOn(on: !self.settingsSwitch.isOn, animated: true)
            }
        }
    }
}
