//
//  TAWVideoTableViewCell.swift
//  TAW
//
//  Created by Andrew Steven on 13/03/2019.
//  Copyright © 2019 PixelBeard. All rights reserved.
//

import UIKit
import Kingfisher
import Alamofire

class TAWVideoTableViewCell: UITableViewCell {
    
    @IBOutlet weak var videoShadowView: PBView!
    @IBOutlet weak var videoImageView: UIImageView!
    @IBOutlet weak var premiumImageView: UIImageView!
    @IBOutlet weak var dateLabel: UILabel!
    @IBOutlet weak var titleLabel: UILabel!
    @IBOutlet weak var titleLabelOffsetY: NSLayoutConstraint!
    
    var video: Video?

    override func awakeFromNib() {
        super.awakeFromNib()
        
        self.videoShadowView.shadowColor = UIColor.black
        self.videoShadowView.shadowOpacity = 0.24
        self.videoShadowView.shadowOffset = CGSize(width: 0, height: 9)
        self.videoShadowView.shadowRadius = 10
    }

    override func setSelected(_ selected: Bool, animated: Bool) {
        super.setSelected(selected, animated: animated)
    }
    
    override func prepareForReuse() {
        
        self.video = nil
        self.videoImageView.image = UIImage(named: "placeholder_videos")
        self.premiumImageView.isHidden = true
        self.dateLabel.text = ""
        self.titleLabel.text = ""
    }
    
    func setVideo(_ video: Video, imageQuality: PodcastImageQuality) {
        self.video = video
        
        var image = ""
        switch imageQuality {
        case .thumbnail:
            image = video.thumbnailImage
        case .medium:
            image = video.mediumImage
        case .large:
            image = video.largeImage
        }
        
        self.videoImageView.kf.setImage(with: URL(string: image),
                                        placeholder: UIImage(named: "placeholder_videos"),
                                        options: [.transition(.fade(0.2))])
        
        self.premiumImageView.image = UIImage(named: "premium_icon")
        self.premiumImageView.isHidden = !video.premium
        
        if let user = LocalStorage.shared.user {
            if user.isSubscribedToVideo {
                self.premiumImageView.image = UIImage(named: "subscribed_icon")
                self.premiumImageView.isHidden = false
            }
            else if video.purchased == true {
                self.premiumImageView.image = UIImage(named: "purchased_icon")
                self.premiumImageView.isHidden = false
            }
        }
        
        self.titleLabelOffsetY.constant = self.premiumImageView.isHidden ? 8 : 32
        self.layoutIfNeeded()
        self.dateLabel.text = video.formattedDate
        self.titleLabel.text = video.title
    }
}
