//
//  PBButton.swift
//  TAW
//
//  Created by Andrew Steven on 17/12/2018.
//  Copyright © 2018 PixelBeard. All rights reserved.
//

import UIKit

@IBDesignable
class PBButton: UIButton {

    var buttonView = UIView()
    
    override func draw(_ rect: CGRect) {
        self.backgroundColor = UIColor.clear
        buttonView.frame = CGRect(x: 0, y: 0, width: self.frame.width, height: self.frame.height)
        buttonView.isUserInteractionEnabled = false
        buttonView.clipsToBounds = true
        
        addSubview(buttonView)
        sendSubviewToBack(buttonView)
    }
    
    @IBInspectable public var buttonCornerRadius: CGFloat = 0.0 {
        didSet {
            self.layer.cornerRadius = buttonCornerRadius
            buttonView.layer.cornerRadius = buttonCornerRadius
        }
    }
    
    @IBInspectable
    var buttonBackgroundColor: UIColor? {
        get {
            return buttonView.backgroundColor
        }
        set {
            if let color = newValue {
                buttonView.backgroundColor = color
            }
            else {
                buttonView.backgroundColor = nil
            }
        }
    }
    
    @IBInspectable public var shadowColor: UIColor = UIColor.black {
        didSet {
            self.layer.shadowColor = shadowColor.cgColor
        }
    }
    
    @IBInspectable public var shadowOffset: CGSize = CGSize(width: 2.0, height: 2.0) {
        didSet {
            self.layer.shadowOffset = shadowOffset
        }
    }
    
    @IBInspectable public var shaddowRadius: CGFloat = 9.0 {
        didSet {
            self.layer.shadowRadius = shaddowRadius
        }
    }
    
    @IBInspectable public var shaddowOppacity: Float = 1.0 {
        didSet {
            self.layer.shadowOpacity = shaddowOppacity
        }
    }
    
    @IBInspectable public var borderColor: UIColor = UIColor.white {
        didSet {
            buttonView.layer.borderColor = borderColor.cgColor
        }
    }
    
    @IBInspectable public var borderWidth: CGFloat = 0.0 {
        didSet {
            buttonView.layer.borderWidth = borderWidth
        }
    }
    
    func setDefaultValues() {
        self.layer.cornerRadius = self.frame.height/2
        self.buttonCornerRadius = self.frame.height/2
        self.buttonBackgroundColor = UIColor.white
        self.shadowColor = UIColor(red: 0/255, green: 0/255, blue: 0/255, alpha: 0.15)
        self.shadowOffset = CGSize(width: 2, height: 2)
        self.shaddowRadius = 4
        self.shaddowOppacity = 1
    }
}

