//
//  PBLoadingOverlay.swift
//  TAW
//
//  Created by Andrew Steven on 11/01/2019.
//  Copyright © 2019 PixelBeard. All rights reserved.
//

import Foundation
import UIKit

public class PBLoadingOverlay {
    var overlay = UIView()
    var activityIndicator = UIActivityIndicatorView()
    var titleLabel = UILabel()
    
    class var shared: PBLoadingOverlay {
        struct Static {
            static let instance: PBLoadingOverlay = PBLoadingOverlay()
        }
        return Static.instance
    }
    
    public func showOverlay(view: UIView, withTitle title: String) {
        
        overlay = UIView(frame: UIScreen.main.bounds)
        overlay.backgroundColor = UIColor.black.withAlphaComponent(0.6)
        
        activityIndicator = UIActivityIndicatorView(style: .whiteLarge)
        activityIndicator.center = overlay.center
        overlay.addSubview(activityIndicator)
        activityIndicator.startAnimating()
        
        titleLabel = UILabel(frame: CGRect(x: 40, y: activityIndicator.frame.origin.y + 40, width: overlay.frame.size.width - 80, height: 80))
        titleLabel.text = title
        titleLabel.font = TAW.Fonts.dinAlternate18
        titleLabel.textColor = UIColor(red: 242/255, green: 242/255, blue: 242/255, alpha: 1.0)
        titleLabel.textAlignment = .center
        titleLabel.numberOfLines = 0
        overlay.addSubview(titleLabel)
        
        view.addSubview(overlay)
    }
    
    public func updateTitle(_ title: String) {
        titleLabel.text = title
    }
    
    public func hideOverlay(_ delay: Double = 0.2) {
        let when = DispatchTime.now() + delay
        DispatchQueue.main.asyncAfter(deadline: when) {
            self.activityIndicator.stopAnimating()
            self.overlay.removeFromSuperview()
        }
    }
    
    public func hideOverlay(_ delay: Double = 0.2, completion: @escaping ()->Void) {
        let when = DispatchTime.now() + delay
        DispatchQueue.main.asyncAfter(deadline: when) {
            self.activityIndicator.stopAnimating()
            self.overlay.removeFromSuperview()
            completion()
        }
    }
}
