//
//  PBPaddedTextView.swift
//  TAW
//
//  Created by Andrew Steven on 01/04/2019.
//  Copyright © 2019 PixelBeard. All rights reserved.
//

import Foundation
import UIKit

class PBPaddedTextView: UITextView, NSLayoutManagerDelegate {
    
    let lineSpacing: CGFloat = 6

    override func awakeFromNib() {
        self.layoutManager.delegate = self
    }
    
    override func draw(_ rect: CGRect) {
        self.layoutManager.enumerateLineFragments(forGlyphRange: NSRange(location: 0,
                                                                         length: self.text.count)) { (_, usedRect, _, _, _) in
            
            let rectanglePath = UIBezierPath(rect: CGRect(x: usedRect.origin.x,
                                                          y: usedRect.origin.y + self.lineSpacing,
                                                          width: usedRect.size.width,
                                                          height: usedRect.size.height))
            UIColor.black.setFill()
            rectanglePath.fill()
        }
    }
    
    func layoutManager(_ layoutManager: NSLayoutManager,
                       lineSpacingAfterGlyphAt glyphIndex: Int,
                       withProposedLineFragmentRect rect: CGRect) -> CGFloat {
        return self.lineSpacing
    }
}
