//
//  PBSlider.swift
//  TAW
//
//  Created by Andrew Steven on 17/01/2019.
//  Copyright © 2019 PixelBeard. All rights reserved.
//

import UIKit

class PBSlider: UISlider {

    override func trackRect(forBounds bounds: CGRect) -> CGRect {
        
        //keeps original origin and width, changes height, you get the idea
        let customBounds = CGRect(origin: bounds.origin, size: CGSize(width: bounds.size.width, height: 4.0))
        super.trackRect(forBounds: customBounds)
        return customBounds
    }
    
    //while we are here, why not change the image here as well? (bonus material)
    override func awakeFromNib() {
        self.setThumbImage(UIImage(named: "thumbnail"), for: .normal)
        self.setThumbImage(UIImage(named: "thumbnail_selected"), for: .highlighted)
        super.awakeFromNib()
    }
}
