//
//  PBView.swift
//  TAW
//
//  Created by Andrew Steven on 18/12/2018.
//  Copyright © 2018 PixelBeard. All rights reserved.
//

import UIKit

class PBView: UIView {

    var shadowLayer: CAShapeLayer!
    var cornerRadius: CGFloat = 0
    var shadowRadius: CGFloat = 14
    var shadowOffset: CGSize = CGSize(width: 0, height: 2)
    var shadowColor: UIColor = UIColor.black.withAlphaComponent(0.20)
    var shadowOpacity: Float = 1
    var fillColor: UIColor = UIColor.white
    
    override func layoutSubviews() {
        super.layoutSubviews()
        
        if shadowLayer == nil {
            shadowLayer = CAShapeLayer()
            layer.insertSublayer(shadowLayer, at: 0)
        }
        shadowLayer.path = UIBezierPath(roundedRect: bounds, cornerRadius: cornerRadius).cgPath
        shadowLayer.fillColor = fillColor.cgColor
        shadowLayer.shadowColor = shadowColor.cgColor
        shadowLayer.shadowOffset = shadowOffset
        shadowLayer.shadowOpacity = shadowOpacity
        shadowLayer.shadowRadius = shadowRadius
    }
}
