/*
 * Copyright 2017 Google Inc. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package co.pixelbeard.theanfieldwrap.billing;

import com.android.billingclient.api.BillingClient;

import java.util.Arrays;
import java.util.List;

/**
 * Static fields and methods useful for billing
 */
public final class BillingConstants {
    // SKUs for our products: the premium upgrade (non-consumable) and gas (consumable)
    public static final String SKU_250_TOKENS = "taw_250_tokens";
    public static final String SKU_500_TOKENS = "taw_500_tokens";

    public static final String SKU_PREMIUM_PACKAGE = "taw_premium_package";
    public static final String SKU_AUDIO_PACKAGE = "taw_audio_package";
    public static final String SKU_VIDEO_PACKAGE = "taw_video_package";

    public static final String AUDIO = "audio";
    public static final String VIDEO = "video";
    public static final String PREMIUM = "premium";
    public static final String EXPIRED = "expired";
    public static final String SUBSCRIPTION = "subscription";
    public static final String PLAN_TYPE = "planType";
    public static final String FREE = "free";
    public static final String PAID = "paid";
    public static final int MONTH = 30;


    private static final String[] IN_APP_SKUS = {SKU_250_TOKENS, SKU_500_TOKENS};
    public static final String[] IN_SUB_SKUS = {SKU_PREMIUM_PACKAGE, SKU_AUDIO_PACKAGE,SKU_VIDEO_PACKAGE};

    private BillingConstants() {
    }

    /**
     * Returns the list of all SKUs for the billing type specified
     */
    public static final List<String> getSkuList(@BillingClient.SkuType String billingType) {
        return Arrays.asList(IN_APP_SKUS);
    }

    /**
     * Returns the list of all Subscription for the billing type specified
     */
    public static final List<String> getSubscriptionList(@BillingClient.SkuType String billingType) {
        return Arrays.asList(IN_SUB_SKUS);
    }


    public static int getValueForSku(String sku) {
        switch (sku) {
            case SKU_250_TOKENS:
                return 250;
            case SKU_500_TOKENS:
                return 500;
            default:
                return 0;
        }
    }

    public static String getTitleForSku(String sku) {
        switch (sku) {
            case SKU_250_TOKENS:
                return "IAP 250 Tokens";
            case SKU_500_TOKENS:
                return "IAP 500 Tokens";
            default:
                return "";
        }
    }

    public static String getSubscriptionSKU(String sku) {
        switch (sku) {
            case PREMIUM:
                return SKU_PREMIUM_PACKAGE;
            case AUDIO:
                return SKU_AUDIO_PACKAGE;
            case VIDEO:
                return SKU_VIDEO_PACKAGE;
            default:
                return "";
        }
    }

    public static String  getAuthLevelSubscriptionSKU(String sku) {
        switch (sku) {
            case SKU_PREMIUM_PACKAGE:
                return "9";
            case SKU_AUDIO_PACKAGE:
                return "8";
            case SKU_VIDEO_PACKAGE:
                return "7";
            default:
                return "0";
        }
    }
}

