package co.pixelbeard.theanfieldwrap.data;

import com.google.gson.annotations.SerializedName;
import com.tonyodev.fetch2.Download;

import org.parceler.Parcel;

@Parcel(Parcel.Serialization.BEAN)
public class Podcast {

    @SerializedName("post_id")
    Long postId;
    @SerializedName("title")
    String title;
    @SerializedName("content")
    String content;
    @SerializedName("created_date")
    String createdDate;
    @SerializedName("premium")
    boolean premium;
    @SerializedName("podcast_full_url")
    String podcastFullUrl;
    @SerializedName("thumbnail_image")
    String thumbnail;
    @SerializedName("medium_image")
    String mediumImage;
    @SerializedName("large_image")
    String largeImage;
    @SerializedName("podcast_length")
    String podcastLength;
    @SerializedName("purchased")
    boolean purchased;
    @SerializedName("cost")
    int cost;
    @SerializedName("sub_level")
    int subLevel;

    @SerializedName("file_path")
    String fileLocation;


    transient Download download;
    transient boolean isPlaying = false;

    public Podcast() {
    }

    public Podcast(Long postId, String title, String content, String createdDate,
                   boolean premium, String podcastFullUrl,
                   String thumbnail, String mediumImage, String largeImage, String podcastLength,
                   boolean purchased, int cost, int subLevel) {
        this.postId = postId;
        this.title = title;
        this.content = content;
        this.createdDate = createdDate;
        this.premium = premium;
        this.podcastFullUrl = podcastFullUrl;
        this.thumbnail = thumbnail;
        this.mediumImage = mediumImage;
        this.largeImage = largeImage;
        this.podcastLength = podcastLength;
        this.purchased = purchased;
        this.cost = cost;
        this.subLevel = subLevel;
    }

    public Long getPostId() {
        return postId;
    }

    public void setPostId(Long postId) {
        this.postId = postId;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getContent() {
        return content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public String getCreatedDate() {
        return createdDate;
    }

    public void setCreatedDate(String createdDate) {
        this.createdDate = createdDate;
    }

    public boolean isPremium() {
        return premium;
    }

    public void setPremium(boolean premium) {
        this.premium = premium;
    }

    public String getPodcastFullUrl() {
        return podcastFullUrl;
    }

    public void setPodcastFullUrl(String podcastFullUrl) {
        this.podcastFullUrl = podcastFullUrl;
    }

    public String getThumbnail() {
        return thumbnail;
    }

    public void setThumbnail(String thumbnail) {
        this.thumbnail = thumbnail;
    }

    public String getMediumImage() {
        return mediumImage;
    }

    public void setMediumImage(String mediumImage) {
        this.mediumImage = mediumImage;
    }

    public String getLargeImage() {
        return largeImage;
    }

    public void setLargeImage(String largeImage) {
        this.largeImage = largeImage;
    }

    public String getPodcastLength() {
        return podcastLength;
    }

    public void setPodcastLength(String podcastLength) {
        this.podcastLength = podcastLength;
    }

    public boolean isPurchased() {
        return purchased;
    }

    public void setPurchased(boolean purchased) {
        this.purchased = purchased;
    }

    public int getCost() {
        return cost;
    }

    public void setCost(int cost) {
        this.cost = cost;
    }

    public Download getDownload() {
        return download;
    }

    public void setDownload(Download download) {
        this.download = download;
    }

    public boolean isPlaying() {
        return isPlaying;
    }

    public String getFileLocation() {
        return fileLocation;
    }

    public void setFileLocation(String fileLocation) {
        this.fileLocation = fileLocation;
    }

    public void setPlaying(boolean playing) {
        isPlaying = playing;
    }

    public int getSubLevel() {
        return subLevel;
    }

    public void setSubLevel(int subLevel) {
        this.subLevel = subLevel;
    }
}
