package co.pixelbeard.theanfieldwrap.data.responses;

import com.google.gson.annotations.SerializedName;

import co.pixelbeard.theanfieldwrap.networking.BaseResponse;

public class GuestUserResponse extends BaseResponse {

    @SerializedName("user_api_token")
    String userAuthToken;
    @SerializedName("username")
    String userName;

    public GuestUserResponse() {
    }

    public GuestUserResponse(boolean success, String message, String userAuthToken, String userName) {
        this.setSuccess(success);
        this.setMessage(message);
        this.userAuthToken = userAuthToken;
        this.userName = userName;
    }

    public String getUserAuthToken() {
        return userAuthToken;
    }

    public void setUserAuthToken(String userAuthToken) {
        this.userAuthToken = userAuthToken;
    }

    public String getUserName() {
        return userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }
}
