package co.pixelbeard.theanfieldwrap.data.source;

import android.content.Context;

import java.util.List;

import co.pixelbeard.theanfieldwrap.data.NotificationSetting;
import co.pixelbeard.theanfieldwrap.data.Podcast;
import co.pixelbeard.theanfieldwrap.data.PodcastStateModel;
import co.pixelbeard.theanfieldwrap.data.RealmPodcast;
import co.pixelbeard.theanfieldwrap.data.User;
import co.pixelbeard.theanfieldwrap.data.responses.ArticleByIdResponse;
import co.pixelbeard.theanfieldwrap.data.responses.ArticlesResponse;
import co.pixelbeard.theanfieldwrap.data.responses.GenericResponse;
import co.pixelbeard.theanfieldwrap.data.responses.GetDevicesResponse;
import co.pixelbeard.theanfieldwrap.data.responses.GetWalletResponse;
import co.pixelbeard.theanfieldwrap.data.responses.GuestUserResponse;
import co.pixelbeard.theanfieldwrap.data.responses.LoginResponse;
import co.pixelbeard.theanfieldwrap.data.responses.NotificationSettingsResponse;
import co.pixelbeard.theanfieldwrap.data.responses.PodcastByIdResponse;
import co.pixelbeard.theanfieldwrap.data.responses.PodcastsResponse;
import co.pixelbeard.theanfieldwrap.data.responses.RegisterUserResponse;
import co.pixelbeard.theanfieldwrap.data.responses.SubscriptionItemResponse;
import co.pixelbeard.theanfieldwrap.data.responses.VideoByIdResponse;
import co.pixelbeard.theanfieldwrap.data.responses.VideosResponse;
import co.pixelbeard.theanfieldwrap.freeSubscription.ActiveSubscriptionResponse;
import io.reactivex.Observable;
import io.realm.RealmResults;

public interface DataSource {

    Observable<GenericResponse> recordAnalytic(String type, String variable, String secondaryVariable);

    Observable<LoginResponse> login(String email, String password);

    void saveUserDetails(User user, String authToken);

    void saveUserDetails(String firstName, String lastName, String userName);

    Observable<GuestUserResponse> registerGuestUser();

    void saveGuestUserDetails(String userName, String authToken);

    Observable<RegisterUserResponse> registerFullUser(String firstName, String lastName, String email, String password, boolean optIn, String username, String country);

    Observable<GenericResponse> convertGuestToFullUser(String firstName, String lastName, String email, String password, boolean optIn, String username, String country);


    Observable<GenericResponse> checkEmailAvailable(String email);

    Observable<GenericResponse> checkUsernameAvailable(String username);

    Observable<GenericResponse> resendAuthCode(String email);

    Observable<GenericResponse> activateUser(String email, String activationCode);

    Observable<GenericResponse> changePassword(String oldPassword, String newPassword);

    Observable<NotificationSettingsResponse> getUserSettings();

    List<NotificationSetting> getUserSettingsLocal();

    void saveUserSettings(List<NotificationSetting> settings);

    Observable<GenericResponse> updateUserSetting(String type, int value);

    Observable<GenericResponse> updateUserEmail(String oldEmail, String newEmail);

    Observable<GenericResponse> updateUserDetails(String firstName, String lastName, String userName);

    Observable<GenericResponse> requestPasswordReset(String email);

    Observable<GenericResponse> resetPassword(String email, String recoveryCode, String password);

    Observable<GenericResponse> logout();

    void clearAllData(Context context);

    Observable<PodcastsResponse> getPodcasts(int pageNum);

    Observable<PodcastByIdResponse> getPodcastByIdRemote(Long podcastId);


    Observable<ArticlesResponse> getArticles(int pageNum);

    Observable<ArticleByIdResponse> getArticleById(Long articleId);


    Observable<VideosResponse> getVideos(int pageNum);

    Observable<VideoByIdResponse> getVideoById(String videoId);

    Observable<LoginResponse> checkUserSubscription();


    void getDownloadedPodcasts(DownloadedPodcastCallback callback);

    void downloadPodcast(Podcast podcast, Context context);

    void savePodcast(Podcast podcast, String filePath);

    RealmPodcast getPodcastByIdLocal(long id);

    Observable<GetDevicesResponse> getActiveDevices();

    Observable<GenericResponse> unlinkDevice(String userApiToken, int deviceId);

    Observable<GetWalletResponse> getWallet();

    Observable<GetWalletResponse> creditUserAccount(int value, String title, String purchaseToken);

    Observable<GetWalletResponse> purchaseItem(String productId);

    void getPodcastStates(PodcastStateCallback callback);

    void clearPodcastStates();

    void getPodcastState(long podcastId, int position, PodcastStateCallback callback);

    Observable<SubscriptionItemResponse> getSubscription();

    Observable<ActiveSubscriptionResponse> activeSubscription(String subscription);

    Observable<ActiveSubscriptionResponse> activePaidSubscription(
            String subscription,
            String planType, int duration,String purchaseToken);

    interface DownloadedPodcastCallback {
        void onPodcastsRetrieved(RealmResults<RealmPodcast> podcasts);
    }

    interface PodcastStateCallback {
        void onPodcastState(PodcastStateModel podcastState, int position);
    }

}
