package co.pixelbeard.theanfieldwrap.devices;

import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;

import java.util.List;

import butterknife.BindView;
import butterknife.ButterKnife;
import co.pixelbeard.theanfieldwrap.R;
import co.pixelbeard.theanfieldwrap.data.Device;
import co.pixelbeard.theanfieldwrap.utils.DateUtils;
import co.pixelbeard.theanfieldwrap.utils.FontUtils;
import co.pixelbeard.theanfieldwrap.utils.TawController;

public class DevicesAdapter extends RecyclerView.Adapter<DevicesAdapter.DeviceViewHolder> {

    private List<Device> mDevices;
    private OnDeviceRemovedListener mListener;


    public DevicesAdapter(List<Device> devices, OnDeviceRemovedListener listener) {
        this.mDevices = devices;
        this.mListener = listener;
    }

    @NonNull
    @Override
    public DeviceViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        return new DeviceViewHolder(LayoutInflater.from(parent.getContext()).inflate(R.layout.item_device, parent, false));
    }

    @Override
    public void onBindViewHolder(@NonNull DeviceViewHolder holder, int position) {
        Device device = mDevices.get(holder.getAdapterPosition());

        String androidId = TawController.getUniqueId();

        if (device.getUniqueDeviceId().equals(androidId)) {
            holder.txtCurrentDevice.setVisibility(View.VISIBLE);
            holder.imgDelete.setVisibility(View.INVISIBLE);
            holder.imgDelete.setClickable(false);
        } else {
            holder.txtCurrentDevice.setVisibility(View.GONE);
            holder.imgDelete.setVisibility(View.VISIBLE);
            holder.imgDelete.setClickable(true);
        }


        holder.txtDeviceName.setText(device.getDeviceName());
        holder.txtDateDeviceLinked.setText(String.format(holder.itemView.getContext().getString(R.string.last_used), DateUtils.getDateddMMYYYY(device.getLastLoggedIn())));
    }

    public void remove(int position) {
        mDevices.remove(position);
        notifyItemRemoved(position);
    }

    @Override
    public int getItemCount() {
        return mDevices.size();
    }

    class DeviceViewHolder extends RecyclerView.ViewHolder {

        @BindView(R.id.img_delete)
        ImageView imgDelete;
        @BindView(R.id.txt_device_name)
        TextView txtDeviceName;
        @BindView(R.id.txt_date_device_linked)
        TextView txtDateDeviceLinked;

        @BindView(R.id.txt_current_device)
        TextView txtCurrentDevice;


        DeviceViewHolder(@NonNull View itemView) {
            super(itemView);
            ButterKnife.bind(this, itemView);

            txtDeviceName.setTypeface(FontUtils.getInstance().getDinAlternateBold());
            txtDateDeviceLinked.setTypeface(FontUtils.getInstance().getDinAlternateBold());
            txtCurrentDevice.setTypeface(FontUtils.getInstance().getDinAlternateBold());


            imgDelete.setOnClickListener(v -> mListener.onDeviceRemoved(mDevices.get(getAdapterPosition()), getAdapterPosition()));
        }
    }
}
