package co.pixelbeard.theanfieldwrap.dialog;

import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.graphics.Color;
import android.graphics.Point;
import android.graphics.drawable.ColorDrawable;
import android.os.Bundle;
import android.view.Window;
import android.view.WindowManager;
import android.widget.TextView;

import androidx.annotation.NonNull;

import butterknife.BindView;
import butterknife.ButterKnife;
import co.pixelbeard.theanfieldwrap.R;
import co.pixelbeard.theanfieldwrap.utils.AnimUtils;
import co.pixelbeard.theanfieldwrap.utils.FontUtils;
import co.pixelbeard.theanfieldwrap.utils.ScreenUtils;


public class LoadingDialog extends Dialog {

    @BindView(R.id.txt_loading_text)
    TextView txtLoadingText;
    private String mTitle;
    private Context mContext;


    public LoadingDialog(String title, @NonNull Context context) {
        super(context);

        this.mTitle = title;
        this.mContext = context;
    }


    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);


        requestWindowFeature(Window.FEATURE_NO_TITLE);
        Window window = getWindow();

        if (window != null) {
            window.setFlags(WindowManager.LayoutParams.FLAG_FULLSCREEN, WindowManager.LayoutParams.FLAG_FULLSCREEN);
//            window.getAttributes().windowAnimations = R.style.TAWDialogAnimationStyle;
        }

        setContentView(R.layout.dialog_loading);
        ButterKnife.bind(this);

        WindowManager manager = (WindowManager) mContext.getSystemService(Activity.WINDOW_SERVICE);
        int width, height;

        Point point = new Point();
        manager.getDefaultDisplay().getSize(point);
        width = point.x;
        height = point.y;

        WindowManager.LayoutParams lp = new WindowManager.LayoutParams();
        lp.copyFrom(this.getWindow().getAttributes());
        lp.width = width;
        lp.height = (int) (height - ScreenUtils.dpToPx(30, mContext));
        this.getWindow().setAttributes(lp);

        this.getWindow().setBackgroundDrawable(new ColorDrawable(Color.TRANSPARENT));


        txtLoadingText.setTypeface(FontUtils.getInstance().getDinProBlack());
        txtLoadingText.startAnimation(AnimUtils.getPulsateFadeLoader(mContext));

        if (mTitle != null && !mTitle.equals("")) {
            txtLoadingText.setText(mTitle);
        }
    }

    @Override
    public void onBackPressed() {

    }
}
