package co.pixelbeard.theanfieldwrap.forgotPassword;

import android.content.Context;
import android.os.Handler;

import androidx.fragment.app.FragmentManager;

import co.pixelbeard.theanfieldwrap.data.responses.GenericResponse;
import co.pixelbeard.theanfieldwrap.data.source.DataRepository;
import co.pixelbeard.theanfieldwrap.networking.CallbackWrapper;
import co.pixelbeard.theanfieldwrap.utils.BaseFragment;
import co.pixelbeard.theanfieldwrap.utils.FragmentUtils;

public class ForgotPasswordPresenter implements ForgotPasswordContract.Presenter {


    private ForgotPasswordContract.View mView;
    private DataRepository mRepo;


    public ForgotPasswordPresenter(ForgotPasswordContract.View view, DataRepository repo) {
        if (view != null && repo != null) {
            this.mView = view;
            this.mRepo = repo;

            mView.setPresenter(this);
        }
    }

    @Override
    public void nextClicked(FragmentManager fragMan) {
        BaseFragment fragment = FragmentUtils.getCurrentlyAttachedFragment(fragMan);

        if (fragment != null) {
            fragment.isValidated();
        }
    }

    @Override
    public void requestPasswordReset(String email, boolean isResend) {

        if (mView != null && mView.checkConnection()) {
            if (!isResend) {
                mView.showLoader("");
            }
            mRepo.requestPasswordReset(email).subscribe(new CallbackWrapper<GenericResponse>(mView) {
                @Override
                protected void onSuccess(GenericResponse genericResponse) {
                    new Handler().postDelayed(() -> {
                        if (mView != null) {
                            if (!isResend) {
                                mView.setForgotPasswordAuthFrag();
                            } else {
                                mView.showResentToast();
                            }
                        }

                    }, 100);
                }

                @Override
                protected void onSuccessFalse(GenericResponse genericResponse) {
                    mView.showSingleButtonDialog("Error", genericResponse.getMessage(), null);
                }
            });

        } else {
            if (mView != null) {
                mView.onConnectionError();
            }
        }
    }

    @Override
    public void resetPassword(String email, String recoveryCode, String password) {

        if (mView != null && mView.checkConnection()) {

            mRepo.resetPassword(email, recoveryCode, password).subscribe(new CallbackWrapper<GenericResponse>(mView) {
                @Override
                protected void onSuccess(GenericResponse genericResponse) {
                    mView.finishForgotPasswordActivity();
                }

                @Override
                protected void onSuccessFalse(GenericResponse genericResponse) {
                    mView.showSingleButtonDialog("Error", genericResponse.getMessage(), null);
                }
            });

        } else {
            if (mView != null) {
                mView.onConnectionError();
            }
        }
    }

    @Override
    public void subscribe() {

    }

    @Override
    public void unsubscribe() {

    }

    @Override
    public void clearUserData(Context context) {
        //Not needed
    }
}
