package co.pixelbeard.theanfieldwrap.login;

import android.content.Context;

import java.util.List;

import co.pixelbeard.theanfieldwrap.data.Device;
import co.pixelbeard.theanfieldwrap.utils.BasePresenter;
import co.pixelbeard.theanfieldwrap.utils.BaseView;

public interface LoginContract {

    interface View extends BaseView<Presenter> {
        void startForgotPasswordActivity(String email);

        void startHomeActivity();

        void startSignUpActivity(String email);

        void showEmailError(String message);

        void showPasswordError(String message);

        void enableButton();

        void disableLoginButton();

        String getStringFromResource(int resourceId);

        void showDeviceLimitDialog(List<Device> deviceList);

        void showSingleButtonDialog(String error, String message);

        void finishLoginActivity();

        void showLoginSuccess();
    }

    interface Presenter extends BasePresenter {
        void backClicked();

        void forgotPasswordClicked(String email);

        void skipLoginClicked();

        void loginClicked(String email, String password, boolean fromGuest);

        boolean checkValidated(String email, String password, boolean shouldShowError);

        boolean checkConnection(Context mContext);

    }
}