package co.pixelbeard.theanfieldwrap.networking;

public class NetworkConstants {

    /**
     * Base Constants
     */

    public static final int PAGE_SIZE = 25;

    static final String HEADER_API_TOKEN = "api-token";
    static final String API_TOKEN = "34dbda4d941fabbd435796f2154dfab9";


    /**
     * Analytics Endpoints
     */

    static final String RECORD_ANALYTIC_ENDPOINT = "analytics/record";

    /**
     * User Services Endpoints
     */

    //Login/Logout
    static final String LOGIN_ENDPOINT = "users/login";
    static final String LOGOUT_USER_ENDPOINT = "users/logout";

    //Register
    static final String REGISTER_GUEST_ENDPOINT = "users/register/guest";
    static final String CONVERT_GUEST_TO_FULL_USER = "users/register/guest/convert";
    static final String REGISTER_FULL_ENDPOINT = "users/register";
    static final String CHECK_EMAIL_ENDPOINT = "users/email/check";
    static final String CHECK_USERNAME_ENDPOINT = "users/username/check";

    //Activation
    static final String RESEND_ACTIVATION_ENDPOINT = "users/activation/resend";
    static final String ACTIVATE_USER_ENDPOINT = "users/activate";

    //Edit user details
    static final String CHANGE_PASSWORD_ENDPOINT = "users/password";
    static final String UPDATE_DETAILS_ENDPOINT = "users/update";
    static final String UPDATE_EMAIL_ENDPOINT = "users/update/email";

    //Reset password
    static final String REQUEST_PASSWORD_RESET_ENDPOINT = "users/recover";
    static final String RESET_PASSWORD_ENDPOINT = "users/reset";

    //Subscription
    static final String CHECK_SUBS_ENDPOINT = "users/subscription/check";

    /**
     * Settings Endpoints
     */

    static final String GET_SETTINGS_ENDPOINT = "users/preferences";
    static final String UPDATE_SETTINGS_ENDPOINT = "users/preferences/{type}";


    /**
     * Device Management Endpoints
     */

    static final String UNLINK_DEVICE_ENDPOINT = "users/devices/remove";
    static final String GET_ACTIVE_DEVICES_ENDPOINT = "users/devices";


    /**
     * Wallet Endpoints
     */

    static final String GET_WALLET_ENDPOINT = "users/wallet";
    static final String CREDIT_ACCOUNT_ENDPOINT = "users/wallet/credit";
    static final String PURCHASE_ITEM_ENDPOINT = "users/wallet/purchase";

    /**
     * Feeds Endpoints
     */

    //Podcasts
    static final String GET_PODCASTS_ENDPOINT = "feed/podcasts/{pageNum}/limit/" + PAGE_SIZE;
    static final String GET_PODCAST_BY_ID_ENDPOINT = "feed/podcast/{podcastId}";

    //Articles
    static final String GET_ARTICLES_ENDPOINT = "feed/writing/{pageNum}/limit/" + PAGE_SIZE;
    static final String GET_ARTICLE_BY_ID_ENDPOINT = "feed/article/{articleId}";

    //Videos
    static final String GET_VIDEOS_ENDPOINT = "feed/videos/{pageNum}/limit/" + PAGE_SIZE;
    static final String GET_VIDEO_BY_ID_ENDPOINT = "feed/video/{videoId}";

    //subscription
    static final String GET_SUBSCRIPTION_LIST_ENDPOINT  = "free-subscriptions";
    static final String ACTIVE_FREE_SUBSCRIPTION  = "user/activate-free-subscription";
    static final String ACTIVE_PAID_SUBSCRIPTION  = "user/activate-subscription";

}
