package co.pixelbeard.theanfieldwrap.settings;

import java.util.List;

import co.pixelbeard.theanfieldwrap.data.NotificationSetting;
import co.pixelbeard.theanfieldwrap.utils.BasePresenter;
import co.pixelbeard.theanfieldwrap.utils.BaseView;

public interface SettingsContract {

    interface View extends BaseView<Presenter> {
        void setNotificationSettingsAdapter(List<NotificationSetting> settings, boolean fromLocal);

        void disableSettings();

        void enableSettings();

        void showSingleButtonDialog(String error, String message);

    }

    interface Presenter extends BasePresenter {
        void getUserSettings();

        void updateUserSetting(String type, int value);

    }
}