package co.pixelbeard.theanfieldwrap.splash;

import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.util.Log;
import android.view.View;
import android.view.animation.Animation;

import androidx.annotation.Nullable;
import androidx.databinding.DataBindingUtil;

import com.facebook.FacebookSdk;
import com.jaredrummler.android.device.DeviceName;

import co.pixelbeard.theanfieldwrap.R;
import co.pixelbeard.theanfieldwrap.data.source.DataRepository;
import co.pixelbeard.theanfieldwrap.data.source.local.LocalRepository;
import co.pixelbeard.theanfieldwrap.data.source.remote.RemoteRepository;
import co.pixelbeard.theanfieldwrap.databinding.ActivitySplashBinding;
import co.pixelbeard.theanfieldwrap.home.HomeActivity;
import co.pixelbeard.theanfieldwrap.utils.ActivityExtraTags;
import co.pixelbeard.theanfieldwrap.utils.AnimUtils;
import co.pixelbeard.theanfieldwrap.utils.BaseActivity;
import co.pixelbeard.theanfieldwrap.utils.ConnectionUtils;
import co.pixelbeard.theanfieldwrap.utils.PrefKey;
import co.pixelbeard.theanfieldwrap.utils.PrefUtils;
import co.pixelbeard.theanfieldwrap.utils.ScreenUtils;
import co.pixelbeard.theanfieldwrap.utils.TawController;
import co.pixelbeard.theanfieldwrap.walkthrough.WalkthroughActivity;
import io.realm.Realm;

/**
 * Created by Michael Stoddart
 * 17/12/2018.
 */
public class SplashActivity extends BaseActivity implements SplashContract.View {

    private static final String TAG = SplashActivity.class.getSimpleName();

    private ActivitySplashBinding binding;

    private SplashContract.Presenter mPresenter;

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        FacebookSdk.sdkInitialize(getApplicationContext());
        super.onCreate(savedInstanceState);

        binding = DataBindingUtil.setContentView(this, R.layout.activity_splash);

        new SplashPresenter(this, new DataRepository(new LocalRepository(Realm.getDefaultInstance()), new RemoteRepository()));

        DeviceName.with(this).request((info, error) -> {
            String manufacturer = info.manufacturer;
            String name = info.marketName;
            String model = info.model;
            String codename = info.codename;
            String deviceName = info.getName();

            Log.d("Manufacturer", manufacturer);
            Log.d("name", name);
            Log.d("model", model);
            Log.d("codename", codename);
            Log.d("deviceName", deviceName);

        });

        new Handler().postDelayed(this::runEntryAnimations, 0);
    }

    @Override
    protected void onResume() {
        super.onResume();
        TawController.setCurrentPage(TAG);
    }

    private void runEntryAnimations() {
        AnimUtils.startTranslateAlphaEntryAnimationSet(binding.imgSplashLogo, ScreenUtils.dpToPx(50, this), 0, new Animation.AnimationListener() {
            @Override
            public void onAnimationStart(Animation animation) {

            }

            @Override
            public void onAnimationEnd(Animation animation) {
                binding.imgSplashLogo.setVisibility(View.VISIBLE);

                if (PrefUtils.getInstance().getBooleanPref(PrefKey.LOGGED_IN) && (PrefUtils.getInstance().getIntPref(PrefKey.AUTH_LEVEL) >= 3 || PrefUtils.getInstance().getBooleanPref(PrefKey.IS_GUEST_ACCOUNT))) {
                    if (!PrefUtils.getInstance().getBooleanPref(PrefKey.IS_GUEST_ACCOUNT)) {
                        mPresenter.checkUserSubs();
                    }
                    startHomeActivity();
                } else {
                    new Handler().postDelayed(() -> startWalkthroughActivity(), 400);
                }
            }

            @Override
            public void onAnimationRepeat(Animation animation) {

            }
        });
    }

    @Override
    public void setPresenter(SplashContract.Presenter presenter) {
        if (presenter != null) {
            this.mPresenter = presenter;
        } else {
            throw new RuntimeException("Presenter is null");
        }
    }

    @Override
    public void goBack() {
        //Not needed
    }

    @Override
    public void showLoader(String text) {
        //Not needed
    }

    @Override
    public void hideLoader() {
        //Not needed
    }

    @Override
    public void onUnknownError(String error) {
        //Not needed maybe future addition but any of these issues would caught and handled in next screen anyway
    }

    @Override
    public void onTimeout() {
        //Not needed maybe future addition but any of these issues would caught and handled in next screen anyway
    }

    @Override
    public void onNetworkError() {
        //Not needed maybe future addition but any of these issues would caught and handled in next screen anyway
    }

    @Override
    public void onConnectionError() {
        //Not needed maybe future addition but any of these issues would caught and handled in next screen anyway
    }

    @Override
    public void logoutUser() {
        //Not needed maybe future addition but any of these issues would caught and handled in next screen anyway
    }

    @Override
    public boolean checkConnection() {
        return ConnectionUtils.userHasConnection(this);
    }

    @Override
    public void startWalkthroughActivity() {
        Intent intent = new Intent(this, WalkthroughActivity.class);
        startActivity(intent);
        finish();
        overridePendingTransition(R.anim.slide_in_from_right, R.anim.slide_out_left);
    }

    @Override
    public void startHomeActivity() {

        String payload = getIntent().getStringExtra(ActivityExtraTags.NOTIF_PAYLOAD);

        Intent intent = new Intent(this, HomeActivity.class);

        if (payload != null) {
            intent.putExtra(ActivityExtraTags.NOTIF_PAYLOAD, payload);
        }

        startActivity(intent);
        finish();
        overridePendingTransition(R.anim.slide_in_from_right, R.anim.slide_out_left);
    }
}
