package co.pixelbeard.theanfieldwrap.utils;


import android.view.View;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;

import androidx.fragment.app.Fragment;

/**
 */
public class BaseFragment extends Fragment {

    public BaseFragment() {
        // Required empty public constructor
    }

    public void isValidated() {

    }

    public Animation onCreateAnimation(int transit, boolean enter, int nextAnim) {
        Animation animation = super.onCreateAnimation(transit, enter, nextAnim);


        if (animation == null && nextAnim != 0) {
            animation = AnimationUtils.loadAnimation(getActivity(), nextAnim);
        }

        if (animation != null && getView() != null) {
            getView().setLayerType(View.LAYER_TYPE_HARDWARE, null);

            animation.setAnimationListener(new Animation.AnimationListener() {
                @Override
                public void onAnimationStart(Animation animation) {

                }

                public void onAnimationEnd(Animation animation) {
                    if (getView() != null) {
                        getView().setLayerType(View.LAYER_TYPE_NONE, null);
                    }
                }

                @Override
                public void onAnimationRepeat(Animation animation) {

                }

                // ...other AnimationListener methods go here...
            });
        }


        return animation;
    }


//    @Override
//    public Animation onCreateAnimation(int transit, boolean enter, int nextAnim) {
//        Animation animation = super.onCreateAnimation(transit, enter, nextAnim);
//
//        // HW layer support only exists on API 11+
//        if (animation == null && nextAnim != 0) {
//            animation = AnimationUtils.loadAnimation(getActivity(), nextAnim);
//        }
//
//        if (animation != null) {
//            getView().setLayerType(View.LAYER_TYPE_HARDWARE, null);
//
//            animation.setAnimationListener(new Animation.AnimationListener() {
//                @Override
//                public void onAnimationStart(Animation animation) {
//
//                }
//
//                public void onAnimationEnd(Animation animation) {
//                    getView().setLayerType(View.LAYER_TYPE_NONE, null);
//                }
//
//                @Override
//                public void onAnimationRepeat(Animation animation) {
//
//                }
//
//                // ...other AnimationListener methods go here...
//            });
//        }
//
//
//        return animation;
//    }

}
