package co.pixelbeard.theanfieldwrap.utils;

import android.content.Context;
import android.view.View;

import androidx.viewpager2.widget.ViewPager2;


public class CustomPagerTransformer implements ViewPager2.PageTransformer {

    private int maxTranslateOffsetX;
    private float MAX_SCALE = 0.0f;
    private int mPageMargin;
    private boolean animationEnabled = true;
    private boolean fadeEnabled = false;
    private float fadeFactor = 0.5f;

    public CustomPagerTransformer(Context context) {
        this.maxTranslateOffsetX = dp2px(context, 180);
//        mPageMargin = (int) ScreenUtils.dpToPx(20, context);
    }

    public void transformPage(View view, float position) {

        int leftInScreen = view.getLeft() - view.getScrollX();
        int centerXInViewPager = leftInScreen + view.getMeasuredWidth() / 2;
        int offsetX = centerXInViewPager - view.getMeasuredWidth() / 2;
        float offsetRate = (float) offsetX * 0.2f / view.getMeasuredWidth();
        float scaleFactor = 1 - Math.abs(offsetRate);


        if (scaleFactor > 0) {
            view.setScaleX(scaleFactor);
            view.setScaleY(scaleFactor);
            view.setTranslationX(-maxTranslateOffsetX * offsetRate);
//            view.setTranslationY(-maxTranslateOffsetX * offsetRate);
        }
//
//        if (mPageMargin <= 0 || !animationEnabled)
//            return;
//        page.setPadding(mPageMargin / 3, mPageMargin / 3, mPageMargin / 3, mPageMargin / 3);
//
//        if (MAX_SCALE == 0.0f && position > 0.0f && position < 1.0f) {
//            MAX_SCALE = position;
//        }
//        position = position - MAX_SCALE;
//        float absolutePosition = Math.abs(position);
//        if (position <= -1.0f || position >= 1.0f) {
//            if (fadeEnabled)
//                page.setAlpha(fadeFactor);
//            // Page is not visible -- stop any running animations
//
//        } else if (position == 0.0f) {
//
//            // Page is selected -- reset any views if necessary
//            page.setScaleX((1 + MAX_SCALE));
//            page.setScaleY((1 + MAX_SCALE));
//            page.setAlpha(1);
//        } else {
//            page.setScaleX(1 + MAX_SCALE * (1 - absolutePosition));
//            page.setScaleY(1 + MAX_SCALE * (1 - absolutePosition));
//            if (fadeEnabled)
//                page.setAlpha(Math.max(fadeFactor, 1 - absolutePosition));
//        }


    }

    private int dp2px(Context context, float dipValue) {
        float m = context.getResources().getDisplayMetrics().density;
        return (int) (dipValue * m + 0.5f);
    }

}
