package co.pixelbeard.theanfieldwrap.utils;

import android.content.Context;
import android.graphics.Typeface;

/**
 * Created by Michael Stoddart
 * 20/12/2018.
 */
public class FontUtils {
    private static final String TAG = FontUtils.class.getSimpleName();

    private static Typeface dinAlternateBold = null, dinCondensedBold = null, dinBlack = null, dinProBlack = null, robotoBold = null, arialReg = null;

    private static FontUtils instance = null;

    private FontUtils(Context context) {

        dinAlternateBold = Typeface.createFromAsset(context.getAssets(), "fonts/DINAlternateBold.ttf");
        dinCondensedBold = Typeface.createFromAsset(context.getAssets(), "fonts/DINCondensedBold.ttf");
        dinProBlack = Typeface.createFromAsset(context.getAssets(), "fonts/DINPro-Black.otf");
        dinBlack = Typeface.createFromAsset(context.getAssets(), "fonts/DIN-Black.ttf");
        robotoBold = Typeface.createFromAsset(context.getAssets(), "fonts/Roboto-Bold.ttf");
        arialReg = Typeface.createFromAsset(context.getAssets(), "fonts/Arial-Reg.ttf");

    }

    public static synchronized FontUtils getInstance(Context context) {
        if (instance == null) {
            instance = new FontUtils(context);
        }
        return instance;
    }

    public static synchronized FontUtils getInstance() {
        if (instance == null) {
            throw new IllegalStateException(TAG +
                    "is not initialized, call getInstance(Context) first");
        }
        return instance;
    }


    public Typeface getDinAlternateBold() {
        return dinAlternateBold;
    }

    public Typeface getDinCondensedBold() {
        return dinCondensedBold;
    }

    public Typeface getDinProBlack() {
        return dinProBlack;
    }

    public Typeface getRobotoBold() {
        return robotoBold;
    }

    public Typeface getDinBlack() {
        return dinBlack;
    }

    public Typeface getArialReg() {
        return arialReg;
    }
}
