package co.pixelbeard.theanfieldwrap.utils;

import android.util.Log;

import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleObserver;
import androidx.lifecycle.OnLifecycleEvent;

import co.pixelbeard.theanfieldwrap.data.responses.GenericResponse;
import co.pixelbeard.theanfieldwrap.data.source.remote.RemoteRepository;
import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;


public class LifecycleListener implements LifecycleObserver {

    @OnLifecycleEvent(Lifecycle.Event.ON_START)
    void onMoveToForeground() {
        Log.d("LIFECYCLE", "FOREGROUNDED");


    }

    @OnLifecycleEvent(Lifecycle.Event.ON_STOP)
    void onMoveToBackground() {
        Log.d("LIFECYCLE", "BACKGROUNDED");


        try {
            RemoteRepository remoteRepository = new RemoteRepository();
            remoteRepository.recordAnalytic(AnalyticsConstants.USER_BACKGROUNDED_APP, TawController.getCurrentPage(), "1").subscribe(new Observer<GenericResponse>() {
                @Override
                public void onSubscribe(Disposable d) {
                }

                @Override
                public void onNext(GenericResponse genericResponse) {
                    if (genericResponse != null) {
                        Log.d(AnalyticsConstants.USER_BACKGROUNDED_APP, genericResponse.getMessage());
                    }
                }

                @Override
                public void onError(Throwable e) {
                    e.printStackTrace();
                }

                @Override
                public void onComplete() {

                }
            });

        } catch (Exception e) {
            e.printStackTrace();
        }
    }

}
