package co.pixelbeard.theanfieldwrap.videos;

import java.util.List;

import co.pixelbeard.theanfieldwrap.data.Video;
import co.pixelbeard.theanfieldwrap.utils.BasePresenter;
import co.pixelbeard.theanfieldwrap.utils.BaseView;

public interface VideosContract {

    interface View extends BaseView<Presenter> {

        void setVideosAdapter(List<Video> videos);

        void showNoConnectionUi();

        void showNoConnectionHeader();

        void showUi();

        void setSwipeRefreshRefreshing(boolean refreshing);

        void showSingleButtonDialog(String error, String message);

    }

    interface Presenter extends BasePresenter {
        void getVideos(int pageNum);

        void checkUserSubs();

        void refreshVideos();

        void recordAnalytic(String type, String variable, String secondVar);
    }
}