package co.pixelbeard.theanfieldwrap.writingDetails;

import android.content.Context;
import android.util.Log;

import co.pixelbeard.theanfieldwrap.data.responses.ArticleByIdResponse;
import co.pixelbeard.theanfieldwrap.data.responses.GenericResponse;
import co.pixelbeard.theanfieldwrap.data.source.DataRepository;
import co.pixelbeard.theanfieldwrap.networking.CallbackWrapper;
import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;

public class WritingDetailPresenter implements WritingDetailContract.Presenter {


    private WritingDetailContract.View mView;
    private DataRepository mRepo;

    public WritingDetailPresenter(WritingDetailContract.View view, DataRepository repo) {
        if (view != null && repo != null) {
            this.mView = view;
            this.mRepo = repo;

            mView.setPresenter(this);
        }
    }

    @Override
    public void recordAnalytic(String type, String variable, String secondVar) {
        mRepo.recordAnalytic(type, variable, secondVar).subscribe(new Observer<GenericResponse>() {
            @Override
            public void onSubscribe(Disposable d) {
            }

            @Override
            public void onNext(GenericResponse genericResponse) {
                if (genericResponse != null) {
                    Log.d("ANALYTIC: " + type, genericResponse.getMessage());
                }
            }

            @Override
            public void onError(Throwable e) {
                e.printStackTrace();
            }

            @Override
            public void onComplete() {
            }
        });
    }

    @Override
    public void getArticleById(long id) {
        if (mView != null && mView.checkConnection()) {
            mView.showLoader("Loading");
            mRepo.getArticleById(id).subscribe(new CallbackWrapper<ArticleByIdResponse>(mView) {
                @Override
                protected void onSuccess(ArticleByIdResponse articleByIdResponse) {
                    mView.setArticle(articleByIdResponse.getArticle());
                }

                @Override
                protected void onSuccessFalse(ArticleByIdResponse articleByIdResponse) {
                    mView.goBack();
                }
            });
        } else {
            if (mView != null) {
                mView.onConnectionError();
            }
        }
    }

    @Override
    public void subscribe() {

    }

    @Override
    public void unsubscribe() {

    }

    @Override
    public void clearUserData(Context context) {
        mRepo.logout().subscribe(new Observer<GenericResponse>() {
            @Override
            public void onSubscribe(Disposable d) {

            }

            @Override
            public void onNext(GenericResponse genericResponse) {
                Log.d("LOGOUT", genericResponse.getMessage());
            }

            @Override
            public void onError(Throwable e) {

            }

            @Override
            public void onComplete() {

            }
        });
        //TODO test this
//        mRepo.clearAllData(context);
    }
}
