package co.pixelbeard.theanfieldwrap.writingDetails.viewholders;

import android.text.Html;
import android.view.View;
import android.widget.TextView;

import androidx.annotation.NonNull;

import butterknife.BindView;
import butterknife.ButterKnife;
import co.pixelbeard.theanfieldwrap.R;
import co.pixelbeard.theanfieldwrap.utils.FontUtils;

public class ContentTextViewHolder extends BaseContentViewHolder {


    @BindView(R.id.txt_article_content)
    TextView txtArticleContent;

    public ContentTextViewHolder(@NonNull View itemView) {
        super(itemView);

        ButterKnife.bind(this, itemView);

        txtArticleContent.setTypeface(FontUtils.getInstance().getArialReg());
    }

    @Override
    public void bindView(String content) {
        super.bindView(content);

        content = content.replaceAll("\\n", "<br>");

        txtArticleContent.setText(Html.fromHtml(content));
    }
}
