#! /usr/bin/env perl

use strict;

die "Usage: $0 USERSFILE GROUPSFILE\n" unless @ARGV == 2;
my ($users_file, $groups_file) = @ARGV;

my %users;
open my $fh, "<$users_file" or die "cannot open '$users_file': $!\n";
while (my $line = <$fh>) {
    chomp $line;
    my ($name, $password) = split /:/, $line, 2;
    next if !defined $password;
    $users{$name} = $line;
}

open my $fh, "<$groups_file" or die "cannot open '$groups_file': $!\n";
while (my $line = <$fh>) {
    my ($name, $members) = split /:/, $line, 2 or next;
    next if !defined $members;
    $name =~ s/[ \t]//g;
    next if $name eq '';
    my @members = grep { length $_ && exists $users{$_} } 
                  split /[ \t\r\n]+/, $members;
    
    my $groups_users_file = $name . '.users';

    print "Writing users file '$groups_users_file'.\n";

    open my $wh, ">>$groups_users_file" 
        or die "Cannot open '$groups_users_file' for writing: $!\n";

    foreach my $user (@members) {
        print $wh "$users{$user}\n"
            or die "Cannot write to '$groups_users_file': $!\n";
    }

    close $wh or die "Cannot close '$groups_users_file': $!\n";
}
