<?php

class am4Cart extends am4Plugin
{
    function action_WpEnqueueScripts(){
        wp_register_script('amember4-cart', am4PluginsManager::getAPI()->getRootURL() . '/application/cart/views/public/js/cart.js', [], null, true);
    }
}

class am4Shortcode_am4basket extends am4Shortcode
{
    function getDescription()
    {
        return __('Include Shopping Cart Widget', 'am4-plugin');
    }

    function getSyntax()
    {
        return "[am4basket]";
    }

    function run($atts= [], $content='')
    {
        wp_enqueue_script('amember4-cart');

        return <<<CUT
<script type="text/javascript">
    jQuery(function(){cart.loadOnly();});
</script>
<div class="am-basket-preview"></div>
CUT;

    }
}

class am4Shortcode_am4button extends am4Shortcode
{
    function getDescription()
    {
        return __('Include Add To Cart Button', 'am4-plugin');
    }

    function getSyntax()
    {
        return "[am4button type='' action='' title='' pids='' src='']";
    }

    function run($atts= [], $content='')
    {
        if (empty($atts['pids'])) return;

        $valid = [
            'action' => ['addCheckoutExternal', 'addExternal', 'addBasketExternal'],
            'type' => ['button', 'link', 'image'],
        ];
        $default = [
            'title' => 'Add To Cart',
            'action' => 'addCheckoutExternal',
            'type' => 'button'
        ];

        foreach ($default as $token => $default) {
            if (empty($atts[$token])) {
                $atts[$token] = $default;
            }
        }

        foreach ($valid as $token => $opts) {
            if (!in_array($atts[$token], $opts)) {
                $atts[$token] = $opts[0];
            }
        }

        if ($atts['type'] == 'image' && empty($atts['src'])) {
            $atts['type'] = 'button';
        }

        wp_enqueue_script('amember4-cart');

        $_ = [];
        foreach (explode(',', $atts['pids']) as $id) {
            $product = explode('-', $id);
            $item = ['type' => 'product'];
            $item['id'] = $product[0];
            if (!empty($product[1])) {
                $item['plan'] = $product[1];
            }
            $item['qty'] = !empty($product[2]) ? $product[2] : 1;
            $_[] = json_encode($item);
        }

        switch ($atts['type']) {
            case 'button' :
                return sprintf("<input type='button' onclick='cart.%s(this, %s); return false;' value='%s' />",
                    $atts['action'], implode(', ', $_), htmlspecialchars($atts['title']));
                break;
            case 'link' :
                return sprintf("<a href='javascript:;' onclick='cart.%s(this, %s); return false;'>%s</a>",
                    $atts['action'], implode(', ', $_), htmlspecialchars($atts['title']));
                break;
            case 'image' :
                return sprintf("<a href='javascript:;' onclick='cart.%s(this, %s); return false;'><img src='%s' alt='%4\$s' title='%4\$s'</a>",
                    $atts['action'], implode(', ', $_), htmlspecialchars($atts['src']), htmlspecialchars($atts['title']));
                break;
        }
    }
}