<?php
/**
 * That is a compressed version of great https://github.com/YahnisElsts/plugin-update-checker
 *
 * Compressed by Alex Scott <alex@cgi-central.net> for easy redistribution
 *
 * LICENSE
Copyright (c) 2017 Jānis Elsts

Permission is hereby granted, free of charge, to any person obtaining a copy of
this software and associated documentation files (the "Software"), to deal in
the Software without restriction, including without limitation the rights to use,
copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the
Software, and to permit persons to whom the Software is furnished to do so, subject
to the following conditions:

The above copyright notice and this permission notice shall be included in all copies
or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED,
INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.


/* @source /utils/library/Puc/v4p2/Metadata.php */
if ( !class_exists('Puc_v4p2_Metadata', false) ): abstract class Puc_v4p2_Metadata { public static function fromJson( $json) { throw new LogicException('The ' . __METHOD__ . ' method must be implemented by subclasses'); } protected static function createFromJson($json, $target) { $apiResponse = json_decode($json); if ( empty($apiResponse) || !is_object($apiResponse) ){ trigger_error( "Failed to parse update metadata. Try validating your .json file with http://jsonlint.com/", E_USER_NOTICE ); return false; } $valid = $target->validateMetadata($apiResponse); if ( is_wp_error($valid) ){ trigger_error($valid->get_error_message(), E_USER_NOTICE); return false; } foreach(get_object_vars($apiResponse) as $key => $value){ $target->$key = $value; } return true; } protected function validateMetadata( $apiResponse) { return true; } public static function fromObject( $object) { throw new LogicException('The ' . __METHOD__ . ' method must be implemented by subclasses'); } public function toStdClass() { $object = new stdClass(); $this->copyFields($this, $object); return $object; } abstract public function toWpFormat(); protected function copyFields($from, $to) { $fields = $this->getFieldNames(); if ( property_exists($from, 'slug') && !empty($from->slug) ) { $fields = apply_filters($this->getPrefixedFilter('retain_fields') . '-' . $from->slug, $fields); } foreach ($fields as $field) { if ( property_exists($from, $field) ) { $to->$field = $from->$field; } } } protected function getFieldNames() { return array(); } protected function getPrefixedFilter($tag) { return 'puc_' . $tag; } } endif;

/* @source /utils/library/Puc/v4p2/Update.php */
if ( !class_exists('Puc_v4p2_Update', false) ): abstract class Puc_v4p2_Update extends Puc_v4p2_Metadata { public $slug; public $version; public $download_url; public $translations = array(); protected function getFieldNames() { return array('slug', 'version', 'download_url', 'translations'); } public function toWpFormat() { $update = new stdClass(); $update->slug = $this->slug; $update->new_version = $this->version; $update->package = $this->download_url; return $update; } } endif;

/* @source /utils/library/Puc/v4p2/UpdateChecker.php */
if ( !class_exists('Puc_v4p2_UpdateChecker', false) ): abstract class Puc_v4p2_UpdateChecker { protected $filterSuffix = ''; protected $updateTransient = ''; protected $translationType = ''; public $debugMode = false; public $optionName = ''; public $metadataUrl = ''; public $directoryName = ''; public $slug = ''; public $scheduler; protected $upgraderStatus; protected $updateState; public function __construct($metadataUrl, $directoryName, $slug = null, $checkPeriod = 12, $optionName = '') { $this->debugMode = (bool)(constant('WP_DEBUG')); $this->metadataUrl = $metadataUrl; $this->directoryName = $directoryName; $this->slug = !empty($slug) ? $slug : $this->directoryName; $this->optionName = $optionName; if ( empty($this->optionName) ) { if ( $this->filterSuffix === '' ) { $this->optionName = 'external_updates-' . $this->slug; } else { $this->optionName = $this->getUniqueName('external_updates'); } } $this->scheduler = $this->createScheduler($checkPeriod); $this->upgraderStatus = new Puc_v4p2_UpgraderStatus(); $this->updateState = new Puc_v4p2_StateStore($this->optionName); if ( did_action('init') ) { $this->loadTextDomain(); } else { add_action('init', array($this, 'loadTextDomain')); } $this->installHooks(); } public function loadTextDomain() { $domain = 'plugin-update-checker'; $locale = apply_filters( 'plugin_locale', (is_admin() && function_exists('get_user_locale')) ? get_user_locale() : get_locale(), $domain ); $moFile = $domain . '-' . $locale . '.mo'; $path = realpath(dirname(__FILE__) . '/../../languages'); if ($path && file_exists($path)) { load_textdomain($domain, $path . '/' . $moFile); } } protected function installHooks() { add_filter('site_transient_' . $this->updateTransient, array($this,'injectUpdate')); add_filter('site_transient_' . $this->updateTransient, array($this, 'injectTranslationUpdates')); add_action( 'delete_site_transient_' . $this->updateTransient, array($this, 'clearCachedTranslationUpdates') ); if ( $this->directoryName !== '.' ) { add_filter('upgrader_source_selection', array($this, 'fixDirectoryName'), 10, 3); } add_filter('http_request_host_is_external', array($this, 'allowMetadataHost'), 10, 2); if ( did_action('plugins_loaded') ) { $this->maybeInitDebugBar(); } else { add_action('plugins_loaded', array($this, 'maybeInitDebugBar')); } } abstract public function userCanInstallUpdates(); public function allowMetadataHost($allow, $host) { static $metadataHost = 0; if ( $metadataHost === 0 ) { $metadataHost = @parse_url($this->metadataUrl, PHP_URL_HOST); } if ( is_string($metadataHost) && (strtolower($host) === strtolower($metadataHost)) ) { return true; } return $allow; } abstract protected function createScheduler($checkPeriod); public function checkForUpdates() { $installedVersion = $this->getInstalledVersion(); if ( $installedVersion === null ) { $this->triggerError( sprintf('Skipping update check for %s - installed version unknown.', $this->slug), E_USER_WARNING ); return null; } $state = $this->updateState; $state->setLastCheckToNow() ->setCheckedVersion($installedVersion) ->save(); $state->setUpdate($this->requestUpdate()); $state->save(); return $this->getUpdate(); } public function getUpdateState() { return $this->updateState->lazyLoad(); } public function resetUpdateState() { $this->updateState->delete(); } public function getUpdate() { $update = $this->updateState->getUpdate(); if ( isset($update) ) { $installedVersion = $this->getInstalledVersion(); if ( ($installedVersion !== null) && version_compare($update->version, $installedVersion, '>') ){ return $update; } } return null; } abstract public function requestUpdate(); protected function filterUpdateResult($update, $httpResult = null) { $update = apply_filters($this->getUniqueName('request_update_result'), $update, $httpResult); if ( isset($update, $update->translations) ) { $update->translations = $this->filterApplicableTranslations($update->translations); } return $update; } abstract public function getInstalledVersion(); protected function triggerError($message, $errorType) { if ($this->debugMode) { trigger_error($message, $errorType); } } public function getUniqueName($baseTag) { $name = 'puc_' . $baseTag; if ($this->filterSuffix !== '') { $name .= '_' . $this->filterSuffix; } return $name . '-' . $this->slug; } public function addFilter($tag, $callback, $priority = 10, $acceptedArgs = 1) { add_filter($this->getUniqueName($tag), $callback, $priority, $acceptedArgs); } public function injectUpdate($updates) { $update = $this->getUpdate(); if ( !$this->shouldShowUpdates() ) { $update = null; } if ( !empty($update) ) { $update = apply_filters($this->getUniqueName('pre_inject_update'), $update); $updates = $this->addUpdateToList($updates, $update->toWpFormat()); } else { $updates = $this->removeUpdateFromList($updates); } return $updates; } protected function addUpdateToList($updates, $updateToAdd) { if ( !is_object($updates) ) { $updates = new stdClass(); $updates->response = array(); } $updates->response[$this->getUpdateListKey()] = $updateToAdd; return $updates; } protected function removeUpdateFromList($updates) { if ( isset($updates, $updates->response) ) { unset($updates->response[$this->getUpdateListKey()]); } return $updates; } abstract protected function getUpdateListKey(); protected function shouldShowUpdates() { return true; } protected function requestMetadata($metaClass, $filterRoot, $queryArgs = array()) { $queryArgs = array_merge( array( 'installed_version' => strval($this->getInstalledVersion()), 'php' => phpversion(), 'locale' => get_locale(), ), $queryArgs ); $queryArgs = apply_filters($this->getUniqueName($filterRoot . '_query_args'), $queryArgs); $options = array( 'timeout' => 10, 'headers' => array( 'Accept' => 'application/json', ), ); $options = apply_filters($this->getUniqueName($filterRoot . '_options'), $options); $url = $this->metadataUrl; if ( !empty($queryArgs) ){ $url = add_query_arg($queryArgs, $url); } $result = wp_remote_get($url, $options); $result = apply_filters($this->getUniqueName('request_metadata_http_result'), $result, $url, $options); $status = $this->validateApiResponse($result); $metadata = null; if ( !is_wp_error($status) ){ $metadata = call_user_func(array($metaClass, 'fromJson'), $result['body']); } else { $this->triggerError( sprintf('The URL %s does not point to a valid metadata file. ', $url) . $status->get_error_message(), E_USER_WARNING ); } return array($metadata, $result); } protected function validateApiResponse($result) { if ( is_wp_error($result) ) { return new WP_Error($result->get_error_code(), 'WP HTTP Error: ' . $result->get_error_message()); } if ( !isset($result['response']['code']) ) { return new WP_Error( 'puc_no_response_code', 'wp_remote_get() returned an unexpected result.' ); } if ( $result['response']['code'] !== 200 ) { return new WP_Error( 'puc_unexpected_response_code', 'HTTP response code is ' . $result['response']['code'] . ' (expected: 200)' ); } if ( empty($result['body']) ) { return new WP_Error('puc_empty_response', 'The metadata file appears to be empty.'); } return true; } protected function filterApplicableTranslations($translations) { $languages = array_flip(array_values(get_available_languages())); $installedTranslations = $this->getInstalledTranslations(); $applicableTranslations = array(); foreach($translations as $translation) { $isApplicable = array_key_exists($translation->language, $languages); if ( isset($installedTranslations[$translation->language]) ) { $updateTimestamp = strtotime($translation->updated); $installedTimestamp = strtotime($installedTranslations[$translation->language]['PO-Revision-Date']); $isApplicable = $updateTimestamp > $installedTimestamp; } if ( $isApplicable ) { $applicableTranslations[] = $translation; } } return $applicableTranslations; } protected function getInstalledTranslations() { $installedTranslations = wp_get_installed_translations($this->translationType . 's'); if ( isset($installedTranslations[$this->directoryName]) ) { $installedTranslations = $installedTranslations[$this->directoryName]; } else { $installedTranslations = array(); } return $installedTranslations; } public function injectTranslationUpdates($updates) { $translationUpdates = $this->getTranslationUpdates(); if ( empty($translationUpdates) ) { return $updates; } if ( !is_object($updates) ) { $updates = new stdClass(); } if ( !isset($updates->translations) ) { $updates->translations = array(); } $updates->translations = array_values(array_filter( $updates->translations, array($this, 'isNotMyTranslation') )); foreach($translationUpdates as $update) { $convertedUpdate = array_merge( array( 'type' => $this->translationType, 'slug' => $this->directoryName, 'autoupdate' => 0, 'version' => isset($update->version) ? $update->version : ('1.' . strtotime($update->updated)), ), (array)$update ); $updates->translations[] = $convertedUpdate; } return $updates; } public function getTranslationUpdates() { return $this->updateState->getTranslations(); } public function clearCachedTranslationUpdates() { $this->updateState->setTranslations(array()); } protected function isNotMyTranslation($translation) { $isMatch = isset($translation['type'], $translation['slug']) && ($translation['type'] === $this->translationType) && ($translation['slug'] === $this->directoryName); return !$isMatch; } public function fixDirectoryName($source, $remoteSource, $upgrader) { global $wp_filesystem; if ( !isset($source, $remoteSource, $upgrader, $upgrader->skin, $wp_filesystem) ) { return $source; } if ( !$this->isBeingUpgraded($upgrader) ) { return $source; } $correctedSource = trailingslashit($remoteSource) . $this->directoryName . '/'; if ( $source !== $correctedSource ) { if ( $this->isBadDirectoryStructure($remoteSource) ) { return new WP_Error( 'puc-incorrect-directory-structure', sprintf( 'The directory structure of the update is incorrect. All files should be inside ' . 'a directory named <span class="code">%s</span>, not at the root of the ZIP archive.', htmlentities($this->slug) ) ); } $upgrader->skin->feedback(sprintf( 'Renaming %s to %s&#8230;', '<span class="code">' . basename($source) . '</span>', '<span class="code">' . $this->directoryName . '</span>' )); if ( $wp_filesystem->move($source, $correctedSource, true) ) { $upgrader->skin->feedback('Directory successfully renamed.'); return $correctedSource; } else { return new WP_Error( 'puc-rename-failed', 'Unable to rename the update to match the existing directory.' ); } } return $source; } abstract public function isBeingUpgraded($upgrader = null); protected function isBadDirectoryStructure($remoteSource) { global $wp_filesystem; $sourceFiles = $wp_filesystem->dirlist($remoteSource); if ( is_array($sourceFiles) ) { $sourceFiles = array_keys($sourceFiles); $firstFilePath = trailingslashit($remoteSource) . $sourceFiles[0]; return (count($sourceFiles) > 1) || (!$wp_filesystem->is_dir($firstFilePath)); } return false; } public function getFileHeader($content) { $content = (string) $content; $content = substr($content, 0, 8192); $content = str_replace("\r", "\n", $content); $headers = $this->getHeaderNames(); $results = array(); foreach ($headers as $field => $name) { $success = preg_match('/^[ \t\/*#@]*' . preg_quote($name, '/') . ':(.*)$/mi', $content, $matches); if ( ($success === 1) && $matches[1] ) { $value = $matches[1]; if ( function_exists('_cleanup_header_comment') ) { $value = _cleanup_header_comment($value); } $results[$field] = $value; } else { $results[$field] = ''; } } return $results; } abstract protected function getHeaderNames(); public function maybeInitDebugBar() { } protected function createDebugBarExtension() { } public function onDisplayConfiguration($panel) { } } endif;

/* @source /utils/library/Puc/v4/Factory.php */
if ( !class_exists('Puc_v4_Factory', false) ): class Puc_v4_Factory { protected static $classVersions = array(); protected static $sorted = false; protected static $myMajorVersion = ''; protected static $latestCompatibleVersion = ''; public static function buildUpdateChecker($metadataUrl, $fullPath, $slug = '', $checkPeriod = 12, $optionName = '', $muPluginFile = '') { $fullPath = wp_normalize_path($fullPath); $id = null; $themeDirectory = self::getThemeDirectoryName($fullPath); if ( self::isPluginFile($fullPath) ) { $type = 'Plugin'; $id = $fullPath; } else if ( $themeDirectory !== null ) { $type = 'Theme'; $id = $themeDirectory; } else { throw new RuntimeException(sprintf( 'The update checker cannot determine if "%s" is a plugin or a theme. ' . 'This is a bug. Please contact the PUC developer.', htmlentities($fullPath) )); } $service = self::getVcsService($metadataUrl); $apiClass = null; if ( empty($service) ) { $checkerClass = $type . '_UpdateChecker'; } else { $checkerClass = 'Vcs_' . $type . 'UpdateChecker'; $apiClass = $service . 'Api'; } $checkerClass = self::getCompatibleClassVersion($checkerClass); if ( $checkerClass === null ) { trigger_error( sprintf( 'PUC %s does not support updates for %ss %s', htmlentities(self::$latestCompatibleVersion), strtolower($type), $service ? ('hosted on ' . htmlentities($service)) : 'using JSON metadata' ), E_USER_ERROR ); return null; } if ( !isset($apiClass) ) { return new $checkerClass($metadataUrl, $id, $slug, $checkPeriod, $optionName, $muPluginFile); } else { $apiClass = self::getCompatibleClassVersion($apiClass); if ( $apiClass === null ) { trigger_error(sprintf( 'PUC %s does not support %s', htmlentities(self::$latestCompatibleVersion), htmlentities($service) ), E_USER_ERROR); return null; } return new $checkerClass( new $apiClass($metadataUrl), $id, $slug, $checkPeriod, $optionName, $muPluginFile ); } } protected static function isPluginFile($absolutePath) { $pluginDir = wp_normalize_path(WP_PLUGIN_DIR); $muPluginDir = wp_normalize_path(WPMU_PLUGIN_DIR); if ( (strpos($absolutePath, $pluginDir) === 0) || (strpos($absolutePath, $muPluginDir) === 0) ) { return true; } if ( !is_file($absolutePath) ) { return false; } if ( function_exists('get_file_data') ) { $headers = get_file_data($absolutePath, array('Name' => 'Plugin Name'), 'plugin'); return !empty($headers['Name']); } return false; } protected static function getThemeDirectoryName($absolutePath) { if ( is_file($absolutePath) ) { $absolutePath = dirname($absolutePath); } if ( file_exists($absolutePath . '/style.css') ) { return basename($absolutePath); } return null; } private static function getVcsService($metadataUrl) { $service = null; $host = @parse_url($metadataUrl, PHP_URL_HOST); $path = @parse_url($metadataUrl, PHP_URL_PATH); $usernameRepoRegex = '@^/?([^/]+?)/([^/#?&]+?)/?$@'; if ( preg_match($usernameRepoRegex, $path) ) { $knownServices = array( 'github.com' => 'GitHub', 'bitbucket.org' => 'BitBucket', 'gitlab.com' => 'GitLab', ); if ( isset($knownServices[$host]) ) { $service = $knownServices[$host]; } } return $service; } protected static function getCompatibleClassVersion($class) { if ( isset(self::$classVersions[$class][self::$latestCompatibleVersion]) ) { return self::$classVersions[$class][self::$latestCompatibleVersion]; } return null; } public static function getLatestClassVersion($class) { if ( !self::$sorted ) { self::sortVersions(); } if ( isset(self::$classVersions[$class]) ) { return reset(self::$classVersions[$class]); } else { return null; } } protected static function sortVersions() { foreach ( self::$classVersions as $class => $versions ) { uksort($versions, array(__CLASS__, 'compareVersions')); self::$classVersions[$class] = $versions; } self::$sorted = true; } protected static function compareVersions($a, $b) { return -version_compare($a, $b); } public static function addVersion($generalClass, $versionedClass, $version) { if ( empty(self::$myMajorVersion) ) { $nameParts = explode('_', __CLASS__, 3); self::$myMajorVersion = substr(ltrim($nameParts[1], 'v'), 0, 1); } $components = explode('.', $version); if ( $components[0] === self::$myMajorVersion ) { if ( empty(self::$latestCompatibleVersion) || version_compare($version, self::$latestCompatibleVersion, '>') ) { self::$latestCompatibleVersion = $version; } } if ( !isset(self::$classVersions[$generalClass]) ) { self::$classVersions[$generalClass] = array(); } self::$classVersions[$generalClass][$version] = $versionedClass; self::$sorted = false; } } endif;

/* @source /utils/library/Puc/v4p2/Autoloader.php */
if ( !class_exists('Puc_v4p2_Autoloader', false) ): class Puc_v4p2_Autoloader { private $prefix = ''; private $rootDir = ''; private $libraryDir = ''; private $staticMap; public function __construct() { $this->rootDir = dirname(__FILE__) . '/'; $nameParts = explode('_', __CLASS__, 3); $this->prefix = $nameParts[0] . '_' . $nameParts[1] . '_'; $this->libraryDir = realpath($this->rootDir . '../..') . '/'; $this->staticMap = array( 'PucReadmeParser' => 'vendor/readme-parser.php', 'Parsedown' => 'vendor/ParsedownLegacy.php', ); if ( version_compare(PHP_VERSION, '5.3.0', '>=') ) { $this->staticMap['Parsedown'] = 'vendor/Parsedown.php'; } spl_autoload_register(array($this, 'autoload')); } public function autoload($className) { if ( isset($this->staticMap[$className]) && file_exists($this->libraryDir . $this->staticMap[$className]) ) { include ($this->libraryDir . $this->staticMap[$className]); return; } if (strpos($className, $this->prefix) === 0) { $path = substr($className, strlen($this->prefix)); $path = str_replace('_', '/', $path); $path = $this->rootDir . $path . '.php'; if (file_exists($path)) { include $path; } } } } endif;

/* @source /utils/library/Puc/v4p2/UpgraderStatus.php */
if ( !class_exists('Puc_v4p2_UpgraderStatus', false) ): class Puc_v4p2_UpgraderStatus { private $currentType = null; private $currentId = null; public function __construct() { add_filter('upgrader_pre_install', array($this, 'setUpgradedThing'), 10, 2); add_filter('upgrader_package_options', array($this, 'setUpgradedPluginFromOptions'), 10, 1); add_filter('upgrader_post_install', array($this, 'clearUpgradedThing'), 10, 1); add_action('upgrader_process_complete', array($this, 'clearUpgradedThing'), 10, 1); } public function isPluginBeingUpgraded($pluginFile, $upgrader = null) { return $this->isBeingUpgraded('plugin', $pluginFile, $upgrader); } public function isThemeBeingUpgraded($stylesheet, $upgrader = null) { return $this->isBeingUpgraded('theme', $stylesheet, $upgrader); } protected function isBeingUpgraded($type, $id, $upgrader = null) { if ( isset($upgrader) ) { list($currentType, $currentId) = $this->getThingBeingUpgradedBy($upgrader); if ( $currentType !== null ) { $this->currentType = $currentType; $this->currentId = $currentId; } } return ($this->currentType === $type) && ($this->currentId === $id); } private function getThingBeingUpgradedBy($upgrader) { if ( !isset($upgrader, $upgrader->skin) ) { return array(null, null); } $pluginFile = null; $themeDirectoryName = null; $skin = $upgrader->skin; if ( isset($skin->theme_info) && ($skin->theme_info instanceof WP_Theme) ) { $themeDirectoryName = $skin->theme_info->get_stylesheet(); } elseif ( $skin instanceof Plugin_Upgrader_Skin ) { if ( isset($skin->plugin) && is_string($skin->plugin) && ($skin->plugin !== '') ) { $pluginFile = $skin->plugin; } } elseif ( $skin instanceof Theme_Upgrader_Skin ) { if ( isset($skin->theme) && is_string($skin->theme) && ($skin->theme !== '') ) { $themeDirectoryName = $skin->theme; } } elseif ( isset($skin->plugin_info) && is_array($skin->plugin_info) ) { $pluginFile = $this->identifyPluginByHeaders($skin->plugin_info); } if ( $pluginFile !== null ) { return array('plugin', $pluginFile); } elseif ( $themeDirectoryName !== null ) { return array('theme', $themeDirectoryName); } return array(null, null); } private function identifyPluginByHeaders($searchHeaders) { if ( !function_exists('get_plugins') ){ require_once( ABSPATH . '/wp-admin/includes/plugin.php' ); } $installedPlugins = get_plugins(); $matches = array(); foreach($installedPlugins as $pluginBasename => $headers) { $diff1 = array_diff_assoc($headers, $searchHeaders); $diff2 = array_diff_assoc($searchHeaders, $headers); if ( empty($diff1) && empty($diff2) ) { $matches[] = $pluginBasename; } } if ( count($matches) !== 1 ) { return null; } return reset($matches); } public function setUpgradedThing($input, $hookExtra) { if ( !empty($hookExtra['plugin']) && is_string($hookExtra['plugin']) ) { $this->currentId = $hookExtra['plugin']; $this->currentType = 'plugin'; } elseif ( !empty($hookExtra['theme']) && is_string($hookExtra['theme']) ) { $this->currentId = $hookExtra['theme']; $this->currentType = 'theme'; } else { $this->currentType = null; $this->currentId = null; } return $input; } public function setUpgradedPluginFromOptions($options) { if ( isset($options['hook_extra']['plugin']) && is_string($options['hook_extra']['plugin']) ) { $this->currentType = 'plugin'; $this->currentId = $options['hook_extra']['plugin']; } else { $this->currentType = null; $this->currentId = null; } return $options; } public function clearUpgradedThing($input = null) { $this->currentId = null; $this->currentType = null; return $input; } } endif;

/* @source /utils/library/Puc/v4p2/Plugin/Update.php */
if ( !class_exists('Puc_v4p2_Plugin_Update', false) ): class Puc_v4p2_Plugin_Update extends Puc_v4p2_Update { public $id = 0; public $homepage; public $upgrade_notice; public $tested; public $filename; protected static $extraFields = array( 'id', 'homepage', 'tested', 'upgrade_notice', 'filename', ); public static function fromJson($json){ $pluginInfo = Puc_v4p2_Plugin_Info::fromJson($json); if ( $pluginInfo !== null ) { return self::fromPluginInfo($pluginInfo); } else { return null; } } public static function fromPluginInfo($info){ return self::fromObject($info); } public static function fromObject($object) { $update = new self(); $update->copyFields($object, $update); return $update; } protected function getFieldNames() { return array_merge(parent::getFieldNames(), self::$extraFields); } public function toWpFormat(){ $update = parent::toWpFormat(); $update->id = $this->id; $update->url = $this->homepage; $update->tested = $this->tested; $update->plugin = $this->filename; if ( !empty($this->upgrade_notice) ){ $update->upgrade_notice = $this->upgrade_notice; } return $update; } } endif;

/* @source /utils/library/Puc/v4p2/Plugin/UpdateChecker.php */
if ( !class_exists('Puc_v4p2_Plugin_UpdateChecker', false) ): class Puc_v4p2_Plugin_UpdateChecker extends Puc_v4p2_UpdateChecker { protected $updateTransient = 'update_plugins'; protected $translationType = 'plugin'; public $pluginAbsolutePath = ''; public $pluginFile = ''; public $muPluginFile = ''; private $cachedInstalledVersion = null; public function __construct($metadataUrl, $pluginFile, $slug = '', $checkPeriod = 12, $optionName = '', $muPluginFile = ''){ $this->pluginAbsolutePath = $pluginFile; $this->pluginFile = plugin_basename($this->pluginAbsolutePath); $this->muPluginFile = $muPluginFile; if ( empty($slug) ){ $slug = basename($this->pluginFile, '.php'); } $slugCheckFilter = 'puc_is_slug_in_use-' . $this->slug; $slugUsedBy = apply_filters($slugCheckFilter, false); if ( $slugUsedBy ) { $this->triggerError(sprintf( 'Plugin slug "%s" is already in use by %s. Slugs must be unique.', htmlentities($this->slug), htmlentities($slugUsedBy) ), E_USER_ERROR); } add_filter($slugCheckFilter, array($this, 'getAbsolutePath')); if ( (strpbrk($this->pluginFile, '/\\') === false) && $this->isUnknownMuPlugin() ) { $this->muPluginFile = $this->pluginFile; } parent::__construct($metadataUrl, dirname($this->pluginFile), $slug, $checkPeriod, $optionName); } protected function createScheduler($checkPeriod) { $scheduler = new Puc_v4p2_Scheduler($this, $checkPeriod, array('load-plugins.php')); register_deactivation_hook($this->pluginFile, array($scheduler, 'removeUpdaterCron')); return $scheduler; } protected function installHooks(){ add_filter('plugins_api', array($this, 'injectInfo'), 20, 3); add_filter('plugin_row_meta', array($this, 'addCheckForUpdatesLink'), 10, 2); add_action('admin_init', array($this, 'handleManualCheck')); add_action('all_admin_notices', array($this, 'displayManualCheckResult')); add_filter('upgrader_post_install', array($this, 'clearCachedVersion')); add_action('delete_site_transient_update_plugins', array($this, 'clearCachedVersion')); parent::installHooks(); } public function requestInfo($queryArgs = array()) { list($pluginInfo, $result) = $this->requestMetadata('Puc_v4p2_Plugin_Info', 'request_info', $queryArgs); if ( $pluginInfo !== null ) { $pluginInfo->filename = $this->pluginFile; $pluginInfo->slug = $this->slug; } $pluginInfo = apply_filters($this->getUniqueName('request_info_result'), $pluginInfo, $result); return $pluginInfo; } public function requestUpdate() { $pluginInfo = $this->requestInfo(array('checking_for_updates' => '1')); if ( $pluginInfo === null ){ return null; } $update = Puc_v4p2_Plugin_Update::fromPluginInfo($pluginInfo); $update = $this->filterUpdateResult($update); return $update; } public function getInstalledVersion(){ if ( isset($this->cachedInstalledVersion) ) { return $this->cachedInstalledVersion; } $pluginHeader = $this->getPluginHeader(); if ( isset($pluginHeader['Version']) ) { $this->cachedInstalledVersion = $pluginHeader['Version']; return $pluginHeader['Version']; } else { $this->triggerError( sprintf( "Can't to read the Version header for '%s'. The filename is incorrect or is not a plugin.", $this->pluginFile ), E_USER_WARNING ); return null; } } protected function getPluginHeader() { if ( !is_file($this->pluginAbsolutePath) ) { $this->triggerError( sprintf( "Can't to read the plugin header for '%s'. The file does not exist.", $this->pluginFile ), E_USER_WARNING ); return array(); } if ( !function_exists('get_plugin_data') ){ require_once( ABSPATH . '/wp-admin/includes/plugin.php' ); } return get_plugin_data($this->pluginAbsolutePath, false, false); } protected function getHeaderNames() { return array( 'Name' => 'Plugin Name', 'PluginURI' => 'Plugin URI', 'Version' => 'Version', 'Description' => 'Description', 'Author' => 'Author', 'AuthorURI' => 'Author URI', 'TextDomain' => 'Text Domain', 'DomainPath' => 'Domain Path', 'Network' => 'Network', 'Tested WP' => 'Tested WP', 'Requires WP' => 'Requires WP', 'Tested up to' => 'Tested up to', 'Requires at least' => 'Requires at least', ); } public function injectInfo($result, $action = null, $args = null){ $relevant = ($action == 'plugin_information') && isset($args->slug) && ( ($args->slug == $this->slug) || ($args->slug == dirname($this->pluginFile)) ); if ( !$relevant ) { return $result; } $pluginInfo = $this->requestInfo(); $pluginInfo = apply_filters($this->getUniqueName('pre_inject_info'), $pluginInfo); if ( $pluginInfo ) { return $pluginInfo->toWpFormat(); } return $result; } protected function shouldShowUpdates() { return !$this->isUnknownMuPlugin(); } protected function addUpdateToList($updates, $updateToAdd) { if ( $this->isMuPlugin() ) { $updateToAdd->package = null; } return parent::addUpdateToList($updates, $updateToAdd); } protected function removeUpdateFromList($updates) { $updates = parent::removeUpdateFromList($updates); if ( !empty($this->muPluginFile) && isset($updates, $updates->response) ) { unset($updates->response[$this->muPluginFile]); } return $updates; } protected function getUpdateListKey() { if ( $this->isMuPlugin() ) { return $this->muPluginFile; } return $this->pluginFile; } public function isPluginBeingUpgraded($upgrader = null) { return $this->isBeingUpgraded($upgrader); } public function isBeingUpgraded($upgrader = null) { return $this->upgraderStatus->isPluginBeingUpgraded($this->pluginFile, $upgrader); } public function getUpdate() { $update = parent::getUpdate(); if ( isset($update) ) { $update->filename = $this->pluginFile; } return $update; } public function addCheckForUpdatesLink($pluginMeta, $pluginFile) { $isRelevant = ($pluginFile == $this->pluginFile) || (!empty($this->muPluginFile) && $pluginFile == $this->muPluginFile); if ( $isRelevant && $this->userCanInstallUpdates() ) { $linkUrl = wp_nonce_url( add_query_arg( array( 'puc_check_for_updates' => 1, 'puc_slug' => $this->slug, ), self_admin_url('plugins.php') ), 'puc_check_for_updates' ); $linkText = apply_filters( $this->getUniqueName('manual_check_link'), __('Check for updates', 'plugin-update-checker') ); if ( !empty($linkText) ) { $pluginMeta[] = sprintf('<a href="%s">%s</a>', esc_attr($linkUrl), $linkText); } } return $pluginMeta; } public function handleManualCheck() { $shouldCheck = isset($_GET['puc_check_for_updates'], $_GET['puc_slug']) && $_GET['puc_slug'] == $this->slug && $this->userCanInstallUpdates() && check_admin_referer('puc_check_for_updates'); if ( $shouldCheck ) { $update = $this->checkForUpdates(); $status = ($update === null) ? 'no_update' : 'update_available'; wp_redirect(add_query_arg( array( 'puc_update_check_result' => $status, 'puc_slug' => $this->slug, ), self_admin_url('plugins.php') )); } } public function displayManualCheckResult() { if ( isset($_GET['puc_update_check_result'], $_GET['puc_slug']) && ($_GET['puc_slug'] == $this->slug) ) { $status = strval($_GET['puc_update_check_result']); $title = $this->getPluginTitle(); if ( $status == 'no_update' ) { $message = sprintf(_x('The %s plugin is up to date.', 'the plugin title', 'plugin-update-checker'), $title); } else if ( $status == 'update_available' ) { $message = sprintf(_x('A new version of the %s plugin is available.', 'the plugin title', 'plugin-update-checker'), $title); } else { $message = sprintf(__('Unknown update checker status "%s"', 'plugin-update-checker'), htmlentities($status)); } printf( '<div class="updated notice is-dismissible"><p>%s</p></div>', apply_filters($this->getUniqueName('manual_check_message'), $message, $status) ); } } protected function getPluginTitle() { $title = ''; $header = $this->getPluginHeader(); if ( $header && !empty($header['Name']) && isset($header['TextDomain']) ) { $title = translate($header['Name'], $header['TextDomain']); } return $title; } public function userCanInstallUpdates() { return current_user_can('update_plugins'); } protected function isMuPlugin() { static $cachedResult = null; if ( $cachedResult === null ) { if ( !defined('WPMU_PLUGIN_DIR') || !is_string(WPMU_PLUGIN_DIR) ) { $cachedResult = false; return $cachedResult; } $muPluginDir = realpath(WPMU_PLUGIN_DIR); $pluginPath = realpath($this->pluginAbsolutePath); if (($muPluginDir === false) || ($pluginPath === false)) { $muPluginDir = self::normalizePath(WPMU_PLUGIN_DIR); $pluginPath  = self::normalizePath($this->pluginAbsolutePath); } $cachedResult = (strpos($pluginPath, $muPluginDir) === 0); } return $cachedResult; } public static function normalizePath($path) { if ( function_exists('wp_normalize_path') ) { return wp_normalize_path($path); } $path = str_replace('\\', '/', $path); $path = preg_replace('|(?<=.)/+|', '/', $path); if ( substr($path, 1, 1) === ':' ) { $path = ucfirst($path); } return $path; } protected function isUnknownMuPlugin() { return empty($this->muPluginFile) && $this->isMuPlugin(); } public function clearCachedVersion($filterArgument = null) { $this->cachedInstalledVersion = null; return $filterArgument; } public function getAbsolutePath() { return $this->pluginAbsolutePath; } public function addQueryArgFilter($callback){ $this->addFilter('request_info_query_args', $callback); } public function addHttpRequestArgFilter($callback) { $this->addFilter('request_info_options', $callback); } public function addResultFilter($callback) { $this->addFilter('request_info_result', $callback, 10, 2); } protected function createDebugBarExtension() { } } endif;

/* @source /utils/library/Puc/v4p2/Plugin/Info.php */
if ( !class_exists('Puc_v4p2_Plugin_Info', false) ): class Puc_v4p2_Plugin_Info extends Puc_v4p2_Metadata { public $name; public $slug; public $version; public $homepage; public $sections = array(); public $banners; public $translations = array(); public $download_url; public $author; public $author_homepage; public $requires; public $tested; public $upgrade_notice; public $rating; public $num_ratings; public $downloaded; public $active_installs; public $last_updated; public $id = 0; public $filename; public static function fromJson($json){ $instance = new self(); if ( !parent::createFromJson($json, $instance) ) { return null; } $instance->sections = (array)$instance->sections; return $instance; } protected function validateMetadata($apiResponse) { if ( !isset($apiResponse->name, $apiResponse->version) || empty($apiResponse->name) || empty($apiResponse->version) ) { return new WP_Error( 'puc-invalid-metadata', "The plugin metadata file does not contain the required 'name' and/or 'version' keys." ); } return true; } public function toWpFormat(){ $info = new stdClass; $sameFormat = array( 'name', 'slug', 'version', 'requires', 'tested', 'rating', 'upgrade_notice', 'num_ratings', 'downloaded', 'active_installs', 'homepage', 'last_updated', ); foreach($sameFormat as $field){ if ( isset($this->$field) ) { $info->$field = $this->$field; } else { $info->$field = null; } } $info->download_link = $this->download_url; $info->author = $this->getFormattedAuthor(); $info->sections = array_merge(array('description' => ''), $this->sections); if ( !empty($this->banners) ) { $info->banners = is_object($this->banners) ? get_object_vars($this->banners) : $this->banners; $info->banners = array_intersect_key($info->banners, array('high' => true, 'low' => true)); } return $info; } protected function getFormattedAuthor() { if ( !empty($this->author_homepage) ){ return sprintf('<a href="%s">%s</a>', $this->author_homepage, $this->author); } return $this->author; } } endif;

/* @source /utils/library/Puc/v4p2/Scheduler.php */
if ( !class_exists('Puc_v4p2_Scheduler', false) ): class Puc_v4p2_Scheduler { public $checkPeriod = 12; public $throttleRedundantChecks = false; public $throttledCheckPeriod = 72; protected $hourlyCheckHooks = array('load-update.php'); protected $updateChecker; private $cronHook = null; public function __construct($updateChecker, $checkPeriod, $hourlyHooks = array('load-plugins.php')) { $this->updateChecker = $updateChecker; $this->checkPeriod = $checkPeriod; $this->cronHook = $this->updateChecker->getUniqueName('cron_check_updates'); if ( $this->checkPeriod > 0 ){ $defaultSchedules = array( 1 => 'hourly', 12 => 'twicedaily', 24 => 'daily', ); if ( array_key_exists($this->checkPeriod, $defaultSchedules) ) { $scheduleName = $defaultSchedules[$this->checkPeriod]; } else { $scheduleName = 'every' . $this->checkPeriod . 'hours'; add_filter('cron_schedules', array($this, '_addCustomSchedule')); } if ( !wp_next_scheduled($this->cronHook) && !defined('WP_INSTALLING') ) { wp_schedule_event(time(), $scheduleName, $this->cronHook); } add_action($this->cronHook, array($this, 'maybeCheckForUpdates')); add_action( 'admin_init', array($this, 'maybeCheckForUpdates') ); add_action('load-update-core.php', array($this, 'maybeCheckForUpdates')); $this->hourlyCheckHooks = array_merge($this->hourlyCheckHooks, $hourlyHooks); foreach($this->hourlyCheckHooks as $hook) { add_action($hook, array($this, 'maybeCheckForUpdates')); } add_action('upgrader_process_complete', array($this, 'maybeCheckForUpdates'), 11, 0); } else { wp_clear_scheduled_hook($this->cronHook); } } public function maybeCheckForUpdates(){ if ( empty($this->checkPeriod) ){ return; } $state = $this->updateChecker->getUpdateState(); $shouldCheck = ($state->timeSinceLastCheck() >= $this->getEffectiveCheckPeriod()); $shouldCheck = apply_filters( $this->updateChecker->getUniqueName('check_now'), $shouldCheck, $state->getLastCheck(), $this->checkPeriod ); if ( $shouldCheck ) { $this->updateChecker->checkForUpdates(); } } protected function getEffectiveCheckPeriod() { $currentFilter = current_filter(); if ( in_array($currentFilter, array('load-update-core.php', 'upgrader_process_complete')) ) { $period = 60; } else if ( in_array($currentFilter, $this->hourlyCheckHooks) ) { $period = 3600; } else if ( $this->throttleRedundantChecks && ($this->updateChecker->getUpdate() !== null) ) { $period = $this->throttledCheckPeriod * 3600; } else if ( defined('DOING_CRON') && constant('DOING_CRON') ) { $cronFuzziness = 20 * 60; $period = $this->checkPeriod * 3600 - $cronFuzziness; } else { $period = $this->checkPeriod * 3600; } return $period; } public function _addCustomSchedule($schedules){ if ( $this->checkPeriod && ($this->checkPeriod > 0) ){ $scheduleName = 'every' . $this->checkPeriod . 'hours'; $schedules[$scheduleName] = array( 'interval' => $this->checkPeriod * 3600, 'display' => sprintf('Every %d hours', $this->checkPeriod), ); } return $schedules; } public function removeUpdaterCron(){ wp_clear_scheduled_hook($this->cronHook); } public function getCronHookName() { return $this->cronHook; } } endif;

/* @source /utils/library/Puc/v4p2/Utils.php */
if ( !class_exists('Puc_v4p2_Utils', false) ): class Puc_v4p2_Utils { public static function get($collection, $path, $default = null, $separator = '.') { if ( is_string($path) ) { $path = explode($separator, $path); } $currentValue = $collection; foreach ($path as $node) { if ( is_array($currentValue) && isset($currentValue[$node]) ) { $currentValue = $currentValue[$node]; } else if ( is_object($currentValue) && isset($currentValue->$node) ) { $currentValue = $currentValue->$node; } else { return $default; } } return $currentValue; } public static function findNotEmpty($values, $default = null) { if ( empty($values) ) { return $default; } foreach ($values as $value) { if ( !empty($value) ) { return $value; } } return $default; } public static function startsWith($input, $prefix) { $length = strlen($prefix); return (substr($input, 0, $length) === $prefix); } } endif;

/* @source /utils/library/Puc/v4p2/StateStore.php */
if ( !class_exists('Puc_v4p2_StateStore', false) ): class Puc_v4p2_StateStore { protected $lastCheck = 0; protected $checkedVersion = ''; protected $update = null; private $optionName = ''; private $isLoaded = false; public function __construct($optionName) { $this->optionName = $optionName; } public function timeSinceLastCheck() { $this->lazyLoad(); return time() - $this->lastCheck; } public function getLastCheck() { $this->lazyLoad(); return $this->lastCheck; } public function setLastCheckToNow() { $this->lazyLoad(); $this->lastCheck = time(); return $this; } public function getUpdate() { $this->lazyLoad(); return $this->update; } public function setUpdate(Puc_v4p2_Update $update = null) { $this->lazyLoad(); $this->update = $update; return $this; } public function getCheckedVersion() { $this->lazyLoad(); return $this->checkedVersion; } public function setCheckedVersion($version) { $this->lazyLoad(); $this->checkedVersion = strval($version); return $this; } public function getTranslations() { $this->lazyLoad(); if ( isset($this->update, $this->update->translations) ) { return $this->update->translations; } return array(); } public function setTranslations($translationUpdates) { $this->lazyLoad(); if ( isset($this->update) ) { $this->update->translations = $translationUpdates; $this->save(); } } public function save() { $state = new stdClass(); $state->lastCheck = $this->lastCheck; $state->checkedVersion = $this->checkedVersion; if ( isset($this->update)) { $state->update = $this->update->toStdClass(); $updateClass = get_class($this->update); $state->updateClass = $updateClass; $prefix = $this->getLibPrefix(); if ( Puc_v4p2_Utils::startsWith($updateClass, $prefix) ) { $state->updateBaseClass = substr($updateClass, strlen($prefix)); } } update_site_option($this->optionName, $state); $this->isLoaded = true; } public function lazyLoad() { if ( !$this->isLoaded ) { $this->load(); } return $this; } protected function load() { $this->isLoaded = true; $state = get_site_option($this->optionName, null); if ( !is_object($state) ) { $this->lastCheck = 0; $this->checkedVersion = ''; $this->update = null; return; } $this->lastCheck = intval(Puc_v4p2_Utils::get($state, 'lastCheck', 0)); $this->checkedVersion = Puc_v4p2_Utils::get($state, 'checkedVersion', ''); $this->update = null; if ( isset($state->update) ) { $updateClass = null; if ( isset($state->updateBaseClass) ) { $updateClass = $this->getLibPrefix() . $state->updateBaseClass; } else if ( isset($state->updateClass) && class_exists($state->updateClass) ) { $updateClass = $state->updateClass; } if ( $updateClass !== null ) { $this->update = call_user_func(array($updateClass, 'fromObject'), $state->update); } } } public function delete() { delete_site_option($this->optionName); $this->lastCheck = 0; $this->checkedVersion = ''; $this->update = null; } private function getLibPrefix() { $parts = explode('_', __CLASS__, 3); return $parts[0] . '_' . $parts[1] . '_'; } } endif;

