jQuery(document).ready(function(){
    jQuery('.am4shortcode-c').shortcodemenu();
});
;(function($) {
$.fn.shortcodemenu = function(param) {
    return this.each(function(){
        var menu = {
            show: function() {
                jQuery(this).find('.am4shortcode-menu').css({opacity:1});
            },
            hide: function() {
                jQuery(this).find('.am4shortcode-menu').css({opacity:0});
            },
            open: function(e){
                e.preventDefault();
                jQuery('tr.am4shortcode-help').removeClass('expandable-expanded')
                jQuery('tr.am4shortcode-help').prev().removeClass('expandable-expanded');

                jQuery('.am4shortcode-more').not(this).text('more…');
                let target = jQuery(this).parents('tr').next('tr');
                jQuery('tr.am4shortcode-help').not(target).hide();

                let isVisible = target.is(':visible');
                jQuery(this).text(isVisible ? 'more…' : 'less');
                target.toggle(!isVisible);
                if (!isVisible) {
                    target.addClass('expandable-expanded');
                    target.prev().addClass('expandable-expanded');
                }
            },
            copy: function(e){
                e.preventDefault();
                var s = jQuery(this).closest('.am4shortcode-menu').prev().find('.am4shortcode');
                writeText(s.html());
            },
            insert: function(e){
                e.preventDefault();
                var s = jQuery(this).closest('.am4shortcode-menu').prev().find('.am4shortcode');
                menu.send_to_editor(s.html());
            },
            send_to_editor: function(text){
                var ed;
                var win = window.dialogArguments || opener || parent || top;
                var reg = /(.*)(\[\/\w+\])$/;
                var close_tag = text.match(reg);

                if ( typeof win.tinyMCE != 'undefined' && ( ed = win.tinyMCE.activeEditor ) && !ed.isHidden() ) {
                    // restore caret position on IE
                    if (ed.selection && (content = ed.selection.getContent())&&close_tag){
                        ed.selection.setContent(close_tag[1]+content+close_tag[2]);
                    } else {
                        ed.execCommand('mceInsertContent', false, text);
                    }
                } else if ( typeof edInsertContent == 'function' ) {
                    edInsertContent(edCanvas, text);
                } else {
                    jQuery( edCanvas ).val( jQuery( edCanvas ).val() + text );
                }
            }
        };

        jQuery(this).closest('tr').hover(menu.show, menu.hide);
        let s = jQuery(this);
        let d = jQuery("<div class='am4shortcode-menu'></div>");
        s.after(d);
        let ins = jQuery("<a href='#' title='Insert Shortcode into Editor'>Insert</a>");
        let copy = jQuery("<a href='#' title='Copy Shortcode to Clicpboard'>Copy</a>");
        let open = jQuery("<a href='#' title='Open Help' class='am4shortcode-more'>more&hellip;</a>");
        d.append(ins, ' <span style="color:#ddd">|</span> ', copy);
        if(s.find('.am4shortcode').hasClass("expandable")){
            d.append(' <span style="color:#ddd">|</span> ', open);
            open.click(menu.open);
        }
        ins.click(menu.insert);
        copy.click(menu.copy);
    });
}
})(jQuery);

// A minimal polyfill for `navigator.clipboard.writeText()` that works most of the time in most modern browsers.
// Note that on Edge this may call `resolve()` even if copying failed.
// See https://github.com/lgarron/clipboard-polyfill for a more robust solution.
// License: public domain
function writeText(str) {
    return new Promise(function(resolve, reject) {
        var success = false;
        function listener(e) {
            e.clipboardData.setData("text/plain", str);
            e.preventDefault();
            success = true;
        }
        document.addEventListener("copy", listener);
        document.execCommand("copy");
        document.removeEventListener("copy", listener);
        success ? resolve(): reject();
    });
};