<?php

abstract class Am_Report_Absignup extends Am_Report_Date
{
    public function getPointField()
    {
        return 'i.tm_started';
    }

    function getCampaign()
    {
        $vars = $this->form->getValue();
        return $this->getDi()->absignupCampaignTable->load($vars['campaign_id']);
    }

    function getLines()
    {
        $ret = [];
        foreach ($this->getFormOptions() as $k => $title) {
            $ret[] = new Am_Report_Line('form_' . $k, $title);
        }
        return $ret;
    }
}

class Am_Report_Absignup_Signup extends Am_Report_Absignup
{
    public function __construct()
    {
        $this->title = ___('A/B Signup Form');
        $this->description = ___('count of paid invoices by signup form');
    }

    public function _initConfigForm(Am_Form $form)
    {
        parent::_initConfigForm($form);
        $form->addSelect('campaign_id')->setLabel(___("Campaign"))
            ->loadOptions($this->getDi()->absignupCampaignTable->getOptions([Bootstrap_AbSignup::CAMPAIGN_SAVEDFORM, Bootstrap_AbSignup::CAMPAIGN_SAVEDFORM_CUSTOM]));
    }

    /** @return Am_Query */
    public function getQuery()
    {
        $campaign = $this->getCampaign();

        $q = new Am_Query($this->getDi()->invoiceTable, 'i');
        $q->clearFields();
        $q->addField('COUNT(invoice_id)', 'cnt')
            ->addWhere('tm_started IS NOT NULL')
            ->addWhere('campaign_id=?', $campaign->pk());

        foreach ($this->getFormOptions() as $k => $title)
            $q->addField("COUNT(IF(i.saved_form_id = $k, 1, NULL))", 'form_' . $k);

        return $q;
    }

    function getFormOptions()
    {
        $res = [];
        $options = $this->getDi()->savedFormTable->getOptions();

        $campaign = $this->getCampaign();
        foreach ($campaign->getRoster() as $form_id) {
            $res[$form_id] = $options[$form_id];
        }
        return $res;
    }
}

abstract class Am_Report_Absignup_Theme extends Am_Report_Absignup
{
    public function getPointField()
    {
        return 'i.tm_added';
    }

    public function _initConfigForm(Am_Form $form)
    {
        parent::_initConfigForm($form);
        $form->addSelect('campaign_id')->setLabel(___("Campaign"))
            ->loadOptions($this->getDi()->absignupCampaignTable->getOptions(Bootstrap_AbSignup::CAMPAIGN_THEME));
    }

    /** @return Am_Query */
    public function getQuery()
    {
        $campaign = $this->getCampaign();

        $q = new Am_Query($this->getDi()->invoiceTable, 'i');
        $q->clearFields();
        $q->addField('COUNT(invoice_id)', 'cnt')
            ->addWhere('campaign_id=?', $campaign->pk());

        foreach ($campaign->getRoster() as $v)
            $q->addField("COUNT(IF(i.theme = '$v', 1, NULL))", 'form_' . $v);

        return $q;
    }

    function getFormOptions()
    {
        $res = [];
        $campaign = $this->getCampaign();
        foreach ($campaign->getRoster() as $theme) {
            $res[$theme] = $theme;
        }
        return $res;
    }
}

class Am_Report_Absignup_Theme_Visitors extends Am_Report_Absignup_Theme
{
    public function __construct()
    {
        $this->title = ___('A/B Signup Theme Visitors');
        $this->description = ___('count of all invoices by theme');
    }
}

class Am_Report_Absignup_Theme_Purchases extends Am_Report_Absignup_Theme
{
    public function __construct()
    {
        $this->title = ___('A/B Signup Theme Purchases');
        $this->description = ___('count of paid invoices by theme');
    }

    /** @return Am_Query */
    public function getQuery()
    {
        $q = parent::getQuery();
        $q->addWhere('tm_started IS NOT NULL');
        return $q;
    }
}

class Am_Report_Absignup_Theme_Pending extends Am_Report_Absignup_Theme
{
    public function __construct()
    {
        $this->title = ___('A/B Signup Theme Pending');
        $this->description = ___('count of non invoices by theme');
    }

    /** @return Am_Query */
    public function getQuery()
    {
        $q = parent::getQuery();
        $q->addWhere('tm_started IS NULL');
        return $q;
    }
}