<?php
/**
 * Zend Framework
 *
 * LICENSE
 *
 * This source file is subject to the new BSD license that is bundled
 * with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://framework.zend.com/license/new-bsd
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@zend.com so we can send you a copy immediately.
 *
 * @copyright  Copyright (c) 2005-2011 Zend Technologies USA Inc. (http://www.zend.com)
 * @license    http://framework.zend.com/license/new-bsd     New BSD License
 */


/* @source /library/Zend/Pdf/Filter/Interface.php */
interface Zend_Pdf_Filter_Interface { public static function encode($data, $params = null); public static function decode($data, $params = null); }

/* @source /library/Zend/Pdf/Canvas/Interface.php */
interface Zend_Pdf_Canvas_Interface { public function getResources(); public function getContents(); public function getHeight(); public function getWidth(); public function drawCanvas(Zend_Pdf_Canvas_Interface $canvas, $x1, $y1, $x2 = null, $y2 = null); public function setFillColor(Zend_Pdf_Color $color); public function setLineColor(Zend_Pdf_Color $color); public function setLineWidth($width); public function setLineDashingPattern($pattern, $phase = 0); public function setFont(Zend_Pdf_Resource_Font $font, $fontSize); public function setStyle(Zend_Pdf_Style $style); public function getFont(); public function getFontSize(); public function getStyle(); public function saveGS(); public function setAlpha($alpha, $mode = 'Normal'); public function clipCircle($x, $y, $radius, $startAngle = null, $endAngle = null); public function clipEllipse($x1, $y1, $x2, $y2, $startAngle = null, $endAngle = null); public function clipPolygon($x, $y, $fillMethod = Zend_Pdf_Page::FILL_METHOD_NON_ZERO_WINDING); public function clipRectangle($x1, $y1, $x2, $y2); public function drawCircle($x, $y, $radius, $param4 = null, $param5 = null, $param6 = null); public function drawEllipse($x1, $y1, $x2, $y2, $param5 = null, $param6 = null, $param7 = null); public function drawImage(Zend_Pdf_Resource_Image $image, $x1, $y1, $x2, $y2); public function drawLayoutBox($box, $x, $y); public function drawLine($x1, $y1, $x2, $y2); public function drawPolygon($x, $y, $fillType = Zend_Pdf_Page::SHAPE_DRAW_FILL_AND_STROKE, $fillMethod = Zend_Pdf_Page::FILL_METHOD_NON_ZERO_WINDING); public function drawRectangle($x1, $y1, $x2, $y2, $fillType = Zend_Pdf_Page::SHAPE_DRAW_FILL_AND_STROKE); public function drawRoundedRectangle($x1, $y1, $x2, $y2, $radius, $fillType = Zend_Pdf_Page::SHAPE_DRAW_FILL_AND_STROKE); public function drawText($text, $x, $y, $charEncoding = ''); public function pathClose(); public function pathLine($x, $y); public function pathMove($x, $y); public function rotate($x, $y, $angle); public function scale($xScale, $yScale); public function translate($xShift, $yShift); public function skew($x, $y, $xAngle, $yAngle); public function rawWrite($data, $procSet = null); }

/* @source /library/Zend/Pdf/ElementFactory/Interface.php */
interface Zend_Pdf_ElementFactory_Interface { public function getFactory(); public function close(); public function resolve(); public function getId(); public function setObjectCount($objCount); public function getObjectCount(); public function attach(Zend_Pdf_ElementFactory_Interface $factory); public function calculateShift(Zend_Pdf_ElementFactory_Interface $factory); public function cleanEnumerationShiftCache(); public function getEnumerationShift(Zend_Pdf_ElementFactory_Interface $factory); public function markAsModified(Zend_Pdf_Element_Object $obj); public function remove(Zend_Pdf_Element_Object $obj); public function newObject(Zend_Pdf_Element $objectValue); public function newStreamObject($streamValue); public function listModifiedObjects($rootFactory = null); public function isModified(); }

/* @source /library/Zend/Pdf/Target.php */
abstract class Zend_Pdf_Target { public static function load(Zend_Pdf_Element $resource) { if ($resource->getType() == Zend_Pdf_Element::TYPE_DICTIONARY) { if (($resource->Type === null || $resource->Type->value =='Action') && $resource->S !== null) { return Zend_Pdf_Action::load($resource); } else if ($resource->D !== null) { $resource = $resource->D; } else { throw new Zend_Pdf_Exception('Wrong resource type.'); } } if ($resource->getType() == Zend_Pdf_Element::TYPE_ARRAY || $resource->getType() == Zend_Pdf_Element::TYPE_NAME || $resource->getType() == Zend_Pdf_Element::TYPE_STRING) { return Zend_Pdf_Destination::load($resource); } else { throw new Zend_Pdf_Exception( 'Wrong resource type.' ); } } abstract public function getResource(); }

/* @source /library/Zend/Pdf/FileParser.php */
abstract class Zend_Pdf_FileParser { const BYTE_ORDER_LITTLE_ENDIAN = 0; const BYTE_ORDER_BIG_ENDIAN = 1; protected $_isScreened = false; protected $_isParsed = false; protected $_dataSource = null; abstract public function screen(); abstract public function parse(); public function __construct(Zend_Pdf_FileParserDataSource $dataSource) { if ($dataSource->getSize() == 0) { throw new Zend_Pdf_Exception('The data source has not been properly initialized', Zend_Pdf_Exception::BAD_DATA_SOURCE); } $this->_dataSource = $dataSource; } public function __destruct() { $this->_dataSource = null; } public function isScreened() { return $this->_isScreened; } public function isParsed() { return $this->_isParsed; } public function getDataSource() { return $this->_dataSource; } public function moveToOffset($offset) { $this->_dataSource->moveToOffset($offset); } public function getOffset() { return $this->_dataSource->getOffset(); } public function getSize() { return $this->_dataSource->getSize(); } public function readBytes($byteCount) { return $this->_dataSource->readBytes($byteCount); } public function skipBytes($byteCount) { $this->_dataSource->skipBytes($byteCount); } public function readInt($size, $byteOrder = Zend_Pdf_FileParser::BYTE_ORDER_BIG_ENDIAN) { if (($size < 1) || ($size > 4)) { throw new Zend_Pdf_Exception("Invalid signed integer size: $size", Zend_Pdf_Exception::INVALID_INTEGER_SIZE); } $bytes = $this->_dataSource->readBytes($size); if ($byteOrder == Zend_Pdf_FileParser::BYTE_ORDER_BIG_ENDIAN) { $number = ord($bytes[0]); if (($number & 0x80) == 0x80) { $number = (~ $number) & 0xff; for ($i = 1; $i < $size; $i++) { $number = ($number << 8) | ((~ ord($bytes[$i])) & 0xff); } $number = ~$number; } else { for ($i = 1; $i < $size; $i++) { $number = ($number << 8) | ord($bytes[$i]); } } } else if ($byteOrder == Zend_Pdf_FileParser::BYTE_ORDER_LITTLE_ENDIAN) { $number = ord($bytes[$size - 1]); if (($number & 0x80) == 0x80) { $number = 0; for ($i = --$size; $i >= 0; $i--) { $number |= ((~ ord($bytes[$i])) & 0xff) << ($i * 8); } $number = ~$number; } else { $number = 0; for ($i = --$size; $i >= 0; $i--) { $number |= ord($bytes[$i]) << ($i * 8); } } } else { throw new Zend_Pdf_Exception("Invalid byte order: $byteOrder", Zend_Pdf_Exception::INVALID_BYTE_ORDER); } return $number; } public function readUInt($size, $byteOrder = Zend_Pdf_FileParser::BYTE_ORDER_BIG_ENDIAN) { if (($size < 1) || ($size > 4)) { throw new Zend_Pdf_Exception("Invalid unsigned integer size: $size", Zend_Pdf_Exception::INVALID_INTEGER_SIZE); } $bytes = $this->_dataSource->readBytes($size); if ($byteOrder == Zend_Pdf_FileParser::BYTE_ORDER_BIG_ENDIAN) { $number = ord($bytes[0]); for ($i = 1; $i < $size; $i++) { $number = ($number << 8) | ord($bytes[$i]); } } else if ($byteOrder == Zend_Pdf_FileParser::BYTE_ORDER_LITTLE_ENDIAN) { $number = 0; for ($i = --$size; $i >= 0; $i--) { $number |= ord($bytes[$i]) << ($i * 8); } } else { throw new Zend_Pdf_Exception("Invalid byte order: $byteOrder", Zend_Pdf_Exception::INVALID_BYTE_ORDER); } return $number; } public function isBitSet($bit, $bitField) { $bitMask = 1 << $bit; $isSet = (($bitField & $bitMask) == $bitMask); return $isSet; } public function readFixed($mantissaBits, $fractionBits, $byteOrder = Zend_Pdf_FileParser::BYTE_ORDER_BIG_ENDIAN) { $bitsToRead = $mantissaBits + $fractionBits; if (($bitsToRead % 8) !== 0) { throw new Zend_Pdf_Exception('Fixed-point numbers are whole bytes', Zend_Pdf_Exception::BAD_FIXED_POINT_SIZE); } $number = $this->readInt(($bitsToRead >> 3), $byteOrder) / (1 << $fractionBits); return $number; } public function readStringUTF16($byteCount, $byteOrder = Zend_Pdf_FileParser::BYTE_ORDER_BIG_ENDIAN, $characterSet = '') { if ($byteCount == 0) { return ''; } $bytes = $this->_dataSource->readBytes($byteCount); if ($byteOrder == Zend_Pdf_FileParser::BYTE_ORDER_BIG_ENDIAN) { if ($characterSet == 'UTF-16BE') { return $bytes; } return iconv('UTF-16BE', $characterSet, $bytes); } else if ($byteOrder == Zend_Pdf_FileParser::BYTE_ORDER_LITTLE_ENDIAN) { if ($characterSet == 'UTF-16LE') { return $bytes; } return iconv('UTF-16LE', $characterSet, $bytes); } else { throw new Zend_Pdf_Exception("Invalid byte order: $byteOrder", Zend_Pdf_Exception::INVALID_BYTE_ORDER); } } public function readStringMacRoman($byteCount, $characterSet = '') { if ($byteCount == 0) { return ''; } $bytes = $this->_dataSource->readBytes($byteCount); if ($characterSet == 'MacRoman') { return $bytes; } return iconv('MacRoman', $characterSet, $bytes); } public function readStringPascal($characterSet = '', $lengthBytes = 1) { $byteCount = $this->readUInt($lengthBytes); if ($byteCount == 0) { return ''; } $bytes = $this->_dataSource->readBytes($byteCount); if ($characterSet == 'ASCII') { return $bytes; } return iconv('ASCII', $characterSet, $bytes); } }

/* @source /library/Zend/Pdf/Resource.php */
abstract class Zend_Pdf_Resource { protected $_objectFactory; protected $_resource; public function __construct($resource) { if ($resource instanceof Zend_Pdf_Element_Object) { $this->_objectFactory = $resource->getFactory(); $this->_resource = $resource; return; } $this->_objectFactory = Zend_Pdf_ElementFactory::createFactory(1); if ($resource instanceof Zend_Pdf_Element) { $this->_resource = $this->_objectFactory->newObject($resource); } else { $this->_resource = $this->_objectFactory->newStreamObject($resource); } } public function __clone() { } public function cloneResource($factory, &$processed) { } public function getResource() { return $this->_resource; } public function getFactory() { return $this->_objectFactory; } }

/* @source /library/Zend/Pdf/Color.php */
abstract class Zend_Pdf_Color { abstract public function instructions($stroking); abstract public function getComponents(); }

/* @source /library/Zend/Pdf/Element.php */
abstract class Zend_Pdf_Element { const TYPE_BOOL = 1; const TYPE_NUMERIC = 2; const TYPE_STRING = 3; const TYPE_NAME = 4; const TYPE_ARRAY = 5; const TYPE_DICTIONARY = 6; const TYPE_STREAM = 7; const TYPE_NULL = 11; private $_parentObject = null; abstract public function getType(); abstract public function toString($factory = null); const CLONE_MODE_SKIP_PAGES = 1; const CLONE_MODE_FORCE_CLONING = 2; public function makeClone(Zend_Pdf_ElementFactory $factory, array &$processed, $mode) { return clone $this; } public function setParentObject(Zend_Pdf_Element_Object $parent) { $this->_parentObject = $parent; } public function getParentObject() { return $this->_parentObject; } public function touch() { if ($this->_parentObject !== null) { $this->_parentObject->touch(); } } public function cleanUp() { } public function toPhp() { return $this->value; } public static function phpToPdf($input) { if (is_numeric($input)) { return new Zend_Pdf_Element_Numeric($input); } else if (is_bool($input)) { return new Zend_Pdf_Element_Boolean($input); } else if (is_array($input)) { $pdfElementsArray = array(); $isDictionary = false; foreach ($input as $key => $value) { if (is_string($key)) { $isDictionary = true; } $pdfElementsArray[$key] = Zend_Pdf_Element::phpToPdf($value); } if ($isDictionary) { return new Zend_Pdf_Element_Dictionary($pdfElementsArray); } else { return new Zend_Pdf_Element_Array($pdfElementsArray); } } else { return new Zend_Pdf_Element_String((string)$input); } } }

/* @source /library/Zend/Pdf/Action.php */
abstract class Zend_Pdf_Action extends Zend_Pdf_Target implements RecursiveIterator, Countable { protected $_actionDictionary; protected $_originalNextList; public $next = array(); public function __construct(Zend_Pdf_Element $dictionary, SplObjectStorage $processedActions) { if ($dictionary->getType() != Zend_Pdf_Element::TYPE_DICTIONARY) { throw new Zend_Pdf_Exception('$dictionary mast be a direct or an indirect dictionary object.'); } $this->_actionDictionary = $dictionary; if ($dictionary->Next !== null) { if ($dictionary->Next instanceof Zend_Pdf_Element_Dictionary) { if (!$processedActions->contains($dictionary->Next)) { $processedActions->attach($dictionary->Next); $this->next[] = Zend_Pdf_Action::load($dictionary->Next, $processedActions); } } else if ($dictionary->Next instanceof Zend_Pdf_Element_Array) { foreach ($dictionary->Next->items as $chainedActionDictionary) { if (!$processedActions->contains($chainedActionDictionary)) { $processedActions->attach($chainedActionDictionary); $this->next[] = Zend_Pdf_Action::load($chainedActionDictionary, $processedActions); } } } else { throw new Zend_Pdf_Exception('PDF Action dictionary Next entry must be a dictionary or an array.'); } } $this->_originalNextList = $this->next; } public static function load(Zend_Pdf_Element $dictionary, SplObjectStorage $processedActions = null) { if ($processedActions === null) { $processedActions = new SplObjectStorage(); } if ($dictionary->getType() != Zend_Pdf_Element::TYPE_DICTIONARY) { throw new Zend_Pdf_Exception('$dictionary mast be a direct or an indirect dictionary object.'); } if (isset($dictionary->Type) && $dictionary->Type->value != 'Action') { throw new Zend_Pdf_Exception('Action dictionary Type entry must be set to \'Action\'.'); } if ($dictionary->S === null) { throw new Zend_Pdf_Exception('Action dictionary must contain S entry'); } switch ($dictionary->S->value) { case 'GoTo': return new Zend_Pdf_Action_GoTo($dictionary, $processedActions); break; case 'GoToR': return new Zend_Pdf_Action_GoToR($dictionary, $processedActions); break; case 'GoToE': return new Zend_Pdf_Action_GoToE($dictionary, $processedActions); break; case 'Launch': return new Zend_Pdf_Action_Launch($dictionary, $processedActions); break; case 'Thread': return new Zend_Pdf_Action_Thread($dictionary, $processedActions); break; case 'URI': return new Zend_Pdf_Action_URI($dictionary, $processedActions); break; case 'Sound': return new Zend_Pdf_Action_Sound($dictionary, $processedActions); break; case 'Movie': return new Zend_Pdf_Action_Movie($dictionary, $processedActions); break; case 'Hide': return new Zend_Pdf_Action_Hide($dictionary, $processedActions); break; case 'Named': return new Zend_Pdf_Action_Named($dictionary, $processedActions); break; case 'SubmitForm': return new Zend_Pdf_Action_SubmitForm($dictionary, $processedActions); break; case 'ResetForm': return new Zend_Pdf_Action_ResetForm($dictionary, $processedActions); break; case 'ImportData': return new Zend_Pdf_Action_ImportData($dictionary, $processedActions); break; case 'JavaScript': return new Zend_Pdf_Action_JavaScript($dictionary, $processedActions); break; case 'SetOCGState': return new Zend_Pdf_Action_SetOCGState($dictionary, $processedActions); break; case 'Rendition': return new Zend_Pdf_Action_Rendition($dictionary, $processedActions); break; case 'Trans': return new Zend_Pdf_Action_Trans($dictionary, $processedActions); break; case 'GoTo3DView': return new Zend_Pdf_Action_GoTo3DView($dictionary, $processedActions); break; default: return new Zend_Pdf_Action_Unknown($dictionary, $processedActions); break; } } public function getResource() { return $this->_actionDictionary; } public function dumpAction(Zend_Pdf_ElementFactory_Interface $factory, SplObjectStorage $processedActions = null) { if ($processedActions === null) { $processedActions = new SplObjectStorage(); } if ($processedActions->contains($this)) { throw new Zend_Pdf_Exception('Action chain cyclyc reference is detected.'); } $processedActions->attach($this); $childListUpdated = false; if (count($this->_originalNextList) != count($this->next)) { $childListUpdated = true; } else if ( !(array_keys($this->_originalNextList) === array_keys($this->next)) ) { $childListUpdated = true; } else { foreach ($this->next as $key => $childAction) { if ($this->_originalNextList[$key] !== $childAction) { $childListUpdated = true; break; } } } if ($childListUpdated) { $this->_actionDictionary->touch(); switch (count($this->next)) { case 0: $this->_actionDictionary->Next = null; break; case 1: $child = reset($this->next); $this->_actionDictionary->Next = $child->dumpAction($factory, $processedActions); break; default: $pdfChildArray = new Zend_Pdf_Element_Array(); foreach ($this->next as $child) { $pdfChildArray->items[] = $child->dumpAction($factory, $processedActions); } $this->_actionDictionary->Next = $pdfChildArray; break; } } else { foreach ($this->next as $child) { $child->dumpAction($factory, $processedActions); } } if ($this->_actionDictionary instanceof Zend_Pdf_Element_Dictionary) { return $factory->newObject($this->_actionDictionary); } else { return $this->_actionDictionary; } } public function current() { return current($this->next); } public function key() { return key($this->next); } public function next() { return next($this->next); } public function rewind() { return reset($this->next); } public function valid() { return current($this->next) !== false; } public function getChildren() { return current($this->next); } public function hasChildren() { return count($this->next) > 0; } public function count() { return count($this->childOutlines); } }

/* @source /library/Zend/Pdf/FileParserDataSource.php */
abstract class Zend_Pdf_FileParserDataSource { protected $_size = 0; protected $_offset = 0; abstract public function __destruct(); abstract public function readBytes($byteCount); abstract public function readAllBytes(); public function __toString() { return get_class($this); } public function getOffset() { return $this->_offset; } public function getSize() { return $this->_size; } public function moveToOffset($offset) { if ($this->_offset == $offset) { return; } if ($offset < 0) { throw new Zend_Pdf_Exception('Attempt to move before start of data source', Zend_Pdf_Exception::MOVE_BEFORE_START_OF_FILE); } if ($offset >= $this->_size) { throw new Zend_Pdf_Exception('Attempt to move beyond end of data source', Zend_Pdf_Exception::MOVE_BEYOND_END_OF_FILE); } $this->_offset = $offset; } public function skipBytes($byteCount) { $this->moveToOffset($this->_offset + $byteCount); } }

/* @source /library/Zend/Pdf/Annotation.php */
abstract class Zend_Pdf_Annotation { protected $_annotationDictionary; public function getResource() { return $this->_annotationDictionary; } public function setBottom($bottom) { $this->_annotationDictionary->Rect->items[1]->touch(); $this->_annotationDictionary->Rect->items[1]->value = $bottom; return $this; } public function getBottom() { return $this->_annotationDictionary->Rect->items[1]->value; } public function setTop($top) { $this->_annotationDictionary->Rect->items[3]->touch(); $this->_annotationDictionary->Rect->items[3]->value = $top; return $this; } public function getTop() { return $this->_annotationDictionary->Rect->items[3]->value; } public function setRight($right) { $this->_annotationDictionary->Rect->items[2]->touch(); $this->_annotationDictionary->Rect->items[2]->value = $right; return $this; } public function getRight() { return $this->_annotationDictionary->Rect->items[2]->value; } public function setLeft($left) { $this->_annotationDictionary->Rect->items[0]->touch(); $this->_annotationDictionary->Rect->items[0]->value = $left; return $this; } public function getLeft() { return $this->_annotationDictionary->Rect->items[0]->value; } public function getText() { if ($this->_annotationDictionary->Contents === null) { return ''; } return $this->_annotationDictionary->Contents->value; } public function setText($text) { if ($this->_annotationDictionary->Contents === null) { $this->_annotationDictionary->touch(); $this->_annotationDictionary->Contents = new Zend_Pdf_Element_String($text); } else { $this->_annotationDictionary->Contents->touch(); $this->_annotationDictionary->Contents->value = new Zend_Pdf_Element_String($text); } return $this; } public function __construct(Zend_Pdf_Element $annotationDictionary) { if ($annotationDictionary->getType() != Zend_Pdf_Element::TYPE_DICTIONARY) { throw new Zend_Pdf_Exception('Annotation dictionary resource has to be a dictionary.'); } $this->_annotationDictionary = $annotationDictionary; if ($this->_annotationDictionary->Type !== null && $this->_annotationDictionary->Type->value != 'Annot') { throw new Zend_Pdf_Exception('Wrong resource type. \'Annot\' expected.'); } if ($this->_annotationDictionary->Rect === null) { throw new Zend_Pdf_Exception('\'Rect\' dictionary entry is required.'); } if (count($this->_annotationDictionary->Rect->items) != 4 || $this->_annotationDictionary->Rect->items[0]->getType() != Zend_Pdf_Element::TYPE_NUMERIC || $this->_annotationDictionary->Rect->items[1]->getType() != Zend_Pdf_Element::TYPE_NUMERIC || $this->_annotationDictionary->Rect->items[2]->getType() != Zend_Pdf_Element::TYPE_NUMERIC || $this->_annotationDictionary->Rect->items[3]->getType() != Zend_Pdf_Element::TYPE_NUMERIC ) { throw new Zend_Pdf_Exception('\'Rect\' dictionary entry must be an array of four numeric elements.'); } } public static function load(Zend_Pdf_Element $resource) { } }

/* @source /library/Zend/Pdf/Outline.php */
abstract class Zend_Pdf_Outline implements RecursiveIterator, Countable { protected $_open = false; public $childOutlines = array(); abstract public function getTitle(); abstract public function setTitle($title); public function isOpen() { return $this->_open; } public function setIsOpen($isOpen) { $this->_open = $isOpen; return $this; } abstract public function isItalic(); abstract public function setIsItalic($isItalic); abstract public function isBold(); abstract public function setIsBold($isBold); abstract public function getColor(); abstract public function setColor(Zend_Pdf_Color_Rgb $color); abstract public function getTarget(); abstract public function setTarget($target = null); public function getOptions() { return array('title' => $this->_title, 'open' => $this->_open, 'color' => $this->_color, 'italic' => $this->_italic, 'bold' => $this->_bold, 'target' => $this->_target); } public function setOptions(array $options) { foreach ($options as $key => $value) { switch ($key) { case 'title': $this->setTitle($value); break; case 'open': $this->setIsOpen($value); break; case 'color': $this->setColor($value); break; case 'italic': $this->setIsItalic($value); break; case 'bold': $this->setIsBold($value); break; case 'target': $this->setTarget($value); break; default: throw new Zend_Pdf_Exception("Unknown option name - '$key'."); break; } } return $this; } public static function create($param1, $param2 = null) { if (is_string($param1)) { if ($param2 !== null && !($param2 instanceof Zend_Pdf_Target || is_string($param2))) { throw new Zend_Pdf_Exception('Outline create method takes $title (string) and $target (Zend_Pdf_Target or string) or an array as an input'); } return new Zend_Pdf_Outline_Created(array('title' => $param1, 'target' => $param2)); } else { if (!is_array($param1) || $param2 !== null) { throw new Zend_Pdf_Exception('Outline create method takes $title (string) and $destination (Zend_Pdf_Destination) or an array as an input'); } return new Zend_Pdf_Outline_Created($param1); } } public function openOutlinesCount() { $count = 1; if ($this->isOpen()) { foreach ($this->childOutlines as $child) { $count += $child->openOutlinesCount(); } } return $count; } abstract public function dumpOutline(Zend_Pdf_ElementFactory_Interface $factory, $updateNavigation, Zend_Pdf_Element $parent, Zend_Pdf_Element $prev = null, SplObjectStorage $processedOutlines = null); public function current() { return current($this->childOutlines); } public function key() { return key($this->childOutlines); } public function next() { return next($this->childOutlines); } public function rewind() { return reset($this->childOutlines); } public function valid() { return current($this->childOutlines) !== false; } public function getChildren() { return current($this->childOutlines); } public function hasChildren() { return count($this->childOutlines) > 0; } public function count() { return count($this->childOutlines); } }

/* @source /library/Zend/Pdf/Destination.php */
abstract class Zend_Pdf_Destination extends Zend_Pdf_Target { public static function load(Zend_Pdf_Element $resource) { if ($resource->getType() == Zend_Pdf_Element::TYPE_NAME || $resource->getType() == Zend_Pdf_Element::TYPE_STRING) { return new Zend_Pdf_Destination_Named($resource); } if ($resource->getType() != Zend_Pdf_Element::TYPE_ARRAY) { throw new Zend_Pdf_Exception('An explicit destination must be a direct or an indirect array object.'); } if (count($resource->items) < 2) { throw new Zend_Pdf_Exception('An explicit destination array must contain at least two elements.'); } switch ($resource->items[1]->value) { case 'XYZ': return new Zend_Pdf_Destination_Zoom($resource); break; case 'Fit': return new Zend_Pdf_Destination_Fit($resource); break; case 'FitH': return new Zend_Pdf_Destination_FitHorizontally($resource); break; case 'FitV': return new Zend_Pdf_Destination_FitVertically($resource); break; case 'FitR': return new Zend_Pdf_Destination_FitRectangle($resource); break; case 'FitB': return new Zend_Pdf_Destination_FitBoundingBox($resource); break; case 'FitBH': return new Zend_Pdf_Destination_FitBoundingBoxHorizontally($resource); break; case 'FitBV': return new Zend_Pdf_Destination_FitBoundingBoxVertically($resource); break; default: return new Zend_Pdf_Destination_Unknown($resource); break; } } }

/* @source /library/Zend/Pdf/Cmap.php */
abstract class Zend_Pdf_Cmap { const TYPE_BYTE_ENCODING = 0x00; const TYPE_HIGH_BYTE_MAPPING = 0x02; const TYPE_SEGMENT_TO_DELTA = 0x04; const TYPE_TRIMMED_TABLE = 0x06; const TYPE_MIXED_COVERAGE = 0x08; const TYPE_TRIMMED_ARRAY = 0x0a; const TYPE_SEGMENTED_COVERAGE = 0x0c; const TYPE_BYTE_ENCODING_STATIC = 0xf1; const TYPE_UNKNOWN = 0xff; const MISSING_CHARACTER_GLYPH = 0x00; public static function cmapWithTypeData($cmapType, $cmapData) { switch ($cmapType) { case Zend_Pdf_Cmap::TYPE_BYTE_ENCODING: return new Zend_Pdf_Cmap_ByteEncoding($cmapData); case Zend_Pdf_Cmap::TYPE_BYTE_ENCODING_STATIC: return new Zend_Pdf_Cmap_ByteEncoding_Static($cmapData); case Zend_Pdf_Cmap::TYPE_HIGH_BYTE_MAPPING: throw new Zend_Pdf_Exception('High byte mapping cmap currently unsupported', Zend_Pdf_Exception::CMAP_TYPE_UNSUPPORTED); case Zend_Pdf_Cmap::TYPE_SEGMENT_TO_DELTA: return new Zend_Pdf_Cmap_SegmentToDelta($cmapData); case Zend_Pdf_Cmap::TYPE_TRIMMED_TABLE: return new Zend_Pdf_Cmap_TrimmedTable($cmapData); case Zend_Pdf_Cmap::TYPE_MIXED_COVERAGE: throw new Zend_Pdf_Exception('Mixed coverage cmap currently unsupported', Zend_Pdf_Exception::CMAP_TYPE_UNSUPPORTED); case Zend_Pdf_Cmap::TYPE_TRIMMED_ARRAY: throw new Zend_Pdf_Exception('Trimmed array cmap currently unsupported', Zend_Pdf_Exception::CMAP_TYPE_UNSUPPORTED); case Zend_Pdf_Cmap::TYPE_SEGMENTED_COVERAGE: throw new Zend_Pdf_Exception('Segmented coverage cmap currently unsupported', Zend_Pdf_Exception::CMAP_TYPE_UNSUPPORTED); default: throw new Zend_Pdf_Exception("Unknown cmap type: $cmapType", Zend_Pdf_Exception::CMAP_UNKNOWN_TYPE); } } abstract public function __construct($cmapData); abstract public function glyphNumbersForCharacters($characterCodes); abstract public function glyphNumberForCharacter($characterCode); abstract public function getCoveredCharacters(); abstract public function getCoveredCharactersGlyphs(); protected function _extractInt2(&$data, $index) { if (($index < 0) | (($index + 1) > strlen($data))) { throw new Zend_Pdf_Exception("Index out of range: $index", Zend_Pdf_Exception::INDEX_OUT_OF_RANGE); } $number = ord($data[$index]); if (($number & 0x80) == 0x80) { $number = ~((((~ $number) & 0xff) << 8) | ((~ ord($data[++$index])) & 0xff)); } else { $number = ($number << 8) | ord($data[++$index]); } return $number; } protected function _extractUInt2(&$data, $index) { if (($index < 0) | (($index + 1) > strlen($data))) { throw new Zend_Pdf_Exception("Index out of range: $index", Zend_Pdf_Exception::INDEX_OUT_OF_RANGE); } $number = (ord($data[$index]) << 8) | ord($data[++$index]); return $number; } protected function _extractUInt4(&$data, $index) { if (($index < 0) | (($index + 3) > strlen($data))) { throw new Zend_Pdf_Exception("Index out of range: $index", Zend_Pdf_Exception::INDEX_OUT_OF_RANGE); } $number = (ord($data[$index]) << 24) | (ord($data[++$index]) << 16) | (ord($data[++$index]) << 8) | ord($data[++$index]); return $number; } }

/* @source /library/Zend/Pdf/Trailer.php */
abstract class Zend_Pdf_Trailer { private static $_allowedKeys = array('Size', 'Prev', 'Root', 'Encrypt', 'Info', 'ID', 'Index', 'W', 'XRefStm', 'DocChecksum'); private $_dict; private function _checkDictKey($key) { if ( !in_array($key, self::$_allowedKeys) ) { throw new Zend_Pdf_Exception("Unknown trailer dictionary key: '$key'."); } } public function __construct(Zend_Pdf_Element_Dictionary $dict) { $this->_dict = $dict; foreach ($this->_dict->getKeys() as $dictKey) { $this->_checkDictKey($dictKey); } } public function __get($property) { return $this->_dict->$property; } public function __set($property, $value) { $this->_checkDictKey($property); $this->_dict->$property = $value; } public function toString() { return "trailer\n" . $this->_dict->toString() . "\n"; } abstract public function getPDFLength(); abstract public function getPDFString(); abstract public function getLastFreeObject(); }

/* @source /library/Zend/Pdf/Font.php */
abstract class Zend_Pdf_Font { const TYPE_UNKNOWN = 0; const TYPE_STANDARD = 1; const TYPE_TYPE_1 = 2; const TYPE_TRUETYPE = 3; const TYPE_TYPE_0 = 4; const TYPE_CIDFONT_TYPE_0 = 5; const TYPE_CIDFONT_TYPE_2 = 6; const FONT_COURIER = 'Courier'; const FONT_COURIER_BOLD = 'Courier-Bold'; const FONT_COURIER_OBLIQUE = 'Courier-Oblique'; const FONT_COURIER_ITALIC = 'Courier-Oblique'; const FONT_COURIER_BOLD_OBLIQUE = 'Courier-BoldOblique'; const FONT_COURIER_BOLD_ITALIC = 'Courier-BoldOblique'; const FONT_HELVETICA = 'Helvetica'; const FONT_HELVETICA_BOLD = 'Helvetica-Bold'; const FONT_HELVETICA_OBLIQUE = 'Helvetica-Oblique'; const FONT_HELVETICA_ITALIC = 'Helvetica-Oblique'; const FONT_HELVETICA_BOLD_OBLIQUE = 'Helvetica-BoldOblique'; const FONT_HELVETICA_BOLD_ITALIC = 'Helvetica-BoldOblique'; const FONT_SYMBOL = 'Symbol'; const FONT_TIMES_ROMAN = 'Times-Roman'; const FONT_TIMES = 'Times-Roman'; const FONT_TIMES_BOLD = 'Times-Bold'; const FONT_TIMES_ITALIC = 'Times-Italic'; const FONT_TIMES_BOLD_ITALIC = 'Times-BoldItalic'; const FONT_ZAPFDINGBATS = 'ZapfDingbats'; const NAME_COPYRIGHT = 0; const NAME_FAMILY = 1; const NAME_STYLE = 2; const NAME_ID = 3; const NAME_FULL = 4; const NAME_VERSION = 5; const NAME_POSTSCRIPT = 6; const NAME_TRADEMARK = 7; const NAME_MANUFACTURER = 8; const NAME_DESIGNER = 9; const NAME_DESCRIPTION = 10; const NAME_VENDOR_URL = 11; const NAME_DESIGNER_URL = 12; const NAME_LICENSE = 13; const NAME_LICENSE_URL = 14; const NAME_PREFERRED_FAMILY = 16; const NAME_PREFERRED_STYLE = 17; const NAME_SAMPLE_TEXT = 19; const NAME_CID_NAME = 20; const WEIGHT_THIN = 100; const WEIGHT_EXTRA_LIGHT = 200; const WEIGHT_LIGHT = 300; const WEIGHT_NORMAL = 400; const WEIGHT_MEDIUM = 500; const WEIGHT_SEMI_BOLD = 600; const WEIGHT_BOLD = 700; const WEIGHT_EXTRA_BOLD = 800; const WEIGHT_BLACK = 900; const WIDTH_ULTRA_CONDENSED = 1; const WIDTH_EXTRA_CONDENSED = 2; const WIDTH_CONDENSED = 3; const WIDTH_SEMI_CONDENSED = 4; const WIDTH_NORMAL = 5; const WIDTH_SEMI_EXPANDED = 6; const WIDTH_EXPANDED = 7; const WIDTH_EXTRA_EXPANDED = 8; const WIDTH_ULTRA_EXPANDED = 9; const EMBED_DONT_EMBED = 0x01; const EMBED_DONT_SUBSET = 0x02; const EMBED_DONT_COMPRESS = 0x04; const EMBED_SUPPRESS_EMBED_EXCEPTION = 0x08; private static $_fontNames = array(); private static $_fontFilePaths = array(); public static function fontWithName($name, $embeddingOptions = 0) { if (isset(Zend_Pdf_Font::$_fontNames[$name])) { return Zend_Pdf_Font::$_fontNames[$name]; } switch ($name) { case Zend_Pdf_Font::FONT_COURIER: $font = new Zend_Pdf_Resource_Font_Simple_Standard_Courier(); break; case Zend_Pdf_Font::FONT_COURIER_BOLD: $font = new Zend_Pdf_Resource_Font_Simple_Standard_CourierBold(); break; case Zend_Pdf_Font::FONT_COURIER_OBLIQUE: $font = new Zend_Pdf_Resource_Font_Simple_Standard_CourierOblique(); break; case Zend_Pdf_Font::FONT_COURIER_BOLD_OBLIQUE: $font = new Zend_Pdf_Resource_Font_Simple_Standard_CourierBoldOblique(); break; case Zend_Pdf_Font::FONT_HELVETICA: $font = new Zend_Pdf_Resource_Font_Simple_Standard_Helvetica(); break; case Zend_Pdf_Font::FONT_HELVETICA_BOLD: $font = new Zend_Pdf_Resource_Font_Simple_Standard_HelveticaBold(); break; case Zend_Pdf_Font::FONT_HELVETICA_OBLIQUE: $font = new Zend_Pdf_Resource_Font_Simple_Standard_HelveticaOblique(); break; case Zend_Pdf_Font::FONT_HELVETICA_BOLD_OBLIQUE: $font = new Zend_Pdf_Resource_Font_Simple_Standard_HelveticaBoldOblique(); break; case Zend_Pdf_Font::FONT_SYMBOL: $font = new Zend_Pdf_Resource_Font_Simple_Standard_Symbol(); break; case Zend_Pdf_Font::FONT_TIMES_ROMAN: $font = new Zend_Pdf_Resource_Font_Simple_Standard_TimesRoman(); break; case Zend_Pdf_Font::FONT_TIMES_BOLD: $font = new Zend_Pdf_Resource_Font_Simple_Standard_TimesBold(); break; case Zend_Pdf_Font::FONT_TIMES_ITALIC: $font = new Zend_Pdf_Resource_Font_Simple_Standard_TimesItalic(); break; case Zend_Pdf_Font::FONT_TIMES_BOLD_ITALIC: $font = new Zend_Pdf_Resource_Font_Simple_Standard_TimesBoldItalic(); break; case Zend_Pdf_Font::FONT_ZAPFDINGBATS: $font = new Zend_Pdf_Resource_Font_Simple_Standard_ZapfDingbats(); break; default: throw new Zend_Pdf_Exception("Unknown font name: $name", Zend_Pdf_Exception::BAD_FONT_NAME); } Zend_Pdf_Font::$_fontNames[$name] = $font; return $font; } public static function fontWithPath($filePath, $embeddingOptions = 0) { $filePathKey = md5($filePath); if (isset(Zend_Pdf_Font::$_fontFilePaths[$filePathKey])) { return Zend_Pdf_Font::$_fontFilePaths[$filePathKey]; } $dataSource = new Zend_Pdf_FileParserDataSource_File($filePath); $fileExtension = strtolower(pathinfo($filePath, PATHINFO_EXTENSION)); switch ($fileExtension) { case 'ttf': $font = Zend_Pdf_Font::_extractTrueTypeFont($dataSource, $embeddingOptions); break; default: $font = null; break; } if ($font === null) { if (($font === null) && ($fileExtension != 'ttf')) { $font = Zend_Pdf_Font::_extractTrueTypeFont($dataSource, $embeddingOptions); } } $dataSource = null; if ($font !== null) { $fontName = $font->getFontName(Zend_Pdf_Font::NAME_POSTSCRIPT, '', ''); Zend_Pdf_Font::$_fontNames[$fontName] = $font; $filePathKey = md5($filePath); Zend_Pdf_Font::$_fontFilePaths[$filePathKey] = $font; return $font; } else { throw new Zend_Pdf_Exception("Cannot determine font type: $filePath", Zend_Pdf_Exception::CANT_DETERMINE_FONT_TYPE); } } protected static function _extractTrueTypeFont($dataSource, $embeddingOptions) { try { $fontParser = new Zend_Pdf_FileParser_Font_OpenType_TrueType($dataSource); $fontParser->parse(); if ($fontParser->isAdobeLatinSubset) { $font = new Zend_Pdf_Resource_Font_Simple_Parsed_TrueType($fontParser, $embeddingOptions); } else { $cidFont = new Zend_Pdf_Resource_Font_CidFont_TrueType($fontParser, $embeddingOptions); $font = new Zend_Pdf_Resource_Font_Type0($cidFont); } } catch (Zend_Pdf_Exception $e) { $fontParser = null; switch ($e->getCode()) { case Zend_Pdf_Exception::WRONG_FONT_TYPE: case Zend_Pdf_Exception::BAD_TABLE_COUNT: case Zend_Pdf_Exception::BAD_MAGIC_NUMBER: return null; default: throw new Zend_Pdf_Exception($e->getMessage(), $e->getCode(), $e); } } return $font; } }

/* @source /library/Zend/Pdf/Image.php */
abstract class Zend_Pdf_Image { const TYPE_UNKNOWN = 0; const TYPE_JPEG = 1; const TYPE_PNG = 2; const TYPE_TIFF = 3; const TIFF_FIELD_TYPE_BYTE=1; const TIFF_FIELD_TYPE_ASCII=2; const TIFF_FIELD_TYPE_SHORT=3; const TIFF_FIELD_TYPE_LONG=4; const TIFF_FIELD_TYPE_RATIONAL=5; const TIFF_TAG_IMAGE_WIDTH=256; const TIFF_TAG_IMAGE_LENGTH=257; const TIFF_TAG_BITS_PER_SAMPLE=258; const TIFF_TAG_COMPRESSION=259; const TIFF_TAG_PHOTOMETRIC_INTERPRETATION=262; const TIFF_TAG_STRIP_OFFSETS=273; const TIFF_TAG_SAMPLES_PER_PIXEL=277; const TIFF_TAG_STRIP_BYTE_COUNTS=279; const TIFF_COMPRESSION_UNCOMPRESSED = 1; const TIFF_COMPRESSION_CCITT1D = 2; const TIFF_COMPRESSION_GROUP_3_FAX = 3; const TIFF_COMPRESSION_GROUP_4_FAX = 4; const TIFF_COMPRESSION_LZW = 5; const TIFF_COMPRESSION_JPEG = 6; const TIFF_COMPRESSION_FLATE = 8; const TIFF_COMPRESSION_FLATE_OBSOLETE_CODE = 32946; const TIFF_COMPRESSION_PACKBITS = 32773; const TIFF_PHOTOMETRIC_INTERPRETATION_WHITE_IS_ZERO=0; const TIFF_PHOTOMETRIC_INTERPRETATION_BLACK_IS_ZERO=1; const TIFF_PHOTOMETRIC_INTERPRETATION_RGB=2; const TIFF_PHOTOMETRIC_INTERPRETATION_RGB_INDEXED=3; const TIFF_PHOTOMETRIC_INTERPRETATION_CMYK=5; const TIFF_PHOTOMETRIC_INTERPRETATION_YCBCR=6; const TIFF_PHOTOMETRIC_INTERPRETATION_CIELAB=8; const PNG_COMPRESSION_DEFAULT_STRATEGY = 0; const PNG_COMPRESSION_FILTERED = 1; const PNG_COMPRESSION_HUFFMAN_ONLY = 2; const PNG_COMPRESSION_RLE = 3; const PNG_FILTER_NONE = 0; const PNG_FILTER_SUB = 1; const PNG_FILTER_UP = 2; const PNG_FILTER_AVERAGE = 3; const PNG_FILTER_PAETH = 4; const PNG_INTERLACING_DISABLED = 0; const PNG_INTERLACING_ENABLED = 1; const PNG_CHANNEL_GRAY = 0; const PNG_CHANNEL_RGB = 2; const PNG_CHANNEL_INDEXED = 3; const PNG_CHANNEL_GRAY_ALPHA = 4; const PNG_CHANNEL_RGB_ALPHA = 6; public static function imageWithPath($filePath) { return Zend_Pdf_Resource_ImageFactory::factory($filePath); $dataSource = new Zend_Pdf_FileParserDataSource_File($filePath); $fileExtension = strtolower(pathinfo($filePath, PATHINFO_EXTENSION)); switch ($fileExtension) { case 'tif': case 'tiff': $image = Zend_Pdf_Image::_extractTiffImage($dataSource); break; case 'png': $image = Zend_Pdf_Image::_extractPngImage($dataSource); break; case 'jpg': case 'jpe': case 'jpeg': $image = Zend_Pdf_Image::_extractJpegImage($dataSource); break; default: throw new Zend_Pdf_Exception("Cannot create image resource. File extension not known or unsupported type."); break; } $dataSource = null; if ($image !== null) { return $image; } else { throw new Zend_Pdf_Exception("Cannot determine image type: $filePath", Zend_Pdf_Exception::CANT_DETERMINE_IMAGE_TYPE); } } protected static function _extractJpegImage($dataSource) { throw new Zend_Pdf_Exception('Jpeg image fileparser is not implemented. Old styly implementation has to be used.'); $imageParser = new Zend_Pdf_FileParser_Image_Jpeg($dataSource); $image = new Zend_Pdf_Resource_Image_Jpeg($imageParser); unset($imageParser); return $image; } protected static function _extractPngImage($dataSource) { $imageParser = new Zend_Pdf_FileParser_Image_Png($dataSource); $image = new Zend_Pdf_Resource_Image_Png($imageParser); unset($imageParser); return $image; } protected static function _extractTiffImage($dataSource) { throw new Zend_Pdf_Exception('Tiff image fileparser is not implemented. Old styly implementation has to be used.'); $imageParser = new Zend_Pdf_FileParser_Image_Tiff($dataSource); $image = new Zend_Pdf_Resource_Image_Tiff($imageParser); unset($imageParser); return $image; } }

/* @source /library/Zend/Pdf/Filter/Compression.php */
abstract class Zend_Pdf_Filter_Compression implements Zend_Pdf_Filter_Interface { private static function _paeth($a, $b, $c) { $p = $a + $b - $c; $pa = abs($p - $a); $pb = abs($p - $b); $pc = abs($p - $c); if ($pa <= $pb && $pa <= $pc) { return $a; } else if ($pb <= $pc) { return $b; } else { return $c; } } private static function _getPredictorValue(&$params) { if (isset($params['Predictor'])) { $predictor = $params['Predictor']; if ($predictor != 1 && $predictor != 2 && $predictor != 10 && $predictor != 11 && $predictor != 12 && $predictor != 13 && $predictor != 14 && $predictor != 15) { throw new Zend_Pdf_Exception('Invalid value of \'Predictor\' decode param - ' . $predictor . '.' ); } return $predictor; } else { return 1; } } private static function _getColorsValue(&$params) { if (isset($params['Colors'])) { $colors = $params['Colors']; if ($colors != 1 && $colors != 2 && $colors != 3 && $colors != 4) { throw new Zend_Pdf_Exception('Invalid value of \'Color\' decode param - ' . $colors . '.' ); } return $colors; } else { return 1; } } private static function _getBitsPerComponentValue(&$params) { if (isset($params['BitsPerComponent'])) { $bitsPerComponent = $params['BitsPerComponent']; if ($bitsPerComponent != 1 && $bitsPerComponent != 2 && $bitsPerComponent != 4 && $bitsPerComponent != 8 && $bitsPerComponent != 16 ) { throw new Zend_Pdf_Exception('Invalid value of \'BitsPerComponent\' decode param - ' . $bitsPerComponent . '.' ); } return $bitsPerComponent; } else { return 8; } } private static function _getColumnsValue(&$params) { if (isset($params['Columns'])) { return $params['Columns']; } else { return 1; } } protected static function _applyEncodeParams($data, $params) { $predictor = self::_getPredictorValue($params); $colors = self::_getColorsValue($params); $bitsPerComponent = self::_getBitsPerComponentValue($params); $columns = self::_getColumnsValue($params); if ($predictor == 1) { return $data; } if ($predictor == 2) { throw new Zend_Pdf_Exception('Not implemented yet' ); } if ($predictor == 15) { $predictor = 14; } if ($predictor == 10 || $predictor == 11 || $predictor == 12 || $predictor == 13 || $predictor == 14 ) { $predictor -= 10; if($bitsPerComponent == 16) { throw new Zend_Pdf_Exception("PNG Prediction with bit depth greater than 8 not yet supported."); } $bitsPerSample = $bitsPerComponent*$colors; $bytesPerSample = (int)(($bitsPerSample + 7)/8); $bytesPerRow = (int)(($bitsPerSample*$columns + 7)/8); $rows = strlen($data)/$bytesPerRow; $output = ''; $offset = 0; if (!is_integer($rows)) { throw new Zend_Pdf_Exception('Wrong data length.'); } switch ($predictor) { case 0: for ($count = 0; $count < $rows; $count++) { $output .= chr($predictor); $output .= substr($data, $offset, $bytesPerRow); $offset += $bytesPerRow; } break; case 1: for ($count = 0; $count < $rows; $count++) { $output .= chr($predictor); $lastSample = array_fill(0, $bytesPerSample, 0); for ($count2 = 0; $count2 < $bytesPerRow; $count2++) { $newByte = ord($data[$offset++]); $output .= chr($newByte - $lastSample[$count2 % $bytesPerSample]); $lastSample[$count2 % $bytesPerSample] = $newByte; } } break; case 2: $lastRow = array_fill(0, $bytesPerRow, 0); for ($count = 0; $count < $rows; $count++) { $output .= chr($predictor); for ($count2 = 0; $count2 < $bytesPerRow; $count2++) { $newByte = ord($data[$offset++]); $output .= chr($newByte - $lastRow[$count2]); $lastRow[$count2] = $newByte; } } break; case 3: $lastRow = array_fill(0, $bytesPerRow, 0); for ($count = 0; $count < $rows; $count++) { $output .= chr($predictor); $lastSample = array_fill(0, $bytesPerSample, 0); for ($count2 = 0; $count2 < $bytesPerRow; $count2++) { $newByte = ord($data[$offset++]); $output .= chr($newByte - floor(( $lastSample[$count2 % $bytesPerSample] + $lastRow[$count2])/2)); $lastSample[$count2 % $bytesPerSample] = $lastRow[$count2] = $newByte; } } break; case 4: $lastRow = array_fill(0, $bytesPerRow, 0); $currentRow = array(); for ($count = 0; $count < $rows; $count++) { $output .= chr($predictor); $lastSample = array_fill(0, $bytesPerSample, 0); for ($count2 = 0; $count2 < $bytesPerRow; $count2++) { $newByte = ord($data[$offset++]); $output .= chr($newByte - self::_paeth( $lastSample[$count2 % $bytesPerSample], $lastRow[$count2], ($count2 - $bytesPerSample < 0)? 0 : $lastRow[$count2 - $bytesPerSample] )); $lastSample[$count2 % $bytesPerSample] = $currentRow[$count2] = $newByte; } $lastRow = $currentRow; } break; } return $output; } throw new Zend_Pdf_Exception('Unknown prediction algorithm - ' . $predictor . '.' ); } protected static function _applyDecodeParams($data, $params) { $predictor = self::_getPredictorValue($params); $colors = self::_getColorsValue($params); $bitsPerComponent = self::_getBitsPerComponentValue($params); $columns = self::_getColumnsValue($params); if ($predictor == 1) { return $data; } if ($predictor == 2) { throw new Zend_Pdf_Exception('Not implemented yet' ); } if ($predictor == 10 || $predictor == 11 || $predictor == 12 || $predictor == 13 || $predictor == 14 || $predictor == 15 ) { $bitsPerSample = $bitsPerComponent*$colors; $bytesPerSample = ceil($bitsPerSample/8); $bytesPerRow = ceil($bitsPerSample*$columns/8); $rows = ceil(strlen($data)/($bytesPerRow + 1)); $output = ''; $offset = 0; $lastRow = array_fill(0, $bytesPerRow, 0); for ($count = 0; $count < $rows; $count++) { $lastSample = array_fill(0, $bytesPerSample, 0); switch (ord($data[$offset++])) { case 0: $output .= substr($data, $offset, $bytesPerRow); for ($count2 = 0; $count2 < $bytesPerRow && $offset < strlen($data); $count2++) { $lastSample[$count2 % $bytesPerSample] = $lastRow[$count2] = ord($data[$offset++]); } break; case 1: for ($count2 = 0; $count2 < $bytesPerRow && $offset < strlen($data); $count2++) { $decodedByte = (ord($data[$offset++]) + $lastSample[$count2 % $bytesPerSample]) & 0xFF; $lastSample[$count2 % $bytesPerSample] = $lastRow[$count2] = $decodedByte; $output .= chr($decodedByte); } break; case 2: for ($count2 = 0; $count2 < $bytesPerRow && $offset < strlen($data); $count2++) { $decodedByte = (ord($data[$offset++]) + $lastRow[$count2]) & 0xFF; $lastSample[$count2 % $bytesPerSample] = $lastRow[$count2] = $decodedByte; $output .= chr($decodedByte); } break; case 3: for ($count2 = 0; $count2 < $bytesPerRow && $offset < strlen($data); $count2++) { $decodedByte = (ord($data[$offset++]) + floor(( $lastSample[$count2 % $bytesPerSample] + $lastRow[$count2])/2) ) & 0xFF; $lastSample[$count2 % $bytesPerSample] = $lastRow[$count2] = $decodedByte; $output .= chr($decodedByte); } break; case 4: $currentRow = array(); for ($count2 = 0; $count2 < $bytesPerRow && $offset < strlen($data); $count2++) { $decodedByte = (ord($data[$offset++]) + self::_paeth($lastSample[$count2 % $bytesPerSample], $lastRow[$count2], ($count2 - $bytesPerSample < 0)? 0 : $lastRow[$count2 - $bytesPerSample]) ) & 0xFF; $lastSample[$count2 % $bytesPerSample] = $currentRow[$count2] = $decodedByte; $output .= chr($decodedByte); } $lastRow = $currentRow; break; default: throw new Zend_Pdf_Exception('Unknown prediction tag.'); } } return $output; } throw new Zend_Pdf_Exception('Unknown prediction algorithm - ' . $predictor . '.' ); } }

/* @source /library/Zend/Pdf/FileParser/Image.php */
abstract class Zend_Pdf_FileParser_Image extends Zend_Pdf_FileParser { protected $imageType; public function __construct(Zend_Pdf_FileParserDataSource $dataSource) { parent::__construct($dataSource); $this->imageType = Zend_Pdf_Image::TYPE_UNKNOWN; } }

/* @source /library/Zend/Pdf/FileParser/Font.php */
abstract class Zend_Pdf_FileParser_Font extends Zend_Pdf_FileParser { private $_fontProperties = array(); private $_debug = false; public function __construct(Zend_Pdf_FileParserDataSource $dataSource) { parent::__construct($dataSource); $this->fontType = Zend_Pdf_Font::TYPE_UNKNOWN; } public function __get($property) { if (isset($this->_fontProperties[$property])) { return $this->_fontProperties[$property]; } else { return null; } } public function readStringUTF16($byteCount, $byteOrder = Zend_Pdf_FileParser::BYTE_ORDER_BIG_ENDIAN, $characterSet = '') { return parent::readStringUTF16($byteCount, $byteOrder, 'UTF-16BE'); } public function readStringMacRoman($byteCount, $characterSet = '') { return parent::readStringMacRoman($byteCount, 'UTF-16BE'); } public function readStringPascal($characterSet = '', $lengthBytes = 1) { return parent::readStringPascal('UTF-16BE'); } public function writeDebug() { print_r($this->_fontProperties); } public function __set($property, $value) { if ($value === null) { unset($this->_fontProperties[$property]); } else { $this->_fontProperties[$property] = $value; } } protected function _debugLog($message) { if (! $this->_debug) { return; } if (func_num_args() > 1) { $args = func_get_args(); $message = array_shift($args); $message = vsprintf($message, $args); } $logger = new Zend_Log(); $logger->log($message, Zend_Log::DEBUG); } }

/* @source /library/Zend/Pdf/Canvas/Abstract.php */
abstract class Zend_Pdf_Canvas_Abstract implements Zend_Pdf_Canvas_Interface { protected $_contents = ''; protected $_font = null; protected $_fontSize; protected $_style = null; protected $_saveCount = 0; abstract protected function _addProcSet($procSetName); abstract protected function _attachResource($type, Zend_Pdf_Resource $resource); public function drawCanvas(Zend_Pdf_Canvas_Interface $canvas, $x1, $y1, $x2 = null, $y2 = null) { $this->saveGS(); $this->translate($x1, $y1); if ($x2 === null) { $with = $canvas->getWidth(); } else { $with = $x2 - $x1; } if ($y2 === null) { $height = $canvas->getHeight(); } else { $height = $y2 - $y1; } $this->clipRectangle(0, 0, $with, $height); if ($x2 !== null || $y2 !== null) { if ($x2 !== null) { $xScale = $with/$canvas->getWidth(); } else { $xScale = 1; } if ($y2 !== null) { $yScale = $height/$canvas->getHeight(); } else { $yScale = 1; } $this->scale($xScale, $yScale); } $contentsToDraw = $canvas->getContents(); $this->restoreGS(); return $this; } public function setFillColor(Zend_Pdf_Color $color) { $this->_addProcSet('PDF'); $this->_contents .= $color->instructions(false); return $this; } public function setLineColor(Zend_Pdf_Color $color) { $this->_addProcSet('PDF'); $this->_contents .= $color->instructions(true); return $this; } public function setLineWidth($width) { $this->_addProcSet('PDF'); $widthObj = new Zend_Pdf_Element_Numeric($width); $this->_contents .= $widthObj->toString() . " w\n"; return $this; } public function setLineDashingPattern($pattern, $phase = 0) { $this->_addProcSet('PDF'); if ($pattern === Zend_Pdf_Page::LINE_DASHING_SOLID) { $pattern = array(); $phase = 0; } $dashPattern = new Zend_Pdf_Element_Array(); $phaseEleemnt = new Zend_Pdf_Element_Numeric($phase); foreach ($pattern as $dashItem) { $dashElement = new Zend_Pdf_Element_Numeric($dashItem); $dashPattern->items[] = $dashElement; } $this->_contents .= $dashPattern->toString() . ' ' . $phaseEleemnt->toString() . " d\n"; return $this; } public function setFont(Zend_Pdf_Resource_Font $font, $fontSize) { $this->_addProcSet('Text'); $fontName = $this->_attachResource('Font', $font); $this->_font = $font; $this->_fontSize = $fontSize; $fontNameObj = new Zend_Pdf_Element_Name($fontName); $fontSizeObj = new Zend_Pdf_Element_Numeric($fontSize); $this->_contents .= $fontNameObj->toString() . ' ' . $fontSizeObj->toString() . " Tf\n"; return $this; } public function setStyle(Zend_Pdf_Style $style) { $this->_addProcSet('Text'); $this->_addProcSet('PDF'); if ($style->getFont() !== null) { $this->setFont($style->getFont(), $style->getFontSize()); } $this->_contents .= $style->instructions($this->_dictionary->Resources); $this->_style = $style; return $this; } public function getFont() { return $this->_font; } public function getFontSize() { return $this->_fontSize; } public function getStyle() { return $this->_style; } public function saveGS() { $this->_saveCount++; $this->_addProcSet('PDF'); $this->_contents .= " q\n"; return $this; } public function restoreGS() { if ($this->_saveCount-- <= 0) { throw new Zend_Pdf_Exception('Restoring graphics state which is not saved'); } $this->_contents .= " Q\n"; return $this; } public function setAlpha($alpha, $mode = 'Normal') { $this->_addProcSet('Text'); $this->_addProcSet('PDF'); $graphicsState = new Zend_Pdf_Resource_GraphicsState(); $graphicsState->setAlpha($alpha, $mode); $gStateName = $this->_attachResource('ExtGState', $graphicsState); $gStateNameObject = new Zend_Pdf_Element_Name($gStateName); $this->_contents .= $gStateNameObject->toString() . " gs\n"; return $this; } public function clipCircle($x, $y, $radius, $startAngle = null, $endAngle = null) { $this->clipEllipse($x - $radius, $y - $radius, $x + $radius, $y + $radius, $startAngle, $endAngle); return $this; } public function clipEllipse($x1, $y1, $x2, $y2, $startAngle = null, $endAngle = null) { $this->_addProcSet('PDF'); if ($x2 < $x1) { $temp = $x1; $x1 = $x2; $x2 = $temp; } if ($y2 < $y1) { $temp = $y1; $y1 = $y2; $y2 = $temp; } $x = ($x1 + $x2)/2.; $y = ($y1 + $y2)/2.; $xC = new Zend_Pdf_Element_Numeric($x); $yC = new Zend_Pdf_Element_Numeric($y); if ($startAngle !== null) { if ($startAngle != 0) { $startAngle = fmod($startAngle, M_PI*2); } if ($endAngle != 0) { $endAngle = fmod($endAngle, M_PI*2); } if ($startAngle > $endAngle) { $endAngle += M_PI*2; } $clipPath = $xC->toString() . ' ' . $yC->toString() . " m\n"; $clipSectors = (int)ceil(($endAngle - $startAngle)/M_PI_4); $clipRadius = max($x2 - $x1, $y2 - $y1); for($count = 0; $count <= $clipSectors; $count++) { $pAngle = $startAngle + ($endAngle - $startAngle)*$count/(float)$clipSectors; $pX = new Zend_Pdf_Element_Numeric($x + cos($pAngle)*$clipRadius); $pY = new Zend_Pdf_Element_Numeric($y + sin($pAngle)*$clipRadius); $clipPath .= $pX->toString() . ' ' . $pY->toString() . " l\n"; } $this->_contents .= $clipPath . "h\nW\nn\n"; } $xLeft = new Zend_Pdf_Element_Numeric($x1); $xRight = new Zend_Pdf_Element_Numeric($x2); $yUp = new Zend_Pdf_Element_Numeric($y2); $yDown = new Zend_Pdf_Element_Numeric($y1); $xDelta = 2*(M_SQRT2 - 1)*($x2 - $x1)/3.; $yDelta = 2*(M_SQRT2 - 1)*($y2 - $y1)/3.; $xr = new Zend_Pdf_Element_Numeric($x + $xDelta); $xl = new Zend_Pdf_Element_Numeric($x - $xDelta); $yu = new Zend_Pdf_Element_Numeric($y + $yDelta); $yd = new Zend_Pdf_Element_Numeric($y - $yDelta); $this->_contents .= $xC->toString() . ' ' . $yUp->toString() . " m\n" . $xr->toString() . ' ' . $yUp->toString() . ' ' . $xRight->toString() . ' ' . $yu->toString() . ' ' . $xRight->toString() . ' ' . $yC->toString() . " c\n" . $xRight->toString() . ' ' . $yd->toString() . ' ' . $xr->toString() . ' ' . $yDown->toString() . ' ' . $xC->toString() . ' ' . $yDown->toString() . " c\n" . $xl->toString() . ' ' . $yDown->toString() . ' ' . $xLeft->toString() . ' ' . $yd->toString() . ' ' . $xLeft->toString() . ' ' . $yC->toString() . " c\n" . $xLeft->toString() . ' ' . $yu->toString() . ' ' . $xl->toString() . ' ' . $yUp->toString() . ' ' . $xC->toString() . ' ' . $yUp->toString() . " c\n" . "h\nW\nn\n"; return $this; } public function clipPolygon($x, $y, $fillMethod = Zend_Pdf_Page::FILL_METHOD_NON_ZERO_WINDING) { $this->_addProcSet('PDF'); $firstPoint = true; foreach ($x as $id => $xVal) { $xObj = new Zend_Pdf_Element_Numeric($xVal); $yObj = new Zend_Pdf_Element_Numeric($y[$id]); if ($firstPoint) { $path = $xObj->toString() . ' ' . $yObj->toString() . " m\n"; $firstPoint = false; } else { $path .= $xObj->toString() . ' ' . $yObj->toString() . " l\n"; } } $this->_contents .= $path; if ($fillMethod == Zend_Pdf_Page::FILL_METHOD_NON_ZERO_WINDING) { $this->_contents .= " h\n W\nn\n"; } else { $this->_contents .= " h\n W*\nn\n"; } return $this; } public function clipRectangle($x1, $y1, $x2, $y2) { $this->_addProcSet('PDF'); $x1Obj = new Zend_Pdf_Element_Numeric($x1); $y1Obj = new Zend_Pdf_Element_Numeric($y1); $widthObj = new Zend_Pdf_Element_Numeric($x2 - $x1); $height2Obj = new Zend_Pdf_Element_Numeric($y2 - $y1); $this->_contents .= $x1Obj->toString() . ' ' . $y1Obj->toString() . ' ' . $widthObj->toString() . ' ' . $height2Obj->toString() . " re\n" . " W\nn\n"; return $this; } public function drawCircle($x, $y, $radius, $param4 = null, $param5 = null, $param6 = null) { $this->drawEllipse($x - $radius, $y - $radius, $x + $radius, $y + $radius, $param4, $param5, $param6); return $this; } public function drawEllipse($x1, $y1, $x2, $y2, $param5 = null, $param6 = null, $param7 = null) { if ($param5 === null) { $startAngle = null; $fillType = Zend_Pdf_Page::SHAPE_DRAW_FILL_AND_STROKE; } else if ($param6 === null) { $startAngle = null; $fillType = $param5; } else { $startAngle = $param5; $endAngle = $param6; if ($param7 === null) { $fillType = Zend_Pdf_Page::SHAPE_DRAW_FILL_AND_STROKE; } else { $fillType = $param7; } } $this->_addProcSet('PDF'); if ($x2 < $x1) { $temp = $x1; $x1 = $x2; $x2 = $temp; } if ($y2 < $y1) { $temp = $y1; $y1 = $y2; $y2 = $temp; } $x = ($x1 + $x2)/2.; $y = ($y1 + $y2)/2.; $xC = new Zend_Pdf_Element_Numeric($x); $yC = new Zend_Pdf_Element_Numeric($y); if ($startAngle !== null) { if ($startAngle != 0) { $startAngle = fmod($startAngle, M_PI*2); } if ($endAngle != 0) { $endAngle = fmod($endAngle, M_PI*2); } if ($startAngle > $endAngle) { $endAngle += M_PI*2; } $clipPath = $xC->toString() . ' ' . $yC->toString() . " m\n"; $clipSectors = (int)ceil(($endAngle - $startAngle)/M_PI_4); $clipRadius = max($x2 - $x1, $y2 - $y1); for($count = 0; $count <= $clipSectors; $count++) { $pAngle = $startAngle + ($endAngle - $startAngle)*$count/(float)$clipSectors; $pX = new Zend_Pdf_Element_Numeric($x + cos($pAngle)*$clipRadius); $pY = new Zend_Pdf_Element_Numeric($y + sin($pAngle)*$clipRadius); $clipPath .= $pX->toString() . ' ' . $pY->toString() . " l\n"; } $this->_contents .= "q\n" . $clipPath . "h\nW\nn\n"; } $xLeft = new Zend_Pdf_Element_Numeric($x1); $xRight = new Zend_Pdf_Element_Numeric($x2); $yUp = new Zend_Pdf_Element_Numeric($y2); $yDown = new Zend_Pdf_Element_Numeric($y1); $xDelta = 2*(M_SQRT2 - 1)*($x2 - $x1)/3.; $yDelta = 2*(M_SQRT2 - 1)*($y2 - $y1)/3.; $xr = new Zend_Pdf_Element_Numeric($x + $xDelta); $xl = new Zend_Pdf_Element_Numeric($x - $xDelta); $yu = new Zend_Pdf_Element_Numeric($y + $yDelta); $yd = new Zend_Pdf_Element_Numeric($y - $yDelta); $this->_contents .= $xC->toString() . ' ' . $yUp->toString() . " m\n" . $xr->toString() . ' ' . $yUp->toString() . ' ' . $xRight->toString() . ' ' . $yu->toString() . ' ' . $xRight->toString() . ' ' . $yC->toString() . " c\n" . $xRight->toString() . ' ' . $yd->toString() . ' ' . $xr->toString() . ' ' . $yDown->toString() . ' ' . $xC->toString() . ' ' . $yDown->toString() . " c\n" . $xl->toString() . ' ' . $yDown->toString() . ' ' . $xLeft->toString() . ' ' . $yd->toString() . ' ' . $xLeft->toString() . ' ' . $yC->toString() . " c\n" . $xLeft->toString() . ' ' . $yu->toString() . ' ' . $xl->toString() . ' ' . $yUp->toString() . ' ' . $xC->toString() . ' ' . $yUp->toString() . " c\n"; switch ($fillType) { case Zend_Pdf_Page::SHAPE_DRAW_FILL_AND_STROKE: $this->_contents .= " B*\n"; break; case Zend_Pdf_Page::SHAPE_DRAW_FILL: $this->_contents .= " f*\n"; break; case Zend_Pdf_Page::SHAPE_DRAW_STROKE: $this->_contents .= " S\n"; break; } if ($startAngle !== null) { $this->_contents .= "Q\n"; } return $this; } public function drawImage(Zend_Pdf_Resource_Image $image, $x1, $y1, $x2, $y2) { $this->_addProcSet('PDF'); $imageName = $this->_attachResource('XObject', $image); $imageNameObj = new Zend_Pdf_Element_Name($imageName); $x1Obj = new Zend_Pdf_Element_Numeric($x1); $y1Obj = new Zend_Pdf_Element_Numeric($y1); $widthObj = new Zend_Pdf_Element_Numeric($x2 - $x1); $heightObj = new Zend_Pdf_Element_Numeric($y2 - $y1); $this->_contents .= "q\n" . '1 0 0 1 ' . $x1Obj->toString() . ' ' . $y1Obj->toString() . " cm\n" . $widthObj->toString() . ' 0 0 ' . $heightObj->toString() . " 0 0 cm\n" . $imageNameObj->toString() . " Do\n" . "Q\n"; return $this; } public function drawLayoutBox($box, $x, $y) { return $this; } public function drawLine($x1, $y1, $x2, $y2) { $this->_addProcSet('PDF'); $x1Obj = new Zend_Pdf_Element_Numeric($x1); $y1Obj = new Zend_Pdf_Element_Numeric($y1); $x2Obj = new Zend_Pdf_Element_Numeric($x2); $y2Obj = new Zend_Pdf_Element_Numeric($y2); $this->_contents .= $x1Obj->toString() . ' ' . $y1Obj->toString() . " m\n" . $x2Obj->toString() . ' ' . $y2Obj->toString() . " l\n S\n"; return $this; } public function drawPolygon($x, $y, $fillType = Zend_Pdf_Page::SHAPE_DRAW_FILL_AND_STROKE, $fillMethod = Zend_Pdf_Page::FILL_METHOD_NON_ZERO_WINDING) { $this->_addProcSet('PDF'); $firstPoint = true; foreach ($x as $id => $xVal) { $xObj = new Zend_Pdf_Element_Numeric($xVal); $yObj = new Zend_Pdf_Element_Numeric($y[$id]); if ($firstPoint) { $path = $xObj->toString() . ' ' . $yObj->toString() . " m\n"; $firstPoint = false; } else { $path .= $xObj->toString() . ' ' . $yObj->toString() . " l\n"; } } $this->_contents .= $path; switch ($fillType) { case Zend_Pdf_Page::SHAPE_DRAW_FILL_AND_STROKE: if ($fillMethod == Zend_Pdf_Page::FILL_METHOD_NON_ZERO_WINDING) { $this->_contents .= " b\n"; } else { $this->_contents .= " b*\n"; } break; case Zend_Pdf_Page::SHAPE_DRAW_FILL: if ($fillMethod == Zend_Pdf_Page::FILL_METHOD_NON_ZERO_WINDING) { $this->_contents .= " h\n f\n"; } else { $this->_contents .= " h\n f*\n"; } break; case Zend_Pdf_Page::SHAPE_DRAW_STROKE: $this->_contents .= " S\n"; break; } return $this; } public function drawRectangle($x1, $y1, $x2, $y2, $fillType = Zend_Pdf_Page::SHAPE_DRAW_FILL_AND_STROKE) { $this->_addProcSet('PDF'); $x1Obj = new Zend_Pdf_Element_Numeric($x1); $y1Obj = new Zend_Pdf_Element_Numeric($y1); $widthObj = new Zend_Pdf_Element_Numeric($x2 - $x1); $height2Obj = new Zend_Pdf_Element_Numeric($y2 - $y1); $this->_contents .= $x1Obj->toString() . ' ' . $y1Obj->toString() . ' ' . $widthObj->toString() . ' ' . $height2Obj->toString() . " re\n"; switch ($fillType) { case Zend_Pdf_Page::SHAPE_DRAW_FILL_AND_STROKE: $this->_contents .= " B*\n"; break; case Zend_Pdf_Page::SHAPE_DRAW_FILL: $this->_contents .= " f*\n"; break; case Zend_Pdf_Page::SHAPE_DRAW_STROKE: $this->_contents .= " S\n"; break; } return $this; } public function drawRoundedRectangle($x1, $y1, $x2, $y2, $radius, $fillType = Zend_Pdf_Page::SHAPE_DRAW_FILL_AND_STROKE) { $this->_addProcSet('PDF'); if(!is_array($radius)) { $radius = array($radius, $radius, $radius, $radius); } else { for ($i = 0; $i < 4; $i++) { if(!isset($radius[$i])) { $radius[$i] = 0; } } } $topLeftX = $x1; $topLeftY = $y2; $topRightX = $x2; $topRightY = $y2; $bottomRightX = $x2; $bottomRightY = $y1; $bottomLeftX = $x1; $bottomLeftY = $y1; $x1Obj = new Zend_Pdf_Element_Numeric($topLeftX + $radius[0]); $y1Obj = new Zend_Pdf_Element_Numeric($topLeftY); $this->_contents .= $x1Obj->toString() . ' ' . $y1Obj->toString() . " m\n"; $x1Obj = new Zend_Pdf_Element_Numeric($topRightX - $radius[1]); $y1Obj = new Zend_Pdf_Element_Numeric($topRightY); $this->_contents .= $x1Obj->toString() . ' ' . $y1Obj->toString() . " l\n"; if ($radius[1] != 0) { $x1Obj = new Zend_Pdf_Element_Numeric($topRightX); $y1Obj = new Zend_Pdf_Element_Numeric($topRightY); $x2Obj = new Zend_Pdf_Element_Numeric($topRightX); $y2Obj = new Zend_Pdf_Element_Numeric($topRightY); $x3Obj = new Zend_Pdf_Element_Numeric($topRightX); $y3Obj = new Zend_Pdf_Element_Numeric($topRightY - $radius[1]); $this->_contents .= $x1Obj->toString() . ' ' . $y1Obj->toString() . ' ' . $x2Obj->toString() . ' ' . $y2Obj->toString() . ' ' . $x3Obj->toString() . ' ' . $y3Obj->toString() . ' ' . " c\n"; } $x1Obj = new Zend_Pdf_Element_Numeric($bottomRightX); $y1Obj = new Zend_Pdf_Element_Numeric($bottomRightY + $radius[2]); $this->_contents .= $x1Obj->toString() . ' ' . $y1Obj->toString() . " l\n"; if ($radius[2] != 0) { $x1Obj = new Zend_Pdf_Element_Numeric($bottomRightX); $y1Obj = new Zend_Pdf_Element_Numeric($bottomRightY); $x2Obj = new Zend_Pdf_Element_Numeric($bottomRightX); $y2Obj = new Zend_Pdf_Element_Numeric($bottomRightY); $x3Obj = new Zend_Pdf_Element_Numeric($bottomRightX - $radius[2]); $y3Obj = new Zend_Pdf_Element_Numeric($bottomRightY); $this->_contents .= $x1Obj->toString() . ' ' . $y1Obj->toString() . ' ' . $x2Obj->toString() . ' ' . $y2Obj->toString() . ' ' . $x3Obj->toString() . ' ' . $y3Obj->toString() . ' ' . " c\n"; } $x1Obj = new Zend_Pdf_Element_Numeric($bottomLeftX + $radius[3]); $y1Obj = new Zend_Pdf_Element_Numeric($bottomLeftY); $this->_contents .= $x1Obj->toString() . ' ' . $y1Obj->toString() . " l\n"; if ($radius[3] != 0) { $x1Obj = new Zend_Pdf_Element_Numeric($bottomLeftX); $y1Obj = new Zend_Pdf_Element_Numeric($bottomLeftY); $x2Obj = new Zend_Pdf_Element_Numeric($bottomLeftX); $y2Obj = new Zend_Pdf_Element_Numeric($bottomLeftY); $x3Obj = new Zend_Pdf_Element_Numeric($bottomLeftX); $y3Obj = new Zend_Pdf_Element_Numeric($bottomLeftY + $radius[3]); $this->_contents .= $x1Obj->toString() . ' ' . $y1Obj->toString() . ' ' . $x2Obj->toString() . ' ' . $y2Obj->toString() . ' ' . $x3Obj->toString() . ' ' . $y3Obj->toString() . ' ' . " c\n"; } $x1Obj = new Zend_Pdf_Element_Numeric($topLeftX); $y1Obj = new Zend_Pdf_Element_Numeric($topLeftY - $radius[0]); $this->_contents .= $x1Obj->toString() . ' ' . $y1Obj->toString() . " l\n"; if ($radius[0] != 0) { $x1Obj = new Zend_Pdf_Element_Numeric($topLeftX); $y1Obj = new Zend_Pdf_Element_Numeric($topLeftY); $x2Obj = new Zend_Pdf_Element_Numeric($topLeftX); $y2Obj = new Zend_Pdf_Element_Numeric($topLeftY); $x3Obj = new Zend_Pdf_Element_Numeric($topLeftX + $radius[0]); $y3Obj = new Zend_Pdf_Element_Numeric($topLeftY); $this->_contents .= $x1Obj->toString() . ' ' . $y1Obj->toString() . ' ' . $x2Obj->toString() . ' ' . $y2Obj->toString() . ' ' . $x3Obj->toString() . ' ' . $y3Obj->toString() . ' ' . " c\n"; } switch ($fillType) { case Zend_Pdf_Page::SHAPE_DRAW_FILL_AND_STROKE: $this->_contents .= " B*\n"; break; case Zend_Pdf_Page::SHAPE_DRAW_FILL: $this->_contents .= " f*\n"; break; case Zend_Pdf_Page::SHAPE_DRAW_STROKE: $this->_contents .= " S\n"; break; } return $this; } public function drawText($text, $x, $y, $charEncoding = '') { if ($this->_font === null) { throw new Zend_Pdf_Exception('Font has not been set'); } $this->_addProcSet('Text'); $textObj = new Zend_Pdf_Element_String($this->_font->encodeString($text, $charEncoding)); $xObj = new Zend_Pdf_Element_Numeric($x); $yObj = new Zend_Pdf_Element_Numeric($y); $this->_contents .= "BT\n" . $xObj->toString() . ' ' . $yObj->toString() . " Td\n" . $textObj->toString() . " Tj\n" . "ET\n"; return $this; } public function pathClose() { return $this; } public function pathLine($x, $y) { return $this; } public function pathMove($x, $y) { return $this; } public function rotate($x, $y, $angle) { $cos = new Zend_Pdf_Element_Numeric(cos($angle)); $sin = new Zend_Pdf_Element_Numeric(sin($angle)); $mSin = new Zend_Pdf_Element_Numeric(-$sin->value); $xObj = new Zend_Pdf_Element_Numeric($x); $yObj = new Zend_Pdf_Element_Numeric($y); $mXObj = new Zend_Pdf_Element_Numeric(-$x); $mYObj = new Zend_Pdf_Element_Numeric(-$y); $this->_addProcSet('PDF'); $this->_contents .= '1 0 0 1 ' . $xObj->toString() . ' ' . $yObj->toString() . " cm\n" . $cos->toString() . ' ' . $sin->toString() . ' ' . $mSin->toString() . ' ' . $cos->toString() . " 0 0 cm\n" . '1 0 0 1 ' . $mXObj->toString() . ' ' . $mYObj->toString() . " cm\n"; return $this; } public function scale($xScale, $yScale) { $xScaleObj = new Zend_Pdf_Element_Numeric($xScale); $yScaleObj = new Zend_Pdf_Element_Numeric($yScale); $this->_addProcSet('PDF'); $this->_contents .= $xScaleObj->toString() . ' 0 0 ' . $yScaleObj->toString() . " 0 0 cm\n"; return $this; } public function translate($xShift, $yShift) { $xShiftObj = new Zend_Pdf_Element_Numeric($xShift); $yShiftObj = new Zend_Pdf_Element_Numeric($yShift); $this->_addProcSet('PDF'); $this->_contents .= '1 0 0 1 ' . $xShiftObj->toString() . ' ' . $yShiftObj->toString() . " cm\n"; return $this; } public function skew($x, $y, $xAngle, $yAngle) { $tanXObj = new Zend_Pdf_Element_Numeric(tan($xAngle)); $tanYObj = new Zend_Pdf_Element_Numeric(-tan($yAngle)); $xObj = new Zend_Pdf_Element_Numeric($x); $yObj = new Zend_Pdf_Element_Numeric($y); $mXObj = new Zend_Pdf_Element_Numeric(-$x); $mYObj = new Zend_Pdf_Element_Numeric(-$y); $this->_addProcSet('PDF'); $this->_contents .= '1 0 0 1 ' . $xObj->toString() . ' ' . $yObj->toString() . " cm\n" . '1 ' . $tanXObj->toString() . ' ' . $tanYObj->toString() . " 1 0 0 cm\n" . '1 0 0 1 ' . $mXObj->toString() . ' ' . $mYObj->toString() . " cm\n"; return $this; } public function rawWrite($data, $procSet = null) { if (! empty($procSet)) { $this->_addProcSet($procSet); } $this->_contents .= $data; return $this; } }

/* @source /library/Zend/Pdf/Resource/Image.php */
abstract class Zend_Pdf_Resource_Image extends Zend_Pdf_Resource { public function __construct() { parent::__construct(''); $this->_resource->dictionary->Type = new Zend_Pdf_Element_Name('XObject'); $this->_resource->dictionary->Subtype = new Zend_Pdf_Element_Name('Image'); } abstract public function getPixelHeight(); abstract public function getPixelWidth(); abstract public function getProperties(); }

/* @source /library/Zend/Pdf/Resource/Font.php */
abstract class Zend_Pdf_Resource_Font extends Zend_Pdf_Resource { protected $_fontType = Zend_Pdf_Font::TYPE_UNKNOWN; protected $_fontNames = array(); protected $_isBold = false; protected $_isItalic = false; protected $_isMonospace = false; protected $_underlinePosition = 0; protected $_underlineThickness = 0; protected $_strikePosition = 0; protected $_strikeThickness = 0; protected $_unitsPerEm = 0; protected $_ascent = 0; protected $_descent = 0; protected $_lineGap = 0; public function __construct() { parent::__construct(new Zend_Pdf_Element_Dictionary()); $this->_resource->Type = new Zend_Pdf_Element_Name('Font'); } public function __toString() { return $this->getFontName(Zend_Pdf_Font::NAME_FULL, '', '//TRANSLIT'); } public function getFontType() { return $this->_fontType; } public function getFontName($nameType, $language, $characterSet = null) { if (! isset($this->_fontNames[$nameType])) { return null; } $name = null; if (is_array($language)) { foreach ($language as $code) { if (isset($this->_fontNames[$nameType][$code])) { $name = $this->_fontNames[$nameType][$code]; break; } } } else { if (isset($this->_fontNames[$nameType][$language])) { $name = $this->_fontNames[$nameType][$language]; } } if ($name === null) { $names = $this->_fontNames[$nameType]; $name = reset($names); } if (($characterSet !== null) && ($characterSet != 'UTF-16BE') && PHP_OS != 'AIX') { $name = iconv('UTF-16BE', $characterSet, $name); } return $name; } public function getFontNames() { return $this->_fontNames; } public function isBold() { return $this->_isBold; } public function isItalic() { return $this->_isItalic; } public function isMonospace() { return $this->_isMonospace; } public function getUnderlinePosition() { return $this->_underlinePosition; } public function getUnderlineThickness() { return $this->_underlineThickness; } public function getStrikePosition() { return $this->_strikePosition; } public function getStrikeThickness() { return $this->_strikeThickness; } public function getUnitsPerEm() { return $this->_unitsPerEm; } public function getAscent() { return $this->_ascent; } public function getDescent() { return $this->_descent; } public function getLineGap() { return $this->_lineGap; } public function getLineHeight() { return $this->_ascent - $this->_descent + $this->_lineGap; } abstract public function glyphNumbersForCharacters($characterCodes); abstract public function glyphNumberForCharacter($characterCode); abstract public function getCoveredPercentage($string, $charEncoding = ''); abstract public function widthsForGlyphs($glyphNumbers); abstract public function widthForGlyph($glyphNumber); abstract public function encodeString($string, $charEncoding); abstract public function decodeString($string, $charEncoding); public function toEmSpace($value) { if ($this->_unitsPerEm == 1000) { return $value; } return ceil(($value / $this->_unitsPerEm) * 1000); } }

/* @source /library/Zend/Pdf/Destination/Explicit.php */
abstract class Zend_Pdf_Destination_Explicit extends Zend_Pdf_Destination { protected $_destinationArray; protected $_isRemote; public function __construct(Zend_Pdf_Element $destinationArray) { if ($destinationArray->getType() != Zend_Pdf_Element::TYPE_ARRAY) { throw new Zend_Pdf_Exception('Explicit destination resource Array must be a direct or an indirect array object.'); } $this->_destinationArray = $destinationArray; switch (count($this->_destinationArray->items)) { case 0: throw new Zend_Pdf_Exception('Destination array must contain a page reference.'); break; case 1: throw new Zend_Pdf_Exception('Destination array must contain a destination type name.'); break; default: break; } switch ($this->_destinationArray->items[0]->getType()) { case Zend_Pdf_Element::TYPE_NUMERIC: $this->_isRemote = true; break; case Zend_Pdf_Element::TYPE_DICTIONARY: $this->_isRemote = false; break; default: throw new Zend_Pdf_Exception('Destination target must be a page number or page dictionary object.'); break; } } public function isRemote() { return $this->_isRemote; } public function getResource() { return $this->_destinationArray; } }

/* @source /library/Zend/Pdf/FileParser/Font/OpenType.php */
abstract class Zend_Pdf_FileParser_Font_OpenType extends Zend_Pdf_FileParser_Font { protected $_scalerType = 0; protected $_tableDirectory = array(); public function screen() { if ($this->_isScreened) { return; } $this->_readScalerType(); } public function parse() { if ($this->_isParsed) { return; } $this->screen(); $this->_parseTableDirectory(); $this->_parseHeadTable(); $this->_parseNameTable(); $this->_parsePostTable(); $this->_parseHheaTable(); $this->_parseMaxpTable(); $this->_parseOs2Table(); $this->_parseHmtxTable(); $this->_parseCmapTable(); } protected function _parseTableDirectory() { $this->moveToOffset(4); $tableCount = $this->readUInt(2); $this->_debugLog('%d tables', $tableCount); if (($tableCount < 7) || ($tableCount > 50)) { throw new Zend_Pdf_Exception('Table count not within expected range', Zend_Pdf_Exception::BAD_TABLE_COUNT); } $this->skipBytes(6); for ($tableIndex = 0; $tableIndex < $tableCount; $tableIndex++) { $tableName = $this->readBytes(4); $this->skipBytes(4); $tableOffset = $this->readUInt(4); $tableLength = $this->readUInt(4); $this->_debugLog('%s offset: 0x%x; length: %d', $tableName, $tableOffset, $tableLength); $fileSize = $this->_dataSource->getSize(); if (($tableOffset < 0) || ($tableOffset > $fileSize)) { throw new Zend_Pdf_Exception("Table offset ($tableOffset) not within expected range", Zend_Pdf_Exception::INDEX_OUT_OF_RANGE); } if (($tableLength < 0) || (($tableOffset + $tableLength) > $fileSize)) { throw new Zend_Pdf_Exception("Table length ($tableLength) not within expected range", Zend_Pdf_Exception::INDEX_OUT_OF_RANGE); } $this->_tableDirectory[$tableName]['offset'] = $tableOffset; $this->_tableDirectory[$tableName]['length'] = $tableLength; } } protected function _parseHeadTable() { $this->_jumpToTable('head'); $tableVersion = $this->_readTableVersion(1, 1); $this->skipBytes(8); $magicNumber = $this->readUInt(4); if ($magicNumber != 0x5f0f3cf5) { throw new Zend_Pdf_Exception('Wrong magic number. Expected: 0x5f0f3cf5; actual: ' . sprintf('%x', $magicNumber), Zend_Pdf_Exception::BAD_MAGIC_NUMBER); } $flags = $this->readUInt(2); $this->baselineAtZero = $this->isBitSet(0, $flags); $this->useIntegerScaling = $this->isBitSet(3, $flags); $this->unitsPerEm = $this->readUInt(2); $this->_debugLog('Units per em: %d', $this->unitsPerEm); $this->skipBytes(16); $this->xMin = $this->readInt(2); $this->yMin = $this->readInt(2); $this->xMax = $this->readInt(2); $this->yMax = $this->readInt(2); $this->_debugLog('Font bounding box: %d %d %d %d', $this->xMin, $this->yMin, $this->xMax, $this->yMax); $macStyleBits = $this->readUInt(2); $this->isBold = $this->isBitSet(0, $macStyleBits); $this->isItalic = $this->isBitSet(1, $macStyleBits); } protected function _parseNameTable() { $this->_jumpToTable('name'); $baseOffset = $this->_tableDirectory['name']['offset']; $tableFormat = $this->readUInt(2); if ($tableFormat != 0) { throw new Zend_Pdf_Exception("Unable to read format $tableFormat table", Zend_Pdf_Exception::DONT_UNDERSTAND_TABLE_VERSION); } $this->_debugLog('Format %d table', $tableFormat); $nameCount = $this->readUInt(2); $this->_debugLog('%d name strings', $nameCount); $storageOffset = $this->readUInt(2) + $baseOffset; $this->_debugLog('Storage offset: 0x%x', $storageOffset); $nameRecords = array(); for ($nameIndex = 0; $nameIndex < $nameCount; $nameIndex++) { $platformID = $this->readUInt(2); $encodingID = $this->readUInt(2); if (! ( (($platformID == 3) && ($encodingID == 1)) || (($platformID == 1) && ($encodingID == 0)) ) ) { $this->skipBytes(8); continue; } $languageID = $this->readUInt(2); $nameID = $this->readUInt(2); $nameLength = $this->readUInt(2); $nameOffset = $this->readUInt(2); $languageCode = $this->_languageCodeForPlatform($platformID, $languageID); if ($languageCode === null) { $this->_debugLog('Skipping languageID: 0x%x; platformID %d', $languageID, $platformID); continue; } $this->_debugLog('Adding nameID: %d; languageID: 0x%x; platformID: %d; offset: 0x%x (0x%x); length: %d', $nameID, $languageID, $platformID, $baseOffset + $nameOffset, $nameOffset, $nameLength); $nameRecords[$nameID][$languageCode] = array('platform' => $platformID, 'offset' => $nameOffset, 'length' => $nameLength ); } $fontNames = array(); foreach ($nameRecords as $name => $languages) { foreach ($languages as $language => $attributes) { $stringOffset = $storageOffset + $attributes['offset']; $this->moveToOffset($stringOffset); if ($attributes['platform'] == 3) { $string = $this->readStringUTF16($attributes['length']); } else { $string = $this->readStringMacRoman($attributes['length']); } $fontNames[$name][$language] = $string; } } $this->names = $fontNames; } protected function _parsePostTable() { $this->_jumpToTable('post'); $tableVersion = $this->_readTableVersion(1, 4); $this->italicAngle = $this->readFixed(16, 16); $this->underlinePosition = $this->readInt(2); $this->underlineThickness = $this->readInt(2); $fixedPitch = $this->readUInt(4); $this->isMonospaced = ($fixedPitch !== 0); $this->skipBytes(16); } protected function _parseHheaTable() { $this->_jumpToTable('hhea'); $tableVersion = $this->_readTableVersion(1, 1); $this->ascent = $this->readInt(2); $this->descent = $this->readInt(2); $this->lineGap = $this->readInt(2); if ($this->descent > 0) { $this->_debugLog('Warning: Font should specify negative descent. Actual: %d; Using %d', $this->descent, -$this->descent); $this->descent = -$this->descent; } $this->skipBytes(22); $this->metricDataFormat = $this->readInt(2); $this->numberHMetrics = $this->readUInt(2); $this->_debugLog('hmtx data format: %d; number of metrics: %d', $this->metricDataFormat, $this->numberHMetrics); } protected function _parseMaxpTable() { $this->_jumpToTable('maxp'); $this->_readTableVersion(0, 1); $this->numGlyphs = $this->readUInt(2); $this->_debugLog('number of glyphs: %d', $this->numGlyphs); } protected function _parseOs2Table() { if (! $this->numberHMetrics) { throw new Zend_Pdf_Exception("hhea table must be parsed prior to calling this method", Zend_Pdf_Exception::PARSED_OUT_OF_ORDER); } try { $this->_jumpToTable('OS/2'); } catch (Zend_Pdf_Exception $e) { if ($e->getCode() == Zend_Pdf_Exception::REQUIRED_TABLE_NOT_FOUND) { $this->_debugLog('No OS/2 table found. Using default values'); $this->fontWeight = Zend_Pdf_Font::WEIGHT_NORMAL; $this->fontWidth = Zend_Pdf_Font::WIDTH_NORMAL; $this->isEmbeddable = true; $this->isSubsettable = true; $this->strikeThickness = $this->unitsPerEm * 0.05; $this->strikePosition = $this->unitsPerEm * 0.225; $this->isSerifFont = false; $this->isSansSerifFont = false; $this->isOrnamentalFont = false; $this->isScriptFont = false; $this->isSymbolicFont = false; $this->isAdobeLatinSubset = false; $this->vendorID = ''; $this->xHeight = 0; $this->capitalHeight = 0; return; } else { throw $e; throw new Zend_Pdf_Exception($e->getMessage(), $e->getCode(), $e); } } $tableVersion = $this->readUInt(2); if (($tableVersion < 0) || ($tableVersion > 3)) { throw new Zend_Pdf_Exception("Unable to read version $tableVersion table", Zend_Pdf_Exception::DONT_UNDERSTAND_TABLE_VERSION); } $this->_debugLog('Version %d table', $tableVersion); $this->averageCharWidth = $this->readInt(2); $this->fontWeight = $this->readUInt(2); $this->fontWidth = $this->readUInt(2); $embeddingFlags = $this->readUInt(2); $this->_debugLog('Embedding flags: %d', $embeddingFlags); if ($this->isBitSet(9, $embeddingFlags)) { $this->isEmbeddable = false; } elseif ($this->isBitSet(2, $embeddingFlags) || $this->isBitSet(3, $embeddingFlags) || $this->isBitSet(4, $embeddingFlags) ) { $this->isEmbeddable = true; } elseif ($this->isBitSet(1, $embeddingFlags)) { $this->isEmbeddable = false; } else { $this->isEmbeddable = true; } $this->_debugLog('Font ' . ($this->isEmbeddable ? 'may' : 'may not') . ' be embedded'); $isSubsettable = $this->isBitSet($embeddingFlags, 8); $this->subscriptXSize = $this->readInt(2); $this->subscriptYSize = $this->readInt(2); $this->subscriptXOffset = $this->readInt(2); $this->subscriptYOffset = $this->readInt(2); $this->superscriptXSize = $this->readInt(2); $this->superscriptYSize = $this->readInt(2); $this->superscriptXOffset = $this->readInt(2); $this->superscriptYOffset = $this->readInt(2); $this->strikeThickness = $this->readInt(2); $this->strikePosition = $this->readInt(2); $familyClass = ($this->readUInt(2) >> 8); $this->_debugLog('Font family class: %d', $familyClass); $this->isSerifFont = ((($familyClass >= 1) && ($familyClass <= 5)) || ($familyClass == 7)); $this->isSansSerifFont = ($familyClass == 8); $this->isOrnamentalFont = ($familyClass == 9); $this->isScriptFont = ($familyClass == 10); $this->isSymbolicFont = ($familyClass == 12); $this->skipBytes(10); $unicodeRange1 = $this->readUInt(4); $unicodeRange2 = $this->readUInt(4); $unicodeRange3 = $this->readUInt(4); $unicodeRange4 = $this->readUInt(4); $this->_debugLog('Unicode ranges: 0x%x 0x%x 0x%x 0x%x', $unicodeRange1, $unicodeRange2, $unicodeRange3, $unicodeRange4); $this->isAdobeLatinSubset = (($unicodeRange1 == 1) && ($unicodeRange2 == 0) && ($unicodeRange3 == 0) && ($unicodeRange4 == 0)); $this->_debugLog(($this->isAdobeLatinSubset ? 'Is' : 'Is not') . ' a subset of Adobe Latin'); $this->vendorID = $this->readBytes(4); $this->skipBytes(6); $this->ascent = $this->readInt(2); $this->descent = $this->readInt(2); $this->lineGap = $this->readInt(2); if ($this->descent > 0) { $this->_debugLog('Warning: Font should specify negative descent. Actual: %d; Using %d', $this->descent, -$this->descent); $this->descent = -$this->descent; } $this->skipBytes(4); if ($tableVersion < 2) { $this->xHeight = 0; $this->capitalHeight = 0; } else { $this->skipBytes(8); $this->xHeight = $this->readInt(2); $this->capitalHeight = $this->readInt(2); } } protected function _parseHmtxTable() { $this->_jumpToTable('hmtx'); if (! $this->numberHMetrics) { throw new Zend_Pdf_Exception("hhea table must be parsed prior to calling this method", Zend_Pdf_Exception::PARSED_OUT_OF_ORDER); } if ($this->metricDataFormat != 0) { throw new Zend_Pdf_Exception("Unable to read format $this->metricDataFormat table.", Zend_Pdf_Exception::DONT_UNDERSTAND_TABLE_VERSION); } $glyphWidths = array(); for ($i = 0; $i < $this->numberHMetrics; $i++) { $glyphWidths[$i] = $this->readUInt(2); $this->skipBytes(2); } while (count($glyphWidths) < $this->numGlyphs) { $glyphWidths[] = end($glyphWidths); } $this->glyphWidths = $glyphWidths; } protected function _parseCmapTable() { $this->_jumpToTable('cmap'); $baseOffset = $this->_tableDirectory['cmap']['offset']; $tableVersion = $this->readUInt(2); if ($tableVersion != 0) { throw new Zend_Pdf_Exception("Unable to read version $tableVersion table", Zend_Pdf_Exception::DONT_UNDERSTAND_TABLE_VERSION); } $this->_debugLog('Version %d table', $tableVersion); $subtableCount = $this->readUInt(2); $this->_debugLog('%d subtables', $subtableCount); $subtables = array(); for ($subtableIndex = 0; $subtableIndex < $subtableCount; $subtableIndex++) { $platformID = $this->readUInt(2); $encodingID = $this->readUInt(2); if (! ( (($platformID == 0) && ($encodingID == 3)) || (($platformID == 0) && ($encodingID == 0)) || (($platformID == 3) && ($encodingID == 1)) || (($platformID == 1) && ($encodingID == 0)) ) ) { $this->_debugLog('Unsupported encoding: platformID: %d; encodingID: %d; skipping', $platformID, $encodingID); $this->skipBytes(4); continue; } $subtableOffset = $this->readUInt(4); if ($subtableOffset < 0) { $this->_debugLog('Offset 0x%x out of range for platformID: %d; skipping', $subtableOffset, $platformID); continue; } $this->_debugLog('Found subtable; platformID: %d; encodingID: %d; offset: 0x%x (0x%x)', $platformID, $encodingID, $baseOffset + $subtableOffset, $subtableOffset); $subtables[$platformID][$encodingID][] = $subtableOffset; } $offsets = array(); if (isset($subtables[0][3])) { foreach ($subtables[0][3] as $offset) { $offsets[] = $offset; } } if (isset($subtables[0][0])) { foreach ($subtables[0][0] as $offset) { $offsets[] = $offset; } } if (isset($subtables[3][1])) { foreach ($subtables[3][1] as $offset) { $offsets[] = $offset; } } if (isset($subtables[1][0])) { foreach ($subtables[1][0] as $offset) { $offsets[] = $offset; } } $cmapType = -1; foreach ($offsets as $offset) { $cmapOffset = $baseOffset + $offset; $this->moveToOffset($cmapOffset); $format = $this->readUInt(2); $language = -1; switch ($format) { case 0x0: $cmapLength = $this->readUInt(2); $language = $this->readUInt(2); if ($language != 0) { $this->_debugLog('Type 0 cmap tables must be language-independent;' . ' language: %d; skipping', $language); continue; } break; case 0x4: case 0x6: $cmapLength = $this->readUInt(2); $language = $this->readUInt(2); if ($language != 0) { $this->_debugLog('Warning: cmap tables must be language-independent - this font' . ' may not work properly; language: %d', $language); } break; case 0x2: case 0x8: case 0xa: case 0xc: $this->_debugLog('Format: 0x%x currently unsupported; skipping', $format); continue; default: $this->_debugLog('Unknown subtable format: 0x%x; skipping', $format); continue; } $cmapType = $format; break; } if ($cmapType == -1) { throw new Zend_Pdf_Exception('Unable to find usable cmap table', Zend_Pdf_Exception::CANT_FIND_GOOD_CMAP); } $this->_debugLog('Using cmap type %d; offset: 0x%x; length: %d', $cmapType, $cmapOffset, $cmapLength); $this->moveToOffset($cmapOffset); $cmapData = $this->readBytes($cmapLength); $this->cmap = Zend_Pdf_Cmap::cmapWithTypeData($cmapType, $cmapData); } protected function _readScalerType() { if ($this->_scalerType != 0) { return $this->_scalerType; } $this->moveToOffset(0); $this->_scalerType = $this->readUInt(4); switch ($this->_scalerType) { case 0x00010000: $this->_debugLog('Windows TrueType signature'); break; case 0x74727565: $this->_debugLog('Macintosh TrueType signature'); break; case 0x4f54544f: $this->_debugLog('PostScript CFF signature'); break; case 0x74797031: throw new Zend_Pdf_Exception('Unsupported font type: PostScript in sfnt wrapper', Zend_Pdf_Exception::WRONG_FONT_TYPE); default: throw new Zend_Pdf_Exception('Not an OpenType font file', Zend_Pdf_Exception::WRONG_FONT_TYPE); } return $this->_scalerType; } protected function _jumpToTable($tableName) { if (empty($this->_tableDirectory[$tableName])) { throw new Zend_Pdf_Exception("Required table '$tableName' not found!", Zend_Pdf_Exception::REQUIRED_TABLE_NOT_FOUND); } $this->_debugLog("Parsing $tableName table..."); $this->moveToOffset($this->_tableDirectory[$tableName]['offset']); } protected function _readTableVersion($minVersion, $maxVersion) { $tableVersion = $this->readFixed(16, 16); if (($tableVersion < $minVersion) || ($tableVersion > $maxVersion)) { throw new Zend_Pdf_Exception("Unable to read version $tableVersion table", Zend_Pdf_Exception::DONT_UNDERSTAND_TABLE_VERSION); } $this->_debugLog('Version %.2f table', $tableVersion); return $tableVersion; } protected function _languageCodeForPlatform($platformID, $languageID) { if ($platformID == 3) { $languageID &= 0xff; switch ($languageID) { case 0x09: return 'en'; case 0x0c: return 'fr'; case 0x07: return 'de'; case 0x10: return 'it'; case 0x13: return 'nl'; case 0x1d: return 'sv'; case 0x0a: return 'es'; case 0x06: return 'da'; case 0x16: return 'pt'; case 0x14: return 'no'; case 0x0d: return 'he'; case 0x11: return 'ja'; case 0x01: return 'ar'; case 0x0b: return 'fi'; case 0x08: return 'el'; default: return null; } } else if ($platformID == 1) { switch ($languageID) { case 0: return 'en'; case 1: return 'fr'; case 2: return 'de'; case 3: return 'it'; case 4: return 'nl'; case 5: return 'sv'; case 6: return 'es'; case 7: return 'da'; case 8: return 'pt'; case 9: return 'no'; case 10: return 'he'; case 11: return 'ja'; case 12: return 'ar'; case 13: return 'fi'; case 14: return 'el'; default: return null; } } else { return null; } } }

/* @source /library/Zend/Pdf/Resource/Font/CidFont.php */
abstract class Zend_Pdf_Resource_Font_CidFont extends Zend_Pdf_Resource_Font { protected $_cmap = null; protected $_charWidths = null; protected $_missingCharWidth = 0; public function __construct(Zend_Pdf_FileParser_Font_OpenType $fontParser) { parent::__construct(); $fontParser->parse(); $this->_fontNames = $fontParser->names; $this->_isBold = $fontParser->isBold; $this->_isItalic = $fontParser->isItalic; $this->_isMonospaced = $fontParser->isMonospaced; $this->_underlinePosition = $fontParser->underlinePosition; $this->_underlineThickness = $fontParser->underlineThickness; $this->_strikePosition = $fontParser->strikePosition; $this->_strikeThickness = $fontParser->strikeThickness; $this->_unitsPerEm = $fontParser->unitsPerEm; $this->_ascent = $fontParser->ascent; $this->_descent = $fontParser->descent; $this->_lineGap = $fontParser->lineGap; $this->_cmap = $fontParser->cmap; $baseFont = $this->getFontName(Zend_Pdf_Font::NAME_POSTSCRIPT, 'en', 'UTF-8'); $this->_resource->BaseFont = new Zend_Pdf_Element_Name($baseFont); $glyphWidths = $fontParser->glyphWidths; $charGlyphs = $this->_cmap->getCoveredCharactersGlyphs(); $charWidths = array(); foreach ($charGlyphs as $charCode => $glyph) { if(isset($glyphWidths[$glyph]) && !is_null($glyphWidths[$glyph])) { $charWidths[$charCode] = $glyphWidths[$glyph]; } } $this->_charWidths = $charWidths; $this->_missingCharWidth = $glyphWidths[0]; $widthFrequencies = array_count_values($charWidths); $defaultWidth = null; $defaultWidthFrequency = -1; foreach ($widthFrequencies as $width => $frequency) { if ($frequency > $defaultWidthFrequency) { $defaultWidth = $width; $defaultWidthFrequency = $frequency; } } $this->_resource->DW = new Zend_Pdf_Element_Numeric($this->toEmSpace($defaultWidth)); $defWidthChars = array_keys($charWidths, $defaultWidth); foreach ($defWidthChars as $charCode) { unset($charWidths[$charCode]); } ksort($charWidths, SORT_NUMERIC); $lastCharCode = -1; $widthsSequences = array(); foreach ($charWidths as $charCode => $width) { if ($lastCharCode == -1) { $charCodesSequense = array(); $sequenceStartCode = $charCode; } else if ($charCode != $lastCharCode + 1) { $widthsSequences[$sequenceStartCode] = $charCodesSequense; $charCodesSequense = array(); $sequenceStartCode = $charCode; } $charCodesSequense[] = $width; $lastCharCode = $charCode; } if (count($charWidths) != 0) { $widthsSequences[$sequenceStartCode] = $charCodesSequense; } $pdfCharsWidths = array(); foreach ($widthsSequences as $startCode => $widthsSequence) { $pdfWidths = array(); $lastWidth = -1; $widthsInSequence = 0; foreach ($widthsSequence as $width) { if ($lastWidth != $width) { if ($widthsInSequence != 0) { $pdfCharsWidths[] = new Zend_Pdf_Element_Numeric($startCode); $pdfCharsWidths[] = new Zend_Pdf_Element_Numeric($startCode + $widthsInSequence - 1); $pdfCharsWidths[] = new Zend_Pdf_Element_Numeric($this->toEmSpace($lastWidth)); $startCode = $startCode + $widthsInSequence; $widthsInSequence = 0; } $pdfWidths[] = new Zend_Pdf_Element_Numeric($this->toEmSpace($width)); $lastWidth = $width; } else { if (count($pdfWidths) != 0) { array_pop($pdfWidths); if (count($pdfWidths) != 0) { $pdfCharsWidths[] = new Zend_Pdf_Element_Numeric($startCode); $pdfCharsWidths[] = new Zend_Pdf_Element_Array($pdfWidths); $startCode += count($pdfWidths); $pdfWidths = array(); } $widthsInSequence = 2; } else { $widthsInSequence++; } } } if (count($pdfWidths) != 0) { $pdfCharsWidths[] = new Zend_Pdf_Element_Numeric($startCode); $pdfCharsWidths[] = new Zend_Pdf_Element_Array($pdfWidths); } else if ($widthsInSequence != 0){ $pdfCharsWidths[] = new Zend_Pdf_Element_Numeric($startCode); $pdfCharsWidths[] = new Zend_Pdf_Element_Numeric($startCode + $widthsInSequence - 1); $pdfCharsWidths[] = new Zend_Pdf_Element_Numeric($this->toEmSpace($lastWidth)); } } $widthsArrayElement = new Zend_Pdf_Element_Array($pdfCharsWidths); $widthsObject = $this->_objectFactory->newObject($widthsArrayElement); $this->_resource->W = $widthsObject; $cidSystemInfo = new Zend_Pdf_Element_Dictionary(); $cidSystemInfo->Registry = new Zend_Pdf_Element_String('Adobe'); $cidSystemInfo->Ordering = new Zend_Pdf_Element_String('UCS'); $cidSystemInfo->Supplement = new Zend_Pdf_Element_Numeric(0); $cidSystemInfoObject = $this->_objectFactory->newObject($cidSystemInfo); $this->_resource->CIDSystemInfo = $cidSystemInfoObject; } public function glyphNumbersForCharacters($characterCodes) { throw new Zend_Pdf_Exception('CIDFont PDF objects could not be used as the operand of the text drawing operators'); } public function glyphNumberForCharacter($characterCode) { throw new Zend_Pdf_Exception('CIDFont PDF objects could not be used as the operand of the text drawing operators'); } public function getCoveredPercentage($string, $charEncoding = '') { if ($charEncoding != 'UTF-16BE') { $string = iconv($charEncoding, 'UTF-16BE', $string); } $charCount = iconv_strlen($string, 'UTF-16BE'); if ($charCount == 0) { return 0; } $score = 0; $maxIndex = strlen($string); for ($i = 0; $i < $maxIndex; $i++) { $charCode = (ord($string[$i]) << 8) | ord($string[++$i]); if (isset($this->_charWidths[$charCode])) { $score++; } } return $score / $charCount; } public function widthsForChars($charCodes) { $widths = array(); foreach ($charCodes as $key => $charCode) { if (!isset($this->_charWidths[$charCode])) { $widths[$key] = $this->_missingCharWidth; } else { $widths[$key] = $this->_charWidths[$charCode]; } } return $widths; } public function widthForChar($charCode) { if (!isset($this->_charWidths[$charCode])) { return $this->_missingCharWidth; } return $this->_charWidths[$charCode]; } public function widthsForGlyphs($glyphNumbers) { throw new Zend_Pdf_Exception('CIDFont PDF objects could not be used as the operand of the text drawing operators'); } public function widthForGlyph($glyphNumber) { throw new Zend_Pdf_Exception('CIDFont PDF objects could not be used as the operand of the text drawing operators'); } public function encodeString($string, $charEncoding) { throw new Zend_Pdf_Exception('CIDFont PDF objects could not be used as the operand of the text drawing operators'); } public function decodeString($string, $charEncoding) { throw new Zend_Pdf_Exception('CIDFont PDF objects could not be used as the operand of the text drawing operators'); } }

/* @source /library/Zend/Pdf/Resource/Font/Simple.php */
abstract class Zend_Pdf_Resource_Font_Simple extends Zend_Pdf_Resource_Font { protected $_cmap = null; protected $_glyphWidths = null; protected $_missingGlyphWidth = 0; public function __construct() { parent::__construct(); $this->_resource->Encoding = new Zend_Pdf_Element_Name('WinAnsiEncoding'); } public function glyphNumbersForCharacters($characterCodes) { return $this->_cmap->glyphNumbersForCharacters($characterCodes); } public function glyphNumberForCharacter($characterCode) { return $this->_cmap->glyphNumberForCharacter($characterCode); } public function getCoveredPercentage($string, $charEncoding = '') { if ($charEncoding != 'UTF-16BE') { if (PHP_OS != 'AIX') { $string = iconv($charEncoding, 'UTF-16BE', $string); } } $charCount = (PHP_OS != 'AIX') ? iconv_strlen($string, 'UTF-16BE') : strlen($string); if ($charCount == 0) { return 0; } $coveredCharacters = $this->_cmap->getCoveredCharacters(); $score = 0; $maxIndex = strlen($string); for ($i = 0; $i < $maxIndex; $i++) { $charCode = (ord($string[$i]) << 8) | ord($string[++$i]); if (in_array($charCode, $coveredCharacters)) { $score++; } } return $score / $charCount; } public function widthsForGlyphs($glyphNumbers) { $widths = array(); foreach ($glyphNumbers as $key => $glyphNumber) { if (!isset($this->_glyphWidths[$glyphNumber])) { $widths[$key] = $this->_missingGlyphWidth; } else { $widths[$key] = $this->_glyphWidths[$glyphNumber]; } } return $widths; } public function widthForGlyph($glyphNumber) { if (!isset($this->_glyphWidths[$glyphNumber])) { return $this->_missingGlyphWidth; } return $this->_glyphWidths[$glyphNumber]; } public function encodeString($string, $charEncoding) { if (PHP_OS == 'AIX') { return $string; } return iconv($charEncoding, 'CP1252//IGNORE', $string); } public function decodeString($string, $charEncoding) { return iconv('CP1252', $charEncoding, $string); } }

/* @source /library/Zend/Pdf/Resource/Font/Simple/Standard.php */
abstract class Zend_Pdf_Resource_Font_Simple_Standard extends Zend_Pdf_Resource_Font_Simple { public function __construct() { $this->_fontType = Zend_Pdf_Font::TYPE_STANDARD; parent::__construct(); $this->_resource->Subtype = new Zend_Pdf_Element_Name('Type1'); } }

/* @source /library/Zend/Pdf/Resource/Font/Simple/Parsed.php */
abstract class Zend_Pdf_Resource_Font_Simple_Parsed extends Zend_Pdf_Resource_Font_Simple { public function __construct(Zend_Pdf_FileParser_Font_OpenType $fontParser) { parent::__construct(); $fontParser->parse(); $this->_fontNames = $fontParser->names; $this->_isBold = $fontParser->isBold; $this->_isItalic = $fontParser->isItalic; $this->_isMonospaced = $fontParser->isMonospaced; $this->_underlinePosition = $fontParser->underlinePosition; $this->_underlineThickness = $fontParser->underlineThickness; $this->_strikePosition = $fontParser->strikePosition; $this->_strikeThickness = $fontParser->strikeThickness; $this->_unitsPerEm = $fontParser->unitsPerEm; $this->_ascent = $fontParser->ascent; $this->_descent = $fontParser->descent; $this->_lineGap = $fontParser->lineGap; $this->_glyphWidths = $fontParser->glyphWidths; $this->_missingGlyphWidth = $this->_glyphWidths[0]; $this->_cmap = $fontParser->cmap; $baseFont = $this->getFontName(Zend_Pdf_Font::NAME_POSTSCRIPT, 'en', 'UTF-8'); $this->_resource->BaseFont = new Zend_Pdf_Element_Name($baseFont); $this->_resource->FirstChar = new Zend_Pdf_Element_Numeric(0); $this->_resource->LastChar = new Zend_Pdf_Element_Numeric(count($this->_glyphWidths) - 1); $pdfWidths = array(); foreach ($this->_glyphWidths as $width) { $pdfWidths[] = new Zend_Pdf_Element_Numeric($this->toEmSpace($width)); } $widthsArrayElement = new Zend_Pdf_Element_Array($pdfWidths); $widthsObject = $this->_objectFactory->newObject($widthsArrayElement); $this->_resource->Widths = $widthsObject; } }

/* @source /library/Zend/Pdf.php */
class Zend_Pdf { const PDF_VERSION = '1.4'; const PDF_HEADER = "%PDF-1.4\n%\xE2\xE3\xCF\xD3\n"; public $pages = array(); public $properties = array(); protected $_originalProperties = array(); protected $_javaScript = null; protected $_namedTargets = array(); public $outlines = array(); protected $_originalOutlines = array(); protected $_originalOpenOutlinesCount = 0; protected $_trailer = null; protected $_objFactory = null; protected static $_memoryManager = null; protected $_parser; protected static $_inheritableAttributes = array('Resources', 'MediaBox', 'CropBox', 'Rotate'); protected $_isNewDocument = true; static public function getMemoryManager() { if (self::$_memoryManager === null) { self::$_memoryManager = Zend_Memory::factory('none'); } return self::$_memoryManager; } static public function setMemoryManager(Zend_Memory_Manager $memoryManager) { self::$_memoryManager = $memoryManager; } public static function parse(&$source = null, $revision = null) { return new Zend_Pdf($source, $revision); } public static function load($source = null, $revision = null) { return new Zend_Pdf($source, $revision, true); } public function save($filename, $updateOnly = false) { if (($file = @fopen($filename, $updateOnly ? 'ab':'wb')) === false ) { throw new Zend_Pdf_Exception( "Can not open '$filename' file for writing." ); } $this->render($updateOnly, $file); fclose($file); } public function __construct($source = null, $revision = null, $load = false) { $this->_objFactory = Zend_Pdf_ElementFactory::createFactory(1); if ($source !== null) { $this->_parser = new Zend_Pdf_Parser($source, $this->_objFactory, $load); $this->_pdfHeaderVersion = $this->_parser->getPDFVersion(); $this->_trailer = $this->_parser->getTrailer(); if ($this->_trailer->Encrypt !== null) { throw new Zend_Pdf_Exception('Encrypted document modification is not supported'); } if ($revision !== null) { $this->rollback($revision); } else { $this->_loadPages($this->_trailer->Root->Pages); } $this->_loadNamedDestinations($this->_trailer->Root, $this->_parser->getPDFVersion()); $this->_loadOutlines($this->_trailer->Root); if ($this->_trailer->Info !== null) { $this->properties = $this->_trailer->Info->toPhp(); if (isset($this->properties['Trapped'])) { switch ($this->properties['Trapped']) { case 'True': $this->properties['Trapped'] = true; break; case 'False': $this->properties['Trapped'] = false; break; case 'Unknown': $this->properties['Trapped'] = null; break; default: break; } } $this->_originalProperties = $this->properties; } $this->_isNewDocument = false; } else { $this->_pdfHeaderVersion = Zend_Pdf::PDF_VERSION; $trailerDictionary = new Zend_Pdf_Element_Dictionary(); $docId = md5(uniqid(rand(), true)); $docIdLow = substr($docId, 0, 16); $docIdHigh = substr($docId, 16, 16); $trailerDictionary->ID = new Zend_Pdf_Element_Array(); $trailerDictionary->ID->items[] = new Zend_Pdf_Element_String_Binary($docIdLow); $trailerDictionary->ID->items[] = new Zend_Pdf_Element_String_Binary($docIdHigh); $trailerDictionary->Size = new Zend_Pdf_Element_Numeric(0); $this->_trailer = new Zend_Pdf_Trailer_Generator($trailerDictionary); $docCatalog = $this->_objFactory->newObject(new Zend_Pdf_Element_Dictionary()); $docCatalog->Type = new Zend_Pdf_Element_Name('Catalog'); $docCatalog->Version = new Zend_Pdf_Element_Name(Zend_Pdf::PDF_VERSION); $this->_trailer->Root = $docCatalog; $docPages = $this->_objFactory->newObject(new Zend_Pdf_Element_Dictionary()); $docPages->Type = new Zend_Pdf_Element_Name('Pages'); $docPages->Kids = new Zend_Pdf_Element_Array(); $docPages->Count = new Zend_Pdf_Element_Numeric(0); $docCatalog->Pages = $docPages; } } public function revisions() { $revisions = 1; $currentTrailer = $this->_trailer; while ($currentTrailer->getPrev() !== null && $currentTrailer->getPrev()->Root !== null ) { $revisions++; $currentTrailer = $currentTrailer->getPrev(); } return $revisions++; } public function rollback($steps) { for ($count = 0; $count < $steps; $count++) { if ($this->_trailer->getPrev() !== null && $this->_trailer->getPrev()->Root !== null) { $this->_trailer = $this->_trailer->getPrev(); } else { break; } } $this->_objFactory->setObjectCount($this->_trailer->Size->value); $this->_trailer->Root->touch(); $this->pages = array(); $this->_loadPages($this->_trailer->Root->Pages); } protected function _loadPages(Zend_Pdf_Element_Reference $pages, $attributes = array()) { if ($pages->getType() != Zend_Pdf_Element::TYPE_DICTIONARY) { throw new Zend_Pdf_Exception('Wrong argument'); } foreach ($pages->getKeys() as $property) { if (in_array($property, self::$_inheritableAttributes)) { $attributes[$property] = $pages->$property; $pages->$property = null; } } foreach ($pages->Kids->items as $child) { if ($child->Type->value == 'Pages') { $this->_loadPages($child, $attributes); } else if ($child->Type->value == 'Page') { foreach (self::$_inheritableAttributes as $property) { if ($child->$property === null && array_key_exists($property, $attributes)) { if ($attributes[$property] instanceof Zend_Pdf_Element_Object || $attributes[$property] instanceof Zend_Pdf_Element_Reference) { $child->$property = $attributes[$property]; } else { $child->$property = $this->_objFactory->newObject($attributes[$property]); } } } $this->pages[] = new Zend_Pdf_Page($child, $this->_objFactory); } } } protected function _loadNamedDestinations(Zend_Pdf_Element_Reference $root, $pdfHeaderVersion) { if ($root->Version !== null && version_compare($root->Version->value, $pdfHeaderVersion, '>')) { $versionIs_1_2_plus = version_compare($root->Version->value, '1.1', '>'); } else { $versionIs_1_2_plus = version_compare($pdfHeaderVersion, '1.1', '>'); } if ($versionIs_1_2_plus) { if ($root->Names !== null && $root->Names->Dests !== null) { foreach (new Zend_Pdf_NameTree($root->Names->Dests) as $name => $destination) { $this->_namedTargets[$name] = Zend_Pdf_Target::load($destination); } } } else { if ($root->Dests !== null) { if ($root->Dests->getType() != Zend_Pdf_Element::TYPE_DICTIONARY) { throw new Zend_Pdf_Exception('Document catalog Dests entry must be a dictionary.'); } foreach ($root->Dests->getKeys() as $destKey) { $this->_namedTargets[$destKey] = Zend_Pdf_Target::load($root->Dests->$destKey); } } } } protected function _loadOutlines(Zend_Pdf_Element_Reference $root) { if ($root->Outlines === null) { return; } if ($root->Outlines->getType() != Zend_Pdf_Element::TYPE_DICTIONARY) { throw new Zend_Pdf_Exception('Document catalog Outlines entry must be a dictionary.'); } if ($root->Outlines->Type !== null && $root->Outlines->Type->value != 'Outlines') { throw new Zend_Pdf_Exception('Outlines Type entry must be an \'Outlines\' string.'); } if ($root->Outlines->First === null) { return; } $outlineDictionary = $root->Outlines->First; $processedDictionaries = new SplObjectStorage(); while ($outlineDictionary !== null && !$processedDictionaries->contains($outlineDictionary)) { $processedDictionaries->attach($outlineDictionary); $this->outlines[] = new Zend_Pdf_Outline_Loaded($outlineDictionary); $outlineDictionary = $outlineDictionary->Next; } $this->_originalOutlines = $this->outlines; if ($root->Outlines->Count !== null) { $this->_originalOpenOutlinesCount = $root->Outlines->Count->value; } } protected function _dumpPages() { $root = $this->_trailer->Root; $pagesContainer = $root->Pages; $pagesContainer->touch(); $pagesContainer->Kids->items = array(); foreach ($this->pages as $page ) { $page->render($this->_objFactory); $pageDictionary = $page->getPageDictionary(); $pageDictionary->touch(); $pageDictionary->Parent = $pagesContainer; $pagesContainer->Kids->items[] = $pageDictionary; } $this->_refreshPagesHash(); $pagesContainer->Count->touch(); $pagesContainer->Count->value = count($this->pages); foreach ($this->_namedTargets as $name => $namedTarget) { if ($namedTarget instanceof Zend_Pdf_Destination_Explicit) { if ($this->resolveDestination($namedTarget, false) === null) { unset($this->_namedTargets[$name]); } } else if ($namedTarget instanceof Zend_Pdf_Action) { if ($this->_cleanUpAction($namedTarget, false) === null) { unset($this->_namedTargets[$name]); } } else { throw new Zend_Pdf_Exception('Wrong type of named targed (\'' . get_class($namedTarget) . '\').'); } } $iterator = new RecursiveIteratorIterator(new Zend_Pdf_RecursivelyIteratableObjectsContainer($this->outlines), RecursiveIteratorIterator::SELF_FIRST); foreach ($iterator as $outline) { $target = $outline->getTarget(); if ($target !== null) { if ($target instanceof Zend_Pdf_Destination) { if ($this->resolveDestination($target, false) === null) { $outline->setTarget(null); } } else if ($target instanceof Zend_Pdf_Action) { if ($this->_cleanUpAction($target, false) === null) { $outline->setTarget(null); } } else { throw new Zend_Pdf_Exception('Wrong outline target.'); } } } $openAction = $this->getOpenAction(); if ($openAction !== null) { if ($openAction instanceof Zend_Pdf_Action) { if ($this->_cleanUpAction($openAction, false) === null) { $this->setOpenAction(null); } } else if ($openAction instanceof Zend_Pdf_Destination) { if ($this->resolveDestination($openAction, false) === null) { $this->setOpenAction(null); } } else { throw new Zend_Pdf_Exception('OpenAction has to be either PDF Action or Destination.'); } } } protected function _dumpNamedDestinations() { ksort($this->_namedTargets, SORT_STRING); $destArrayItems = array(); foreach ($this->_namedTargets as $name => $destination) { $destArrayItems[] = new Zend_Pdf_Element_String($name); if ($destination instanceof Zend_Pdf_Target) { $destArrayItems[] = $destination->getResource(); } else { throw new Zend_Pdf_Exception('PDF named destinations must be a Zend_Pdf_Target object.'); } } $destArray = $this->_objFactory->newObject(new Zend_Pdf_Element_Array($destArrayItems)); $DestTree = $this->_objFactory->newObject(new Zend_Pdf_Element_Dictionary()); $DestTree->Names = $destArray; $root = $this->_trailer->Root; if ($root->Names === null) { $root->touch(); $root->Names = $this->_objFactory->newObject(new Zend_Pdf_Element_Dictionary()); } else { $root->Names->touch(); } $root->Names->Dests = $DestTree; } protected function _dumpOutlines() { $root = $this->_trailer->Root; if ($root->Outlines === null) { if (count($this->outlines) == 0) { return; } else { $root->Outlines = $this->_objFactory->newObject(new Zend_Pdf_Element_Dictionary()); $root->Outlines->Type = new Zend_Pdf_Element_Name('Outlines'); $updateOutlinesNavigation = true; } } else { $updateOutlinesNavigation = false; if (count($this->_originalOutlines) != count($this->outlines)) { $updateOutlinesNavigation = true; } else if ( !(array_keys($this->_originalOutlines) === array_keys($this->outlines)) ) { $updateOutlinesNavigation = true; } else { foreach ($this->outlines as $key => $outline) { if ($this->_originalOutlines[$key] !== $outline) { $updateOutlinesNavigation = true; } } } } $lastOutline = null; $openOutlinesCount = 0; if ($updateOutlinesNavigation) { $root->Outlines->touch(); $root->Outlines->First = null; foreach ($this->outlines as $outline) { if ($lastOutline === null) { $lastOutline = $outline->dumpOutline($this->_objFactory, $updateOutlinesNavigation, $root->Outlines); $root->Outlines->First = $lastOutline; } else { $currentOutlineDictionary = $outline->dumpOutline($this->_objFactory, $updateOutlinesNavigation, $root->Outlines, $lastOutline); $lastOutline->Next = $currentOutlineDictionary; $lastOutline = $currentOutlineDictionary; } $openOutlinesCount += $outline->openOutlinesCount(); } $root->Outlines->Last = $lastOutline; } else { foreach ($this->outlines as $outline) { $lastOutline = $outline->dumpOutline($this->_objFactory, $updateOutlinesNavigation, $root->Outlines, $lastOutline); $openOutlinesCount += $outline->openOutlinesCount(); } } if ($openOutlinesCount != $this->_originalOpenOutlinesCount) { $root->Outlines->touch; $root->Outlines->Count = new Zend_Pdf_Element_Numeric($openOutlinesCount); } } public function newPage($param1, $param2 = null) { if ($param2 === null) { return new Zend_Pdf_Page($param1, $this->_objFactory); } else { return new Zend_Pdf_Page($param1, $param2, $this->_objFactory); } } public function getMetadata() { if ($this->_trailer->Root->Metadata !== null) { return $this->_trailer->Root->Metadata->value; } else { return null; } } public function setMetadata($metadata) { $metadataObject = $this->_objFactory->newStreamObject($metadata); $metadataObject->dictionary->Type = new Zend_Pdf_Element_Name('Metadata'); $metadataObject->dictionary->Subtype = new Zend_Pdf_Element_Name('XML'); $this->_trailer->Root->Metadata = $metadataObject; $this->_trailer->Root->touch(); } public function getJavaScript() { return $this->_javaScript; } public function getOpenAction() { if ($this->_trailer->Root->OpenAction !== null) { return Zend_Pdf_Target::load($this->_trailer->Root->OpenAction); } else { return null; } } public function setOpenAction(Zend_Pdf_Target $openAction = null) { $root = $this->_trailer->Root; $root->touch(); if ($openAction === null) { $root->OpenAction = null; } else { $root->OpenAction = $openAction->getResource(); if ($openAction instanceof Zend_Pdf_Action) { $openAction->dumpAction($this->_objFactory); } } return $this; } public function getNamedDestinations() { return $this->_namedTargets; } public function getNamedDestination($name) { if (isset($this->_namedTargets[$name])) { return $this->_namedTargets[$name]; } else { return null; } } public function setNamedDestination($name, $destination = null) { if ($destination !== null && !$destination instanceof Zend_Pdf_Action_GoTo && !$destination instanceof Zend_Pdf_Destination_Explicit) { throw new Zend_Pdf_Exception('PDF named destination must refer an explicit destination or a GoTo PDF action.'); } if ($destination !== null) { $this->_namedTargets[$name] = $destination; } else { unset($this->_namedTargets[$name]); } } protected $_pageReferences = null; protected $_pageNumbers = null; protected function _refreshPagesHash() { $this->_pageReferences = array(); $this->_pageNumbers = array(); $count = 1; foreach ($this->pages as $page) { $pageDictionaryHashId = spl_object_hash($page->getPageDictionary()->getObject()); $this->_pageReferences[$pageDictionaryHashId] = $page; $this->_pageNumbers[$count++] = $page; } return $this; } public function resolveDestination(Zend_Pdf_Destination $destination, $refreshPageCollectionHashes = true) { if ($this->_pageReferences === null || $refreshPageCollectionHashes) { $this->_refreshPagesHash(); } if ($destination instanceof Zend_Pdf_Destination_Named) { if (!isset($this->_namedTargets[$destination->getName()])) { return null; } $destination = $this->getNamedDestination($destination->getName()); if ($destination instanceof Zend_Pdf_Action) { if (!$destination instanceof Zend_Pdf_Action_GoTo) { return null; } $destination = $destination->getDestination(); } if (!$destination instanceof Zend_Pdf_Destination_Explicit) { throw new Zend_Pdf_Exception('Named destination target has to be an explicit destination.'); } } $pageElement = $destination->getResource()->items[0]; if ($pageElement->getType() == Zend_Pdf_Element::TYPE_NUMERIC) { if (!isset($this->_pageNumbers[$pageElement->value])) { return null; } return $this->_pageNumbers[$pageElement->value]; } $pageDictionaryHashId = spl_object_hash($pageElement->getObject()); if (!isset($this->_pageReferences[$pageDictionaryHashId])) { return null; } return $this->_pageReferences[$pageDictionaryHashId]; } protected function _cleanUpAction(Zend_Pdf_Action $action, $refreshPageCollectionHashes = true) { if ($this->_pageReferences === null || $refreshPageCollectionHashes) { $this->_refreshPagesHash(); } if ($action instanceof Zend_Pdf_Action_GoTo && $this->resolveDestination($action->getDestination(), false) === null) { return null; } $iterator = new RecursiveIteratorIterator($action, RecursiveIteratorIterator::SELF_FIRST); $actionsToClean = array(); $deletionCandidateKeys = array(); foreach ($iterator as $chainedAction) { if ($chainedAction instanceof Zend_Pdf_Action_GoTo && $this->resolveDestination($chainedAction->getDestination(), false) === null) { $actionsToClean[] = $iterator->getSubIterator(); $deletionCandidateKeys[] = $iterator->getSubIterator()->key(); } } foreach ($actionsToClean as $id => $action) { unset($action->next[$deletionCandidateKeys[$id]]); } return $action; } public function extractFonts() { $fontResourcesUnique = array(); foreach ($this->pages as $page) { $pageResources = $page->extractResources(); if ($pageResources->Font === null) { continue; } $fontResources = $pageResources->Font; foreach ($fontResources->getKeys() as $fontResourceName) { $fontDictionary = $fontResources->$fontResourceName; if (! ($fontDictionary instanceof Zend_Pdf_Element_Reference || $fontDictionary instanceof Zend_Pdf_Element_Object) ) { throw new Zend_Pdf_Exception('Font dictionary has to be an indirect object or object reference.'); } $fontResourcesUnique[spl_object_hash($fontDictionary->getObject())] = $fontDictionary; } } $fonts = array(); foreach ($fontResourcesUnique as $resourceId => $fontDictionary) { try { $extractedFont = new Zend_Pdf_Resource_Font_Extracted($fontDictionary); $fonts[$resourceId] = $extractedFont; } catch (Zend_Pdf_Exception $e) { if ($e->getMessage() != 'Unsupported font type.') { throw $e; } } } return $fonts; } public function extractFont($fontName) { $fontResourcesUnique = array(); foreach ($this->pages as $page) { $pageResources = $page->extractResources(); if ($pageResources->Font === null) { continue; } $fontResources = $pageResources->Font; foreach ($fontResources->getKeys() as $fontResourceName) { $fontDictionary = $fontResources->$fontResourceName; if (! ($fontDictionary instanceof Zend_Pdf_Element_Reference || $fontDictionary instanceof Zend_Pdf_Element_Object) ) { throw new Zend_Pdf_Exception('Font dictionary has to be an indirect object or object reference.'); } $resourceId = spl_object_hash($fontDictionary->getObject()); if (isset($fontResourcesUnique[$resourceId])) { continue; } else { $fontResourcesUnique[$resourceId] = 1; } if ($fontDictionary->BaseFont->value != $fontName) { continue; } try { return new Zend_Pdf_Resource_Font_Extracted($fontDictionary); } catch (Zend_Pdf_Exception $e) { if ($e->getMessage() != 'Unsupported font type.') { throw $e; } } } } return null; } public function render($newSegmentOnly = false, $outputStream = null) { if ($this->_isNewDocument) { $newSegmentOnly = false; $this->_isNewDocument = false; } if ($this->properties != $this->_originalProperties) { $docInfo = $this->_objFactory->newObject(new Zend_Pdf_Element_Dictionary()); foreach ($this->properties as $key => $value) { switch ($key) { case 'Trapped': switch ($value) { case true: $docInfo->$key = new Zend_Pdf_Element_Name('True'); break; case false: $docInfo->$key = new Zend_Pdf_Element_Name('False'); break; case null: $docInfo->$key = new Zend_Pdf_Element_Name('Unknown'); break; default: throw new Zend_Pdf_Exception('Wrong Trapped document property vale: \'' . $value . '\'. Only true, false and null values are allowed.'); break; } case 'CreationDate': case 'ModDate': $docInfo->$key = new Zend_Pdf_Element_String((string)$value); break; case 'Title': case 'Author': case 'Subject': case 'Keywords': case 'Creator': case 'Producer': if (extension_loaded('mbstring') === true) { $detected = mb_detect_encoding($value); if ($detected !== 'ASCII') { $value = "\xfe\xff" . mb_convert_encoding($value, 'UTF-16', $detected); } } $docInfo->$key = new Zend_Pdf_Element_String((string)$value); break; default: $docInfo->$key = Zend_Pdf_Element::phpToPdf($value); break; } } $this->_trailer->Info = $docInfo; } $this->_dumpPages(); $this->_dumpNamedDestinations(); $this->_dumpOutlines(); if (!$this->_objFactory->isModified()) { if ($newSegmentOnly) { return ''; } if ($outputStream === null) { return $this->_trailer->getPDFString(); } else { $pdfData = $this->_trailer->getPDFString(); while ( strlen($pdfData) > 0 && ($byteCount = fwrite($outputStream, $pdfData)) != false ) { $pdfData = substr($pdfData, $byteCount); } return ''; } } $offset = $this->_trailer->getPDFLength(); $lastFreeObject = $this->_trailer->getLastFreeObject(); $xrefTable = array(); $xrefSectionStartNums = array(); $xrefSection = array(); $xrefSection[] = 0; $xrefSectionStartNums[] = 0; $lastObjNum = 0; if ($outputStream !== null) { if (!$newSegmentOnly) { $pdfData = $this->_trailer->getPDFString(); while ( strlen($pdfData) > 0 && ($byteCount = fwrite($outputStream, $pdfData)) != false ) { $pdfData = substr($pdfData, $byteCount); } } } else { $pdfSegmentBlocks = ($newSegmentOnly) ? array() : array($this->_trailer->getPDFString()); } foreach ($this->_objFactory->listModifiedObjects() as $updateInfo) { $objNum = $updateInfo->getObjNum(); if ($objNum - $lastObjNum != 1) { $xrefTable[] = $xrefSection; $xrefSection = array(); $xrefSectionStartNums[] = $objNum; } if ($updateInfo->isFree()) { $xrefSection[] = sprintf("%010d %05d f \n", $lastFreeObject, $updateInfo->getGenNum()); $lastFreeObject = $objNum; } else { $xrefSection[] = sprintf("%010d %05d n \n", $offset, $updateInfo->getGenNum()); $pdfBlock = $updateInfo->getObjectDump(); $offset += strlen($pdfBlock); if ($outputStream === null) { $pdfSegmentBlocks[] = $pdfBlock; } else { while ( strlen($pdfBlock) > 0 && ($byteCount = fwrite($outputStream, $pdfBlock)) != false ) { $pdfBlock = substr($pdfBlock, $byteCount); } } } $lastObjNum = $objNum; } $xrefTable[] = $xrefSection; $xrefTable[0][0] = sprintf("%010d 65535 f \n", $lastFreeObject); $xrefTableStr = "xref\n"; foreach ($xrefTable as $sectId => $xrefSection) { $xrefTableStr .= sprintf("%d %d \n", $xrefSectionStartNums[$sectId], count($xrefSection)); foreach ($xrefSection as $xrefTableEntry) { $xrefTableStr .= $xrefTableEntry; } } $this->_trailer->Size->value = $this->_objFactory->getObjectCount(); $pdfBlock = $xrefTableStr . $this->_trailer->toString() . "startxref\n" . $offset . "\n" . "%%EOF\n"; $this->_objFactory->cleanEnumerationShiftCache(); if ($outputStream === null) { $pdfSegmentBlocks[] = $pdfBlock; return implode('', $pdfSegmentBlocks); } else { while ( strlen($pdfBlock) > 0 && ($byteCount = fwrite($outputStream, $pdfBlock)) != false ) { $pdfBlock = substr($pdfBlock, $byteCount); } return ''; } } public function setJavaScript($javascript) { $this->_javaScript = $javascript; } public static function pdfDate($timestamp = null) { if ($timestamp === null) { $date = date('\D\:YmdHisO'); } else { $date = date('\D\:YmdHisO', $timestamp); } return substr_replace($date, '\'', -2, 0) . '\''; } }

/* @source /library/Zend/Pdf/ElementFactory.php */
class Zend_Pdf_ElementFactory implements Zend_Pdf_ElementFactory_Interface { private $_modifiedObjects = array(); private $_removedObjects; private $_registeredObjects = array(); private $_objectCount; private $_attachedFactories = array(); private $_factoryId; private static $_identity = 0; private $_shiftCalculationCache = array(); public function __construct($objCount) { $this->_objectCount = (int)$objCount; $this->_factoryId = self::$_identity++; $this->_removedObjects = new SplObjectStorage(); } public function getFactory() { return $this; } static public function createFactory($objCount) { return new Zend_Pdf_ElementFactory_Proxy(new Zend_Pdf_ElementFactory($objCount)); } public function close() { $this->_modifiedObjects = null; $this->_removedObjects = null; $this->_attachedFactories = null; foreach ($this->_registeredObjects as $obj) { $obj->cleanUp(); } $this->_registeredObjects = null; } public function resolve() { return $this; } public function getId() { return $this->_factoryId; } public function setObjectCount($objCount) { $this->_objectCount = (int)$objCount; } public function getObjectCount() { $count = $this->_objectCount; foreach ($this->_attachedFactories as $attached) { $count += $attached->getObjectCount() - 1; } return $count; } public function attach(Zend_Pdf_ElementFactory_Interface $factory) { if ( $factory === $this || isset($this->_attachedFactories[$factory->getId()])) { return; } $this->_attachedFactories[$factory->getId()] = $factory; } public function calculateShift(Zend_Pdf_ElementFactory_Interface $factory) { if ($factory === $this) { return 0; } if (isset($this->_shiftCalculationCache[$factory->_factoryId])) { return $this->_shiftCalculationCache[$factory->_factoryId]; } $shift = $this->_objectCount - 1; foreach ($this->_attachedFactories as $subFactory) { $subFactoryShift = $subFactory->calculateShift($factory); if ($subFactoryShift != -1) { $this->_shiftCalculationCache[$factory->_factoryId] = $shift + $subFactoryShift; return $shift + $subFactoryShift; } else { $shift += $subFactory->getObjectCount()-1; } } $this->_shiftCalculationCache[$factory->_factoryId] = -1; return -1; } public function cleanEnumerationShiftCache() { $this->_shiftCalculationCache = array(); foreach ($this->_attachedFactories as $attached) { $attached->cleanEnumerationShiftCache(); } } public function getEnumerationShift(Zend_Pdf_ElementFactory_Interface $factory) { if (($shift = $this->calculateShift($factory)) == -1) { throw new Zend_Pdf_Exception('Wrong object context'); } return $shift; } public function markAsModified(Zend_Pdf_Element_Object $obj) { if ($obj->getFactory() !== $this) { throw new Zend_Pdf_Exception('Object is not generated by this factory'); } $this->_modifiedObjects[$obj->getObjNum()] = $obj; } public function remove(Zend_Pdf_Element_Object $obj) { if (!$obj->compareFactory($this)) { throw new Zend_Pdf_Exception('Object is not generated by this factory'); } $this->_modifiedObjects[$obj->getObjNum()] = $obj; $this->_removedObjects->attach($obj); } public function newObject(Zend_Pdf_Element $objectValue) { $obj = new Zend_Pdf_Element_Object($objectValue, $this->_objectCount++, 0, $this); $this->_modifiedObjects[$obj->getObjNum()] = $obj; return $obj; } public function newStreamObject($streamValue) { $obj = new Zend_Pdf_Element_Object_Stream($streamValue, $this->_objectCount++, 0, $this); $this->_modifiedObjects[$obj->getObjNum()] = $obj; return $obj; } public function listModifiedObjects($rootFactory = null) { if ($rootFactory == null) { $rootFactory = $this; $shift = 0; } else { $shift = $rootFactory->getEnumerationShift($this); } ksort($this->_modifiedObjects); $result = array(); foreach ($this->_modifiedObjects as $objNum => $obj) { if ($this->_removedObjects->contains($obj)) { $result[$objNum+$shift] = new Zend_Pdf_UpdateInfoContainer($objNum + $shift, $obj->getGenNum()+1, true); } else { $result[$objNum+$shift] = new Zend_Pdf_UpdateInfoContainer($objNum + $shift, $obj->getGenNum(), false, $obj->dump($rootFactory)); } } foreach ($this->_attachedFactories as $factory) { $result += $factory->listModifiedObjects($rootFactory); } return $result; } public function registerObject(Zend_Pdf_Element_Object $obj, $refString) { $this->_registeredObjects[$refString] = $obj; } public function fetchObject($refString) { if (!isset($this->_registeredObjects[$refString])) { return null; } return $this->_registeredObjects[$refString]; } public function isModified() { if (count($this->_modifiedObjects) != 0) { return true; } foreach ($this->_attachedFactories as $subFactory) { if ($subFactory->isModified()) { return true; } } return false; } }

/* @source /library/Zend/Pdf/NameTree.php */
class Zend_Pdf_NameTree implements ArrayAccess, Iterator, Countable { protected $_items = array(); public function __construct(Zend_Pdf_Element $rootDictionary) { if ($rootDictionary->getType() != Zend_Pdf_Element::TYPE_DICTIONARY) { throw new Zend_Pdf_Exception('Name tree root must be a dictionary.'); } $intermediateNodes = array(); $leafNodes = array(); if ($rootDictionary->Kids !== null) { $intermediateNodes[] = $rootDictionary; } else { $leafNodes[] = $rootDictionary; } while (count($intermediateNodes) != 0) { $newIntermediateNodes = array(); foreach ($intermediateNodes as $node) { foreach ($node->Kids->items as $childNode) { if ($childNode->Kids !== null) { $newIntermediateNodes[] = $childNode; } else { $leafNodes[] = $childNode; } } } $intermediateNodes = $newIntermediateNodes; } foreach ($leafNodes as $leafNode) { $destinationsCount = count($leafNode->Names->items)/2; for ($count = 0; $count < $destinationsCount; $count++) { $this->_items[$leafNode->Names->items[$count*2]->value] = $leafNode->Names->items[$count*2 + 1]; } } } public function current() { return current($this->_items); } public function next() { return next($this->_items); } public function key() { return key($this->_items); } public function valid() { return current($this->_items)!==false; } public function rewind() { reset($this->_items); } public function offsetExists($offset) { return array_key_exists($offset, $this->_items); } public function offsetGet($offset) { return $this->_items[$offset]; } public function offsetSet($offset, $value) { if ($offset === null) { $this->_items[] = $value; } else { $this->_items[$offset] = $value; } } public function offsetUnset($offset) { unset($this->_items[$offset]); } public function clear() { $this->_items = array(); } public function count() { return count($this->_items); } }

/* @source /library/Zend/Pdf/RecursivelyIteratableObjectsContainer.php */
class Zend_Pdf_RecursivelyIteratableObjectsContainer implements RecursiveIterator, Countable { protected $_objects = array(); public function __construct(array $objects) { $this->_objects = $objects; } public function current() { return current($this->_objects); } public function key() { return key($this->_objects); } public function next() { return next($this->_objects); } public function rewind() { return reset($this->_objects); } public function valid() { return current($this->_objects) !== false; } public function getChildren() { return current($this->_objects); } public function hasChildren() { return count($this->_objects) > 0; } public function count() { return count($this->_objects); } }

/* @source /library/Zend/Pdf/Parser.php */
class Zend_Pdf_Parser { private $_stringParser; private $_trailer; private $_pdfVersion; public function getPDFLength() { return strlen($this->_stringParser->data); } public function getPDFString() { return $this->_stringParser->data; } public function getPDFVersion() { return $this->_pdfVersion; } private function _loadXRefTable($offset) { $this->_stringParser->offset = $offset; $refTable = new Zend_Pdf_Element_Reference_Table(); $context = new Zend_Pdf_Element_Reference_Context($this->_stringParser, $refTable); $this->_stringParser->setContext($context); $nextLexeme = $this->_stringParser->readLexeme(); if ($nextLexeme == 'xref') { $this->_stringParser->skipWhiteSpace(); while ( ($nextLexeme = $this->_stringParser->readLexeme()) != 'trailer' ) { if (!ctype_digit($nextLexeme)) { throw new Zend_Pdf_Exception(sprintf('PDF file syntax error. Offset - 0x%X. Cross-reference table subheader values must contain only digits.', $this->_stringParser->offset-strlen($nextLexeme))); } $objNum = (int)$nextLexeme; $refCount = $this->_stringParser->readLexeme(); if (!ctype_digit($refCount)) { throw new Zend_Pdf_Exception(sprintf('PDF file syntax error. Offset - 0x%X. Cross-reference table subheader values must contain only digits.', $this->_stringParser->offset-strlen($refCount))); } $this->_stringParser->skipWhiteSpace(); while ($refCount > 0) { $objectOffset = substr($this->_stringParser->data, $this->_stringParser->offset, 10); if (!ctype_digit($objectOffset)) { throw new Zend_Pdf_Exception(sprintf('PDF file cross-reference table syntax error. Offset - 0x%X. Offset must contain only digits.', $this->_stringParser->offset)); } for ($numStart = 0; $numStart < strlen($objectOffset)-1; $numStart++) { if ($objectOffset[$numStart] != '0') { break; } } $objectOffset = substr($objectOffset, $numStart); $this->_stringParser->offset += 10; if (strpos("\x00\t\n\f\r ", $this->_stringParser->data[$this->_stringParser->offset]) === false) { throw new Zend_Pdf_Exception(sprintf('PDF file cross-reference table syntax error. Offset - 0x%X. Value separator must be white space.', $this->_stringParser->offset)); } $this->_stringParser->offset++; $genNumber = substr($this->_stringParser->data, $this->_stringParser->offset, 5); if (!ctype_digit($objectOffset)) { throw new Zend_Pdf_Exception(sprintf('PDF file cross-reference table syntax error. Offset - 0x%X. Offset must contain only digits.', $this->_stringParser->offset)); } for ($numStart = 0; $numStart < strlen($genNumber)-1; $numStart++) { if ($genNumber[$numStart] != '0') { break; } } $genNumber = substr($genNumber, $numStart); $this->_stringParser->offset += 5; if (strpos("\x00\t\n\f\r ", $this->_stringParser->data[$this->_stringParser->offset]) === false) { throw new Zend_Pdf_Exception(sprintf('PDF file cross-reference table syntax error. Offset - 0x%X. Value separator must be white space.', $this->_stringParser->offset)); } $this->_stringParser->offset++; $inUseKey = $this->_stringParser->data[$this->_stringParser->offset]; $this->_stringParser->offset++; switch ($inUseKey) { case 'f': unset( $this->_refTable[$objNum . ' ' . $genNumber . ' R'] ); $refTable->addReference($objNum . ' ' . $genNumber . ' R', $objectOffset, false); break; case 'n': $refTable->addReference($objNum . ' ' . $genNumber . ' R', $objectOffset, true); } if ( !Zend_Pdf_StringParser::isWhiteSpace(ord( $this->_stringParser->data[$this->_stringParser->offset] )) ) { throw new Zend_Pdf_Exception(sprintf('PDF file cross-reference table syntax error. Offset - 0x%X. Value separator must be white space.', $this->_stringParser->offset)); } $this->_stringParser->offset++; if ( !Zend_Pdf_StringParser::isWhiteSpace(ord( $this->_stringParser->data[$this->_stringParser->offset] )) ) { throw new Zend_Pdf_Exception(sprintf('PDF file cross-reference table syntax error. Offset - 0x%X. Value separator must be white space.', $this->_stringParser->offset)); } $this->_stringParser->offset++; $refCount--; $objNum++; } } $trailerDictOffset = $this->_stringParser->offset; $trailerDict = $this->_stringParser->readElement(); if (!$trailerDict instanceof Zend_Pdf_Element_Dictionary) { throw new Zend_Pdf_Exception(sprintf('PDF file syntax error. Offset - 0x%X.  Dictionary expected after \'trailer\' keyword.', $trailerDictOffset)); } } else { $xrefStream = $this->_stringParser->getObject($offset, $context); if (!$xrefStream instanceof Zend_Pdf_Element_Object_Stream) { throw new Zend_Pdf_Exception(sprintf('PDF file syntax error. Offset - 0x%X.  Cross-reference stream expected.', $offset)); } $trailerDict = $xrefStream->dictionary; if ($trailerDict->Type->value != 'XRef') { throw new Zend_Pdf_Exception(sprintf('PDF file syntax error. Offset - 0x%X.  Cross-reference stream object must have /Type property assigned to /XRef.', $offset)); } if ($trailerDict->W === null || $trailerDict->W->getType() != Zend_Pdf_Element::TYPE_ARRAY) { throw new Zend_Pdf_Exception(sprintf('PDF file syntax error. Offset - 0x%X. Cross reference stream dictionary doesn\'t have W entry or it\'s not an array.', $offset)); } $entryField1Size = $trailerDict->W->items[0]->value; $entryField2Size = $trailerDict->W->items[1]->value; $entryField3Size = $trailerDict->W->items[2]->value; if ($entryField2Size == 0 || $entryField3Size == 0) { throw new Zend_Pdf_Exception(sprintf('PDF file syntax error. Offset - 0x%X. Wrong W dictionary entry. Only type field of stream entries has default value and could be zero length.', $offset)); } $xrefStreamData = $xrefStream->value; if ($trailerDict->Index !== null) { if ($trailerDict->Index->getType() != Zend_Pdf_Element::TYPE_ARRAY) { throw new Zend_Pdf_Exception(sprintf('PDF file syntax error. Offset - 0x%X. Cross reference stream dictionary Index entry must be an array.', $offset)); } $sections = count($trailerDict->Index->items)/2; } else { $sections = 1; } $streamOffset = 0; $size = $entryField1Size + $entryField2Size + $entryField3Size; $entries = strlen($xrefStreamData)/$size; for ($count = 0; $count < $sections; $count++) { if ($trailerDict->Index !== null) { $objNum = $trailerDict->Index->items[$count*2 ]->value; $entries = $trailerDict->Index->items[$count*2 + 1]->value; } else { $objNum = 0; $entries = $trailerDict->Size->value; } for ($count2 = 0; $count2 < $entries; $count2++) { if ($entryField1Size == 0) { $type = 1; } else if ($entryField1Size == 1) { $type = ord($xrefStreamData[$streamOffset++]); } else { $type = Zend_Pdf_StringParser::parseIntFromStream($xrefStreamData, $streamOffset, $entryField1Size); $streamOffset += $entryField1Size; } if ($entryField2Size == 1) { $field2 = ord($xrefStreamData[$streamOffset++]); } else { $field2 = Zend_Pdf_StringParser::parseIntFromStream($xrefStreamData, $streamOffset, $entryField2Size); $streamOffset += $entryField2Size; } if ($entryField3Size == 1) { $field3 = ord($xrefStreamData[$streamOffset++]); } else { $field3 = Zend_Pdf_StringParser::parseIntFromStream($xrefStreamData, $streamOffset, $entryField3Size); $streamOffset += $entryField3Size; } switch ($type) { case 0: $refTable->addReference($objNum . ' ' . $field3 . ' R', $field2, false); break; case 1: $refTable->addReference($objNum . ' ' . $field3 . ' R', $field2, true); break; case 2: break; } $objNum++; } } throw new Zend_Pdf_Exception('Cross-reference streams are not supported yet.'); } $trailerObj = new Zend_Pdf_Trailer_Keeper($trailerDict, $context); if ($trailerDict->Prev instanceof Zend_Pdf_Element_Numeric || $trailerDict->Prev instanceof Zend_Pdf_Element_Reference ) { $trailerObj->setPrev($this->_loadXRefTable($trailerDict->Prev->value)); $context->getRefTable()->setParent($trailerObj->getPrev()->getRefTable()); } $trailerObj->Prev = new Zend_Pdf_Element_Numeric($offset); return $trailerObj; } public function getTrailer() { return $this->_trailer; } public function __construct($source, Zend_Pdf_ElementFactory_Interface $factory, $load) { if ($load) { if (($pdfFile = @fopen($source, 'rb')) === false ) { throw new Zend_Pdf_Exception( "Can not open '$source' file for reading." ); } $data = ''; $byteCount = filesize($source); while ($byteCount > 0 && !feof($pdfFile)) { $nextBlock = fread($pdfFile, $byteCount); if ($nextBlock === false) { throw new Zend_Pdf_Exception( "Error occured while '$source' file reading." ); } $data .= $nextBlock; $byteCount -= strlen($nextBlock); } if ($byteCount != 0) { throw new Zend_Pdf_Exception( "Error occured while '$source' file reading." ); } fclose($pdfFile); $this->_stringParser = new Zend_Pdf_StringParser($data, $factory); } else { $this->_stringParser = new Zend_Pdf_StringParser($source, $factory); } $pdfVersionComment = $this->_stringParser->readComment(); if (substr($pdfVersionComment, 0, 5) != '%PDF-') { throw new Zend_Pdf_Exception('File is not a PDF.'); } $pdfVersion = substr($pdfVersionComment, 5); if (version_compare($pdfVersion, '0.9', '<') || version_compare($pdfVersion, '1.61', '>=') ) { throw new Zend_Pdf_Exception(sprintf('Unsupported PDF version. Zend_Pdf supports PDF 1.0-1.4. Current version - \'%f\'', $pdfVersion)); } $this->_pdfVersion = $pdfVersion; $this->_stringParser->offset = strrpos($this->_stringParser->data, '%%EOF'); if ($this->_stringParser->offset === false || strlen($this->_stringParser->data) - $this->_stringParser->offset > 7) { throw new Zend_Pdf_Exception('Pdf file syntax error. End-of-fle marker expected at the end of file.'); } $this->_stringParser->offset--; while (Zend_Pdf_StringParser::isWhiteSpace( ord($this->_stringParser->data[$this->_stringParser->offset]) )&& ($this->_stringParser->offset > 0)) { $this->_stringParser->offset--; } while ( (!Zend_Pdf_StringParser::isWhiteSpace( ord($this->_stringParser->data[$this->_stringParser->offset]) ))&& ($this->_stringParser->offset > 0)) { $this->_stringParser->offset--; } while (Zend_Pdf_StringParser::isWhiteSpace( ord($this->_stringParser->data[$this->_stringParser->offset]) )&& ($this->_stringParser->offset > 0)) { $this->_stringParser->offset--; } $this->_stringParser->offset -= 9; $nextLexeme = $this->_stringParser->readLexeme(); if ($nextLexeme != 'startxref') { throw new Zend_Pdf_Exception(sprintf('Pdf file syntax error. \'startxref\' keyword expected. Offset - 0x%X.', $this->_stringParser->offset-strlen($nextLexeme))); } $startXref = $this->_stringParser->readLexeme(); if (!ctype_digit($startXref)) { throw new Zend_Pdf_Exception(sprintf('Pdf file syntax error. Cross-reference table offset must contain only digits. Offset - 0x%X.', $this->_stringParser->offset-strlen($nextLexeme))); } $this->_trailer = $this->_loadXRefTable($startXref); $factory->setObjectCount($this->_trailer->Size->value); } public function __destruct() { $this->_stringParser->cleanUp(); } }

/* @source /library/Zend/Pdf/StringParser.php */
class Zend_Pdf_StringParser { public $data = ''; public $offset = 0; private $_context = null; private $_elements = array(); private $_objFactory = null; public function cleanUp() { $this->_context = null; $this->_elements = array(); $this->_objFactory = null; } public static function isWhiteSpace($chCode) { if ($chCode == 0x00 || $chCode == 0x09 || $chCode == 0x0A || $chCode == 0x0C || $chCode == 0x0D || $chCode == 0x20 ) { return true; } else { return false; } } public static function isDelimiter($chCode ) { if ($chCode == 0x28 || $chCode == 0x29 || $chCode == 0x3C || $chCode == 0x3E || $chCode == 0x5B || $chCode == 0x5D || $chCode == 0x7B || $chCode == 0x7D || $chCode == 0x2F || $chCode == 0x25 ) { return true; } else { return false; } } public function skipWhiteSpace($skipComment = true) { if ($skipComment) { while (true) { $this->offset += strspn($this->data, "\x00\t\n\f\r ", $this->offset); if ($this->offset < strlen($this->data) && $this->data[$this->offset] == '%') { $this->offset += strcspn($this->data, "\r\n", $this->offset); } else { return; } } } else { $this->offset += strspn($this->data, "\x00\t\n\f\r ", $this->offset); } } public function skipComment() { while ($this->offset < strlen($this->data)) { if (ord($this->data[$this->offset]) != 0x0A || ord($this->data[$this->offset]) != 0x0d ) { $this->offset++; } else { return; } } } public function readComment() { $this->skipWhiteSpace(false); if ($this->data[$this->offset] != '%') { return ''; } for ($start = $this->offset; $this->offset < strlen($this->data); $this->offset++) { if (ord($this->data[$this->offset]) == 0x0A || ord($this->data[$this->offset]) == 0x0d ) { break; } } return substr($this->data, $start, $this->offset-$start); } public function readLexeme() { while (true) { $this->offset += strspn($this->data, "\x00\t\n\f\r ", $this->offset); if ($this->offset < strlen($this->data) && $this->data[$this->offset] == '%') { $this->offset += strcspn($this->data, "\r\n", $this->offset); } else { break; } } if ($this->offset >= strlen($this->data)) { return ''; } if ( strpos('()<>[]{}/%', $this->data[$this->offset]) !== false ) { switch (substr($this->data, $this->offset, 2)) { case '<<': $this->offset += 2; return '<<'; break; case '>>': $this->offset += 2; return '>>'; break; default: return $this->data[$this->offset++]; break; } } else { $start = $this->offset; $compare = ''; if( version_compare( phpversion(), '5.2.5' ) >= 0) { $compare = "()<>[]{}/%\x00\t\n\f\r "; } else { $compare = "()<>[]{}/%\x00\t\n\r "; } $this->offset += strcspn($this->data, $compare, $this->offset); return substr($this->data, $start, $this->offset - $start); } } public function readElement($nextLexeme = null) { if ($nextLexeme === null) { $nextLexeme = $this->readLexeme(); } switch ($nextLexeme) { case '(': return ($this->_elements[] = $this->_readString()); case '<': return ($this->_elements[] = $this->_readBinaryString()); case '/': return ($this->_elements[] = new Zend_Pdf_Element_Name( Zend_Pdf_Element_Name::unescape( $this->readLexeme() ) )); case '[': return ($this->_elements[] = $this->_readArray()); case '<<': return ($this->_elements[] = $this->_readDictionary()); case ')': case '>': case ']': case '>>': case '{': case '}': throw new Zend_Pdf_Exception(sprintf('PDF file syntax error. Offset - 0x%X.', $this->offset)); default: if (strcasecmp($nextLexeme, 'true') == 0) { return ($this->_elements[] = new Zend_Pdf_Element_Boolean(true)); } else if (strcasecmp($nextLexeme, 'false') == 0) { return ($this->_elements[] = new Zend_Pdf_Element_Boolean(false)); } else if (strcasecmp($nextLexeme, 'null') == 0) { return ($this->_elements[] = new Zend_Pdf_Element_Null()); } $ref = $this->_readReference($nextLexeme); if ($ref !== null) { return ($this->_elements[] = $ref); } return ($this->_elements[] = $this->_readNumeric($nextLexeme)); } } private function _readString() { $start = $this->offset; $openedBrackets = 1; $this->offset += strcspn($this->data, '()\\', $this->offset); while ($this->offset < strlen($this->data)) { switch (ord( $this->data[$this->offset] )) { case 0x28: $this->offset++; $openedBrackets++; break; case 0x29: $this->offset++; $openedBrackets--; break; case 0x5C: $this->offset += 2; } if ($openedBrackets == 0) { break; } $this->offset += strcspn($this->data, '()\\', $this->offset); } if ($openedBrackets != 0) { throw new Zend_Pdf_Exception(sprintf('PDF file syntax error. Unexpected end of file while string reading. Offset - 0x%X. \')\' expected.', $start)); } return new Zend_Pdf_Element_String(Zend_Pdf_Element_String::unescape( substr($this->data, $start, $this->offset - $start - 1) )); } private function _readBinaryString() { $start = $this->offset; $this->offset += strspn($this->data, "\x00\t\n\f\r 0123456789abcdefABCDEF", $this->offset); if ($this->offset >= strlen($this->data) - 1) { throw new Zend_Pdf_Exception(sprintf('PDF file syntax error. Unexpected end of file while reading binary string. Offset - 0x%X. \'>\' expected.', $start)); } if ($this->data[$this->offset++] != '>') { throw new Zend_Pdf_Exception(sprintf('PDF file syntax error. Unexpected character while binary string reading. Offset - 0x%X.', $this->offset)); } return new Zend_Pdf_Element_String_Binary( Zend_Pdf_Element_String_Binary::unescape( substr($this->data, $start, $this->offset - $start - 1) )); } private function _readArray() { $elements = array(); while ( strlen($nextLexeme = $this->readLexeme()) != 0 ) { if ($nextLexeme != ']') { $elements[] = $this->readElement($nextLexeme); } else { return new Zend_Pdf_Element_Array($elements); } } throw new Zend_Pdf_Exception(sprintf('PDF file syntax error. Unexpected end of file while array reading. Offset - 0x%X. \']\' expected.', $this->offset)); } private function _readDictionary() { $dictionary = new Zend_Pdf_Element_Dictionary(); while ( strlen($nextLexeme = $this->readLexeme()) != 0 ) { if ($nextLexeme != '>>') { $nameStart = $this->offset - strlen($nextLexeme); $name = $this->readElement($nextLexeme); $value = $this->readElement(); if (!$name instanceof Zend_Pdf_Element_Name) { throw new Zend_Pdf_Exception(sprintf('PDF file syntax error. Name object expected while dictionary reading. Offset - 0x%X.', $nameStart)); } $dictionary->add($name, $value); } else { return $dictionary; } } throw new Zend_Pdf_Exception(sprintf('PDF file syntax error. Unexpected end of file while dictionary reading. Offset - 0x%X. \'>>\' expected.', $this->offset)); } private function _readReference($nextLexeme = null) { $start = $this->offset; if ($nextLexeme === null) { $objNum = $this->readLexeme(); } else { $objNum = $nextLexeme; } if (!ctype_digit($objNum)) { $this->offset = $start; return null; } $genNum = $this->readLexeme(); if (!ctype_digit($genNum)) { $this->offset = $start; return null; } $rMark = $this->readLexeme(); if ($rMark != 'R') { $this->offset = $start; return null; } $ref = new Zend_Pdf_Element_Reference((int)$objNum, (int)$genNum, $this->_context, $this->_objFactory->resolve()); return $ref; } private function _readNumeric($nextLexeme = null) { if ($nextLexeme === null) { $nextLexeme = $this->readLexeme(); } return new Zend_Pdf_Element_Numeric($nextLexeme); } public function getObject($offset, Zend_Pdf_Element_Reference_Context $context) { if ($offset === null ) { return new Zend_Pdf_Element_Null(); } $offsetSave = $this->offset; $this->offset = $offset; $this->_context = $context; $this->_elements = array(); $objNum = $this->readLexeme(); if (!ctype_digit($objNum)) { throw new Zend_Pdf_Exception(sprintf('PDF file syntax error. Offset - 0x%X. Object number expected.', $this->offset - strlen($objNum))); } $genNum = $this->readLexeme(); if (!ctype_digit($genNum)) { throw new Zend_Pdf_Exception(sprintf('PDF file syntax error. Offset - 0x%X. Object generation number expected.', $this->offset - strlen($genNum))); } $objKeyword = $this->readLexeme(); if ($objKeyword != 'obj') { throw new Zend_Pdf_Exception(sprintf('PDF file syntax error. Offset - 0x%X. \'obj\' keyword expected.', $this->offset - strlen($objKeyword))); } $objValue = $this->readElement(); $nextLexeme = $this->readLexeme(); if( $nextLexeme == 'endobj' ) { $obj = new Zend_Pdf_Element_Object($objValue, (int)$objNum, (int)$genNum, $this->_objFactory->resolve()); foreach ($this->_elements as $element) { $element->setParentObject($obj); } $this->offset = $offsetSave; return $obj; } if ($nextLexeme != 'stream') { throw new Zend_Pdf_Exception(sprintf('PDF file syntax error. Offset - 0x%X. \'endobj\' or \'stream\' keywords expected.', $this->offset - strlen($nextLexeme))); } if (!$objValue instanceof Zend_Pdf_Element_Dictionary) { throw new Zend_Pdf_Exception(sprintf('PDF file syntax error. Offset - 0x%X. Stream extent must be preceded by stream dictionary.', $this->offset - strlen($nextLexeme))); } $streamLength = $objValue->Length->value; if ($this->data[$this->offset] == "\r" && $this->data[$this->offset + 1] == "\n" ) { $this->offset += 2; } else if ($this->data[$this->offset] == "\n" ) { $this->offset++; } else { throw new Zend_Pdf_Exception(sprintf('PDF file syntax error. Offset - 0x%X. \'stream\' must be followed by either cr-lf sequence or lf character only.', $this->offset - strlen($nextLexeme))); } $dataOffset = $this->offset; $this->offset += $streamLength; $nextLexeme = $this->readLexeme(); if ($nextLexeme != 'endstream') { throw new Zend_Pdf_Exception(sprintf('PDF file syntax error. Offset - 0x%X. \'endstream\' keyword expected.', $this->offset - strlen($nextLexeme))); } $nextLexeme = $this->readLexeme(); if ($nextLexeme != 'endobj') { throw new Zend_Pdf_Exception(sprintf('PDF file syntax error. Offset - 0x%X. \'endobj\' keyword expected.', $this->offset - strlen($nextLexeme))); } $obj = new Zend_Pdf_Element_Object_Stream(substr($this->data, $dataOffset, $streamLength), (int)$objNum, (int)$genNum, $this->_objFactory->resolve(), $objValue); foreach ($this->_elements as $element) { $element->setParentObject($obj); } $this->offset = $offsetSave; return $obj; } public function getLength() { return strlen($this->data); } public function getString() { return $this->data; } public static function parseIntFromStream($stream, $offset, $size) { $value = 0; for ($count = 0; $count < $size; $count++) { $value *= 256; $value += ord($stream[$offset + $count]); } return $value; } public function setContext(Zend_Pdf_Element_Reference_Context $context) { $this->_context = $context; } public function __construct($source, Zend_Pdf_ElementFactory_Interface $factory) { $this->data = $source; $this->_objFactory = $factory; } }

/* @source /library/Zend/Pdf/Style.php */
class Zend_Pdf_Style { private $_fillColor = null; private $_color; private $_lineWidth; private $_lineDashingPattern; private $_lineDashingPhase; private $_font; private $_fontSize; public function __construct($anotherStyle = null) { if ($anotherStyle !== null) { $this->_fillColor = $anotherStyle->_fillColor; $this->_color = $anotherStyle->_color; $this->_lineWidth = $anotherStyle->_lineWidth; $this->_lineDashingPattern = $anotherStyle->_lineDashingPattern; $this->_lineDashingPhase = $anotherStyle->_lineDashingPhase; $this->_font = $anotherStyle->_font; $this->_fontSize = $anotherStyle->_fontSize; } } public function setFillColor(Zend_Pdf_Color $color) { $this->_fillColor = $color; } public function setLineColor(Zend_Pdf_Color $color) { $this->_color = $color; } public function setLineWidth($width) { $this->_lineWidth = new Zend_Pdf_Element_Numeric($width); } public function setLineDashingPattern($pattern, $phase = 0) { if ($pattern === Zend_Pdf_Page::LINE_DASHING_SOLID) { $pattern = array(); $phase = 0; } $this->_lineDashingPattern = $pattern; $this->_lineDashingPhase = new Zend_Pdf_Element_Numeric($phase); } public function setFont(Zend_Pdf_Resource_Font $font, $fontSize) { $this->_font = $font; $this->_fontSize = $fontSize; } public function setFontSize($fontSize) { $this->_fontSize = $fontSize; } public function getFillColor() { return $this->_fillColor; } public function getLineColor() { return $this->_color; } public function getLineWidth() { return $this->_lineWidth->value; } public function getLineDashingPattern() { return $this->_lineDashingPattern; } public function getFont() { return $this->_font; } public function getFontSize() { return $this->_fontSize; } public function getLineDashingPhase() { return $this->_lineDashingPhase->value; } public function instructions() { $instructions = ''; if ($this->_fillColor !== null) { $instructions .= $this->_fillColor->instructions(false); } if ($this->_color !== null) { $instructions .= $this->_color->instructions(true); } if ($this->_lineWidth !== null) { $instructions .= $this->_lineWidth->toString() . " w\n"; } if ($this->_lineDashingPattern !== null) { $dashPattern = new Zend_Pdf_Element_Array(); foreach ($this->_lineDashingPattern as $dashItem) { $dashElement = new Zend_Pdf_Element_Numeric($dashItem); $dashPattern->items[] = $dashElement; } $instructions .= $dashPattern->toString() . ' ' . $this->_lineDashingPhase->toString() . " d\n"; } return $instructions; } }

/* @source /library/Zend/Pdf/Page.php */
class Zend_Pdf_Page extends Zend_Pdf_Canvas_Abstract { const SIZE_A4 = '595:842:'; const SIZE_A4_LANDSCAPE = '842:595:'; const SIZE_LETTER = '612:792:'; const SIZE_LETTER_LANDSCAPE = '792:612:'; const SHAPE_DRAW_STROKE = 0; const SHAPE_DRAW_FILL = 1; const SHAPE_DRAW_FILL_AND_STROKE = 2; const FILL_METHOD_NON_ZERO_WINDING = 0; const FILL_METHOD_EVEN_ODD = 1; const LINE_DASHING_SOLID = 0; protected $_dictionary; protected $_objFactory = null; protected $_attached; protected $_safeGS; public function __construct($param1, $param2 = null, $param3 = null) { if (($param1 instanceof Zend_Pdf_Element_Reference || $param1 instanceof Zend_Pdf_Element_Object ) && $param2 instanceof Zend_Pdf_ElementFactory_Interface && $param3 === null ) { switch ($param1->getType()) { case Zend_Pdf_Element::TYPE_DICTIONARY: $this->_dictionary = $param1; $this->_objFactory = $param2; $this->_attached = true; $this->_safeGS = false; return; break; case Zend_Pdf_Element::TYPE_NULL: $this->_objFactory = $param2; $pageWidth = $pageHeight = 0; break; default: throw new Zend_Pdf_Exception('Unrecognized object type.'); break; } } else if ($param1 instanceof Zend_Pdf_Page && $param2 === null && $param3 === null) { $this->_objFactory = $param1->_objFactory; $this->_attached = &$param1->_attached; $this->_safeGS = false; $this->_dictionary = $this->_objFactory->newObject(new Zend_Pdf_Element_Dictionary()); foreach ($param1->_dictionary->getKeys() as $key) { if ($key == 'Contents') { $this->_dictionary->Contents = new Zend_Pdf_Element_Array(); if ($param1->_dictionary->Contents->getType() != Zend_Pdf_Element::TYPE_ARRAY) { $this->_dictionary->Contents->items[] = $param1->_dictionary->Contents; } else { foreach ($param1->_dictionary->Contents->items as $srcContentStream) { $this->_dictionary->Contents->items[] = $srcContentStream; } } } else { $this->_dictionary->$key = $param1->_dictionary->$key; } } return; } else if (is_string($param1) && ($param2 === null || $param2 instanceof Zend_Pdf_ElementFactory_Interface) && $param3 === null) { if ($param2 !== null) { $this->_objFactory = $param2; } else { $this->_objFactory = Zend_Pdf_ElementFactory::createFactory(1); } $this->_attached = false; $this->_safeGS = true; switch (strtolower($param1)) { case 'a4': $param1 = Zend_Pdf_Page::SIZE_A4; break; case 'a4-landscape': $param1 = Zend_Pdf_Page::SIZE_A4_LANDSCAPE; break; case 'letter': $param1 = Zend_Pdf_Page::SIZE_LETTER; break; case 'letter-landscape': $param1 = Zend_Pdf_Page::SIZE_LETTER_LANDSCAPE; break; default: } $pageDim = explode(':', $param1); if(count($pageDim) == 2 || count($pageDim) == 3) { $pageWidth = $pageDim[0]; $pageHeight = $pageDim[1]; } else { throw new Zend_Pdf_Exception('Wrong pagesize notation.'); } } else if (is_numeric($param1) && is_numeric($param2) && ($param3 === null || $param3 instanceof Zend_Pdf_ElementFactory_Interface)) { if ($param3 !== null) { $this->_objFactory = $param3; } else { $this->_objFactory = Zend_Pdf_ElementFactory::createFactory(1); } $this->_attached = false; $this->_safeGS = true; $pageWidth = $param1; $pageHeight = $param2; } else { throw new Zend_Pdf_Exception('Unrecognized method signature, wrong number of arguments or wrong argument types.'); } $this->_dictionary = $this->_objFactory->newObject(new Zend_Pdf_Element_Dictionary()); $this->_dictionary->Type = new Zend_Pdf_Element_Name('Page'); $this->_dictionary->LastModified = new Zend_Pdf_Element_String(Zend_Pdf::pdfDate()); $this->_dictionary->Resources = new Zend_Pdf_Element_Dictionary(); $this->_dictionary->MediaBox = new Zend_Pdf_Element_Array(); $this->_dictionary->MediaBox->items[] = new Zend_Pdf_Element_Numeric(0); $this->_dictionary->MediaBox->items[] = new Zend_Pdf_Element_Numeric(0); $this->_dictionary->MediaBox->items[] = new Zend_Pdf_Element_Numeric($pageWidth); $this->_dictionary->MediaBox->items[] = new Zend_Pdf_Element_Numeric($pageHeight); $this->_dictionary->Contents = new Zend_Pdf_Element_Array(); } protected function _attachResource($type, Zend_Pdf_Resource $resource) { if ($this->_dictionary->Resources->$type === null) { $this->_dictionary->Resources->touch(); $this->_dictionary->Resources->$type = new Zend_Pdf_Element_Dictionary(); } else { $this->_dictionary->Resources->$type->touch(); } $resObject = $resource->getResource(); foreach ($this->_dictionary->Resources->$type->getKeys() as $ResID) { if ($this->_dictionary->Resources->$type->$ResID === $resObject) { return $ResID; } } $idCounter = 1; do { $newResName = $type[0] . $idCounter++; } while ($this->_dictionary->Resources->$type->$newResName !== null); $this->_dictionary->Resources->$type->$newResName = $resObject; $this->_objFactory->attach($resource->getFactory()); return $newResName; } protected function _addProcSet($procSetName) { if ($this->_dictionary->Resources->ProcSet === null) { $this->_dictionary->Resources->touch(); $this->_dictionary->Resources->ProcSet = new Zend_Pdf_Element_Array(); } else { $this->_dictionary->Resources->ProcSet->touch(); } foreach ($this->_dictionary->Resources->ProcSet->items as $procSetEntry) { if ($procSetEntry->value == $procSetName) { return; } } $this->_dictionary->Resources->ProcSet->items[] = new Zend_Pdf_Element_Name($procSetName); } public function getResources() { $resources = array(); $resDictionary = $this->_dictionary->Resources; foreach ($resDictionary->getKeys() as $resType) { $resources[$resType] = array(); if ($resType == 'ProcSet') { foreach ($resDictionary->ProcSet->items as $procSetEntry) { $resources[$resType][] = $procSetEntry->value; } } else { $resMap = $resDictionary->$resType; foreach ($resMap->getKeys() as $resId) { $resources[$resType][$resId] =new Zend_Pdf_Resource_Unified($resMap->$resId); } } } return $resources; } public function getContents() { } public function getHeight() { return $this->_dictionary->MediaBox->items[3]->value - $this->_dictionary->MediaBox->items[1]->value; } public function getWidth() { return $this->_dictionary->MediaBox->items[2]->value - $this->_dictionary->MediaBox->items[0]->value; } public function __clone() { $factory = Zend_Pdf_ElementFactory::createFactory(1); $processed = array(); $dictionary = new Zend_Pdf_Element_Dictionary(); foreach ($this->_dictionary->getKeys() as $key) { $dictionary->$key = $this->_dictionary->$key->makeClone($factory->getFactory(), $processed, Zend_Pdf_Element::CLONE_MODE_SKIP_PAGES); } $this->_dictionary = $factory->newObject($dictionary); $this->_objFactory = $factory; $this->_attached = false; $this->_style = null; $this->_font = null; } public function clonePage($factory, &$processed) { $dictionary = new Zend_Pdf_Element_Dictionary(); foreach ($this->_dictionary->getKeys() as $key) { $dictionary->$key = $this->_dictionary->$key->makeClone($factory->getFactory(), $processed, Zend_Pdf_Element::CLONE_MODE_SKIP_PAGES); } $clonedPage = new Zend_Pdf_Page($factory->newObject($dictionary), $factory); $clonedPage->_attached = false; return $clonedPage; } public function getPageDictionary() { return $this->_dictionary; } public function flush() { if ($this->_saveCount != 0) { throw new Zend_Pdf_Exception('Saved graphics state is not restored'); } if ($this->_contents == '') { return; } if ($this->_dictionary->Contents->getType() != Zend_Pdf_Element::TYPE_ARRAY) { $this->_dictionary->touch(); $currentPageContents = $this->_dictionary->Contents; $this->_dictionary->Contents = new Zend_Pdf_Element_Array(); $this->_dictionary->Contents->items[] = $currentPageContents; } else { $this->_dictionary->Contents->touch(); } if ((!$this->_safeGS) && (count($this->_dictionary->Contents->items) != 0)) { $this->_addProcSet('PDF'); $newContentsArray = new Zend_Pdf_Element_Array(); $newContentsArray->items[] = $this->_objFactory->newStreamObject(" q\n"); foreach ($this->_dictionary->Contents->items as $contentStream) { $newContentsArray->items[] = $contentStream; } $newContentsArray->items[] = $this->_objFactory->newStreamObject(" Q\n"); $this->_dictionary->touch(); $this->_dictionary->Contents = $newContentsArray; $this->_safeGS = true; } $this->_dictionary->Contents->items[] = $this->_objFactory->newStreamObject($this->_contents); $this->_contents = ''; } public function render(Zend_Pdf_ElementFactory_Interface $objFactory) { $this->flush(); if ($objFactory === $this->_objFactory) { return; } if ($this->_attached) { throw new Zend_Pdf_Exception('Page is attached to other documen. Use clone $page to get it context free.'); } else { $objFactory->attach($this->_objFactory); } } public function extractResources() { return $this->_dictionary->Resources; } public function extractFonts() { if ($this->_dictionary->Resources->Font === null) { return array(); } $fontResources = $this->_dictionary->Resources->Font; $fontResourcesUnique = array(); foreach ($fontResources->getKeys() as $fontResourceName) { $fontDictionary = $fontResources->$fontResourceName; if (! ($fontDictionary instanceof Zend_Pdf_Element_Reference || $fontDictionary instanceof Zend_Pdf_Element_Object) ) { throw new Zend_Pdf_Exception('Font dictionary has to be an indirect object or object reference.'); } $fontResourcesUnique[spl_object_hash($fontDictionary->getObject())] = $fontDictionary; } $fonts = array(); foreach ($fontResourcesUnique as $resourceId => $fontDictionary) { try { $extractedFont = new Zend_Pdf_Resource_Font_Extracted($fontDictionary); $fonts[$resourceId] = $extractedFont; } catch (Zend_Pdf_Exception $e) { if ($e->getMessage() != 'Unsupported font type.') { throw new Zend_Pdf_Exception($e->getMessage(), $e->getCode(), $e); } } } return $fonts; } public function extractFont($fontName) { if ($this->_dictionary->Resources->Font === null) { return null; } $fontResources = $this->_dictionary->Resources->Font; $fontResourcesUnique = array(); foreach ($fontResources->getKeys() as $fontResourceName) { $fontDictionary = $fontResources->$fontResourceName; if (! ($fontDictionary instanceof Zend_Pdf_Element_Reference || $fontDictionary instanceof Zend_Pdf_Element_Object) ) { throw new Zend_Pdf_Exception('Font dictionary has to be an indirect object or object reference.'); } $resourceId = spl_object_hash($fontDictionary->getObject()); if (isset($fontResourcesUnique[$resourceId])) { continue; } else { $fontResourcesUnique[$resourceId] = 1; } if ($fontDictionary->BaseFont->value != $fontName) { continue; } try { return new Zend_Pdf_Resource_Font_Extracted($fontDictionary); } catch (Zend_Pdf_Exception $e) { if ($e->getMessage() != 'Unsupported font type.') { throw new Zend_Pdf_Exception($e->getMessage(), $e->getCode(), $e); } } } return null; } public function attachAnnotation(Zend_Pdf_Annotation $annotation) { $annotationDictionary = $annotation->getResource(); if (!$annotationDictionary instanceof Zend_Pdf_Element_Object && !$annotationDictionary instanceof Zend_Pdf_Element_Reference) { $annotationDictionary = $this->_objFactory->newObject($annotationDictionary); } if ($this->_dictionary->Annots === null) { $this->_dictionary->touch(); $this->_dictionary->Annots = new Zend_Pdf_Element_Array(); } else { $this->_dictionary->Annots->touch(); } $this->_dictionary->Annots->items[] = $annotationDictionary; $annotationDictionary->touch(); $annotationDictionary->P = $this->_dictionary; return $this; } }

/* @source /library/Zend/Pdf/Exception.php */
class Zend_Pdf_Exception extends Zend_Exception { const NOT_IMPLEMENTED = 0x0001; const DEPRECATED = 0x0002; const TOO_FEW_PARAMETERS = 0x0003; const BAD_PARAMETER_TYPE = 0x0004; const BAD_PARAMETER_VALUE = 0x0005; const PARAMETER_VALUE_OUT_OF_RANGE = 0x0006; const BAD_METHOD_SIGNATURE = 0x0007; const INDEX_OUT_OF_RANGE = 0x0008; const BAD_FILE_PATH = 0x0101; const NOT_READABLE = 0x0102; const NOT_WRITEABLE = 0x0103; const FILE_NOT_OPEN = 0x0104; const CANT_OPEN_FILE = 0x0105; const CANT_GET_FILE_POSITION = 0x0106; const CANT_SET_FILE_POSITION = 0x0107; const MOVE_BEFORE_START_OF_FILE = 0x0108; const MOVE_BEYOND_END_OF_FILE = 0x0109; const CANT_GET_FILE_SIZE = 0x010a; const ERROR_DURING_READ = 0x010b; const ERROR_DURING_WRITE = 0x010c; const INVALID_PAGE_SIZE = 0x010d; const INSUFFICIENT_DATA = 0x010e; const BAD_DATA_SOURCE = 0x0201; const INVALID_BYTE_ORDER = 0x0202; const INVALID_INTEGER_SIZE = 0x0203; const BAD_FIXED_POINT_SIZE = 0x0204; const CANT_READ_STRING = 0x0205; const PARSED_OUT_OF_ORDER = 0x0206; const WRONG_FONT_TYPE = 0x0301; const BAD_TABLE_COUNT = 0x0302; const REQUIRED_TABLE_NOT_FOUND = 0x0303; const DONT_UNDERSTAND_TABLE_VERSION = 0x0303; const BAD_MAGIC_NUMBER = 0x0304; const CANT_FIND_GOOD_CMAP = 0x0305; const CMAP_TYPE_UNSUPPORTED = 0x0401; const CMAP_UNKNOWN_TYPE = 0x0402; const CMAP_TABLE_DATA_TOO_SMALL = 0x0403; const CMAP_WRONG_TABLE_TYPE = 0x0404; const CMAP_WRONG_TABLE_LENGTH = 0x0405; const CMAP_NOT_LANGUAGE_INDEPENDENT = 0x0406; const CMAP_FINAL_OFFSET_NOT_LENGTH = 0x0407; const CMAP_WRONG_ENTRY_COUNT = 0x0408; const GLYPH_OUT_OF_RANGE = 0x0501; const FONT_CANT_BE_EMBEDDED = 0x0502; const BAD_FONT_NAME = 0x0601; const CANT_DETERMINE_FONT_TYPE = 0x0602; const BAD_ATTRIBUTE_VALUE = 0x0701; const CANT_DETERMINE_IMAGE_TYPE = 0x0801; const WRONG_IMAGE_TYPE = 0x0802; const UNSUPPORTED_IMAGE_ENCODING_OPTIONS = 0x0803; const IMAGE_FILE_CORRUPT = 0x0804; }

/* @source /library/Zend/Pdf/UpdateInfoContainer.php */
class Zend_Pdf_UpdateInfoContainer { private $_objNum; private $_genNum; private $_isFree; private $_dump = null; public function __construct($objNum, $genNum, $isFree, $dump = null) { $this->_objNum = $objNum; $this->_genNum = $genNum; $this->_isFree = $isFree; if ($dump !== null) { $this->_dump = $dump; } } public function getObjNum() { return $this->_objNum; } public function getGenNum() { return $this->_genNum; } public function isFree() { return $this->_isFree; } public function getObjectDump() { if ($this->_dump === null) { return ''; } if (is_string($this->_dump)) { return $this->_dump; } return $this->_dump->getRef(); } }

/* @source /library/Zend/Pdf/Canvas.php */
class Zend_Pdf_Canvas extends Zend_Pdf_Canvas_Abstract { protected $_procSet = array(); protected $_width; protected $_height; protected $_resources = array('Font' => array(), 'XObject' => array(), 'ExtGState' => array()); public function __construct($width, $height) { $this->_width = $width; $this->_height = $height; } protected function _addProcSet($procSetName) { $this->_procset[$procSetName] = 1; } protected function _attachResource($type, Zend_Pdf_Resource $resource) { $resObject = $resource->getResource(); foreach ($this->_resources[$type] as $resName => $collectedResObject) { if ($collectedResObject === $resObject) { return $resName; } } $idCounter = 1; do { $newResName = $type[0] . $idCounter++; } while (isset($this->_resources[$type][$newResName])); $this->_resources[$type][$newResName] = $resObject; return $newResName; } public function getResources() { $this->_resources['ProcSet'] = array_keys($this->_procSet); return $this->_resources; } public function getContents() { } public function getHeight() { return $this->_height; } public function getWidth() { return $this->_width; } }

/* @source /library/Zend/Pdf/Action/Trans.php */
class Zend_Pdf_Action_Trans extends Zend_Pdf_Action { }

/* @source /library/Zend/Pdf/Action/ImportData.php */
class Zend_Pdf_Action_ImportData extends Zend_Pdf_Action { }

/* @source /library/Zend/Pdf/Filter/Ascii85.php */
class Zend_Pdf_Filter_Ascii85 implements Zend_Pdf_Filter_Interface { public static function encode($data, $params = null) { $output = ''; $dataLength = strlen($data); for ($i = 0; $i < $dataLength; $i += 4) { $chunk = substr($data, $i, 4); if (strlen($chunk) < 4) { break; } $b = unpack("N", $chunk); $b = $b[1]; if ($b == 0) { $output .= 'z'; continue; } for ($j = 4; $j >= 0; $j--) { $foo = (int) (($b / pow(85,$j)) + 33); $b %= pow(85,$j); $output .= chr($foo); } } if ($i < $dataLength) { $n = $dataLength - $i; $chunk = substr($data, -$n); for ($j = $n;$j < 4;$j++) { $chunk .= "\0"; } $b = unpack("N", $chunk); $b = $b[1]; for ($j = 4; $j >= (4 - $n); $j--) { $foo = (int) (($b / pow(85,$j)) + 33); $b %= pow(85,$j); $output .= chr($foo); } } $output .= '~>'; $output = chunk_split($output, 76, "\n"); $output = substr($output, 0, -1); return $output; } public static function decode($data, $params = null) { $output = ''; $whiteSpace = array("\x00", "\x09", "\x0A", "\x0C", "\x0D", "\x20"); $data = str_replace($whiteSpace, '', $data); if (substr($data, -2) != '~>') { throw new Zend_Pdf_Exception('Invalid EOF marker'); return ''; } $data = substr($data, 0, (strlen($data) - 2)); $dataLength = strlen($data); for ($i = 0; $i < $dataLength; $i += 5) { $b = 0; if (substr($data, $i, 1) == "z") { $i -= 4; $output .= pack("N", 0); continue; } $c = substr($data, $i, 5); if(strlen($c) < 5) { break; } $c = unpack('C5', $c); $value = 0; for ($j = 1; $j <= 5; $j++) { $value += (($c[$j] - 33) * pow(85, (5 - $j))); } $output .= pack("N", $value); } if ($i < $dataLength) { $value = 0; $chunk = substr($data, $i); $partialLength = strlen($chunk); for ($j = 0; $j < (5 - $partialLength); $j++) { $chunk .= 'u'; } $c = unpack('C5', $chunk); for ($j = 1; $j <= 5; $j++) { $value += (($c[$j] - 33) * pow(85, (5 - $j))); } $foo = pack("N", $value); $output .= substr($foo, 0, ($partialLength - 1)); } return $output; } }

/* @source /library/Zend/Pdf/Filter/RunLength.php */
class Zend_Pdf_Filter_RunLength implements Zend_Pdf_Filter_Interface { public static function encode($data, $params = null) { $output = ''; $chainStartOffset = 0; $offset = 0; while ($offset < strlen($data)) { if (($repeatedCharChainLength = strspn($data, $data[$offset], $offset + 1, 127) + 1) > 2) { if ($chainStartOffset != $offset) { $output .= chr($offset - $chainStartOffset - 1) . substr($data, $chainStartOffset, $offset - $chainStartOffset); } $output .= chr(257 - $repeatedCharChainLength) . $data[$offset]; $offset += $repeatedCharChainLength; $chainStartOffset = $offset; } else { $offset++; if ($offset - $chainStartOffset == 128) { $output .= "\x7F" . substr($data, $chainStartOffset, 128); $chainStartOffset = $offset; } } } if ($chainStartOffset != $offset) { $output .= chr($offset - $chainStartOffset - 1) . substr($data, $chainStartOffset, $offset - $chainStartOffset); } $output .= "\x80"; return $output; } public static function decode($data, $params = null) { $dataLength = strlen($data); $output = ''; $offset = 0; while($offset < $dataLength) { $length = ord($data[$offset]); $offset++; if ($length == 128) { break; } else if ($length < 128) { $length++; $output .= substr($data, $offset, $length); $offset += $length; } else if ($length > 128) { $output .= str_repeat($data[$offset], 257 - $length); $offset++; } } return $output; } }

/* @source /library/Zend/Pdf/Filter/AsciiHex.php */
class Zend_Pdf_Filter_AsciiHex implements Zend_Pdf_Filter_Interface { public static function encode($data, $params = null) { return bin2hex($data) . '>'; } public static function decode($data, $params = null) { $output = ''; $oddCode = true; $commentMode = false; for ($count = 0; $count < strlen($data) && $data[$count] != '>'; $count++) { $charCode = ord($data[$count]); if ($commentMode) { if ($charCode == 0x0A || $charCode == 0x0D ) { $commentMode = false; } continue; } switch ($charCode) { case 0x00: case 0x09: case 0x0A: case 0x0C: case 0x0D: case 0x20: break; case 0x25: $commentMode = true; break; default: if ($charCode >= 0x30 && $charCode <= 0x39 ) { $code = $charCode - 0x30; } else if ($charCode >= 0x41 && $charCode <= 0x46 ) { $code = $charCode - 0x37; } else if ($charCode >= 0x61 && $charCode <= 0x66 ) { $code = $charCode - 0x57; } else { throw new Zend_Pdf_Exception('Wrong character in a encoded stream'); } if ($oddCode) { $hexCodeHigh = $code; } else { $output .= chr($hexCodeHigh*16 + $code); } $oddCode = !$oddCode; break; } } if ($data[$count] != '>') { throw new Zend_Pdf_Exception('Wrong encoded stream End Of Data marker.'); } if (!$oddCode) { $output .= chr($hexCodeHigh*16); } return $output; } }

/* @source /library/Zend/Pdf/Action/GoTo3DView.php */
class Zend_Pdf_Action_GoTo3DView extends Zend_Pdf_Action { }

/* @source /library/Zend/Pdf/Action/GoTo.php */
class Zend_Pdf_Action_GoTo extends Zend_Pdf_Action { protected $_destination; public function __construct(Zend_Pdf_Element $dictionary, SplObjectStorage $processedActions) { parent::__construct($dictionary, $processedActions); $this->_destination = Zend_Pdf_Destination::load($dictionary->D); } public static function create($destination) { if (is_string($destination)) { $destination = Zend_Pdf_Destination_Named::create($destination); } if (!$destination instanceof Zend_Pdf_Destination) { throw new Zend_Pdf_Exception('$destination parameter must be a Zend_Pdf_Destination object or string.'); } $dictionary = new Zend_Pdf_Element_Dictionary(); $dictionary->Type = new Zend_Pdf_Element_Name('Action'); $dictionary->S = new Zend_Pdf_Element_Name('GoTo'); $dictionary->Next = null; $dictionary->D = $destination->getResource(); return new Zend_Pdf_Action_GoTo($dictionary, new SplObjectStorage()); } public function setDestination(Zend_Pdf_Destination $destination) { $this->_destination = $destination; $this->_actionDictionary->touch(); $this->_actionDictionary->D = $destination->getResource(); return $this; } public function getDestination() { return $this->_destination; } }

/* @source /library/Zend/Pdf/Action/Rendition.php */
class Zend_Pdf_Action_Rendition extends Zend_Pdf_Action { }

/* @source /library/Zend/Pdf/Action/URI.php */
class Zend_Pdf_Action_URI extends Zend_Pdf_Action { public function __construct(Zend_Pdf_Element $dictionary, SplObjectStorage $processedActions) { parent::__construct($dictionary, $processedActions); if ($dictionary->URI === null) { throw new Zend_Pdf_Exception('URI action dictionary entry is required'); } } protected static function _validateUri($uri) { $scheme = parse_url((string)$uri, PHP_URL_SCHEME); if ($scheme === false || $scheme === null) { throw new Zend_Pdf_Exception('Invalid URI'); } } public static function create($uri, $isMap = false) { self::_validateUri($uri); $dictionary = new Zend_Pdf_Element_Dictionary(); $dictionary->Type = new Zend_Pdf_Element_Name('Action'); $dictionary->S = new Zend_Pdf_Element_Name('URI'); $dictionary->Next = null; $dictionary->URI = new Zend_Pdf_Element_String($uri); if ($isMap) { $dictionary->IsMap = new Zend_Pdf_Element_Boolean(true); } return new Zend_Pdf_Action_URI($dictionary, new SplObjectStorage()); } public function setUri($uri) { $this->_validateUri($uri); $this->_actionDictionary->touch(); $this->_actionDictionary->URI = new Zend_Pdf_Element_String($uri); return $this; } public function getUri() { return $this->_actionDictionary->URI->value; } public function setIsMap($isMap) { $this->_actionDictionary->touch(); if ($isMap) { $this->_actionDictionary->IsMap = new Zend_Pdf_Element_Boolean(true); } else { $this->_actionDictionary->IsMap = null; } return $this; } public function getIsMap() { return $this->_actionDictionary->IsMap !== null && $this->_actionDictionary->IsMap->value; } }

/* @source /library/Zend/Pdf/Action/JavaScript.php */
class Zend_Pdf_Action_JavaScript extends Zend_Pdf_Action { }

/* @source /library/Zend/Pdf/Action/Sound.php */
class Zend_Pdf_Action_Sound extends Zend_Pdf_Action { }

/* @source /library/Zend/Pdf/Action/GoToR.php */
class Zend_Pdf_Action_GoToR extends Zend_Pdf_Action { }

/* @source /library/Zend/Pdf/Action/ResetForm.php */
class Zend_Pdf_Action_ResetForm extends Zend_Pdf_Action { }

/* @source /library/Zend/Pdf/Action/Movie.php */
class Zend_Pdf_Action_Movie extends Zend_Pdf_Action { }

/* @source /library/Zend/Pdf/Action/SubmitForm.php */
class Zend_Pdf_Action_SubmitForm extends Zend_Pdf_Action { }

/* @source /library/Zend/Pdf/Action/SetOCGState.php */
class Zend_Pdf_Action_SetOCGState extends Zend_Pdf_Action { }

/* @source /library/Zend/Pdf/Action/Thread.php */
class Zend_Pdf_Action_Thread extends Zend_Pdf_Action { }

/* @source /library/Zend/Pdf/Action/Unknown.php */
class Zend_Pdf_Action_Unknown extends Zend_Pdf_Action { }

/* @source /library/Zend/Pdf/Trailer/Generator.php */
class Zend_Pdf_Trailer_Generator extends Zend_Pdf_Trailer { public function __construct(Zend_Pdf_Element_Dictionary $dict) { parent::__construct($dict); } public function getPDFLength() { return strlen(Zend_Pdf::PDF_HEADER); } public function getPDFString() { return Zend_Pdf::PDF_HEADER; } public function getLastFreeObject() { return 0; } }

/* @source /library/Zend/Pdf/FileParserDataSource/String.php */
class Zend_Pdf_FileParserDataSource_String extends Zend_Pdf_FileParserDataSource { protected $_string = ''; public function __construct($string) { if (empty($string)) { throw new Zend_Pdf_Exception('String is empty', Zend_Pdf_Exception::PARAMETER_VALUE_OUT_OF_RANGE); } $this->_size = strlen($string); $this->_string = $string; } public function __destruct() { $this->_string = ''; } public function readBytes($byteCount) { if (($this->_offset + $byteCount) > $this->_size) { throw new Zend_Pdf_Exception("Insufficient data to read $byteCount bytes", Zend_Pdf_Exception::INSUFFICIENT_DATA); } $bytes = substr($this->_string, $this->_offset, $byteCount); $this->_offset += $byteCount; return $bytes; } public function readAllBytes() { return $this->_string; } public function __toString() { return "String ($this->_size bytes)"; } }

/* @source /library/Zend/Pdf/Trailer/Keeper.php */
class Zend_Pdf_Trailer_Keeper extends Zend_Pdf_Trailer { private $_context; private $_prev; public function __construct(Zend_Pdf_Element_Dictionary $dict, Zend_Pdf_Element_Reference_Context $context, Zend_Pdf_Trailer $prev = null) { parent::__construct($dict); $this->_context = $context; $this->_prev = $prev; } public function setPrev(Zend_Pdf_Trailer_Keeper $prev) { $this->_prev = $prev; } public function getPrev() { return $this->_prev; } public function getPDFLength() { return $this->_context->getParser()->getLength(); } public function getPDFString() { return $this->_context->getParser()->getString(); } public function getRefTable() { return $this->_context->getRefTable(); } public function getLastFreeObject() { try { $this->_context->getRefTable()->getNextFree('0 65535 R'); } catch (Zend_Pdf_Exception $e) { if ($e->getMessage() == 'Object not found.') { return 0; } throw new Zend_Pdf_Exception($e->getMessage(), $e->getCode(), $e); } } }

/* @source /library/Zend/Pdf/Element/Numeric.php */
class Zend_Pdf_Element_Numeric extends Zend_Pdf_Element { public $value; public function __construct($val) { if ( !is_numeric($val) ) { throw new Zend_Pdf_Exception('Argument must be numeric'); } $this->value = $val; } public function getType() { return Zend_Pdf_Element::TYPE_NUMERIC; } public function toString($factory = null) { if (is_integer($this->value)) { return (string)$this->value; } $prec = 0; $v = $this->value; while (abs( floor($v) - $v ) > 1e-10) { $prec++; $v *= 10; } return sprintf("%.{$prec}F", $this->value); } }

/* @source /library/Zend/Pdf/Color/Cmyk.php */
class Zend_Pdf_Color_Cmyk extends Zend_Pdf_Color { private $_c; private $_m; private $_y; private $_k; public function __construct($c, $m, $y, $k) { if ($c < 0) { $c = 0; } if ($c > 1) { $c = 1; } if ($m < 0) { $m = 0; } if ($m > 1) { $m = 1; } if ($y < 0) { $y = 0; } if ($y > 1) { $y = 1; } if ($k < 0) { $k = 0; } if ($k > 1) { $k = 1; } $this->_c = new Zend_Pdf_Element_Numeric($c); $this->_m = new Zend_Pdf_Element_Numeric($m); $this->_y = new Zend_Pdf_Element_Numeric($y); $this->_k = new Zend_Pdf_Element_Numeric($k); } public function instructions($stroking) { return $this->_c->toString() . ' ' . $this->_m->toString() . ' ' . $this->_y->toString() . ' ' . $this->_k->toString() . ($stroking? " K\n" : " k\n"); } public function getComponents() { return array($this->_c->value, $this->_m->value, $this->_y->value, $this->_k->value); } }

/* @source /library/Zend/Pdf/Annotation/Text.php */
class Zend_Pdf_Annotation_Text extends Zend_Pdf_Annotation { public function __construct(Zend_Pdf_Element $annotationDictionary) { if ($annotationDictionary->getType() != Zend_Pdf_Element::TYPE_DICTIONARY) { throw new Zend_Pdf_Exception('Annotation dictionary resource has to be a dictionary.'); } if ($annotationDictionary->Subtype === null || $annotationDictionary->Subtype->getType() != Zend_Pdf_Element::TYPE_NAME || $annotationDictionary->Subtype->value != 'Text') { throw new Zend_Pdf_Exception('Subtype => Text entry is requires'); } parent::__construct($annotationDictionary); } public static function create($x1, $y1, $x2, $y2, $text) { $annotationDictionary = new Zend_Pdf_Element_Dictionary(); $annotationDictionary->Type = new Zend_Pdf_Element_Name('Annot'); $annotationDictionary->Subtype = new Zend_Pdf_Element_Name('Text'); $rectangle = new Zend_Pdf_Element_Array(); $rectangle->items[] = new Zend_Pdf_Element_Numeric($x1); $rectangle->items[] = new Zend_Pdf_Element_Numeric($y1); $rectangle->items[] = new Zend_Pdf_Element_Numeric($x2); $rectangle->items[] = new Zend_Pdf_Element_Numeric($y2); $annotationDictionary->Rect = $rectangle; $annotationDictionary->Contents = new Zend_Pdf_Element_String($text); return new Zend_Pdf_Annotation_Text($annotationDictionary); } }

/* @source /library/Zend/Pdf/Annotation/Markup.php */
class Zend_Pdf_Annotation_Markup extends Zend_Pdf_Annotation { const SUBTYPE_HIGHLIGHT = 'Highlight'; const SUBTYPE_UNDERLINE = 'Underline'; const SUBTYPE_SQUIGGLY = 'Squiggly'; const SUBTYPE_STRIKEOUT = 'StrikeOut'; public function __construct(Zend_Pdf_Element $annotationDictionary) { if ($annotationDictionary->getType() != Zend_Pdf_Element::TYPE_DICTIONARY) { throw new Zend_Pdf_Exception('Annotation dictionary resource has to be a dictionary.'); } if ($annotationDictionary->Subtype === null || $annotationDictionary->Subtype->getType() != Zend_Pdf_Element::TYPE_NAME || !in_array( $annotationDictionary->Subtype->value, array(self::SUBTYPE_HIGHLIGHT, self::SUBTYPE_UNDERLINE, self::SUBTYPE_SQUIGGLY, self::SUBTYPE_STRIKEOUT) )) { throw new Zend_Pdf_Exception('Subtype => Markup entry is omitted or has wrong value.'); } parent::__construct($annotationDictionary); } public static function create($x1, $y1, $x2, $y2, $text, $subType, $quadPoints) { $annotationDictionary = new Zend_Pdf_Element_Dictionary(); $annotationDictionary->Type = new Zend_Pdf_Element_Name('Annot'); $annotationDictionary->Subtype = new Zend_Pdf_Element_Name($subType); $rectangle = new Zend_Pdf_Element_Array(); $rectangle->items[] = new Zend_Pdf_Element_Numeric($x1); $rectangle->items[] = new Zend_Pdf_Element_Numeric($y1); $rectangle->items[] = new Zend_Pdf_Element_Numeric($x2); $rectangle->items[] = new Zend_Pdf_Element_Numeric($y2); $annotationDictionary->Rect = $rectangle; $annotationDictionary->Contents = new Zend_Pdf_Element_String($text); if (!is_array($quadPoints) || count($quadPoints) == 0 || count($quadPoints) % 8 != 0) { throw new Zend_Pdf_Exception('$quadPoints parameter must be an array of 8xN numbers'); } $points = new Zend_Pdf_Element_Array(); foreach ($quadPoints as $quadPoint) { $points->items[] = new Zend_Pdf_Element_Numeric($quadPoint); } $annotationDictionary->QuadPoints = $points; return new Zend_Pdf_Annotation_Markup($annotationDictionary); } }

/* @source /library/Zend/Pdf/Annotation/Link.php */
class Zend_Pdf_Annotation_Link extends Zend_Pdf_Annotation { public function __construct(Zend_Pdf_Element $annotationDictionary) { if ($annotationDictionary->getType() != Zend_Pdf_Element::TYPE_DICTIONARY) { throw new Zend_Pdf_Exception('Annotation dictionary resource has to be a dictionary.'); } if ($annotationDictionary->Subtype === null || $annotationDictionary->Subtype->getType() != Zend_Pdf_Element::TYPE_NAME || $annotationDictionary->Subtype->value != 'Link') { throw new Zend_Pdf_Exception('Subtype => Link entry is requires'); } parent::__construct($annotationDictionary); } public static function create($x1, $y1, $x2, $y2, $target) { if (is_string($target)) { $target = Zend_Pdf_Destination_Named::create($target); } if (!$target instanceof Zend_Pdf_Target) { throw new Zend_Pdf_Exception('$target parameter must be a Zend_Pdf_Target object or a string.'); } $annotationDictionary = new Zend_Pdf_Element_Dictionary(); $annotationDictionary->Type = new Zend_Pdf_Element_Name('Annot'); $annotationDictionary->Subtype = new Zend_Pdf_Element_Name('Link'); $rectangle = new Zend_Pdf_Element_Array(); $rectangle->items[] = new Zend_Pdf_Element_Numeric($x1); $rectangle->items[] = new Zend_Pdf_Element_Numeric($y1); $rectangle->items[] = new Zend_Pdf_Element_Numeric($x2); $rectangle->items[] = new Zend_Pdf_Element_Numeric($y2); $annotationDictionary->Rect = $rectangle; if ($target instanceof Zend_Pdf_Destination) { $annotationDictionary->Dest = $target->getResource(); } else { $annotationDictionary->A = $target->getResource(); } return new Zend_Pdf_Annotation_Link($annotationDictionary); } public function setDestination($target) { if (is_string($target)) { $destination = Zend_Pdf_Destination_Named::create($target); } if (!$target instanceof Zend_Pdf_Target) { throw new Zend_Pdf_Exception('$target parameter must be a Zend_Pdf_Target object or a string.'); } $this->_annotationDictionary->touch(); $this->_annotationDictionary->Dest = $destination->getResource(); if ($target instanceof Zend_Pdf_Destination) { $this->_annotationDictionary->Dest = $target->getResource(); $this->_annotationDictionary->A = null; } else { $this->_annotationDictionary->Dest = null; $this->_annotationDictionary->A = $target->getResource(); } return $this; } public function getDestination() { if ($this->_annotationDictionary->Dest === null && $this->_annotationDictionary->A === null) { return null; } if ($this->_annotationDictionary->Dest !== null) { return Zend_Pdf_Destination::load($this->_annotationDictionary->Dest); } else { return Zend_Pdf_Action::load($this->_annotationDictionary->A); } } }

/* @source /library/Zend/Pdf/Annotation/FileAttachment.php */
class Zend_Pdf_Annotation_FileAttachment extends Zend_Pdf_Annotation { public function __construct(Zend_Pdf_Element $annotationDictionary) { if ($annotationDictionary->getType() != Zend_Pdf_Element::TYPE_DICTIONARY) { throw new Zend_Pdf_Exception('Annotation dictionary resource has to be a dictionary.'); } if ($annotationDictionary->Subtype === null || $annotationDictionary->Subtype->getType() != Zend_Pdf_Element::TYPE_NAME || $annotationDictionary->Subtype->value != 'FileAttachment') { throw new Zend_Pdf_Exception('Subtype => FileAttachment entry is requires'); } parent::__construct($annotationDictionary); } public static function create($x1, $y1, $x2, $y2, $fileSpecification) { $annotationDictionary = new Zend_Pdf_Element_Dictionary(); $annotationDictionary->Type = new Zend_Pdf_Element_Name('Annot'); $annotationDictionary->Subtype = new Zend_Pdf_Element_Name('FileAttachment'); $rectangle = new Zend_Pdf_Element_Array(); $rectangle->items[] = new Zend_Pdf_Element_Numeric($x1); $rectangle->items[] = new Zend_Pdf_Element_Numeric($y1); $rectangle->items[] = new Zend_Pdf_Element_Numeric($x2); $rectangle->items[] = new Zend_Pdf_Element_Numeric($y2); $annotationDictionary->Rect = $rectangle; $fsDictionary = new Zend_Pdf_Element_Dictionary(); $fsDictionary->Type = new Zend_Pdf_Element_Name('Filespec'); $fsDictionary->F = new Zend_Pdf_Element_String($fileSpecification); $annotationDictionary->FS = $fsDictionary; return new Zend_Pdf_Annotation_FileAttachment($annotationDictionary); } }

/* @source /library/Zend/Pdf/Cmap/TrimmedTable.php */
class Zend_Pdf_Cmap_TrimmedTable extends Zend_Pdf_Cmap { protected $_startCode = 0; protected $_endCode = 0; protected $_glyphIndexArray = array(); public function glyphNumbersForCharacters($characterCodes) { $glyphNumbers = array(); foreach ($characterCodes as $key => $characterCode) { if (($characterCode < $this->_startCode) || ($characterCode > $this->_endCode)) { $glyphNumbers[$key] = Zend_Pdf_Cmap::MISSING_CHARACTER_GLYPH; continue; } $glyphIndex = $characterCode - $this->_startCode; $glyphNumbers[$key] = $this->_glyphIndexArray[$glyphIndex]; } return $glyphNumbers; } public function glyphNumberForCharacter($characterCode) { if (($characterCode < $this->_startCode) || ($characterCode > $this->_endCode)) { return Zend_Pdf_Cmap::MISSING_CHARACTER_GLYPH; } $glyphIndex = $characterCode - $this->_startCode; return $this->_glyphIndexArray[$glyphIndex]; } public function getCoveredCharacters() { $characterCodes = array(); for ($code = $this->_startCode; $code <= $this->_endCode; $code++) { $characterCodes[] = $code; } return $characterCodes; } public function getCoveredCharactersGlyphs() { $glyphNumbers = array(); for ($code = $this->_startCode; $code <= $this->_endCode; $code++) { $glyphNumbers[$code] = $this->_glyphIndexArray[$code - $this->_startCode]; } return $glyphNumbers; } public function __construct($cmapData) { $actualLength = strlen($cmapData); if ($actualLength < 9) { throw new Zend_Pdf_Exception('Insufficient table data', Zend_Pdf_Exception::CMAP_TABLE_DATA_TOO_SMALL); } $type = $this->_extractUInt2($cmapData, 0); if ($type != Zend_Pdf_Cmap::TYPE_TRIMMED_TABLE) { throw new Zend_Pdf_Exception('Wrong cmap table type', Zend_Pdf_Exception::CMAP_WRONG_TABLE_TYPE); } $length = $this->_extractUInt2($cmapData, 2); if ($length != $actualLength) { throw new Zend_Pdf_Exception("Table length ($length) does not match actual length ($actualLength)", Zend_Pdf_Exception::CMAP_WRONG_TABLE_LENGTH); } $language = $this->_extractUInt2($cmapData, 4); if ($language != 0) { } $this->_startCode = $this->_extractUInt2($cmapData, 6); $entryCount = $this->_extractUInt2($cmapData, 8); $expectedCount = ($length - 10) >> 1; if ($entryCount != $expectedCount) { throw new Zend_Pdf_Exception("Entry count is wrong; expected: $expectedCount; actual: $entryCount", Zend_Pdf_Exception::CMAP_WRONG_ENTRY_COUNT); } $this->_endCode = $this->_startCode + $entryCount - 1; $offset = 10; for ($i = 0; $i < $entryCount; $i++, $offset += 2) { $this->_glyphIndexArray[] = $this->_extractUInt2($cmapData, $offset); } if ($offset != $length) { throw new Zend_Pdf_Exception("Ending offset ($offset) does not match length ($length)", Zend_Pdf_Exception::CMAP_FINAL_OFFSET_NOT_LENGTH); } } }

/* @source /library/Zend/Pdf/Cmap/ByteEncoding.php */
class Zend_Pdf_Cmap_ByteEncoding extends Zend_Pdf_Cmap { protected $_glyphIndexArray = array(); public function glyphNumbersForCharacters($characterCodes) { $glyphNumbers = array(); foreach ($characterCodes as $key => $characterCode) { if (! isset($this->_glyphIndexArray[$characterCode])) { $glyphNumbers[$key] = Zend_Pdf_Cmap::MISSING_CHARACTER_GLYPH; continue; } $glyphNumbers[$key] = $this->_glyphIndexArray[$characterCode]; } return $glyphNumbers; } public function glyphNumberForCharacter($characterCode) { if (! isset($this->_glyphIndexArray[$characterCode])) { return Zend_Pdf_Cmap::MISSING_CHARACTER_GLYPH; } return $this->_glyphIndexArray[$characterCode]; } public function getCoveredCharacters() { return array_keys($this->_glyphIndexArray); } public function getCoveredCharactersGlyphs() { return $this->_glyphIndexArray; } public function __construct($cmapData) { $actualLength = strlen($cmapData); if ($actualLength != 262) { throw new Zend_Pdf_Exception('Insufficient table data', Zend_Pdf_Exception::CMAP_TABLE_DATA_TOO_SMALL); } $type = $this->_extractUInt2($cmapData, 0); if ($type != Zend_Pdf_Cmap::TYPE_BYTE_ENCODING) { throw new Zend_Pdf_Exception('Wrong cmap table type', Zend_Pdf_Exception::CMAP_WRONG_TABLE_TYPE); } $length = $this->_extractUInt2($cmapData, 2); if ($length != $actualLength) { throw new Zend_Pdf_Exception("Table length ($length) does not match actual length ($actualLength)", Zend_Pdf_Exception::CMAP_WRONG_TABLE_LENGTH); } $language = $this->_extractUInt2($cmapData, 4); if ($language != 0) { } $i = 6; $this->_glyphIndexArray[0x00] = ord($cmapData[$i++]); $this->_glyphIndexArray[0x01] = ord($cmapData[$i++]); $this->_glyphIndexArray[0x02] = ord($cmapData[$i++]); $this->_glyphIndexArray[0x03] = ord($cmapData[$i++]); $this->_glyphIndexArray[0x04] = ord($cmapData[$i++]); $this->_glyphIndexArray[0x05] = ord($cmapData[$i++]); $this->_glyphIndexArray[0x06] = ord($cmapData[$i++]); $this->_glyphIndexArray[0x07] = ord($cmapData[$i++]); $this->_glyphIndexArray[0x08] = ord($cmapData[$i++]); $this->_glyphIndexArray[0x09] = ord($cmapData[$i++]); $this->_glyphIndexArray[0x0a] = ord($cmapData[$i++]); $this->_glyphIndexArray[0x0b] = ord($cmapData[$i++]); $this->_glyphIndexArray[0x0c] = ord($cmapData[$i++]); $this->_glyphIndexArray[0x0d] = ord($cmapData[$i++]); $this->_glyphIndexArray[0x0e] = ord($cmapData[$i++]); $this->_glyphIndexArray[0x0f] = ord($cmapData[$i++]); $this->_glyphIndexArray[0x10] = ord($cmapData[$i++]); $this->_glyphIndexArray[0x11] = ord($cmapData[$i++]); $this->_glyphIndexArray[0x12] = ord($cmapData[$i++]); $this->_glyphIndexArray[0x13] = ord($cmapData[$i++]); $this->_glyphIndexArray[0x14] = ord($cmapData[$i++]); $this->_glyphIndexArray[0x15] = ord($cmapData[$i++]); $this->_glyphIndexArray[0x16] = ord($cmapData[$i++]); $this->_glyphIndexArray[0x17] = ord($cmapData[$i++]); $this->_glyphIndexArray[0x18] = ord($cmapData[$i++]); $this->_glyphIndexArray[0x19] = ord($cmapData[$i++]); $this->_glyphIndexArray[0x1a] = ord($cmapData[$i++]); $this->_glyphIndexArray[0x1b] = ord($cmapData[$i++]); $this->_glyphIndexArray[0x1c] = ord($cmapData[$i++]); $this->_glyphIndexArray[0x1d] = ord($cmapData[$i++]); $this->_glyphIndexArray[0x1e] = ord($cmapData[$i++]); $this->_glyphIndexArray[0x1f] = ord($cmapData[$i++]); $this->_glyphIndexArray[0x20] = ord($cmapData[$i++]); $this->_glyphIndexArray[0x21] = ord($cmapData[$i++]); $this->_glyphIndexArray[0x22] = ord($cmapData[$i++]); $this->_glyphIndexArray[0x23] = ord($cmapData[$i++]); $this->_glyphIndexArray[0x24] = ord($cmapData[$i++]); $this->_glyphIndexArray[0x25] = ord($cmapData[$i++]); $this->_glyphIndexArray[0x26] = ord($cmapData[$i++]); $this->_glyphIndexArray[0x27] = ord($cmapData[$i++]); $this->_glyphIndexArray[0x28] = ord($cmapData[$i++]); $this->_glyphIndexArray[0x29] = ord($cmapData[$i++]); $this->_glyphIndexArray[0x2a] = ord($cmapData[$i++]); $this->_glyphIndexArray[0x2b] = ord($cmapData[$i++]); $this->_glyphIndexArray[0x2c] = ord($cmapData[$i++]); $this->_glyphIndexArray[0x2d] = ord($cmapData[$i++]); $this->_glyphIndexArray[0x2e] = ord($cmapData[$i++]); $this->_glyphIndexArray[0x2f] = ord($cmapData[$i++]); $this->_glyphIndexArray[0x30] = ord($cmapData[$i++]); $this->_glyphIndexArray[0x31] = ord($cmapData[$i++]); $this->_glyphIndexArray[0x32] = ord($cmapData[$i++]); $this->_glyphIndexArray[0x33] = ord($cmapData[$i++]); $this->_glyphIndexArray[0x34] = ord($cmapData[$i++]); $this->_glyphIndexArray[0x35] = ord($cmapData[$i++]); $this->_glyphIndexArray[0x36] = ord($cmapData[$i++]); $this->_glyphIndexArray[0x37] = ord($cmapData[$i++]); $this->_glyphIndexArray[0x38] = ord($cmapData[$i++]); $this->_glyphIndexArray[0x39] = ord($cmapData[$i++]); $this->_glyphIndexArray[0x3a] = ord($cmapData[$i++]); $this->_glyphIndexArray[0x3b] = ord($cmapData[$i++]); $this->_glyphIndexArray[0x3c] = ord($cmapData[$i++]); $this->_glyphIndexArray[0x3d] = ord($cmapData[$i++]); $this->_glyphIndexArray[0x3e] = ord($cmapData[$i++]); $this->_glyphIndexArray[0x3f] = ord($cmapData[$i++]); $this->_glyphIndexArray[0x40] = ord($cmapData[$i++]); $this->_glyphIndexArray[0x41] = ord($cmapData[$i++]); $this->_glyphIndexArray[0x42] = ord($cmapData[$i++]); $this->_glyphIndexArray[0x43] = ord($cmapData[$i++]); $this->_glyphIndexArray[0x44] = ord($cmapData[$i++]); $this->_glyphIndexArray[0x45] = ord($cmapData[$i++]); $this->_glyphIndexArray[0x46] = ord($cmapData[$i++]); $this->_glyphIndexArray[0x47] = ord($cmapData[$i++]); $this->_glyphIndexArray[0x48] = ord($cmapData[$i++]); $this->_glyphIndexArray[0x49] = ord($cmapData[$i++]); $this->_glyphIndexArray[0x4a] = ord($cmapData[$i++]); $this->_glyphIndexArray[0x4b] = ord($cmapData[$i++]); $this->_glyphIndexArray[0x4c] = ord($cmapData[$i++]); $this->_glyphIndexArray[0x4d] = ord($cmapData[$i++]); $this->_glyphIndexArray[0x4e] = ord($cmapData[$i++]); $this->_glyphIndexArray[0x4f] = ord($cmapData[$i++]); $this->_glyphIndexArray[0x50] = ord($cmapData[$i++]); $this->_glyphIndexArray[0x51] = ord($cmapData[$i++]); $this->_glyphIndexArray[0x52] = ord($cmapData[$i++]); $this->_glyphIndexArray[0x53] = ord($cmapData[$i++]); $this->_glyphIndexArray[0x54] = ord($cmapData[$i++]); $this->_glyphIndexArray[0x55] = ord($cmapData[$i++]); $this->_glyphIndexArray[0x56] = ord($cmapData[$i++]); $this->_glyphIndexArray[0x57] = ord($cmapData[$i++]); $this->_glyphIndexArray[0x58] = ord($cmapData[$i++]); $this->_glyphIndexArray[0x59] = ord($cmapData[$i++]); $this->_glyphIndexArray[0x5a] = ord($cmapData[$i++]); $this->_glyphIndexArray[0x5b] = ord($cmapData[$i++]); $this->_glyphIndexArray[0x5c] = ord($cmapData[$i++]); $this->_glyphIndexArray[0x5d] = ord($cmapData[$i++]); $this->_glyphIndexArray[0x5e] = ord($cmapData[$i++]); $this->_glyphIndexArray[0x5f] = ord($cmapData[$i++]); $this->_glyphIndexArray[0x60] = ord($cmapData[$i++]); $this->_glyphIndexArray[0x61] = ord($cmapData[$i++]); $this->_glyphIndexArray[0x62] = ord($cmapData[$i++]); $this->_glyphIndexArray[0x63] = ord($cmapData[$i++]); $this->_glyphIndexArray[0x64] = ord($cmapData[$i++]); $this->_glyphIndexArray[0x65] = ord($cmapData[$i++]); $this->_glyphIndexArray[0x66] = ord($cmapData[$i++]); $this->_glyphIndexArray[0x67] = ord($cmapData[$i++]); $this->_glyphIndexArray[0x68] = ord($cmapData[$i++]); $this->_glyphIndexArray[0x69] = ord($cmapData[$i++]); $this->_glyphIndexArray[0x6a] = ord($cmapData[$i++]); $this->_glyphIndexArray[0x6b] = ord($cmapData[$i++]); $this->_glyphIndexArray[0x6c] = ord($cmapData[$i++]); $this->_glyphIndexArray[0x6d] = ord($cmapData[$i++]); $this->_glyphIndexArray[0x6e] = ord($cmapData[$i++]); $this->_glyphIndexArray[0x6f] = ord($cmapData[$i++]); $this->_glyphIndexArray[0x70] = ord($cmapData[$i++]); $this->_glyphIndexArray[0x71] = ord($cmapData[$i++]); $this->_glyphIndexArray[0x72] = ord($cmapData[$i++]); $this->_glyphIndexArray[0x73] = ord($cmapData[$i++]); $this->_glyphIndexArray[0x74] = ord($cmapData[$i++]); $this->_glyphIndexArray[0x75] = ord($cmapData[$i++]); $this->_glyphIndexArray[0x76] = ord($cmapData[$i++]); $this->_glyphIndexArray[0x77] = ord($cmapData[$i++]); $this->_glyphIndexArray[0x78] = ord($cmapData[$i++]); $this->_glyphIndexArray[0x79] = ord($cmapData[$i++]); $this->_glyphIndexArray[0x7a] = ord($cmapData[$i++]); $this->_glyphIndexArray[0x7b] = ord($cmapData[$i++]); $this->_glyphIndexArray[0x7c] = ord($cmapData[$i++]); $this->_glyphIndexArray[0x7d] = ord($cmapData[$i++]); $this->_glyphIndexArray[0x7e] = ord($cmapData[$i++]); $this->_glyphIndexArray[0x7f] = ord($cmapData[$i++]); $this->_glyphIndexArray[0xc4] = ord($cmapData[$i++]); $this->_glyphIndexArray[0xc5] = ord($cmapData[$i++]); $this->_glyphIndexArray[0xc7] = ord($cmapData[$i++]); $this->_glyphIndexArray[0xc9] = ord($cmapData[$i++]); $this->_glyphIndexArray[0xd1] = ord($cmapData[$i++]); $this->_glyphIndexArray[0xd6] = ord($cmapData[$i++]); $this->_glyphIndexArray[0xdc] = ord($cmapData[$i++]); $this->_glyphIndexArray[0xe1] = ord($cmapData[$i++]); $this->_glyphIndexArray[0xe0] = ord($cmapData[$i++]); $this->_glyphIndexArray[0xe2] = ord($cmapData[$i++]); $this->_glyphIndexArray[0xe4] = ord($cmapData[$i++]); $this->_glyphIndexArray[0xe3] = ord($cmapData[$i++]); $this->_glyphIndexArray[0xe5] = ord($cmapData[$i++]); $this->_glyphIndexArray[0xe7] = ord($cmapData[$i++]); $this->_glyphIndexArray[0xe9] = ord($cmapData[$i++]); $this->_glyphIndexArray[0xe8] = ord($cmapData[$i++]); $this->_glyphIndexArray[0xea] = ord($cmapData[$i++]); $this->_glyphIndexArray[0xeb] = ord($cmapData[$i++]); $this->_glyphIndexArray[0xed] = ord($cmapData[$i++]); $this->_glyphIndexArray[0xec] = ord($cmapData[$i++]); $this->_glyphIndexArray[0xee] = ord($cmapData[$i++]); $this->_glyphIndexArray[0xef] = ord($cmapData[$i++]); $this->_glyphIndexArray[0xf1] = ord($cmapData[$i++]); $this->_glyphIndexArray[0xf3] = ord($cmapData[$i++]); $this->_glyphIndexArray[0xf2] = ord($cmapData[$i++]); $this->_glyphIndexArray[0xf4] = ord($cmapData[$i++]); $this->_glyphIndexArray[0xf6] = ord($cmapData[$i++]); $this->_glyphIndexArray[0xf5] = ord($cmapData[$i++]); $this->_glyphIndexArray[0xfa] = ord($cmapData[$i++]); $this->_glyphIndexArray[0xf9] = ord($cmapData[$i++]); $this->_glyphIndexArray[0xfb] = ord($cmapData[$i++]); $this->_glyphIndexArray[0xfc] = ord($cmapData[$i++]); $this->_glyphIndexArray[0x2020] = ord($cmapData[$i++]); $this->_glyphIndexArray[0xb0] = ord($cmapData[$i++]); $this->_glyphIndexArray[0xa2] = ord($cmapData[$i++]); $this->_glyphIndexArray[0xa3] = ord($cmapData[$i++]); $this->_glyphIndexArray[0xa7] = ord($cmapData[$i++]); $this->_glyphIndexArray[0x2022] = ord($cmapData[$i++]); $this->_glyphIndexArray[0xb6] = ord($cmapData[$i++]); $this->_glyphIndexArray[0xdf] = ord($cmapData[$i++]); $this->_glyphIndexArray[0xae] = ord($cmapData[$i++]); $this->_glyphIndexArray[0xa9] = ord($cmapData[$i++]); $this->_glyphIndexArray[0x2122] = ord($cmapData[$i++]); $this->_glyphIndexArray[0xb4] = ord($cmapData[$i++]); $this->_glyphIndexArray[0xa8] = ord($cmapData[$i++]); $this->_glyphIndexArray[0x2260] = ord($cmapData[$i++]); $this->_glyphIndexArray[0xc6] = ord($cmapData[$i++]); $this->_glyphIndexArray[0xd8] = ord($cmapData[$i++]); $this->_glyphIndexArray[0x221e] = ord($cmapData[$i++]); $this->_glyphIndexArray[0xb1] = ord($cmapData[$i++]); $this->_glyphIndexArray[0x2264] = ord($cmapData[$i++]); $this->_glyphIndexArray[0x2265] = ord($cmapData[$i++]); $this->_glyphIndexArray[0xa5] = ord($cmapData[$i++]); $this->_glyphIndexArray[0xb5] = ord($cmapData[$i++]); $this->_glyphIndexArray[0x2202] = ord($cmapData[$i++]); $this->_glyphIndexArray[0x2211] = ord($cmapData[$i++]); $this->_glyphIndexArray[0x220f] = ord($cmapData[$i++]); $this->_glyphIndexArray[0x03c0] = ord($cmapData[$i++]); $this->_glyphIndexArray[0x222b] = ord($cmapData[$i++]); $this->_glyphIndexArray[0xaa] = ord($cmapData[$i++]); $this->_glyphIndexArray[0xba] = ord($cmapData[$i++]); $this->_glyphIndexArray[0x03a9] = ord($cmapData[$i++]); $this->_glyphIndexArray[0xe6] = ord($cmapData[$i++]); $this->_glyphIndexArray[0xf8] = ord($cmapData[$i++]); $this->_glyphIndexArray[0xbf] = ord($cmapData[$i++]); $this->_glyphIndexArray[0xa1] = ord($cmapData[$i++]); $this->_glyphIndexArray[0xac] = ord($cmapData[$i++]); $this->_glyphIndexArray[0x221a] = ord($cmapData[$i++]); $this->_glyphIndexArray[0x0192] = ord($cmapData[$i++]); $this->_glyphIndexArray[0x2248] = ord($cmapData[$i++]); $this->_glyphIndexArray[0x2206] = ord($cmapData[$i++]); $this->_glyphIndexArray[0xab] = ord($cmapData[$i++]); $this->_glyphIndexArray[0xbb] = ord($cmapData[$i++]); $this->_glyphIndexArray[0x2026] = ord($cmapData[$i++]); $this->_glyphIndexArray[0xa0] = ord($cmapData[$i++]); $this->_glyphIndexArray[0xc0] = ord($cmapData[$i++]); $this->_glyphIndexArray[0xc3] = ord($cmapData[$i++]); $this->_glyphIndexArray[0xd5] = ord($cmapData[$i++]); $this->_glyphIndexArray[0x0152] = ord($cmapData[$i++]); $this->_glyphIndexArray[0x0153] = ord($cmapData[$i++]); $this->_glyphIndexArray[0x2013] = ord($cmapData[$i++]); $this->_glyphIndexArray[0x2014] = ord($cmapData[$i++]); $this->_glyphIndexArray[0x201c] = ord($cmapData[$i++]); $this->_glyphIndexArray[0x201d] = ord($cmapData[$i++]); $this->_glyphIndexArray[0x2018] = ord($cmapData[$i++]); $this->_glyphIndexArray[0x2019] = ord($cmapData[$i++]); $this->_glyphIndexArray[0xf7] = ord($cmapData[$i++]); $this->_glyphIndexArray[0x25ca] = ord($cmapData[$i++]); $this->_glyphIndexArray[0xff] = ord($cmapData[$i++]); $this->_glyphIndexArray[0x0178] = ord($cmapData[$i++]); $this->_glyphIndexArray[0x2044] = ord($cmapData[$i++]); $this->_glyphIndexArray[0x20ac] = ord($cmapData[$i++]); $this->_glyphIndexArray[0x2039] = ord($cmapData[$i++]); $this->_glyphIndexArray[0x203a] = ord($cmapData[$i++]); $this->_glyphIndexArray[0xfb01] = ord($cmapData[$i++]); $this->_glyphIndexArray[0xfb02] = ord($cmapData[$i++]); $this->_glyphIndexArray[0x2021] = ord($cmapData[$i++]); $this->_glyphIndexArray[0xb7] = ord($cmapData[$i++]); $this->_glyphIndexArray[0x201a] = ord($cmapData[$i++]); $this->_glyphIndexArray[0x201e] = ord($cmapData[$i++]); $this->_glyphIndexArray[0x2030] = ord($cmapData[$i++]); $this->_glyphIndexArray[0xc2] = ord($cmapData[$i++]); $this->_glyphIndexArray[0xca] = ord($cmapData[$i++]); $this->_glyphIndexArray[0xc1] = ord($cmapData[$i++]); $this->_glyphIndexArray[0xcb] = ord($cmapData[$i++]); $this->_glyphIndexArray[0xc8] = ord($cmapData[$i++]); $this->_glyphIndexArray[0xcd] = ord($cmapData[$i++]); $this->_glyphIndexArray[0xce] = ord($cmapData[$i++]); $this->_glyphIndexArray[0xcf] = ord($cmapData[$i++]); $this->_glyphIndexArray[0xcc] = ord($cmapData[$i++]); $this->_glyphIndexArray[0xd3] = ord($cmapData[$i++]); $this->_glyphIndexArray[0xd4] = ord($cmapData[$i++]); $this->_glyphIndexArray[0xf8ff] = ord($cmapData[$i++]); $this->_glyphIndexArray[0xd2] = ord($cmapData[$i++]); $this->_glyphIndexArray[0xda] = ord($cmapData[$i++]); $this->_glyphIndexArray[0xdb] = ord($cmapData[$i++]); $this->_glyphIndexArray[0xd9] = ord($cmapData[$i++]); $this->_glyphIndexArray[0x0131] = ord($cmapData[$i++]); $this->_glyphIndexArray[0x02c6] = ord($cmapData[$i++]); $this->_glyphIndexArray[0x02dc] = ord($cmapData[$i++]); $this->_glyphIndexArray[0xaf] = ord($cmapData[$i++]); $this->_glyphIndexArray[0x02d8] = ord($cmapData[$i++]); $this->_glyphIndexArray[0x02d9] = ord($cmapData[$i++]); $this->_glyphIndexArray[0x02da] = ord($cmapData[$i++]); $this->_glyphIndexArray[0xb8] = ord($cmapData[$i++]); $this->_glyphIndexArray[0x02dd] = ord($cmapData[$i++]); $this->_glyphIndexArray[0x02db] = ord($cmapData[$i++]); $this->_glyphIndexArray[0x02c7] = ord($cmapData[$i]); } }

/* @source /library/Zend/Pdf/Cmap/SegmentToDelta.php */
class Zend_Pdf_Cmap_SegmentToDelta extends Zend_Pdf_Cmap { protected $_segmentCount = 0; protected $_searchRange = 0; protected $_searchIterations = 0; protected $_segmentTableEndCodes = array(); protected $_searchRangeEndCode = 0; protected $_segmentTableStartCodes = array(); protected $_segmentTableIdDeltas = array(); protected $_segmentTableIdRangeOffsets = array(); protected $_glyphIndexArray = array(); public function glyphNumbersForCharacters($characterCodes) { $glyphNumbers = array(); foreach ($characterCodes as $key => $characterCode) { if ($characterCode > 0xffff) { $glyphNumbers[$key] = Zend_Pdf_Cmap::MISSING_CHARACTER_GLYPH; continue; } if ($this->_searchRangeEndCode >= $characterCode) { $searchIndex = $this->_searchRange; } else { $searchIndex = $this->_segmentCount; } for ($i = 1; $i <= $this->_searchIterations; $i++) { if ($this->_segmentTableEndCodes[$searchIndex] >= $characterCode) { $subtableIndex = $searchIndex; $searchIndex -= $this->_searchRange >> $i; } else { $searchIndex += $this->_searchRange >> $i; } } if ($this->_segmentTableStartCodes[$subtableIndex] > $characterCode) { $glyphNumbers[$key] = Zend_Pdf_Cmap::MISSING_CHARACTER_GLYPH; continue; } if ($this->_segmentTableIdRangeOffsets[$subtableIndex] == 0) { $glyphNumbers[$key] = ($characterCode + $this->_segmentTableIdDeltas[$subtableIndex]) % 65536; } else { $glyphIndex = ($characterCode - $this->_segmentTableStartCodes[$subtableIndex] + $this->_segmentTableIdRangeOffsets[$subtableIndex] - $this->_segmentCount + $subtableIndex - 1); $glyphNumbers[$key] = $this->_glyphIndexArray[$glyphIndex]; } } return $glyphNumbers; } public function glyphNumberForCharacter($characterCode) { if ($characterCode > 0xffff) { return Zend_Pdf_Cmap::MISSING_CHARACTER_GLYPH; } if ($this->_searchRangeEndCode >= $characterCode) { $searchIndex = $this->_searchRange; } else { $searchIndex = $this->_segmentCount; } for ($i = 1; $i <= $this->_searchIterations; $i++) { if ($this->_segmentTableEndCodes[$searchIndex] >= $characterCode) { $subtableIndex = $searchIndex; $searchIndex -= $this->_searchRange >> $i; } else { $searchIndex += $this->_searchRange >> $i; } } if ($this->_segmentTableStartCodes[$subtableIndex] > $characterCode) { return Zend_Pdf_Cmap::MISSING_CHARACTER_GLYPH; } if ($this->_segmentTableIdRangeOffsets[$subtableIndex] == 0) { $glyphNumber = ($characterCode + $this->_segmentTableIdDeltas[$subtableIndex]) % 65536; } else { $glyphIndex = ($characterCode - $this->_segmentTableStartCodes[$subtableIndex] + $this->_segmentTableIdRangeOffsets[$subtableIndex] - $this->_segmentCount + $subtableIndex - 1); $glyphNumber = $this->_glyphIndexArray[$glyphIndex]; } return $glyphNumber; } public function getCoveredCharacters() { $characterCodes = array(); for ($i = 1; $i <= $this->_segmentCount; $i++) { for ($code = $this->_segmentTableStartCodes[$i]; $code <= $this->_segmentTableEndCodes[$i]; $code++) { $characterCodes[] = $code; } } return $characterCodes; } public function getCoveredCharactersGlyphs() { $glyphNumbers = array(); for ($segmentNum = 1; $segmentNum <= $this->_segmentCount; $segmentNum++) { if ($this->_segmentTableIdRangeOffsets[$segmentNum] == 0) { $delta = $this->_segmentTableIdDeltas[$segmentNum]; for ($code = $this->_segmentTableStartCodes[$segmentNum]; $code <= $this->_segmentTableEndCodes[$segmentNum]; $code++) { $glyphNumbers[$code] = ($code + $delta) % 65536; } } else { $code = $this->_segmentTableStartCodes[$segmentNum]; $glyphIndex = $this->_segmentTableIdRangeOffsets[$segmentNum] - ($this->_segmentCount - $segmentNum) - 1; while ($code <= $this->_segmentTableEndCodes[$segmentNum]) { $glyphNumbers[$code] = $this->_glyphIndexArray[$glyphIndex]; $code++; $glyphIndex++; } } } return $glyphNumbers; } public function __construct($cmapData) { $actualLength = strlen($cmapData); if ($actualLength < 23) { throw new Zend_Pdf_Exception('Insufficient table data', Zend_Pdf_Exception::CMAP_TABLE_DATA_TOO_SMALL); } $type = $this->_extractUInt2($cmapData, 0); if ($type != Zend_Pdf_Cmap::TYPE_SEGMENT_TO_DELTA) { throw new Zend_Pdf_Exception('Wrong cmap table type', Zend_Pdf_Exception::CMAP_WRONG_TABLE_TYPE); } $length = $this->_extractUInt2($cmapData, 2); if ($length != $actualLength) { throw new Zend_Pdf_Exception("Table length ($length) does not match actual length ($actualLength)", Zend_Pdf_Exception::CMAP_WRONG_TABLE_LENGTH); } $language = $this->_extractUInt2($cmapData, 4); if ($language != 0) { } $this->_segmentCount = $this->_extractUInt2($cmapData, 6) >> 1; $this->_searchRange = $this->_extractUInt2($cmapData, 8) >> 1; $this->_searchIterations = $this->_extractUInt2($cmapData, 10) + 1; $offset = 14; for ($i = 1; $i <= $this->_segmentCount; $i++, $offset += 2) { $this->_segmentTableEndCodes[$i] = $this->_extractUInt2($cmapData, $offset); } $this->_searchRangeEndCode = $this->_segmentTableEndCodes[$this->_searchRange]; $offset += 2; for ($i = 1; $i <= $this->_segmentCount; $i++, $offset += 2) { $this->_segmentTableStartCodes[$i] = $this->_extractUInt2($cmapData, $offset); } for ($i = 1; $i <= $this->_segmentCount; $i++, $offset += 2) { $this->_segmentTableIdDeltas[$i] = $this->_extractInt2($cmapData, $offset); } for ($i = 1; $i <= $this->_segmentCount; $i++, $offset += 2) { $this->_segmentTableIdRangeOffsets[$i] = $this->_extractUInt2($cmapData, $offset) >> 1; } for (; $offset < $length; $offset += 2) { $this->_glyphIndexArray[] = $this->_extractUInt2($cmapData, $offset); } if ($offset != $length) { throw new Zend_Pdf_Exception("Ending offset ($offset) does not match length ($length)", Zend_Pdf_Exception::CMAP_FINAL_OFFSET_NOT_LENGTH); } } }

/* @source /library/Zend/Pdf/Color/GrayScale.php */
class Zend_Pdf_Color_GrayScale extends Zend_Pdf_Color { private $_grayLevel; public function __construct($grayLevel) { if ($grayLevel < 0) { $grayLevel = 0; } if ($grayLevel > 1) { $grayLevel = 1; } $this->_grayLevel = new Zend_Pdf_Element_Numeric($grayLevel); } public function instructions($stroking) { return $this->_grayLevel->toString() . ($stroking? " G\n" : " g\n"); } public function getComponents() { return array($this->_grayLevel->value); } }

/* @source /library/Zend/Pdf/Color/Html.php */
class Zend_Pdf_Color_Html extends Zend_Pdf_Color { private $_color; public function __construct($color) { $this->_color = self::color($color); } public function instructions($stroking) { return $this->_color->instructions($stroking); } public function getComponents() { return $this->_color->getComponents(); } public static function color($color) { $pattern = '/^#([A-Fa-f0-9]{2})([A-Fa-f0-9]{2})([A-Fa-f0-9]{2})$/'; if (preg_match($pattern, $color, $matches)) { $r = round((hexdec($matches[1]) / 255), 3); $g = round((hexdec($matches[2]) / 255), 3); $b = round((hexdec($matches[3]) / 255), 3); if (($r == $g) && ($g == $b)) { return new Zend_Pdf_Color_GrayScale($r); } else { return new Zend_Pdf_Color_Rgb($r, $g, $b); } } else { return Zend_Pdf_Color_Html::namedColor($color); } } public static function namedColor($color) { switch (strtolower($color)) { case 'aqua': $r = 0.0; $g = 1.0; $b = 1.0; break; case 'black': $r = 0.0; $g = 0.0; $b = 0.0; break; case 'blue': $r = 0.0; $g = 0.0; $b = 1.0; break; case 'fuchsia': $r = 1.0; $g = 0.0; $b = 1.0; break; case 'gray': $r = 0.502; $g = 0.502; $b = 0.502; break; case 'green': $r = 0.0; $g = 0.502; $b = 0.0; break; case 'lime': $r = 0.0; $g = 1.0; $b = 0.0; break; case 'maroon': $r = 0.502; $g = 0.0; $b = 0.0; break; case 'navy': $r = 0.0; $g = 0.0; $b = 0.502; break; case 'olive': $r = 0.502; $g = 0.502; $b = 0.0; break; case 'purple': $r = 0.502; $g = 0.0; $b = 0.502; break; case 'red': $r = 1.0; $g = 0.0; $b = 0.0; break; case 'silver': $r = 0.753; $g = 0.753; $b = 0.753; break; case 'teal': $r = 0.0; $g = 0.502; $b = 0.502; break; case 'white': $r = 1.0; $g = 1.0; $b = 1.0; break; case 'yellow': $r = 1.0; $g = 1.0; $b = 0.0; break; case 'aliceblue': $r = 0.941; $g = 0.973; $b = 1.0; break; case 'antiquewhite': $r = 0.980; $g = 0.922; $b = 0.843; break; case 'aquamarine': $r = 0.498; $g = 1.0; $b = 0.831; break; case 'azure': $r = 0.941; $g = 1.0; $b = 1.0; break; case 'beige': $r = 0.961; $g = 0.961; $b = 0.863; break; case 'bisque': $r = 1.0; $g = 0.894; $b = 0.769; break; case 'blanchedalmond': $r = 1.0; $g = 1.0; $b = 0.804; break; case 'blueviolet': $r = 0.541; $g = 0.169; $b = 0.886; break; case 'brown': $r = 0.647; $g = 0.165; $b = 0.165; break; case 'burlywood': $r = 0.871; $g = 0.722; $b = 0.529; break; case 'cadetblue': $r = 0.373; $g = 0.620; $b = 0.627; break; case 'chartreuse': $r = 0.498; $g = 1.0; $b = 0.0; break; case 'chocolate': $r = 0.824; $g = 0.412; $b = 0.118; break; case 'coral': $r = 1.0; $g = 0.498; $b = 0.314; break; case 'cornflowerblue': $r = 0.392; $g = 0.584; $b = 0.929; break; case 'cornsilk': $r = 1.0; $g = 0.973; $b = 0.863; break; case 'crimson': $r = 0.863; $g = 0.078; $b = 0.235; break; case 'cyan': $r = 0.0; $g = 1.0; $b = 1.0; break; case 'darkblue': $r = 0.0; $g = 0.0; $b = 0.545; break; case 'darkcyan': $r = 0.0; $g = 0.545; $b = 0.545; break; case 'darkgoldenrod': $r = 0.722; $g = 0.525; $b = 0.043; break; case 'darkgray': $r = 0.663; $g = 0.663; $b = 0.663; break; case 'darkgreen': $r = 0.0; $g = 0.392; $b = 0.0; break; case 'darkkhaki': $r = 0.741; $g = 0.718; $b = 0.420; break; case 'darkmagenta': $r = 0.545; $g = 0.0; $b = 0.545; break; case 'darkolivegreen': $r = 0.333; $g = 0.420; $b = 0.184; break; case 'darkorange': $r = 1.0; $g = 0.549; $b = 0.0; break; case 'darkorchid': $r = 0.6; $g = 0.196; $b = 0.8; break; case 'darkred': $r = 0.545; $g = 0.0; $b = 0.0; break; case 'darksalmon': $r = 0.914; $g = 0.588; $b = 0.478; break; case 'darkseagreen': $r = 0.561; $g = 0.737; $b = 0.561; break; case 'darkslateblue': $r = 0.282; $g = 0.239; $b = 0.545; break; case 'darkslategray': $r = 0.184; $g = 0.310; $b = 0.310; break; case 'darkturquoise': $r = 0.0; $g = 0.808; $b = 0.820; break; case 'darkviolet': $r = 0.580; $g = 0.0; $b = 0.827; break; case 'deeppink': $r = 1.0; $g = 0.078; $b = 0.576; break; case 'deepskyblue': $r = 0.0; $g = 0.749; $b = 1.0; break; case 'dimgray': $r = 0.412; $g = 0.412; $b = 0.412; break; case 'dodgerblue': $r = 0.118; $g = 0.565; $b = 1.0; break; case 'firebrick': $r = 0.698; $g = 0.133; $b = 0.133; break; case 'floralwhite': $r = 1.0; $g = 0.980; $b = 0.941; break; case 'forestgreen': $r = 0.133; $g = 0.545; $b = 0.133; break; case 'gainsboro': $r = 0.863; $g = 0.863; $b = 0.863; break; case 'ghostwhite': $r = 0.973; $g = 0.973; $b = 1.0; break; case 'gold': $r = 1.0; $g = 0.843; $b = 0.0; break; case 'goldenrod': $r = 0.855; $g = 0.647; $b = 0.125; break; case 'greenyellow': $r = 0.678; $g = 1.0; $b = 0.184; break; case 'honeydew': $r = 0.941; $g = 1.0; $b = 0.941; break; case 'hotpink': $r = 1.0; $g = 0.412; $b = 0.706; break; case 'indianred': $r = 0.804; $g = 0.361; $b = 0.361; break; case 'indigo': $r = 0.294; $g = 0.0; $b = 0.510; break; case 'ivory': $r = 1.0; $g = 0.941; $b = 0.941; break; case 'khaki': $r = 0.941; $g = 0.902; $b = 0.549; break; case 'lavender': $r = 0.902; $g = 0.902; $b = 0.980; break; case 'lavenderblush': $r = 1.0; $g = 0.941; $b = 0.961; break; case 'lawngreen': $r = 0.486; $g = 0.988; $b = 0.0; break; case 'lemonchiffon': $r = 1.0; $g = 0.980; $b = 0.804; break; case 'lightblue': $r = 0.678; $g = 0.847; $b = 0.902; break; case 'lightcoral': $r = 0.941; $g = 0.502; $b = 0.502; break; case 'lightcyan': $r = 0.878; $g = 1.0; $b = 1.0; break; case 'lightgoldenrodyellow': $r = 0.980; $g = 0.980; $b = 0.824; break; case 'lightgreen': $r = 0.565; $g = 0.933; $b = 0.565; break; case 'lightgrey': $r = 0.827; $g = 0.827; $b = 0.827; break; case 'lightpink': $r = 1.0; $g = 0.714; $b = 0.757; break; case 'lightsalmon': $r = 1.0; $g = 0.627; $b = 0.478; break; case 'lightseagreen': $r = 0.125; $g = 0.698; $b = 0.667; break; case 'lightskyblue': $r = 0.529; $g = 0.808; $b = 0.980; break; case 'lightslategray': $r = 0.467; $g = 0.533; $b = 0.6; break; case 'lightsteelblue': $r = 0.690; $g = 0.769; $b = 0.871; break; case 'lightyellow': $r = 1.0; $g = 1.0; $b = 0.878; break; case 'limegreen': $r = 0.196; $g = 0.804; $b = 0.196; break; case 'linen': $r = 0.980; $g = 0.941; $b = 0.902; break; case 'magenta': $r = 1.0; $g = 0.0; $b = 1.0; break; case 'mediumaquamarine': $r = 0.4; $g = 0.804; $b = 0.667; break; case 'mediumblue': $r = 0.0; $g = 0.0; $b = 0.804; break; case 'mediumorchid': $r = 0.729; $g = 0.333; $b = 0.827; break; case 'mediumpurple': $r = 0.576; $g = 0.439; $b = 0.859; break; case 'mediumseagreen': $r = 0.235; $g = 0.702; $b = 0.443; break; case 'mediumslateblue': $r = 0.482; $g = 0.408; $b = 0.933; break; case 'mediumspringgreen': $r = 0.0; $g = 0.980; $b = 0.604; break; case 'mediumturquoise': $r = 0.282; $g = 0.820; $b = 0.8; break; case 'mediumvioletred': $r = 0.780; $g = 0.082; $b = 0.522; break; case 'midnightblue': $r = 0.098; $g = 0.098; $b = 0.439; break; case 'mintcream': $r = 0.961; $g = 1.0; $b = 0.980; break; case 'mistyrose': $r = 1.0; $g = 0.894; $b = 0.882; break; case 'moccasin': $r = 1.0; $g = 0.894; $b = 0.710; break; case 'navajowhite': $r = 1.0; $g = 0.871; $b = 0.678; break; case 'oldlace': $r = 0.992; $g = 0.961; $b = 0.902; break; case 'olivedrab': $r = 0.420; $g = 0.557; $b = 0.137; break; case 'orange': $r = 1.0; $g = 0.647; $b = 0.0; break; case 'orangered': $r = 1.0; $g = 0.271; $b = 0.0; break; case 'orchid': $r = 0.855; $g = 0.439; $b = 0.839; break; case 'palegoldenrod': $r = 0.933; $g = 0.910; $b = 0.667; break; case 'palegreen': $r = 0.596; $g = 0.984; $b = 0.596; break; case 'paleturquoise': $r = 0.686; $g = 0.933; $b = 0.933; break; case 'palevioletred': $r = 0.859; $g = 0.439; $b = 0.576; break; case 'papayawhip': $r = 1.0; $g = 0.937; $b = 0.835; break; case 'peachpuff': $r = 1.0; $g = 0.937; $b = 0.835; break; case 'peru': $r = 0.804; $g = 0.522; $b = 0.247; break; case 'pink': $r = 1.0; $g = 0.753; $b = 0.796; break; case 'plum': $r = 0.867; $g = 0.627; $b = 0.867; break; case 'powderblue': $r = 0.690; $g = 0.878; $b = 0.902; break; case 'rosybrown': $r = 0.737; $g = 0.561; $b = 0.561; break; case 'royalblue': $r = 0.255; $g = 0.412; $b = 0.882; break; case 'saddlebrown': $r = 0.545; $g = 0.271; $b = 0.075; break; case 'salmon': $r = 0.980; $g = 0.502; $b = 0.447; break; case 'sandybrown': $r = 0.957; $g = 0.643; $b = 0.376; break; case 'seagreen': $r = 0.180; $g = 0.545; $b = 0.341; break; case 'seashell': $r = 1.0; $g = 0.961; $b = 0.933; break; case 'sienna': $r = 0.627; $g = 0.322; $b = 0.176; break; case 'skyblue': $r = 0.529; $g = 0.808; $b = 0.922; break; case 'slateblue': $r = 0.416; $g = 0.353; $b = 0.804; break; case 'slategray': $r = 0.439; $g = 0.502; $b = 0.565; break; case 'snow': $r = 1.0; $g = 0.980; $b = 0.980; break; case 'springgreen': $r = 0.0; $g = 1.0; $b = 0.498; break; case 'steelblue': $r = 0.275; $g = 0.510; $b = 0.706; break; case 'tan': $r = 0.824; $g = 0.706; $b = 0.549; break; case 'thistle': $r = 0.847; $g = 0.749; $b = 0.847; break; case 'tomato': $r = 0.992; $g = 0.388; $b = 0.278; break; case 'turquoise': $r = 0.251; $g = 0.878; $b = 0.816; break; case 'violet': $r = 0.933; $g = 0.510; $b = 0.933; break; case 'wheat': $r = 0.961; $g = 0.871; $b = 0.702; break; case 'whitesmoke': $r = 0.961; $g = 0.961; $b = 0.961; break; case 'yellowgreen': $r = 0.604; $g = 0.804; $b = 0.196; break; default: throw new Zend_Pdf_Exception('Unknown color name: ' . $color); } if (($r == $g) && ($g == $b)) { return new Zend_Pdf_Color_GrayScale($r); } else { return new Zend_Pdf_Color_Rgb($r, $g, $b); } } }

/* @source /library/Zend/Pdf/Element/Reference.php */
class Zend_Pdf_Element_Reference extends Zend_Pdf_Element { private $_ref; private $_objNum; private $_genNum; private $_context; private $_factory; public function __construct($objNum, $genNum = 0, Zend_Pdf_Element_Reference_Context $context, Zend_Pdf_ElementFactory $factory) { if ( !(is_integer($objNum) && $objNum > 0) ) { throw new Zend_Pdf_Exception('Object number must be positive integer'); } if ( !(is_integer($genNum) && $genNum >= 0) ) { throw new Zend_Pdf_Exception('Generation number must be non-negative integer'); } $this->_objNum = $objNum; $this->_genNum = $genNum; $this->_ref = null; $this->_context = $context; $this->_factory = $factory; } public function getFactory() { return $this->_factory; } public function getType() { if ($this->_ref === null) { $this->_dereference(); } return $this->_ref->getType(); } public function toString($factory = null) { if ($factory === null) { $shift = 0; } else { $shift = $factory->getEnumerationShift($this->_factory); } return $this->_objNum + $shift . ' ' . $this->_genNum . ' R'; } private function _dereference() { if (($obj = $this->_factory->fetchObject($this->_objNum . ' ' . $this->_genNum)) === null) { $obj = $this->_context->getParser()->getObject( $this->_context->getRefTable()->getOffset($this->_objNum . ' ' . $this->_genNum . ' R'), $this->_context ); } if ($obj === null ) { $this->_ref = new Zend_Pdf_Element_Null(); return; } if ($obj->toString() != $this->_objNum . ' ' . $this->_genNum . ' R') { throw new Zend_Pdf_Exception('Incorrect reference to the object'); } $this->_ref = $obj; } public function makeClone(Zend_Pdf_ElementFactory $factory, array &$processed, $mode) { if ($this->_ref === null) { $this->_dereference(); } $id = spl_object_hash($this->_ref); if (isset($processed[$id])) { return $processed[$id]; } return $this->_ref->makeClone($factory, $processed, $mode); } public function touch() { if ($this->_ref === null) { $this->_dereference(); } $this->_ref->touch(); } public function getObject() { if ($this->_ref === null) { $this->_dereference(); } return $this->_ref; } public function __get($property) { if ($this->_ref === null) { $this->_dereference(); } return $this->_ref->$property; } public function __set($property, $value) { if ($this->_ref === null) { $this->_dereference(); } $this->_ref->$property = $value; } public function __call($method, $args) { if ($this->_ref === null) { $this->_dereference(); } return call_user_func_array(array($this->_ref, $method), $args); } public function cleanUp() { $this->_ref = null; } public function toPhp() { if ($this->_ref === null) { $this->_dereference(); } return $this->_ref->toPhp(); } }

/* @source /library/Zend/Pdf/Action/Named.php */
class Zend_Pdf_Action_Named extends Zend_Pdf_Action { }

/* @source /library/Zend/Pdf/Element/Null.php */
class Zend_Pdf_Element_Null extends Zend_Pdf_Element { public $value; public function __construct() { $this->value = null; } public function getType() { return Zend_Pdf_Element::TYPE_NULL; } public function toString($factory = null) { return 'null'; } }

/* @source /library/Zend/Pdf/Element/Name.php */
class Zend_Pdf_Element_Name extends Zend_Pdf_Element { public $value; public function __construct($val) { settype($val, 'string'); if (strpos($val,"\x00") !== false) { throw new Zend_Pdf_Exception('Null character is not allowed in PDF Names'); } $this->value = (string)$val; } public function getType() { return Zend_Pdf_Element::TYPE_NAME; } public static function escape($inStr) { $outStr = ''; for ($count = 0; $count < strlen($inStr); $count++) { $nextCode = ord($inStr[$count]); switch ($inStr[$count]) { case '(': case ')': case '<': case '>': case '[': case ']': case '{': case '}': case '/': case '%': case '\\': case '#': $outStr .= sprintf('#%02X', $nextCode); break; default: if ($nextCode >= 33 && $nextCode <= 126 ) { $outStr .= $inStr[$count]; } else { $outStr .= sprintf('#%02X', $nextCode); } } } return $outStr; } public static function unescape($inStr) { $outStr = ''; for ($count = 0; $count < strlen($inStr); $count++) { if ($inStr[$count] != '#' ) { $outStr .= $inStr[$count]; } else { $outStr .= chr(base_convert(substr($inStr, $count+1, 2), 16, 10 )); $count +=2; } } return $outStr; } public function toString($factory = null) { return '/' . self::escape((string)$this->value); } }

/* @source /library/Zend/Pdf/Element/Object.php */
class Zend_Pdf_Element_Object extends Zend_Pdf_Element { protected $_value; protected $_objNum; protected $_genNum; protected $_factory; public function __construct(Zend_Pdf_Element $val, $objNum, $genNum, Zend_Pdf_ElementFactory $factory) { if ($val instanceof self) { throw new Zend_Pdf_Exception('Object number must not be an instance of Zend_Pdf_Element_Object.'); } if ( !(is_integer($objNum) && $objNum > 0) ) { throw new Zend_Pdf_Exception('Object number must be positive integer.'); } if ( !(is_integer($genNum) && $genNum >= 0) ) { throw new Zend_Pdf_Exception('Generation number must be non-negative integer.'); } $this->_value = $val; $this->_objNum = $objNum; $this->_genNum = $genNum; $this->_factory = $factory; $this->setParentObject($this); $factory->registerObject($this, $objNum . ' ' . $genNum); } public function getFactory() { return $this->_factory; } public function getType() { return $this->_value->getType(); } public function getObjNum() { return $this->_objNum; } public function getGenNum() { return $this->_genNum; } public function toString($factory = null) { if ($factory === null) { $shift = 0; } else { $shift = $factory->getEnumerationShift($this->_factory); } return $this->_objNum + $shift . ' ' . $this->_genNum . ' R'; } public function dump(Zend_Pdf_ElementFactory $factory) { $shift = $factory->getEnumerationShift($this->_factory); return $this->_objNum + $shift . " " . $this->_genNum . " obj \n" . $this->_value->toString($factory) . "\n" . "endobj\n"; } public function __get($property) { return $this->_value->$property; } public function __set($property, $value) { $this->_value->$property = $value; } public function __call($method, $args) { return call_user_func_array(array($this->_value, $method), $args); } public function makeClone(Zend_Pdf_ElementFactory $factory, array &$processed, $mode) { $id = spl_object_hash($this); if (isset($processed[$id])) { return $processed[$id]; } $processed[$id] = $clonedObject = $factory->newObject(new Zend_Pdf_Element_Null()); $clonedObject->_value = $this->_value->makeClone($factory, $processed, $mode); if ($clonedObject->_value instanceof Zend_Pdf_Element_Null) { unset($processed[$id]); return $clonedObject->_value; } return $clonedObject; } public function touch() { $this->_factory->markAsModified($this); } public function getObject() { return $this; } public function cleanUp() { $this->_value = null; } public function toPhp() { return $this->_value->toPhp(); } }

/* @source /library/Zend/Pdf/Element/Array.php */
class Zend_Pdf_Element_Array extends Zend_Pdf_Element { public $items; public function __construct($val = null) { $this->items = new ArrayObject(); if ($val !== null && is_array($val)) { foreach ($val as $element) { if (!$element instanceof Zend_Pdf_Element) { throw new Zend_Pdf_Exception('Array elements must be Zend_Pdf_Element objects'); } $this->items[] = $element; } } else if ($val !== null){ throw new Zend_Pdf_Exception('Argument must be an array'); } } public function __get($property) { throw new Zend_Pdf_Exception('Undefined property: Zend_Pdf_Element_Array::$' . $property); } public function __set($property, $value) { throw new Zend_Pdf_Exception('Undefined property: Zend_Pdf_Element_Array::$' . $property); } public function getType() { return Zend_Pdf_Element::TYPE_ARRAY; } public function toString($factory = null) { $outStr = '['; $lastNL = 0; foreach ($this->items as $element) { if (strlen($outStr) - $lastNL > 128) { $outStr .= "\n"; $lastNL = strlen($outStr); } $outStr .= $element->toString($factory) . ' '; } $outStr .= ']'; return $outStr; } public function makeClone(Zend_Pdf_ElementFactory $factory, array &$processed, $mode) { $newArray = new self(); foreach ($this->items as $key => $value) { $newArray->items[$key] = $value->makeClone($factory, $processed, $mode); } return $newArray; } public function setParentObject(Zend_Pdf_Element_Object $parent) { parent::setParentObject($parent); foreach ($this->items as $item) { $item->setParentObject($parent); } } public function toPhp() { $phpArray = array(); foreach ($this->items as $item) { $phpArray[] = $item->toPhp(); } return $phpArray; } }

/* @source /library/Zend/Pdf/Element/Boolean.php */
class Zend_Pdf_Element_Boolean extends Zend_Pdf_Element { public $value; public function __construct($val) { if (! is_bool($val)) { throw new Zend_Pdf_Exception('Argument must be boolean.'); } $this->value = $val; } public function getType() { return Zend_Pdf_Element::TYPE_BOOL; } public function toString($factory = null) { return $this->value ? 'true' : 'false'; } }

/* @source /library/Zend/Pdf/Element/Stream.php */
class Zend_Pdf_Element_FakeStream { function __construct($value){ $this->value = $value; } function & getRef() { return $this->value; } function touch() {} } class Zend_Pdf_Element_Stream extends Zend_Pdf_Element { public $value; public function __construct($val) { $this->value = new Zend_Pdf_Element_FakeStream($val); } public function getType() { return Zend_Pdf_Element::TYPE_STREAM; } public function length() { return strlen($this->value->getRef()); } public function clear() { $ref = &$this->value->getRef(); $ref = ''; $this->value->touch(); } public function append($val) { $ref = &$this->value->getRef(); $ref .= (string)$val; $this->value->touch(); } public function makeClone(Zend_Pdf_ElementFactory $factory, array &$processed, $mode) { return new self($this->value->getRef()); } public function toString($factory = null) { return "stream\n" . $this->value->getRef() . "\nendstream"; } }

/* @source /library/Zend/Pdf/Element/String.php */
class Zend_Pdf_Element_String extends Zend_Pdf_Element { public $value; public function __construct($val) { $this->value = (string)$val; } public function getType() { return Zend_Pdf_Element::TYPE_STRING; } public function toString($factory = null) { return '(' . self::escape((string)$this->value) . ')'; } public static function escape($str) { $outEntries = array(); foreach (str_split($str, 128) as $chunk) { $offset = strcspn($chunk, "\n\r\t\x08\x0C()\\"); $chunkOut = substr($chunk, 0, $offset); while ($offset < strlen($chunk)) { $nextCode = ord($chunk[$offset++]); switch ($nextCode) { case 10: $chunkOut .= '\\n'; break; case 13: $chunkOut .= '\\r'; break; case 9: $chunkOut .= '\\t'; break; case 8: $chunkOut .= '\\b'; break; case 12: $chunkOut .= '\\f'; break; case 40: $chunkOut .= '\\('; break; case 41: $chunkOut .= '\\)'; break; case 92: $chunkOut .= '\\\\'; break; default: break; } $start = $offset; $offset += strcspn($chunk, "\n\r\t\x08\x0C()\\", $offset); $chunkOut .= substr($chunk, $start, $offset - $start); } $outEntries[] = $chunkOut; } return implode("\\\n", $outEntries); } public static function unescape($str) { $outEntries = array(); $offset = 0; while ($offset < strlen($str)) { $escapeCharOffset = strpos($str, '\\', $offset); if ($escapeCharOffset === false || $escapeCharOffset == strlen($str) - 1) { $outEntries[] = substr($str, $offset); break; } else { $outEntries[] = substr($str, $offset, $escapeCharOffset - $offset); $offset = $escapeCharOffset + 1; switch ($str[$offset]) { case 'n': $outEntries[] = "\n"; break; case 'r': $outEntries[] = "\r"; break; case 't': $outEntries[] = "\t"; break; case 'b': $outEntries[] = "\x08"; break; case 'f': $outEntries[] = "\x0C"; break; case '(': $outEntries[] = '('; break; case ')': $outEntries[] = ')'; break; case '\\': $outEntries[] = '\\'; break; case "\n": if ($str[$offset + 1] == "\r") { $offset++; } break; default: if (strpos('0123456789', $str[$offset]) !== false) { $nextCode = '0' . $str[$offset]; if (strpos('0123456789', $str[$offset + 1]) !== false) { $nextCode .= $str[++$offset]; if (strpos('0123456789', $str[$offset + 1]) !== false) { $nextCode .= $str[++$offset]; } } $outEntries[] = chr(octdec($nextCode)); } else { $outEntries[] = $str[$offset]; } break; } $offset++; } } return implode($outEntries); } }

/* @source /library/Zend/Pdf/Element/Dictionary.php */
class Zend_Pdf_Element_Dictionary extends Zend_Pdf_Element { private $_items = array(); public function __construct($val = null) { if ($val === null) { return; } else if (!is_array($val)) { throw new Zend_Pdf_Exception('Argument must be an array'); } foreach ($val as $name => $element) { if (!$element instanceof Zend_Pdf_Element) { throw new Zend_Pdf_Exception('Array elements must be Zend_Pdf_Element objects'); } if (!is_string($name)) { throw new Zend_Pdf_Exception('Array keys must be strings'); } $this->_items[$name] = $element; } } public function add(Zend_Pdf_Element_Name $name, Zend_Pdf_Element $val) { $this->_items[$name->value] = $val; } public function getKeys() { return array_keys($this->_items); } public function __get($item) { $element = isset($this->_items[$item]) ? $this->_items[$item] : null; return $element; } public function __set($item, $value) { if ($value === null) { unset($this->_items[$item]); } else { $this->_items[$item] = $value; } } public function getType() { return Zend_Pdf_Element::TYPE_DICTIONARY; } public function toString($factory = null) { $outStr = '<<'; $lastNL = 0; foreach ($this->_items as $name => $element) { if (!is_object($element)) { throw new Zend_Pdf_Exception('Wrong data'); } if (strlen($outStr) - $lastNL > 128) { $outStr .= "\n"; $lastNL = strlen($outStr); } $nameObj = new Zend_Pdf_Element_Name($name); $outStr .= $nameObj->toString($factory) . ' ' . $element->toString($factory) . ' '; } $outStr .= '>>'; return $outStr; } public function makeClone(Zend_Pdf_ElementFactory $factory, array &$processed, $mode) { if (isset($this->_items['Type'])) { if ($this->_items['Type']->value == 'Pages') { return new Zend_Pdf_Element_Null(); } if ($this->_items['Type']->value == 'Page' && $mode == Zend_Pdf_Element::CLONE_MODE_SKIP_PAGES ) { return new Zend_Pdf_Element_Null(); } } $newDictionary = new self(); foreach ($this->_items as $key => $value) { $newDictionary->_items[$key] = $value->makeClone($factory, $processed, $mode); } return $newDictionary; } public function setParentObject(Zend_Pdf_Element_Object $parent) { parent::setParentObject($parent); foreach ($this->_items as $item) { $item->setParentObject($parent); } } public function toPhp() { $phpArray = array(); foreach ($this->_items as $itemName => $item) { $phpArray[$itemName] = $item->toPhp(); } return $phpArray; } }

/* @source /library/Zend/Pdf/ElementFactory/Proxy.php */
class Zend_Pdf_ElementFactory_Proxy implements Zend_Pdf_ElementFactory_Interface { private $_factory; public function __construct(Zend_Pdf_ElementFactory_Interface $factory) { $this->_factory = $factory; } public function __destruct() { $this->_factory->close(); $this->_factory = null; } public function getFactory() { return $this->_factory->getFactory(); } public function close() { } public function resolve() { return $this->_factory->resolve(); } public function getId() { return $this->_factory->getId(); } public function setObjectCount($objCount) { $this->_factory->setObjectCount($objCount); } public function getObjectCount() { return $this->_factory->getObjectCount(); } public function attach(Zend_Pdf_ElementFactory_Interface $factory) { $this->_factory->attach($factory); } public function calculateShift(Zend_Pdf_ElementFactory_Interface $factory) { return $this->_factory->calculateShift($factory); } public function cleanEnumerationShiftCache() { return $this->_factory->cleanEnumerationShiftCache(); } public function getEnumerationShift(Zend_Pdf_ElementFactory_Interface $factory) { return $this->_factory->getEnumerationShift($factory); } public function markAsModified(Zend_Pdf_Element_Object $obj) { $this->_factory->markAsModified($obj); } public function remove(Zend_Pdf_Element_Object $obj) { $this->_factory->remove($obj); } public function newObject(Zend_Pdf_Element $objectValue) { return $this->_factory->newObject($objectValue); } public function newStreamObject($streamValue) { return $this->_factory->newStreamObject($streamValue); } public function listModifiedObjects($rootFactory = null) { return $this->_factory->listModifiedObjects($rootFactory); } public function isModified() { return $this->_factory->isModified(); } }

/* @source /library/Zend/Pdf/FileParserDataSource/File.php */
class Zend_Pdf_FileParserDataSource_File extends Zend_Pdf_FileParserDataSource { protected $_filePath = ''; protected $_fileResource = null; public function __construct($filePath) { if (! (is_file($filePath) || is_link($filePath))) { throw new Zend_Pdf_Exception("Invalid file path: $filePath", Zend_Pdf_Exception::BAD_FILE_PATH); } if (! is_readable($filePath)) { throw new Zend_Pdf_Exception("File is not readable: $filePath", Zend_Pdf_Exception::NOT_READABLE); } if (($this->_size = @filesize($filePath)) === false) { throw new Zend_Pdf_Exception("Error while obtaining file size: $filePath", Zend_Pdf_Exception::CANT_GET_FILE_SIZE); } if (($this->_fileResource = @fopen($filePath, 'rb')) === false) { throw new Zend_Pdf_Exception("Cannot open file for reading: $filePath", Zend_Pdf_Exception::CANT_OPEN_FILE); } $this->_filePath = $filePath; } public function __destruct() { if (is_resource($this->_fileResource)) { @fclose($this->_fileResource); } } public function readBytes($byteCount) { $bytes = @fread($this->_fileResource, $byteCount); if ($bytes === false) { throw new Zend_Pdf_Exception('Unexpected error while reading file', Zend_Pdf_Exception::ERROR_DURING_READ); } if (strlen($bytes) != $byteCount) { throw new Zend_Pdf_Exception("Insufficient data to read $byteCount bytes", Zend_Pdf_Exception::INSUFFICIENT_DATA); } $this->_offset += $byteCount; return $bytes; } public function readAllBytes() { return file_get_contents($this->_filePath); } public function __toString() { return $this->_filePath; } public function moveToOffset($offset) { if ($this->_offset == $offset) { return; } parent::moveToOffset($offset); $result = @fseek($this->_fileResource, $offset, SEEK_SET); if ($result !== 0) { throw new Zend_Pdf_Exception('Error while setting new file position', Zend_Pdf_Exception::CANT_SET_FILE_POSITION); } if (feof($this->_fileResource)) { throw new Zend_Pdf_Exception('Moved beyond the end of the file', Zend_Pdf_Exception::MOVE_BEYOND_END_OF_FILE); } } }

/* @source /library/Zend/Pdf/Action/GoToE.php */
class Zend_Pdf_Action_GoToE extends Zend_Pdf_Action { }

/* @source /library/Zend/Pdf/Action/Launch.php */
class Zend_Pdf_Action_Launch extends Zend_Pdf_Action { }

/* @source /library/Zend/Pdf/Action/Hide.php */
class Zend_Pdf_Action_Hide extends Zend_Pdf_Action { }

/* @source /library/Zend/Pdf/Outline/Loaded.php */
class Zend_Pdf_Outline_Loaded extends Zend_Pdf_Outline { protected $_outlineDictionary; protected $_originalChildOutlines = array(); public function getTitle() { if ($this->_outlineDictionary->Title === null) { throw new Zend_Pdf_Exception('Outline dictionary Title entry is required.'); } return $this->_outlineDictionary->Title->value; } public function setTitle($title) { $this->_outlineDictionary->Title->touch(); $this->_outlineDictionary->Title = new Zend_Pdf_Element_String($title); return $this; } public function setIsOpen($isOpen) { parent::setIsOpen($isOpen); if ($this->_outlineDictionary->Count === null) { return this; } $childrenCount = $this->_outlineDictionary->Count->value; $isOpenCurrentState = ($childrenCount > 0); if ($isOpen != $isOpenCurrentState) { $this->_outlineDictionary->Count->touch(); $this->_outlineDictionary->Count->value = ($isOpen? 1 : -1)*abs($childrenCount); } return $this; } public function isItalic() { if ($this->_outlineDictionary->F === null) { return false; } return $this->_outlineDictionary->F->value & 1; } public function setIsItalic($isItalic) { if ($this->_outlineDictionary->F === null) { $this->_outlineDictionary->touch(); $this->_outlineDictionary->F = new Zend_Pdf_Element_Numeric($isItalic? 1 : 0); } else { $this->_outlineDictionary->F->touch(); if ($isItalic) { $this->_outlineDictionary->F->value = $this->_outlineDictionary->F->value | 1; } else { $this->_outlineDictionary->F->value = $this->_outlineDictionary->F->value | ~1; } } return $this; } public function isBold() { if ($this->_outlineDictionary->F === null) { return false; } return $this->_outlineDictionary->F->value & 2; } public function setIsBold($isBold) { if ($this->_outlineDictionary->F === null) { $this->_outlineDictionary->touch(); $this->_outlineDictionary->F = new Zend_Pdf_Element_Numeric($isBold? 2 : 0); } else { $this->_outlineDictionary->F->touch(); if ($isBold) { $this->_outlineDictionary->F->value = $this->_outlineDictionary->F->value | 2; } else { $this->_outlineDictionary->F->value = $this->_outlineDictionary->F->value | ~2; } } return $this; } public function getColor() { if ($this->_outlineDictionary->C === null) { return null; } $components = $this->_outlineDictionary->C->items; return new Zend_Pdf_Color_Rgb($components[0], $components[1], $components[2]); } public function setColor(Zend_Pdf_Color_Rgb $color) { $this->_outlineDictionary->touch(); if ($color === null) { $this->_outlineDictionary->C = null; } else { $components = $color->getComponents(); $colorComponentElements = array(new Zend_Pdf_Element_Numeric($components[0]), new Zend_Pdf_Element_Numeric($components[1]), new Zend_Pdf_Element_Numeric($components[2])); $this->_outlineDictionary->C = new Zend_Pdf_Element_Array($colorComponentElements); } return $this; } public function getTarget() { if ($this->_outlineDictionary->Dest !== null) { if ($this->_outlineDictionary->A !== null) { throw new Zend_Pdf_Exception('Outline dictionary may contain Dest or A entry, but not both.'); } return Zend_Pdf_Destination::load($this->_outlineDictionary->Dest); } else if ($this->_outlineDictionary->A !== null) { return Zend_Pdf_Action::load($this->_outlineDictionary->A); } return null; } public function setTarget($target = null) { $this->_outlineDictionary->touch(); if (is_string($target)) { $target = Zend_Pdf_Destination_Named::create($target); } if ($target === null) { $this->_outlineDictionary->Dest = null; $this->_outlineDictionary->A = null; } else if ($target instanceof Zend_Pdf_Destination) { $this->_outlineDictionary->Dest = $target->getResource(); $this->_outlineDictionary->A = null; } else if ($target instanceof Zend_Pdf_Action) { $this->_outlineDictionary->Dest = null; $this->_outlineDictionary->A = $target->getResource(); } else { throw new Zend_Pdf_Exception('Outline target has to be Zend_Pdf_Destination or Zend_Pdf_Action object or string'); } return $this; } public function setOptions(array $options) { parent::setOptions($options); return $this; } public function __construct(Zend_Pdf_Element $dictionary, SplObjectStorage $processedDictionaries = null) { if ($dictionary->getType() != Zend_Pdf_Element::TYPE_DICTIONARY) { throw new Zend_Pdf_Exception('$dictionary mast be an indirect dictionary object.'); } if ($processedDictionaries === null) { $processedDictionaries = new SplObjectStorage(); } $processedDictionaries->attach($dictionary); $this->_outlineDictionary = $dictionary; if ($dictionary->Count !== null) { if ($dictionary->Count->getType() != Zend_Pdf_Element::TYPE_NUMERIC) { throw new Zend_Pdf_Exception('Outline dictionary Count entry must be a numeric element.'); } $childOutlinesCount = $dictionary->Count->value; if ($childOutlinesCount > 0) { $this->_open = true; } $childOutlinesCount = abs($childOutlinesCount); $childDictionary = $dictionary->First; $children = new SplObjectStorage(); while ($childDictionary !== null) { if ($children->contains($childDictionary)) { throw new Zend_Pdf_Exception('Outline childs load error.'); } if (!$processedDictionaries->contains($childDictionary)) { $this->childOutlines[] = new Zend_Pdf_Outline_Loaded($childDictionary, $processedDictionaries); } $childDictionary = $childDictionary->Next; } $this->_originalChildOutlines = $this->childOutlines; } } public function dumpOutline(Zend_Pdf_ElementFactory_Interface $factory, $updateNavigation, Zend_Pdf_Element $parent, Zend_Pdf_Element $prev = null, SplObjectStorage $processedOutlines = null) { if ($processedOutlines === null) { $processedOutlines = new SplObjectStorage(); } $processedOutlines->attach($this); if ($updateNavigation) { $this->_outlineDictionary->touch(); $this->_outlineDictionary->Parent = $parent; $this->_outlineDictionary->Prev = $prev; $this->_outlineDictionary->Next = null; } $updateChildNavigation = false; if (count($this->_originalChildOutlines) != count($this->childOutlines)) { $updateChildNavigation = true; } else if ( !(array_keys($this->_originalChildOutlines) === array_keys($this->childOutlines)) ) { $updateChildNavigation = true; } else { foreach ($this->childOutlines as $key => $childOutline) { if ($this->_originalChildOutlines[$key] !== $childOutline) { $updateChildNavigation = true; break; } } } $lastChild = null; if ($updateChildNavigation) { $this->_outlineDictionary->touch(); $this->_outlineDictionary->First = null; foreach ($this->childOutlines as $childOutline) { if ($processedOutlines->contains($childOutline)) { throw new Zend_Pdf_Exception('Outlines cyclyc reference is detected.'); } if ($lastChild === null) { $lastChild = $childOutline->dumpOutline($factory, $updateChildNavigation, $this->_outlineDictionary, null, $processedOutlines); $this->_outlineDictionary->First = $lastChild; } else { $childOutlineDictionary = $childOutline->dumpOutline($factory, $updateChildNavigation, $this->_outlineDictionary, $lastChild, $processedOutlines); $lastChild->Next = $childOutlineDictionary; $lastChild = $childOutlineDictionary; } } $this->_outlineDictionary->Last = $lastChild; if (count($this->childOutlines) != 0) { $this->_outlineDictionary->Count = new Zend_Pdf_Element_Numeric(($this->isOpen()? 1 : -1)*count($this->childOutlines)); } else { $this->_outlineDictionary->Count = null; } } else { foreach ($this->childOutlines as $childOutline) { if ($processedOutlines->contains($childOutline)) { throw new Zend_Pdf_Exception('Outlines cyclyc reference is detected.'); } $lastChild = $childOutline->dumpOutline($factory, $updateChildNavigation, $this->_outlineDictionary, $lastChild, $processedOutlines); } } return $this->_outlineDictionary; } public function dump($level = 0) { printf(":%3d:%s:%s:%s%s  :\n", count($this->childOutlines),$this->isItalic()? 'i':' ', $this->isBold()? 'b':' ', str_pad('', 4*$level), $this->getTitle()); if ($this->isOpen() || true) { foreach ($this->childOutlines as $child) { $child->dump($level + 1); } } } }

/* @source /library/Zend/Pdf/Resource/ContentStream.php */
class Zend_Pdf_Resource_ContentStream extends Zend_Pdf_Resource { protected $_bufferedContent = ''; public function __construct($contentStreamObject = '') { if ($contentStreamObject !== null && !$contentStreamObject instanceof Zend_Pdf_Element_Object_Stream && !is_string($contentStreamObject) ) { throw new Zend_Pdf_Exception('Content stream parameter must be a string or stream object'); } parent::__construct($contentStreamObject); } public function addInstructions($instructions) { $this->_bufferedContent .= $instructions; return $this; } public function getInstructions() { $this->flush(); return $this->_resource->value; } public function clear() { $this->_resource->value = ''; $this->_bufferedContent = ''; return $this; } public function flush() { $this->_resource->value .= $this->_bufferedContent; $this->_bufferedContent = ''; return $this; } }

/* @source /library/Zend/Pdf/Resource/Unified.php */
class Zend_Pdf_Resource_Unified extends Zend_Pdf_Resource { }

/* @source /library/Zend/Pdf/Resource/GraphicsState.php */
class Zend_Pdf_Resource_GraphicsState extends Zend_Pdf_Resource { public function __construct(Zend_Pdf_Element_Object $extGStateObject = null) { if ($extGStateObject == null) { $factory = Zend_Pdf_ElementFactory::createFactory(1); $gsDictionary = new Zend_Pdf_Element_Dictionary(); $gsDictionary->Type = new Zend_Pdf_Element_Name('ExtGState'); $extGStateObject = $factory->newObject($gsDictionary); } if ($extGStateObject->getType() != Zend_Pdf_Element::TYPE_DICTIONARY) { throw new Zend_Pdf_Exception('Graphics state PDF object must be a dictionary'); } parent::__construct($gsDictionary); } public function setAlpha($alpha, $mode = 'Normal') { if (!in_array($mode, array('Normal', 'Multiply', 'Screen', 'Overlay', 'Darken', 'Lighten', 'ColorDodge', 'ColorBurn', 'HardLight', 'SoftLight', 'Difference', 'Exclusion'))) { throw new Zend_Pdf_Exception('Unsupported transparency mode.'); } if (!is_numeric($alpha) || $alpha < 0 || $alpha > 1) { throw new Zend_Pdf_Exception('Alpha value must be numeric between 0 (transparent) and 1 (opaque).'); } $this->_resource->BM = new Zend_Pdf_Element_Name($mode); $this->_resource->CA = new Zend_Pdf_Element_Numeric($alpha); $this->_resource->ca = new Zend_Pdf_Element_Numeric($alpha); } }

/* @source /library/Zend/Pdf/Resource/Extractor.php */
class Zend_Pdf_Resource_Extractor { protected $_factory; protected $_processed; public function __construct() { $this->_factory = Zend_Pdf_ElementFactory::createFactory(1); $this->_processed = array(); } public function clonePage(Zend_Pdf_Page $page) { return $page->clonePage($this->_factory, $this->_processed); } }

/* @source /library/Zend/Pdf/Resource/ImageFactory.php */
class Zend_Pdf_Resource_ImageFactory { public static function factory($filename) { if(!is_file($filename)) { throw new Zend_Pdf_Exception("Cannot create image resource. File not found."); } $extension = pathinfo($filename, PATHINFO_EXTENSION); switch (strtolower($extension)) { case 'tif': case 'tiff': return new Zend_Pdf_Resource_Image_Tiff($filename); break; case 'png': return new Zend_Pdf_Resource_Image_Png($filename); break; case 'jpg': case 'jpe': case 'jpeg': return new Zend_Pdf_Resource_Image_Jpeg($filename); break; default: throw new Zend_Pdf_Exception("Cannot create image resource. File extension not known or unsupported type."); break; } } }

/* @source /library/Zend/Pdf/Destination/Fit.php */
class Zend_Pdf_Destination_Fit extends Zend_Pdf_Destination_Explicit { public static function create($page) { $destinationArray = new Zend_Pdf_Element_Array(); if ($page instanceof Zend_Pdf_Page) { $destinationArray->items[] = $page->getPageDictionary(); } else if (is_integer($page)) { $destinationArray->items[] = new Zend_Pdf_Element_Numeric($page); } else { throw new Zend_Pdf_Exception('Page entry must be a Zend_Pdf_Page object or a page number.'); } $destinationArray->items[] = new Zend_Pdf_Element_Name('Fit'); return new Zend_Pdf_Destination_Fit($destinationArray); } }

/* @source /library/Zend/Pdf/Destination/Zoom.php */
class Zend_Pdf_Destination_Zoom extends Zend_Pdf_Destination_Explicit { public static function create($page, $left = null, $top = null, $zoom = null) { $destinationArray = new Zend_Pdf_Element_Array(); if ($page instanceof Zend_Pdf_Page) { $destinationArray->items[] = $page->getPageDictionary(); } else if (is_integer($page)) { $destinationArray->items[] = new Zend_Pdf_Element_Numeric($page); } else { throw new Zend_Pdf_Exception('Page entry must be a Zend_Pdf_Page object or a page number.'); } $destinationArray->items[] = new Zend_Pdf_Element_Name('XYZ'); if ($left === null) { $destinationArray->items[] = new Zend_Pdf_Element_Null(); } else { $destinationArray->items[] = new Zend_Pdf_Element_Numeric($left); } if ($top === null) { $destinationArray->items[] = new Zend_Pdf_Element_Null(); } else { $destinationArray->items[] = new Zend_Pdf_Element_Numeric($top); } if ($zoom === null) { $destinationArray->items[] = new Zend_Pdf_Element_Null(); } else { $destinationArray->items[] = new Zend_Pdf_Element_Numeric($zoom); } return new Zend_Pdf_Destination_Zoom($destinationArray); } public function getLeftEdge() { return $this->_destinationArray->items[2]->value; } public function setLeftEdge($left) { if ($left === null) { $this->_destinationArray->items[2] = new Zend_Pdf_Element_Null(); } else { $this->_destinationArray->items[2] = new Zend_Pdf_Element_Numeric($left); } return $this; } public function getTopEdge() { return $this->_destinationArray->items[3]->value; } public function setTopEdge($top) { if ($top === null) { $this->_destinationArray->items[3] = new Zend_Pdf_Element_Null(); } else { $this->_destinationArray->items[3] = new Zend_Pdf_Element_Numeric($top); } return $this; } public function getZoomFactor() { return $this->_destinationArray->items[4]->value; } public function setZoomFactor($zoom) { if ($zoom === null) { $this->_destinationArray->items[4] = new Zend_Pdf_Element_Null(); } else { $this->_destinationArray->items[4] = new Zend_Pdf_Element_Numeric($zoom); } return $this; } }

/* @source /library/Zend/Pdf/Destination/FitBoundingBoxVertically.php */
class Zend_Pdf_Destination_FitBoundingBoxVertically extends Zend_Pdf_Destination_Explicit { public static function create($page, $left) { $destinationArray = new Zend_Pdf_Element_Array(); if ($page instanceof Zend_Pdf_Page) { $destinationArray->items[] = $page->getPageDictionary(); } else if (is_integer($page)) { $destinationArray->items[] = new Zend_Pdf_Element_Numeric($page); } else { throw new Zend_Pdf_Exception('Page entry must be a Zend_Pdf_Page object or a page number.'); } $destinationArray->items[] = new Zend_Pdf_Element_Name('FitBV'); $destinationArray->items[] = new Zend_Pdf_Element_Numeric($left); return new Zend_Pdf_Destination_FitBoundingBoxVertically($destinationArray); } public function getLeftEdge() { return $this->_destinationArray->items[2]->value; } public function setLeftEdge($left) { $this->_destinationArray->items[2] = new Zend_Pdf_Element_Numeric($left); return $this; } }

/* @source /library/Zend/Pdf/Destination/FitBoundingBox.php */
class Zend_Pdf_Destination_FitBoundingBox extends Zend_Pdf_Destination_Explicit { public static function create($page) { $destinationArray = new Zend_Pdf_Element_Array(); if ($page instanceof Zend_Pdf_Page) { $destinationArray->items[] = $page->getPageDictionary(); } else if (is_integer($page)) { $destinationArray->items[] = new Zend_Pdf_Element_Numeric($page); } else { throw new Zend_Pdf_Exception('Page entry must be a Zend_Pdf_Page object or a page number.'); } $destinationArray->items[] = new Zend_Pdf_Element_Name('FitB'); return new Zend_Pdf_Destination_FitBoundingBox($destinationArray); } }

/* @source /library/Zend/Pdf/Destination/Unknown.php */
class Zend_Pdf_Destination_Unknown extends Zend_Pdf_Destination_Explicit { }

/* @source /library/Zend/Pdf/Destination/FitBoundingBoxHorizontally.php */
class Zend_Pdf_Destination_FitBoundingBoxHorizontally extends Zend_Pdf_Destination_Explicit { public static function create($page, $top) { $destinationArray = new Zend_Pdf_Element_Array(); if ($page instanceof Zend_Pdf_Page) { $destinationArray->items[] = $page->getPageDictionary(); } else if (is_integer($page)) { $destinationArray->items[] = new Zend_Pdf_Element_Numeric($page); } else { throw new Zend_Pdf_Exception('Page entry must be a Zend_Pdf_Page object or a page number.'); } $destinationArray->items[] = new Zend_Pdf_Element_Name('FitBH'); $destinationArray->items[] = new Zend_Pdf_Element_Numeric($top); return new Zend_Pdf_Destination_FitBoundingBoxHorizontally($destinationArray); } public function getTopEdge() { return $this->_destinationArray->items[2]->value; } public function setTopEdge($top) { $this->_destinationArray->items[2] = new Zend_Pdf_Element_Numeric($top); return $this; } }

/* @source /library/Zend/Pdf/Outline/Created.php */
class Zend_Pdf_Outline_Created extends Zend_Pdf_Outline { protected $_title; protected $_color = null; protected $_italic = false; protected $_bold = false; protected $_target = null; public function getTitle() { return $this->_title; } public function setTitle($title) { $this->_title = $title; return $this; } public function isItalic() { return $this->_italic; } public function setIsItalic($isItalic) { $this->_italic = $isItalic; return $this; } public function isBold() { return $this->_bold; } public function setIsBold($isBold) { $this->_bold = $isBold; return $this; } public function getColor() { return $this->_color; } public function setColor(Zend_Pdf_Color_Rgb $color) { $this->_color = $color; return $this; } public function getTarget() { return $this->_target; } public function setTarget($target = null) { if (is_string($target)) { $target = new Zend_Pdf_Destination_Named($target); } if ($target === null || $target instanceof Zend_Pdf_Target) { $this->_target = $target; } else { throw new Zend_Pdf_Exception('Outline target has to be Zend_Pdf_Destination or Zend_Pdf_Action object or string'); } return $this; } public function __construct($options = array()) { if (!isset($options['title'])) { throw new Zend_Pdf_Exception('Title parameter is required.'); } $this->setOptions($options); } public function dumpOutline(Zend_Pdf_ElementFactory_Interface $factory, $updateNavigation, Zend_Pdf_Element $parent, Zend_Pdf_Element $prev = null, SplObjectStorage $processedOutlines = null) { if ($processedOutlines === null) { $processedOutlines = new SplObjectStorage(); } $processedOutlines->attach($this); $outlineDictionary = $factory->newObject(new Zend_Pdf_Element_Dictionary()); $outlineDictionary->Title = new Zend_Pdf_Element_String($this->getTitle()); $target = $this->getTarget(); if ($target === null) { } else if ($target instanceof Zend_Pdf_Destination) { $outlineDictionary->Dest = $target->getResource(); } else if ($target instanceof Zend_Pdf_Action) { $outlineDictionary->A = $target->getResource(); } else { throw new Zend_Pdf_Exception('Outline target has to be Zend_Pdf_Destination, Zend_Pdf_Action object or null'); } $color = $this->getColor(); if ($color !== null) { $components = $color->getComponents(); $colorComponentElements = array(new Zend_Pdf_Element_Numeric($components[0]), new Zend_Pdf_Element_Numeric($components[1]), new Zend_Pdf_Element_Numeric($components[2])); $outlineDictionary->C = new Zend_Pdf_Element_Array($colorComponentElements); } if ($this->isItalic() || $this->isBold()) { $outlineDictionary->F = new Zend_Pdf_Element_Numeric(($this->isItalic()? 1 : 0) | ($this->isBold()? 2 : 0)); } $outlineDictionary->Parent = $parent; $outlineDictionary->Prev = $prev; $lastChild = null; foreach ($this->childOutlines as $childOutline) { if ($processedOutlines->contains($childOutline)) { throw new Zend_Pdf_Exception('Outlines cyclyc reference is detected.'); } if ($lastChild === null) { $lastChild = $childOutline->dumpOutline($factory, true, $outlineDictionary, null, $processedOutlines); $outlineDictionary->First = $lastChild; } else { $childOutlineDictionary = $childOutline->dumpOutline($factory, true, $outlineDictionary, $lastChild, $processedOutlines); $lastChild->Next = $childOutlineDictionary; $lastChild = $childOutlineDictionary; } } $outlineDictionary->Last = $lastChild; if (count($this->childOutlines) != 0) { $outlineDictionary->Count = new Zend_Pdf_Element_Numeric(($this->isOpen()? 1 : -1)*count($this->childOutlines)); } return $outlineDictionary; } }

/* @source /library/Zend/Pdf/Destination/FitHorizontally.php */
class Zend_Pdf_Destination_FitHorizontally extends Zend_Pdf_Destination_Explicit { public static function create($page, $top) { $destinationArray = new Zend_Pdf_Element_Array(); if ($page instanceof Zend_Pdf_Page) { $destinationArray->items[] = $page->getPageDictionary(); } else if (is_integer($page)) { $destinationArray->items[] = new Zend_Pdf_Element_Numeric($page); } else { throw new Zend_Pdf_Exception('Page entry must be a Zend_Pdf_Page object or a page number.'); } $destinationArray->items[] = new Zend_Pdf_Element_Name('FitH'); $destinationArray->items[] = new Zend_Pdf_Element_Numeric($top); return new Zend_Pdf_Destination_FitHorizontally($destinationArray); } public function getTopEdge() { return $this->_destinationArray->items[2]->value; } public function setTopEdge($top) { $this->_destinationArray->items[2] = new Zend_Pdf_Element_Numeric($top); return $this; } }

/* @source /library/Zend/Pdf/Destination/FitRectangle.php */
class Zend_Pdf_Destination_FitRectangle extends Zend_Pdf_Destination_Explicit { public static function create($page, $left, $bottom, $right, $top) { $destinationArray = new Zend_Pdf_Element_Array(); if ($page instanceof Zend_Pdf_Page) { $destinationArray->items[] = $page->getPageDictionary(); } else if (is_integer($page)) { $destinationArray->items[] = new Zend_Pdf_Element_Numeric($page); } else { throw new Zend_Pdf_Exception('Page entry must be a Zend_Pdf_Page object or a page number.'); } $destinationArray->items[] = new Zend_Pdf_Element_Name('FitR'); $destinationArray->items[] = new Zend_Pdf_Element_Numeric($left); $destinationArray->items[] = new Zend_Pdf_Element_Numeric($bottom); $destinationArray->items[] = new Zend_Pdf_Element_Numeric($right); $destinationArray->items[] = new Zend_Pdf_Element_Numeric($top); return new Zend_Pdf_Destination_FitRectangle($destinationArray); } public function getLeftEdge() { return $this->_destinationArray->items[2]->value; } public function setLeftEdge($left) { $this->_destinationArray->items[2] = new Zend_Pdf_Element_Numeric($left); return $this; } public function getBottomEdge() { return $this->_destinationArray->items[3]->value; } public function setBottomEdge($bottom) { $this->_destinationArray->items[3] = new Zend_Pdf_Element_Numeric($bottom); return $this; } public function getRightEdge() { return $this->_destinationArray->items[4]->value; } public function setRightEdge($right) { $this->_destinationArray->items[4] = new Zend_Pdf_Element_Numeric($right); return $this; } public function getTopEdge() { return $this->_destinationArray->items[5]->value; } public function setTopEdge($top) { $this->_destinationArray->items[5] = new Zend_Pdf_Element_Numeric($top); return $this; } }

/* @source /library/Zend/Pdf/Destination/Named.php */
class Zend_Pdf_Destination_Named extends Zend_Pdf_Destination { protected $_nameElement; public function __construct(Zend_Pdf_Element $resource) { if ($resource->getType() != Zend_Pdf_Element::TYPE_NAME && $resource->getType() != Zend_Pdf_Element::TYPE_STRING) { throw new Zend_Pdf_Exception('Named destination resource must be a PDF name or a PDF string.'); } $this->_nameElement = $resource; } public static function create($name) { return new Zend_Pdf_Destination_Named(new Zend_Pdf_Element_String($name)); } public function getName() { return $this->_nameElement->value; } public function getResource() { return $this->_nameElement; } }

/* @source /library/Zend/Pdf/Destination/FitVertically.php */
class Zend_Pdf_Destination_FitVertically extends Zend_Pdf_Destination_Explicit { public static function create($page, $left) { $destinationArray = new Zend_Pdf_Element_Array(); if ($page instanceof Zend_Pdf_Page) { $destinationArray->items[] = $page->getPageDictionary(); } else if (is_integer($page)) { $destinationArray->items[] = new Zend_Pdf_Element_Numeric($page); } else { throw new Zend_Pdf_Exception('Page entry must be a Zend_Pdf_Page object or page number.'); } $destinationArray->items[] = new Zend_Pdf_Element_Name('FitV'); $destinationArray->items[] = new Zend_Pdf_Element_Numeric($left); return new Zend_Pdf_Destination_FitVertically($destinationArray); } public function getLeftEdge() { return $this->_destinationArray->items[2]->value; } public function setLeftEdge($left) { $this->_destinationArray->items[2] = new Zend_Pdf_Element_Numeric($left); return $this; } }

/* @source /library/Zend/Pdf/Color/Rgb.php */
class Zend_Pdf_Color_Rgb extends Zend_Pdf_Color { private $_r; private $_g; private $_b; public function __construct($r, $g, $b) { if ($r < 0) { $r = 0; } if ($r > 1) { $r = 1; } if ($g < 0) { $g = 0; } if ($g > 1) { $g = 1; } if ($b < 0) { $b = 0; } if ($b > 1) { $b = 1; } $this->_r = new Zend_Pdf_Element_Numeric($r); $this->_g = new Zend_Pdf_Element_Numeric($g); $this->_b = new Zend_Pdf_Element_Numeric($b); } public function instructions($stroking) { return $this->_r->toString() . ' ' . $this->_g->toString() . ' ' . $this->_b->toString() . ($stroking? " RG\n" : " rg\n"); } public function getComponents() { return array($this->_r->value, $this->_g->value, $this->_b->value); } }

/* @source /library/Zend/Pdf/Element/Reference/Table.php */
class Zend_Pdf_Element_Reference_Table { private $_parent; private $_free; private $_generations; private $_inuse; private $_usedObjects; public function __construct() { $this->_parent = null; $this->_free = array(); $this->_generations = array(); $this->_inuse = array(); $this->_usedObjects = array(); } public function addReference($ref, $offset, $inuse = true) { $refElements = explode(' ', $ref); if (!is_numeric($refElements[0]) || !is_numeric($refElements[1]) || $refElements[2] != 'R') { throw new Zend_Pdf_Exception("Incorrect reference: '$ref'"); } $objNum = (int)$refElements[0]; $genNum = (int)$refElements[1]; if ($inuse) { $this->_inuse[$ref] = $offset; $this->_usedObjects[$objNum] = $objNum; } else { $this->_free[$ref] = $offset; $this->_generations[$objNum] = $genNum; } } public function setParent(self $parent) { $this->_parent = $parent; } public function getOffset($ref) { if (isset($this->_inuse[$ref])) { return $this->_inuse[$ref]; } if (isset($this->_free[$ref])) { return null; } if (isset($this->_parent)) { return $this->_parent->getOffset($ref); } return null; } public function getNextFree($ref) { if (isset($this->_inuse[$ref])) { throw new Zend_Pdf_Exception('Object is not free'); } if (isset($this->_free[$ref])) { return $this->_free[$ref]; } if (isset($this->_parent)) { return $this->_parent->getNextFree($ref); } throw new Zend_Pdf_Exception('Object not found.'); } public function getNewGeneration($objNum) { if (isset($this->_usedObjects[$objNum])) { throw new Zend_Pdf_Exception('Object is not free'); } if (isset($this->_generations[$objNum])) { return $this->_generations[$objNum]; } if (isset($this->_parent)) { return $this->_parent->getNewGeneration($objNum); } throw new Zend_Pdf_Exception('Object not found.'); } }

/* @source /library/Zend/Pdf/Element/Reference/Context.php */
class Zend_Pdf_Element_Reference_Context { private $_stringParser; private $_refTable; public function __construct(Zend_Pdf_StringParser $parser, Zend_Pdf_Element_Reference_Table $refTable) { $this->_stringParser = $parser; $this->_refTable = $refTable; } public function getParser() { return $this->_stringParser; } public function getRefTable() { return $this->_refTable; } }

/* @source /library/Zend/Pdf/FileParser/Image/Png.php */
class Zend_Pdf_FileParser_Image_Png extends Zend_Pdf_FileParser_Image { protected $_isPNG; protected $_width; protected $_height; protected $_bits; protected $_color; protected $_compression; protected $_preFilter; protected $_interlacing; protected $_imageData; protected $_paletteData; protected $_transparencyData; public function getWidth() { if(!$this->_isParsed) { $this->parse(); } return $this->_width; } public function getHeight() { if(!$this->_isParsed) { $this->parse(); } return $this->_width; } public function getBitDepth() { if(!$this->_isParsed) { $this->parse(); } return $this->_bits; } public function getColorSpace() { if(!$this->_isParsed) { $this->parse(); } return $this->_color; } public function getCompressionStrategy() { if(!$this->_isParsed) { $this->parse(); } return $this->_compression; } public function getPaethFilter() { if(!$this->_isParsed) { $this->parse(); } return $this->_preFilter; } public function getInterlacingMode() { if(!$this->_isParsed) { $this->parse(); } return $this->_interlacing; } public function getRawImageData() { if(!$this->_isParsed) { $this->parse(); } return $this->_imageData; } public function getRawPaletteData() { if(!$this->_isParsed) { $this->parse(); } return $this->_paletteData; } public function getRawTransparencyData() { if(!$this->_isParsed) { $this->parse(); } return $this->_transparencyData; } public function screen() { if ($this->_isScreened) { return; } return $this->_checkSignature(); } public function parse() { if ($this->_isParsed) { return; } $this->screen(); $this->_parseIHDRChunk(); $this->_parseChunks(); } protected function _parseSignature() { $this->moveToOffset(1); if('PNG' != $this->readBytes(3)) { $this->_isPNG = false; } else { $this->_isPNG = true; } } protected function _checkSignature() { if(!isset($this->_isPNG)) { $this->_parseSignature(); } return $this->_isPNG; } protected function _parseChunks() { $this->moveToOffset(33); $size = $this->getSize(); while($size - $this->getOffset() >= 8) { $chunkLength = $this->readUInt(4); if($chunkLength < 0 || ($chunkLength + $this->getOffset() + 4) > $size) { throw new Zend_Pdf_Exception("PNG Corrupt: Invalid Chunk Size In File."); } $chunkType = $this->readBytes(4); $offset = $this->getOffset(); switch($chunkType) { case 'IDAT': $this->_parseIDATChunk($offset, $chunkLength); break; case 'PLTE': $this->_parsePLTEChunk($offset, $chunkLength); break; case 'tRNS': $this->_parseTRNSChunk($offset, $chunkLength); break; case 'IEND': break 2; } if($offset + $chunkLength + 4 < $size) { $this->moveToOffset($offset + $chunkLength + 4); } } if(empty($this->_imageData)) { throw new Zend_Pdf_Exception ( "This PNG is corrupt. All png must contain IDAT chunks." ); } } protected function _parseIHDRChunk() { $this->moveToOffset(12); if(!$this->readBytes(4) == 'IHDR') { throw new Zend_Pdf_Exception( "This PNG is corrupt. The first chunk in a PNG file must be IHDR." ); } $this->_width = $this->readUInt(4); $this->_height = $this->readUInt(4); $this->_bits = $this->readInt(1); $this->_color = $this->readInt(1); $this->_compression = $this->readInt(1); $this->_preFilter = $this->readInt(1); $this->_interlacing = $this->readInt(1); if($this->_interlacing != Zend_Pdf_Image::PNG_INTERLACING_DISABLED) { throw new Zend_Pdf_Exception( "Only non-interlaced images are currently supported." ); } } protected function _parseIDATChunk($chunkOffset, $chunkLength) { $this->moveToOffset($chunkOffset); if(!isset($this->_imageData)) { $this->_imageData = $this->readBytes($chunkLength); } else { $this->_imageData .= $this->readBytes($chunkLength); } } protected function _parsePLTEChunk($chunkOffset, $chunkLength) { $this->moveToOffset($chunkOffset); $this->_paletteData = $this->readBytes($chunkLength); } protected function _parseTRNSChunk($chunkOffset, $chunkLength) { $this->moveToOffset($chunkOffset); switch($this->_color) { case Zend_Pdf_Image::PNG_CHANNEL_GRAY: $baseColor = $this->readInt(1); $this->_transparencyData = array($baseColor, $baseColor); break; case Zend_Pdf_Image::PNG_CHANNEL_RGB: $red = $this->readInt(1); $this->skipBytes(1); $green = $this->readInt(1); $this->skipBytes(1); $blue = $this->readInt(1); $this->_transparencyData = array($red, $red, $green, $green, $blue, $blue); break; case Zend_Pdf_Image::PNG_CHANNEL_INDEXED: $tmpData = $this->readBytes($chunkLength); if(($trnsIdx = strpos($tmpData, "\0")) !== false) { $this->_transparencyData = array($trnsIdx, $trnsIdx); } break; case Zend_Pdf_Image::PNG_CHANNEL_GRAY_ALPHA: case Zend_Pdf_Image::PNG_CHANNEL_RGB_ALPHA: throw new Zend_Pdf_Exception( "tRNS chunk illegal for Alpha Channel Images" ); break; } } }

/* @source /library/Zend/Pdf/Cmap/ByteEncoding/Static.php */
class Zend_Pdf_Cmap_ByteEncoding_Static extends Zend_Pdf_Cmap_ByteEncoding { public function __construct($cmapData) { if (! is_array($cmapData)) { throw new Zend_Pdf_Exception('Constructor parameter must be an array', Zend_Pdf_Exception::BAD_PARAMETER_TYPE); } $this->_glyphIndexArray = $cmapData; } }

/* @source /library/Zend/Pdf/Resource/Font/FontDescriptor.php */
class Zend_Pdf_Resource_Font_FontDescriptor { public function __construct() { throw new Zend_Pdf_Exception('Zend_Pdf_Resource_Font_FontDescriptor is not intended to be instantiated'); } static public function factory(Zend_Pdf_Resource_Font $font, Zend_Pdf_FileParser_Font_OpenType $fontParser, $embeddingOptions) { $fontDescriptor = new Zend_Pdf_Element_Dictionary(); $fontDescriptor->Type = new Zend_Pdf_Element_Name('FontDescriptor'); $fontDescriptor->FontName = new Zend_Pdf_Element_Name($font->getResource()->BaseFont->value); $flags = 0; if ($fontParser->isMonospaced) { $flags |= 1 << 0; } if ($fontParser->isSerifFont) { $flags |= 1 << 1; } if (! $fontParser->isAdobeLatinSubset) { $flags |= 1 << 2; } if ($fontParser->isScriptFont) { $flags |= 1 << 3; } if ($fontParser->isAdobeLatinSubset) { $flags |= 1 << 5; } if ($fontParser->isItalic) { $flags |= 1 << 6; } $fontDescriptor->Flags = new Zend_Pdf_Element_Numeric($flags); $fontBBox = array(new Zend_Pdf_Element_Numeric($font->toEmSpace($fontParser->xMin)), new Zend_Pdf_Element_Numeric($font->toEmSpace($fontParser->yMin)), new Zend_Pdf_Element_Numeric($font->toEmSpace($fontParser->xMax)), new Zend_Pdf_Element_Numeric($font->toEmSpace($fontParser->yMax))); $fontDescriptor->FontBBox = new Zend_Pdf_Element_Array($fontBBox); $fontDescriptor->ItalicAngle = new Zend_Pdf_Element_Numeric($fontParser->italicAngle); $fontDescriptor->Ascent = new Zend_Pdf_Element_Numeric($font->toEmSpace($fontParser->ascent)); $fontDescriptor->Descent = new Zend_Pdf_Element_Numeric($font->toEmSpace($fontParser->descent)); $fontDescriptor->CapHeight = new Zend_Pdf_Element_Numeric($fontParser->capitalHeight); $fontDescriptor->StemV = new Zend_Pdf_Element_Numeric(0); $fontDescriptor->MissingWidth = new Zend_Pdf_Element_Numeric($fontParser->glyphWidths[0]); if (!($embeddingOptions & Zend_Pdf_Font::EMBED_DONT_EMBED)) { if (! $fontParser->isEmbeddable) { if (!($embeddingOptions & Zend_Pdf_Font::EMBED_SUPPRESS_EMBED_EXCEPTION)) { $message = 'This font cannot be embedded in the PDF document. If you would like to use ' . 'it anyway, you must pass Zend_Pdf_Font::EMBED_SUPPRESS_EMBED_EXCEPTION ' . 'in the $options parameter of the font constructor.'; throw new Zend_Pdf_Exception($message, Zend_Pdf_Exception::FONT_CANT_BE_EMBEDDED); } } else { $fontFile = $fontParser->getDataSource()->readAllBytes(); $fontFileObject = $font->getFactory()->newStreamObject($fontFile); $fontFileObject->dictionary->Length1 = new Zend_Pdf_Element_Numeric(strlen($fontFile)); if (!($embeddingOptions & Zend_Pdf_Font::EMBED_DONT_COMPRESS)) { $fontFileObject->dictionary->Filter = new Zend_Pdf_Element_Name('FlateDecode'); } if ($fontParser instanceof Zend_Pdf_FileParser_Font_OpenType_Type1 ) { $fontDescriptor->FontFile = $fontFileObject; } else if ($fontParser instanceof Zend_Pdf_FileParser_Font_OpenType_TrueType) { $fontDescriptor->FontFile2 = $fontFileObject; } else { $fontDescriptor->FontFile3 = $fontFileObject; } } } return $fontDescriptor; } }

/* @source /library/Zend/Pdf/Element/String/Binary.php */
class Zend_Pdf_Element_String_Binary extends Zend_Pdf_Element_String { public $value; public static function escape($inStr) { return strtoupper(bin2hex($inStr)); } public static function unescape($inStr) { $chunks = array(); $offset = 0; $length = 0; while ($offset < strlen($inStr)) { $start = $offset; $offset += strspn($inStr, "0123456789abcdefABCDEF", $offset); $chunks[] = substr($inStr, $start, $offset - $start); $length += strlen(end($chunks)); $offset += strcspn($inStr, "0123456789abcdefABCDEF", $offset); } if ($length % 2 != 0) { $chunks[] = '0'; } return pack('H*' , implode($chunks)); } public function toString($factory = null) { return '<' . self::escape((string)$this->value) . '>'; } }

/* @source /library/Zend/Pdf/Element/Object/Stream.php */
class Zend_Pdf_Element_Object_Stream extends Zend_Pdf_Element_Object { private $_dictionary; private $_streamDecoded; private $_initialDictionaryData = null; public function __construct($val, $objNum, $genNum, Zend_Pdf_ElementFactory $factory, $dictionary = null) { parent::__construct(new Zend_Pdf_Element_Stream($val), $objNum, $genNum, $factory); if ($dictionary === null) { $this->_dictionary = new Zend_Pdf_Element_Dictionary(); $this->_dictionary->Length = new Zend_Pdf_Element_Numeric(strlen( $val )); $this->_streamDecoded = true; } else { $this->_dictionary = $dictionary; $this->_streamDecoded = false; } } private function _extractDictionaryData() { $dictionaryArray = array(); $dictionaryArray['Filter'] = array(); $dictionaryArray['DecodeParms'] = array(); if ($this->_dictionary->Filter === null) { } else if ($this->_dictionary->Filter->getType() == Zend_Pdf_Element::TYPE_ARRAY) { foreach ($this->_dictionary->Filter->items as $id => $filter) { $dictionaryArray['Filter'][$id] = $filter->value; $dictionaryArray['DecodeParms'][$id] = array(); if ($this->_dictionary->DecodeParms !== null ) { if ($this->_dictionary->DecodeParms->items[$id] !== null && $this->_dictionary->DecodeParms->items[$id]->value !== null ) { foreach ($this->_dictionary->DecodeParms->items[$id]->getKeys() as $paramKey) { $dictionaryArray['DecodeParms'][$id][$paramKey] = $this->_dictionary->DecodeParms->items[$id]->$paramKey->value; } } } } } else if ($this->_dictionary->Filter->getType() != Zend_Pdf_Element::TYPE_NULL) { $dictionaryArray['Filter'][0] = $this->_dictionary->Filter->value; $dictionaryArray['DecodeParms'][0] = array(); if ($this->_dictionary->DecodeParms !== null ) { foreach ($this->_dictionary->DecodeParms->getKeys() as $paramKey) { $dictionaryArray['DecodeParms'][0][$paramKey] = $this->_dictionary->DecodeParms->$paramKey->value; } } } if ($this->_dictionary->F !== null) { $dictionaryArray['F'] = $this->_dictionary->F->value; } $dictionaryArray['FFilter'] = array(); $dictionaryArray['FDecodeParms'] = array(); if ($this->_dictionary->FFilter === null) { } else if ($this->_dictionary->FFilter->getType() == Zend_Pdf_Element::TYPE_ARRAY) { foreach ($this->_dictionary->FFilter->items as $id => $filter) { $dictionaryArray['FFilter'][$id] = $filter->value; $dictionaryArray['FDecodeParms'][$id] = array(); if ($this->_dictionary->FDecodeParms !== null ) { if ($this->_dictionary->FDecodeParms->items[$id] !== null && $this->_dictionary->FDecodeParms->items[$id]->value !== null) { foreach ($this->_dictionary->FDecodeParms->items[$id]->getKeys() as $paramKey) { $dictionaryArray['FDecodeParms'][$id][$paramKey] = $this->_dictionary->FDecodeParms->items[$id]->items[$paramKey]->value; } } } } } else { $dictionaryArray['FFilter'][0] = $this->_dictionary->FFilter->value; $dictionaryArray['FDecodeParms'][0] = array(); if ($this->_dictionary->FDecodeParms !== null ) { foreach ($this->_dictionary->FDecodeParms->getKeys() as $paramKey) { $dictionaryArray['FDecodeParms'][0][$paramKey] = $this->_dictionary->FDecodeParms->items[$paramKey]->value; } } } return $dictionaryArray; } private function _decodeStream() { if ($this->_initialDictionaryData === null) { $this->_initialDictionaryData = $this->_extractDictionaryData(); } if (isset($this->_initialDictionaryData['F'])) { throw new Zend_Pdf_Exception('External filters are not supported now.'); } foreach ($this->_initialDictionaryData['Filter'] as $id => $filterName ) { $valueRef = &$this->_value->value->getRef(); $this->_value->value->touch(); switch ($filterName) { case 'ASCIIHexDecode': $valueRef = Zend_Pdf_Filter_AsciiHex::decode($valueRef); break; case 'ASCII85Decode': $valueRef = Zend_Pdf_Filter_Ascii85::decode($valueRef); break; case 'FlateDecode': $valueRef = Zend_Pdf_Filter_Compression_Flate::decode($valueRef, $this->_initialDictionaryData['DecodeParms'][$id]); break; case 'LZWDecode': $valueRef = Zend_Pdf_Filter_Compression_Lzw::decode($valueRef, $this->_initialDictionaryData['DecodeParms'][$id]); break; case 'RunLengthDecode': $valueRef = Zend_Pdf_Filter_RunLength::decode($valueRef); break; default: throw new Zend_Pdf_Exception('Unknown stream filter: \'' . $filterName . '\'.'); } } $this->_streamDecoded = true; } private function _encodeStream() { if (isset($this->_initialDictionaryData['F'])) { throw new Zend_Pdf_Exception('External filters are not supported now.'); } $filters = array_reverse($this->_initialDictionaryData['Filter'], true); foreach ($filters as $id => $filterName ) { $valueRef = &$this->_value->value->getRef(); $this->_value->value->touch(); switch ($filterName) { case 'ASCIIHexDecode': $valueRef = Zend_Pdf_Filter_AsciiHex::encode($valueRef); break; case 'ASCII85Decode': $valueRef = Zend_Pdf_Filter_Ascii85::encode($valueRef); break; case 'FlateDecode': $valueRef = Zend_Pdf_Filter_Compression_Flate::encode($valueRef, $this->_initialDictionaryData['DecodeParms'][$id]); break; case 'LZWDecode': $valueRef = Zend_Pdf_Filter_Compression_Lzw::encode($valueRef, $this->_initialDictionaryData['DecodeParms'][$id]); break; case 'RunLengthDecode': $valueRef = Zend_Pdf_Filter_RunLength::encode($valueRef); break; default: throw new Zend_Pdf_Exception('Unknown stream filter: \'' . $filterName . '\'.'); } } $this->_streamDecoded = false; } public function __get($property) { if ($property == 'dictionary') { if (( !$this->_streamDecoded ) && ($this->_initialDictionaryData === null)) { $this->_initialDictionaryData = $this->_extractDictionaryData(); } return $this->_dictionary; } if ($property == 'value') { if (!$this->_streamDecoded) { $this->_decodeStream(); } return $this->_value->value->getRef(); } throw new Zend_Pdf_Exception('Unknown stream object property requested.'); } public function __set($property, $value) { if ($property == 'value') { $valueRef = &$this->_value->value->getRef(); $valueRef = $value; $this->_value->value->touch(); $this->_streamDecoded = true; return; } throw new Zend_Pdf_Exception('Unknown stream object property: \'' . $property . '\'.'); } public function skipFilters() { $this->_streamDecoded = false; } public function __call($method, $args) { if (!$this->_streamDecoded) { $this->_decodeStream(); } switch (count($args)) { case 0: return $this->_value->$method(); case 1: return $this->_value->$method($args[0]); default: throw new Zend_Pdf_Exception('Unsupported number of arguments'); } } public function makeClone(Zend_Pdf_ElementFactory $factory, array &$processed, $mode) { $id = spl_object_hash($this); if (isset($processed[$id])) { return $processed[$id]; } $streamValue = $this->_value; $streamDictionary = $this->_dictionary->makeClone($factory, $processed, $mode); $processed[$id] = $clonedObject = $factory->newStreamObject(''); $clonedObject->_dictionary = $this->_dictionary->makeClone($factory, $processed, $mode); $clonedObject->_value = $this->_value->makeClone($factory, $processed, $mode); $clonedObject->_initialDictionaryData = $this->_initialDictionaryData; $clonedObject->_streamDecoded = $this->_streamDecoded; return $clonedObject; } public function dump(Zend_Pdf_ElementFactory $factory) { $shift = $factory->getEnumerationShift($this->_factory); if ($this->_streamDecoded) { $this->_initialDictionaryData = $this->_extractDictionaryData(); $this->_encodeStream(); } else if ($this->_initialDictionaryData != null) { $newDictionary = $this->_extractDictionaryData(); if ($this->_initialDictionaryData !== $newDictionary) { $this->_decodeStream(); $this->_initialDictionaryData = $newDictionary; $this->_encodeStream(); } } $this->dictionary->Length->value = $this->_value->length(); return $this->_objNum + $shift . " " . $this->_genNum . " obj \n" . $this->dictionary->toString($factory) . "\n" . $this->_value->toString($factory) . "\n" . "endobj\n"; } public function cleanUp() { $this->_dictionary = null; $this->_value = null; } }

/* @source /library/Zend/Pdf/Resource/Image/Png.php */
class Zend_Pdf_Resource_Image_Png extends Zend_Pdf_Resource_Image { const PNG_COMPRESSION_DEFAULT_STRATEGY = 0; const PNG_COMPRESSION_FILTERED = 1; const PNG_COMPRESSION_HUFFMAN_ONLY = 2; const PNG_COMPRESSION_RLE = 3; const PNG_FILTER_NONE = 0; const PNG_FILTER_SUB = 1; const PNG_FILTER_UP = 2; const PNG_FILTER_AVERAGE = 3; const PNG_FILTER_PAETH = 4; const PNG_INTERLACING_DISABLED = 0; const PNG_INTERLACING_ENABLED = 1; const PNG_CHANNEL_GRAY = 0; const PNG_CHANNEL_RGB = 2; const PNG_CHANNEL_INDEXED = 3; const PNG_CHANNEL_GRAY_ALPHA = 4; const PNG_CHANNEL_RGB_ALPHA = 6; protected $_width; protected $_height; protected $_imageProperties; public function __construct($imageFileName) { if (($imageFile = @fopen($imageFileName, 'rb')) === false ) { throw new Zend_Pdf_Exception( "Can not open '$imageFileName' file for reading." ); } parent::__construct(); fseek($imageFile, 1, SEEK_CUR); if ('PNG' != fread($imageFile, 3)) { throw new Zend_Pdf_Exception('Image is not a PNG'); } fseek($imageFile, 12, SEEK_CUR); $wtmp = unpack('Ni',fread($imageFile, 4)); $width = $wtmp['i']; $htmp = unpack('Ni',fread($imageFile, 4)); $height = $htmp['i']; $bits = ord(fread($imageFile, 1)); $color = ord(fread($imageFile, 1)); $compression = ord(fread($imageFile, 1)); $prefilter = ord(fread($imageFile,1)); if (($interlacing = ord(fread($imageFile,1))) != Zend_Pdf_Resource_Image_Png::PNG_INTERLACING_DISABLED) { throw new Zend_Pdf_Exception( "Only non-interlaced images are currently supported." ); } $this->_width = $width; $this->_height = $height; $this->_imageProperties = array(); $this->_imageProperties['bitDepth'] = $bits; $this->_imageProperties['pngColorType'] = $color; $this->_imageProperties['pngFilterType'] = $prefilter; $this->_imageProperties['pngCompressionType'] = $compression; $this->_imageProperties['pngInterlacingType'] = $interlacing; fseek($imageFile, 4, SEEK_CUR); $imageData = ''; while (!feof($imageFile)) { $chunkLengthBytes = fread($imageFile, 4); if ($chunkLengthBytes === false) { throw new Zend_Pdf_Exception('Error ocuured while image file reading.'); } $chunkLengthtmp = unpack('Ni', $chunkLengthBytes); $chunkLength = $chunkLengthtmp['i']; $chunkType = fread($imageFile, 4); switch($chunkType) { case 'IDAT': $imageData .= fread($imageFile, $chunkLength); fseek($imageFile, 4, SEEK_CUR); break; case 'PLTE': $paletteData = fread($imageFile, $chunkLength); fseek($imageFile, 4, SEEK_CUR); break; case 'tRNS': $trnsData = fread($imageFile, $chunkLength); switch ($color) { case Zend_Pdf_Resource_Image_Png::PNG_CHANNEL_GRAY: $baseColor = ord(substr($trnsData, 1, 1)); $transparencyData = array(new Zend_Pdf_Element_Numeric($baseColor), new Zend_Pdf_Element_Numeric($baseColor)); break; case Zend_Pdf_Resource_Image_Png::PNG_CHANNEL_RGB: $red = ord(substr($trnsData,1,1)); $green = ord(substr($trnsData,3,1)); $blue = ord(substr($trnsData,5,1)); $transparencyData = array(new Zend_Pdf_Element_Numeric($red), new Zend_Pdf_Element_Numeric($red), new Zend_Pdf_Element_Numeric($green), new Zend_Pdf_Element_Numeric($green), new Zend_Pdf_Element_Numeric($blue), new Zend_Pdf_Element_Numeric($blue)); break; case Zend_Pdf_Resource_Image_Png::PNG_CHANNEL_INDEXED: if(($trnsIdx = strpos($trnsData, "\0")) !== false) { $transparencyData = array(new Zend_Pdf_Element_Numeric($trnsIdx), new Zend_Pdf_Element_Numeric($trnsIdx)); } break; case Zend_Pdf_Resource_Image_Png::PNG_CHANNEL_GRAY_ALPHA: case Zend_Pdf_Resource_Image_Png::PNG_CHANNEL_RGB_ALPHA: throw new Zend_Pdf_Exception( "tRNS chunk illegal for Alpha Channel Images" ); break; } fseek($imageFile, 4, SEEK_CUR); break; case 'IEND'; break 2; default: fseek($imageFile, $chunkLength + 4, SEEK_CUR); break; } } fclose($imageFile); $compressed = true; $imageDataTmp = ''; $smaskData = ''; switch ($color) { case Zend_Pdf_Resource_Image_Png::PNG_CHANNEL_RGB: $colorSpace = new Zend_Pdf_Element_Name('DeviceRGB'); break; case Zend_Pdf_Resource_Image_Png::PNG_CHANNEL_GRAY: $colorSpace = new Zend_Pdf_Element_Name('DeviceGray'); break; case Zend_Pdf_Resource_Image_Png::PNG_CHANNEL_INDEXED: if(empty($paletteData)) { throw new Zend_Pdf_Exception( "PNG Corruption: No palette data read for indexed type PNG." ); } $colorSpace = new Zend_Pdf_Element_Array(); $colorSpace->items[] = new Zend_Pdf_Element_Name('Indexed'); $colorSpace->items[] = new Zend_Pdf_Element_Name('DeviceRGB'); $colorSpace->items[] = new Zend_Pdf_Element_Numeric((strlen($paletteData)/3-1)); $paletteObject = $this->_objectFactory->newObject(new Zend_Pdf_Element_String_Binary($paletteData)); $colorSpace->items[] = $paletteObject; break; case Zend_Pdf_Resource_Image_Png::PNG_CHANNEL_GRAY_ALPHA: if($bits > 8) { throw new Zend_Pdf_Exception("Alpha PNGs with bit depth > 8 are not yet supported"); } $colorSpace = new Zend_Pdf_Element_Name('DeviceGray'); $decodingObjFactory = Zend_Pdf_ElementFactory::createFactory(1); $decodingStream = $decodingObjFactory->newStreamObject($imageData); $decodingStream->dictionary->Filter = new Zend_Pdf_Element_Name('FlateDecode'); $decodingStream->dictionary->DecodeParms = new Zend_Pdf_Element_Dictionary(); $decodingStream->dictionary->DecodeParms->Predictor = new Zend_Pdf_Element_Numeric(15); $decodingStream->dictionary->DecodeParms->Columns = new Zend_Pdf_Element_Numeric($width); $decodingStream->dictionary->DecodeParms->Colors = new Zend_Pdf_Element_Numeric(2); $decodingStream->dictionary->DecodeParms->BitsPerComponent = new Zend_Pdf_Element_Numeric($bits); $decodingStream->skipFilters(); $pngDataRawDecoded = $decodingStream->value; for($pixel = 0, $pixelcount = ($width * $height); $pixel < $pixelcount; $pixel++) { $imageDataTmp .= $pngDataRawDecoded[($pixel*2)]; $smaskData .= $pngDataRawDecoded[($pixel*2)+1]; } $compressed = false; $imageData = $imageDataTmp; break; case Zend_Pdf_Resource_Image_Png::PNG_CHANNEL_RGB_ALPHA: if($bits > 8) { throw new Zend_Pdf_Exception("Alpha PNGs with bit depth > 8 are not yet supported"); } $colorSpace = new Zend_Pdf_Element_Name('DeviceRGB'); $decodingObjFactory = Zend_Pdf_ElementFactory::createFactory(1); $decodingStream = $decodingObjFactory->newStreamObject($imageData); $decodingStream->dictionary->Filter = new Zend_Pdf_Element_Name('FlateDecode'); $decodingStream->dictionary->DecodeParms = new Zend_Pdf_Element_Dictionary(); $decodingStream->dictionary->DecodeParms->Predictor = new Zend_Pdf_Element_Numeric(15); $decodingStream->dictionary->DecodeParms->Columns = new Zend_Pdf_Element_Numeric($width); $decodingStream->dictionary->DecodeParms->Colors = new Zend_Pdf_Element_Numeric(4); $decodingStream->dictionary->DecodeParms->BitsPerComponent = new Zend_Pdf_Element_Numeric($bits); $decodingStream->skipFilters(); $pngDataRawDecoded = $decodingStream->value; for($pixel = 0, $pixelcount = ($width * $height); $pixel < $pixelcount; $pixel++) { $imageDataTmp .= $pngDataRawDecoded[($pixel*4)+0] . $pngDataRawDecoded[($pixel*4)+1] . $pngDataRawDecoded[($pixel*4)+2]; $smaskData .= $pngDataRawDecoded[($pixel*4)+3]; } $compressed = false; $imageData = $imageDataTmp; break; default: throw new Zend_Pdf_Exception( "PNG Corruption: Invalid color space." ); } if(empty($imageData)) { throw new Zend_Pdf_Exception( "Corrupt PNG Image. Mandatory IDAT chunk not found." ); } $imageDictionary = $this->_resource->dictionary; if(!empty($smaskData)) { $smaskStream = $this->_objectFactory->newStreamObject($smaskData); $smaskStream->dictionary->Type = new Zend_Pdf_Element_Name('XObject'); $smaskStream->dictionary->Subtype = new Zend_Pdf_Element_Name('Image'); $smaskStream->dictionary->Width = new Zend_Pdf_Element_Numeric($width); $smaskStream->dictionary->Height = new Zend_Pdf_Element_Numeric($height); $smaskStream->dictionary->ColorSpace = new Zend_Pdf_Element_Name('DeviceGray'); $smaskStream->dictionary->BitsPerComponent = new Zend_Pdf_Element_Numeric($bits); $imageDictionary->SMask = $smaskStream; $smaskStreamDecodeParms = array(); $smaskStreamDecodeParms['Predictor'] = new Zend_Pdf_Element_Numeric(15); $smaskStreamDecodeParms['Columns'] = new Zend_Pdf_Element_Numeric($width); $smaskStreamDecodeParms['Colors'] = new Zend_Pdf_Element_Numeric(1); $smaskStreamDecodeParms['BitsPerComponent'] = new Zend_Pdf_Element_Numeric(8); $smaskStream->dictionary->DecodeParms = new Zend_Pdf_Element_Dictionary($smaskStreamDecodeParms); $smaskStream->dictionary->Filter = new Zend_Pdf_Element_Name('FlateDecode'); } if(!empty($transparencyData)) { $imageDictionary->Mask = new Zend_Pdf_Element_Array($transparencyData); } $imageDictionary->Width = new Zend_Pdf_Element_Numeric($width); $imageDictionary->Height = new Zend_Pdf_Element_Numeric($height); $imageDictionary->ColorSpace = $colorSpace; $imageDictionary->BitsPerComponent = new Zend_Pdf_Element_Numeric($bits); $imageDictionary->Filter = new Zend_Pdf_Element_Name('FlateDecode'); $decodeParms = array(); $decodeParms['Predictor'] = new Zend_Pdf_Element_Numeric(15); $decodeParms['Columns'] = new Zend_Pdf_Element_Numeric($width); $decodeParms['Colors'] = new Zend_Pdf_Element_Numeric((($color==Zend_Pdf_Resource_Image_Png::PNG_CHANNEL_RGB || $color==Zend_Pdf_Resource_Image_Png::PNG_CHANNEL_RGB_ALPHA)?(3):(1))); $decodeParms['BitsPerComponent'] = new Zend_Pdf_Element_Numeric($bits); $imageDictionary->DecodeParms = new Zend_Pdf_Element_Dictionary($decodeParms); $this->_resource->value = $imageData; if ($compressed) { $this->_resource->skipFilters(); } } public function getPixelWidth() { return $this->_width; } public function getPixelHeight() { return $this->_height; } public function getProperties() { return $this->_imageProperties; } }

/* @source /library/Zend/Pdf/Resource/Image/Jpeg.php */
class Zend_Pdf_Resource_Image_Jpeg extends Zend_Pdf_Resource_Image { protected $_width; protected $_height; protected $_imageProperties; public function __construct($imageFileName) { if (!function_exists('gd_info')) { throw new Zend_Pdf_Exception('Image extension is not installed.'); } $gd_options = gd_info(); if ( (!isset($gd_options['JPG Support']) || $gd_options['JPG Support'] != true) && (!isset($gd_options['JPEG Support']) || $gd_options['JPEG Support'] != true) ) { throw new Zend_Pdf_Exception('JPG support is not configured properly.'); } if (($imageInfo = getimagesize($imageFileName)) === false) { throw new Zend_Pdf_Exception('Corrupted image or image doesn\'t exist.'); } if ($imageInfo[2] != IMAGETYPE_JPEG && $imageInfo[2] != IMAGETYPE_JPEG2000) { throw new Zend_Pdf_Exception('ImageType is not JPG'); } parent::__construct(); switch ($imageInfo['channels']) { case 3: $colorSpace = 'DeviceRGB'; break; case 4: $colorSpace = 'DeviceCMYK'; break; default: $colorSpace = 'DeviceGray'; break; } $imageDictionary = $this->_resource->dictionary; $imageDictionary->Width = new Zend_Pdf_Element_Numeric($imageInfo[0]); $imageDictionary->Height = new Zend_Pdf_Element_Numeric($imageInfo[1]); $imageDictionary->ColorSpace = new Zend_Pdf_Element_Name($colorSpace); $imageDictionary->BitsPerComponent = new Zend_Pdf_Element_Numeric($imageInfo['bits']); if ($imageInfo[2] == IMAGETYPE_JPEG) { $imageDictionary->Filter = new Zend_Pdf_Element_Name('DCTDecode'); } else if ($imageInfo[2] == IMAGETYPE_JPEG2000){ $imageDictionary->Filter = new Zend_Pdf_Element_Name('JPXDecode'); } if (($imageFile = @fopen($imageFileName, 'rb')) === false ) { throw new Zend_Pdf_Exception( "Can not open '$imageFileName' file for reading." ); } $byteCount = filesize($imageFileName); $this->_resource->value = ''; while ($byteCount > 0 && !feof($imageFile)) { $nextBlock = fread($imageFile, $byteCount); if ($nextBlock === false) { throw new Zend_Pdf_Exception( "Error occured while '$imageFileName' file reading." ); } $this->_resource->value .= $nextBlock; $byteCount -= strlen($nextBlock); } if ($byteCount != 0) { throw new Zend_Pdf_Exception( "Error occured while '$imageFileName' file reading." ); } fclose($imageFile); $this->_resource->skipFilters(); $this->_width = $imageInfo[0]; $this->_height = $imageInfo[1]; $this->_imageProperties = array(); $this->_imageProperties['bitDepth'] = $imageInfo['bits']; $this->_imageProperties['jpegImageType'] = $imageInfo[2]; $this->_imageProperties['jpegColorType'] = $imageInfo['channels']; } public function getPixelWidth() { return $this->_width; } public function getPixelHeight() { return $this->_height; } public function getProperties() { return $this->_imageProperties; } }

/* @source /library/Zend/Pdf/Resource/Image/Tiff.php */
class Zend_Pdf_Resource_Image_Tiff extends Zend_Pdf_Resource_Image { const TIFF_FIELD_TYPE_BYTE=1; const TIFF_FIELD_TYPE_ASCII=2; const TIFF_FIELD_TYPE_SHORT=3; const TIFF_FIELD_TYPE_LONG=4; const TIFF_FIELD_TYPE_RATIONAL=5; const TIFF_TAG_IMAGE_WIDTH=256; const TIFF_TAG_IMAGE_LENGTH=257; const TIFF_TAG_BITS_PER_SAMPLE=258; const TIFF_TAG_COMPRESSION=259; const TIFF_TAG_PHOTOMETRIC_INTERPRETATION=262; const TIFF_TAG_STRIP_OFFSETS=273; const TIFF_TAG_SAMPLES_PER_PIXEL=277; const TIFF_TAG_STRIP_BYTE_COUNTS=279; const TIFF_COMPRESSION_UNCOMPRESSED = 1; const TIFF_COMPRESSION_CCITT1D = 2; const TIFF_COMPRESSION_GROUP_3_FAX = 3; const TIFF_COMPRESSION_GROUP_4_FAX = 4; const TIFF_COMPRESSION_LZW = 5; const TIFF_COMPRESSION_JPEG = 6; const TIFF_COMPRESSION_FLATE = 8; const TIFF_COMPRESSION_FLATE_OBSOLETE_CODE = 32946; const TIFF_COMPRESSION_PACKBITS = 32773; const TIFF_PHOTOMETRIC_INTERPRETATION_WHITE_IS_ZERO=0; const TIFF_PHOTOMETRIC_INTERPRETATION_BLACK_IS_ZERO=1; const TIFF_PHOTOMETRIC_INTERPRETATION_RGB=2; const TIFF_PHOTOMETRIC_INTERPRETATION_RGB_INDEXED=3; const TIFF_PHOTOMETRIC_INTERPRETATION_CMYK=5; const TIFF_PHOTOMETRIC_INTERPRETATION_YCBCR=6; const TIFF_PHOTOMETRIC_INTERPRETATION_CIELAB=8; protected $_width; protected $_height; protected $_imageProperties; protected $_endianType; protected $_fileSize; protected $_bitsPerSample; protected $_compression; protected $_filter; protected $_colorCode; protected $_whiteIsZero; protected $_blackIsZero; protected $_colorSpace; protected $_imageDataOffset; protected $_imageDataLength; const TIFF_ENDIAN_BIG=0; const TIFF_ENDIAN_LITTLE=1; const UNPACK_TYPE_BYTE=0; const UNPACK_TYPE_SHORT=1; const UNPACK_TYPE_LONG=2; const UNPACK_TYPE_RATIONAL=3; protected function unpackBytes($type, $bytes) { if(!isset($this->_endianType)) { throw new Zend_Pdf_Exception("The unpackBytes function can only be used after the endianness of the file is known"); } switch($type) { case Zend_Pdf_Resource_Image_Tiff::UNPACK_TYPE_BYTE: $format = 'C'; $unpacked = unpack($format, $bytes); return $unpacked[1]; break; case Zend_Pdf_Resource_Image_Tiff::UNPACK_TYPE_SHORT: $format = ($this->_endianType == Zend_Pdf_Resource_Image_Tiff::TIFF_ENDIAN_LITTLE)?'v':'n'; $unpacked = unpack($format, $bytes); return $unpacked[1]; break; case Zend_Pdf_Resource_Image_Tiff::UNPACK_TYPE_LONG: $format = ($this->_endianType == Zend_Pdf_Resource_Image_Tiff::TIFF_ENDIAN_LITTLE)?'V':'N'; $unpacked = unpack($format, $bytes); return $unpacked[1]; break; case Zend_Pdf_Resource_Image_Tiff::UNPACK_TYPE_RATIONAL: $format = ($this->_endianType == Zend_Pdf_Resource_Image_Tiff::TIFF_ENDIAN_LITTLE)?'V2':'N2'; $unpacked = unpack($format, $bytes); return ($unpacked[1]/$unpacked[2]); break; } } public function __construct($imageFileName) { if (($imageFile = @fopen($imageFileName, 'rb')) === false ) { throw new Zend_Pdf_Exception( "Can not open '$imageFileName' file for reading." ); } $byteOrderIndicator = fread($imageFile, 2); if($byteOrderIndicator == 'II') { $this->_endianType = Zend_Pdf_Resource_Image_Tiff::TIFF_ENDIAN_LITTLE; } else if($byteOrderIndicator == 'MM') { $this->_endianType = Zend_Pdf_Resource_Image_Tiff::TIFF_ENDIAN_BIG; } else { throw new Zend_Pdf_Exception( "Not a tiff file or Tiff corrupt. No byte order indication found" ); } $version = $this->unpackBytes(Zend_Pdf_Resource_Image_Tiff::UNPACK_TYPE_SHORT, fread($imageFile, 2)); if($version != 42) { throw new Zend_Pdf_Exception( "Not a tiff file or Tiff corrupt. Incorrect version number." ); } $ifdOffset = $this->unpackBytes(Zend_Pdf_Resource_Image_Tiff::UNPACK_TYPE_LONG, fread($imageFile, 4)); $fileStats = fstat($imageFile); $this->_fileSize = $fileStats['size']; while($ifdOffset > 0) { if(fseek($imageFile, $ifdOffset, SEEK_SET) == -1 || $ifdOffset+2 >= $this->_fileSize) { throw new Zend_Pdf_Exception("Could not seek to the image file directory as indexed by the file. Likely cause is TIFF corruption. Offset: ". $ifdOffset); } $numDirEntries = $this->unpackBytes(Zend_Pdf_Resource_Image_Tiff::UNPACK_TYPE_SHORT, fread($imageFile, 2)); for($dirEntryIdx = 1; $dirEntryIdx <= $numDirEntries; $dirEntryIdx++) { $tag = $this->unpackBytes(Zend_Pdf_Resource_Image_Tiff::UNPACK_TYPE_SHORT, fread($imageFile, 2)); $fieldType = $this->unpackBytes(Zend_Pdf_Resource_Image_Tiff::UNPACK_TYPE_SHORT, fread($imageFile, 2)); $valueCount = $this->unpackBytes(Zend_Pdf_Resource_Image_Tiff::UNPACK_TYPE_LONG, fread($imageFile, 4)); switch($fieldType) { case Zend_Pdf_Resource_Image_Tiff::TIFF_FIELD_TYPE_BYTE: $fieldLength = $valueCount; break; case Zend_Pdf_Resource_Image_Tiff::TIFF_FIELD_TYPE_ASCII: $fieldLength = $valueCount; break; case Zend_Pdf_Resource_Image_Tiff::TIFF_FIELD_TYPE_SHORT: $fieldLength = $valueCount * 2; break; case Zend_Pdf_Resource_Image_Tiff::TIFF_FIELD_TYPE_LONG: $fieldLength = $valueCount * 4; break; case Zend_Pdf_Resource_Image_Tiff::TIFF_FIELD_TYPE_RATIONAL: $fieldLength = $valueCount * 8; break; default: $fieldLength = $valueCount; } $offsetBytes = fread($imageFile, 4); if($fieldLength <= 4) { switch($fieldType) { case Zend_Pdf_Resource_Image_Tiff::TIFF_FIELD_TYPE_BYTE: $value = $this->unpackBytes(Zend_Pdf_Resource_Image_Tiff::UNPACK_TYPE_BYTE, $offsetBytes); break; case Zend_Pdf_Resource_Image_Tiff::TIFF_FIELD_TYPE_ASCII: case Zend_Pdf_Resource_Image_Tiff::TIFF_FIELD_TYPE_LONG: $value = $this->unpackBytes(Zend_Pdf_Resource_Image_Tiff::UNPACK_TYPE_LONG, $offsetBytes); break; case Zend_Pdf_Resource_Image_Tiff::TIFF_FIELD_TYPE_SHORT: default: $value = $this->unpackBytes(Zend_Pdf_Resource_Image_Tiff::UNPACK_TYPE_SHORT, $offsetBytes); } } else { $refOffset = $this->unpackBytes(Zend_Pdf_Resource_Image_Tiff::UNPACK_TYPE_LONG, $offsetBytes); } switch($tag) { case Zend_Pdf_Resource_Image_Tiff::TIFF_TAG_IMAGE_WIDTH: $this->_width = $value; break; case Zend_Pdf_Resource_Image_Tiff::TIFF_TAG_IMAGE_LENGTH: $this->_height = $value; break; case Zend_Pdf_Resource_Image_Tiff::TIFF_TAG_BITS_PER_SAMPLE: if($valueCount>1) { $fp = ftell($imageFile); fseek($imageFile, $refOffset, SEEK_SET); $this->_bitsPerSample = $this->unpackBytes(Zend_Pdf_Resource_Image_Tiff::UNPACK_TYPE_SHORT, fread($imageFile, 2)); fseek($imageFile, $fp, SEEK_SET); } else { $this->_bitsPerSample = $value; } break; case Zend_Pdf_Resource_Image_Tiff::TIFF_TAG_COMPRESSION: $this->_compression = $value; switch($value) { case Zend_Pdf_Resource_Image_Tiff::TIFF_COMPRESSION_UNCOMPRESSED: $this->_filter = 'None'; break; case Zend_Pdf_Resource_Image_Tiff::TIFF_COMPRESSION_CCITT1D: case Zend_Pdf_Resource_Image_Tiff::TIFF_COMPRESSION_GROUP_3_FAX: case Zend_Pdf_Resource_Image_Tiff::TIFF_COMPRESSION_GROUP_4_FAX: $this->_filter = 'CCITTFaxDecode'; throw new Zend_Pdf_Exception("CCITTFaxDecode Compression Mode Not Currently Supported"); break; case Zend_Pdf_Resource_Image_Tiff::TIFF_COMPRESSION_LZW: $this->_filter = 'LZWDecode'; throw new Zend_Pdf_Exception("LZWDecode Compression Mode Not Currently Supported"); break; case Zend_Pdf_Resource_Image_Tiff::TIFF_COMPRESSION_JPEG: $this->_filter = 'DCTDecode'; throw new Zend_Pdf_Exception("JPEG Compression Mode Not Currently Supported"); break; case Zend_Pdf_Resource_Image_Tiff::TIFF_COMPRESSION_FLATE: case Zend_Pdf_Resource_Image_Tiff::TIFF_COMPRESSION_FLATE_OBSOLETE_CODE: $this->_filter = 'FlateDecode'; throw new Zend_Pdf_Exception("ZIP/Flate Compression Mode Not Currently Supported"); break; case Zend_Pdf_Resource_Image_Tiff::TIFF_COMPRESSION_PACKBITS: $this->_filter = 'RunLengthDecode'; break; } break; case Zend_Pdf_Resource_Image_Tiff::TIFF_TAG_PHOTOMETRIC_INTERPRETATION: $this->_colorCode = $value; $this->_whiteIsZero = false; $this->_blackIsZero = false; switch($value) { case Zend_Pdf_Resource_Image_Tiff::TIFF_PHOTOMETRIC_INTERPRETATION_WHITE_IS_ZERO: $this->_whiteIsZero = true; $this->_colorSpace = 'DeviceGray'; break; case Zend_Pdf_Resource_Image_Tiff::TIFF_PHOTOMETRIC_INTERPRETATION_BLACK_IS_ZERO: $this->_blackIsZero = true; $this->_colorSpace = 'DeviceGray'; break; case Zend_Pdf_Resource_Image_Tiff::TIFF_PHOTOMETRIC_INTERPRETATION_YCBCR: case Zend_Pdf_Resource_Image_Tiff::TIFF_PHOTOMETRIC_INTERPRETATION_RGB: $this->_colorSpace = 'DeviceRGB'; break; case Zend_Pdf_Resource_Image_Tiff::TIFF_PHOTOMETRIC_INTERPRETATION_RGB_INDEXED: $this->_colorSpace = 'Indexed'; break; case Zend_Pdf_Resource_Image_Tiff::TIFF_PHOTOMETRIC_INTERPRETATION_CMYK: $this->_colorSpace = 'DeviceCMYK'; break; case Zend_Pdf_Resource_Image_Tiff::TIFF_PHOTOMETRIC_INTERPRETATION_CIELAB: $this->_colorSpace = 'Lab'; break; default: throw new Zend_Pdf_Exception('TIFF: Unknown or Unsupported Color Type: '. $value); } break; case Zend_Pdf_Resource_Image_Tiff::TIFF_TAG_STRIP_OFFSETS: if($valueCount>1) { $format = ($this->_endianType == Zend_Pdf_Resource_Image_Tiff::TIFF_ENDIAN_LITTLE)?'V*':'N*'; $fp = ftell($imageFile); fseek($imageFile, $refOffset, SEEK_SET); $stripOffsetsBytes = fread($imageFile, $fieldLength); $this->_imageDataOffset = unpack($format, $stripOffsetsBytes); fseek($imageFile, $fp, SEEK_SET); } else { $this->_imageDataOffset = $value; } break; case Zend_Pdf_Resource_Image_Tiff::TIFF_TAG_STRIP_BYTE_COUNTS: if($valueCount>1) { $format = ($this->_endianType == Zend_Pdf_Resource_Image_Tiff::TIFF_ENDIAN_LITTLE)?'V*':'N*'; $fp = ftell($imageFile); fseek($imageFile, $refOffset, SEEK_SET); $stripByteCountsBytes = fread($imageFile, $fieldLength); $this->_imageDataLength = unpack($format, $stripByteCountsBytes); fseek($imageFile, $fp, SEEK_SET); } else { $this->_imageDataLength = $value; } break; default: } } $ifdOffset = $this->unpackBytes(Zend_Pdf_Resource_Image_Tiff::UNPACK_TYPE_LONG, fread($imageFile, 4)); } if(!isset($this->_imageDataOffset) || !isset($this->_imageDataLength)) { throw new Zend_Pdf_Exception("TIFF: The image processed did not contain image data as expected."); } $imageDataBytes = ''; if(is_array($this->_imageDataOffset)) { if(!is_array($this->_imageDataLength)) { throw new Zend_Pdf_Exception("TIFF: The image contained multiple data offsets but not multiple data lengths. Tiff may be corrupt."); } foreach($this->_imageDataOffset as $idx => $offset) { fseek($imageFile, $this->_imageDataOffset[$idx], SEEK_SET); $imageDataBytes .= fread($imageFile, $this->_imageDataLength[$idx]); } } else { fseek($imageFile, $this->_imageDataOffset, SEEK_SET); $imageDataBytes = fread($imageFile, $this->_imageDataLength); } if($imageDataBytes === '') { throw new Zend_Pdf_Exception("TIFF: No data. Image Corruption"); } fclose($imageFile); parent::__construct(); $imageDictionary = $this->_resource->dictionary; if(!isset($this->_width) || !isset($this->_width)) { throw new Zend_Pdf_Exception("Problem reading tiff file. Tiff is probably corrupt."); } $this->_imageProperties = array(); $this->_imageProperties['bitDepth'] = $this->_bitsPerSample; $this->_imageProperties['fileSize'] = $this->_fileSize; $this->_imageProperties['TIFFendianType'] = $this->_endianType; $this->_imageProperties['TIFFcompressionType'] = $this->_compression; $this->_imageProperties['TIFFwhiteIsZero'] = $this->_whiteIsZero; $this->_imageProperties['TIFFblackIsZero'] = $this->_blackIsZero; $this->_imageProperties['TIFFcolorCode'] = $this->_colorCode; $this->_imageProperties['TIFFimageDataOffset'] = $this->_imageDataOffset; $this->_imageProperties['TIFFimageDataLength'] = $this->_imageDataLength; $this->_imageProperties['PDFfilter'] = $this->_filter; $this->_imageProperties['PDFcolorSpace'] = $this->_colorSpace; $imageDictionary->Width = new Zend_Pdf_Element_Numeric($this->_width); if($this->_whiteIsZero === true) { $imageDictionary->Decode = new Zend_Pdf_Element_Array(array(new Zend_Pdf_Element_Numeric(1), new Zend_Pdf_Element_Numeric(0))); } $imageDictionary->Height = new Zend_Pdf_Element_Numeric($this->_height); $imageDictionary->ColorSpace = new Zend_Pdf_Element_Name($this->_colorSpace); $imageDictionary->BitsPerComponent = new Zend_Pdf_Element_Numeric($this->_bitsPerSample); if(isset($this->_filter) && $this->_filter != 'None') { $imageDictionary->Filter = new Zend_Pdf_Element_Name($this->_filter); } $this->_resource->value = $imageDataBytes; $this->_resource->skipFilters(); } public function getPixelWidth() { return $this->_width; } public function getPixelHeight() { return $this->_height; } public function getProperties() { return $this->_imageProperties; } }

/* @source /library/Zend/Pdf/Filter/Compression/Lzw.php */
class Zend_Pdf_Filter_Compression_Lzw extends Zend_Pdf_Filter_Compression { private static function _getEarlyChangeValue($params) { if (isset($params['EarlyChange'])) { $earlyChange = $params['EarlyChange']; if ($earlyChange != 0 && $earlyChange != 1) { throw new Zend_Pdf_Exception('Invalid value of \'EarlyChange\' decode param - ' . $earlyChange . '.' ); } return $earlyChange; } else { return 1; } } public static function encode($data, $params = null) { if ($params != null) { $data = self::_applyEncodeParams($data, $params); } throw new Zend_Pdf_Exception('Not implemented yet'); } public static function decode($data, $params = null) { throw new Zend_Pdf_Exception('Not implemented yet'); if ($params !== null) { return self::_applyDecodeParams($data, $params); } else { return $data; } } }

/* @source /library/Zend/Pdf/Filter/Compression/Flate.php */
class Zend_Pdf_Filter_Compression_Flate extends Zend_Pdf_Filter_Compression { public static function encode($data, $params = null) { if ($params != null) { $data = self::_applyEncodeParams($data, $params); } if (extension_loaded('zlib')) { $trackErrors = ini_get( "track_errors"); ini_set('track_errors', '1'); if (($output = @gzcompress($data)) === false) { ini_set('track_errors', $trackErrors); throw new Zend_Pdf_Exception($php_errormsg); } ini_set('track_errors', $trackErrors); } else { throw new Zend_Pdf_Exception('Not implemented yet. You have to use zlib extension.'); } return $output; } public static function decode($data, $params = null) { global $php_errormsg; if (extension_loaded('zlib')) { $trackErrors = ini_get( "track_errors"); ini_set('track_errors', '1'); if (($output = @gzuncompress($data)) === false) { ini_set('track_errors', $trackErrors); throw new Zend_Pdf_Exception($php_errormsg); } ini_set('track_errors', $trackErrors); } else { throw new Zend_Pdf_Exception('Not implemented yet'); } if ($params !== null) { return self::_applyDecodeParams($output, $params); } else { return $output; } } }

/* @source /library/Zend/Pdf/Resource/Font/Type0.php */
class Zend_Pdf_Resource_Font_Type0 extends Zend_Pdf_Resource_Font { private $_descendantFont; static private function getToUnicodeCMapData() { return '/CIDInit /ProcSet findresource begin ' . "\n" . '12 dict begin ' . "\n" . 'begincmap ' . "\n" . '/CIDSystemInfo ' . "\n" . '<</Registry (Adobe) ' . "\n" . '/Ordering (UCS) ' . "\n" . '/Supplement 0' . "\n" . '>> def' . "\n" . '/CMapName /Adobe-Identity-UCS def ' . "\n" . '/CMapType 2 def ' . "\n" . '1 begincodespacerange' . "\n" . '<0000> <FFFF> ' . "\n" . 'endcodespacerange ' . "\n" . '1 beginbfrange ' . "\n" . '<0000> <FFFF> <0000> ' . "\n" . 'endbfrange ' . "\n" . 'endcmap ' . "\n" . 'CMapName currentdict /CMap defineresource pop ' . "\n" . 'end ' . 'end '; } public function __construct(Zend_Pdf_Resource_Font_CidFont $descendantFont) { parent::__construct(); $this->_objectFactory->attach($descendantFont->getFactory()); $this->_fontType = Zend_Pdf_Font::TYPE_TYPE_0; $this->_descendantFont = $descendantFont; $this->_fontNames = $descendantFont->getFontNames(); $this->_isBold = $descendantFont->isBold(); $this->_isItalic = $descendantFont->isItalic(); $this->_isMonospaced = $descendantFont->isMonospace(); $this->_underlinePosition = $descendantFont->getUnderlinePosition(); $this->_underlineThickness = $descendantFont->getUnderlineThickness(); $this->_strikePosition = $descendantFont->getStrikePosition(); $this->_strikeThickness = $descendantFont->getStrikeThickness(); $this->_unitsPerEm = $descendantFont->getUnitsPerEm(); $this->_ascent = $descendantFont->getAscent(); $this->_descent = $descendantFont->getDescent(); $this->_lineGap = $descendantFont->getLineGap(); $this->_resource->Subtype = new Zend_Pdf_Element_Name('Type0'); $this->_resource->BaseFont = new Zend_Pdf_Element_Name($descendantFont->getResource()->BaseFont->value); $this->_resource->DescendantFonts = new Zend_Pdf_Element_Array(array( $descendantFont->getResource() )); $this->_resource->Encoding = new Zend_Pdf_Element_Name('Identity-H'); $toUnicode = $this->_objectFactory->newStreamObject(self::getToUnicodeCMapData()); $this->_resource->ToUnicode = $toUnicode; } public function glyphNumbersForCharacters($characterCodes) { return $characterCodes; } public function glyphNumberForCharacter($characterCode) { return $characterCode; } public function getCoveredPercentage($string, $charEncoding = '') { return $this->_descendantFont->getCoveredPercentage($string, $charEncoding); } public function widthsForGlyphs($glyphNumbers) { return $this->_descendantFont->widthsForChars($glyphNumbers); } public function widthForGlyph($glyphNumber) { return $this->_descendantFont->widthForChar($glyphNumber); } public function encodeString($string, $charEncoding) { return iconv($charEncoding, 'UTF-16BE', $string); } public function decodeString($string, $charEncoding) { return iconv('UTF-16BE', $charEncoding, $string); } }

/* @source /library/Zend/Pdf/Resource/Font/Extracted.php */
class Zend_Pdf_Resource_Font_Extracted extends Zend_Pdf_Resource_Font { const TYPE_NOT_SUPPORTED = 'Unsupported font type.'; const ENCODING_NOT_SUPPORTED = 'Font encoding is not supported'; const OPERATION_NOT_SUPPORTED = 'Operation is not supported for extracted fonts'; protected $_encoding = null; public function __construct($fontDictionary) { $this->_objectFactory = $fontDictionary->getFactory(); $this->_resource = $fontDictionary; if ($fontDictionary->Encoding !== null) { $this->_encoding = $fontDictionary->Encoding->value; } switch ($fontDictionary->Subtype->value) { case 'Type0': if (count($fontDictionary->DescendantFonts->items) != 1) { throw new Zend_Pdf_Exception(self::TYPE_NOT_SUPPORTED); } $fontDictionaryIterator = $fontDictionary->DescendantFonts->items->getIterator(); $fontDictionaryIterator->rewind(); $descendantFont = $fontDictionaryIterator->current(); $fontDescriptor = $descendantFont->FontDescriptor; break; case 'Type1': if ($fontDictionary->FontDescriptor === null) { $standardFont = Zend_Pdf_Font::fontWithName($fontDictionary->BaseFont->value); $this->_fontNames = $standardFont->getFontNames(); $this->_isBold = $standardFont->isBold(); $this->_isItalic = $standardFont->isItalic(); $this->_isMonospace = $standardFont->isMonospace(); $this->_underlinePosition = $standardFont->getUnderlinePosition(); $this->_underlineThickness = $standardFont->getUnderlineThickness(); $this->_strikePosition = $standardFont->getStrikePosition(); $this->_strikeThickness = $standardFont->getStrikeThickness(); $this->_unitsPerEm = $standardFont->getUnitsPerEm(); $this->_ascent = $standardFont->getAscent(); $this->_descent = $standardFont->getDescent(); $this->_lineGap = $standardFont->getLineGap(); return; } $fontDescriptor = $fontDictionary->FontDescriptor; break; case 'TrueType': $fontDescriptor = $fontDictionary->FontDescriptor; break; default: throw new Zend_Pdf_Exception(self::TYPE_NOT_SUPPORTED); } $this->_fontNames[Zend_Pdf_Font::NAME_POSTSCRIPT]['en'] = iconv('UTF-8', 'UTF-16BE', $fontDictionary->BaseFont->value); $this->_isBold = false; $this->_isItalic = ( ($fontDescriptor->Flags->value & (1 << 6)) != 0 ); $this->_isMonospace = ( ($fontDescriptor->Flags->value & (1 << 0)) != 0 ); $this->_underlinePosition = null; $this->_underlineThickness = null; $this->_strikePosition = null; $this->_strikeThickness = null; $this->_unitsPerEm = null; $this->_ascent = $fontDescriptor->Ascent->value; $this->_descent = $fontDescriptor->Descent->value; $this->_lineGap = null; } public function glyphNumbersForCharacters($characterCodes) { throw new Zend_Pdf_Exception(self::OPERATION_NOT_SUPPORTED); } public function glyphNumberForCharacter($characterCode) { throw new Zend_Pdf_Exception(self::OPERATION_NOT_SUPPORTED); } public function getCoveredPercentage($string, $charEncoding = '') { throw new Zend_Pdf_Exception(self::OPERATION_NOT_SUPPORTED); } public function widthsForGlyphs($glyphNumbers) { throw new Zend_Pdf_Exception(self::OPERATION_NOT_SUPPORTED); } public function widthForGlyph($glyphNumber) { throw new Zend_Pdf_Exception(self::OPERATION_NOT_SUPPORTED); } public function encodeString($string, $charEncoding) { if ($this->_encoding == 'Identity-H') { return iconv($charEncoding, 'UTF-16BE', $string); } if ($this->_encoding == 'WinAnsiEncoding') { return iconv($charEncoding, 'CP1252//IGNORE', $string); } throw new Zend_Pdf_Exception(self::ENCODING_NOT_SUPPORTED); } public function decodeString($string, $charEncoding) { if ($this->_encoding == 'Identity-H') { return iconv('UTF-16BE', $charEncoding, $string); } if ($this->_encoding == 'WinAnsiEncoding') { return iconv('CP1252', $charEncoding, $string); } throw new Zend_Pdf_Exception(self::ENCODING_NOT_SUPPORTED); } }

/* @source /library/Zend/Pdf/FileParser/Font/OpenType/TrueType.php */
class Zend_Pdf_FileParser_Font_OpenType_TrueType extends Zend_Pdf_FileParser_Font_OpenType { public function screen() { if ($this->_isScreened) { return; } parent::screen(); switch ($this->_readScalerType()) { case 0x00010000: break; case 0x74727565: break; default: throw new Zend_Pdf_Exception('Not a TrueType font file', Zend_Pdf_Exception::WRONG_FONT_TYPE); } $this->fontType = Zend_Pdf_Font::TYPE_TRUETYPE; $this->_isScreened = true; } public function parse() { if ($this->_isParsed) { return; } parent::parse(); $this->_isParsed = true; } }

/* @source /library/Zend/Pdf/Resource/Font/CidFont/TrueType.php */
class Zend_Pdf_Resource_Font_CidFont_TrueType extends Zend_Pdf_Resource_Font_CidFont { public function __construct(Zend_Pdf_FileParser_Font_OpenType_TrueType $fontParser, $embeddingOptions) { parent::__construct($fontParser, $embeddingOptions); $this->_fontType = Zend_Pdf_Font::TYPE_CIDFONT_TYPE_2; $this->_resource->Subtype = new Zend_Pdf_Element_Name('CIDFontType2'); $fontDescriptor = Zend_Pdf_Resource_Font_FontDescriptor::factory($this, $fontParser, $embeddingOptions); $this->_resource->FontDescriptor = $this->_objectFactory->newObject($fontDescriptor); $cidToGidMapData = str_repeat("\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", 8192); $charGlyphs = $this->_cmap->getCoveredCharactersGlyphs(); foreach ($charGlyphs as $charCode => $glyph) { $cidToGidMapData[$charCode*2 ] = chr($glyph >> 8); $cidToGidMapData[$charCode*2 + 1] = chr($glyph & 0xFF); } $cidToGidMap = $this->_objectFactory->newStreamObject($cidToGidMapData); $cidToGidMap->dictionary->Filter = new Zend_Pdf_Element_Name('FlateDecode'); $this->_resource->CIDToGIDMap = $cidToGidMap; } }

/* @source /library/Zend/Pdf/Resource/Font/Simple/Standard/Symbol.php */
class Zend_Pdf_Resource_Font_Simple_Standard_Symbol extends Zend_Pdf_Resource_Font_Simple_Standard { protected $_toFontEncoding = array( 0x20 => "\x20", 0x21 => "\x21", 0x2200 => "\x22", 0x23 => "\x23", 0x2203 => "\x24", 0x25 => "\x25", 0x26 => "\x26", 0x220b => "\x27", 0x28 => "\x28", 0x29 => "\x29", 0x2217 => "\x2a", 0x2b => "\x2b", 0x2c => "\x2c", 0x2212 => "\x2d", 0x2e => "\x2e", 0x2f => "\x2f", 0x30 => "\x30", 0x31 => "\x31", 0x32 => "\x32", 0x33 => "\x33", 0x34 => "\x34", 0x35 => "\x35", 0x36 => "\x36", 0x37 => "\x37", 0x38 => "\x38", 0x39 => "\x39", 0x3a => "\x3a", 0x3b => "\x3b", 0x3c => "\x3c", 0x3d => "\x3d", 0x3e => "\x3e", 0x3f => "\x3f", 0x2245 => "\x40", 0x0391 => "\x41", 0x0392 => "\x42", 0x03a7 => "\x43", 0x2206 => "\x44", 0x0395 => "\x45", 0x03a6 => "\x46", 0x0393 => "\x47", 0x0397 => "\x48", 0x0399 => "\x49", 0x03d1 => "\x4a", 0x039a => "\x4b", 0x039b => "\x4c", 0x039c => "\x4d", 0x039d => "\x4e", 0x039f => "\x4f", 0x03a0 => "\x50", 0x0398 => "\x51", 0x03a1 => "\x52", 0x03a3 => "\x53", 0x03a4 => "\x54", 0x03a5 => "\x55", 0x03c2 => "\x56", 0x2126 => "\x57", 0x039e => "\x58", 0x03a8 => "\x59", 0x0396 => "\x5a", 0x5b => "\x5b", 0x2234 => "\x5c", 0x5d => "\x5d", 0x22a5 => "\x5e", 0x5f => "\x5f", 0xf8e5 => "\x60", 0x03b1 => "\x61", 0x03b2 => "\x62", 0x03c7 => "\x63", 0x03b4 => "\x64", 0x03b5 => "\x65", 0x03c6 => "\x66", 0x03b3 => "\x67", 0x03b7 => "\x68", 0x03b9 => "\x69", 0x03d5 => "\x6a", 0x03ba => "\x6b", 0x03bb => "\x6c", 0xb5 => "\x6d", 0x03bd => "\x6e", 0x03bf => "\x6f", 0x03c0 => "\x70", 0x03b8 => "\x71", 0x03c1 => "\x72", 0x03c3 => "\x73", 0x03c4 => "\x74", 0x03c5 => "\x75", 0x03d6 => "\x76", 0x03c9 => "\x77", 0x03be => "\x78", 0x03c8 => "\x79", 0x03b6 => "\x7a", 0x7b => "\x7b", 0x7c => "\x7c", 0x7d => "\x7d", 0x223c => "\x7e", 0x20ac => "\xa0", 0x03d2 => "\xa1", 0x2032 => "\xa2", 0x2264 => "\xa3", 0x2044 => "\xa4", 0x221e => "\xa5", 0x0192 => "\xa6", 0x2663 => "\xa7", 0x2666 => "\xa8", 0x2665 => "\xa9", 0x2660 => "\xaa", 0x2194 => "\xab", 0x2190 => "\xac", 0x2191 => "\xad", 0x2192 => "\xae", 0x2193 => "\xaf", 0xb0 => "\xb0", 0xb1 => "\xb1", 0x2033 => "\xb2", 0x2265 => "\xb3", 0xd7 => "\xb4", 0x221d => "\xb5", 0x2202 => "\xb6", 0x2022 => "\xb7", 0xf7 => "\xb8", 0x2260 => "\xb9", 0x2261 => "\xba", 0x2248 => "\xbb", 0x2026 => "\xbc", 0xf8e6 => "\xbd", 0xf8e7 => "\xbe", 0x21b5 => "\xbf", 0x2135 => "\xc0", 0x2111 => "\xc1", 0x211c => "\xc2", 0x2118 => "\xc3", 0x2297 => "\xc4", 0x2295 => "\xc5", 0x2205 => "\xc6", 0x2229 => "\xc7", 0x222a => "\xc8", 0x2283 => "\xc9", 0x2287 => "\xca", 0x2284 => "\xcb", 0x2282 => "\xcc", 0x2286 => "\xcd", 0x2208 => "\xce", 0x2209 => "\xcf", 0x2220 => "\xd0", 0x2207 => "\xd1", 0xf6da => "\xd2", 0xf6d9 => "\xd3", 0xf6db => "\xd4", 0x220f => "\xd5", 0x221a => "\xd6", 0x22c5 => "\xd7", 0xac => "\xd8", 0x2227 => "\xd9", 0x2228 => "\xda", 0x21d4 => "\xdb", 0x21d0 => "\xdc", 0x21d1 => "\xdd", 0x21d2 => "\xde", 0x21d3 => "\xdf", 0x25ca => "\xe0", 0x2329 => "\xe1", 0xf8e8 => "\xe2", 0xf8e9 => "\xe3", 0xf8ea => "\xe4", 0x2211 => "\xe5", 0xf8eb => "\xe6", 0xf8ec => "\xe7", 0xf8ed => "\xe8", 0xf8ee => "\xe9", 0xf8ef => "\xea", 0xf8f0 => "\xeb", 0xf8f1 => "\xec", 0xf8f2 => "\xed", 0xf8f3 => "\xee", 0xf8f4 => "\xef", 0x232a => "\xf1", 0x222b => "\xf2", 0x2320 => "\xf3", 0xf8f5 => "\xf4", 0x2321 => "\xf5", 0xf8f6 => "\xf6", 0xf8f7 => "\xf7", 0xf8f8 => "\xf8", 0xf8f9 => "\xf9", 0xf8fa => "\xfa", 0xf8fb => "\xfb", 0xf8fc => "\xfc", 0xf8fd => "\xfd", 0xf8fe => "\xfe"); protected $_fromFontEncoding = array( 0x20 => "\x00\x20", 0x21 => "\x00\x21", 0x22 => "\x22\x00", 0x23 => "\x00\x23", 0x24 => "\x22\x03", 0x25 => "\x00\x25", 0x26 => "\x00\x26", 0x27 => "\x22\x0b", 0x28 => "\x00\x28", 0x29 => "\x00\x29", 0x2a => "\x22\x17", 0x2b => "\x00\x2b", 0x2c => "\x00\x2c", 0x2d => "\x22\x12", 0x2e => "\x00\x2e", 0x2f => "\x00\x2f", 0x30 => "\x00\x30", 0x31 => "\x00\x31", 0x32 => "\x00\x32", 0x33 => "\x00\x33", 0x34 => "\x00\x34", 0x35 => "\x00\x35", 0x36 => "\x00\x36", 0x37 => "\x00\x37", 0x38 => "\x00\x38", 0x39 => "\x00\x39", 0x3a => "\x00\x3a", 0x3b => "\x00\x3b", 0x3c => "\x00\x3c", 0x3d => "\x00\x3d", 0x3e => "\x00\x3e", 0x3f => "\x00\x3f", 0x40 => "\x22\x45", 0x41 => "\x03\x91", 0x42 => "\x03\x92", 0x43 => "\x03\xa7", 0x44 => "\x22\x06", 0x45 => "\x03\x95", 0x46 => "\x03\xa6", 0x47 => "\x03\x93", 0x48 => "\x03\x97", 0x49 => "\x03\x99", 0x4a => "\x03\xd1", 0x4b => "\x03\x9a", 0x4c => "\x03\x9b", 0x4d => "\x03\x9c", 0x4e => "\x03\x9d", 0x4f => "\x03\x9f", 0x50 => "\x03\xa0", 0x51 => "\x03\x98", 0x52 => "\x03\xa1", 0x53 => "\x03\xa3", 0x54 => "\x03\xa4", 0x55 => "\x03\xa5", 0x56 => "\x03\xc2", 0x57 => "\x21\x26", 0x58 => "\x03\x9e", 0x59 => "\x03\xa8", 0x5a => "\x03\x96", 0x5b => "\x00\x5b", 0x5c => "\x22\x34", 0x5d => "\x00\x5d", 0x5e => "\x22\xa5", 0x5f => "\x00\x5f", 0x60 => "\xf8\xe5", 0x61 => "\x03\xb1", 0x62 => "\x03\xb2", 0x63 => "\x03\xc7", 0x64 => "\x03\xb4", 0x65 => "\x03\xb5", 0x66 => "\x03\xc6", 0x67 => "\x03\xb3", 0x68 => "\x03\xb7", 0x69 => "\x03\xb9", 0x6a => "\x03\xd5", 0x6b => "\x03\xba", 0x6c => "\x03\xbb", 0x6d => "\x00\xb5", 0x6e => "\x03\xbd", 0x6f => "\x03\xbf", 0x70 => "\x03\xc0", 0x71 => "\x03\xb8", 0x72 => "\x03\xc1", 0x73 => "\x03\xc3", 0x74 => "\x03\xc4", 0x75 => "\x03\xc5", 0x76 => "\x03\xd6", 0x77 => "\x03\xc9", 0x78 => "\x03\xbe", 0x79 => "\x03\xc8", 0x7a => "\x03\xb6", 0x7b => "\x00\x7b", 0x7c => "\x00\x7c", 0x7d => "\x00\x7d", 0x7e => "\x22\x3c", 0xa0 => "\x20\xac", 0xa1 => "\x03\xd2", 0xa2 => "\x20\x32", 0xa3 => "\x22\x64", 0xa4 => "\x20\x44", 0xa5 => "\x22\x1e", 0xa6 => "\x01\x92", 0xa7 => "\x26\x63", 0xa8 => "\x26\x66", 0xa9 => "\x26\x65", 0xaa => "\x26\x60", 0xab => "\x21\x94", 0xac => "\x21\x90", 0xad => "\x21\x91", 0xae => "\x21\x92", 0xaf => "\x21\x93", 0xb0 => "\x00\xb0", 0xb1 => "\x00\xb1", 0xb2 => "\x20\x33", 0xb3 => "\x22\x65", 0xb4 => "\x00\xd7", 0xb5 => "\x22\x1d", 0xb6 => "\x22\x02", 0xb7 => "\x20\x22", 0xb8 => "\x00\xf7", 0xb9 => "\x22\x60", 0xba => "\x22\x61", 0xbb => "\x22\x48", 0xbc => "\x20\x26", 0xbd => "\xf8\xe6", 0xbe => "\xf8\xe7", 0xbf => "\x21\xb5", 0xc0 => "\x21\x35", 0xc1 => "\x21\x11", 0xc2 => "\x21\x1c", 0xc3 => "\x21\x18", 0xc4 => "\x22\x97", 0xc5 => "\x22\x95", 0xc6 => "\x22\x05", 0xc7 => "\x22\x29", 0xc8 => "\x22\x2a", 0xc9 => "\x22\x83", 0xca => "\x22\x87", 0xcb => "\x22\x84", 0xcc => "\x22\x82", 0xcd => "\x22\x86", 0xce => "\x22\x08", 0xcf => "\x22\x09", 0xd0 => "\x22\x20", 0xd1 => "\x22\x07", 0xd2 => "\xf6\xda", 0xd3 => "\xf6\xd9", 0xd4 => "\xf6\xdb", 0xd5 => "\x22\x0f", 0xd6 => "\x22\x1a", 0xd7 => "\x22\xc5", 0xd8 => "\x00\xac", 0xd9 => "\x22\x27", 0xda => "\x22\x28", 0xdb => "\x21\xd4", 0xdc => "\x21\xd0", 0xdd => "\x21\xd1", 0xde => "\x21\xd2", 0xdf => "\x21\xd3", 0xe0 => "\x25\xca", 0xe1 => "\x23\x29", 0xe2 => "\xf8\xe8", 0xe3 => "\xf8\xe9", 0xe4 => "\xf8\xea", 0xe5 => "\x22\x11", 0xe6 => "\xf8\xeb", 0xe7 => "\xf8\xec", 0xe8 => "\xf8\xed", 0xe9 => "\xf8\xee", 0xea => "\xf8\xef", 0xeb => "\xf8\xf0", 0xec => "\xf8\xf1", 0xed => "\xf8\xf2", 0xee => "\xf8\xf3", 0xef => "\xf8\xf4", 0xf1 => "\x23\x2a", 0xf2 => "\x22\x2b", 0xf3 => "\x23\x20", 0xf4 => "\xf8\xf5", 0xf5 => "\x23\x21", 0xf6 => "\xf8\xf6", 0xf7 => "\xf8\xf7", 0xf8 => "\xf8\xf8", 0xf9 => "\xf8\xf9", 0xfa => "\xf8\xfa", 0xfb => "\xf8\xfb", 0xfc => "\xf8\xfc", 0xfd => "\xf8\xfd", 0xfe => "\xf8\xfe", ); public function __construct() { parent::__construct(); $this->_fontNames[Zend_Pdf_Font::NAME_COPYRIGHT]['en'] = "\x00\x43\x00\x6f\x00\x70\x00\x79\x00\x72\x00\x69\x00\x67\x00\x68\x00" . "\x74\x00\x20\x00\x28\x00\x63\x00\x29\x00\x20\x00\x31\x00\x39\x00" . "\x38\x00\x35\x00\x2c\x00\x20\x00\x31\x00\x39\x00\x38\x00\x37\x00" . "\x2c\x00\x20\x00\x31\x00\x39\x00\x38\x00\x39\x00\x2c\x00\x20\x00" . "\x31\x00\x39\x00\x39\x00\x30\x00\x2c\x00\x20\x00\x31\x00\x39\x00" . "\x39\x00\x37\x00\x20\x00\x41\x00\x64\x00\x6f\x00\x62\x00\x65\x00" . "\x20\x00\x53\x00\x79\x00\x73\x00\x74\x00\x65\x00\x6d\x00\x73\x00" . "\x20\x00\x49\x00\x6e\x00\x63\x00\x6f\x00\x72\x00\x70\x00\x6f\x00" . "\x72\x00\x61\x00\x74\x00\x65\x00\x64\x00\x2e\x00\x20\x00\x41\x00" . "\x6c\x00\x6c\x00\x20\x00\x72\x00\x69\x00\x67\x00\x68\x00\x74\x00" . "\x73\x00\x20\x00\x72\x00\x65\x00\x73\x00\x65\x00\x72\x00\x76\x00" . "\x65\x00\x64\x00\x2e"; $this->_fontNames[Zend_Pdf_Font::NAME_FAMILY]['en'] = "\x00\x53\x00\x79\x00\x6d\x00\x62\x00\x6f\x00\x6c"; $this->_fontNames[Zend_Pdf_Font::NAME_STYLE]['en'] = "\x00\x4d\x00\x65\x00\x64\x00\x69\x00\x75\x00\x6d"; $this->_fontNames[Zend_Pdf_Font::NAME_ID]['en'] = "\x00\x34\x00\x33\x00\x30\x00\x36\x00\x34"; $this->_fontNames[Zend_Pdf_Font::NAME_FULL]['en'] = "\x00\x53\x00\x79\x00\x6d\x00\x62\x00\x6f\x00\x6c\x00\x20\x00\x4d\x00" . "\x65\x00\x64\x00\x69\x00\x75\x00\x6d"; $this->_fontNames[Zend_Pdf_Font::NAME_VERSION]['en'] = "\x00\x30\x00\x30\x00\x31\x00\x2e\x00\x30\x00\x30\x00\x38"; $this->_fontNames[Zend_Pdf_Font::NAME_POSTSCRIPT]['en'] = "\x00\x53\x00\x79\x00\x6d\x00\x62\x00\x6f\x00\x6c"; $this->_isBold = false; $this->_isItalic = false; $this->_isMonospaced = false; $this->_underlinePosition = -100; $this->_underlineThickness = 50; $this->_strikePosition = 225; $this->_strikeThickness = 50; $this->_unitsPerEm = 1000; $this->_ascent = 1000; $this->_descent = 0; $this->_lineGap = 200; $this->_glyphWidths = array( 0x00 => 0x01f4, 0x01 => 0xfa, 0x02 => 0x014d, 0x03 => 0x02c9, 0x04 => 0x01f4, 0x05 => 0x0225, 0x06 => 0x0341, 0x07 => 0x030a, 0x08 => 0x01b7, 0x09 => 0x014d, 0x0a => 0x014d, 0x0b => 0x01f4, 0x0c => 0x0225, 0x0d => 0xfa, 0x0e => 0x0225, 0x0f => 0xfa, 0x10 => 0x0116, 0x11 => 0x01f4, 0x12 => 0x01f4, 0x13 => 0x01f4, 0x14 => 0x01f4, 0x15 => 0x01f4, 0x16 => 0x01f4, 0x17 => 0x01f4, 0x18 => 0x01f4, 0x19 => 0x01f4, 0x1a => 0x01f4, 0x1b => 0x0116, 0x1c => 0x0116, 0x1d => 0x0225, 0x1e => 0x0225, 0x1f => 0x0225, 0x20 => 0x01bc, 0x21 => 0x0225, 0x22 => 0x02d2, 0x23 => 0x029b, 0x24 => 0x02d2, 0x25 => 0x0264, 0x26 => 0x0263, 0x27 => 0x02fb, 0x28 => 0x025b, 0x29 => 0x02d2, 0x2a => 0x014d, 0x2b => 0x0277, 0x2c => 0x02d2, 0x2d => 0x02ae, 0x2e => 0x0379, 0x2f => 0x02d2, 0x30 => 0x02d2, 0x31 => 0x0300, 0x32 => 0x02e5, 0x33 => 0x022c, 0x34 => 0x0250, 0x35 => 0x0263, 0x36 => 0x02b2, 0x37 => 0x01b7, 0x38 => 0x0300, 0x39 => 0x0285, 0x3a => 0x031b, 0x3b => 0x0263, 0x3c => 0x014d, 0x3d => 0x035f, 0x3e => 0x014d, 0x3f => 0x0292, 0x40 => 0x01f4, 0x41 => 0x01f4, 0x42 => 0x0277, 0x43 => 0x0225, 0x44 => 0x0225, 0x45 => 0x01ee, 0x46 => 0x01b7, 0x47 => 0x0209, 0x48 => 0x019b, 0x49 => 0x025b, 0x4a => 0x0149, 0x4b => 0x025b, 0x4c => 0x0225, 0x4d => 0x0225, 0x4e => 0x0240, 0x4f => 0x0209, 0x50 => 0x0225, 0x51 => 0x0225, 0x52 => 0x0209, 0x53 => 0x0225, 0x54 => 0x025b, 0x55 => 0x01b7, 0x56 => 0x0240, 0x57 => 0x02c9, 0x58 => 0x02ae, 0x59 => 0x01ed, 0x5a => 0x02ae, 0x5b => 0x01ee, 0x5c => 0x01e0, 0x5d => 0xc8, 0x5e => 0x01e0, 0x5f => 0x0225, 0x60 => 0x02ee, 0x61 => 0x026c, 0x62 => 0xf7, 0x63 => 0x0225, 0x64 => 0xa7, 0x65 => 0x02c9, 0x66 => 0x01f4, 0x67 => 0x02f1, 0x68 => 0x02f1, 0x69 => 0x02f1, 0x6a => 0x02f1, 0x6b => 0x0412, 0x6c => 0x03db, 0x6d => 0x025b, 0x6e => 0x03db, 0x6f => 0x025b, 0x70 => 0x0190, 0x71 => 0x0225, 0x72 => 0x019b, 0x73 => 0x0225, 0x74 => 0x0225, 0x75 => 0x02c9, 0x76 => 0x01ee, 0x77 => 0x01cc, 0x78 => 0x0225, 0x79 => 0x0225, 0x7a => 0x0225, 0x7b => 0x0225, 0x7c => 0x03e8, 0x7d => 0x025b, 0x7e => 0x03e8, 0x7f => 0x0292, 0x80 => 0x0337, 0x81 => 0x02ae, 0x82 => 0x031b, 0x83 => 0x03db, 0x84 => 0x0300, 0x85 => 0x0300, 0x86 => 0x0337, 0x87 => 0x0300, 0x88 => 0x0300, 0x89 => 0x02c9, 0x8a => 0x02c9, 0x8b => 0x02c9, 0x8c => 0x02c9, 0x8d => 0x02c9, 0x8e => 0x02c9, 0x8f => 0x02c9, 0x90 => 0x0300, 0x91 => 0x02c9, 0x92 => 0x0316, 0x93 => 0x0316, 0x94 => 0x037a, 0x95 => 0x0337, 0x96 => 0x0225, 0x97 => 0xfa, 0x98 => 0x02c9, 0x99 => 0x025b, 0x9a => 0x025b, 0x9b => 0x0412, 0x9c => 0x03db, 0x9d => 0x025b, 0x9e => 0x03db, 0x9f => 0x025b, 0xa0 => 0x01ee, 0xa1 => 0x0149, 0xa2 => 0x0316, 0xa3 => 0x0316, 0xa4 => 0x0312, 0xa5 => 0x02c9, 0xa6 => 0x0180, 0xa7 => 0x0180, 0xa8 => 0x0180, 0xa9 => 0x0180, 0xaa => 0x0180, 0xab => 0x0180, 0xac => 0x01ee, 0xad => 0x01ee, 0xae => 0x01ee, 0xaf => 0x01ee, 0xb0 => 0x0149, 0xb1 => 0x0112, 0xb2 => 0x02ae, 0xb3 => 0x02ae, 0xb4 => 0x02ae, 0xb5 => 0x0180, 0xb6 => 0x0180, 0xb7 => 0x0180, 0xb8 => 0x0180, 0xb9 => 0x0180, 0xba => 0x0180, 0xbb => 0x01ee, 0xbc => 0x01ee, 0xbd => 0x01ee, 0xbe => 0x0316); $cmapData = array( 0x20 => 0x01, 0x21 => 0x02, 0x2200 => 0x03, 0x23 => 0x04, 0x2203 => 0x05, 0x25 => 0x06, 0x26 => 0x07, 0x220b => 0x08, 0x28 => 0x09, 0x29 => 0x0a, 0x2217 => 0x0b, 0x2b => 0x0c, 0x2c => 0x0d, 0x2212 => 0x0e, 0x2e => 0x0f, 0x2f => 0x10, 0x30 => 0x11, 0x31 => 0x12, 0x32 => 0x13, 0x33 => 0x14, 0x34 => 0x15, 0x35 => 0x16, 0x36 => 0x17, 0x37 => 0x18, 0x38 => 0x19, 0x39 => 0x1a, 0x3a => 0x1b, 0x3b => 0x1c, 0x3c => 0x1d, 0x3d => 0x1e, 0x3e => 0x1f, 0x3f => 0x20, 0x2245 => 0x21, 0x0391 => 0x22, 0x0392 => 0x23, 0x03a7 => 0x24, 0x2206 => 0x25, 0x0395 => 0x26, 0x03a6 => 0x27, 0x0393 => 0x28, 0x0397 => 0x29, 0x0399 => 0x2a, 0x03d1 => 0x2b, 0x039a => 0x2c, 0x039b => 0x2d, 0x039c => 0x2e, 0x039d => 0x2f, 0x039f => 0x30, 0x03a0 => 0x31, 0x0398 => 0x32, 0x03a1 => 0x33, 0x03a3 => 0x34, 0x03a4 => 0x35, 0x03a5 => 0x36, 0x03c2 => 0x37, 0x2126 => 0x38, 0x039e => 0x39, 0x03a8 => 0x3a, 0x0396 => 0x3b, 0x5b => 0x3c, 0x2234 => 0x3d, 0x5d => 0x3e, 0x22a5 => 0x3f, 0x5f => 0x40, 0xf8e5 => 0x41, 0x03b1 => 0x42, 0x03b2 => 0x43, 0x03c7 => 0x44, 0x03b4 => 0x45, 0x03b5 => 0x46, 0x03c6 => 0x47, 0x03b3 => 0x48, 0x03b7 => 0x49, 0x03b9 => 0x4a, 0x03d5 => 0x4b, 0x03ba => 0x4c, 0x03bb => 0x4d, 0xb5 => 0x4e, 0x03bd => 0x4f, 0x03bf => 0x50, 0x03c0 => 0x51, 0x03b8 => 0x52, 0x03c1 => 0x53, 0x03c3 => 0x54, 0x03c4 => 0x55, 0x03c5 => 0x56, 0x03d6 => 0x57, 0x03c9 => 0x58, 0x03be => 0x59, 0x03c8 => 0x5a, 0x03b6 => 0x5b, 0x7b => 0x5c, 0x7c => 0x5d, 0x7d => 0x5e, 0x223c => 0x5f, 0x20ac => 0x60, 0x03d2 => 0x61, 0x2032 => 0x62, 0x2264 => 0x63, 0x2044 => 0x64, 0x221e => 0x65, 0x0192 => 0x66, 0x2663 => 0x67, 0x2666 => 0x68, 0x2665 => 0x69, 0x2660 => 0x6a, 0x2194 => 0x6b, 0x2190 => 0x6c, 0x2191 => 0x6d, 0x2192 => 0x6e, 0x2193 => 0x6f, 0xb0 => 0x70, 0xb1 => 0x71, 0x2033 => 0x72, 0x2265 => 0x73, 0xd7 => 0x74, 0x221d => 0x75, 0x2202 => 0x76, 0x2022 => 0x77, 0xf7 => 0x78, 0x2260 => 0x79, 0x2261 => 0x7a, 0x2248 => 0x7b, 0x2026 => 0x7c, 0xf8e6 => 0x7d, 0xf8e7 => 0x7e, 0x21b5 => 0x7f, 0x2135 => 0x80, 0x2111 => 0x81, 0x211c => 0x82, 0x2118 => 0x83, 0x2297 => 0x84, 0x2295 => 0x85, 0x2205 => 0x86, 0x2229 => 0x87, 0x222a => 0x88, 0x2283 => 0x89, 0x2287 => 0x8a, 0x2284 => 0x8b, 0x2282 => 0x8c, 0x2286 => 0x8d, 0x2208 => 0x8e, 0x2209 => 0x8f, 0x2220 => 0x90, 0x2207 => 0x91, 0xf6da => 0x92, 0xf6d9 => 0x93, 0xf6db => 0x94, 0x220f => 0x95, 0x221a => 0x96, 0x22c5 => 0x97, 0xac => 0x98, 0x2227 => 0x99, 0x2228 => 0x9a, 0x21d4 => 0x9b, 0x21d0 => 0x9c, 0x21d1 => 0x9d, 0x21d2 => 0x9e, 0x21d3 => 0x9f, 0x25ca => 0xa0, 0x2329 => 0xa1, 0xf8e8 => 0xa2, 0xf8e9 => 0xa3, 0xf8ea => 0xa4, 0x2211 => 0xa5, 0xf8eb => 0xa6, 0xf8ec => 0xa7, 0xf8ed => 0xa8, 0xf8ee => 0xa9, 0xf8ef => 0xaa, 0xf8f0 => 0xab, 0xf8f1 => 0xac, 0xf8f2 => 0xad, 0xf8f3 => 0xae, 0xf8f4 => 0xaf, 0x232a => 0xb0, 0x222b => 0xb1, 0x2320 => 0xb2, 0xf8f5 => 0xb3, 0x2321 => 0xb4, 0xf8f6 => 0xb5, 0xf8f7 => 0xb6, 0xf8f8 => 0xb7, 0xf8f9 => 0xb8, 0xf8fa => 0xb9, 0xf8fb => 0xba, 0xf8fc => 0xbb, 0xf8fd => 0xbc, 0xf8fe => 0xbd, 0xf8ff => 0xbe); $this->_cmap = Zend_Pdf_Cmap::cmapWithTypeData( Zend_Pdf_Cmap::TYPE_BYTE_ENCODING_STATIC, $cmapData); $this->_resource->BaseFont = new Zend_Pdf_Element_Name('Symbol'); $this->_resource->Encoding = null; } public function encodeString($string, $charEncoding) { if ($charEncoding != 'UTF-16BE') { $string = iconv($charEncoding, 'UTF-16BE', $string); } $encodedString = ''; for ($i = 0; $i < strlen($string); $i++) { $characterCode = (ord($string[$i++]) << 8) | ord($string[$i]); if (isset($this->_toFontEncoding[$characterCode])) { $encodedString .= $this->_toFontEncoding[$characterCode]; } else { } } return $encodedString; } public function decodeString($string, $charEncoding) { $decodedString = ''; for ($i = 0; $i < strlen($string); $i++) { $characterCode = ord($string[$i]); if (isset($this->_fromFontEncoding[$characterCode])) { $decodedString .= $this->_fromFontEncoding[$characterCode]; } else { } } if ($charEncoding != 'UTF-16BE') { $decodedString = iconv('UTF-16BE', $charEncoding, $decodedString); } return $decodedString; } public function toUnicode($string, $charEncoding = '') { if ($charEncoding != 'ISO-8859-1') { $string = iconv($charEncoding, 'ISO-8859-1', $string); } return $this->decodeString($string, 'UTF-16BE'); } }

/* @source /library/Zend/Pdf/Resource/Font/Simple/Standard/Courier.php */
class Zend_Pdf_Resource_Font_Simple_Standard_Courier extends Zend_Pdf_Resource_Font_Simple_Standard { public function __construct() { parent::__construct(); $this->_fontNames[Zend_Pdf_Font::NAME_COPYRIGHT]['en'] = "\x00\x43\x00\x6f\x00\x70\x00\x79\x00\x72\x00\x69\x00\x67\x00\x68\x00" . "\x74\x00\x20\x00\x28\x00\x63\x00\x29\x00\x20\x00\x31\x00\x39\x00" . "\x38\x00\x39\x00\x2c\x00\x20\x00\x31\x00\x39\x00\x39\x00\x30\x00" . "\x2c\x00\x20\x00\x31\x00\x39\x00\x39\x00\x31\x00\x2c\x00\x20\x00" . "\x31\x00\x39\x00\x39\x00\x32\x00\x2c\x00\x20\x00\x31\x00\x39\x00" . "\x39\x00\x33\x00\x2c\x00\x20\x00\x31\x00\x39\x00\x39\x00\x37\x00" . "\x20\x00\x41\x00\x64\x00\x6f\x00\x62\x00\x65\x00\x20\x00\x53\x00" . "\x79\x00\x73\x00\x74\x00\x65\x00\x6d\x00\x73\x00\x20\x00\x49\x00" . "\x6e\x00\x63\x00\x6f\x00\x72\x00\x70\x00\x6f\x00\x72\x00\x61\x00" . "\x74\x00\x65\x00\x64\x00\x2e\x00\x20\x00\x20\x00\x41\x00\x6c\x00" . "\x6c\x00\x20\x00\x52\x00\x69\x00\x67\x00\x68\x00\x74\x00\x73\x00" . "\x20\x00\x52\x00\x65\x00\x73\x00\x65\x00\x72\x00\x76\x00\x65\x00" . "\x64\x00\x2e"; $this->_fontNames[Zend_Pdf_Font::NAME_FAMILY]['en'] = "\x00\x43\x00\x6f\x00\x75\x00\x72\x00\x69\x00\x65\x00\x72"; $this->_fontNames[Zend_Pdf_Font::NAME_STYLE]['en'] = "\x00\x4d\x00\x65\x00\x64\x00\x69\x00\x75\x00\x6d"; $this->_fontNames[Zend_Pdf_Font::NAME_ID]['en'] = "\x00\x34\x00\x33\x00\x30\x00\x35\x00\x30"; $this->_fontNames[Zend_Pdf_Font::NAME_FULL]['en'] = "\x00\x43\x00\x6f\x00\x75\x00\x72\x00\x69\x00\x65\x00\x72\x00\x20\x00" . "\x4d\x00\x65\x00\x64\x00\x69\x00\x75\x00\x6d"; $this->_fontNames[Zend_Pdf_Font::NAME_VERSION]['en'] = "\x00\x30\x00\x30\x00\x33\x00\x2e\x00\x30\x00\x30\x00\x30"; $this->_fontNames[Zend_Pdf_Font::NAME_POSTSCRIPT]['en'] = "\x00\x43\x00\x6f\x00\x75\x00\x72\x00\x69\x00\x65\x00\x72"; $this->_isBold = false; $this->_isItalic = false; $this->_isMonospaced = true; $this->_underlinePosition = -100; $this->_underlineThickness = 50; $this->_strikePosition = 225; $this->_strikeThickness = 50; $this->_unitsPerEm = 1000; $this->_ascent = 629; $this->_descent = -157; $this->_lineGap = 414; $this->_glyphWidths = array( 0x00 => 0x01f4, 0x01 => 0x0258, 0x02 => 0x0258, 0x03 => 0x0258, 0x04 => 0x0258, 0x05 => 0x0258, 0x06 => 0x0258, 0x07 => 0x0258, 0x08 => 0x0258, 0x09 => 0x0258, 0x0a => 0x0258, 0x0b => 0x0258, 0x0c => 0x0258, 0x0d => 0x0258, 0x0e => 0x0258, 0x0f => 0x0258, 0x10 => 0x0258, 0x11 => 0x0258, 0x12 => 0x0258, 0x13 => 0x0258, 0x14 => 0x0258, 0x15 => 0x0258, 0x16 => 0x0258, 0x17 => 0x0258, 0x18 => 0x0258, 0x19 => 0x0258, 0x1a => 0x0258, 0x1b => 0x0258, 0x1c => 0x0258, 0x1d => 0x0258, 0x1e => 0x0258, 0x1f => 0x0258, 0x20 => 0x0258, 0x21 => 0x0258, 0x22 => 0x0258, 0x23 => 0x0258, 0x24 => 0x0258, 0x25 => 0x0258, 0x26 => 0x0258, 0x27 => 0x0258, 0x28 => 0x0258, 0x29 => 0x0258, 0x2a => 0x0258, 0x2b => 0x0258, 0x2c => 0x0258, 0x2d => 0x0258, 0x2e => 0x0258, 0x2f => 0x0258, 0x30 => 0x0258, 0x31 => 0x0258, 0x32 => 0x0258, 0x33 => 0x0258, 0x34 => 0x0258, 0x35 => 0x0258, 0x36 => 0x0258, 0x37 => 0x0258, 0x38 => 0x0258, 0x39 => 0x0258, 0x3a => 0x0258, 0x3b => 0x0258, 0x3c => 0x0258, 0x3d => 0x0258, 0x3e => 0x0258, 0x3f => 0x0258, 0x40 => 0x0258, 0x41 => 0x0258, 0x42 => 0x0258, 0x43 => 0x0258, 0x44 => 0x0258, 0x45 => 0x0258, 0x46 => 0x0258, 0x47 => 0x0258, 0x48 => 0x0258, 0x49 => 0x0258, 0x4a => 0x0258, 0x4b => 0x0258, 0x4c => 0x0258, 0x4d => 0x0258, 0x4e => 0x0258, 0x4f => 0x0258, 0x50 => 0x0258, 0x51 => 0x0258, 0x52 => 0x0258, 0x53 => 0x0258, 0x54 => 0x0258, 0x55 => 0x0258, 0x56 => 0x0258, 0x57 => 0x0258, 0x58 => 0x0258, 0x59 => 0x0258, 0x5a => 0x0258, 0x5b => 0x0258, 0x5c => 0x0258, 0x5d => 0x0258, 0x5e => 0x0258, 0x5f => 0x0258, 0x60 => 0x0258, 0x61 => 0x0258, 0x62 => 0x0258, 0x63 => 0x0258, 0x64 => 0x0258, 0x65 => 0x0258, 0x66 => 0x0258, 0x67 => 0x0258, 0x68 => 0x0258, 0x69 => 0x0258, 0x6a => 0x0258, 0x6b => 0x0258, 0x6c => 0x0258, 0x6d => 0x0258, 0x6e => 0x0258, 0x6f => 0x0258, 0x70 => 0x0258, 0x71 => 0x0258, 0x72 => 0x0258, 0x73 => 0x0258, 0x74 => 0x0258, 0x75 => 0x0258, 0x76 => 0x0258, 0x77 => 0x0258, 0x78 => 0x0258, 0x79 => 0x0258, 0x7a => 0x0258, 0x7b => 0x0258, 0x7c => 0x0258, 0x7d => 0x0258, 0x7e => 0x0258, 0x7f => 0x0258, 0x80 => 0x0258, 0x81 => 0x0258, 0x82 => 0x0258, 0x83 => 0x0258, 0x84 => 0x0258, 0x85 => 0x0258, 0x86 => 0x0258, 0x87 => 0x0258, 0x88 => 0x0258, 0x89 => 0x0258, 0x8a => 0x0258, 0x8b => 0x0258, 0x8c => 0x0258, 0x8d => 0x0258, 0x8e => 0x0258, 0x8f => 0x0258, 0x90 => 0x0258, 0x91 => 0x0258, 0x92 => 0x0258, 0x93 => 0x0258, 0x94 => 0x0258, 0x95 => 0x0258, 0x96 => 0x0258, 0x97 => 0x0258, 0x98 => 0x0258, 0x99 => 0x0258, 0x9a => 0x0258, 0x9b => 0x0258, 0x9c => 0x0258, 0x9d => 0x0258, 0x9e => 0x0258, 0x9f => 0x0258, 0xa0 => 0x0258, 0xa1 => 0x0258, 0xa2 => 0x0258, 0xa3 => 0x0258, 0xa4 => 0x0258, 0xa5 => 0x0258, 0xa6 => 0x0258, 0xa7 => 0x0258, 0xa8 => 0x0258, 0xa9 => 0x0258, 0xaa => 0x0258, 0xab => 0x0258, 0xac => 0x0258, 0xad => 0x0258, 0xae => 0x0258, 0xaf => 0x0258, 0xb0 => 0x0258, 0xb1 => 0x0258, 0xb2 => 0x0258, 0xb3 => 0x0258, 0xb4 => 0x0258, 0xb5 => 0x0258, 0xb6 => 0x0258, 0xb7 => 0x0258, 0xb8 => 0x0258, 0xb9 => 0x0258, 0xba => 0x0258, 0xbb => 0x0258, 0xbc => 0x0258, 0xbd => 0x0258, 0xbe => 0x0258, 0xbf => 0x0258, 0xc0 => 0x0258, 0xc1 => 0x0258, 0xc2 => 0x0258, 0xc3 => 0x0258, 0xc4 => 0x0258, 0xc5 => 0x0258, 0xc6 => 0x0258, 0xc7 => 0x0258, 0xc8 => 0x0258, 0xc9 => 0x0258, 0xca => 0x0258, 0xcb => 0x0258, 0xcc => 0x0258, 0xcd => 0x0258, 0xce => 0x0258, 0xcf => 0x0258, 0xd0 => 0x0258, 0xd1 => 0x0258, 0xd2 => 0x0258, 0xd3 => 0x0258, 0xd4 => 0x0258, 0xd5 => 0x0258, 0xd6 => 0x0258, 0xd7 => 0x0258, 0xd8 => 0x0258, 0xd9 => 0x0258, 0xda => 0x0258, 0xdb => 0x0258, 0xdc => 0x0258, 0xdd => 0x0258, 0xde => 0x0258, 0xdf => 0x0258, 0xe0 => 0x0258, 0xe1 => 0x0258, 0xe2 => 0x0258, 0xe3 => 0x0258, 0xe4 => 0x0258, 0xe5 => 0x0258, 0xe6 => 0x0258, 0xe7 => 0x0258, 0xe8 => 0x0258, 0xe9 => 0x0258, 0xea => 0x0258, 0xeb => 0x0258, 0xec => 0x0258, 0xed => 0x0258, 0xee => 0x0258, 0xef => 0x0258, 0xf0 => 0x0258, 0xf1 => 0x0258, 0xf2 => 0x0258, 0xf3 => 0x0258, 0xf4 => 0x0258, 0xf5 => 0x0258, 0xf6 => 0x0258, 0xf7 => 0x0258, 0xf8 => 0x0258, 0xf9 => 0x0258, 0xfa => 0x0258, 0xfb => 0x0258, 0xfc => 0x0258, 0xfd => 0x0258, 0xfe => 0x0258, 0xff => 0x0258, 0x0100 => 0x0258, 0x0101 => 0x0258, 0x0102 => 0x0258, 0x0103 => 0x0258, 0x0104 => 0x0258, 0x0105 => 0x0258, 0x0106 => 0x0258, 0x0107 => 0x0258, 0x0108 => 0x0258, 0x0109 => 0x0258, 0x010a => 0x0258, 0x010b => 0x0258, 0x010c => 0x0258, 0x010d => 0x0258, 0x010e => 0x0258, 0x010f => 0x0258, 0x0110 => 0x0258, 0x0111 => 0x0258, 0x0112 => 0x0258, 0x0113 => 0x0258, 0x0114 => 0x0258, 0x0115 => 0x0258, 0x0116 => 0x0258, 0x0117 => 0x0258, 0x0118 => 0x0258, 0x0119 => 0x0258, 0x011a => 0x0258, 0x011b => 0x0258, 0x011c => 0x0258, 0x011d => 0x0258, 0x011e => 0x0258, 0x011f => 0x0258, 0x0120 => 0x0258, 0x0121 => 0x0258, 0x0122 => 0x0258, 0x0123 => 0x0258, 0x0124 => 0x0258, 0x0125 => 0x0258, 0x0126 => 0x0258, 0x0127 => 0x0258, 0x0128 => 0x0258, 0x0129 => 0x0258, 0x012a => 0x0258, 0x012b => 0x0258, 0x012c => 0x0258, 0x012d => 0x0258, 0x012e => 0x0258, 0x012f => 0x0258, 0x0130 => 0x0258, 0x0131 => 0x0258, 0x0132 => 0x0258, 0x0133 => 0x0258, 0x0134 => 0x0258, 0x0135 => 0x0258, 0x0136 => 0x0258, 0x0137 => 0x0258, 0x0138 => 0x0258, 0x0139 => 0x0258, 0x013a => 0x0258, 0x013b => 0x0258, ); $cmapData = array( 0x20 => 0x01, 0x21 => 0x02, 0x22 => 0x03, 0x23 => 0x04, 0x24 => 0x05, 0x25 => 0x06, 0x26 => 0x07, 0x2019 => 0x08, 0x28 => 0x09, 0x29 => 0x0a, 0x2a => 0x0b, 0x2b => 0x0c, 0x2c => 0x0d, 0x2d => 0x0e, 0x2e => 0x0f, 0x2f => 0x10, 0x30 => 0x11, 0x31 => 0x12, 0x32 => 0x13, 0x33 => 0x14, 0x34 => 0x15, 0x35 => 0x16, 0x36 => 0x17, 0x37 => 0x18, 0x38 => 0x19, 0x39 => 0x1a, 0x3a => 0x1b, 0x3b => 0x1c, 0x3c => 0x1d, 0x3d => 0x1e, 0x3e => 0x1f, 0x3f => 0x20, 0x40 => 0x21, 0x41 => 0x22, 0x42 => 0x23, 0x43 => 0x24, 0x44 => 0x25, 0x45 => 0x26, 0x46 => 0x27, 0x47 => 0x28, 0x48 => 0x29, 0x49 => 0x2a, 0x4a => 0x2b, 0x4b => 0x2c, 0x4c => 0x2d, 0x4d => 0x2e, 0x4e => 0x2f, 0x4f => 0x30, 0x50 => 0x31, 0x51 => 0x32, 0x52 => 0x33, 0x53 => 0x34, 0x54 => 0x35, 0x55 => 0x36, 0x56 => 0x37, 0x57 => 0x38, 0x58 => 0x39, 0x59 => 0x3a, 0x5a => 0x3b, 0x5b => 0x3c, 0x5c => 0x3d, 0x5d => 0x3e, 0x5e => 0x3f, 0x5f => 0x40, 0x2018 => 0x41, 0x61 => 0x42, 0x62 => 0x43, 0x63 => 0x44, 0x64 => 0x45, 0x65 => 0x46, 0x66 => 0x47, 0x67 => 0x48, 0x68 => 0x49, 0x69 => 0x4a, 0x6a => 0x4b, 0x6b => 0x4c, 0x6c => 0x4d, 0x6d => 0x4e, 0x6e => 0x4f, 0x6f => 0x50, 0x70 => 0x51, 0x71 => 0x52, 0x72 => 0x53, 0x73 => 0x54, 0x74 => 0x55, 0x75 => 0x56, 0x76 => 0x57, 0x77 => 0x58, 0x78 => 0x59, 0x79 => 0x5a, 0x7a => 0x5b, 0x7b => 0x5c, 0x7c => 0x5d, 0x7d => 0x5e, 0x7e => 0x5f, 0xa1 => 0x60, 0xa2 => 0x61, 0xa3 => 0x62, 0x2044 => 0x63, 0xa5 => 0x64, 0x0192 => 0x65, 0xa7 => 0x66, 0xa4 => 0x67, 0x27 => 0x68, 0x201c => 0x69, 0xab => 0x6a, 0x2039 => 0x6b, 0x203a => 0x6c, 0xfb01 => 0x6d, 0xfb02 => 0x6e, 0x2013 => 0x6f, 0x2020 => 0x70, 0x2021 => 0x71, 0xb7 => 0x72, 0xb6 => 0x73, 0x2022 => 0x74, 0x201a => 0x75, 0x201e => 0x76, 0x201d => 0x77, 0xbb => 0x78, 0x2026 => 0x79, 0x2030 => 0x7a, 0xbf => 0x7b, 0x60 => 0x7c, 0xb4 => 0x7d, 0x02c6 => 0x7e, 0x02dc => 0x7f, 0xaf => 0x80, 0x02d8 => 0x81, 0x02d9 => 0x82, 0xa8 => 0x83, 0x02da => 0x84, 0xb8 => 0x85, 0x02dd => 0x86, 0x02db => 0x87, 0x02c7 => 0x88, 0x2014 => 0x89, 0xc6 => 0x8a, 0xaa => 0x8b, 0x0141 => 0x8c, 0xd8 => 0x8d, 0x0152 => 0x8e, 0xba => 0x8f, 0xe6 => 0x90, 0x0131 => 0x91, 0x0142 => 0x92, 0xf8 => 0x93, 0x0153 => 0x94, 0xdf => 0x95, 0xcf => 0x96, 0xe9 => 0x97, 0x0103 => 0x98, 0x0171 => 0x99, 0x011b => 0x9a, 0x0178 => 0x9b, 0xf7 => 0x9c, 0xdd => 0x9d, 0xc2 => 0x9e, 0xe1 => 0x9f, 0xdb => 0xa0, 0xfd => 0xa1, 0x0219 => 0xa2, 0xea => 0xa3, 0x016e => 0xa4, 0xdc => 0xa5, 0x0105 => 0xa6, 0xda => 0xa7, 0x0173 => 0xa8, 0xcb => 0xa9, 0x0110 => 0xaa, 0xf6c3 => 0xab, 0xa9 => 0xac, 0x0112 => 0xad, 0x010d => 0xae, 0xe5 => 0xaf, 0x0145 => 0xb0, 0x013a => 0xb1, 0xe0 => 0xb2, 0x0162 => 0xb3, 0x0106 => 0xb4, 0xe3 => 0xb5, 0x0116 => 0xb6, 0x0161 => 0xb7, 0x015f => 0xb8, 0xed => 0xb9, 0x25ca => 0xba, 0x0158 => 0xbb, 0x0122 => 0xbc, 0xfb => 0xbd, 0xe2 => 0xbe, 0x0100 => 0xbf, 0x0159 => 0xc0, 0xe7 => 0xc1, 0x017b => 0xc2, 0xde => 0xc3, 0x014c => 0xc4, 0x0154 => 0xc5, 0x015a => 0xc6, 0x010f => 0xc7, 0x016a => 0xc8, 0x016f => 0xc9, 0xb3 => 0xca, 0xd2 => 0xcb, 0xc0 => 0xcc, 0x0102 => 0xcd, 0xd7 => 0xce, 0xfa => 0xcf, 0x0164 => 0xd0, 0x2202 => 0xd1, 0xff => 0xd2, 0x0143 => 0xd3, 0xee => 0xd4, 0xca => 0xd5, 0xe4 => 0xd6, 0xeb => 0xd7, 0x0107 => 0xd8, 0x0144 => 0xd9, 0x016b => 0xda, 0x0147 => 0xdb, 0xcd => 0xdc, 0xb1 => 0xdd, 0xa6 => 0xde, 0xae => 0xdf, 0x011e => 0xe0, 0x0130 => 0xe1, 0x2211 => 0xe2, 0xc8 => 0xe3, 0x0155 => 0xe4, 0x014d => 0xe5, 0x0179 => 0xe6, 0x017d => 0xe7, 0x2265 => 0xe8, 0xd0 => 0xe9, 0xc7 => 0xea, 0x013c => 0xeb, 0x0165 => 0xec, 0x0119 => 0xed, 0x0172 => 0xee, 0xc1 => 0xef, 0xc4 => 0xf0, 0xe8 => 0xf1, 0x017a => 0xf2, 0x012f => 0xf3, 0xd3 => 0xf4, 0xf3 => 0xf5, 0x0101 => 0xf6, 0x015b => 0xf7, 0xef => 0xf8, 0xd4 => 0xf9, 0xd9 => 0xfa, 0x2206 => 0xfb, 0xfe => 0xfc, 0xb2 => 0xfd, 0xd6 => 0xfe, 0xb5 => 0xff, 0xec => 0x0100, 0x0151 => 0x0101, 0x0118 => 0x0102, 0x0111 => 0x0103, 0xbe => 0x0104, 0x015e => 0x0105, 0x013e => 0x0106, 0x0136 => 0x0107, 0x0139 => 0x0108, 0x2122 => 0x0109, 0x0117 => 0x010a, 0xcc => 0x010b, 0x012a => 0x010c, 0x013d => 0x010d, 0xbd => 0x010e, 0x2264 => 0x010f, 0xf4 => 0x0110, 0xf1 => 0x0111, 0x0170 => 0x0112, 0xc9 => 0x0113, 0x0113 => 0x0114, 0x011f => 0x0115, 0xbc => 0x0116, 0x0160 => 0x0117, 0x0218 => 0x0118, 0x0150 => 0x0119, 0xb0 => 0x011a, 0xf2 => 0x011b, 0x010c => 0x011c, 0xf9 => 0x011d, 0x221a => 0x011e, 0x010e => 0x011f, 0x0157 => 0x0120, 0xd1 => 0x0121, 0xf5 => 0x0122, 0x0156 => 0x0123, 0x013b => 0x0124, 0xc3 => 0x0125, 0x0104 => 0x0126, 0xc5 => 0x0127, 0xd5 => 0x0128, 0x017c => 0x0129, 0x011a => 0x012a, 0x012e => 0x012b, 0x0137 => 0x012c, 0x2212 => 0x012d, 0xce => 0x012e, 0x0148 => 0x012f, 0x0163 => 0x0130, 0xac => 0x0131, 0xf6 => 0x0132, 0xfc => 0x0133, 0x2260 => 0x0134, 0x0123 => 0x0135, 0xf0 => 0x0136, 0x017e => 0x0137, 0x0146 => 0x0138, 0xb9 => 0x0139, 0x012b => 0x013a, 0x20ac => 0x013b); $this->_cmap = Zend_Pdf_Cmap::cmapWithTypeData( Zend_Pdf_Cmap::TYPE_BYTE_ENCODING_STATIC, $cmapData); $this->_resource->BaseFont = new Zend_Pdf_Element_Name('Courier'); } }

/* @source /library/Zend/Pdf/Resource/Font/Simple/Standard/CourierBold.php */
class Zend_Pdf_Resource_Font_Simple_Standard_CourierBold extends Zend_Pdf_Resource_Font_Simple_Standard { public function __construct() { parent::__construct(); $this->_fontNames[Zend_Pdf_Font::NAME_COPYRIGHT]['en'] = "\x00\x43\x00\x6f\x00\x70\x00\x79\x00\x72\x00\x69\x00\x67\x00\x68\x00" . "\x74\x00\x20\x00\x28\x00\x63\x00\x29\x00\x20\x00\x31\x00\x39\x00" . "\x38\x00\x39\x00\x2c\x00\x20\x00\x31\x00\x39\x00\x39\x00\x30\x00" . "\x2c\x00\x20\x00\x31\x00\x39\x00\x39\x00\x31\x00\x2c\x00\x20\x00" . "\x31\x00\x39\x00\x39\x00\x33\x00\x2c\x00\x20\x00\x31\x00\x39\x00" . "\x39\x00\x37\x00\x20\x00\x41\x00\x64\x00\x6f\x00\x62\x00\x65\x00" . "\x20\x00\x53\x00\x79\x00\x73\x00\x74\x00\x65\x00\x6d\x00\x73\x00" . "\x20\x00\x49\x00\x6e\x00\x63\x00\x6f\x00\x72\x00\x70\x00\x6f\x00" . "\x72\x00\x61\x00\x74\x00\x65\x00\x64\x00\x2e\x00\x20\x00\x20\x00" . "\x41\x00\x6c\x00\x6c\x00\x20\x00\x52\x00\x69\x00\x67\x00\x68\x00" . "\x74\x00\x73\x00\x20\x00\x52\x00\x65\x00\x73\x00\x65\x00\x72\x00" . "\x76\x00\x65\x00\x64\x00\x2e"; $this->_fontNames[Zend_Pdf_Font::NAME_FAMILY]['en'] = "\x00\x43\x00\x6f\x00\x75\x00\x72\x00\x69\x00\x65\x00\x72"; $this->_fontNames[Zend_Pdf_Font::NAME_STYLE]['en'] = "\x00\x42\x00\x6f\x00\x6c\x00\x64"; $this->_fontNames[Zend_Pdf_Font::NAME_ID]['en'] = "\x00\x34\x00\x33\x00\x30\x00\x34\x00\x38"; $this->_fontNames[Zend_Pdf_Font::NAME_FULL]['en'] = "\x00\x43\x00\x6f\x00\x75\x00\x72\x00\x69\x00\x65\x00\x72\x00\x2d\x00" . "\x42\x00\x6f\x00\x6c\x00\x64\x00\x20\x00\x42\x00\x6f\x00\x6c\x00" . "\x64"; $this->_fontNames[Zend_Pdf_Font::NAME_VERSION]['en'] = "\x00\x30\x00\x30\x00\x33\x00\x2e\x00\x30\x00\x30\x00\x30"; $this->_fontNames[Zend_Pdf_Font::NAME_POSTSCRIPT]['en'] = "\x00\x43\x00\x6f\x00\x75\x00\x72\x00\x69\x00\x65\x00\x72\x00\x2d\x00" . "\x42\x00\x6f\x00\x6c\x00\x64"; $this->_isBold = true; $this->_isItalic = false; $this->_isMonospaced = true; $this->_underlinePosition = -100; $this->_underlineThickness = 50; $this->_strikePosition = 225; $this->_strikeThickness = 50; $this->_unitsPerEm = 1000; $this->_ascent = 629; $this->_descent = -157; $this->_lineGap = 414; $this->_glyphWidths = array( 0x00 => 0x01f4, 0x01 => 0x0258, 0x02 => 0x0258, 0x03 => 0x0258, 0x04 => 0x0258, 0x05 => 0x0258, 0x06 => 0x0258, 0x07 => 0x0258, 0x08 => 0x0258, 0x09 => 0x0258, 0x0a => 0x0258, 0x0b => 0x0258, 0x0c => 0x0258, 0x0d => 0x0258, 0x0e => 0x0258, 0x0f => 0x0258, 0x10 => 0x0258, 0x11 => 0x0258, 0x12 => 0x0258, 0x13 => 0x0258, 0x14 => 0x0258, 0x15 => 0x0258, 0x16 => 0x0258, 0x17 => 0x0258, 0x18 => 0x0258, 0x19 => 0x0258, 0x1a => 0x0258, 0x1b => 0x0258, 0x1c => 0x0258, 0x1d => 0x0258, 0x1e => 0x0258, 0x1f => 0x0258, 0x20 => 0x0258, 0x21 => 0x0258, 0x22 => 0x0258, 0x23 => 0x0258, 0x24 => 0x0258, 0x25 => 0x0258, 0x26 => 0x0258, 0x27 => 0x0258, 0x28 => 0x0258, 0x29 => 0x0258, 0x2a => 0x0258, 0x2b => 0x0258, 0x2c => 0x0258, 0x2d => 0x0258, 0x2e => 0x0258, 0x2f => 0x0258, 0x30 => 0x0258, 0x31 => 0x0258, 0x32 => 0x0258, 0x33 => 0x0258, 0x34 => 0x0258, 0x35 => 0x0258, 0x36 => 0x0258, 0x37 => 0x0258, 0x38 => 0x0258, 0x39 => 0x0258, 0x3a => 0x0258, 0x3b => 0x0258, 0x3c => 0x0258, 0x3d => 0x0258, 0x3e => 0x0258, 0x3f => 0x0258, 0x40 => 0x0258, 0x41 => 0x0258, 0x42 => 0x0258, 0x43 => 0x0258, 0x44 => 0x0258, 0x45 => 0x0258, 0x46 => 0x0258, 0x47 => 0x0258, 0x48 => 0x0258, 0x49 => 0x0258, 0x4a => 0x0258, 0x4b => 0x0258, 0x4c => 0x0258, 0x4d => 0x0258, 0x4e => 0x0258, 0x4f => 0x0258, 0x50 => 0x0258, 0x51 => 0x0258, 0x52 => 0x0258, 0x53 => 0x0258, 0x54 => 0x0258, 0x55 => 0x0258, 0x56 => 0x0258, 0x57 => 0x0258, 0x58 => 0x0258, 0x59 => 0x0258, 0x5a => 0x0258, 0x5b => 0x0258, 0x5c => 0x0258, 0x5d => 0x0258, 0x5e => 0x0258, 0x5f => 0x0258, 0x60 => 0x0258, 0x61 => 0x0258, 0x62 => 0x0258, 0x63 => 0x0258, 0x64 => 0x0258, 0x65 => 0x0258, 0x66 => 0x0258, 0x67 => 0x0258, 0x68 => 0x0258, 0x69 => 0x0258, 0x6a => 0x0258, 0x6b => 0x0258, 0x6c => 0x0258, 0x6d => 0x0258, 0x6e => 0x0258, 0x6f => 0x0258, 0x70 => 0x0258, 0x71 => 0x0258, 0x72 => 0x0258, 0x73 => 0x0258, 0x74 => 0x0258, 0x75 => 0x0258, 0x76 => 0x0258, 0x77 => 0x0258, 0x78 => 0x0258, 0x79 => 0x0258, 0x7a => 0x0258, 0x7b => 0x0258, 0x7c => 0x0258, 0x7d => 0x0258, 0x7e => 0x0258, 0x7f => 0x0258, 0x80 => 0x0258, 0x81 => 0x0258, 0x82 => 0x0258, 0x83 => 0x0258, 0x84 => 0x0258, 0x85 => 0x0258, 0x86 => 0x0258, 0x87 => 0x0258, 0x88 => 0x0258, 0x89 => 0x0258, 0x8a => 0x0258, 0x8b => 0x0258, 0x8c => 0x0258, 0x8d => 0x0258, 0x8e => 0x0258, 0x8f => 0x0258, 0x90 => 0x0258, 0x91 => 0x0258, 0x92 => 0x0258, 0x93 => 0x0258, 0x94 => 0x0258, 0x95 => 0x0258, 0x96 => 0x0258, 0x97 => 0x0258, 0x98 => 0x0258, 0x99 => 0x0258, 0x9a => 0x0258, 0x9b => 0x0258, 0x9c => 0x0258, 0x9d => 0x0258, 0x9e => 0x0258, 0x9f => 0x0258, 0xa0 => 0x0258, 0xa1 => 0x0258, 0xa2 => 0x0258, 0xa3 => 0x0258, 0xa4 => 0x0258, 0xa5 => 0x0258, 0xa6 => 0x0258, 0xa7 => 0x0258, 0xa8 => 0x0258, 0xa9 => 0x0258, 0xaa => 0x0258, 0xab => 0x0258, 0xac => 0x0258, 0xad => 0x0258, 0xae => 0x0258, 0xaf => 0x0258, 0xb0 => 0x0258, 0xb1 => 0x0258, 0xb2 => 0x0258, 0xb3 => 0x0258, 0xb4 => 0x0258, 0xb5 => 0x0258, 0xb6 => 0x0258, 0xb7 => 0x0258, 0xb8 => 0x0258, 0xb9 => 0x0258, 0xba => 0x0258, 0xbb => 0x0258, 0xbc => 0x0258, 0xbd => 0x0258, 0xbe => 0x0258, 0xbf => 0x0258, 0xc0 => 0x0258, 0xc1 => 0x0258, 0xc2 => 0x0258, 0xc3 => 0x0258, 0xc4 => 0x0258, 0xc5 => 0x0258, 0xc6 => 0x0258, 0xc7 => 0x0258, 0xc8 => 0x0258, 0xc9 => 0x0258, 0xca => 0x0258, 0xcb => 0x0258, 0xcc => 0x0258, 0xcd => 0x0258, 0xce => 0x0258, 0xcf => 0x0258, 0xd0 => 0x0258, 0xd1 => 0x0258, 0xd2 => 0x0258, 0xd3 => 0x0258, 0xd4 => 0x0258, 0xd5 => 0x0258, 0xd6 => 0x0258, 0xd7 => 0x0258, 0xd8 => 0x0258, 0xd9 => 0x0258, 0xda => 0x0258, 0xdb => 0x0258, 0xdc => 0x0258, 0xdd => 0x0258, 0xde => 0x0258, 0xdf => 0x0258, 0xe0 => 0x0258, 0xe1 => 0x0258, 0xe2 => 0x0258, 0xe3 => 0x0258, 0xe4 => 0x0258, 0xe5 => 0x0258, 0xe6 => 0x0258, 0xe7 => 0x0258, 0xe8 => 0x0258, 0xe9 => 0x0258, 0xea => 0x0258, 0xeb => 0x0258, 0xec => 0x0258, 0xed => 0x0258, 0xee => 0x0258, 0xef => 0x0258, 0xf0 => 0x0258, 0xf1 => 0x0258, 0xf2 => 0x0258, 0xf3 => 0x0258, 0xf4 => 0x0258, 0xf5 => 0x0258, 0xf6 => 0x0258, 0xf7 => 0x0258, 0xf8 => 0x0258, 0xf9 => 0x0258, 0xfa => 0x0258, 0xfb => 0x0258, 0xfc => 0x0258, 0xfd => 0x0258, 0xfe => 0x0258, 0xff => 0x0258, 0x0100 => 0x0258, 0x0101 => 0x0258, 0x0102 => 0x0258, 0x0103 => 0x0258, 0x0104 => 0x0258, 0x0105 => 0x0258, 0x0106 => 0x0258, 0x0107 => 0x0258, 0x0108 => 0x0258, 0x0109 => 0x0258, 0x010a => 0x0258, 0x010b => 0x0258, 0x010c => 0x0258, 0x010d => 0x0258, 0x010e => 0x0258, 0x010f => 0x0258, 0x0110 => 0x0258, 0x0111 => 0x0258, 0x0112 => 0x0258, 0x0113 => 0x0258, 0x0114 => 0x0258, 0x0115 => 0x0258, 0x0116 => 0x0258, 0x0117 => 0x0258, 0x0118 => 0x0258, 0x0119 => 0x0258, 0x011a => 0x0258, 0x011b => 0x0258, 0x011c => 0x0258, 0x011d => 0x0258, 0x011e => 0x0258, 0x011f => 0x0258, 0x0120 => 0x0258, 0x0121 => 0x0258, 0x0122 => 0x0258, 0x0123 => 0x0258, 0x0124 => 0x0258, 0x0125 => 0x0258, 0x0126 => 0x0258, 0x0127 => 0x0258, 0x0128 => 0x0258, 0x0129 => 0x0258, 0x012a => 0x0258, 0x012b => 0x0258, 0x012c => 0x0258, 0x012d => 0x0258, 0x012e => 0x0258, 0x012f => 0x0258, 0x0130 => 0x0258, 0x0131 => 0x0258, 0x0132 => 0x0258, 0x0133 => 0x0258, 0x0134 => 0x0258, 0x0135 => 0x0258, 0x0136 => 0x0258, 0x0137 => 0x0258, 0x0138 => 0x0258, 0x0139 => 0x0258, 0x013a => 0x0258, 0x013b => 0x0258, ); $cmapData = array( 0x20 => 0x01, 0x21 => 0x02, 0x22 => 0x03, 0x23 => 0x04, 0x24 => 0x05, 0x25 => 0x06, 0x26 => 0x07, 0x2019 => 0x08, 0x28 => 0x09, 0x29 => 0x0a, 0x2a => 0x0b, 0x2b => 0x0c, 0x2c => 0x0d, 0x2d => 0x0e, 0x2e => 0x0f, 0x2f => 0x10, 0x30 => 0x11, 0x31 => 0x12, 0x32 => 0x13, 0x33 => 0x14, 0x34 => 0x15, 0x35 => 0x16, 0x36 => 0x17, 0x37 => 0x18, 0x38 => 0x19, 0x39 => 0x1a, 0x3a => 0x1b, 0x3b => 0x1c, 0x3c => 0x1d, 0x3d => 0x1e, 0x3e => 0x1f, 0x3f => 0x20, 0x40 => 0x21, 0x41 => 0x22, 0x42 => 0x23, 0x43 => 0x24, 0x44 => 0x25, 0x45 => 0x26, 0x46 => 0x27, 0x47 => 0x28, 0x48 => 0x29, 0x49 => 0x2a, 0x4a => 0x2b, 0x4b => 0x2c, 0x4c => 0x2d, 0x4d => 0x2e, 0x4e => 0x2f, 0x4f => 0x30, 0x50 => 0x31, 0x51 => 0x32, 0x52 => 0x33, 0x53 => 0x34, 0x54 => 0x35, 0x55 => 0x36, 0x56 => 0x37, 0x57 => 0x38, 0x58 => 0x39, 0x59 => 0x3a, 0x5a => 0x3b, 0x5b => 0x3c, 0x5c => 0x3d, 0x5d => 0x3e, 0x5e => 0x3f, 0x5f => 0x40, 0x2018 => 0x41, 0x61 => 0x42, 0x62 => 0x43, 0x63 => 0x44, 0x64 => 0x45, 0x65 => 0x46, 0x66 => 0x47, 0x67 => 0x48, 0x68 => 0x49, 0x69 => 0x4a, 0x6a => 0x4b, 0x6b => 0x4c, 0x6c => 0x4d, 0x6d => 0x4e, 0x6e => 0x4f, 0x6f => 0x50, 0x70 => 0x51, 0x71 => 0x52, 0x72 => 0x53, 0x73 => 0x54, 0x74 => 0x55, 0x75 => 0x56, 0x76 => 0x57, 0x77 => 0x58, 0x78 => 0x59, 0x79 => 0x5a, 0x7a => 0x5b, 0x7b => 0x5c, 0x7c => 0x5d, 0x7d => 0x5e, 0x7e => 0x5f, 0xa1 => 0x60, 0xa2 => 0x61, 0xa3 => 0x62, 0x2044 => 0x63, 0xa5 => 0x64, 0x0192 => 0x65, 0xa7 => 0x66, 0xa4 => 0x67, 0x27 => 0x68, 0x201c => 0x69, 0xab => 0x6a, 0x2039 => 0x6b, 0x203a => 0x6c, 0xfb01 => 0x6d, 0xfb02 => 0x6e, 0x2013 => 0x6f, 0x2020 => 0x70, 0x2021 => 0x71, 0xb7 => 0x72, 0xb6 => 0x73, 0x2022 => 0x74, 0x201a => 0x75, 0x201e => 0x76, 0x201d => 0x77, 0xbb => 0x78, 0x2026 => 0x79, 0x2030 => 0x7a, 0xbf => 0x7b, 0x60 => 0x7c, 0xb4 => 0x7d, 0x02c6 => 0x7e, 0x02dc => 0x7f, 0xaf => 0x80, 0x02d8 => 0x81, 0x02d9 => 0x82, 0xa8 => 0x83, 0x02da => 0x84, 0xb8 => 0x85, 0x02dd => 0x86, 0x02db => 0x87, 0x02c7 => 0x88, 0x2014 => 0x89, 0xc6 => 0x8a, 0xaa => 0x8b, 0x0141 => 0x8c, 0xd8 => 0x8d, 0x0152 => 0x8e, 0xba => 0x8f, 0xe6 => 0x90, 0x0131 => 0x91, 0x0142 => 0x92, 0xf8 => 0x93, 0x0153 => 0x94, 0xdf => 0x95, 0xcf => 0x96, 0xe9 => 0x97, 0x0103 => 0x98, 0x0171 => 0x99, 0x011b => 0x9a, 0x0178 => 0x9b, 0xf7 => 0x9c, 0xdd => 0x9d, 0xc2 => 0x9e, 0xe1 => 0x9f, 0xdb => 0xa0, 0xfd => 0xa1, 0x0219 => 0xa2, 0xea => 0xa3, 0x016e => 0xa4, 0xdc => 0xa5, 0x0105 => 0xa6, 0xda => 0xa7, 0x0173 => 0xa8, 0xcb => 0xa9, 0x0110 => 0xaa, 0xf6c3 => 0xab, 0xa9 => 0xac, 0x0112 => 0xad, 0x010d => 0xae, 0xe5 => 0xaf, 0x0145 => 0xb0, 0x013a => 0xb1, 0xe0 => 0xb2, 0x0162 => 0xb3, 0x0106 => 0xb4, 0xe3 => 0xb5, 0x0116 => 0xb6, 0x0161 => 0xb7, 0x015f => 0xb8, 0xed => 0xb9, 0x25ca => 0xba, 0x0158 => 0xbb, 0x0122 => 0xbc, 0xfb => 0xbd, 0xe2 => 0xbe, 0x0100 => 0xbf, 0x0159 => 0xc0, 0xe7 => 0xc1, 0x017b => 0xc2, 0xde => 0xc3, 0x014c => 0xc4, 0x0154 => 0xc5, 0x015a => 0xc6, 0x010f => 0xc7, 0x016a => 0xc8, 0x016f => 0xc9, 0xb3 => 0xca, 0xd2 => 0xcb, 0xc0 => 0xcc, 0x0102 => 0xcd, 0xd7 => 0xce, 0xfa => 0xcf, 0x0164 => 0xd0, 0x2202 => 0xd1, 0xff => 0xd2, 0x0143 => 0xd3, 0xee => 0xd4, 0xca => 0xd5, 0xe4 => 0xd6, 0xeb => 0xd7, 0x0107 => 0xd8, 0x0144 => 0xd9, 0x016b => 0xda, 0x0147 => 0xdb, 0xcd => 0xdc, 0xb1 => 0xdd, 0xa6 => 0xde, 0xae => 0xdf, 0x011e => 0xe0, 0x0130 => 0xe1, 0x2211 => 0xe2, 0xc8 => 0xe3, 0x0155 => 0xe4, 0x014d => 0xe5, 0x0179 => 0xe6, 0x017d => 0xe7, 0x2265 => 0xe8, 0xd0 => 0xe9, 0xc7 => 0xea, 0x013c => 0xeb, 0x0165 => 0xec, 0x0119 => 0xed, 0x0172 => 0xee, 0xc1 => 0xef, 0xc4 => 0xf0, 0xe8 => 0xf1, 0x017a => 0xf2, 0x012f => 0xf3, 0xd3 => 0xf4, 0xf3 => 0xf5, 0x0101 => 0xf6, 0x015b => 0xf7, 0xef => 0xf8, 0xd4 => 0xf9, 0xd9 => 0xfa, 0x2206 => 0xfb, 0xfe => 0xfc, 0xb2 => 0xfd, 0xd6 => 0xfe, 0xb5 => 0xff, 0xec => 0x0100, 0x0151 => 0x0101, 0x0118 => 0x0102, 0x0111 => 0x0103, 0xbe => 0x0104, 0x015e => 0x0105, 0x013e => 0x0106, 0x0136 => 0x0107, 0x0139 => 0x0108, 0x2122 => 0x0109, 0x0117 => 0x010a, 0xcc => 0x010b, 0x012a => 0x010c, 0x013d => 0x010d, 0xbd => 0x010e, 0x2264 => 0x010f, 0xf4 => 0x0110, 0xf1 => 0x0111, 0x0170 => 0x0112, 0xc9 => 0x0113, 0x0113 => 0x0114, 0x011f => 0x0115, 0xbc => 0x0116, 0x0160 => 0x0117, 0x0218 => 0x0118, 0x0150 => 0x0119, 0xb0 => 0x011a, 0xf2 => 0x011b, 0x010c => 0x011c, 0xf9 => 0x011d, 0x221a => 0x011e, 0x010e => 0x011f, 0x0157 => 0x0120, 0xd1 => 0x0121, 0xf5 => 0x0122, 0x0156 => 0x0123, 0x013b => 0x0124, 0xc3 => 0x0125, 0x0104 => 0x0126, 0xc5 => 0x0127, 0xd5 => 0x0128, 0x017c => 0x0129, 0x011a => 0x012a, 0x012e => 0x012b, 0x0137 => 0x012c, 0x2212 => 0x012d, 0xce => 0x012e, 0x0148 => 0x012f, 0x0163 => 0x0130, 0xac => 0x0131, 0xf6 => 0x0132, 0xfc => 0x0133, 0x2260 => 0x0134, 0x0123 => 0x0135, 0xf0 => 0x0136, 0x017e => 0x0137, 0x0146 => 0x0138, 0xb9 => 0x0139, 0x012b => 0x013a, 0x20ac => 0x013b); $this->_cmap = Zend_Pdf_Cmap::cmapWithTypeData( Zend_Pdf_Cmap::TYPE_BYTE_ENCODING_STATIC, $cmapData); $this->_resource->BaseFont = new Zend_Pdf_Element_Name('Courier-Bold'); } }

/* @source /library/Zend/Pdf/Resource/Font/Simple/Standard/TimesItalic.php */
class Zend_Pdf_Resource_Font_Simple_Standard_TimesItalic extends Zend_Pdf_Resource_Font_Simple_Standard { public function __construct() { parent::__construct(); $this->_fontNames[Zend_Pdf_Font::NAME_COPYRIGHT]['en'] = "\x00\x43\x00\x6f\x00\x70\x00\x79\x00\x72\x00\x69\x00\x67\x00\x68\x00" . "\x74\x00\x20\x00\x28\x00\x63\x00\x29\x00\x20\x00\x31\x00\x39\x00" . "\x38\x00\x35\x00\x2c\x00\x20\x00\x31\x00\x39\x00\x38\x00\x37\x00" . "\x2c\x00\x20\x00\x31\x00\x39\x00\x38\x00\x39\x00\x2c\x00\x20\x00" . "\x31\x00\x39\x00\x39\x00\x30\x00\x2c\x00\x20\x00\x31\x00\x39\x00" . "\x39\x00\x33\x00\x2c\x00\x20\x00\x31\x00\x39\x00\x39\x00\x37\x00" . "\x20\x00\x41\x00\x64\x00\x6f\x00\x62\x00\x65\x00\x20\x00\x53\x00" . "\x79\x00\x73\x00\x74\x00\x65\x00\x6d\x00\x73\x00\x20\x00\x49\x00" . "\x6e\x00\x63\x00\x6f\x00\x72\x00\x70\x00\x6f\x00\x72\x00\x61\x00" . "\x74\x00\x65\x00\x64\x00\x2e\x00\x20\x00\x20\x00\x41\x00\x6c\x00" . "\x6c\x00\x20\x00\x52\x00\x69\x00\x67\x00\x68\x00\x74\x00\x73\x00" . "\x20\x00\x52\x00\x65\x00\x73\x00\x65\x00\x72\x00\x76\x00\x65\x00" . "\x64\x00\x2e\x00\x54\x00\x69\x00\x6d\x00\x65\x00\x73\x00\x20\x00" . "\x69\x00\x73\x00\x20\x00\x61\x00\x20\x00\x74\x00\x72\x00\x61\x00" . "\x64\x00\x65\x00\x6d\x00\x61\x00\x72\x00\x6b\x00\x20\x00\x6f\x00" . "\x66\x00\x20\x00\x4c\x00\x69\x00\x6e\x00\x6f\x00\x74\x00\x79\x00" . "\x70\x00\x65\x00\x2d\x00\x48\x00\x65\x00\x6c\x00\x6c\x00\x20\x00" . "\x41\x00\x47\x00\x20\x00\x61\x00\x6e\x00\x64\x00\x2f\x00\x6f\x00" . "\x72\x00\x20\x00\x69\x00\x74\x00\x73\x00\x20\x00\x73\x00\x75\x00" . "\x62\x00\x73\x00\x69\x00\x64\x00\x69\x00\x61\x00\x72\x00\x69\x00" . "\x65\x00\x73\x00\x2e"; $this->_fontNames[Zend_Pdf_Font::NAME_FAMILY]['en'] = "\x00\x54\x00\x69\x00\x6d\x00\x65\x00\x73"; $this->_fontNames[Zend_Pdf_Font::NAME_STYLE]['en'] = "\x00\x4d\x00\x65\x00\x64\x00\x69\x00\x75\x00\x6d"; $this->_fontNames[Zend_Pdf_Font::NAME_ID]['en'] = "\x00\x34\x00\x33\x00\x30\x00\x36\x00\x37"; $this->_fontNames[Zend_Pdf_Font::NAME_FULL]['en'] = "\x00\x54\x00\x69\x00\x6d\x00\x65\x00\x73\x00\x2d\x00\x49\x00\x74\x00" . "\x61\x00\x6c\x00\x69\x00\x63\x00\x20\x00\x4d\x00\x65\x00\x64\x00" . "\x69\x00\x75\x00\x6d"; $this->_fontNames[Zend_Pdf_Font::NAME_VERSION]['en'] = "\x00\x30\x00\x30\x00\x32\x00\x2e\x00\x30\x00\x30\x00\x30"; $this->_fontNames[Zend_Pdf_Font::NAME_POSTSCRIPT]['en'] = "\x00\x54\x00\x69\x00\x6d\x00\x65\x00\x73\x00\x2d\x00\x49\x00\x74\x00" . "\x61\x00\x6c\x00\x69\x00\x63"; $this->_isBold = false; $this->_isItalic = true; $this->_isMonospaced = false; $this->_underlinePosition = -100; $this->_underlineThickness = 50; $this->_strikePosition = 225; $this->_strikeThickness = 50; $this->_unitsPerEm = 1000; $this->_ascent = 683; $this->_descent = -217; $this->_lineGap = 300; $this->_glyphWidths = array( 0x00 => 0x01f4, 0x01 => 0xfa, 0x02 => 0x014d, 0x03 => 0x01a4, 0x04 => 0x01f4, 0x05 => 0x01f4, 0x06 => 0x0341, 0x07 => 0x030a, 0x08 => 0x014d, 0x09 => 0x014d, 0x0a => 0x014d, 0x0b => 0x01f4, 0x0c => 0x02a3, 0x0d => 0xfa, 0x0e => 0x014d, 0x0f => 0xfa, 0x10 => 0x0116, 0x11 => 0x01f4, 0x12 => 0x01f4, 0x13 => 0x01f4, 0x14 => 0x01f4, 0x15 => 0x01f4, 0x16 => 0x01f4, 0x17 => 0x01f4, 0x18 => 0x01f4, 0x19 => 0x01f4, 0x1a => 0x01f4, 0x1b => 0x014d, 0x1c => 0x014d, 0x1d => 0x02a3, 0x1e => 0x02a3, 0x1f => 0x02a3, 0x20 => 0x01f4, 0x21 => 0x0398, 0x22 => 0x0263, 0x23 => 0x0263, 0x24 => 0x029b, 0x25 => 0x02d2, 0x26 => 0x0263, 0x27 => 0x0263, 0x28 => 0x02d2, 0x29 => 0x02d2, 0x2a => 0x014d, 0x2b => 0x01bc, 0x2c => 0x029b, 0x2d => 0x022c, 0x2e => 0x0341, 0x2f => 0x029b, 0x30 => 0x02d2, 0x31 => 0x0263, 0x32 => 0x02d2, 0x33 => 0x0263, 0x34 => 0x01f4, 0x35 => 0x022c, 0x36 => 0x02d2, 0x37 => 0x0263, 0x38 => 0x0341, 0x39 => 0x0263, 0x3a => 0x022c, 0x3b => 0x022c, 0x3c => 0x0185, 0x3d => 0x0116, 0x3e => 0x0185, 0x3f => 0x01a6, 0x40 => 0x01f4, 0x41 => 0x014d, 0x42 => 0x01f4, 0x43 => 0x01f4, 0x44 => 0x01bc, 0x45 => 0x01f4, 0x46 => 0x01bc, 0x47 => 0x0116, 0x48 => 0x01f4, 0x49 => 0x01f4, 0x4a => 0x0116, 0x4b => 0x0116, 0x4c => 0x01bc, 0x4d => 0x0116, 0x4e => 0x02d2, 0x4f => 0x01f4, 0x50 => 0x01f4, 0x51 => 0x01f4, 0x52 => 0x01f4, 0x53 => 0x0185, 0x54 => 0x0185, 0x55 => 0x0116, 0x56 => 0x01f4, 0x57 => 0x01bc, 0x58 => 0x029b, 0x59 => 0x01bc, 0x5a => 0x01bc, 0x5b => 0x0185, 0x5c => 0x0190, 0x5d => 0x0113, 0x5e => 0x0190, 0x5f => 0x021d, 0x60 => 0x0185, 0x61 => 0x01f4, 0x62 => 0x01f4, 0x63 => 0xa7, 0x64 => 0x01f4, 0x65 => 0x01f4, 0x66 => 0x01f4, 0x67 => 0x01f4, 0x68 => 0xd6, 0x69 => 0x022c, 0x6a => 0x01f4, 0x6b => 0x014d, 0x6c => 0x014d, 0x6d => 0x01f4, 0x6e => 0x01f4, 0x6f => 0x01f4, 0x70 => 0x01f4, 0x71 => 0x01f4, 0x72 => 0xfa, 0x73 => 0x020b, 0x74 => 0x015e, 0x75 => 0x014d, 0x76 => 0x022c, 0x77 => 0x022c, 0x78 => 0x01f4, 0x79 => 0x0379, 0x7a => 0x03e8, 0x7b => 0x01f4, 0x7c => 0x014d, 0x7d => 0x014d, 0x7e => 0x014d, 0x7f => 0x014d, 0x80 => 0x014d, 0x81 => 0x014d, 0x82 => 0x014d, 0x83 => 0x014d, 0x84 => 0x014d, 0x85 => 0x014d, 0x86 => 0x014d, 0x87 => 0x014d, 0x88 => 0x014d, 0x89 => 0x0379, 0x8a => 0x0379, 0x8b => 0x0114, 0x8c => 0x022c, 0x8d => 0x02d2, 0x8e => 0x03b0, 0x8f => 0x0136, 0x90 => 0x029b, 0x91 => 0x0116, 0x92 => 0x0116, 0x93 => 0x01f4, 0x94 => 0x029b, 0x95 => 0x01f4, 0x96 => 0x014d, 0x97 => 0x01bc, 0x98 => 0x01f4, 0x99 => 0x01f4, 0x9a => 0x01bc, 0x9b => 0x022c, 0x9c => 0x02a3, 0x9d => 0x022c, 0x9e => 0x0263, 0x9f => 0x01f4, 0xa0 => 0x02d2, 0xa1 => 0x01bc, 0xa2 => 0x0185, 0xa3 => 0x01bc, 0xa4 => 0x02d2, 0xa5 => 0x02d2, 0xa6 => 0x01f4, 0xa7 => 0x02d2, 0xa8 => 0x01f4, 0xa9 => 0x0263, 0xaa => 0x02d2, 0xab => 0xfa, 0xac => 0x02f8, 0xad => 0x0263, 0xae => 0x01bc, 0xaf => 0x01f4, 0xb0 => 0x029b, 0xb1 => 0x0116, 0xb2 => 0x01f4, 0xb3 => 0x022c, 0xb4 => 0x029b, 0xb5 => 0x01f4, 0xb6 => 0x0263, 0xb7 => 0x0185, 0xb8 => 0x0185, 0xb9 => 0x0116, 0xba => 0x01d7, 0xbb => 0x0263, 0xbc => 0x02d2, 0xbd => 0x01f4, 0xbe => 0x01f4, 0xbf => 0x0263, 0xc0 => 0x0185, 0xc1 => 0x01bc, 0xc2 => 0x022c, 0xc3 => 0x0263, 0xc4 => 0x02d2, 0xc5 => 0x0263, 0xc6 => 0x01f4, 0xc7 => 0x0220, 0xc8 => 0x02d2, 0xc9 => 0x01f4, 0xca => 0x012c, 0xcb => 0x02d2, 0xcc => 0x0263, 0xcd => 0x0263, 0xce => 0x02a3, 0xcf => 0x01f4, 0xd0 => 0x022c, 0xd1 => 0x01dc, 0xd2 => 0x01bc, 0xd3 => 0x029b, 0xd4 => 0x0116, 0xd5 => 0x0263, 0xd6 => 0x01f4, 0xd7 => 0x01bc, 0xd8 => 0x01bc, 0xd9 => 0x01f4, 0xda => 0x01f4, 0xdb => 0x029b, 0xdc => 0x014d, 0xdd => 0x02a3, 0xde => 0x0113, 0xdf => 0x02f8, 0xe0 => 0x02d2, 0xe1 => 0x014d, 0xe2 => 0x0258, 0xe3 => 0x0263, 0xe4 => 0x0185, 0xe5 => 0x01f4, 0xe6 => 0x022c, 0xe7 => 0x022c, 0xe8 => 0x0225, 0xe9 => 0x02d2, 0xea => 0x029b, 0xeb => 0x0116, 0xec => 0x012c, 0xed => 0x01bc, 0xee => 0x02d2, 0xef => 0x0263, 0xf0 => 0x0263, 0xf1 => 0x01bc, 0xf2 => 0x0185, 0xf3 => 0x0116, 0xf4 => 0x02d2, 0xf5 => 0x01f4, 0xf6 => 0x01f4, 0xf7 => 0x0185, 0xf8 => 0x0116, 0xf9 => 0x02d2, 0xfa => 0x02d2, 0xfb => 0x0264, 0xfc => 0x01f4, 0xfd => 0x012c, 0xfe => 0x02d2, 0xff => 0x01f4, 0x0100 => 0x0116, 0x0101 => 0x01f4, 0x0102 => 0x0263, 0x0103 => 0x01f4, 0x0104 => 0x02ee, 0x0105 => 0x01f4, 0x0106 => 0x012c, 0x0107 => 0x029b, 0x0108 => 0x022c, 0x0109 => 0x03d4, 0x010a => 0x01bc, 0x010b => 0x014d, 0x010c => 0x014d, 0x010d => 0x0263, 0x010e => 0x02ee, 0x010f => 0x0225, 0x0110 => 0x01f4, 0x0111 => 0x01f4, 0x0112 => 0x02d2, 0x0113 => 0x0263, 0x0114 => 0x01bc, 0x0115 => 0x01f4, 0x0116 => 0x02ee, 0x0117 => 0x01f4, 0x0118 => 0x01f4, 0x0119 => 0x02d2, 0x011a => 0x0190, 0x011b => 0x01f4, 0x011c => 0x029b, 0x011d => 0x01f4, 0x011e => 0x01c5, 0x011f => 0x02d2, 0x0120 => 0x0185, 0x0121 => 0x029b, 0x0122 => 0x01f4, 0x0123 => 0x0263, 0x0124 => 0x022c, 0x0125 => 0x0263, 0x0126 => 0x0263, 0x0127 => 0x0263, 0x0128 => 0x02d2, 0x0129 => 0x0185, 0x012a => 0x0263, 0x012b => 0x014d, 0x012c => 0x01bc, 0x012d => 0x02a3, 0x012e => 0x014d, 0x012f => 0x01f4, 0x0130 => 0x0116, 0x0131 => 0x02a3, 0x0132 => 0x01f4, 0x0133 => 0x01f4, 0x0134 => 0x0225, 0x0135 => 0x01f4, 0x0136 => 0x01f4, 0x0137 => 0x0185, 0x0138 => 0x01f4, 0x0139 => 0x012c, 0x013a => 0x0116, 0x013b => 0x01f4, ); $cmapData = array( 0x20 => 0x01, 0x21 => 0x02, 0x22 => 0x03, 0x23 => 0x04, 0x24 => 0x05, 0x25 => 0x06, 0x26 => 0x07, 0x2019 => 0x08, 0x28 => 0x09, 0x29 => 0x0a, 0x2a => 0x0b, 0x2b => 0x0c, 0x2c => 0x0d, 0x2d => 0x0e, 0x2e => 0x0f, 0x2f => 0x10, 0x30 => 0x11, 0x31 => 0x12, 0x32 => 0x13, 0x33 => 0x14, 0x34 => 0x15, 0x35 => 0x16, 0x36 => 0x17, 0x37 => 0x18, 0x38 => 0x19, 0x39 => 0x1a, 0x3a => 0x1b, 0x3b => 0x1c, 0x3c => 0x1d, 0x3d => 0x1e, 0x3e => 0x1f, 0x3f => 0x20, 0x40 => 0x21, 0x41 => 0x22, 0x42 => 0x23, 0x43 => 0x24, 0x44 => 0x25, 0x45 => 0x26, 0x46 => 0x27, 0x47 => 0x28, 0x48 => 0x29, 0x49 => 0x2a, 0x4a => 0x2b, 0x4b => 0x2c, 0x4c => 0x2d, 0x4d => 0x2e, 0x4e => 0x2f, 0x4f => 0x30, 0x50 => 0x31, 0x51 => 0x32, 0x52 => 0x33, 0x53 => 0x34, 0x54 => 0x35, 0x55 => 0x36, 0x56 => 0x37, 0x57 => 0x38, 0x58 => 0x39, 0x59 => 0x3a, 0x5a => 0x3b, 0x5b => 0x3c, 0x5c => 0x3d, 0x5d => 0x3e, 0x5e => 0x3f, 0x5f => 0x40, 0x2018 => 0x41, 0x61 => 0x42, 0x62 => 0x43, 0x63 => 0x44, 0x64 => 0x45, 0x65 => 0x46, 0x66 => 0x47, 0x67 => 0x48, 0x68 => 0x49, 0x69 => 0x4a, 0x6a => 0x4b, 0x6b => 0x4c, 0x6c => 0x4d, 0x6d => 0x4e, 0x6e => 0x4f, 0x6f => 0x50, 0x70 => 0x51, 0x71 => 0x52, 0x72 => 0x53, 0x73 => 0x54, 0x74 => 0x55, 0x75 => 0x56, 0x76 => 0x57, 0x77 => 0x58, 0x78 => 0x59, 0x79 => 0x5a, 0x7a => 0x5b, 0x7b => 0x5c, 0x7c => 0x5d, 0x7d => 0x5e, 0x7e => 0x5f, 0xa1 => 0x60, 0xa2 => 0x61, 0xa3 => 0x62, 0x2044 => 0x63, 0xa5 => 0x64, 0x0192 => 0x65, 0xa7 => 0x66, 0xa4 => 0x67, 0x27 => 0x68, 0x201c => 0x69, 0xab => 0x6a, 0x2039 => 0x6b, 0x203a => 0x6c, 0xfb01 => 0x6d, 0xfb02 => 0x6e, 0x2013 => 0x6f, 0x2020 => 0x70, 0x2021 => 0x71, 0xb7 => 0x72, 0xb6 => 0x73, 0x2022 => 0x74, 0x201a => 0x75, 0x201e => 0x76, 0x201d => 0x77, 0xbb => 0x78, 0x2026 => 0x79, 0x2030 => 0x7a, 0xbf => 0x7b, 0x60 => 0x7c, 0xb4 => 0x7d, 0x02c6 => 0x7e, 0x02dc => 0x7f, 0xaf => 0x80, 0x02d8 => 0x81, 0x02d9 => 0x82, 0xa8 => 0x83, 0x02da => 0x84, 0xb8 => 0x85, 0x02dd => 0x86, 0x02db => 0x87, 0x02c7 => 0x88, 0x2014 => 0x89, 0xc6 => 0x8a, 0xaa => 0x8b, 0x0141 => 0x8c, 0xd8 => 0x8d, 0x0152 => 0x8e, 0xba => 0x8f, 0xe6 => 0x90, 0x0131 => 0x91, 0x0142 => 0x92, 0xf8 => 0x93, 0x0153 => 0x94, 0xdf => 0x95, 0xcf => 0x96, 0xe9 => 0x97, 0x0103 => 0x98, 0x0171 => 0x99, 0x011b => 0x9a, 0x0178 => 0x9b, 0xf7 => 0x9c, 0xdd => 0x9d, 0xc2 => 0x9e, 0xe1 => 0x9f, 0xdb => 0xa0, 0xfd => 0xa1, 0x0219 => 0xa2, 0xea => 0xa3, 0x016e => 0xa4, 0xdc => 0xa5, 0x0105 => 0xa6, 0xda => 0xa7, 0x0173 => 0xa8, 0xcb => 0xa9, 0x0110 => 0xaa, 0xf6c3 => 0xab, 0xa9 => 0xac, 0x0112 => 0xad, 0x010d => 0xae, 0xe5 => 0xaf, 0x0145 => 0xb0, 0x013a => 0xb1, 0xe0 => 0xb2, 0x0162 => 0xb3, 0x0106 => 0xb4, 0xe3 => 0xb5, 0x0116 => 0xb6, 0x0161 => 0xb7, 0x015f => 0xb8, 0xed => 0xb9, 0x25ca => 0xba, 0x0158 => 0xbb, 0x0122 => 0xbc, 0xfb => 0xbd, 0xe2 => 0xbe, 0x0100 => 0xbf, 0x0159 => 0xc0, 0xe7 => 0xc1, 0x017b => 0xc2, 0xde => 0xc3, 0x014c => 0xc4, 0x0154 => 0xc5, 0x015a => 0xc6, 0x010f => 0xc7, 0x016a => 0xc8, 0x016f => 0xc9, 0xb3 => 0xca, 0xd2 => 0xcb, 0xc0 => 0xcc, 0x0102 => 0xcd, 0xd7 => 0xce, 0xfa => 0xcf, 0x0164 => 0xd0, 0x2202 => 0xd1, 0xff => 0xd2, 0x0143 => 0xd3, 0xee => 0xd4, 0xca => 0xd5, 0xe4 => 0xd6, 0xeb => 0xd7, 0x0107 => 0xd8, 0x0144 => 0xd9, 0x016b => 0xda, 0x0147 => 0xdb, 0xcd => 0xdc, 0xb1 => 0xdd, 0xa6 => 0xde, 0xae => 0xdf, 0x011e => 0xe0, 0x0130 => 0xe1, 0x2211 => 0xe2, 0xc8 => 0xe3, 0x0155 => 0xe4, 0x014d => 0xe5, 0x0179 => 0xe6, 0x017d => 0xe7, 0x2265 => 0xe8, 0xd0 => 0xe9, 0xc7 => 0xea, 0x013c => 0xeb, 0x0165 => 0xec, 0x0119 => 0xed, 0x0172 => 0xee, 0xc1 => 0xef, 0xc4 => 0xf0, 0xe8 => 0xf1, 0x017a => 0xf2, 0x012f => 0xf3, 0xd3 => 0xf4, 0xf3 => 0xf5, 0x0101 => 0xf6, 0x015b => 0xf7, 0xef => 0xf8, 0xd4 => 0xf9, 0xd9 => 0xfa, 0x2206 => 0xfb, 0xfe => 0xfc, 0xb2 => 0xfd, 0xd6 => 0xfe, 0xb5 => 0xff, 0xec => 0x0100, 0x0151 => 0x0101, 0x0118 => 0x0102, 0x0111 => 0x0103, 0xbe => 0x0104, 0x015e => 0x0105, 0x013e => 0x0106, 0x0136 => 0x0107, 0x0139 => 0x0108, 0x2122 => 0x0109, 0x0117 => 0x010a, 0xcc => 0x010b, 0x012a => 0x010c, 0x013d => 0x010d, 0xbd => 0x010e, 0x2264 => 0x010f, 0xf4 => 0x0110, 0xf1 => 0x0111, 0x0170 => 0x0112, 0xc9 => 0x0113, 0x0113 => 0x0114, 0x011f => 0x0115, 0xbc => 0x0116, 0x0160 => 0x0117, 0x0218 => 0x0118, 0x0150 => 0x0119, 0xb0 => 0x011a, 0xf2 => 0x011b, 0x010c => 0x011c, 0xf9 => 0x011d, 0x221a => 0x011e, 0x010e => 0x011f, 0x0157 => 0x0120, 0xd1 => 0x0121, 0xf5 => 0x0122, 0x0156 => 0x0123, 0x013b => 0x0124, 0xc3 => 0x0125, 0x0104 => 0x0126, 0xc5 => 0x0127, 0xd5 => 0x0128, 0x017c => 0x0129, 0x011a => 0x012a, 0x012e => 0x012b, 0x0137 => 0x012c, 0x2212 => 0x012d, 0xce => 0x012e, 0x0148 => 0x012f, 0x0163 => 0x0130, 0xac => 0x0131, 0xf6 => 0x0132, 0xfc => 0x0133, 0x2260 => 0x0134, 0x0123 => 0x0135, 0xf0 => 0x0136, 0x017e => 0x0137, 0x0146 => 0x0138, 0xb9 => 0x0139, 0x012b => 0x013a, 0x20ac => 0x013b); $this->_cmap = Zend_Pdf_Cmap::cmapWithTypeData( Zend_Pdf_Cmap::TYPE_BYTE_ENCODING_STATIC, $cmapData); $this->_resource->BaseFont = new Zend_Pdf_Element_Name('Times-Italic'); } }

/* @source /library/Zend/Pdf/Resource/Font/Simple/Standard/TimesBoldItalic.php */
class Zend_Pdf_Resource_Font_Simple_Standard_TimesBoldItalic extends Zend_Pdf_Resource_Font_Simple_Standard { public function __construct() { parent::__construct(); $this->_fontNames[Zend_Pdf_Font::NAME_COPYRIGHT]['en'] = "\x00\x43\x00\x6f\x00\x70\x00\x79\x00\x72\x00\x69\x00\x67\x00\x68\x00" . "\x74\x00\x20\x00\x28\x00\x63\x00\x29\x00\x20\x00\x31\x00\x39\x00" . "\x38\x00\x35\x00\x2c\x00\x20\x00\x31\x00\x39\x00\x38\x00\x37\x00" . "\x2c\x00\x20\x00\x31\x00\x39\x00\x38\x00\x39\x00\x2c\x00\x20\x00" . "\x31\x00\x39\x00\x39\x00\x30\x00\x2c\x00\x20\x00\x31\x00\x39\x00" . "\x39\x00\x33\x00\x2c\x00\x20\x00\x31\x00\x39\x00\x39\x00\x37\x00" . "\x20\x00\x41\x00\x64\x00\x6f\x00\x62\x00\x65\x00\x20\x00\x53\x00" . "\x79\x00\x73\x00\x74\x00\x65\x00\x6d\x00\x73\x00\x20\x00\x49\x00" . "\x6e\x00\x63\x00\x6f\x00\x72\x00\x70\x00\x6f\x00\x72\x00\x61\x00" . "\x74\x00\x65\x00\x64\x00\x2e\x00\x20\x00\x20\x00\x41\x00\x6c\x00" . "\x6c\x00\x20\x00\x52\x00\x69\x00\x67\x00\x68\x00\x74\x00\x73\x00" . "\x20\x00\x52\x00\x65\x00\x73\x00\x65\x00\x72\x00\x76\x00\x65\x00" . "\x64\x00\x2e\x00\x54\x00\x69\x00\x6d\x00\x65\x00\x73\x00\x20\x00" . "\x69\x00\x73\x00\x20\x00\x61\x00\x20\x00\x74\x00\x72\x00\x61\x00" . "\x64\x00\x65\x00\x6d\x00\x61\x00\x72\x00\x6b\x00\x20\x00\x6f\x00" . "\x66\x00\x20\x00\x4c\x00\x69\x00\x6e\x00\x6f\x00\x74\x00\x79\x00" . "\x70\x00\x65\x00\x2d\x00\x48\x00\x65\x00\x6c\x00\x6c\x00\x20\x00" . "\x41\x00\x47\x00\x20\x00\x61\x00\x6e\x00\x64\x00\x2f\x00\x6f\x00" . "\x72\x00\x20\x00\x69\x00\x74\x00\x73\x00\x20\x00\x73\x00\x75\x00" . "\x62\x00\x73\x00\x69\x00\x64\x00\x69\x00\x61\x00\x72\x00\x69\x00" . "\x65\x00\x73\x00\x2e"; $this->_fontNames[Zend_Pdf_Font::NAME_FAMILY]['en'] = "\x00\x54\x00\x69\x00\x6d\x00\x65\x00\x73"; $this->_fontNames[Zend_Pdf_Font::NAME_STYLE]['en'] = "\x00\x42\x00\x6f\x00\x6c\x00\x64"; $this->_fontNames[Zend_Pdf_Font::NAME_ID]['en'] = "\x00\x34\x00\x33\x00\x30\x00\x36\x00\x36"; $this->_fontNames[Zend_Pdf_Font::NAME_FULL]['en'] = "\x00\x54\x00\x69\x00\x6d\x00\x65\x00\x73\x00\x2d\x00\x42\x00\x6f\x00" . "\x6c\x00\x64\x00\x49\x00\x74\x00\x61\x00\x6c\x00\x69\x00\x63\x00" . "\x20\x00\x42\x00\x6f\x00\x6c\x00\x64"; $this->_fontNames[Zend_Pdf_Font::NAME_VERSION]['en'] = "\x00\x30\x00\x30\x00\x32\x00\x2e\x00\x30\x00\x30\x00\x30"; $this->_fontNames[Zend_Pdf_Font::NAME_POSTSCRIPT]['en'] = "\x00\x54\x00\x69\x00\x6d\x00\x65\x00\x73\x00\x2d\x00\x42\x00\x6f\x00" . "\x6c\x00\x64\x00\x49\x00\x74\x00\x61\x00\x6c\x00\x69\x00\x63"; $this->_isBold = true; $this->_isItalic = true; $this->_isMonospaced = false; $this->_underlinePosition = -100; $this->_underlineThickness = 50; $this->_strikePosition = 225; $this->_strikeThickness = 50; $this->_unitsPerEm = 1000; $this->_ascent = 683; $this->_descent = -217; $this->_lineGap = 300; $this->_glyphWidths = array( 0x00 => 0x01f4, 0x01 => 0xfa, 0x02 => 0x0185, 0x03 => 0x022b, 0x04 => 0x01f4, 0x05 => 0x01f4, 0x06 => 0x0341, 0x07 => 0x030a, 0x08 => 0x014d, 0x09 => 0x014d, 0x0a => 0x014d, 0x0b => 0x01f4, 0x0c => 0x023a, 0x0d => 0xfa, 0x0e => 0x014d, 0x0f => 0xfa, 0x10 => 0x0116, 0x11 => 0x01f4, 0x12 => 0x01f4, 0x13 => 0x01f4, 0x14 => 0x01f4, 0x15 => 0x01f4, 0x16 => 0x01f4, 0x17 => 0x01f4, 0x18 => 0x01f4, 0x19 => 0x01f4, 0x1a => 0x01f4, 0x1b => 0x014d, 0x1c => 0x014d, 0x1d => 0x023a, 0x1e => 0x023a, 0x1f => 0x023a, 0x20 => 0x01f4, 0x21 => 0x0340, 0x22 => 0x029b, 0x23 => 0x029b, 0x24 => 0x029b, 0x25 => 0x02d2, 0x26 => 0x029b, 0x27 => 0x029b, 0x28 => 0x02d2, 0x29 => 0x030a, 0x2a => 0x0185, 0x2b => 0x01f4, 0x2c => 0x029b, 0x2d => 0x0263, 0x2e => 0x0379, 0x2f => 0x02d2, 0x30 => 0x02d2, 0x31 => 0x0263, 0x32 => 0x02d2, 0x33 => 0x029b, 0x34 => 0x022c, 0x35 => 0x0263, 0x36 => 0x02d2, 0x37 => 0x029b, 0x38 => 0x0379, 0x39 => 0x029b, 0x3a => 0x0263, 0x3b => 0x0263, 0x3c => 0x014d, 0x3d => 0x0116, 0x3e => 0x014d, 0x3f => 0x023a, 0x40 => 0x01f4, 0x41 => 0x014d, 0x42 => 0x01f4, 0x43 => 0x01f4, 0x44 => 0x01bc, 0x45 => 0x01f4, 0x46 => 0x01bc, 0x47 => 0x014d, 0x48 => 0x01f4, 0x49 => 0x022c, 0x4a => 0x0116, 0x4b => 0x0116, 0x4c => 0x01f4, 0x4d => 0x0116, 0x4e => 0x030a, 0x4f => 0x022c, 0x50 => 0x01f4, 0x51 => 0x01f4, 0x52 => 0x01f4, 0x53 => 0x0185, 0x54 => 0x0185, 0x55 => 0x0116, 0x56 => 0x022c, 0x57 => 0x01bc, 0x58 => 0x029b, 0x59 => 0x01f4, 0x5a => 0x01bc, 0x5b => 0x0185, 0x5c => 0x015c, 0x5d => 0xdc, 0x5e => 0x015c, 0x5f => 0x023a, 0x60 => 0x0185, 0x61 => 0x01f4, 0x62 => 0x01f4, 0x63 => 0xa7, 0x64 => 0x01f4, 0x65 => 0x01f4, 0x66 => 0x01f4, 0x67 => 0x01f4, 0x68 => 0x0116, 0x69 => 0x01f4, 0x6a => 0x01f4, 0x6b => 0x014d, 0x6c => 0x014d, 0x6d => 0x022c, 0x6e => 0x022c, 0x6f => 0x01f4, 0x70 => 0x01f4, 0x71 => 0x01f4, 0x72 => 0xfa, 0x73 => 0x01f4, 0x74 => 0x015e, 0x75 => 0x014d, 0x76 => 0x01f4, 0x77 => 0x01f4, 0x78 => 0x01f4, 0x79 => 0x03e8, 0x7a => 0x03e8, 0x7b => 0x01f4, 0x7c => 0x014d, 0x7d => 0x014d, 0x7e => 0x014d, 0x7f => 0x014d, 0x80 => 0x014d, 0x81 => 0x014d, 0x82 => 0x014d, 0x83 => 0x014d, 0x84 => 0x014d, 0x85 => 0x014d, 0x86 => 0x014d, 0x87 => 0x014d, 0x88 => 0x014d, 0x89 => 0x03e8, 0x8a => 0x03b0, 0x8b => 0x010a, 0x8c => 0x0263, 0x8d => 0x02d2, 0x8e => 0x03b0, 0x8f => 0x012c, 0x90 => 0x02d2, 0x91 => 0x0116, 0x92 => 0x0116, 0x93 => 0x01f4, 0x94 => 0x02d2, 0x95 => 0x01f4, 0x96 => 0x0185, 0x97 => 0x01bc, 0x98 => 0x01f4, 0x99 => 0x022c, 0x9a => 0x01bc, 0x9b => 0x0263, 0x9c => 0x023a, 0x9d => 0x0263, 0x9e => 0x029b, 0x9f => 0x01f4, 0xa0 => 0x02d2, 0xa1 => 0x01bc, 0xa2 => 0x0185, 0xa3 => 0x01bc, 0xa4 => 0x02d2, 0xa5 => 0x02d2, 0xa6 => 0x01f4, 0xa7 => 0x02d2, 0xa8 => 0x022c, 0xa9 => 0x029b, 0xaa => 0x02d2, 0xab => 0xfa, 0xac => 0x02eb, 0xad => 0x029b, 0xae => 0x01bc, 0xaf => 0x01f4, 0xb0 => 0x02d2, 0xb1 => 0x0116, 0xb2 => 0x01f4, 0xb3 => 0x0263, 0xb4 => 0x029b, 0xb5 => 0x01f4, 0xb6 => 0x029b, 0xb7 => 0x0185, 0xb8 => 0x0185, 0xb9 => 0x0116, 0xba => 0x01ee, 0xbb => 0x029b, 0xbc => 0x02d2, 0xbd => 0x022c, 0xbe => 0x01f4, 0xbf => 0x029b, 0xc0 => 0x0185, 0xc1 => 0x01bc, 0xc2 => 0x0263, 0xc3 => 0x0263, 0xc4 => 0x02d2, 0xc5 => 0x029b, 0xc6 => 0x022c, 0xc7 => 0x0260, 0xc8 => 0x02d2, 0xc9 => 0x022c, 0xca => 0x012c, 0xcb => 0x02d2, 0xcc => 0x029b, 0xcd => 0x029b, 0xce => 0x023a, 0xcf => 0x022c, 0xd0 => 0x0263, 0xd1 => 0x01ee, 0xd2 => 0x01bc, 0xd3 => 0x02d2, 0xd4 => 0x0116, 0xd5 => 0x029b, 0xd6 => 0x01f4, 0xd7 => 0x01bc, 0xd8 => 0x01bc, 0xd9 => 0x022c, 0xda => 0x022c, 0xdb => 0x02d2, 0xdc => 0x0185, 0xdd => 0x023a, 0xde => 0xdc, 0xdf => 0x02eb, 0xe0 => 0x02d2, 0xe1 => 0x0185, 0xe2 => 0x0258, 0xe3 => 0x029b, 0xe4 => 0x0185, 0xe5 => 0x01f4, 0xe6 => 0x0263, 0xe7 => 0x0263, 0xe8 => 0x0225, 0xe9 => 0x02d2, 0xea => 0x029b, 0xeb => 0x0116, 0xec => 0x016e, 0xed => 0x01bc, 0xee => 0x02d2, 0xef => 0x029b, 0xf0 => 0x029b, 0xf1 => 0x01bc, 0xf2 => 0x0185, 0xf3 => 0x0116, 0xf4 => 0x02d2, 0xf5 => 0x01f4, 0xf6 => 0x01f4, 0xf7 => 0x0185, 0xf8 => 0x0116, 0xf9 => 0x02d2, 0xfa => 0x02d2, 0xfb => 0x0264, 0xfc => 0x01f4, 0xfd => 0x012c, 0xfe => 0x02d2, 0xff => 0x0240, 0x0100 => 0x0116, 0x0101 => 0x01f4, 0x0102 => 0x029b, 0x0103 => 0x01f4, 0x0104 => 0x02ee, 0x0105 => 0x022c, 0x0106 => 0x017e, 0x0107 => 0x029b, 0x0108 => 0x0263, 0x0109 => 0x03e8, 0x010a => 0x01bc, 0x010b => 0x0185, 0x010c => 0x0185, 0x010d => 0x0263, 0x010e => 0x02ee, 0x010f => 0x0225, 0x0110 => 0x01f4, 0x0111 => 0x022c, 0x0112 => 0x02d2, 0x0113 => 0x029b, 0x0114 => 0x01bc, 0x0115 => 0x01f4, 0x0116 => 0x02ee, 0x0117 => 0x022c, 0x0118 => 0x022c, 0x0119 => 0x02d2, 0x011a => 0x0190, 0x011b => 0x01f4, 0x011c => 0x029b, 0x011d => 0x022c, 0x011e => 0x0225, 0x011f => 0x02d2, 0x0120 => 0x0185, 0x0121 => 0x02d2, 0x0122 => 0x01f4, 0x0123 => 0x029b, 0x0124 => 0x0263, 0x0125 => 0x029b, 0x0126 => 0x029b, 0x0127 => 0x029b, 0x0128 => 0x02d2, 0x0129 => 0x0185, 0x012a => 0x029b, 0x012b => 0x0185, 0x012c => 0x01f4, 0x012d => 0x025e, 0x012e => 0x0185, 0x012f => 0x022c, 0x0130 => 0x0116, 0x0131 => 0x025e, 0x0132 => 0x01f4, 0x0133 => 0x022c, 0x0134 => 0x0225, 0x0135 => 0x01f4, 0x0136 => 0x01f4, 0x0137 => 0x0185, 0x0138 => 0x022c, 0x0139 => 0x012c, 0x013a => 0x0116, 0x013b => 0x01f4, ); $cmapData = array( 0x20 => 0x01, 0x21 => 0x02, 0x22 => 0x03, 0x23 => 0x04, 0x24 => 0x05, 0x25 => 0x06, 0x26 => 0x07, 0x2019 => 0x08, 0x28 => 0x09, 0x29 => 0x0a, 0x2a => 0x0b, 0x2b => 0x0c, 0x2c => 0x0d, 0x2d => 0x0e, 0x2e => 0x0f, 0x2f => 0x10, 0x30 => 0x11, 0x31 => 0x12, 0x32 => 0x13, 0x33 => 0x14, 0x34 => 0x15, 0x35 => 0x16, 0x36 => 0x17, 0x37 => 0x18, 0x38 => 0x19, 0x39 => 0x1a, 0x3a => 0x1b, 0x3b => 0x1c, 0x3c => 0x1d, 0x3d => 0x1e, 0x3e => 0x1f, 0x3f => 0x20, 0x40 => 0x21, 0x41 => 0x22, 0x42 => 0x23, 0x43 => 0x24, 0x44 => 0x25, 0x45 => 0x26, 0x46 => 0x27, 0x47 => 0x28, 0x48 => 0x29, 0x49 => 0x2a, 0x4a => 0x2b, 0x4b => 0x2c, 0x4c => 0x2d, 0x4d => 0x2e, 0x4e => 0x2f, 0x4f => 0x30, 0x50 => 0x31, 0x51 => 0x32, 0x52 => 0x33, 0x53 => 0x34, 0x54 => 0x35, 0x55 => 0x36, 0x56 => 0x37, 0x57 => 0x38, 0x58 => 0x39, 0x59 => 0x3a, 0x5a => 0x3b, 0x5b => 0x3c, 0x5c => 0x3d, 0x5d => 0x3e, 0x5e => 0x3f, 0x5f => 0x40, 0x2018 => 0x41, 0x61 => 0x42, 0x62 => 0x43, 0x63 => 0x44, 0x64 => 0x45, 0x65 => 0x46, 0x66 => 0x47, 0x67 => 0x48, 0x68 => 0x49, 0x69 => 0x4a, 0x6a => 0x4b, 0x6b => 0x4c, 0x6c => 0x4d, 0x6d => 0x4e, 0x6e => 0x4f, 0x6f => 0x50, 0x70 => 0x51, 0x71 => 0x52, 0x72 => 0x53, 0x73 => 0x54, 0x74 => 0x55, 0x75 => 0x56, 0x76 => 0x57, 0x77 => 0x58, 0x78 => 0x59, 0x79 => 0x5a, 0x7a => 0x5b, 0x7b => 0x5c, 0x7c => 0x5d, 0x7d => 0x5e, 0x7e => 0x5f, 0xa1 => 0x60, 0xa2 => 0x61, 0xa3 => 0x62, 0x2044 => 0x63, 0xa5 => 0x64, 0x0192 => 0x65, 0xa7 => 0x66, 0xa4 => 0x67, 0x27 => 0x68, 0x201c => 0x69, 0xab => 0x6a, 0x2039 => 0x6b, 0x203a => 0x6c, 0xfb01 => 0x6d, 0xfb02 => 0x6e, 0x2013 => 0x6f, 0x2020 => 0x70, 0x2021 => 0x71, 0xb7 => 0x72, 0xb6 => 0x73, 0x2022 => 0x74, 0x201a => 0x75, 0x201e => 0x76, 0x201d => 0x77, 0xbb => 0x78, 0x2026 => 0x79, 0x2030 => 0x7a, 0xbf => 0x7b, 0x60 => 0x7c, 0xb4 => 0x7d, 0x02c6 => 0x7e, 0x02dc => 0x7f, 0xaf => 0x80, 0x02d8 => 0x81, 0x02d9 => 0x82, 0xa8 => 0x83, 0x02da => 0x84, 0xb8 => 0x85, 0x02dd => 0x86, 0x02db => 0x87, 0x02c7 => 0x88, 0x2014 => 0x89, 0xc6 => 0x8a, 0xaa => 0x8b, 0x0141 => 0x8c, 0xd8 => 0x8d, 0x0152 => 0x8e, 0xba => 0x8f, 0xe6 => 0x90, 0x0131 => 0x91, 0x0142 => 0x92, 0xf8 => 0x93, 0x0153 => 0x94, 0xdf => 0x95, 0xcf => 0x96, 0xe9 => 0x97, 0x0103 => 0x98, 0x0171 => 0x99, 0x011b => 0x9a, 0x0178 => 0x9b, 0xf7 => 0x9c, 0xdd => 0x9d, 0xc2 => 0x9e, 0xe1 => 0x9f, 0xdb => 0xa0, 0xfd => 0xa1, 0x0219 => 0xa2, 0xea => 0xa3, 0x016e => 0xa4, 0xdc => 0xa5, 0x0105 => 0xa6, 0xda => 0xa7, 0x0173 => 0xa8, 0xcb => 0xa9, 0x0110 => 0xaa, 0xf6c3 => 0xab, 0xa9 => 0xac, 0x0112 => 0xad, 0x010d => 0xae, 0xe5 => 0xaf, 0x0145 => 0xb0, 0x013a => 0xb1, 0xe0 => 0xb2, 0x0162 => 0xb3, 0x0106 => 0xb4, 0xe3 => 0xb5, 0x0116 => 0xb6, 0x0161 => 0xb7, 0x015f => 0xb8, 0xed => 0xb9, 0x25ca => 0xba, 0x0158 => 0xbb, 0x0122 => 0xbc, 0xfb => 0xbd, 0xe2 => 0xbe, 0x0100 => 0xbf, 0x0159 => 0xc0, 0xe7 => 0xc1, 0x017b => 0xc2, 0xde => 0xc3, 0x014c => 0xc4, 0x0154 => 0xc5, 0x015a => 0xc6, 0x010f => 0xc7, 0x016a => 0xc8, 0x016f => 0xc9, 0xb3 => 0xca, 0xd2 => 0xcb, 0xc0 => 0xcc, 0x0102 => 0xcd, 0xd7 => 0xce, 0xfa => 0xcf, 0x0164 => 0xd0, 0x2202 => 0xd1, 0xff => 0xd2, 0x0143 => 0xd3, 0xee => 0xd4, 0xca => 0xd5, 0xe4 => 0xd6, 0xeb => 0xd7, 0x0107 => 0xd8, 0x0144 => 0xd9, 0x016b => 0xda, 0x0147 => 0xdb, 0xcd => 0xdc, 0xb1 => 0xdd, 0xa6 => 0xde, 0xae => 0xdf, 0x011e => 0xe0, 0x0130 => 0xe1, 0x2211 => 0xe2, 0xc8 => 0xe3, 0x0155 => 0xe4, 0x014d => 0xe5, 0x0179 => 0xe6, 0x017d => 0xe7, 0x2265 => 0xe8, 0xd0 => 0xe9, 0xc7 => 0xea, 0x013c => 0xeb, 0x0165 => 0xec, 0x0119 => 0xed, 0x0172 => 0xee, 0xc1 => 0xef, 0xc4 => 0xf0, 0xe8 => 0xf1, 0x017a => 0xf2, 0x012f => 0xf3, 0xd3 => 0xf4, 0xf3 => 0xf5, 0x0101 => 0xf6, 0x015b => 0xf7, 0xef => 0xf8, 0xd4 => 0xf9, 0xd9 => 0xfa, 0x2206 => 0xfb, 0xfe => 0xfc, 0xb2 => 0xfd, 0xd6 => 0xfe, 0xb5 => 0xff, 0xec => 0x0100, 0x0151 => 0x0101, 0x0118 => 0x0102, 0x0111 => 0x0103, 0xbe => 0x0104, 0x015e => 0x0105, 0x013e => 0x0106, 0x0136 => 0x0107, 0x0139 => 0x0108, 0x2122 => 0x0109, 0x0117 => 0x010a, 0xcc => 0x010b, 0x012a => 0x010c, 0x013d => 0x010d, 0xbd => 0x010e, 0x2264 => 0x010f, 0xf4 => 0x0110, 0xf1 => 0x0111, 0x0170 => 0x0112, 0xc9 => 0x0113, 0x0113 => 0x0114, 0x011f => 0x0115, 0xbc => 0x0116, 0x0160 => 0x0117, 0x0218 => 0x0118, 0x0150 => 0x0119, 0xb0 => 0x011a, 0xf2 => 0x011b, 0x010c => 0x011c, 0xf9 => 0x011d, 0x221a => 0x011e, 0x010e => 0x011f, 0x0157 => 0x0120, 0xd1 => 0x0121, 0xf5 => 0x0122, 0x0156 => 0x0123, 0x013b => 0x0124, 0xc3 => 0x0125, 0x0104 => 0x0126, 0xc5 => 0x0127, 0xd5 => 0x0128, 0x017c => 0x0129, 0x011a => 0x012a, 0x012e => 0x012b, 0x0137 => 0x012c, 0x2212 => 0x012d, 0xce => 0x012e, 0x0148 => 0x012f, 0x0163 => 0x0130, 0xac => 0x0131, 0xf6 => 0x0132, 0xfc => 0x0133, 0x2260 => 0x0134, 0x0123 => 0x0135, 0xf0 => 0x0136, 0x017e => 0x0137, 0x0146 => 0x0138, 0xb9 => 0x0139, 0x012b => 0x013a, 0x20ac => 0x013b); $this->_cmap = Zend_Pdf_Cmap::cmapWithTypeData( Zend_Pdf_Cmap::TYPE_BYTE_ENCODING_STATIC, $cmapData); $this->_resource->BaseFont = new Zend_Pdf_Element_Name('Times-BoldItalic'); } }

/* @source /library/Zend/Pdf/Resource/Font/Simple/Standard/CourierOblique.php */
class Zend_Pdf_Resource_Font_Simple_Standard_CourierOblique extends Zend_Pdf_Resource_Font_Simple_Standard { public function __construct() { parent::__construct(); $this->_fontNames[Zend_Pdf_Font::NAME_COPYRIGHT]['en'] = "\x00\x43\x00\x6f\x00\x70\x00\x79\x00\x72\x00\x69\x00\x67\x00\x68\x00" . "\x74\x00\x20\x00\x28\x00\x63\x00\x29\x00\x20\x00\x31\x00\x39\x00" . "\x38\x00\x39\x00\x2c\x00\x20\x00\x31\x00\x39\x00\x39\x00\x30\x00" . "\x2c\x00\x20\x00\x31\x00\x39\x00\x39\x00\x31\x00\x2c\x00\x20\x00" . "\x31\x00\x39\x00\x39\x00\x32\x00\x2c\x00\x20\x00\x31\x00\x39\x00" . "\x39\x00\x33\x00\x2c\x00\x20\x00\x31\x00\x39\x00\x39\x00\x37\x00" . "\x20\x00\x41\x00\x64\x00\x6f\x00\x62\x00\x65\x00\x20\x00\x53\x00" . "\x79\x00\x73\x00\x74\x00\x65\x00\x6d\x00\x73\x00\x20\x00\x49\x00" . "\x6e\x00\x63\x00\x6f\x00\x72\x00\x70\x00\x6f\x00\x72\x00\x61\x00" . "\x74\x00\x65\x00\x64\x00\x2e\x00\x20\x00\x20\x00\x41\x00\x6c\x00" . "\x6c\x00\x20\x00\x52\x00\x69\x00\x67\x00\x68\x00\x74\x00\x73\x00" . "\x20\x00\x52\x00\x65\x00\x73\x00\x65\x00\x72\x00\x76\x00\x65\x00" . "\x64\x00\x2e"; $this->_fontNames[Zend_Pdf_Font::NAME_FAMILY]['en'] = "\x00\x43\x00\x6f\x00\x75\x00\x72\x00\x69\x00\x65\x00\x72"; $this->_fontNames[Zend_Pdf_Font::NAME_STYLE]['en'] = "\x00\x4d\x00\x65\x00\x64\x00\x69\x00\x75\x00\x6d"; $this->_fontNames[Zend_Pdf_Font::NAME_ID]['en'] = "\x00\x34\x00\x33\x00\x30\x00\x35\x00\x31"; $this->_fontNames[Zend_Pdf_Font::NAME_FULL]['en'] = "\x00\x43\x00\x6f\x00\x75\x00\x72\x00\x69\x00\x65\x00\x72\x00\x2d\x00" . "\x4f\x00\x62\x00\x6c\x00\x69\x00\x71\x00\x75\x00\x65\x00\x20\x00" . "\x4d\x00\x65\x00\x64\x00\x69\x00\x75\x00\x6d"; $this->_fontNames[Zend_Pdf_Font::NAME_VERSION]['en'] = "\x00\x30\x00\x30\x00\x33\x00\x2e\x00\x30\x00\x30\x00\x30"; $this->_fontNames[Zend_Pdf_Font::NAME_POSTSCRIPT]['en'] = "\x00\x43\x00\x6f\x00\x75\x00\x72\x00\x69\x00\x65\x00\x72\x00\x2d\x00" . "\x4f\x00\x62\x00\x6c\x00\x69\x00\x71\x00\x75\x00\x65"; $this->_isBold = false; $this->_isItalic = true; $this->_isMonospaced = true; $this->_underlinePosition = -100; $this->_underlineThickness = 50; $this->_strikePosition = 225; $this->_strikeThickness = 50; $this->_unitsPerEm = 1000; $this->_ascent = 629; $this->_descent = -157; $this->_lineGap = 414; $this->_glyphWidths = array( 0x00 => 0x01f4, 0x01 => 0x0258, 0x02 => 0x0258, 0x03 => 0x0258, 0x04 => 0x0258, 0x05 => 0x0258, 0x06 => 0x0258, 0x07 => 0x0258, 0x08 => 0x0258, 0x09 => 0x0258, 0x0a => 0x0258, 0x0b => 0x0258, 0x0c => 0x0258, 0x0d => 0x0258, 0x0e => 0x0258, 0x0f => 0x0258, 0x10 => 0x0258, 0x11 => 0x0258, 0x12 => 0x0258, 0x13 => 0x0258, 0x14 => 0x0258, 0x15 => 0x0258, 0x16 => 0x0258, 0x17 => 0x0258, 0x18 => 0x0258, 0x19 => 0x0258, 0x1a => 0x0258, 0x1b => 0x0258, 0x1c => 0x0258, 0x1d => 0x0258, 0x1e => 0x0258, 0x1f => 0x0258, 0x20 => 0x0258, 0x21 => 0x0258, 0x22 => 0x0258, 0x23 => 0x0258, 0x24 => 0x0258, 0x25 => 0x0258, 0x26 => 0x0258, 0x27 => 0x0258, 0x28 => 0x0258, 0x29 => 0x0258, 0x2a => 0x0258, 0x2b => 0x0258, 0x2c => 0x0258, 0x2d => 0x0258, 0x2e => 0x0258, 0x2f => 0x0258, 0x30 => 0x0258, 0x31 => 0x0258, 0x32 => 0x0258, 0x33 => 0x0258, 0x34 => 0x0258, 0x35 => 0x0258, 0x36 => 0x0258, 0x37 => 0x0258, 0x38 => 0x0258, 0x39 => 0x0258, 0x3a => 0x0258, 0x3b => 0x0258, 0x3c => 0x0258, 0x3d => 0x0258, 0x3e => 0x0258, 0x3f => 0x0258, 0x40 => 0x0258, 0x41 => 0x0258, 0x42 => 0x0258, 0x43 => 0x0258, 0x44 => 0x0258, 0x45 => 0x0258, 0x46 => 0x0258, 0x47 => 0x0258, 0x48 => 0x0258, 0x49 => 0x0258, 0x4a => 0x0258, 0x4b => 0x0258, 0x4c => 0x0258, 0x4d => 0x0258, 0x4e => 0x0258, 0x4f => 0x0258, 0x50 => 0x0258, 0x51 => 0x0258, 0x52 => 0x0258, 0x53 => 0x0258, 0x54 => 0x0258, 0x55 => 0x0258, 0x56 => 0x0258, 0x57 => 0x0258, 0x58 => 0x0258, 0x59 => 0x0258, 0x5a => 0x0258, 0x5b => 0x0258, 0x5c => 0x0258, 0x5d => 0x0258, 0x5e => 0x0258, 0x5f => 0x0258, 0x60 => 0x0258, 0x61 => 0x0258, 0x62 => 0x0258, 0x63 => 0x0258, 0x64 => 0x0258, 0x65 => 0x0258, 0x66 => 0x0258, 0x67 => 0x0258, 0x68 => 0x0258, 0x69 => 0x0258, 0x6a => 0x0258, 0x6b => 0x0258, 0x6c => 0x0258, 0x6d => 0x0258, 0x6e => 0x0258, 0x6f => 0x0258, 0x70 => 0x0258, 0x71 => 0x0258, 0x72 => 0x0258, 0x73 => 0x0258, 0x74 => 0x0258, 0x75 => 0x0258, 0x76 => 0x0258, 0x77 => 0x0258, 0x78 => 0x0258, 0x79 => 0x0258, 0x7a => 0x0258, 0x7b => 0x0258, 0x7c => 0x0258, 0x7d => 0x0258, 0x7e => 0x0258, 0x7f => 0x0258, 0x80 => 0x0258, 0x81 => 0x0258, 0x82 => 0x0258, 0x83 => 0x0258, 0x84 => 0x0258, 0x85 => 0x0258, 0x86 => 0x0258, 0x87 => 0x0258, 0x88 => 0x0258, 0x89 => 0x0258, 0x8a => 0x0258, 0x8b => 0x0258, 0x8c => 0x0258, 0x8d => 0x0258, 0x8e => 0x0258, 0x8f => 0x0258, 0x90 => 0x0258, 0x91 => 0x0258, 0x92 => 0x0258, 0x93 => 0x0258, 0x94 => 0x0258, 0x95 => 0x0258, 0x96 => 0x0258, 0x97 => 0x0258, 0x98 => 0x0258, 0x99 => 0x0258, 0x9a => 0x0258, 0x9b => 0x0258, 0x9c => 0x0258, 0x9d => 0x0258, 0x9e => 0x0258, 0x9f => 0x0258, 0xa0 => 0x0258, 0xa1 => 0x0258, 0xa2 => 0x0258, 0xa3 => 0x0258, 0xa4 => 0x0258, 0xa5 => 0x0258, 0xa6 => 0x0258, 0xa7 => 0x0258, 0xa8 => 0x0258, 0xa9 => 0x0258, 0xaa => 0x0258, 0xab => 0x0258, 0xac => 0x0258, 0xad => 0x0258, 0xae => 0x0258, 0xaf => 0x0258, 0xb0 => 0x0258, 0xb1 => 0x0258, 0xb2 => 0x0258, 0xb3 => 0x0258, 0xb4 => 0x0258, 0xb5 => 0x0258, 0xb6 => 0x0258, 0xb7 => 0x0258, 0xb8 => 0x0258, 0xb9 => 0x0258, 0xba => 0x0258, 0xbb => 0x0258, 0xbc => 0x0258, 0xbd => 0x0258, 0xbe => 0x0258, 0xbf => 0x0258, 0xc0 => 0x0258, 0xc1 => 0x0258, 0xc2 => 0x0258, 0xc3 => 0x0258, 0xc4 => 0x0258, 0xc5 => 0x0258, 0xc6 => 0x0258, 0xc7 => 0x0258, 0xc8 => 0x0258, 0xc9 => 0x0258, 0xca => 0x0258, 0xcb => 0x0258, 0xcc => 0x0258, 0xcd => 0x0258, 0xce => 0x0258, 0xcf => 0x0258, 0xd0 => 0x0258, 0xd1 => 0x0258, 0xd2 => 0x0258, 0xd3 => 0x0258, 0xd4 => 0x0258, 0xd5 => 0x0258, 0xd6 => 0x0258, 0xd7 => 0x0258, 0xd8 => 0x0258, 0xd9 => 0x0258, 0xda => 0x0258, 0xdb => 0x0258, 0xdc => 0x0258, 0xdd => 0x0258, 0xde => 0x0258, 0xdf => 0x0258, 0xe0 => 0x0258, 0xe1 => 0x0258, 0xe2 => 0x0258, 0xe3 => 0x0258, 0xe4 => 0x0258, 0xe5 => 0x0258, 0xe6 => 0x0258, 0xe7 => 0x0258, 0xe8 => 0x0258, 0xe9 => 0x0258, 0xea => 0x0258, 0xeb => 0x0258, 0xec => 0x0258, 0xed => 0x0258, 0xee => 0x0258, 0xef => 0x0258, 0xf0 => 0x0258, 0xf1 => 0x0258, 0xf2 => 0x0258, 0xf3 => 0x0258, 0xf4 => 0x0258, 0xf5 => 0x0258, 0xf6 => 0x0258, 0xf7 => 0x0258, 0xf8 => 0x0258, 0xf9 => 0x0258, 0xfa => 0x0258, 0xfb => 0x0258, 0xfc => 0x0258, 0xfd => 0x0258, 0xfe => 0x0258, 0xff => 0x0258, 0x0100 => 0x0258, 0x0101 => 0x0258, 0x0102 => 0x0258, 0x0103 => 0x0258, 0x0104 => 0x0258, 0x0105 => 0x0258, 0x0106 => 0x0258, 0x0107 => 0x0258, 0x0108 => 0x0258, 0x0109 => 0x0258, 0x010a => 0x0258, 0x010b => 0x0258, 0x010c => 0x0258, 0x010d => 0x0258, 0x010e => 0x0258, 0x010f => 0x0258, 0x0110 => 0x0258, 0x0111 => 0x0258, 0x0112 => 0x0258, 0x0113 => 0x0258, 0x0114 => 0x0258, 0x0115 => 0x0258, 0x0116 => 0x0258, 0x0117 => 0x0258, 0x0118 => 0x0258, 0x0119 => 0x0258, 0x011a => 0x0258, 0x011b => 0x0258, 0x011c => 0x0258, 0x011d => 0x0258, 0x011e => 0x0258, 0x011f => 0x0258, 0x0120 => 0x0258, 0x0121 => 0x0258, 0x0122 => 0x0258, 0x0123 => 0x0258, 0x0124 => 0x0258, 0x0125 => 0x0258, 0x0126 => 0x0258, 0x0127 => 0x0258, 0x0128 => 0x0258, 0x0129 => 0x0258, 0x012a => 0x0258, 0x012b => 0x0258, 0x012c => 0x0258, 0x012d => 0x0258, 0x012e => 0x0258, 0x012f => 0x0258, 0x0130 => 0x0258, 0x0131 => 0x0258, 0x0132 => 0x0258, 0x0133 => 0x0258, 0x0134 => 0x0258, 0x0135 => 0x0258, 0x0136 => 0x0258, 0x0137 => 0x0258, 0x0138 => 0x0258, 0x0139 => 0x0258, 0x013a => 0x0258, 0x013b => 0x0258, ); $cmapData = array( 0x20 => 0x01, 0x21 => 0x02, 0x22 => 0x03, 0x23 => 0x04, 0x24 => 0x05, 0x25 => 0x06, 0x26 => 0x07, 0x2019 => 0x08, 0x28 => 0x09, 0x29 => 0x0a, 0x2a => 0x0b, 0x2b => 0x0c, 0x2c => 0x0d, 0x2d => 0x0e, 0x2e => 0x0f, 0x2f => 0x10, 0x30 => 0x11, 0x31 => 0x12, 0x32 => 0x13, 0x33 => 0x14, 0x34 => 0x15, 0x35 => 0x16, 0x36 => 0x17, 0x37 => 0x18, 0x38 => 0x19, 0x39 => 0x1a, 0x3a => 0x1b, 0x3b => 0x1c, 0x3c => 0x1d, 0x3d => 0x1e, 0x3e => 0x1f, 0x3f => 0x20, 0x40 => 0x21, 0x41 => 0x22, 0x42 => 0x23, 0x43 => 0x24, 0x44 => 0x25, 0x45 => 0x26, 0x46 => 0x27, 0x47 => 0x28, 0x48 => 0x29, 0x49 => 0x2a, 0x4a => 0x2b, 0x4b => 0x2c, 0x4c => 0x2d, 0x4d => 0x2e, 0x4e => 0x2f, 0x4f => 0x30, 0x50 => 0x31, 0x51 => 0x32, 0x52 => 0x33, 0x53 => 0x34, 0x54 => 0x35, 0x55 => 0x36, 0x56 => 0x37, 0x57 => 0x38, 0x58 => 0x39, 0x59 => 0x3a, 0x5a => 0x3b, 0x5b => 0x3c, 0x5c => 0x3d, 0x5d => 0x3e, 0x5e => 0x3f, 0x5f => 0x40, 0x2018 => 0x41, 0x61 => 0x42, 0x62 => 0x43, 0x63 => 0x44, 0x64 => 0x45, 0x65 => 0x46, 0x66 => 0x47, 0x67 => 0x48, 0x68 => 0x49, 0x69 => 0x4a, 0x6a => 0x4b, 0x6b => 0x4c, 0x6c => 0x4d, 0x6d => 0x4e, 0x6e => 0x4f, 0x6f => 0x50, 0x70 => 0x51, 0x71 => 0x52, 0x72 => 0x53, 0x73 => 0x54, 0x74 => 0x55, 0x75 => 0x56, 0x76 => 0x57, 0x77 => 0x58, 0x78 => 0x59, 0x79 => 0x5a, 0x7a => 0x5b, 0x7b => 0x5c, 0x7c => 0x5d, 0x7d => 0x5e, 0x7e => 0x5f, 0xa1 => 0x60, 0xa2 => 0x61, 0xa3 => 0x62, 0x2044 => 0x63, 0xa5 => 0x64, 0x0192 => 0x65, 0xa7 => 0x66, 0xa4 => 0x67, 0x27 => 0x68, 0x201c => 0x69, 0xab => 0x6a, 0x2039 => 0x6b, 0x203a => 0x6c, 0xfb01 => 0x6d, 0xfb02 => 0x6e, 0x2013 => 0x6f, 0x2020 => 0x70, 0x2021 => 0x71, 0xb7 => 0x72, 0xb6 => 0x73, 0x2022 => 0x74, 0x201a => 0x75, 0x201e => 0x76, 0x201d => 0x77, 0xbb => 0x78, 0x2026 => 0x79, 0x2030 => 0x7a, 0xbf => 0x7b, 0x60 => 0x7c, 0xb4 => 0x7d, 0x02c6 => 0x7e, 0x02dc => 0x7f, 0xaf => 0x80, 0x02d8 => 0x81, 0x02d9 => 0x82, 0xa8 => 0x83, 0x02da => 0x84, 0xb8 => 0x85, 0x02dd => 0x86, 0x02db => 0x87, 0x02c7 => 0x88, 0x2014 => 0x89, 0xc6 => 0x8a, 0xaa => 0x8b, 0x0141 => 0x8c, 0xd8 => 0x8d, 0x0152 => 0x8e, 0xba => 0x8f, 0xe6 => 0x90, 0x0131 => 0x91, 0x0142 => 0x92, 0xf8 => 0x93, 0x0153 => 0x94, 0xdf => 0x95, 0xcf => 0x96, 0xe9 => 0x97, 0x0103 => 0x98, 0x0171 => 0x99, 0x011b => 0x9a, 0x0178 => 0x9b, 0xf7 => 0x9c, 0xdd => 0x9d, 0xc2 => 0x9e, 0xe1 => 0x9f, 0xdb => 0xa0, 0xfd => 0xa1, 0x0219 => 0xa2, 0xea => 0xa3, 0x016e => 0xa4, 0xdc => 0xa5, 0x0105 => 0xa6, 0xda => 0xa7, 0x0173 => 0xa8, 0xcb => 0xa9, 0x0110 => 0xaa, 0xf6c3 => 0xab, 0xa9 => 0xac, 0x0112 => 0xad, 0x010d => 0xae, 0xe5 => 0xaf, 0x0145 => 0xb0, 0x013a => 0xb1, 0xe0 => 0xb2, 0x0162 => 0xb3, 0x0106 => 0xb4, 0xe3 => 0xb5, 0x0116 => 0xb6, 0x0161 => 0xb7, 0x015f => 0xb8, 0xed => 0xb9, 0x25ca => 0xba, 0x0158 => 0xbb, 0x0122 => 0xbc, 0xfb => 0xbd, 0xe2 => 0xbe, 0x0100 => 0xbf, 0x0159 => 0xc0, 0xe7 => 0xc1, 0x017b => 0xc2, 0xde => 0xc3, 0x014c => 0xc4, 0x0154 => 0xc5, 0x015a => 0xc6, 0x010f => 0xc7, 0x016a => 0xc8, 0x016f => 0xc9, 0xb3 => 0xca, 0xd2 => 0xcb, 0xc0 => 0xcc, 0x0102 => 0xcd, 0xd7 => 0xce, 0xfa => 0xcf, 0x0164 => 0xd0, 0x2202 => 0xd1, 0xff => 0xd2, 0x0143 => 0xd3, 0xee => 0xd4, 0xca => 0xd5, 0xe4 => 0xd6, 0xeb => 0xd7, 0x0107 => 0xd8, 0x0144 => 0xd9, 0x016b => 0xda, 0x0147 => 0xdb, 0xcd => 0xdc, 0xb1 => 0xdd, 0xa6 => 0xde, 0xae => 0xdf, 0x011e => 0xe0, 0x0130 => 0xe1, 0x2211 => 0xe2, 0xc8 => 0xe3, 0x0155 => 0xe4, 0x014d => 0xe5, 0x0179 => 0xe6, 0x017d => 0xe7, 0x2265 => 0xe8, 0xd0 => 0xe9, 0xc7 => 0xea, 0x013c => 0xeb, 0x0165 => 0xec, 0x0119 => 0xed, 0x0172 => 0xee, 0xc1 => 0xef, 0xc4 => 0xf0, 0xe8 => 0xf1, 0x017a => 0xf2, 0x012f => 0xf3, 0xd3 => 0xf4, 0xf3 => 0xf5, 0x0101 => 0xf6, 0x015b => 0xf7, 0xef => 0xf8, 0xd4 => 0xf9, 0xd9 => 0xfa, 0x2206 => 0xfb, 0xfe => 0xfc, 0xb2 => 0xfd, 0xd6 => 0xfe, 0xb5 => 0xff, 0xec => 0x0100, 0x0151 => 0x0101, 0x0118 => 0x0102, 0x0111 => 0x0103, 0xbe => 0x0104, 0x015e => 0x0105, 0x013e => 0x0106, 0x0136 => 0x0107, 0x0139 => 0x0108, 0x2122 => 0x0109, 0x0117 => 0x010a, 0xcc => 0x010b, 0x012a => 0x010c, 0x013d => 0x010d, 0xbd => 0x010e, 0x2264 => 0x010f, 0xf4 => 0x0110, 0xf1 => 0x0111, 0x0170 => 0x0112, 0xc9 => 0x0113, 0x0113 => 0x0114, 0x011f => 0x0115, 0xbc => 0x0116, 0x0160 => 0x0117, 0x0218 => 0x0118, 0x0150 => 0x0119, 0xb0 => 0x011a, 0xf2 => 0x011b, 0x010c => 0x011c, 0xf9 => 0x011d, 0x221a => 0x011e, 0x010e => 0x011f, 0x0157 => 0x0120, 0xd1 => 0x0121, 0xf5 => 0x0122, 0x0156 => 0x0123, 0x013b => 0x0124, 0xc3 => 0x0125, 0x0104 => 0x0126, 0xc5 => 0x0127, 0xd5 => 0x0128, 0x017c => 0x0129, 0x011a => 0x012a, 0x012e => 0x012b, 0x0137 => 0x012c, 0x2212 => 0x012d, 0xce => 0x012e, 0x0148 => 0x012f, 0x0163 => 0x0130, 0xac => 0x0131, 0xf6 => 0x0132, 0xfc => 0x0133, 0x2260 => 0x0134, 0x0123 => 0x0135, 0xf0 => 0x0136, 0x017e => 0x0137, 0x0146 => 0x0138, 0xb9 => 0x0139, 0x012b => 0x013a, 0x20ac => 0x013b); $this->_cmap = Zend_Pdf_Cmap::cmapWithTypeData( Zend_Pdf_Cmap::TYPE_BYTE_ENCODING_STATIC, $cmapData); $this->_resource->BaseFont = new Zend_Pdf_Element_Name('Courier-Oblique'); } }

/* @source /library/Zend/Pdf/Resource/Font/Simple/Standard/CourierBoldOblique.php */
class Zend_Pdf_Resource_Font_Simple_Standard_CourierBoldOblique extends Zend_Pdf_Resource_Font_Simple_Standard { public function __construct() { parent::__construct(); $this->_fontNames[Zend_Pdf_Font::NAME_COPYRIGHT]['en'] = "\x00\x43\x00\x6f\x00\x70\x00\x79\x00\x72\x00\x69\x00\x67\x00\x68\x00" . "\x74\x00\x20\x00\x28\x00\x63\x00\x29\x00\x20\x00\x31\x00\x39\x00" . "\x38\x00\x39\x00\x2c\x00\x20\x00\x31\x00\x39\x00\x39\x00\x30\x00" . "\x2c\x00\x20\x00\x31\x00\x39\x00\x39\x00\x31\x00\x2c\x00\x20\x00" . "\x31\x00\x39\x00\x39\x00\x33\x00\x2c\x00\x20\x00\x31\x00\x39\x00" . "\x39\x00\x37\x00\x20\x00\x41\x00\x64\x00\x6f\x00\x62\x00\x65\x00" . "\x20\x00\x53\x00\x79\x00\x73\x00\x74\x00\x65\x00\x6d\x00\x73\x00" . "\x20\x00\x49\x00\x6e\x00\x63\x00\x6f\x00\x72\x00\x70\x00\x6f\x00" . "\x72\x00\x61\x00\x74\x00\x65\x00\x64\x00\x2e\x00\x20\x00\x20\x00" . "\x41\x00\x6c\x00\x6c\x00\x20\x00\x52\x00\x69\x00\x67\x00\x68\x00" . "\x74\x00\x73\x00\x20\x00\x52\x00\x65\x00\x73\x00\x65\x00\x72\x00" . "\x76\x00\x65\x00\x64\x00\x2e"; $this->_fontNames[Zend_Pdf_Font::NAME_FAMILY]['en'] = "\x00\x43\x00\x6f\x00\x75\x00\x72\x00\x69\x00\x65\x00\x72"; $this->_fontNames[Zend_Pdf_Font::NAME_STYLE]['en'] = "\x00\x42\x00\x6f\x00\x6c\x00\x64"; $this->_fontNames[Zend_Pdf_Font::NAME_ID]['en'] = "\x00\x34\x00\x33\x00\x30\x00\x34\x00\x39"; $this->_fontNames[Zend_Pdf_Font::NAME_FULL]['en'] = "\x00\x43\x00\x6f\x00\x75\x00\x72\x00\x69\x00\x65\x00\x72\x00\x2d\x00" . "\x42\x00\x6f\x00\x6c\x00\x64\x00\x4f\x00\x62\x00\x6c\x00\x69\x00" . "\x71\x00\x75\x00\x65\x00\x20\x00\x42\x00\x6f\x00\x6c\x00\x64"; $this->_fontNames[Zend_Pdf_Font::NAME_VERSION]['en'] = "\x00\x30\x00\x30\x00\x33\x00\x2e\x00\x30\x00\x30\x00\x30"; $this->_fontNames[Zend_Pdf_Font::NAME_POSTSCRIPT]['en'] = "\x00\x43\x00\x6f\x00\x75\x00\x72\x00\x69\x00\x65\x00\x72\x00\x2d\x00" . "\x42\x00\x6f\x00\x6c\x00\x64\x00\x4f\x00\x62\x00\x6c\x00\x69\x00" . "\x71\x00\x75\x00\x65"; $this->_isBold = true; $this->_isItalic = true; $this->_isMonospaced = true; $this->_underlinePosition = -100; $this->_underlineThickness = 50; $this->_strikePosition = 225; $this->_strikeThickness = 50; $this->_unitsPerEm = 1000; $this->_ascent = 629; $this->_descent = -157; $this->_lineGap = 414; $this->_glyphWidths = array( 0x00 => 0x01f4, 0x01 => 0x0258, 0x02 => 0x0258, 0x03 => 0x0258, 0x04 => 0x0258, 0x05 => 0x0258, 0x06 => 0x0258, 0x07 => 0x0258, 0x08 => 0x0258, 0x09 => 0x0258, 0x0a => 0x0258, 0x0b => 0x0258, 0x0c => 0x0258, 0x0d => 0x0258, 0x0e => 0x0258, 0x0f => 0x0258, 0x10 => 0x0258, 0x11 => 0x0258, 0x12 => 0x0258, 0x13 => 0x0258, 0x14 => 0x0258, 0x15 => 0x0258, 0x16 => 0x0258, 0x17 => 0x0258, 0x18 => 0x0258, 0x19 => 0x0258, 0x1a => 0x0258, 0x1b => 0x0258, 0x1c => 0x0258, 0x1d => 0x0258, 0x1e => 0x0258, 0x1f => 0x0258, 0x20 => 0x0258, 0x21 => 0x0258, 0x22 => 0x0258, 0x23 => 0x0258, 0x24 => 0x0258, 0x25 => 0x0258, 0x26 => 0x0258, 0x27 => 0x0258, 0x28 => 0x0258, 0x29 => 0x0258, 0x2a => 0x0258, 0x2b => 0x0258, 0x2c => 0x0258, 0x2d => 0x0258, 0x2e => 0x0258, 0x2f => 0x0258, 0x30 => 0x0258, 0x31 => 0x0258, 0x32 => 0x0258, 0x33 => 0x0258, 0x34 => 0x0258, 0x35 => 0x0258, 0x36 => 0x0258, 0x37 => 0x0258, 0x38 => 0x0258, 0x39 => 0x0258, 0x3a => 0x0258, 0x3b => 0x0258, 0x3c => 0x0258, 0x3d => 0x0258, 0x3e => 0x0258, 0x3f => 0x0258, 0x40 => 0x0258, 0x41 => 0x0258, 0x42 => 0x0258, 0x43 => 0x0258, 0x44 => 0x0258, 0x45 => 0x0258, 0x46 => 0x0258, 0x47 => 0x0258, 0x48 => 0x0258, 0x49 => 0x0258, 0x4a => 0x0258, 0x4b => 0x0258, 0x4c => 0x0258, 0x4d => 0x0258, 0x4e => 0x0258, 0x4f => 0x0258, 0x50 => 0x0258, 0x51 => 0x0258, 0x52 => 0x0258, 0x53 => 0x0258, 0x54 => 0x0258, 0x55 => 0x0258, 0x56 => 0x0258, 0x57 => 0x0258, 0x58 => 0x0258, 0x59 => 0x0258, 0x5a => 0x0258, 0x5b => 0x0258, 0x5c => 0x0258, 0x5d => 0x0258, 0x5e => 0x0258, 0x5f => 0x0258, 0x60 => 0x0258, 0x61 => 0x0258, 0x62 => 0x0258, 0x63 => 0x0258, 0x64 => 0x0258, 0x65 => 0x0258, 0x66 => 0x0258, 0x67 => 0x0258, 0x68 => 0x0258, 0x69 => 0x0258, 0x6a => 0x0258, 0x6b => 0x0258, 0x6c => 0x0258, 0x6d => 0x0258, 0x6e => 0x0258, 0x6f => 0x0258, 0x70 => 0x0258, 0x71 => 0x0258, 0x72 => 0x0258, 0x73 => 0x0258, 0x74 => 0x0258, 0x75 => 0x0258, 0x76 => 0x0258, 0x77 => 0x0258, 0x78 => 0x0258, 0x79 => 0x0258, 0x7a => 0x0258, 0x7b => 0x0258, 0x7c => 0x0258, 0x7d => 0x0258, 0x7e => 0x0258, 0x7f => 0x0258, 0x80 => 0x0258, 0x81 => 0x0258, 0x82 => 0x0258, 0x83 => 0x0258, 0x84 => 0x0258, 0x85 => 0x0258, 0x86 => 0x0258, 0x87 => 0x0258, 0x88 => 0x0258, 0x89 => 0x0258, 0x8a => 0x0258, 0x8b => 0x0258, 0x8c => 0x0258, 0x8d => 0x0258, 0x8e => 0x0258, 0x8f => 0x0258, 0x90 => 0x0258, 0x91 => 0x0258, 0x92 => 0x0258, 0x93 => 0x0258, 0x94 => 0x0258, 0x95 => 0x0258, 0x96 => 0x0258, 0x97 => 0x0258, 0x98 => 0x0258, 0x99 => 0x0258, 0x9a => 0x0258, 0x9b => 0x0258, 0x9c => 0x0258, 0x9d => 0x0258, 0x9e => 0x0258, 0x9f => 0x0258, 0xa0 => 0x0258, 0xa1 => 0x0258, 0xa2 => 0x0258, 0xa3 => 0x0258, 0xa4 => 0x0258, 0xa5 => 0x0258, 0xa6 => 0x0258, 0xa7 => 0x0258, 0xa8 => 0x0258, 0xa9 => 0x0258, 0xaa => 0x0258, 0xab => 0x0258, 0xac => 0x0258, 0xad => 0x0258, 0xae => 0x0258, 0xaf => 0x0258, 0xb0 => 0x0258, 0xb1 => 0x0258, 0xb2 => 0x0258, 0xb3 => 0x0258, 0xb4 => 0x0258, 0xb5 => 0x0258, 0xb6 => 0x0258, 0xb7 => 0x0258, 0xb8 => 0x0258, 0xb9 => 0x0258, 0xba => 0x0258, 0xbb => 0x0258, 0xbc => 0x0258, 0xbd => 0x0258, 0xbe => 0x0258, 0xbf => 0x0258, 0xc0 => 0x0258, 0xc1 => 0x0258, 0xc2 => 0x0258, 0xc3 => 0x0258, 0xc4 => 0x0258, 0xc5 => 0x0258, 0xc6 => 0x0258, 0xc7 => 0x0258, 0xc8 => 0x0258, 0xc9 => 0x0258, 0xca => 0x0258, 0xcb => 0x0258, 0xcc => 0x0258, 0xcd => 0x0258, 0xce => 0x0258, 0xcf => 0x0258, 0xd0 => 0x0258, 0xd1 => 0x0258, 0xd2 => 0x0258, 0xd3 => 0x0258, 0xd4 => 0x0258, 0xd5 => 0x0258, 0xd6 => 0x0258, 0xd7 => 0x0258, 0xd8 => 0x0258, 0xd9 => 0x0258, 0xda => 0x0258, 0xdb => 0x0258, 0xdc => 0x0258, 0xdd => 0x0258, 0xde => 0x0258, 0xdf => 0x0258, 0xe0 => 0x0258, 0xe1 => 0x0258, 0xe2 => 0x0258, 0xe3 => 0x0258, 0xe4 => 0x0258, 0xe5 => 0x0258, 0xe6 => 0x0258, 0xe7 => 0x0258, 0xe8 => 0x0258, 0xe9 => 0x0258, 0xea => 0x0258, 0xeb => 0x0258, 0xec => 0x0258, 0xed => 0x0258, 0xee => 0x0258, 0xef => 0x0258, 0xf0 => 0x0258, 0xf1 => 0x0258, 0xf2 => 0x0258, 0xf3 => 0x0258, 0xf4 => 0x0258, 0xf5 => 0x0258, 0xf6 => 0x0258, 0xf7 => 0x0258, 0xf8 => 0x0258, 0xf9 => 0x0258, 0xfa => 0x0258, 0xfb => 0x0258, 0xfc => 0x0258, 0xfd => 0x0258, 0xfe => 0x0258, 0xff => 0x0258, 0x0100 => 0x0258, 0x0101 => 0x0258, 0x0102 => 0x0258, 0x0103 => 0x0258, 0x0104 => 0x0258, 0x0105 => 0x0258, 0x0106 => 0x0258, 0x0107 => 0x0258, 0x0108 => 0x0258, 0x0109 => 0x0258, 0x010a => 0x0258, 0x010b => 0x0258, 0x010c => 0x0258, 0x010d => 0x0258, 0x010e => 0x0258, 0x010f => 0x0258, 0x0110 => 0x0258, 0x0111 => 0x0258, 0x0112 => 0x0258, 0x0113 => 0x0258, 0x0114 => 0x0258, 0x0115 => 0x0258, 0x0116 => 0x0258, 0x0117 => 0x0258, 0x0118 => 0x0258, 0x0119 => 0x0258, 0x011a => 0x0258, 0x011b => 0x0258, 0x011c => 0x0258, 0x011d => 0x0258, 0x011e => 0x0258, 0x011f => 0x0258, 0x0120 => 0x0258, 0x0121 => 0x0258, 0x0122 => 0x0258, 0x0123 => 0x0258, 0x0124 => 0x0258, 0x0125 => 0x0258, 0x0126 => 0x0258, 0x0127 => 0x0258, 0x0128 => 0x0258, 0x0129 => 0x0258, 0x012a => 0x0258, 0x012b => 0x0258, 0x012c => 0x0258, 0x012d => 0x0258, 0x012e => 0x0258, 0x012f => 0x0258, 0x0130 => 0x0258, 0x0131 => 0x0258, 0x0132 => 0x0258, 0x0133 => 0x0258, 0x0134 => 0x0258, 0x0135 => 0x0258, 0x0136 => 0x0258, 0x0137 => 0x0258, 0x0138 => 0x0258, 0x0139 => 0x0258, 0x013a => 0x0258, 0x013b => 0x0258, ); $cmapData = array( 0x20 => 0x01, 0x21 => 0x02, 0x22 => 0x03, 0x23 => 0x04, 0x24 => 0x05, 0x25 => 0x06, 0x26 => 0x07, 0x2019 => 0x08, 0x28 => 0x09, 0x29 => 0x0a, 0x2a => 0x0b, 0x2b => 0x0c, 0x2c => 0x0d, 0x2d => 0x0e, 0x2e => 0x0f, 0x2f => 0x10, 0x30 => 0x11, 0x31 => 0x12, 0x32 => 0x13, 0x33 => 0x14, 0x34 => 0x15, 0x35 => 0x16, 0x36 => 0x17, 0x37 => 0x18, 0x38 => 0x19, 0x39 => 0x1a, 0x3a => 0x1b, 0x3b => 0x1c, 0x3c => 0x1d, 0x3d => 0x1e, 0x3e => 0x1f, 0x3f => 0x20, 0x40 => 0x21, 0x41 => 0x22, 0x42 => 0x23, 0x43 => 0x24, 0x44 => 0x25, 0x45 => 0x26, 0x46 => 0x27, 0x47 => 0x28, 0x48 => 0x29, 0x49 => 0x2a, 0x4a => 0x2b, 0x4b => 0x2c, 0x4c => 0x2d, 0x4d => 0x2e, 0x4e => 0x2f, 0x4f => 0x30, 0x50 => 0x31, 0x51 => 0x32, 0x52 => 0x33, 0x53 => 0x34, 0x54 => 0x35, 0x55 => 0x36, 0x56 => 0x37, 0x57 => 0x38, 0x58 => 0x39, 0x59 => 0x3a, 0x5a => 0x3b, 0x5b => 0x3c, 0x5c => 0x3d, 0x5d => 0x3e, 0x5e => 0x3f, 0x5f => 0x40, 0x2018 => 0x41, 0x61 => 0x42, 0x62 => 0x43, 0x63 => 0x44, 0x64 => 0x45, 0x65 => 0x46, 0x66 => 0x47, 0x67 => 0x48, 0x68 => 0x49, 0x69 => 0x4a, 0x6a => 0x4b, 0x6b => 0x4c, 0x6c => 0x4d, 0x6d => 0x4e, 0x6e => 0x4f, 0x6f => 0x50, 0x70 => 0x51, 0x71 => 0x52, 0x72 => 0x53, 0x73 => 0x54, 0x74 => 0x55, 0x75 => 0x56, 0x76 => 0x57, 0x77 => 0x58, 0x78 => 0x59, 0x79 => 0x5a, 0x7a => 0x5b, 0x7b => 0x5c, 0x7c => 0x5d, 0x7d => 0x5e, 0x7e => 0x5f, 0xa1 => 0x60, 0xa2 => 0x61, 0xa3 => 0x62, 0x2044 => 0x63, 0xa5 => 0x64, 0x0192 => 0x65, 0xa7 => 0x66, 0xa4 => 0x67, 0x27 => 0x68, 0x201c => 0x69, 0xab => 0x6a, 0x2039 => 0x6b, 0x203a => 0x6c, 0xfb01 => 0x6d, 0xfb02 => 0x6e, 0x2013 => 0x6f, 0x2020 => 0x70, 0x2021 => 0x71, 0xb7 => 0x72, 0xb6 => 0x73, 0x2022 => 0x74, 0x201a => 0x75, 0x201e => 0x76, 0x201d => 0x77, 0xbb => 0x78, 0x2026 => 0x79, 0x2030 => 0x7a, 0xbf => 0x7b, 0x60 => 0x7c, 0xb4 => 0x7d, 0x02c6 => 0x7e, 0x02dc => 0x7f, 0xaf => 0x80, 0x02d8 => 0x81, 0x02d9 => 0x82, 0xa8 => 0x83, 0x02da => 0x84, 0xb8 => 0x85, 0x02dd => 0x86, 0x02db => 0x87, 0x02c7 => 0x88, 0x2014 => 0x89, 0xc6 => 0x8a, 0xaa => 0x8b, 0x0141 => 0x8c, 0xd8 => 0x8d, 0x0152 => 0x8e, 0xba => 0x8f, 0xe6 => 0x90, 0x0131 => 0x91, 0x0142 => 0x92, 0xf8 => 0x93, 0x0153 => 0x94, 0xdf => 0x95, 0xcf => 0x96, 0xe9 => 0x97, 0x0103 => 0x98, 0x0171 => 0x99, 0x011b => 0x9a, 0x0178 => 0x9b, 0xf7 => 0x9c, 0xdd => 0x9d, 0xc2 => 0x9e, 0xe1 => 0x9f, 0xdb => 0xa0, 0xfd => 0xa1, 0x0219 => 0xa2, 0xea => 0xa3, 0x016e => 0xa4, 0xdc => 0xa5, 0x0105 => 0xa6, 0xda => 0xa7, 0x0173 => 0xa8, 0xcb => 0xa9, 0x0110 => 0xaa, 0xf6c3 => 0xab, 0xa9 => 0xac, 0x0112 => 0xad, 0x010d => 0xae, 0xe5 => 0xaf, 0x0145 => 0xb0, 0x013a => 0xb1, 0xe0 => 0xb2, 0x0162 => 0xb3, 0x0106 => 0xb4, 0xe3 => 0xb5, 0x0116 => 0xb6, 0x0161 => 0xb7, 0x015f => 0xb8, 0xed => 0xb9, 0x25ca => 0xba, 0x0158 => 0xbb, 0x0122 => 0xbc, 0xfb => 0xbd, 0xe2 => 0xbe, 0x0100 => 0xbf, 0x0159 => 0xc0, 0xe7 => 0xc1, 0x017b => 0xc2, 0xde => 0xc3, 0x014c => 0xc4, 0x0154 => 0xc5, 0x015a => 0xc6, 0x010f => 0xc7, 0x016a => 0xc8, 0x016f => 0xc9, 0xb3 => 0xca, 0xd2 => 0xcb, 0xc0 => 0xcc, 0x0102 => 0xcd, 0xd7 => 0xce, 0xfa => 0xcf, 0x0164 => 0xd0, 0x2202 => 0xd1, 0xff => 0xd2, 0x0143 => 0xd3, 0xee => 0xd4, 0xca => 0xd5, 0xe4 => 0xd6, 0xeb => 0xd7, 0x0107 => 0xd8, 0x0144 => 0xd9, 0x016b => 0xda, 0x0147 => 0xdb, 0xcd => 0xdc, 0xb1 => 0xdd, 0xa6 => 0xde, 0xae => 0xdf, 0x011e => 0xe0, 0x0130 => 0xe1, 0x2211 => 0xe2, 0xc8 => 0xe3, 0x0155 => 0xe4, 0x014d => 0xe5, 0x0179 => 0xe6, 0x017d => 0xe7, 0x2265 => 0xe8, 0xd0 => 0xe9, 0xc7 => 0xea, 0x013c => 0xeb, 0x0165 => 0xec, 0x0119 => 0xed, 0x0172 => 0xee, 0xc1 => 0xef, 0xc4 => 0xf0, 0xe8 => 0xf1, 0x017a => 0xf2, 0x012f => 0xf3, 0xd3 => 0xf4, 0xf3 => 0xf5, 0x0101 => 0xf6, 0x015b => 0xf7, 0xef => 0xf8, 0xd4 => 0xf9, 0xd9 => 0xfa, 0x2206 => 0xfb, 0xfe => 0xfc, 0xb2 => 0xfd, 0xd6 => 0xfe, 0xb5 => 0xff, 0xec => 0x0100, 0x0151 => 0x0101, 0x0118 => 0x0102, 0x0111 => 0x0103, 0xbe => 0x0104, 0x015e => 0x0105, 0x013e => 0x0106, 0x0136 => 0x0107, 0x0139 => 0x0108, 0x2122 => 0x0109, 0x0117 => 0x010a, 0xcc => 0x010b, 0x012a => 0x010c, 0x013d => 0x010d, 0xbd => 0x010e, 0x2264 => 0x010f, 0xf4 => 0x0110, 0xf1 => 0x0111, 0x0170 => 0x0112, 0xc9 => 0x0113, 0x0113 => 0x0114, 0x011f => 0x0115, 0xbc => 0x0116, 0x0160 => 0x0117, 0x0218 => 0x0118, 0x0150 => 0x0119, 0xb0 => 0x011a, 0xf2 => 0x011b, 0x010c => 0x011c, 0xf9 => 0x011d, 0x221a => 0x011e, 0x010e => 0x011f, 0x0157 => 0x0120, 0xd1 => 0x0121, 0xf5 => 0x0122, 0x0156 => 0x0123, 0x013b => 0x0124, 0xc3 => 0x0125, 0x0104 => 0x0126, 0xc5 => 0x0127, 0xd5 => 0x0128, 0x017c => 0x0129, 0x011a => 0x012a, 0x012e => 0x012b, 0x0137 => 0x012c, 0x2212 => 0x012d, 0xce => 0x012e, 0x0148 => 0x012f, 0x0163 => 0x0130, 0xac => 0x0131, 0xf6 => 0x0132, 0xfc => 0x0133, 0x2260 => 0x0134, 0x0123 => 0x0135, 0xf0 => 0x0136, 0x017e => 0x0137, 0x0146 => 0x0138, 0xb9 => 0x0139, 0x012b => 0x013a, 0x20ac => 0x013b); $this->_cmap = Zend_Pdf_Cmap::cmapWithTypeData( Zend_Pdf_Cmap::TYPE_BYTE_ENCODING_STATIC, $cmapData); $this->_resource->BaseFont = new Zend_Pdf_Element_Name('Courier-BoldOblique'); } }

/* @source /library/Zend/Pdf/Resource/Font/Simple/Standard/HelveticaOblique.php */
class Zend_Pdf_Resource_Font_Simple_Standard_HelveticaOblique extends Zend_Pdf_Resource_Font_Simple_Standard { public function __construct() { parent::__construct(); $this->_fontNames[Zend_Pdf_Font::NAME_COPYRIGHT]['en'] = "\x00\x43\x00\x6f\x00\x70\x00\x79\x00\x72\x00\x69\x00\x67\x00\x68\x00" . "\x74\x00\x20\x00\x28\x00\x63\x00\x29\x00\x20\x00\x31\x00\x39\x00" . "\x38\x00\x35\x00\x2c\x00\x20\x00\x31\x00\x39\x00\x38\x00\x37\x00" . "\x2c\x00\x20\x00\x31\x00\x39\x00\x38\x00\x39\x00\x2c\x00\x20\x00" . "\x31\x00\x39\x00\x39\x00\x30\x00\x2c\x00\x20\x00\x31\x00\x39\x00" . "\x39\x00\x37\x00\x20\x00\x41\x00\x64\x00\x6f\x00\x62\x00\x65\x00" . "\x20\x00\x53\x00\x79\x00\x73\x00\x74\x00\x65\x00\x6d\x00\x73\x00" . "\x20\x00\x49\x00\x6e\x00\x63\x00\x6f\x00\x72\x00\x70\x00\x6f\x00" . "\x72\x00\x61\x00\x74\x00\x65\x00\x64\x00\x2e\x00\x20\x00\x20\x00" . "\x41\x00\x6c\x00\x6c\x00\x20\x00\x52\x00\x69\x00\x67\x00\x68\x00" . "\x74\x00\x73\x00\x20\x00\x52\x00\x65\x00\x73\x00\x65\x00\x72\x00" . "\x76\x00\x65\x00\x64\x00\x2e\x00\x48\x00\x65\x00\x6c\x00\x76\x00" . "\x65\x00\x74\x00\x69\x00\x63\x00\x61\x00\x20\x00\x69\x00\x73\x00" . "\x20\x00\x61\x00\x20\x00\x74\x00\x72\x00\x61\x00\x64\x00\x65\x00" . "\x6d\x00\x61\x00\x72\x00\x6b\x00\x20\x00\x6f\x00\x66\x00\x20\x00" . "\x4c\x00\x69\x00\x6e\x00\x6f\x00\x74\x00\x79\x00\x70\x00\x65\x00" . "\x2d\x00\x48\x00\x65\x00\x6c\x00\x6c\x00\x20\x00\x41\x00\x47\x00" . "\x20\x00\x61\x00\x6e\x00\x64\x00\x2f\x00\x6f\x00\x72\x00\x20\x00" . "\x69\x00\x74\x00\x73\x00\x20\x00\x73\x00\x75\x00\x62\x00\x73\x00" . "\x69\x00\x64\x00\x69\x00\x61\x00\x72\x00\x69\x00\x65\x00\x73\x00" . "\x2e"; $this->_fontNames[Zend_Pdf_Font::NAME_FAMILY]['en'] = "\x00\x48\x00\x65\x00\x6c\x00\x76\x00\x65\x00\x74\x00\x69\x00\x63\x00" . "\x61"; $this->_fontNames[Zend_Pdf_Font::NAME_STYLE]['en'] = "\x00\x4d\x00\x65\x00\x64\x00\x69\x00\x75\x00\x6d"; $this->_fontNames[Zend_Pdf_Font::NAME_ID]['en'] = "\x00\x34\x00\x33\x00\x30\x00\x35\x00\x35"; $this->_fontNames[Zend_Pdf_Font::NAME_FULL]['en'] = "\x00\x48\x00\x65\x00\x6c\x00\x76\x00\x65\x00\x74\x00\x69\x00\x63\x00" . "\x61\x00\x2d\x00\x4f\x00\x62\x00\x6c\x00\x69\x00\x71\x00\x75\x00" . "\x65\x00\x20\x00\x4d\x00\x65\x00\x64\x00\x69\x00\x75\x00\x6d"; $this->_fontNames[Zend_Pdf_Font::NAME_VERSION]['en'] = "\x00\x30\x00\x30\x00\x32\x00\x2e\x00\x30\x00\x30\x00\x30"; $this->_fontNames[Zend_Pdf_Font::NAME_POSTSCRIPT]['en'] = "\x00\x48\x00\x65\x00\x6c\x00\x76\x00\x65\x00\x74\x00\x69\x00\x63\x00" . "\x61\x00\x2d\x00\x4f\x00\x62\x00\x6c\x00\x69\x00\x71\x00\x75\x00" . "\x65"; $this->_isBold = false; $this->_isItalic = true; $this->_isMonospaced = false; $this->_underlinePosition = -100; $this->_underlineThickness = 50; $this->_strikePosition = 225; $this->_strikeThickness = 50; $this->_unitsPerEm = 1000; $this->_ascent = 718; $this->_descent = -207; $this->_lineGap = 275; $this->_glyphWidths = array( 0x00 => 0x01f4, 0x01 => 0x0116, 0x02 => 0x0116, 0x03 => 0x0163, 0x04 => 0x022c, 0x05 => 0x022c, 0x06 => 0x0379, 0x07 => 0x029b, 0x08 => 0xde, 0x09 => 0x014d, 0x0a => 0x014d, 0x0b => 0x0185, 0x0c => 0x0248, 0x0d => 0x0116, 0x0e => 0x014d, 0x0f => 0x0116, 0x10 => 0x0116, 0x11 => 0x022c, 0x12 => 0x022c, 0x13 => 0x022c, 0x14 => 0x022c, 0x15 => 0x022c, 0x16 => 0x022c, 0x17 => 0x022c, 0x18 => 0x022c, 0x19 => 0x022c, 0x1a => 0x022c, 0x1b => 0x0116, 0x1c => 0x0116, 0x1d => 0x0248, 0x1e => 0x0248, 0x1f => 0x0248, 0x20 => 0x022c, 0x21 => 0x03f7, 0x22 => 0x029b, 0x23 => 0x029b, 0x24 => 0x02d2, 0x25 => 0x02d2, 0x26 => 0x029b, 0x27 => 0x0263, 0x28 => 0x030a, 0x29 => 0x02d2, 0x2a => 0x0116, 0x2b => 0x01f4, 0x2c => 0x029b, 0x2d => 0x022c, 0x2e => 0x0341, 0x2f => 0x02d2, 0x30 => 0x030a, 0x31 => 0x029b, 0x32 => 0x030a, 0x33 => 0x02d2, 0x34 => 0x029b, 0x35 => 0x0263, 0x36 => 0x02d2, 0x37 => 0x029b, 0x38 => 0x03b0, 0x39 => 0x029b, 0x3a => 0x029b, 0x3b => 0x0263, 0x3c => 0x0116, 0x3d => 0x0116, 0x3e => 0x0116, 0x3f => 0x01d5, 0x40 => 0x022c, 0x41 => 0xde, 0x42 => 0x022c, 0x43 => 0x022c, 0x44 => 0x01f4, 0x45 => 0x022c, 0x46 => 0x022c, 0x47 => 0x0116, 0x48 => 0x022c, 0x49 => 0x022c, 0x4a => 0xde, 0x4b => 0xde, 0x4c => 0x01f4, 0x4d => 0xde, 0x4e => 0x0341, 0x4f => 0x022c, 0x50 => 0x022c, 0x51 => 0x022c, 0x52 => 0x022c, 0x53 => 0x014d, 0x54 => 0x01f4, 0x55 => 0x0116, 0x56 => 0x022c, 0x57 => 0x01f4, 0x58 => 0x02d2, 0x59 => 0x01f4, 0x5a => 0x01f4, 0x5b => 0x01f4, 0x5c => 0x014e, 0x5d => 0x0104, 0x5e => 0x014e, 0x5f => 0x0248, 0x60 => 0x014d, 0x61 => 0x022c, 0x62 => 0x022c, 0x63 => 0xa7, 0x64 => 0x022c, 0x65 => 0x022c, 0x66 => 0x022c, 0x67 => 0x022c, 0x68 => 0xbf, 0x69 => 0x014d, 0x6a => 0x022c, 0x6b => 0x014d, 0x6c => 0x014d, 0x6d => 0x01f4, 0x6e => 0x01f4, 0x6f => 0x022c, 0x70 => 0x022c, 0x71 => 0x022c, 0x72 => 0x0116, 0x73 => 0x0219, 0x74 => 0x015e, 0x75 => 0xde, 0x76 => 0x014d, 0x77 => 0x014d, 0x78 => 0x022c, 0x79 => 0x03e8, 0x7a => 0x03e8, 0x7b => 0x0263, 0x7c => 0x014d, 0x7d => 0x014d, 0x7e => 0x014d, 0x7f => 0x014d, 0x80 => 0x014d, 0x81 => 0x014d, 0x82 => 0x014d, 0x83 => 0x014d, 0x84 => 0x014d, 0x85 => 0x014d, 0x86 => 0x014d, 0x87 => 0x014d, 0x88 => 0x014d, 0x89 => 0x03e8, 0x8a => 0x03e8, 0x8b => 0x0172, 0x8c => 0x022c, 0x8d => 0x030a, 0x8e => 0x03e8, 0x8f => 0x016d, 0x90 => 0x0379, 0x91 => 0x0116, 0x92 => 0xde, 0x93 => 0x0263, 0x94 => 0x03b0, 0x95 => 0x0263, 0x96 => 0x0116, 0x97 => 0x022c, 0x98 => 0x022c, 0x99 => 0x022c, 0x9a => 0x022c, 0x9b => 0x029b, 0x9c => 0x0248, 0x9d => 0x029b, 0x9e => 0x029b, 0x9f => 0x022c, 0xa0 => 0x02d2, 0xa1 => 0x01f4, 0xa2 => 0x01f4, 0xa3 => 0x022c, 0xa4 => 0x02d2, 0xa5 => 0x02d2, 0xa6 => 0x022c, 0xa7 => 0x02d2, 0xa8 => 0x022c, 0xa9 => 0x029b, 0xaa => 0x02d2, 0xab => 0xfa, 0xac => 0x02e1, 0xad => 0x029b, 0xae => 0x01f4, 0xaf => 0x022c, 0xb0 => 0x02d2, 0xb1 => 0xde, 0xb2 => 0x022c, 0xb3 => 0x0263, 0xb4 => 0x02d2, 0xb5 => 0x022c, 0xb6 => 0x029b, 0xb7 => 0x01f4, 0xb8 => 0x01f4, 0xb9 => 0x0116, 0xba => 0x01d7, 0xbb => 0x02d2, 0xbc => 0x030a, 0xbd => 0x022c, 0xbe => 0x022c, 0xbf => 0x029b, 0xc0 => 0x014d, 0xc1 => 0x01f4, 0xc2 => 0x0263, 0xc3 => 0x029b, 0xc4 => 0x030a, 0xc5 => 0x02d2, 0xc6 => 0x029b, 0xc7 => 0x0283, 0xc8 => 0x02d2, 0xc9 => 0x022c, 0xca => 0x014d, 0xcb => 0x030a, 0xcc => 0x029b, 0xcd => 0x029b, 0xce => 0x0248, 0xcf => 0x022c, 0xd0 => 0x0263, 0xd1 => 0x01dc, 0xd2 => 0x01f4, 0xd3 => 0x02d2, 0xd4 => 0x0116, 0xd5 => 0x029b, 0xd6 => 0x022c, 0xd7 => 0x022c, 0xd8 => 0x01f4, 0xd9 => 0x022c, 0xda => 0x022c, 0xdb => 0x02d2, 0xdc => 0x0116, 0xdd => 0x0248, 0xde => 0x0104, 0xdf => 0x02e1, 0xe0 => 0x030a, 0xe1 => 0x0116, 0xe2 => 0x0258, 0xe3 => 0x029b, 0xe4 => 0x014d, 0xe5 => 0x022c, 0xe6 => 0x0263, 0xe7 => 0x0263, 0xe8 => 0x0225, 0xe9 => 0x02d2, 0xea => 0x02d2, 0xeb => 0xde, 0xec => 0x013d, 0xed => 0x022c, 0xee => 0x02d2, 0xef => 0x029b, 0xf0 => 0x029b, 0xf1 => 0x022c, 0xf2 => 0x01f4, 0xf3 => 0xde, 0xf4 => 0x030a, 0xf5 => 0x022c, 0xf6 => 0x022c, 0xf7 => 0x01f4, 0xf8 => 0x0116, 0xf9 => 0x030a, 0xfa => 0x02d2, 0xfb => 0x0264, 0xfc => 0x022c, 0xfd => 0x014d, 0xfe => 0x030a, 0xff => 0x022c, 0x0100 => 0x0116, 0x0101 => 0x022c, 0x0102 => 0x029b, 0x0103 => 0x022c, 0x0104 => 0x0342, 0x0105 => 0x029b, 0x0106 => 0x012b, 0x0107 => 0x029b, 0x0108 => 0x022c, 0x0109 => 0x03e8, 0x010a => 0x022c, 0x010b => 0x0116, 0x010c => 0x0116, 0x010d => 0x022c, 0x010e => 0x0342, 0x010f => 0x0225, 0x0110 => 0x022c, 0x0111 => 0x022c, 0x0112 => 0x02d2, 0x0113 => 0x029b, 0x0114 => 0x022c, 0x0115 => 0x022c, 0x0116 => 0x0342, 0x0117 => 0x029b, 0x0118 => 0x029b, 0x0119 => 0x030a, 0x011a => 0x0190, 0x011b => 0x022c, 0x011c => 0x02d2, 0x011d => 0x022c, 0x011e => 0x01c5, 0x011f => 0x02d2, 0x0120 => 0x014d, 0x0121 => 0x02d2, 0x0122 => 0x022c, 0x0123 => 0x02d2, 0x0124 => 0x022c, 0x0125 => 0x029b, 0x0126 => 0x029b, 0x0127 => 0x029b, 0x0128 => 0x030a, 0x0129 => 0x01f4, 0x012a => 0x029b, 0x012b => 0x0116, 0x012c => 0x01f4, 0x012d => 0x0248, 0x012e => 0x0116, 0x012f => 0x022c, 0x0130 => 0x0116, 0x0131 => 0x0248, 0x0132 => 0x022c, 0x0133 => 0x022c, 0x0134 => 0x0225, 0x0135 => 0x022c, 0x0136 => 0x022c, 0x0137 => 0x01f4, 0x0138 => 0x022c, 0x0139 => 0x014d, 0x013a => 0x0116, 0x013b => 0x022c, ); $cmapData = array( 0x20 => 0x01, 0x21 => 0x02, 0x22 => 0x03, 0x23 => 0x04, 0x24 => 0x05, 0x25 => 0x06, 0x26 => 0x07, 0x2019 => 0x08, 0x28 => 0x09, 0x29 => 0x0a, 0x2a => 0x0b, 0x2b => 0x0c, 0x2c => 0x0d, 0x2d => 0x0e, 0x2e => 0x0f, 0x2f => 0x10, 0x30 => 0x11, 0x31 => 0x12, 0x32 => 0x13, 0x33 => 0x14, 0x34 => 0x15, 0x35 => 0x16, 0x36 => 0x17, 0x37 => 0x18, 0x38 => 0x19, 0x39 => 0x1a, 0x3a => 0x1b, 0x3b => 0x1c, 0x3c => 0x1d, 0x3d => 0x1e, 0x3e => 0x1f, 0x3f => 0x20, 0x40 => 0x21, 0x41 => 0x22, 0x42 => 0x23, 0x43 => 0x24, 0x44 => 0x25, 0x45 => 0x26, 0x46 => 0x27, 0x47 => 0x28, 0x48 => 0x29, 0x49 => 0x2a, 0x4a => 0x2b, 0x4b => 0x2c, 0x4c => 0x2d, 0x4d => 0x2e, 0x4e => 0x2f, 0x4f => 0x30, 0x50 => 0x31, 0x51 => 0x32, 0x52 => 0x33, 0x53 => 0x34, 0x54 => 0x35, 0x55 => 0x36, 0x56 => 0x37, 0x57 => 0x38, 0x58 => 0x39, 0x59 => 0x3a, 0x5a => 0x3b, 0x5b => 0x3c, 0x5c => 0x3d, 0x5d => 0x3e, 0x5e => 0x3f, 0x5f => 0x40, 0x2018 => 0x41, 0x61 => 0x42, 0x62 => 0x43, 0x63 => 0x44, 0x64 => 0x45, 0x65 => 0x46, 0x66 => 0x47, 0x67 => 0x48, 0x68 => 0x49, 0x69 => 0x4a, 0x6a => 0x4b, 0x6b => 0x4c, 0x6c => 0x4d, 0x6d => 0x4e, 0x6e => 0x4f, 0x6f => 0x50, 0x70 => 0x51, 0x71 => 0x52, 0x72 => 0x53, 0x73 => 0x54, 0x74 => 0x55, 0x75 => 0x56, 0x76 => 0x57, 0x77 => 0x58, 0x78 => 0x59, 0x79 => 0x5a, 0x7a => 0x5b, 0x7b => 0x5c, 0x7c => 0x5d, 0x7d => 0x5e, 0x7e => 0x5f, 0xa1 => 0x60, 0xa2 => 0x61, 0xa3 => 0x62, 0x2044 => 0x63, 0xa5 => 0x64, 0x0192 => 0x65, 0xa7 => 0x66, 0xa4 => 0x67, 0x27 => 0x68, 0x201c => 0x69, 0xab => 0x6a, 0x2039 => 0x6b, 0x203a => 0x6c, 0xfb01 => 0x6d, 0xfb02 => 0x6e, 0x2013 => 0x6f, 0x2020 => 0x70, 0x2021 => 0x71, 0xb7 => 0x72, 0xb6 => 0x73, 0x2022 => 0x74, 0x201a => 0x75, 0x201e => 0x76, 0x201d => 0x77, 0xbb => 0x78, 0x2026 => 0x79, 0x2030 => 0x7a, 0xbf => 0x7b, 0x60 => 0x7c, 0xb4 => 0x7d, 0x02c6 => 0x7e, 0x02dc => 0x7f, 0xaf => 0x80, 0x02d8 => 0x81, 0x02d9 => 0x82, 0xa8 => 0x83, 0x02da => 0x84, 0xb8 => 0x85, 0x02dd => 0x86, 0x02db => 0x87, 0x02c7 => 0x88, 0x2014 => 0x89, 0xc6 => 0x8a, 0xaa => 0x8b, 0x0141 => 0x8c, 0xd8 => 0x8d, 0x0152 => 0x8e, 0xba => 0x8f, 0xe6 => 0x90, 0x0131 => 0x91, 0x0142 => 0x92, 0xf8 => 0x93, 0x0153 => 0x94, 0xdf => 0x95, 0xcf => 0x96, 0xe9 => 0x97, 0x0103 => 0x98, 0x0171 => 0x99, 0x011b => 0x9a, 0x0178 => 0x9b, 0xf7 => 0x9c, 0xdd => 0x9d, 0xc2 => 0x9e, 0xe1 => 0x9f, 0xdb => 0xa0, 0xfd => 0xa1, 0x0219 => 0xa2, 0xea => 0xa3, 0x016e => 0xa4, 0xdc => 0xa5, 0x0105 => 0xa6, 0xda => 0xa7, 0x0173 => 0xa8, 0xcb => 0xa9, 0x0110 => 0xaa, 0xf6c3 => 0xab, 0xa9 => 0xac, 0x0112 => 0xad, 0x010d => 0xae, 0xe5 => 0xaf, 0x0145 => 0xb0, 0x013a => 0xb1, 0xe0 => 0xb2, 0x0162 => 0xb3, 0x0106 => 0xb4, 0xe3 => 0xb5, 0x0116 => 0xb6, 0x0161 => 0xb7, 0x015f => 0xb8, 0xed => 0xb9, 0x25ca => 0xba, 0x0158 => 0xbb, 0x0122 => 0xbc, 0xfb => 0xbd, 0xe2 => 0xbe, 0x0100 => 0xbf, 0x0159 => 0xc0, 0xe7 => 0xc1, 0x017b => 0xc2, 0xde => 0xc3, 0x014c => 0xc4, 0x0154 => 0xc5, 0x015a => 0xc6, 0x010f => 0xc7, 0x016a => 0xc8, 0x016f => 0xc9, 0xb3 => 0xca, 0xd2 => 0xcb, 0xc0 => 0xcc, 0x0102 => 0xcd, 0xd7 => 0xce, 0xfa => 0xcf, 0x0164 => 0xd0, 0x2202 => 0xd1, 0xff => 0xd2, 0x0143 => 0xd3, 0xee => 0xd4, 0xca => 0xd5, 0xe4 => 0xd6, 0xeb => 0xd7, 0x0107 => 0xd8, 0x0144 => 0xd9, 0x016b => 0xda, 0x0147 => 0xdb, 0xcd => 0xdc, 0xb1 => 0xdd, 0xa6 => 0xde, 0xae => 0xdf, 0x011e => 0xe0, 0x0130 => 0xe1, 0x2211 => 0xe2, 0xc8 => 0xe3, 0x0155 => 0xe4, 0x014d => 0xe5, 0x0179 => 0xe6, 0x017d => 0xe7, 0x2265 => 0xe8, 0xd0 => 0xe9, 0xc7 => 0xea, 0x013c => 0xeb, 0x0165 => 0xec, 0x0119 => 0xed, 0x0172 => 0xee, 0xc1 => 0xef, 0xc4 => 0xf0, 0xe8 => 0xf1, 0x017a => 0xf2, 0x012f => 0xf3, 0xd3 => 0xf4, 0xf3 => 0xf5, 0x0101 => 0xf6, 0x015b => 0xf7, 0xef => 0xf8, 0xd4 => 0xf9, 0xd9 => 0xfa, 0x2206 => 0xfb, 0xfe => 0xfc, 0xb2 => 0xfd, 0xd6 => 0xfe, 0xb5 => 0xff, 0xec => 0x0100, 0x0151 => 0x0101, 0x0118 => 0x0102, 0x0111 => 0x0103, 0xbe => 0x0104, 0x015e => 0x0105, 0x013e => 0x0106, 0x0136 => 0x0107, 0x0139 => 0x0108, 0x2122 => 0x0109, 0x0117 => 0x010a, 0xcc => 0x010b, 0x012a => 0x010c, 0x013d => 0x010d, 0xbd => 0x010e, 0x2264 => 0x010f, 0xf4 => 0x0110, 0xf1 => 0x0111, 0x0170 => 0x0112, 0xc9 => 0x0113, 0x0113 => 0x0114, 0x011f => 0x0115, 0xbc => 0x0116, 0x0160 => 0x0117, 0x0218 => 0x0118, 0x0150 => 0x0119, 0xb0 => 0x011a, 0xf2 => 0x011b, 0x010c => 0x011c, 0xf9 => 0x011d, 0x221a => 0x011e, 0x010e => 0x011f, 0x0157 => 0x0120, 0xd1 => 0x0121, 0xf5 => 0x0122, 0x0156 => 0x0123, 0x013b => 0x0124, 0xc3 => 0x0125, 0x0104 => 0x0126, 0xc5 => 0x0127, 0xd5 => 0x0128, 0x017c => 0x0129, 0x011a => 0x012a, 0x012e => 0x012b, 0x0137 => 0x012c, 0x2212 => 0x012d, 0xce => 0x012e, 0x0148 => 0x012f, 0x0163 => 0x0130, 0xac => 0x0131, 0xf6 => 0x0132, 0xfc => 0x0133, 0x2260 => 0x0134, 0x0123 => 0x0135, 0xf0 => 0x0136, 0x017e => 0x0137, 0x0146 => 0x0138, 0xb9 => 0x0139, 0x012b => 0x013a, 0x20ac => 0x013b); $this->_cmap = Zend_Pdf_Cmap::cmapWithTypeData( Zend_Pdf_Cmap::TYPE_BYTE_ENCODING_STATIC, $cmapData); $this->_resource->BaseFont = new Zend_Pdf_Element_Name('Helvetica-Oblique'); } }

/* @source /library/Zend/Pdf/Resource/Font/Simple/Parsed/TrueType.php */
class Zend_Pdf_Resource_Font_Simple_Parsed_TrueType extends Zend_Pdf_Resource_Font_Simple_Parsed { public function __construct(Zend_Pdf_FileParser_Font_OpenType_TrueType $fontParser, $embeddingOptions) { parent::__construct($fontParser, $embeddingOptions); $this->_fontType = Zend_Pdf_Font::TYPE_TRUETYPE; $this->_resource->Subtype = new Zend_Pdf_Element_Name('TrueType'); $fontDescriptor = Zend_Pdf_Resource_Font_FontDescriptor::factory($this, $fontParser, $embeddingOptions); $this->_resource->FontDescriptor = $this->_objectFactory->newObject($fontDescriptor); } }

/* @source /library/Zend/Pdf/Resource/Font/Simple/Standard/HelveticaBold.php */
class Zend_Pdf_Resource_Font_Simple_Standard_HelveticaBold extends Zend_Pdf_Resource_Font_Simple_Standard { public function __construct() { parent::__construct(); $this->_fontNames[Zend_Pdf_Font::NAME_COPYRIGHT]['en'] = "\x00\x43\x00\x6f\x00\x70\x00\x79\x00\x72\x00\x69\x00\x67\x00\x68\x00" . "\x74\x00\x20\x00\x28\x00\x63\x00\x29\x00\x20\x00\x31\x00\x39\x00" . "\x38\x00\x35\x00\x2c\x00\x20\x00\x31\x00\x39\x00\x38\x00\x37\x00" . "\x2c\x00\x20\x00\x31\x00\x39\x00\x38\x00\x39\x00\x2c\x00\x20\x00" . "\x31\x00\x39\x00\x39\x00\x30\x00\x2c\x00\x20\x00\x31\x00\x39\x00" . "\x39\x00\x37\x00\x20\x00\x41\x00\x64\x00\x6f\x00\x62\x00\x65\x00" . "\x20\x00\x53\x00\x79\x00\x73\x00\x74\x00\x65\x00\x6d\x00\x73\x00" . "\x20\x00\x49\x00\x6e\x00\x63\x00\x6f\x00\x72\x00\x70\x00\x6f\x00" . "\x72\x00\x61\x00\x74\x00\x65\x00\x64\x00\x2e\x00\x20\x00\x20\x00" . "\x41\x00\x6c\x00\x6c\x00\x20\x00\x52\x00\x69\x00\x67\x00\x68\x00" . "\x74\x00\x73\x00\x20\x00\x52\x00\x65\x00\x73\x00\x65\x00\x72\x00" . "\x76\x00\x65\x00\x64\x00\x2e\x00\x48\x00\x65\x00\x6c\x00\x76\x00" . "\x65\x00\x74\x00\x69\x00\x63\x00\x61\x00\x20\x00\x69\x00\x73\x00" . "\x20\x00\x61\x00\x20\x00\x74\x00\x72\x00\x61\x00\x64\x00\x65\x00" . "\x6d\x00\x61\x00\x72\x00\x6b\x00\x20\x00\x6f\x00\x66\x00\x20\x00" . "\x4c\x00\x69\x00\x6e\x00\x6f\x00\x74\x00\x79\x00\x70\x00\x65\x00" . "\x2d\x00\x48\x00\x65\x00\x6c\x00\x6c\x00\x20\x00\x41\x00\x47\x00" . "\x20\x00\x61\x00\x6e\x00\x64\x00\x2f\x00\x6f\x00\x72\x00\x20\x00" . "\x69\x00\x74\x00\x73\x00\x20\x00\x73\x00\x75\x00\x62\x00\x73\x00" . "\x69\x00\x64\x00\x69\x00\x61\x00\x72\x00\x69\x00\x65\x00\x73\x00" . "\x2e"; $this->_fontNames[Zend_Pdf_Font::NAME_FAMILY]['en'] = "\x00\x48\x00\x65\x00\x6c\x00\x76\x00\x65\x00\x74\x00\x69\x00\x63\x00" . "\x61"; $this->_fontNames[Zend_Pdf_Font::NAME_STYLE]['en'] = "\x00\x42\x00\x6f\x00\x6c\x00\x64"; $this->_fontNames[Zend_Pdf_Font::NAME_ID]['en'] = "\x00\x34\x00\x33\x00\x30\x00\x35\x00\x32"; $this->_fontNames[Zend_Pdf_Font::NAME_FULL]['en'] = "\x00\x48\x00\x65\x00\x6c\x00\x76\x00\x65\x00\x74\x00\x69\x00\x63\x00" . "\x61\x00\x2d\x00\x42\x00\x6f\x00\x6c\x00\x64\x00\x20\x00\x42\x00" . "\x6f\x00\x6c\x00\x64"; $this->_fontNames[Zend_Pdf_Font::NAME_VERSION]['en'] = "\x00\x30\x00\x30\x00\x32\x00\x2e\x00\x30\x00\x30\x00\x30"; $this->_fontNames[Zend_Pdf_Font::NAME_POSTSCRIPT]['en'] = "\x00\x48\x00\x65\x00\x6c\x00\x76\x00\x65\x00\x74\x00\x69\x00\x63\x00" . "\x61\x00\x2d\x00\x42\x00\x6f\x00\x6c\x00\x64"; $this->_isBold = true; $this->_isItalic = false; $this->_isMonospaced = false; $this->_underlinePosition = -100; $this->_underlineThickness = 50; $this->_strikePosition = 225; $this->_strikeThickness = 50; $this->_unitsPerEm = 1000; $this->_ascent = 718; $this->_descent = -207; $this->_lineGap = 275; $this->_glyphWidths = array( 0x00 => 0x01f4, 0x01 => 0x0116, 0x02 => 0x014d, 0x03 => 0x01da, 0x04 => 0x022c, 0x05 => 0x022c, 0x06 => 0x0379, 0x07 => 0x02d2, 0x08 => 0x0116, 0x09 => 0x014d, 0x0a => 0x014d, 0x0b => 0x0185, 0x0c => 0x0248, 0x0d => 0x0116, 0x0e => 0x014d, 0x0f => 0x0116, 0x10 => 0x0116, 0x11 => 0x022c, 0x12 => 0x022c, 0x13 => 0x022c, 0x14 => 0x022c, 0x15 => 0x022c, 0x16 => 0x022c, 0x17 => 0x022c, 0x18 => 0x022c, 0x19 => 0x022c, 0x1a => 0x022c, 0x1b => 0x014d, 0x1c => 0x014d, 0x1d => 0x0248, 0x1e => 0x0248, 0x1f => 0x0248, 0x20 => 0x0263, 0x21 => 0x03cf, 0x22 => 0x02d2, 0x23 => 0x02d2, 0x24 => 0x02d2, 0x25 => 0x02d2, 0x26 => 0x029b, 0x27 => 0x0263, 0x28 => 0x030a, 0x29 => 0x02d2, 0x2a => 0x0116, 0x2b => 0x022c, 0x2c => 0x02d2, 0x2d => 0x0263, 0x2e => 0x0341, 0x2f => 0x02d2, 0x30 => 0x030a, 0x31 => 0x029b, 0x32 => 0x030a, 0x33 => 0x02d2, 0x34 => 0x029b, 0x35 => 0x0263, 0x36 => 0x02d2, 0x37 => 0x029b, 0x38 => 0x03b0, 0x39 => 0x029b, 0x3a => 0x029b, 0x3b => 0x0263, 0x3c => 0x014d, 0x3d => 0x0116, 0x3e => 0x014d, 0x3f => 0x0248, 0x40 => 0x022c, 0x41 => 0x0116, 0x42 => 0x022c, 0x43 => 0x0263, 0x44 => 0x022c, 0x45 => 0x0263, 0x46 => 0x022c, 0x47 => 0x014d, 0x48 => 0x0263, 0x49 => 0x0263, 0x4a => 0x0116, 0x4b => 0x0116, 0x4c => 0x022c, 0x4d => 0x0116, 0x4e => 0x0379, 0x4f => 0x0263, 0x50 => 0x0263, 0x51 => 0x0263, 0x52 => 0x0263, 0x53 => 0x0185, 0x54 => 0x022c, 0x55 => 0x014d, 0x56 => 0x0263, 0x57 => 0x022c, 0x58 => 0x030a, 0x59 => 0x022c, 0x5a => 0x022c, 0x5b => 0x01f4, 0x5c => 0x0185, 0x5d => 0x0118, 0x5e => 0x0185, 0x5f => 0x0248, 0x60 => 0x014d, 0x61 => 0x022c, 0x62 => 0x022c, 0x63 => 0xa7, 0x64 => 0x022c, 0x65 => 0x022c, 0x66 => 0x022c, 0x67 => 0x022c, 0x68 => 0xee, 0x69 => 0x01f4, 0x6a => 0x022c, 0x6b => 0x014d, 0x6c => 0x014d, 0x6d => 0x0263, 0x6e => 0x0263, 0x6f => 0x022c, 0x70 => 0x022c, 0x71 => 0x022c, 0x72 => 0x0116, 0x73 => 0x022c, 0x74 => 0x015e, 0x75 => 0x0116, 0x76 => 0x01f4, 0x77 => 0x01f4, 0x78 => 0x022c, 0x79 => 0x03e8, 0x7a => 0x03e8, 0x7b => 0x0263, 0x7c => 0x014d, 0x7d => 0x014d, 0x7e => 0x014d, 0x7f => 0x014d, 0x80 => 0x014d, 0x81 => 0x014d, 0x82 => 0x014d, 0x83 => 0x014d, 0x84 => 0x014d, 0x85 => 0x014d, 0x86 => 0x014d, 0x87 => 0x014d, 0x88 => 0x014d, 0x89 => 0x03e8, 0x8a => 0x03e8, 0x8b => 0x0172, 0x8c => 0x0263, 0x8d => 0x030a, 0x8e => 0x03e8, 0x8f => 0x016d, 0x90 => 0x0379, 0x91 => 0x0116, 0x92 => 0x0116, 0x93 => 0x0263, 0x94 => 0x03b0, 0x95 => 0x0263, 0x96 => 0x0116, 0x97 => 0x022c, 0x98 => 0x022c, 0x99 => 0x0263, 0x9a => 0x022c, 0x9b => 0x029b, 0x9c => 0x0248, 0x9d => 0x029b, 0x9e => 0x02d2, 0x9f => 0x022c, 0xa0 => 0x02d2, 0xa1 => 0x022c, 0xa2 => 0x022c, 0xa3 => 0x022c, 0xa4 => 0x02d2, 0xa5 => 0x02d2, 0xa6 => 0x022c, 0xa7 => 0x02d2, 0xa8 => 0x0263, 0xa9 => 0x029b, 0xaa => 0x02d2, 0xab => 0xfa, 0xac => 0x02e1, 0xad => 0x029b, 0xae => 0x022c, 0xaf => 0x022c, 0xb0 => 0x02d2, 0xb1 => 0x0116, 0xb2 => 0x022c, 0xb3 => 0x0263, 0xb4 => 0x02d2, 0xb5 => 0x022c, 0xb6 => 0x029b, 0xb7 => 0x022c, 0xb8 => 0x022c, 0xb9 => 0x0116, 0xba => 0x01ee, 0xbb => 0x02d2, 0xbc => 0x030a, 0xbd => 0x0263, 0xbe => 0x022c, 0xbf => 0x02d2, 0xc0 => 0x0185, 0xc1 => 0x022c, 0xc2 => 0x0263, 0xc3 => 0x029b, 0xc4 => 0x030a, 0xc5 => 0x02d2, 0xc6 => 0x029b, 0xc7 => 0x02e7, 0xc8 => 0x02d2, 0xc9 => 0x0263, 0xca => 0x014d, 0xcb => 0x030a, 0xcc => 0x02d2, 0xcd => 0x02d2, 0xce => 0x0248, 0xcf => 0x0263, 0xd0 => 0x0263, 0xd1 => 0x01ee, 0xd2 => 0x022c, 0xd3 => 0x02d2, 0xd4 => 0x0116, 0xd5 => 0x029b, 0xd6 => 0x022c, 0xd7 => 0x022c, 0xd8 => 0x022c, 0xd9 => 0x0263, 0xda => 0x0263, 0xdb => 0x02d2, 0xdc => 0x0116, 0xdd => 0x0248, 0xde => 0x0118, 0xdf => 0x02e1, 0xe0 => 0x030a, 0xe1 => 0x0116, 0xe2 => 0x0258, 0xe3 => 0x029b, 0xe4 => 0x0185, 0xe5 => 0x0263, 0xe6 => 0x0263, 0xe7 => 0x0263, 0xe8 => 0x0225, 0xe9 => 0x02d2, 0xea => 0x02d2, 0xeb => 0x0116, 0xec => 0x0185, 0xed => 0x022c, 0xee => 0x02d2, 0xef => 0x02d2, 0xf0 => 0x02d2, 0xf1 => 0x022c, 0xf2 => 0x01f4, 0xf3 => 0x0116, 0xf4 => 0x030a, 0xf5 => 0x0263, 0xf6 => 0x022c, 0xf7 => 0x022c, 0xf8 => 0x0116, 0xf9 => 0x030a, 0xfa => 0x02d2, 0xfb => 0x0264, 0xfc => 0x0263, 0xfd => 0x014d, 0xfe => 0x030a, 0xff => 0x0263, 0x0100 => 0x0116, 0x0101 => 0x0263, 0x0102 => 0x029b, 0x0103 => 0x0263, 0x0104 => 0x0342, 0x0105 => 0x029b, 0x0106 => 0x0190, 0x0107 => 0x02d2, 0x0108 => 0x0263, 0x0109 => 0x03e8, 0x010a => 0x022c, 0x010b => 0x0116, 0x010c => 0x0116, 0x010d => 0x0263, 0x010e => 0x0342, 0x010f => 0x0225, 0x0110 => 0x0263, 0x0111 => 0x0263, 0x0112 => 0x02d2, 0x0113 => 0x029b, 0x0114 => 0x022c, 0x0115 => 0x0263, 0x0116 => 0x0342, 0x0117 => 0x029b, 0x0118 => 0x029b, 0x0119 => 0x030a, 0x011a => 0x0190, 0x011b => 0x0263, 0x011c => 0x02d2, 0x011d => 0x0263, 0x011e => 0x0225, 0x011f => 0x02d2, 0x0120 => 0x0185, 0x0121 => 0x02d2, 0x0122 => 0x0263, 0x0123 => 0x02d2, 0x0124 => 0x0263, 0x0125 => 0x02d2, 0x0126 => 0x02d2, 0x0127 => 0x02d2, 0x0128 => 0x030a, 0x0129 => 0x01f4, 0x012a => 0x029b, 0x012b => 0x0116, 0x012c => 0x022c, 0x012d => 0x0248, 0x012e => 0x0116, 0x012f => 0x0263, 0x0130 => 0x014d, 0x0131 => 0x0248, 0x0132 => 0x0263, 0x0133 => 0x0263, 0x0134 => 0x0225, 0x0135 => 0x0263, 0x0136 => 0x0263, 0x0137 => 0x01f4, 0x0138 => 0x0263, 0x0139 => 0x014d, 0x013a => 0x0116, 0x013b => 0x022c, ); $cmapData = array( 0x20 => 0x01, 0x21 => 0x02, 0x22 => 0x03, 0x23 => 0x04, 0x24 => 0x05, 0x25 => 0x06, 0x26 => 0x07, 0x2019 => 0x08, 0x28 => 0x09, 0x29 => 0x0a, 0x2a => 0x0b, 0x2b => 0x0c, 0x2c => 0x0d, 0x2d => 0x0e, 0x2e => 0x0f, 0x2f => 0x10, 0x30 => 0x11, 0x31 => 0x12, 0x32 => 0x13, 0x33 => 0x14, 0x34 => 0x15, 0x35 => 0x16, 0x36 => 0x17, 0x37 => 0x18, 0x38 => 0x19, 0x39 => 0x1a, 0x3a => 0x1b, 0x3b => 0x1c, 0x3c => 0x1d, 0x3d => 0x1e, 0x3e => 0x1f, 0x3f => 0x20, 0x40 => 0x21, 0x41 => 0x22, 0x42 => 0x23, 0x43 => 0x24, 0x44 => 0x25, 0x45 => 0x26, 0x46 => 0x27, 0x47 => 0x28, 0x48 => 0x29, 0x49 => 0x2a, 0x4a => 0x2b, 0x4b => 0x2c, 0x4c => 0x2d, 0x4d => 0x2e, 0x4e => 0x2f, 0x4f => 0x30, 0x50 => 0x31, 0x51 => 0x32, 0x52 => 0x33, 0x53 => 0x34, 0x54 => 0x35, 0x55 => 0x36, 0x56 => 0x37, 0x57 => 0x38, 0x58 => 0x39, 0x59 => 0x3a, 0x5a => 0x3b, 0x5b => 0x3c, 0x5c => 0x3d, 0x5d => 0x3e, 0x5e => 0x3f, 0x5f => 0x40, 0x2018 => 0x41, 0x61 => 0x42, 0x62 => 0x43, 0x63 => 0x44, 0x64 => 0x45, 0x65 => 0x46, 0x66 => 0x47, 0x67 => 0x48, 0x68 => 0x49, 0x69 => 0x4a, 0x6a => 0x4b, 0x6b => 0x4c, 0x6c => 0x4d, 0x6d => 0x4e, 0x6e => 0x4f, 0x6f => 0x50, 0x70 => 0x51, 0x71 => 0x52, 0x72 => 0x53, 0x73 => 0x54, 0x74 => 0x55, 0x75 => 0x56, 0x76 => 0x57, 0x77 => 0x58, 0x78 => 0x59, 0x79 => 0x5a, 0x7a => 0x5b, 0x7b => 0x5c, 0x7c => 0x5d, 0x7d => 0x5e, 0x7e => 0x5f, 0xa1 => 0x60, 0xa2 => 0x61, 0xa3 => 0x62, 0x2044 => 0x63, 0xa5 => 0x64, 0x0192 => 0x65, 0xa7 => 0x66, 0xa4 => 0x67, 0x27 => 0x68, 0x201c => 0x69, 0xab => 0x6a, 0x2039 => 0x6b, 0x203a => 0x6c, 0xfb01 => 0x6d, 0xfb02 => 0x6e, 0x2013 => 0x6f, 0x2020 => 0x70, 0x2021 => 0x71, 0xb7 => 0x72, 0xb6 => 0x73, 0x2022 => 0x74, 0x201a => 0x75, 0x201e => 0x76, 0x201d => 0x77, 0xbb => 0x78, 0x2026 => 0x79, 0x2030 => 0x7a, 0xbf => 0x7b, 0x60 => 0x7c, 0xb4 => 0x7d, 0x02c6 => 0x7e, 0x02dc => 0x7f, 0xaf => 0x80, 0x02d8 => 0x81, 0x02d9 => 0x82, 0xa8 => 0x83, 0x02da => 0x84, 0xb8 => 0x85, 0x02dd => 0x86, 0x02db => 0x87, 0x02c7 => 0x88, 0x2014 => 0x89, 0xc6 => 0x8a, 0xaa => 0x8b, 0x0141 => 0x8c, 0xd8 => 0x8d, 0x0152 => 0x8e, 0xba => 0x8f, 0xe6 => 0x90, 0x0131 => 0x91, 0x0142 => 0x92, 0xf8 => 0x93, 0x0153 => 0x94, 0xdf => 0x95, 0xcf => 0x96, 0xe9 => 0x97, 0x0103 => 0x98, 0x0171 => 0x99, 0x011b => 0x9a, 0x0178 => 0x9b, 0xf7 => 0x9c, 0xdd => 0x9d, 0xc2 => 0x9e, 0xe1 => 0x9f, 0xdb => 0xa0, 0xfd => 0xa1, 0x0219 => 0xa2, 0xea => 0xa3, 0x016e => 0xa4, 0xdc => 0xa5, 0x0105 => 0xa6, 0xda => 0xa7, 0x0173 => 0xa8, 0xcb => 0xa9, 0x0110 => 0xaa, 0xf6c3 => 0xab, 0xa9 => 0xac, 0x0112 => 0xad, 0x010d => 0xae, 0xe5 => 0xaf, 0x0145 => 0xb0, 0x013a => 0xb1, 0xe0 => 0xb2, 0x0162 => 0xb3, 0x0106 => 0xb4, 0xe3 => 0xb5, 0x0116 => 0xb6, 0x0161 => 0xb7, 0x015f => 0xb8, 0xed => 0xb9, 0x25ca => 0xba, 0x0158 => 0xbb, 0x0122 => 0xbc, 0xfb => 0xbd, 0xe2 => 0xbe, 0x0100 => 0xbf, 0x0159 => 0xc0, 0xe7 => 0xc1, 0x017b => 0xc2, 0xde => 0xc3, 0x014c => 0xc4, 0x0154 => 0xc5, 0x015a => 0xc6, 0x010f => 0xc7, 0x016a => 0xc8, 0x016f => 0xc9, 0xb3 => 0xca, 0xd2 => 0xcb, 0xc0 => 0xcc, 0x0102 => 0xcd, 0xd7 => 0xce, 0xfa => 0xcf, 0x0164 => 0xd0, 0x2202 => 0xd1, 0xff => 0xd2, 0x0143 => 0xd3, 0xee => 0xd4, 0xca => 0xd5, 0xe4 => 0xd6, 0xeb => 0xd7, 0x0107 => 0xd8, 0x0144 => 0xd9, 0x016b => 0xda, 0x0147 => 0xdb, 0xcd => 0xdc, 0xb1 => 0xdd, 0xa6 => 0xde, 0xae => 0xdf, 0x011e => 0xe0, 0x0130 => 0xe1, 0x2211 => 0xe2, 0xc8 => 0xe3, 0x0155 => 0xe4, 0x014d => 0xe5, 0x0179 => 0xe6, 0x017d => 0xe7, 0x2265 => 0xe8, 0xd0 => 0xe9, 0xc7 => 0xea, 0x013c => 0xeb, 0x0165 => 0xec, 0x0119 => 0xed, 0x0172 => 0xee, 0xc1 => 0xef, 0xc4 => 0xf0, 0xe8 => 0xf1, 0x017a => 0xf2, 0x012f => 0xf3, 0xd3 => 0xf4, 0xf3 => 0xf5, 0x0101 => 0xf6, 0x015b => 0xf7, 0xef => 0xf8, 0xd4 => 0xf9, 0xd9 => 0xfa, 0x2206 => 0xfb, 0xfe => 0xfc, 0xb2 => 0xfd, 0xd6 => 0xfe, 0xb5 => 0xff, 0xec => 0x0100, 0x0151 => 0x0101, 0x0118 => 0x0102, 0x0111 => 0x0103, 0xbe => 0x0104, 0x015e => 0x0105, 0x013e => 0x0106, 0x0136 => 0x0107, 0x0139 => 0x0108, 0x2122 => 0x0109, 0x0117 => 0x010a, 0xcc => 0x010b, 0x012a => 0x010c, 0x013d => 0x010d, 0xbd => 0x010e, 0x2264 => 0x010f, 0xf4 => 0x0110, 0xf1 => 0x0111, 0x0170 => 0x0112, 0xc9 => 0x0113, 0x0113 => 0x0114, 0x011f => 0x0115, 0xbc => 0x0116, 0x0160 => 0x0117, 0x0218 => 0x0118, 0x0150 => 0x0119, 0xb0 => 0x011a, 0xf2 => 0x011b, 0x010c => 0x011c, 0xf9 => 0x011d, 0x221a => 0x011e, 0x010e => 0x011f, 0x0157 => 0x0120, 0xd1 => 0x0121, 0xf5 => 0x0122, 0x0156 => 0x0123, 0x013b => 0x0124, 0xc3 => 0x0125, 0x0104 => 0x0126, 0xc5 => 0x0127, 0xd5 => 0x0128, 0x017c => 0x0129, 0x011a => 0x012a, 0x012e => 0x012b, 0x0137 => 0x012c, 0x2212 => 0x012d, 0xce => 0x012e, 0x0148 => 0x012f, 0x0163 => 0x0130, 0xac => 0x0131, 0xf6 => 0x0132, 0xfc => 0x0133, 0x2260 => 0x0134, 0x0123 => 0x0135, 0xf0 => 0x0136, 0x017e => 0x0137, 0x0146 => 0x0138, 0xb9 => 0x0139, 0x012b => 0x013a, 0x20ac => 0x013b); $this->_cmap = Zend_Pdf_Cmap::cmapWithTypeData( Zend_Pdf_Cmap::TYPE_BYTE_ENCODING_STATIC, $cmapData); $this->_resource->BaseFont = new Zend_Pdf_Element_Name('Helvetica-Bold'); } }

/* @source /library/Zend/Pdf/Resource/Font/Simple/Standard/Helvetica.php */
class Zend_Pdf_Resource_Font_Simple_Standard_Helvetica extends Zend_Pdf_Resource_Font_Simple_Standard { public function __construct() { parent::__construct(); $this->_fontNames[Zend_Pdf_Font::NAME_COPYRIGHT]['en'] = "\x00\x43\x00\x6f\x00\x70\x00\x79\x00\x72\x00\x69\x00\x67\x00\x68\x00" . "\x74\x00\x20\x00\x28\x00\x63\x00\x29\x00\x20\x00\x31\x00\x39\x00" . "\x38\x00\x35\x00\x2c\x00\x20\x00\x31\x00\x39\x00\x38\x00\x37\x00" . "\x2c\x00\x20\x00\x31\x00\x39\x00\x38\x00\x39\x00\x2c\x00\x20\x00" . "\x31\x00\x39\x00\x39\x00\x30\x00\x2c\x00\x20\x00\x31\x00\x39\x00" . "\x39\x00\x37\x00\x20\x00\x41\x00\x64\x00\x6f\x00\x62\x00\x65\x00" . "\x20\x00\x53\x00\x79\x00\x73\x00\x74\x00\x65\x00\x6d\x00\x73\x00" . "\x20\x00\x49\x00\x6e\x00\x63\x00\x6f\x00\x72\x00\x70\x00\x6f\x00" . "\x72\x00\x61\x00\x74\x00\x65\x00\x64\x00\x2e\x00\x20\x00\x20\x00" . "\x41\x00\x6c\x00\x6c\x00\x20\x00\x52\x00\x69\x00\x67\x00\x68\x00" . "\x74\x00\x73\x00\x20\x00\x52\x00\x65\x00\x73\x00\x65\x00\x72\x00" . "\x76\x00\x65\x00\x64\x00\x2e\x00\x48\x00\x65\x00\x6c\x00\x76\x00" . "\x65\x00\x74\x00\x69\x00\x63\x00\x61\x00\x20\x00\x69\x00\x73\x00" . "\x20\x00\x61\x00\x20\x00\x74\x00\x72\x00\x61\x00\x64\x00\x65\x00" . "\x6d\x00\x61\x00\x72\x00\x6b\x00\x20\x00\x6f\x00\x66\x00\x20\x00" . "\x4c\x00\x69\x00\x6e\x00\x6f\x00\x74\x00\x79\x00\x70\x00\x65\x00" . "\x2d\x00\x48\x00\x65\x00\x6c\x00\x6c\x00\x20\x00\x41\x00\x47\x00" . "\x20\x00\x61\x00\x6e\x00\x64\x00\x2f\x00\x6f\x00\x72\x00\x20\x00" . "\x69\x00\x74\x00\x73\x00\x20\x00\x73\x00\x75\x00\x62\x00\x73\x00" . "\x69\x00\x64\x00\x69\x00\x61\x00\x72\x00\x69\x00\x65\x00\x73\x00" . "\x2e"; $this->_fontNames[Zend_Pdf_Font::NAME_FAMILY]['en'] = "\x00\x48\x00\x65\x00\x6c\x00\x76\x00\x65\x00\x74\x00\x69\x00\x63\x00" . "\x61"; $this->_fontNames[Zend_Pdf_Font::NAME_STYLE]['en'] = "\x00\x4d\x00\x65\x00\x64\x00\x69\x00\x75\x00\x6d"; $this->_fontNames[Zend_Pdf_Font::NAME_ID]['en'] = "\x00\x34\x00\x33\x00\x30\x00\x35\x00\x34"; $this->_fontNames[Zend_Pdf_Font::NAME_FULL]['en'] = "\x00\x48\x00\x65\x00\x6c\x00\x76\x00\x65\x00\x74\x00\x69\x00\x63\x00" . "\x61\x00\x20\x00\x4d\x00\x65\x00\x64\x00\x69\x00\x75\x00\x6d"; $this->_fontNames[Zend_Pdf_Font::NAME_VERSION]['en'] = "\x00\x30\x00\x30\x00\x32\x00\x2e\x00\x30\x00\x30\x00\x30"; $this->_fontNames[Zend_Pdf_Font::NAME_POSTSCRIPT]['en'] = "\x00\x48\x00\x65\x00\x6c\x00\x76\x00\x65\x00\x74\x00\x69\x00\x63\x00" . "\x61"; $this->_isBold = false; $this->_isItalic = false; $this->_isMonospaced = false; $this->_underlinePosition = -100; $this->_underlineThickness = 50; $this->_strikePosition = 225; $this->_strikeThickness = 50; $this->_unitsPerEm = 1000; $this->_ascent = 718; $this->_descent = -207; $this->_lineGap = 275; $this->_glyphWidths = array( 0x00 => 0x01f4, 0x01 => 0x0116, 0x02 => 0x0116, 0x03 => 0x0163, 0x04 => 0x022c, 0x05 => 0x022c, 0x06 => 0x0379, 0x07 => 0x029b, 0x08 => 0xde, 0x09 => 0x014d, 0x0a => 0x014d, 0x0b => 0x0185, 0x0c => 0x0248, 0x0d => 0x0116, 0x0e => 0x014d, 0x0f => 0x0116, 0x10 => 0x0116, 0x11 => 0x022c, 0x12 => 0x022c, 0x13 => 0x022c, 0x14 => 0x022c, 0x15 => 0x022c, 0x16 => 0x022c, 0x17 => 0x022c, 0x18 => 0x022c, 0x19 => 0x022c, 0x1a => 0x022c, 0x1b => 0x0116, 0x1c => 0x0116, 0x1d => 0x0248, 0x1e => 0x0248, 0x1f => 0x0248, 0x20 => 0x022c, 0x21 => 0x03f7, 0x22 => 0x029b, 0x23 => 0x029b, 0x24 => 0x02d2, 0x25 => 0x02d2, 0x26 => 0x029b, 0x27 => 0x0263, 0x28 => 0x030a, 0x29 => 0x02d2, 0x2a => 0x0116, 0x2b => 0x01f4, 0x2c => 0x029b, 0x2d => 0x022c, 0x2e => 0x0341, 0x2f => 0x02d2, 0x30 => 0x030a, 0x31 => 0x029b, 0x32 => 0x030a, 0x33 => 0x02d2, 0x34 => 0x029b, 0x35 => 0x0263, 0x36 => 0x02d2, 0x37 => 0x029b, 0x38 => 0x03b0, 0x39 => 0x029b, 0x3a => 0x029b, 0x3b => 0x0263, 0x3c => 0x0116, 0x3d => 0x0116, 0x3e => 0x0116, 0x3f => 0x01d5, 0x40 => 0x022c, 0x41 => 0xde, 0x42 => 0x022c, 0x43 => 0x022c, 0x44 => 0x01f4, 0x45 => 0x022c, 0x46 => 0x022c, 0x47 => 0x0116, 0x48 => 0x022c, 0x49 => 0x022c, 0x4a => 0xde, 0x4b => 0xde, 0x4c => 0x01f4, 0x4d => 0xde, 0x4e => 0x0341, 0x4f => 0x022c, 0x50 => 0x022c, 0x51 => 0x022c, 0x52 => 0x022c, 0x53 => 0x014d, 0x54 => 0x01f4, 0x55 => 0x0116, 0x56 => 0x022c, 0x57 => 0x01f4, 0x58 => 0x02d2, 0x59 => 0x01f4, 0x5a => 0x01f4, 0x5b => 0x01f4, 0x5c => 0x014e, 0x5d => 0x0104, 0x5e => 0x014e, 0x5f => 0x0248, 0x60 => 0x014d, 0x61 => 0x022c, 0x62 => 0x022c, 0x63 => 0xa7, 0x64 => 0x022c, 0x65 => 0x022c, 0x66 => 0x022c, 0x67 => 0x022c, 0x68 => 0xbf, 0x69 => 0x014d, 0x6a => 0x022c, 0x6b => 0x014d, 0x6c => 0x014d, 0x6d => 0x01f4, 0x6e => 0x01f4, 0x6f => 0x022c, 0x70 => 0x022c, 0x71 => 0x022c, 0x72 => 0x0116, 0x73 => 0x0219, 0x74 => 0x015e, 0x75 => 0xde, 0x76 => 0x014d, 0x77 => 0x014d, 0x78 => 0x022c, 0x79 => 0x03e8, 0x7a => 0x03e8, 0x7b => 0x0263, 0x7c => 0x014d, 0x7d => 0x014d, 0x7e => 0x014d, 0x7f => 0x014d, 0x80 => 0x014d, 0x81 => 0x014d, 0x82 => 0x014d, 0x83 => 0x014d, 0x84 => 0x014d, 0x85 => 0x014d, 0x86 => 0x014d, 0x87 => 0x014d, 0x88 => 0x014d, 0x89 => 0x03e8, 0x8a => 0x03e8, 0x8b => 0x0172, 0x8c => 0x022c, 0x8d => 0x030a, 0x8e => 0x03e8, 0x8f => 0x016d, 0x90 => 0x0379, 0x91 => 0x0116, 0x92 => 0xde, 0x93 => 0x0263, 0x94 => 0x03b0, 0x95 => 0x0263, 0x96 => 0x0116, 0x97 => 0x022c, 0x98 => 0x022c, 0x99 => 0x022c, 0x9a => 0x022c, 0x9b => 0x029b, 0x9c => 0x0248, 0x9d => 0x029b, 0x9e => 0x029b, 0x9f => 0x022c, 0xa0 => 0x02d2, 0xa1 => 0x01f4, 0xa2 => 0x01f4, 0xa3 => 0x022c, 0xa4 => 0x02d2, 0xa5 => 0x02d2, 0xa6 => 0x022c, 0xa7 => 0x02d2, 0xa8 => 0x022c, 0xa9 => 0x029b, 0xaa => 0x02d2, 0xab => 0xfa, 0xac => 0x02e1, 0xad => 0x029b, 0xae => 0x01f4, 0xaf => 0x022c, 0xb0 => 0x02d2, 0xb1 => 0xde, 0xb2 => 0x022c, 0xb3 => 0x0263, 0xb4 => 0x02d2, 0xb5 => 0x022c, 0xb6 => 0x029b, 0xb7 => 0x01f4, 0xb8 => 0x01f4, 0xb9 => 0x0116, 0xba => 0x01d7, 0xbb => 0x02d2, 0xbc => 0x030a, 0xbd => 0x022c, 0xbe => 0x022c, 0xbf => 0x029b, 0xc0 => 0x014d, 0xc1 => 0x01f4, 0xc2 => 0x0263, 0xc3 => 0x029b, 0xc4 => 0x030a, 0xc5 => 0x02d2, 0xc6 => 0x029b, 0xc7 => 0x0283, 0xc8 => 0x02d2, 0xc9 => 0x022c, 0xca => 0x014d, 0xcb => 0x030a, 0xcc => 0x029b, 0xcd => 0x029b, 0xce => 0x0248, 0xcf => 0x022c, 0xd0 => 0x0263, 0xd1 => 0x01dc, 0xd2 => 0x01f4, 0xd3 => 0x02d2, 0xd4 => 0x0116, 0xd5 => 0x029b, 0xd6 => 0x022c, 0xd7 => 0x022c, 0xd8 => 0x01f4, 0xd9 => 0x022c, 0xda => 0x022c, 0xdb => 0x02d2, 0xdc => 0x0116, 0xdd => 0x0248, 0xde => 0x0104, 0xdf => 0x02e1, 0xe0 => 0x030a, 0xe1 => 0x0116, 0xe2 => 0x0258, 0xe3 => 0x029b, 0xe4 => 0x014d, 0xe5 => 0x022c, 0xe6 => 0x0263, 0xe7 => 0x0263, 0xe8 => 0x0225, 0xe9 => 0x02d2, 0xea => 0x02d2, 0xeb => 0xde, 0xec => 0x013d, 0xed => 0x022c, 0xee => 0x02d2, 0xef => 0x029b, 0xf0 => 0x029b, 0xf1 => 0x022c, 0xf2 => 0x01f4, 0xf3 => 0xde, 0xf4 => 0x030a, 0xf5 => 0x022c, 0xf6 => 0x022c, 0xf7 => 0x01f4, 0xf8 => 0x0116, 0xf9 => 0x030a, 0xfa => 0x02d2, 0xfb => 0x0264, 0xfc => 0x022c, 0xfd => 0x014d, 0xfe => 0x030a, 0xff => 0x022c, 0x0100 => 0x0116, 0x0101 => 0x022c, 0x0102 => 0x029b, 0x0103 => 0x022c, 0x0104 => 0x0342, 0x0105 => 0x029b, 0x0106 => 0x012b, 0x0107 => 0x029b, 0x0108 => 0x022c, 0x0109 => 0x03e8, 0x010a => 0x022c, 0x010b => 0x0116, 0x010c => 0x0116, 0x010d => 0x022c, 0x010e => 0x0342, 0x010f => 0x0225, 0x0110 => 0x022c, 0x0111 => 0x022c, 0x0112 => 0x02d2, 0x0113 => 0x029b, 0x0114 => 0x022c, 0x0115 => 0x022c, 0x0116 => 0x0342, 0x0117 => 0x029b, 0x0118 => 0x029b, 0x0119 => 0x030a, 0x011a => 0x0190, 0x011b => 0x022c, 0x011c => 0x02d2, 0x011d => 0x022c, 0x011e => 0x01c5, 0x011f => 0x02d2, 0x0120 => 0x014d, 0x0121 => 0x02d2, 0x0122 => 0x022c, 0x0123 => 0x02d2, 0x0124 => 0x022c, 0x0125 => 0x029b, 0x0126 => 0x029b, 0x0127 => 0x029b, 0x0128 => 0x030a, 0x0129 => 0x01f4, 0x012a => 0x029b, 0x012b => 0x0116, 0x012c => 0x01f4, 0x012d => 0x0248, 0x012e => 0x0116, 0x012f => 0x022c, 0x0130 => 0x0116, 0x0131 => 0x0248, 0x0132 => 0x022c, 0x0133 => 0x022c, 0x0134 => 0x0225, 0x0135 => 0x022c, 0x0136 => 0x022c, 0x0137 => 0x01f4, 0x0138 => 0x022c, 0x0139 => 0x014d, 0x013a => 0x0116, 0x013b => 0x022c, ); $cmapData = array( 0x20 => 0x01, 0x21 => 0x02, 0x22 => 0x03, 0x23 => 0x04, 0x24 => 0x05, 0x25 => 0x06, 0x26 => 0x07, 0x2019 => 0x08, 0x28 => 0x09, 0x29 => 0x0a, 0x2a => 0x0b, 0x2b => 0x0c, 0x2c => 0x0d, 0x2d => 0x0e, 0x2e => 0x0f, 0x2f => 0x10, 0x30 => 0x11, 0x31 => 0x12, 0x32 => 0x13, 0x33 => 0x14, 0x34 => 0x15, 0x35 => 0x16, 0x36 => 0x17, 0x37 => 0x18, 0x38 => 0x19, 0x39 => 0x1a, 0x3a => 0x1b, 0x3b => 0x1c, 0x3c => 0x1d, 0x3d => 0x1e, 0x3e => 0x1f, 0x3f => 0x20, 0x40 => 0x21, 0x41 => 0x22, 0x42 => 0x23, 0x43 => 0x24, 0x44 => 0x25, 0x45 => 0x26, 0x46 => 0x27, 0x47 => 0x28, 0x48 => 0x29, 0x49 => 0x2a, 0x4a => 0x2b, 0x4b => 0x2c, 0x4c => 0x2d, 0x4d => 0x2e, 0x4e => 0x2f, 0x4f => 0x30, 0x50 => 0x31, 0x51 => 0x32, 0x52 => 0x33, 0x53 => 0x34, 0x54 => 0x35, 0x55 => 0x36, 0x56 => 0x37, 0x57 => 0x38, 0x58 => 0x39, 0x59 => 0x3a, 0x5a => 0x3b, 0x5b => 0x3c, 0x5c => 0x3d, 0x5d => 0x3e, 0x5e => 0x3f, 0x5f => 0x40, 0x2018 => 0x41, 0x61 => 0x42, 0x62 => 0x43, 0x63 => 0x44, 0x64 => 0x45, 0x65 => 0x46, 0x66 => 0x47, 0x67 => 0x48, 0x68 => 0x49, 0x69 => 0x4a, 0x6a => 0x4b, 0x6b => 0x4c, 0x6c => 0x4d, 0x6d => 0x4e, 0x6e => 0x4f, 0x6f => 0x50, 0x70 => 0x51, 0x71 => 0x52, 0x72 => 0x53, 0x73 => 0x54, 0x74 => 0x55, 0x75 => 0x56, 0x76 => 0x57, 0x77 => 0x58, 0x78 => 0x59, 0x79 => 0x5a, 0x7a => 0x5b, 0x7b => 0x5c, 0x7c => 0x5d, 0x7d => 0x5e, 0x7e => 0x5f, 0xa1 => 0x60, 0xa2 => 0x61, 0xa3 => 0x62, 0x2044 => 0x63, 0xa5 => 0x64, 0x0192 => 0x65, 0xa7 => 0x66, 0xa4 => 0x67, 0x27 => 0x68, 0x201c => 0x69, 0xab => 0x6a, 0x2039 => 0x6b, 0x203a => 0x6c, 0xfb01 => 0x6d, 0xfb02 => 0x6e, 0x2013 => 0x6f, 0x2020 => 0x70, 0x2021 => 0x71, 0xb7 => 0x72, 0xb6 => 0x73, 0x2022 => 0x74, 0x201a => 0x75, 0x201e => 0x76, 0x201d => 0x77, 0xbb => 0x78, 0x2026 => 0x79, 0x2030 => 0x7a, 0xbf => 0x7b, 0x60 => 0x7c, 0xb4 => 0x7d, 0x02c6 => 0x7e, 0x02dc => 0x7f, 0xaf => 0x80, 0x02d8 => 0x81, 0x02d9 => 0x82, 0xa8 => 0x83, 0x02da => 0x84, 0xb8 => 0x85, 0x02dd => 0x86, 0x02db => 0x87, 0x02c7 => 0x88, 0x2014 => 0x89, 0xc6 => 0x8a, 0xaa => 0x8b, 0x0141 => 0x8c, 0xd8 => 0x8d, 0x0152 => 0x8e, 0xba => 0x8f, 0xe6 => 0x90, 0x0131 => 0x91, 0x0142 => 0x92, 0xf8 => 0x93, 0x0153 => 0x94, 0xdf => 0x95, 0xcf => 0x96, 0xe9 => 0x97, 0x0103 => 0x98, 0x0171 => 0x99, 0x011b => 0x9a, 0x0178 => 0x9b, 0xf7 => 0x9c, 0xdd => 0x9d, 0xc2 => 0x9e, 0xe1 => 0x9f, 0xdb => 0xa0, 0xfd => 0xa1, 0x0219 => 0xa2, 0xea => 0xa3, 0x016e => 0xa4, 0xdc => 0xa5, 0x0105 => 0xa6, 0xda => 0xa7, 0x0173 => 0xa8, 0xcb => 0xa9, 0x0110 => 0xaa, 0xf6c3 => 0xab, 0xa9 => 0xac, 0x0112 => 0xad, 0x010d => 0xae, 0xe5 => 0xaf, 0x0145 => 0xb0, 0x013a => 0xb1, 0xe0 => 0xb2, 0x0162 => 0xb3, 0x0106 => 0xb4, 0xe3 => 0xb5, 0x0116 => 0xb6, 0x0161 => 0xb7, 0x015f => 0xb8, 0xed => 0xb9, 0x25ca => 0xba, 0x0158 => 0xbb, 0x0122 => 0xbc, 0xfb => 0xbd, 0xe2 => 0xbe, 0x0100 => 0xbf, 0x0159 => 0xc0, 0xe7 => 0xc1, 0x017b => 0xc2, 0xde => 0xc3, 0x014c => 0xc4, 0x0154 => 0xc5, 0x015a => 0xc6, 0x010f => 0xc7, 0x016a => 0xc8, 0x016f => 0xc9, 0xb3 => 0xca, 0xd2 => 0xcb, 0xc0 => 0xcc, 0x0102 => 0xcd, 0xd7 => 0xce, 0xfa => 0xcf, 0x0164 => 0xd0, 0x2202 => 0xd1, 0xff => 0xd2, 0x0143 => 0xd3, 0xee => 0xd4, 0xca => 0xd5, 0xe4 => 0xd6, 0xeb => 0xd7, 0x0107 => 0xd8, 0x0144 => 0xd9, 0x016b => 0xda, 0x0147 => 0xdb, 0xcd => 0xdc, 0xb1 => 0xdd, 0xa6 => 0xde, 0xae => 0xdf, 0x011e => 0xe0, 0x0130 => 0xe1, 0x2211 => 0xe2, 0xc8 => 0xe3, 0x0155 => 0xe4, 0x014d => 0xe5, 0x0179 => 0xe6, 0x017d => 0xe7, 0x2265 => 0xe8, 0xd0 => 0xe9, 0xc7 => 0xea, 0x013c => 0xeb, 0x0165 => 0xec, 0x0119 => 0xed, 0x0172 => 0xee, 0xc1 => 0xef, 0xc4 => 0xf0, 0xe8 => 0xf1, 0x017a => 0xf2, 0x012f => 0xf3, 0xd3 => 0xf4, 0xf3 => 0xf5, 0x0101 => 0xf6, 0x015b => 0xf7, 0xef => 0xf8, 0xd4 => 0xf9, 0xd9 => 0xfa, 0x2206 => 0xfb, 0xfe => 0xfc, 0xb2 => 0xfd, 0xd6 => 0xfe, 0xb5 => 0xff, 0xec => 0x0100, 0x0151 => 0x0101, 0x0118 => 0x0102, 0x0111 => 0x0103, 0xbe => 0x0104, 0x015e => 0x0105, 0x013e => 0x0106, 0x0136 => 0x0107, 0x0139 => 0x0108, 0x2122 => 0x0109, 0x0117 => 0x010a, 0xcc => 0x010b, 0x012a => 0x010c, 0x013d => 0x010d, 0xbd => 0x010e, 0x2264 => 0x010f, 0xf4 => 0x0110, 0xf1 => 0x0111, 0x0170 => 0x0112, 0xc9 => 0x0113, 0x0113 => 0x0114, 0x011f => 0x0115, 0xbc => 0x0116, 0x0160 => 0x0117, 0x0218 => 0x0118, 0x0150 => 0x0119, 0xb0 => 0x011a, 0xf2 => 0x011b, 0x010c => 0x011c, 0xf9 => 0x011d, 0x221a => 0x011e, 0x010e => 0x011f, 0x0157 => 0x0120, 0xd1 => 0x0121, 0xf5 => 0x0122, 0x0156 => 0x0123, 0x013b => 0x0124, 0xc3 => 0x0125, 0x0104 => 0x0126, 0xc5 => 0x0127, 0xd5 => 0x0128, 0x017c => 0x0129, 0x011a => 0x012a, 0x012e => 0x012b, 0x0137 => 0x012c, 0x2212 => 0x012d, 0xce => 0x012e, 0x0148 => 0x012f, 0x0163 => 0x0130, 0xac => 0x0131, 0xf6 => 0x0132, 0xfc => 0x0133, 0x2260 => 0x0134, 0x0123 => 0x0135, 0xf0 => 0x0136, 0x017e => 0x0137, 0x0146 => 0x0138, 0xb9 => 0x0139, 0x012b => 0x013a, 0x20ac => 0x013b); $this->_cmap = Zend_Pdf_Cmap::cmapWithTypeData( Zend_Pdf_Cmap::TYPE_BYTE_ENCODING_STATIC, $cmapData); $this->_resource->BaseFont = new Zend_Pdf_Element_Name('Helvetica'); } }

/* @source /library/Zend/Pdf/Resource/Font/Simple/Standard/TimesBold.php */
class Zend_Pdf_Resource_Font_Simple_Standard_TimesBold extends Zend_Pdf_Resource_Font_Simple_Standard { public function __construct() { parent::__construct(); $this->_fontNames[Zend_Pdf_Font::NAME_COPYRIGHT]['en'] = "\x00\x43\x00\x6f\x00\x70\x00\x79\x00\x72\x00\x69\x00\x67\x00\x68\x00" . "\x74\x00\x20\x00\x28\x00\x63\x00\x29\x00\x20\x00\x31\x00\x39\x00" . "\x38\x00\x35\x00\x2c\x00\x20\x00\x31\x00\x39\x00\x38\x00\x37\x00" . "\x2c\x00\x20\x00\x31\x00\x39\x00\x38\x00\x39\x00\x2c\x00\x20\x00" . "\x31\x00\x39\x00\x39\x00\x30\x00\x2c\x00\x20\x00\x31\x00\x39\x00" . "\x39\x00\x33\x00\x2c\x00\x20\x00\x31\x00\x39\x00\x39\x00\x37\x00" . "\x20\x00\x41\x00\x64\x00\x6f\x00\x62\x00\x65\x00\x20\x00\x53\x00" . "\x79\x00\x73\x00\x74\x00\x65\x00\x6d\x00\x73\x00\x20\x00\x49\x00" . "\x6e\x00\x63\x00\x6f\x00\x72\x00\x70\x00\x6f\x00\x72\x00\x61\x00" . "\x74\x00\x65\x00\x64\x00\x2e\x00\x20\x00\x20\x00\x41\x00\x6c\x00" . "\x6c\x00\x20\x00\x52\x00\x69\x00\x67\x00\x68\x00\x74\x00\x73\x00" . "\x20\x00\x52\x00\x65\x00\x73\x00\x65\x00\x72\x00\x76\x00\x65\x00" . "\x64\x00\x2e\x00\x54\x00\x69\x00\x6d\x00\x65\x00\x73\x00\x20\x00" . "\x69\x00\x73\x00\x20\x00\x61\x00\x20\x00\x74\x00\x72\x00\x61\x00" . "\x64\x00\x65\x00\x6d\x00\x61\x00\x72\x00\x6b\x00\x20\x00\x6f\x00" . "\x66\x00\x20\x00\x4c\x00\x69\x00\x6e\x00\x6f\x00\x74\x00\x79\x00" . "\x70\x00\x65\x00\x2d\x00\x48\x00\x65\x00\x6c\x00\x6c\x00\x20\x00" . "\x41\x00\x47\x00\x20\x00\x61\x00\x6e\x00\x64\x00\x2f\x00\x6f\x00" . "\x72\x00\x20\x00\x69\x00\x74\x00\x73\x00\x20\x00\x73\x00\x75\x00" . "\x62\x00\x73\x00\x69\x00\x64\x00\x69\x00\x61\x00\x72\x00\x69\x00" . "\x65\x00\x73\x00\x2e"; $this->_fontNames[Zend_Pdf_Font::NAME_FAMILY]['en'] = "\x00\x54\x00\x69\x00\x6d\x00\x65\x00\x73"; $this->_fontNames[Zend_Pdf_Font::NAME_STYLE]['en'] = "\x00\x42\x00\x6f\x00\x6c\x00\x64"; $this->_fontNames[Zend_Pdf_Font::NAME_ID]['en'] = "\x00\x34\x00\x33\x00\x30\x00\x36\x00\x35"; $this->_fontNames[Zend_Pdf_Font::NAME_FULL]['en'] = "\x00\x54\x00\x69\x00\x6d\x00\x65\x00\x73\x00\x2d\x00\x42\x00\x6f\x00" . "\x6c\x00\x64\x00\x20\x00\x42\x00\x6f\x00\x6c\x00\x64"; $this->_fontNames[Zend_Pdf_Font::NAME_VERSION]['en'] = "\x00\x30\x00\x30\x00\x32\x00\x2e\x00\x30\x00\x30\x00\x30"; $this->_fontNames[Zend_Pdf_Font::NAME_POSTSCRIPT]['en'] = "\x00\x54\x00\x69\x00\x6d\x00\x65\x00\x73\x00\x2d\x00\x42\x00\x6f\x00" . "\x6c\x00\x64"; $this->_isBold = true; $this->_isItalic = false; $this->_isMonospaced = false; $this->_underlinePosition = -100; $this->_underlineThickness = 50; $this->_strikePosition = 225; $this->_strikeThickness = 50; $this->_unitsPerEm = 1000; $this->_ascent = 683; $this->_descent = -217; $this->_lineGap = 300; $this->_glyphWidths = array( 0x00 => 0x01f4, 0x01 => 0xfa, 0x02 => 0x014d, 0x03 => 0x022b, 0x04 => 0x01f4, 0x05 => 0x01f4, 0x06 => 0x03e8, 0x07 => 0x0341, 0x08 => 0x014d, 0x09 => 0x014d, 0x0a => 0x014d, 0x0b => 0x01f4, 0x0c => 0x023a, 0x0d => 0xfa, 0x0e => 0x014d, 0x0f => 0xfa, 0x10 => 0x0116, 0x11 => 0x01f4, 0x12 => 0x01f4, 0x13 => 0x01f4, 0x14 => 0x01f4, 0x15 => 0x01f4, 0x16 => 0x01f4, 0x17 => 0x01f4, 0x18 => 0x01f4, 0x19 => 0x01f4, 0x1a => 0x01f4, 0x1b => 0x014d, 0x1c => 0x014d, 0x1d => 0x023a, 0x1e => 0x023a, 0x1f => 0x023a, 0x20 => 0x01f4, 0x21 => 0x03a2, 0x22 => 0x02d2, 0x23 => 0x029b, 0x24 => 0x02d2, 0x25 => 0x02d2, 0x26 => 0x029b, 0x27 => 0x0263, 0x28 => 0x030a, 0x29 => 0x030a, 0x2a => 0x0185, 0x2b => 0x01f4, 0x2c => 0x030a, 0x2d => 0x029b, 0x2e => 0x03b0, 0x2f => 0x02d2, 0x30 => 0x030a, 0x31 => 0x0263, 0x32 => 0x030a, 0x33 => 0x02d2, 0x34 => 0x022c, 0x35 => 0x029b, 0x36 => 0x02d2, 0x37 => 0x02d2, 0x38 => 0x03e8, 0x39 => 0x02d2, 0x3a => 0x02d2, 0x3b => 0x029b, 0x3c => 0x014d, 0x3d => 0x0116, 0x3e => 0x014d, 0x3f => 0x0245, 0x40 => 0x01f4, 0x41 => 0x014d, 0x42 => 0x01f4, 0x43 => 0x022c, 0x44 => 0x01bc, 0x45 => 0x022c, 0x46 => 0x01bc, 0x47 => 0x014d, 0x48 => 0x01f4, 0x49 => 0x022c, 0x4a => 0x0116, 0x4b => 0x014d, 0x4c => 0x022c, 0x4d => 0x0116, 0x4e => 0x0341, 0x4f => 0x022c, 0x50 => 0x01f4, 0x51 => 0x022c, 0x52 => 0x022c, 0x53 => 0x01bc, 0x54 => 0x0185, 0x55 => 0x014d, 0x56 => 0x022c, 0x57 => 0x01f4, 0x58 => 0x02d2, 0x59 => 0x01f4, 0x5a => 0x01f4, 0x5b => 0x01bc, 0x5c => 0x018a, 0x5d => 0xdc, 0x5e => 0x018a, 0x5f => 0x0208, 0x60 => 0x014d, 0x61 => 0x01f4, 0x62 => 0x01f4, 0x63 => 0xa7, 0x64 => 0x01f4, 0x65 => 0x01f4, 0x66 => 0x01f4, 0x67 => 0x01f4, 0x68 => 0x0116, 0x69 => 0x01f4, 0x6a => 0x01f4, 0x6b => 0x014d, 0x6c => 0x014d, 0x6d => 0x022c, 0x6e => 0x022c, 0x6f => 0x01f4, 0x70 => 0x01f4, 0x71 => 0x01f4, 0x72 => 0xfa, 0x73 => 0x021c, 0x74 => 0x015e, 0x75 => 0x014d, 0x76 => 0x01f4, 0x77 => 0x01f4, 0x78 => 0x01f4, 0x79 => 0x03e8, 0x7a => 0x03e8, 0x7b => 0x01f4, 0x7c => 0x014d, 0x7d => 0x014d, 0x7e => 0x014d, 0x7f => 0x014d, 0x80 => 0x014d, 0x81 => 0x014d, 0x82 => 0x014d, 0x83 => 0x014d, 0x84 => 0x014d, 0x85 => 0x014d, 0x86 => 0x014d, 0x87 => 0x014d, 0x88 => 0x014d, 0x89 => 0x03e8, 0x8a => 0x03e8, 0x8b => 0x012c, 0x8c => 0x029b, 0x8d => 0x030a, 0x8e => 0x03e8, 0x8f => 0x014a, 0x90 => 0x02d2, 0x91 => 0x0116, 0x92 => 0x0116, 0x93 => 0x01f4, 0x94 => 0x02d2, 0x95 => 0x022c, 0x96 => 0x0185, 0x97 => 0x01bc, 0x98 => 0x01f4, 0x99 => 0x022c, 0x9a => 0x01bc, 0x9b => 0x02d2, 0x9c => 0x023a, 0x9d => 0x02d2, 0x9e => 0x02d2, 0x9f => 0x01f4, 0xa0 => 0x02d2, 0xa1 => 0x01f4, 0xa2 => 0x0185, 0xa3 => 0x01bc, 0xa4 => 0x02d2, 0xa5 => 0x02d2, 0xa6 => 0x01f4, 0xa7 => 0x02d2, 0xa8 => 0x022c, 0xa9 => 0x029b, 0xaa => 0x02d2, 0xab => 0xfa, 0xac => 0x02eb, 0xad => 0x029b, 0xae => 0x01bc, 0xaf => 0x01f4, 0xb0 => 0x02d2, 0xb1 => 0x0116, 0xb2 => 0x01f4, 0xb3 => 0x029b, 0xb4 => 0x02d2, 0xb5 => 0x01f4, 0xb6 => 0x029b, 0xb7 => 0x0185, 0xb8 => 0x0185, 0xb9 => 0x0116, 0xba => 0x01ee, 0xbb => 0x02d2, 0xbc => 0x030a, 0xbd => 0x022c, 0xbe => 0x01f4, 0xbf => 0x02d2, 0xc0 => 0x01bc, 0xc1 => 0x01bc, 0xc2 => 0x029b, 0xc3 => 0x0263, 0xc4 => 0x030a, 0xc5 => 0x02d2, 0xc6 => 0x022c, 0xc7 => 0x02a0, 0xc8 => 0x02d2, 0xc9 => 0x022c, 0xca => 0x012c, 0xcb => 0x030a, 0xcc => 0x02d2, 0xcd => 0x02d2, 0xce => 0x023a, 0xcf => 0x022c, 0xd0 => 0x029b, 0xd1 => 0x01ee, 0xd2 => 0x01f4, 0xd3 => 0x02d2, 0xd4 => 0x0116, 0xd5 => 0x029b, 0xd6 => 0x01f4, 0xd7 => 0x01bc, 0xd8 => 0x01bc, 0xd9 => 0x022c, 0xda => 0x022c, 0xdb => 0x02d2, 0xdc => 0x0185, 0xdd => 0x023a, 0xde => 0xdc, 0xdf => 0x02eb, 0xe0 => 0x030a, 0xe1 => 0x0185, 0xe2 => 0x0258, 0xe3 => 0x029b, 0xe4 => 0x01bc, 0xe5 => 0x01f4, 0xe6 => 0x029b, 0xe7 => 0x029b, 0xe8 => 0x0225, 0xe9 => 0x02d2, 0xea => 0x02d2, 0xeb => 0x0116, 0xec => 0x01a0, 0xed => 0x01bc, 0xee => 0x02d2, 0xef => 0x02d2, 0xf0 => 0x02d2, 0xf1 => 0x01bc, 0xf2 => 0x01bc, 0xf3 => 0x0116, 0xf4 => 0x030a, 0xf5 => 0x01f4, 0xf6 => 0x01f4, 0xf7 => 0x0185, 0xf8 => 0x0116, 0xf9 => 0x030a, 0xfa => 0x02d2, 0xfb => 0x0264, 0xfc => 0x022c, 0xfd => 0x012c, 0xfe => 0x030a, 0xff => 0x022c, 0x0100 => 0x0116, 0x0101 => 0x01f4, 0x0102 => 0x029b, 0x0103 => 0x022c, 0x0104 => 0x02ee, 0x0105 => 0x022c, 0x0106 => 0x018a, 0x0107 => 0x030a, 0x0108 => 0x029b, 0x0109 => 0x03e8, 0x010a => 0x01bc, 0x010b => 0x0185, 0x010c => 0x0185, 0x010d => 0x029b, 0x010e => 0x02ee, 0x010f => 0x0225, 0x0110 => 0x01f4, 0x0111 => 0x022c, 0x0112 => 0x02d2, 0x0113 => 0x029b, 0x0114 => 0x01bc, 0x0115 => 0x01f4, 0x0116 => 0x02ee, 0x0117 => 0x022c, 0x0118 => 0x022c, 0x0119 => 0x030a, 0x011a => 0x0190, 0x011b => 0x01f4, 0x011c => 0x02d2, 0x011d => 0x022c, 0x011e => 0x0225, 0x011f => 0x02d2, 0x0120 => 0x01bc, 0x0121 => 0x02d2, 0x0122 => 0x01f4, 0x0123 => 0x02d2, 0x0124 => 0x029b, 0x0125 => 0x02d2, 0x0126 => 0x02d2, 0x0127 => 0x02d2, 0x0128 => 0x030a, 0x0129 => 0x01bc, 0x012a => 0x029b, 0x012b => 0x0185, 0x012c => 0x022c, 0x012d => 0x023a, 0x012e => 0x0185, 0x012f => 0x022c, 0x0130 => 0x014d, 0x0131 => 0x023a, 0x0132 => 0x01f4, 0x0133 => 0x022c, 0x0134 => 0x0225, 0x0135 => 0x01f4, 0x0136 => 0x01f4, 0x0137 => 0x01bc, 0x0138 => 0x022c, 0x0139 => 0x012c, 0x013a => 0x0116, 0x013b => 0x01f4, ); $cmapData = array( 0x20 => 0x01, 0x21 => 0x02, 0x22 => 0x03, 0x23 => 0x04, 0x24 => 0x05, 0x25 => 0x06, 0x26 => 0x07, 0x2019 => 0x08, 0x28 => 0x09, 0x29 => 0x0a, 0x2a => 0x0b, 0x2b => 0x0c, 0x2c => 0x0d, 0x2d => 0x0e, 0x2e => 0x0f, 0x2f => 0x10, 0x30 => 0x11, 0x31 => 0x12, 0x32 => 0x13, 0x33 => 0x14, 0x34 => 0x15, 0x35 => 0x16, 0x36 => 0x17, 0x37 => 0x18, 0x38 => 0x19, 0x39 => 0x1a, 0x3a => 0x1b, 0x3b => 0x1c, 0x3c => 0x1d, 0x3d => 0x1e, 0x3e => 0x1f, 0x3f => 0x20, 0x40 => 0x21, 0x41 => 0x22, 0x42 => 0x23, 0x43 => 0x24, 0x44 => 0x25, 0x45 => 0x26, 0x46 => 0x27, 0x47 => 0x28, 0x48 => 0x29, 0x49 => 0x2a, 0x4a => 0x2b, 0x4b => 0x2c, 0x4c => 0x2d, 0x4d => 0x2e, 0x4e => 0x2f, 0x4f => 0x30, 0x50 => 0x31, 0x51 => 0x32, 0x52 => 0x33, 0x53 => 0x34, 0x54 => 0x35, 0x55 => 0x36, 0x56 => 0x37, 0x57 => 0x38, 0x58 => 0x39, 0x59 => 0x3a, 0x5a => 0x3b, 0x5b => 0x3c, 0x5c => 0x3d, 0x5d => 0x3e, 0x5e => 0x3f, 0x5f => 0x40, 0x2018 => 0x41, 0x61 => 0x42, 0x62 => 0x43, 0x63 => 0x44, 0x64 => 0x45, 0x65 => 0x46, 0x66 => 0x47, 0x67 => 0x48, 0x68 => 0x49, 0x69 => 0x4a, 0x6a => 0x4b, 0x6b => 0x4c, 0x6c => 0x4d, 0x6d => 0x4e, 0x6e => 0x4f, 0x6f => 0x50, 0x70 => 0x51, 0x71 => 0x52, 0x72 => 0x53, 0x73 => 0x54, 0x74 => 0x55, 0x75 => 0x56, 0x76 => 0x57, 0x77 => 0x58, 0x78 => 0x59, 0x79 => 0x5a, 0x7a => 0x5b, 0x7b => 0x5c, 0x7c => 0x5d, 0x7d => 0x5e, 0x7e => 0x5f, 0xa1 => 0x60, 0xa2 => 0x61, 0xa3 => 0x62, 0x2044 => 0x63, 0xa5 => 0x64, 0x0192 => 0x65, 0xa7 => 0x66, 0xa4 => 0x67, 0x27 => 0x68, 0x201c => 0x69, 0xab => 0x6a, 0x2039 => 0x6b, 0x203a => 0x6c, 0xfb01 => 0x6d, 0xfb02 => 0x6e, 0x2013 => 0x6f, 0x2020 => 0x70, 0x2021 => 0x71, 0xb7 => 0x72, 0xb6 => 0x73, 0x2022 => 0x74, 0x201a => 0x75, 0x201e => 0x76, 0x201d => 0x77, 0xbb => 0x78, 0x2026 => 0x79, 0x2030 => 0x7a, 0xbf => 0x7b, 0x60 => 0x7c, 0xb4 => 0x7d, 0x02c6 => 0x7e, 0x02dc => 0x7f, 0xaf => 0x80, 0x02d8 => 0x81, 0x02d9 => 0x82, 0xa8 => 0x83, 0x02da => 0x84, 0xb8 => 0x85, 0x02dd => 0x86, 0x02db => 0x87, 0x02c7 => 0x88, 0x2014 => 0x89, 0xc6 => 0x8a, 0xaa => 0x8b, 0x0141 => 0x8c, 0xd8 => 0x8d, 0x0152 => 0x8e, 0xba => 0x8f, 0xe6 => 0x90, 0x0131 => 0x91, 0x0142 => 0x92, 0xf8 => 0x93, 0x0153 => 0x94, 0xdf => 0x95, 0xcf => 0x96, 0xe9 => 0x97, 0x0103 => 0x98, 0x0171 => 0x99, 0x011b => 0x9a, 0x0178 => 0x9b, 0xf7 => 0x9c, 0xdd => 0x9d, 0xc2 => 0x9e, 0xe1 => 0x9f, 0xdb => 0xa0, 0xfd => 0xa1, 0x0219 => 0xa2, 0xea => 0xa3, 0x016e => 0xa4, 0xdc => 0xa5, 0x0105 => 0xa6, 0xda => 0xa7, 0x0173 => 0xa8, 0xcb => 0xa9, 0x0110 => 0xaa, 0xf6c3 => 0xab, 0xa9 => 0xac, 0x0112 => 0xad, 0x010d => 0xae, 0xe5 => 0xaf, 0x0145 => 0xb0, 0x013a => 0xb1, 0xe0 => 0xb2, 0x0162 => 0xb3, 0x0106 => 0xb4, 0xe3 => 0xb5, 0x0116 => 0xb6, 0x0161 => 0xb7, 0x015f => 0xb8, 0xed => 0xb9, 0x25ca => 0xba, 0x0158 => 0xbb, 0x0122 => 0xbc, 0xfb => 0xbd, 0xe2 => 0xbe, 0x0100 => 0xbf, 0x0159 => 0xc0, 0xe7 => 0xc1, 0x017b => 0xc2, 0xde => 0xc3, 0x014c => 0xc4, 0x0154 => 0xc5, 0x015a => 0xc6, 0x010f => 0xc7, 0x016a => 0xc8, 0x016f => 0xc9, 0xb3 => 0xca, 0xd2 => 0xcb, 0xc0 => 0xcc, 0x0102 => 0xcd, 0xd7 => 0xce, 0xfa => 0xcf, 0x0164 => 0xd0, 0x2202 => 0xd1, 0xff => 0xd2, 0x0143 => 0xd3, 0xee => 0xd4, 0xca => 0xd5, 0xe4 => 0xd6, 0xeb => 0xd7, 0x0107 => 0xd8, 0x0144 => 0xd9, 0x016b => 0xda, 0x0147 => 0xdb, 0xcd => 0xdc, 0xb1 => 0xdd, 0xa6 => 0xde, 0xae => 0xdf, 0x011e => 0xe0, 0x0130 => 0xe1, 0x2211 => 0xe2, 0xc8 => 0xe3, 0x0155 => 0xe4, 0x014d => 0xe5, 0x0179 => 0xe6, 0x017d => 0xe7, 0x2265 => 0xe8, 0xd0 => 0xe9, 0xc7 => 0xea, 0x013c => 0xeb, 0x0165 => 0xec, 0x0119 => 0xed, 0x0172 => 0xee, 0xc1 => 0xef, 0xc4 => 0xf0, 0xe8 => 0xf1, 0x017a => 0xf2, 0x012f => 0xf3, 0xd3 => 0xf4, 0xf3 => 0xf5, 0x0101 => 0xf6, 0x015b => 0xf7, 0xef => 0xf8, 0xd4 => 0xf9, 0xd9 => 0xfa, 0x2206 => 0xfb, 0xfe => 0xfc, 0xb2 => 0xfd, 0xd6 => 0xfe, 0xb5 => 0xff, 0xec => 0x0100, 0x0151 => 0x0101, 0x0118 => 0x0102, 0x0111 => 0x0103, 0xbe => 0x0104, 0x015e => 0x0105, 0x013e => 0x0106, 0x0136 => 0x0107, 0x0139 => 0x0108, 0x2122 => 0x0109, 0x0117 => 0x010a, 0xcc => 0x010b, 0x012a => 0x010c, 0x013d => 0x010d, 0xbd => 0x010e, 0x2264 => 0x010f, 0xf4 => 0x0110, 0xf1 => 0x0111, 0x0170 => 0x0112, 0xc9 => 0x0113, 0x0113 => 0x0114, 0x011f => 0x0115, 0xbc => 0x0116, 0x0160 => 0x0117, 0x0218 => 0x0118, 0x0150 => 0x0119, 0xb0 => 0x011a, 0xf2 => 0x011b, 0x010c => 0x011c, 0xf9 => 0x011d, 0x221a => 0x011e, 0x010e => 0x011f, 0x0157 => 0x0120, 0xd1 => 0x0121, 0xf5 => 0x0122, 0x0156 => 0x0123, 0x013b => 0x0124, 0xc3 => 0x0125, 0x0104 => 0x0126, 0xc5 => 0x0127, 0xd5 => 0x0128, 0x017c => 0x0129, 0x011a => 0x012a, 0x012e => 0x012b, 0x0137 => 0x012c, 0x2212 => 0x012d, 0xce => 0x012e, 0x0148 => 0x012f, 0x0163 => 0x0130, 0xac => 0x0131, 0xf6 => 0x0132, 0xfc => 0x0133, 0x2260 => 0x0134, 0x0123 => 0x0135, 0xf0 => 0x0136, 0x017e => 0x0137, 0x0146 => 0x0138, 0xb9 => 0x0139, 0x012b => 0x013a, 0x20ac => 0x013b); $this->_cmap = Zend_Pdf_Cmap::cmapWithTypeData( Zend_Pdf_Cmap::TYPE_BYTE_ENCODING_STATIC, $cmapData); $this->_resource->BaseFont = new Zend_Pdf_Element_Name('Times-Bold'); } }

/* @source /library/Zend/Pdf/Resource/Font/Simple/Standard/HelveticaBoldOblique.php */
class Zend_Pdf_Resource_Font_Simple_Standard_HelveticaBoldOblique extends Zend_Pdf_Resource_Font_Simple_Standard { public function __construct() { parent::__construct(); $this->_fontNames[Zend_Pdf_Font::NAME_COPYRIGHT]['en'] = "\x00\x43\x00\x6f\x00\x70\x00\x79\x00\x72\x00\x69\x00\x67\x00\x68\x00" . "\x74\x00\x20\x00\x28\x00\x63\x00\x29\x00\x20\x00\x31\x00\x39\x00" . "\x38\x00\x35\x00\x2c\x00\x20\x00\x31\x00\x39\x00\x38\x00\x37\x00" . "\x2c\x00\x20\x00\x31\x00\x39\x00\x38\x00\x39\x00\x2c\x00\x20\x00" . "\x31\x00\x39\x00\x39\x00\x30\x00\x2c\x00\x20\x00\x31\x00\x39\x00" . "\x39\x00\x37\x00\x20\x00\x41\x00\x64\x00\x6f\x00\x62\x00\x65\x00" . "\x20\x00\x53\x00\x79\x00\x73\x00\x74\x00\x65\x00\x6d\x00\x73\x00" . "\x20\x00\x49\x00\x6e\x00\x63\x00\x6f\x00\x72\x00\x70\x00\x6f\x00" . "\x72\x00\x61\x00\x74\x00\x65\x00\x64\x00\x2e\x00\x20\x00\x20\x00" . "\x41\x00\x6c\x00\x6c\x00\x20\x00\x52\x00\x69\x00\x67\x00\x68\x00" . "\x74\x00\x73\x00\x20\x00\x52\x00\x65\x00\x73\x00\x65\x00\x72\x00" . "\x76\x00\x65\x00\x64\x00\x2e\x00\x48\x00\x65\x00\x6c\x00\x76\x00" . "\x65\x00\x74\x00\x69\x00\x63\x00\x61\x00\x20\x00\x69\x00\x73\x00" . "\x20\x00\x61\x00\x20\x00\x74\x00\x72\x00\x61\x00\x64\x00\x65\x00" . "\x6d\x00\x61\x00\x72\x00\x6b\x00\x20\x00\x6f\x00\x66\x00\x20\x00" . "\x4c\x00\x69\x00\x6e\x00\x6f\x00\x74\x00\x79\x00\x70\x00\x65\x00" . "\x2d\x00\x48\x00\x65\x00\x6c\x00\x6c\x00\x20\x00\x41\x00\x47\x00" . "\x20\x00\x61\x00\x6e\x00\x64\x00\x2f\x00\x6f\x00\x72\x00\x20\x00" . "\x69\x00\x74\x00\x73\x00\x20\x00\x73\x00\x75\x00\x62\x00\x73\x00" . "\x69\x00\x64\x00\x69\x00\x61\x00\x72\x00\x69\x00\x65\x00\x73\x00" . "\x2e"; $this->_fontNames[Zend_Pdf_Font::NAME_FAMILY]['en'] = "\x00\x48\x00\x65\x00\x6c\x00\x76\x00\x65\x00\x74\x00\x69\x00\x63\x00" . "\x61"; $this->_fontNames[Zend_Pdf_Font::NAME_STYLE]['en'] = "\x00\x42\x00\x6f\x00\x6c\x00\x64"; $this->_fontNames[Zend_Pdf_Font::NAME_ID]['en'] = "\x00\x34\x00\x33\x00\x30\x00\x35\x00\x33"; $this->_fontNames[Zend_Pdf_Font::NAME_FULL]['en'] = "\x00\x48\x00\x65\x00\x6c\x00\x76\x00\x65\x00\x74\x00\x69\x00\x63\x00" . "\x61\x00\x2d\x00\x42\x00\x6f\x00\x6c\x00\x64\x00\x4f\x00\x62\x00" . "\x6c\x00\x69\x00\x71\x00\x75\x00\x65\x00\x20\x00\x42\x00\x6f\x00" . "\x6c\x00\x64"; $this->_fontNames[Zend_Pdf_Font::NAME_VERSION]['en'] = "\x00\x30\x00\x30\x00\x32\x00\x2e\x00\x30\x00\x30\x00\x30"; $this->_fontNames[Zend_Pdf_Font::NAME_POSTSCRIPT]['en'] = "\x00\x48\x00\x65\x00\x6c\x00\x76\x00\x65\x00\x74\x00\x69\x00\x63\x00" . "\x61\x00\x2d\x00\x42\x00\x6f\x00\x6c\x00\x64\x00\x4f\x00\x62\x00" . "\x6c\x00\x69\x00\x71\x00\x75\x00\x65"; $this->_isBold = true; $this->_isItalic = true; $this->_isMonospaced = false; $this->_underlinePosition = -100; $this->_underlineThickness = 50; $this->_strikePosition = 225; $this->_strikeThickness = 50; $this->_unitsPerEm = 1000; $this->_ascent = 718; $this->_descent = -207; $this->_lineGap = 275; $this->_glyphWidths = array( 0x00 => 0x01f4, 0x01 => 0x0116, 0x02 => 0x014d, 0x03 => 0x01da, 0x04 => 0x022c, 0x05 => 0x022c, 0x06 => 0x0379, 0x07 => 0x02d2, 0x08 => 0x0116, 0x09 => 0x014d, 0x0a => 0x014d, 0x0b => 0x0185, 0x0c => 0x0248, 0x0d => 0x0116, 0x0e => 0x014d, 0x0f => 0x0116, 0x10 => 0x0116, 0x11 => 0x022c, 0x12 => 0x022c, 0x13 => 0x022c, 0x14 => 0x022c, 0x15 => 0x022c, 0x16 => 0x022c, 0x17 => 0x022c, 0x18 => 0x022c, 0x19 => 0x022c, 0x1a => 0x022c, 0x1b => 0x014d, 0x1c => 0x014d, 0x1d => 0x0248, 0x1e => 0x0248, 0x1f => 0x0248, 0x20 => 0x0263, 0x21 => 0x03cf, 0x22 => 0x02d2, 0x23 => 0x02d2, 0x24 => 0x02d2, 0x25 => 0x02d2, 0x26 => 0x029b, 0x27 => 0x0263, 0x28 => 0x030a, 0x29 => 0x02d2, 0x2a => 0x0116, 0x2b => 0x022c, 0x2c => 0x02d2, 0x2d => 0x0263, 0x2e => 0x0341, 0x2f => 0x02d2, 0x30 => 0x030a, 0x31 => 0x029b, 0x32 => 0x030a, 0x33 => 0x02d2, 0x34 => 0x029b, 0x35 => 0x0263, 0x36 => 0x02d2, 0x37 => 0x029b, 0x38 => 0x03b0, 0x39 => 0x029b, 0x3a => 0x029b, 0x3b => 0x0263, 0x3c => 0x014d, 0x3d => 0x0116, 0x3e => 0x014d, 0x3f => 0x0248, 0x40 => 0x022c, 0x41 => 0x0116, 0x42 => 0x022c, 0x43 => 0x0263, 0x44 => 0x022c, 0x45 => 0x0263, 0x46 => 0x022c, 0x47 => 0x014d, 0x48 => 0x0263, 0x49 => 0x0263, 0x4a => 0x0116, 0x4b => 0x0116, 0x4c => 0x022c, 0x4d => 0x0116, 0x4e => 0x0379, 0x4f => 0x0263, 0x50 => 0x0263, 0x51 => 0x0263, 0x52 => 0x0263, 0x53 => 0x0185, 0x54 => 0x022c, 0x55 => 0x014d, 0x56 => 0x0263, 0x57 => 0x022c, 0x58 => 0x030a, 0x59 => 0x022c, 0x5a => 0x022c, 0x5b => 0x01f4, 0x5c => 0x0185, 0x5d => 0x0118, 0x5e => 0x0185, 0x5f => 0x0248, 0x60 => 0x014d, 0x61 => 0x022c, 0x62 => 0x022c, 0x63 => 0xa7, 0x64 => 0x022c, 0x65 => 0x022c, 0x66 => 0x022c, 0x67 => 0x022c, 0x68 => 0xee, 0x69 => 0x01f4, 0x6a => 0x022c, 0x6b => 0x014d, 0x6c => 0x014d, 0x6d => 0x0263, 0x6e => 0x0263, 0x6f => 0x022c, 0x70 => 0x022c, 0x71 => 0x022c, 0x72 => 0x0116, 0x73 => 0x022c, 0x74 => 0x015e, 0x75 => 0x0116, 0x76 => 0x01f4, 0x77 => 0x01f4, 0x78 => 0x022c, 0x79 => 0x03e8, 0x7a => 0x03e8, 0x7b => 0x0263, 0x7c => 0x014d, 0x7d => 0x014d, 0x7e => 0x014d, 0x7f => 0x014d, 0x80 => 0x014d, 0x81 => 0x014d, 0x82 => 0x014d, 0x83 => 0x014d, 0x84 => 0x014d, 0x85 => 0x014d, 0x86 => 0x014d, 0x87 => 0x014d, 0x88 => 0x014d, 0x89 => 0x03e8, 0x8a => 0x03e8, 0x8b => 0x0172, 0x8c => 0x0263, 0x8d => 0x030a, 0x8e => 0x03e8, 0x8f => 0x016d, 0x90 => 0x0379, 0x91 => 0x0116, 0x92 => 0x0116, 0x93 => 0x0263, 0x94 => 0x03b0, 0x95 => 0x0263, 0x96 => 0x0116, 0x97 => 0x022c, 0x98 => 0x022c, 0x99 => 0x0263, 0x9a => 0x022c, 0x9b => 0x029b, 0x9c => 0x0248, 0x9d => 0x029b, 0x9e => 0x02d2, 0x9f => 0x022c, 0xa0 => 0x02d2, 0xa1 => 0x022c, 0xa2 => 0x022c, 0xa3 => 0x022c, 0xa4 => 0x02d2, 0xa5 => 0x02d2, 0xa6 => 0x022c, 0xa7 => 0x02d2, 0xa8 => 0x0263, 0xa9 => 0x029b, 0xaa => 0x02d2, 0xab => 0xfa, 0xac => 0x02e1, 0xad => 0x029b, 0xae => 0x022c, 0xaf => 0x022c, 0xb0 => 0x02d2, 0xb1 => 0x0116, 0xb2 => 0x022c, 0xb3 => 0x0263, 0xb4 => 0x02d2, 0xb5 => 0x022c, 0xb6 => 0x029b, 0xb7 => 0x022c, 0xb8 => 0x022c, 0xb9 => 0x0116, 0xba => 0x01ee, 0xbb => 0x02d2, 0xbc => 0x030a, 0xbd => 0x0263, 0xbe => 0x022c, 0xbf => 0x02d2, 0xc0 => 0x0185, 0xc1 => 0x022c, 0xc2 => 0x0263, 0xc3 => 0x029b, 0xc4 => 0x030a, 0xc5 => 0x02d2, 0xc6 => 0x029b, 0xc7 => 0x02e7, 0xc8 => 0x02d2, 0xc9 => 0x0263, 0xca => 0x014d, 0xcb => 0x030a, 0xcc => 0x02d2, 0xcd => 0x02d2, 0xce => 0x0248, 0xcf => 0x0263, 0xd0 => 0x0263, 0xd1 => 0x01ee, 0xd2 => 0x022c, 0xd3 => 0x02d2, 0xd4 => 0x0116, 0xd5 => 0x029b, 0xd6 => 0x022c, 0xd7 => 0x022c, 0xd8 => 0x022c, 0xd9 => 0x0263, 0xda => 0x0263, 0xdb => 0x02d2, 0xdc => 0x0116, 0xdd => 0x0248, 0xde => 0x0118, 0xdf => 0x02e1, 0xe0 => 0x030a, 0xe1 => 0x0116, 0xe2 => 0x0258, 0xe3 => 0x029b, 0xe4 => 0x0185, 0xe5 => 0x0263, 0xe6 => 0x0263, 0xe7 => 0x0263, 0xe8 => 0x0225, 0xe9 => 0x02d2, 0xea => 0x02d2, 0xeb => 0x0116, 0xec => 0x0185, 0xed => 0x022c, 0xee => 0x02d2, 0xef => 0x02d2, 0xf0 => 0x02d2, 0xf1 => 0x022c, 0xf2 => 0x01f4, 0xf3 => 0x0116, 0xf4 => 0x030a, 0xf5 => 0x0263, 0xf6 => 0x022c, 0xf7 => 0x022c, 0xf8 => 0x0116, 0xf9 => 0x030a, 0xfa => 0x02d2, 0xfb => 0x0264, 0xfc => 0x0263, 0xfd => 0x014d, 0xfe => 0x030a, 0xff => 0x0263, 0x0100 => 0x0116, 0x0101 => 0x0263, 0x0102 => 0x029b, 0x0103 => 0x0263, 0x0104 => 0x0342, 0x0105 => 0x029b, 0x0106 => 0x0190, 0x0107 => 0x02d2, 0x0108 => 0x0263, 0x0109 => 0x03e8, 0x010a => 0x022c, 0x010b => 0x0116, 0x010c => 0x0116, 0x010d => 0x0263, 0x010e => 0x0342, 0x010f => 0x0225, 0x0110 => 0x0263, 0x0111 => 0x0263, 0x0112 => 0x02d2, 0x0113 => 0x029b, 0x0114 => 0x022c, 0x0115 => 0x0263, 0x0116 => 0x0342, 0x0117 => 0x029b, 0x0118 => 0x029b, 0x0119 => 0x030a, 0x011a => 0x0190, 0x011b => 0x0263, 0x011c => 0x02d2, 0x011d => 0x0263, 0x011e => 0x0225, 0x011f => 0x02d2, 0x0120 => 0x0185, 0x0121 => 0x02d2, 0x0122 => 0x0263, 0x0123 => 0x02d2, 0x0124 => 0x0263, 0x0125 => 0x02d2, 0x0126 => 0x02d2, 0x0127 => 0x02d2, 0x0128 => 0x030a, 0x0129 => 0x01f4, 0x012a => 0x029b, 0x012b => 0x0116, 0x012c => 0x022c, 0x012d => 0x0248, 0x012e => 0x0116, 0x012f => 0x0263, 0x0130 => 0x014d, 0x0131 => 0x0248, 0x0132 => 0x0263, 0x0133 => 0x0263, 0x0134 => 0x0225, 0x0135 => 0x0263, 0x0136 => 0x0263, 0x0137 => 0x01f4, 0x0138 => 0x0263, 0x0139 => 0x014d, 0x013a => 0x0116, 0x013b => 0x022c, ); $cmapData = array( 0x20 => 0x01, 0x21 => 0x02, 0x22 => 0x03, 0x23 => 0x04, 0x24 => 0x05, 0x25 => 0x06, 0x26 => 0x07, 0x2019 => 0x08, 0x28 => 0x09, 0x29 => 0x0a, 0x2a => 0x0b, 0x2b => 0x0c, 0x2c => 0x0d, 0x2d => 0x0e, 0x2e => 0x0f, 0x2f => 0x10, 0x30 => 0x11, 0x31 => 0x12, 0x32 => 0x13, 0x33 => 0x14, 0x34 => 0x15, 0x35 => 0x16, 0x36 => 0x17, 0x37 => 0x18, 0x38 => 0x19, 0x39 => 0x1a, 0x3a => 0x1b, 0x3b => 0x1c, 0x3c => 0x1d, 0x3d => 0x1e, 0x3e => 0x1f, 0x3f => 0x20, 0x40 => 0x21, 0x41 => 0x22, 0x42 => 0x23, 0x43 => 0x24, 0x44 => 0x25, 0x45 => 0x26, 0x46 => 0x27, 0x47 => 0x28, 0x48 => 0x29, 0x49 => 0x2a, 0x4a => 0x2b, 0x4b => 0x2c, 0x4c => 0x2d, 0x4d => 0x2e, 0x4e => 0x2f, 0x4f => 0x30, 0x50 => 0x31, 0x51 => 0x32, 0x52 => 0x33, 0x53 => 0x34, 0x54 => 0x35, 0x55 => 0x36, 0x56 => 0x37, 0x57 => 0x38, 0x58 => 0x39, 0x59 => 0x3a, 0x5a => 0x3b, 0x5b => 0x3c, 0x5c => 0x3d, 0x5d => 0x3e, 0x5e => 0x3f, 0x5f => 0x40, 0x2018 => 0x41, 0x61 => 0x42, 0x62 => 0x43, 0x63 => 0x44, 0x64 => 0x45, 0x65 => 0x46, 0x66 => 0x47, 0x67 => 0x48, 0x68 => 0x49, 0x69 => 0x4a, 0x6a => 0x4b, 0x6b => 0x4c, 0x6c => 0x4d, 0x6d => 0x4e, 0x6e => 0x4f, 0x6f => 0x50, 0x70 => 0x51, 0x71 => 0x52, 0x72 => 0x53, 0x73 => 0x54, 0x74 => 0x55, 0x75 => 0x56, 0x76 => 0x57, 0x77 => 0x58, 0x78 => 0x59, 0x79 => 0x5a, 0x7a => 0x5b, 0x7b => 0x5c, 0x7c => 0x5d, 0x7d => 0x5e, 0x7e => 0x5f, 0xa1 => 0x60, 0xa2 => 0x61, 0xa3 => 0x62, 0x2044 => 0x63, 0xa5 => 0x64, 0x0192 => 0x65, 0xa7 => 0x66, 0xa4 => 0x67, 0x27 => 0x68, 0x201c => 0x69, 0xab => 0x6a, 0x2039 => 0x6b, 0x203a => 0x6c, 0xfb01 => 0x6d, 0xfb02 => 0x6e, 0x2013 => 0x6f, 0x2020 => 0x70, 0x2021 => 0x71, 0xb7 => 0x72, 0xb6 => 0x73, 0x2022 => 0x74, 0x201a => 0x75, 0x201e => 0x76, 0x201d => 0x77, 0xbb => 0x78, 0x2026 => 0x79, 0x2030 => 0x7a, 0xbf => 0x7b, 0x60 => 0x7c, 0xb4 => 0x7d, 0x02c6 => 0x7e, 0x02dc => 0x7f, 0xaf => 0x80, 0x02d8 => 0x81, 0x02d9 => 0x82, 0xa8 => 0x83, 0x02da => 0x84, 0xb8 => 0x85, 0x02dd => 0x86, 0x02db => 0x87, 0x02c7 => 0x88, 0x2014 => 0x89, 0xc6 => 0x8a, 0xaa => 0x8b, 0x0141 => 0x8c, 0xd8 => 0x8d, 0x0152 => 0x8e, 0xba => 0x8f, 0xe6 => 0x90, 0x0131 => 0x91, 0x0142 => 0x92, 0xf8 => 0x93, 0x0153 => 0x94, 0xdf => 0x95, 0xcf => 0x96, 0xe9 => 0x97, 0x0103 => 0x98, 0x0171 => 0x99, 0x011b => 0x9a, 0x0178 => 0x9b, 0xf7 => 0x9c, 0xdd => 0x9d, 0xc2 => 0x9e, 0xe1 => 0x9f, 0xdb => 0xa0, 0xfd => 0xa1, 0x0219 => 0xa2, 0xea => 0xa3, 0x016e => 0xa4, 0xdc => 0xa5, 0x0105 => 0xa6, 0xda => 0xa7, 0x0173 => 0xa8, 0xcb => 0xa9, 0x0110 => 0xaa, 0xf6c3 => 0xab, 0xa9 => 0xac, 0x0112 => 0xad, 0x010d => 0xae, 0xe5 => 0xaf, 0x0145 => 0xb0, 0x013a => 0xb1, 0xe0 => 0xb2, 0x0162 => 0xb3, 0x0106 => 0xb4, 0xe3 => 0xb5, 0x0116 => 0xb6, 0x0161 => 0xb7, 0x015f => 0xb8, 0xed => 0xb9, 0x25ca => 0xba, 0x0158 => 0xbb, 0x0122 => 0xbc, 0xfb => 0xbd, 0xe2 => 0xbe, 0x0100 => 0xbf, 0x0159 => 0xc0, 0xe7 => 0xc1, 0x017b => 0xc2, 0xde => 0xc3, 0x014c => 0xc4, 0x0154 => 0xc5, 0x015a => 0xc6, 0x010f => 0xc7, 0x016a => 0xc8, 0x016f => 0xc9, 0xb3 => 0xca, 0xd2 => 0xcb, 0xc0 => 0xcc, 0x0102 => 0xcd, 0xd7 => 0xce, 0xfa => 0xcf, 0x0164 => 0xd0, 0x2202 => 0xd1, 0xff => 0xd2, 0x0143 => 0xd3, 0xee => 0xd4, 0xca => 0xd5, 0xe4 => 0xd6, 0xeb => 0xd7, 0x0107 => 0xd8, 0x0144 => 0xd9, 0x016b => 0xda, 0x0147 => 0xdb, 0xcd => 0xdc, 0xb1 => 0xdd, 0xa6 => 0xde, 0xae => 0xdf, 0x011e => 0xe0, 0x0130 => 0xe1, 0x2211 => 0xe2, 0xc8 => 0xe3, 0x0155 => 0xe4, 0x014d => 0xe5, 0x0179 => 0xe6, 0x017d => 0xe7, 0x2265 => 0xe8, 0xd0 => 0xe9, 0xc7 => 0xea, 0x013c => 0xeb, 0x0165 => 0xec, 0x0119 => 0xed, 0x0172 => 0xee, 0xc1 => 0xef, 0xc4 => 0xf0, 0xe8 => 0xf1, 0x017a => 0xf2, 0x012f => 0xf3, 0xd3 => 0xf4, 0xf3 => 0xf5, 0x0101 => 0xf6, 0x015b => 0xf7, 0xef => 0xf8, 0xd4 => 0xf9, 0xd9 => 0xfa, 0x2206 => 0xfb, 0xfe => 0xfc, 0xb2 => 0xfd, 0xd6 => 0xfe, 0xb5 => 0xff, 0xec => 0x0100, 0x0151 => 0x0101, 0x0118 => 0x0102, 0x0111 => 0x0103, 0xbe => 0x0104, 0x015e => 0x0105, 0x013e => 0x0106, 0x0136 => 0x0107, 0x0139 => 0x0108, 0x2122 => 0x0109, 0x0117 => 0x010a, 0xcc => 0x010b, 0x012a => 0x010c, 0x013d => 0x010d, 0xbd => 0x010e, 0x2264 => 0x010f, 0xf4 => 0x0110, 0xf1 => 0x0111, 0x0170 => 0x0112, 0xc9 => 0x0113, 0x0113 => 0x0114, 0x011f => 0x0115, 0xbc => 0x0116, 0x0160 => 0x0117, 0x0218 => 0x0118, 0x0150 => 0x0119, 0xb0 => 0x011a, 0xf2 => 0x011b, 0x010c => 0x011c, 0xf9 => 0x011d, 0x221a => 0x011e, 0x010e => 0x011f, 0x0157 => 0x0120, 0xd1 => 0x0121, 0xf5 => 0x0122, 0x0156 => 0x0123, 0x013b => 0x0124, 0xc3 => 0x0125, 0x0104 => 0x0126, 0xc5 => 0x0127, 0xd5 => 0x0128, 0x017c => 0x0129, 0x011a => 0x012a, 0x012e => 0x012b, 0x0137 => 0x012c, 0x2212 => 0x012d, 0xce => 0x012e, 0x0148 => 0x012f, 0x0163 => 0x0130, 0xac => 0x0131, 0xf6 => 0x0132, 0xfc => 0x0133, 0x2260 => 0x0134, 0x0123 => 0x0135, 0xf0 => 0x0136, 0x017e => 0x0137, 0x0146 => 0x0138, 0xb9 => 0x0139, 0x012b => 0x013a, 0x20ac => 0x013b); $this->_cmap = Zend_Pdf_Cmap::cmapWithTypeData( Zend_Pdf_Cmap::TYPE_BYTE_ENCODING_STATIC, $cmapData); $this->_resource->BaseFont = new Zend_Pdf_Element_Name('Helvetica-BoldOblique'); } }

/* @source /library/Zend/Pdf/Resource/Font/Simple/Standard/TimesRoman.php */
class Zend_Pdf_Resource_Font_Simple_Standard_TimesRoman extends Zend_Pdf_Resource_Font_Simple_Standard { public function __construct() { parent::__construct(); $this->_fontNames[Zend_Pdf_Font::NAME_COPYRIGHT]['en'] = "\x00\x43\x00\x6f\x00\x70\x00\x79\x00\x72\x00\x69\x00\x67\x00\x68\x00" . "\x74\x00\x20\x00\x28\x00\x63\x00\x29\x00\x20\x00\x31\x00\x39\x00" . "\x38\x00\x35\x00\x2c\x00\x20\x00\x31\x00\x39\x00\x38\x00\x37\x00" . "\x2c\x00\x20\x00\x31\x00\x39\x00\x38\x00\x39\x00\x2c\x00\x20\x00" . "\x31\x00\x39\x00\x39\x00\x30\x00\x2c\x00\x20\x00\x31\x00\x39\x00" . "\x39\x00\x33\x00\x2c\x00\x20\x00\x31\x00\x39\x00\x39\x00\x37\x00" . "\x20\x00\x41\x00\x64\x00\x6f\x00\x62\x00\x65\x00\x20\x00\x53\x00" . "\x79\x00\x73\x00\x74\x00\x65\x00\x6d\x00\x73\x00\x20\x00\x49\x00" . "\x6e\x00\x63\x00\x6f\x00\x72\x00\x70\x00\x6f\x00\x72\x00\x61\x00" . "\x74\x00\x65\x00\x64\x00\x2e\x00\x20\x00\x20\x00\x41\x00\x6c\x00" . "\x6c\x00\x20\x00\x52\x00\x69\x00\x67\x00\x68\x00\x74\x00\x73\x00" . "\x20\x00\x52\x00\x65\x00\x73\x00\x65\x00\x72\x00\x76\x00\x65\x00" . "\x64\x00\x2e\x00\x54\x00\x69\x00\x6d\x00\x65\x00\x73\x00\x20\x00" . "\x69\x00\x73\x00\x20\x00\x61\x00\x20\x00\x74\x00\x72\x00\x61\x00" . "\x64\x00\x65\x00\x6d\x00\x61\x00\x72\x00\x6b\x00\x20\x00\x6f\x00" . "\x66\x00\x20\x00\x4c\x00\x69\x00\x6e\x00\x6f\x00\x74\x00\x79\x00" . "\x70\x00\x65\x00\x2d\x00\x48\x00\x65\x00\x6c\x00\x6c\x00\x20\x00" . "\x41\x00\x47\x00\x20\x00\x61\x00\x6e\x00\x64\x00\x2f\x00\x6f\x00" . "\x72\x00\x20\x00\x69\x00\x74\x00\x73\x00\x20\x00\x73\x00\x75\x00" . "\x62\x00\x73\x00\x69\x00\x64\x00\x69\x00\x61\x00\x72\x00\x69\x00" . "\x65\x00\x73\x00\x2e"; $this->_fontNames[Zend_Pdf_Font::NAME_FAMILY]['en'] = "\x00\x54\x00\x69\x00\x6d\x00\x65\x00\x73"; $this->_fontNames[Zend_Pdf_Font::NAME_STYLE]['en'] = "\x00\x52\x00\x6f\x00\x6d\x00\x61\x00\x6e"; $this->_fontNames[Zend_Pdf_Font::NAME_ID]['en'] = "\x00\x34\x00\x33\x00\x30\x00\x36\x00\x38"; $this->_fontNames[Zend_Pdf_Font::NAME_FULL]['en'] = "\x00\x54\x00\x69\x00\x6d\x00\x65\x00\x73\x00\x2d\x00\x52\x00\x6f\x00" . "\x6d\x00\x61\x00\x6e\x00\x20\x00\x52\x00\x6f\x00\x6d\x00\x61\x00" . "\x6e"; $this->_fontNames[Zend_Pdf_Font::NAME_VERSION]['en'] = "\x00\x30\x00\x30\x00\x32\x00\x2e\x00\x30\x00\x30\x00\x30"; $this->_fontNames[Zend_Pdf_Font::NAME_POSTSCRIPT]['en'] = "\x00\x54\x00\x69\x00\x6d\x00\x65\x00\x73\x00\x2d\x00\x52\x00\x6f\x00" . "\x6d\x00\x61\x00\x6e"; $this->_isBold = false; $this->_isItalic = false; $this->_isMonospaced = false; $this->_underlinePosition = -100; $this->_underlineThickness = 50; $this->_strikePosition = 225; $this->_strikeThickness = 50; $this->_unitsPerEm = 1000; $this->_ascent = 683; $this->_descent = -217; $this->_lineGap = 300; $this->_glyphWidths = array( 0x00 => 0x01f4, 0x01 => 0xfa, 0x02 => 0x014d, 0x03 => 0x0198, 0x04 => 0x01f4, 0x05 => 0x01f4, 0x06 => 0x0341, 0x07 => 0x030a, 0x08 => 0x014d, 0x09 => 0x014d, 0x0a => 0x014d, 0x0b => 0x01f4, 0x0c => 0x0234, 0x0d => 0xfa, 0x0e => 0x014d, 0x0f => 0xfa, 0x10 => 0x0116, 0x11 => 0x01f4, 0x12 => 0x01f4, 0x13 => 0x01f4, 0x14 => 0x01f4, 0x15 => 0x01f4, 0x16 => 0x01f4, 0x17 => 0x01f4, 0x18 => 0x01f4, 0x19 => 0x01f4, 0x1a => 0x01f4, 0x1b => 0x0116, 0x1c => 0x0116, 0x1d => 0x0234, 0x1e => 0x0234, 0x1f => 0x0234, 0x20 => 0x01bc, 0x21 => 0x0399, 0x22 => 0x02d2, 0x23 => 0x029b, 0x24 => 0x029b, 0x25 => 0x02d2, 0x26 => 0x0263, 0x27 => 0x022c, 0x28 => 0x02d2, 0x29 => 0x02d2, 0x2a => 0x014d, 0x2b => 0x0185, 0x2c => 0x02d2, 0x2d => 0x0263, 0x2e => 0x0379, 0x2f => 0x02d2, 0x30 => 0x02d2, 0x31 => 0x022c, 0x32 => 0x02d2, 0x33 => 0x029b, 0x34 => 0x022c, 0x35 => 0x0263, 0x36 => 0x02d2, 0x37 => 0x02d2, 0x38 => 0x03b0, 0x39 => 0x02d2, 0x3a => 0x02d2, 0x3b => 0x0263, 0x3c => 0x014d, 0x3d => 0x0116, 0x3e => 0x014d, 0x3f => 0x01d5, 0x40 => 0x01f4, 0x41 => 0x014d, 0x42 => 0x01bc, 0x43 => 0x01f4, 0x44 => 0x01bc, 0x45 => 0x01f4, 0x46 => 0x01bc, 0x47 => 0x014d, 0x48 => 0x01f4, 0x49 => 0x01f4, 0x4a => 0x0116, 0x4b => 0x0116, 0x4c => 0x01f4, 0x4d => 0x0116, 0x4e => 0x030a, 0x4f => 0x01f4, 0x50 => 0x01f4, 0x51 => 0x01f4, 0x52 => 0x01f4, 0x53 => 0x014d, 0x54 => 0x0185, 0x55 => 0x0116, 0x56 => 0x01f4, 0x57 => 0x01f4, 0x58 => 0x02d2, 0x59 => 0x01f4, 0x5a => 0x01f4, 0x5b => 0x01bc, 0x5c => 0x01e0, 0x5d => 0xc8, 0x5e => 0x01e0, 0x5f => 0x021d, 0x60 => 0x014d, 0x61 => 0x01f4, 0x62 => 0x01f4, 0x63 => 0xa7, 0x64 => 0x01f4, 0x65 => 0x01f4, 0x66 => 0x01f4, 0x67 => 0x01f4, 0x68 => 0xb4, 0x69 => 0x01bc, 0x6a => 0x01f4, 0x6b => 0x014d, 0x6c => 0x014d, 0x6d => 0x022c, 0x6e => 0x022c, 0x6f => 0x01f4, 0x70 => 0x01f4, 0x71 => 0x01f4, 0x72 => 0xfa, 0x73 => 0x01c5, 0x74 => 0x015e, 0x75 => 0x014d, 0x76 => 0x01bc, 0x77 => 0x01bc, 0x78 => 0x01f4, 0x79 => 0x03e8, 0x7a => 0x03e8, 0x7b => 0x01bc, 0x7c => 0x014d, 0x7d => 0x014d, 0x7e => 0x014d, 0x7f => 0x014d, 0x80 => 0x014d, 0x81 => 0x014d, 0x82 => 0x014d, 0x83 => 0x014d, 0x84 => 0x014d, 0x85 => 0x014d, 0x86 => 0x014d, 0x87 => 0x014d, 0x88 => 0x014d, 0x89 => 0x03e8, 0x8a => 0x0379, 0x8b => 0x0114, 0x8c => 0x0263, 0x8d => 0x02d2, 0x8e => 0x0379, 0x8f => 0x0136, 0x90 => 0x029b, 0x91 => 0x0116, 0x92 => 0x0116, 0x93 => 0x01f4, 0x94 => 0x02d2, 0x95 => 0x01f4, 0x96 => 0x014d, 0x97 => 0x01bc, 0x98 => 0x01bc, 0x99 => 0x01f4, 0x9a => 0x01bc, 0x9b => 0x02d2, 0x9c => 0x0234, 0x9d => 0x02d2, 0x9e => 0x02d2, 0x9f => 0x01bc, 0xa0 => 0x02d2, 0xa1 => 0x01f4, 0xa2 => 0x0185, 0xa3 => 0x01bc, 0xa4 => 0x02d2, 0xa5 => 0x02d2, 0xa6 => 0x01bc, 0xa7 => 0x02d2, 0xa8 => 0x01f4, 0xa9 => 0x0263, 0xaa => 0x02d2, 0xab => 0xfa, 0xac => 0x02f8, 0xad => 0x0263, 0xae => 0x01bc, 0xaf => 0x01bc, 0xb0 => 0x02d2, 0xb1 => 0x0116, 0xb2 => 0x01bc, 0xb3 => 0x0263, 0xb4 => 0x029b, 0xb5 => 0x01bc, 0xb6 => 0x0263, 0xb7 => 0x0185, 0xb8 => 0x0185, 0xb9 => 0x0116, 0xba => 0x01d7, 0xbb => 0x029b, 0xbc => 0x02d2, 0xbd => 0x01f4, 0xbe => 0x01bc, 0xbf => 0x02d2, 0xc0 => 0x014d, 0xc1 => 0x01bc, 0xc2 => 0x0263, 0xc3 => 0x022c, 0xc4 => 0x02d2, 0xc5 => 0x029b, 0xc6 => 0x022c, 0xc7 => 0x024c, 0xc8 => 0x02d2, 0xc9 => 0x01f4, 0xca => 0x012c, 0xcb => 0x02d2, 0xcc => 0x02d2, 0xcd => 0x02d2, 0xce => 0x0234, 0xcf => 0x01f4, 0xd0 => 0x0263, 0xd1 => 0x01dc, 0xd2 => 0x01f4, 0xd3 => 0x02d2, 0xd4 => 0x0116, 0xd5 => 0x0263, 0xd6 => 0x01bc, 0xd7 => 0x01bc, 0xd8 => 0x01bc, 0xd9 => 0x01f4, 0xda => 0x01f4, 0xdb => 0x02d2, 0xdc => 0x014d, 0xdd => 0x0234, 0xde => 0xc8, 0xdf => 0x02f8, 0xe0 => 0x02d2, 0xe1 => 0x014d, 0xe2 => 0x0258, 0xe3 => 0x0263, 0xe4 => 0x014d, 0xe5 => 0x01f4, 0xe6 => 0x0263, 0xe7 => 0x0263, 0xe8 => 0x0225, 0xe9 => 0x02d2, 0xea => 0x029b, 0xeb => 0x0116, 0xec => 0x0146, 0xed => 0x01bc, 0xee => 0x02d2, 0xef => 0x02d2, 0xf0 => 0x02d2, 0xf1 => 0x01bc, 0xf2 => 0x01bc, 0xf3 => 0x0116, 0xf4 => 0x02d2, 0xf5 => 0x01f4, 0xf6 => 0x01bc, 0xf7 => 0x0185, 0xf8 => 0x0116, 0xf9 => 0x02d2, 0xfa => 0x02d2, 0xfb => 0x0264, 0xfc => 0x01f4, 0xfd => 0x012c, 0xfe => 0x02d2, 0xff => 0x01f4, 0x0100 => 0x0116, 0x0101 => 0x01f4, 0x0102 => 0x0263, 0x0103 => 0x01f4, 0x0104 => 0x02ee, 0x0105 => 0x022c, 0x0106 => 0x0158, 0x0107 => 0x02d2, 0x0108 => 0x0263, 0x0109 => 0x03d4, 0x010a => 0x01bc, 0x010b => 0x014d, 0x010c => 0x014d, 0x010d => 0x0263, 0x010e => 0x02ee, 0x010f => 0x0225, 0x0110 => 0x01f4, 0x0111 => 0x01f4, 0x0112 => 0x02d2, 0x0113 => 0x0263, 0x0114 => 0x01bc, 0x0115 => 0x01f4, 0x0116 => 0x02ee, 0x0117 => 0x022c, 0x0118 => 0x022c, 0x0119 => 0x02d2, 0x011a => 0x0190, 0x011b => 0x01f4, 0x011c => 0x029b, 0x011d => 0x01f4, 0x011e => 0x01c5, 0x011f => 0x02d2, 0x0120 => 0x014d, 0x0121 => 0x02d2, 0x0122 => 0x01f4, 0x0123 => 0x029b, 0x0124 => 0x0263, 0x0125 => 0x02d2, 0x0126 => 0x02d2, 0x0127 => 0x02d2, 0x0128 => 0x02d2, 0x0129 => 0x01bc, 0x012a => 0x0263, 0x012b => 0x014d, 0x012c => 0x01f4, 0x012d => 0x0234, 0x012e => 0x014d, 0x012f => 0x01f4, 0x0130 => 0x0116, 0x0131 => 0x0234, 0x0132 => 0x01f4, 0x0133 => 0x01f4, 0x0134 => 0x0225, 0x0135 => 0x01f4, 0x0136 => 0x01f4, 0x0137 => 0x01bc, 0x0138 => 0x01f4, 0x0139 => 0x012c, 0x013a => 0x0116, 0x013b => 0x01f4, ); $cmapData = array( 0x20 => 0x01, 0x21 => 0x02, 0x22 => 0x03, 0x23 => 0x04, 0x24 => 0x05, 0x25 => 0x06, 0x26 => 0x07, 0x2019 => 0x08, 0x28 => 0x09, 0x29 => 0x0a, 0x2a => 0x0b, 0x2b => 0x0c, 0x2c => 0x0d, 0x2d => 0x0e, 0x2e => 0x0f, 0x2f => 0x10, 0x30 => 0x11, 0x31 => 0x12, 0x32 => 0x13, 0x33 => 0x14, 0x34 => 0x15, 0x35 => 0x16, 0x36 => 0x17, 0x37 => 0x18, 0x38 => 0x19, 0x39 => 0x1a, 0x3a => 0x1b, 0x3b => 0x1c, 0x3c => 0x1d, 0x3d => 0x1e, 0x3e => 0x1f, 0x3f => 0x20, 0x40 => 0x21, 0x41 => 0x22, 0x42 => 0x23, 0x43 => 0x24, 0x44 => 0x25, 0x45 => 0x26, 0x46 => 0x27, 0x47 => 0x28, 0x48 => 0x29, 0x49 => 0x2a, 0x4a => 0x2b, 0x4b => 0x2c, 0x4c => 0x2d, 0x4d => 0x2e, 0x4e => 0x2f, 0x4f => 0x30, 0x50 => 0x31, 0x51 => 0x32, 0x52 => 0x33, 0x53 => 0x34, 0x54 => 0x35, 0x55 => 0x36, 0x56 => 0x37, 0x57 => 0x38, 0x58 => 0x39, 0x59 => 0x3a, 0x5a => 0x3b, 0x5b => 0x3c, 0x5c => 0x3d, 0x5d => 0x3e, 0x5e => 0x3f, 0x5f => 0x40, 0x2018 => 0x41, 0x61 => 0x42, 0x62 => 0x43, 0x63 => 0x44, 0x64 => 0x45, 0x65 => 0x46, 0x66 => 0x47, 0x67 => 0x48, 0x68 => 0x49, 0x69 => 0x4a, 0x6a => 0x4b, 0x6b => 0x4c, 0x6c => 0x4d, 0x6d => 0x4e, 0x6e => 0x4f, 0x6f => 0x50, 0x70 => 0x51, 0x71 => 0x52, 0x72 => 0x53, 0x73 => 0x54, 0x74 => 0x55, 0x75 => 0x56, 0x76 => 0x57, 0x77 => 0x58, 0x78 => 0x59, 0x79 => 0x5a, 0x7a => 0x5b, 0x7b => 0x5c, 0x7c => 0x5d, 0x7d => 0x5e, 0x7e => 0x5f, 0xa1 => 0x60, 0xa2 => 0x61, 0xa3 => 0x62, 0x2044 => 0x63, 0xa5 => 0x64, 0x0192 => 0x65, 0xa7 => 0x66, 0xa4 => 0x67, 0x27 => 0x68, 0x201c => 0x69, 0xab => 0x6a, 0x2039 => 0x6b, 0x203a => 0x6c, 0xfb01 => 0x6d, 0xfb02 => 0x6e, 0x2013 => 0x6f, 0x2020 => 0x70, 0x2021 => 0x71, 0xb7 => 0x72, 0xb6 => 0x73, 0x2022 => 0x74, 0x201a => 0x75, 0x201e => 0x76, 0x201d => 0x77, 0xbb => 0x78, 0x2026 => 0x79, 0x2030 => 0x7a, 0xbf => 0x7b, 0x60 => 0x7c, 0xb4 => 0x7d, 0x02c6 => 0x7e, 0x02dc => 0x7f, 0xaf => 0x80, 0x02d8 => 0x81, 0x02d9 => 0x82, 0xa8 => 0x83, 0x02da => 0x84, 0xb8 => 0x85, 0x02dd => 0x86, 0x02db => 0x87, 0x02c7 => 0x88, 0x2014 => 0x89, 0xc6 => 0x8a, 0xaa => 0x8b, 0x0141 => 0x8c, 0xd8 => 0x8d, 0x0152 => 0x8e, 0xba => 0x8f, 0xe6 => 0x90, 0x0131 => 0x91, 0x0142 => 0x92, 0xf8 => 0x93, 0x0153 => 0x94, 0xdf => 0x95, 0xcf => 0x96, 0xe9 => 0x97, 0x0103 => 0x98, 0x0171 => 0x99, 0x011b => 0x9a, 0x0178 => 0x9b, 0xf7 => 0x9c, 0xdd => 0x9d, 0xc2 => 0x9e, 0xe1 => 0x9f, 0xdb => 0xa0, 0xfd => 0xa1, 0x0219 => 0xa2, 0xea => 0xa3, 0x016e => 0xa4, 0xdc => 0xa5, 0x0105 => 0xa6, 0xda => 0xa7, 0x0173 => 0xa8, 0xcb => 0xa9, 0x0110 => 0xaa, 0xf6c3 => 0xab, 0xa9 => 0xac, 0x0112 => 0xad, 0x010d => 0xae, 0xe5 => 0xaf, 0x0145 => 0xb0, 0x013a => 0xb1, 0xe0 => 0xb2, 0x0162 => 0xb3, 0x0106 => 0xb4, 0xe3 => 0xb5, 0x0116 => 0xb6, 0x0161 => 0xb7, 0x015f => 0xb8, 0xed => 0xb9, 0x25ca => 0xba, 0x0158 => 0xbb, 0x0122 => 0xbc, 0xfb => 0xbd, 0xe2 => 0xbe, 0x0100 => 0xbf, 0x0159 => 0xc0, 0xe7 => 0xc1, 0x017b => 0xc2, 0xde => 0xc3, 0x014c => 0xc4, 0x0154 => 0xc5, 0x015a => 0xc6, 0x010f => 0xc7, 0x016a => 0xc8, 0x016f => 0xc9, 0xb3 => 0xca, 0xd2 => 0xcb, 0xc0 => 0xcc, 0x0102 => 0xcd, 0xd7 => 0xce, 0xfa => 0xcf, 0x0164 => 0xd0, 0x2202 => 0xd1, 0xff => 0xd2, 0x0143 => 0xd3, 0xee => 0xd4, 0xca => 0xd5, 0xe4 => 0xd6, 0xeb => 0xd7, 0x0107 => 0xd8, 0x0144 => 0xd9, 0x016b => 0xda, 0x0147 => 0xdb, 0xcd => 0xdc, 0xb1 => 0xdd, 0xa6 => 0xde, 0xae => 0xdf, 0x011e => 0xe0, 0x0130 => 0xe1, 0x2211 => 0xe2, 0xc8 => 0xe3, 0x0155 => 0xe4, 0x014d => 0xe5, 0x0179 => 0xe6, 0x017d => 0xe7, 0x2265 => 0xe8, 0xd0 => 0xe9, 0xc7 => 0xea, 0x013c => 0xeb, 0x0165 => 0xec, 0x0119 => 0xed, 0x0172 => 0xee, 0xc1 => 0xef, 0xc4 => 0xf0, 0xe8 => 0xf1, 0x017a => 0xf2, 0x012f => 0xf3, 0xd3 => 0xf4, 0xf3 => 0xf5, 0x0101 => 0xf6, 0x015b => 0xf7, 0xef => 0xf8, 0xd4 => 0xf9, 0xd9 => 0xfa, 0x2206 => 0xfb, 0xfe => 0xfc, 0xb2 => 0xfd, 0xd6 => 0xfe, 0xb5 => 0xff, 0xec => 0x0100, 0x0151 => 0x0101, 0x0118 => 0x0102, 0x0111 => 0x0103, 0xbe => 0x0104, 0x015e => 0x0105, 0x013e => 0x0106, 0x0136 => 0x0107, 0x0139 => 0x0108, 0x2122 => 0x0109, 0x0117 => 0x010a, 0xcc => 0x010b, 0x012a => 0x010c, 0x013d => 0x010d, 0xbd => 0x010e, 0x2264 => 0x010f, 0xf4 => 0x0110, 0xf1 => 0x0111, 0x0170 => 0x0112, 0xc9 => 0x0113, 0x0113 => 0x0114, 0x011f => 0x0115, 0xbc => 0x0116, 0x0160 => 0x0117, 0x0218 => 0x0118, 0x0150 => 0x0119, 0xb0 => 0x011a, 0xf2 => 0x011b, 0x010c => 0x011c, 0xf9 => 0x011d, 0x221a => 0x011e, 0x010e => 0x011f, 0x0157 => 0x0120, 0xd1 => 0x0121, 0xf5 => 0x0122, 0x0156 => 0x0123, 0x013b => 0x0124, 0xc3 => 0x0125, 0x0104 => 0x0126, 0xc5 => 0x0127, 0xd5 => 0x0128, 0x017c => 0x0129, 0x011a => 0x012a, 0x012e => 0x012b, 0x0137 => 0x012c, 0x2212 => 0x012d, 0xce => 0x012e, 0x0148 => 0x012f, 0x0163 => 0x0130, 0xac => 0x0131, 0xf6 => 0x0132, 0xfc => 0x0133, 0x2260 => 0x0134, 0x0123 => 0x0135, 0xf0 => 0x0136, 0x017e => 0x0137, 0x0146 => 0x0138, 0xb9 => 0x0139, 0x012b => 0x013a, 0x20ac => 0x013b); $this->_cmap = Zend_Pdf_Cmap::cmapWithTypeData( Zend_Pdf_Cmap::TYPE_BYTE_ENCODING_STATIC, $cmapData); $this->_resource->BaseFont = new Zend_Pdf_Element_Name('Times-Roman'); } }

/* @source /library/Zend/Pdf/Resource/Font/Simple/Standard/ZapfDingbats.php */
class Zend_Pdf_Resource_Font_Simple_Standard_ZapfDingbats extends Zend_Pdf_Resource_Font_Simple_Standard { protected $_toFontEncoding = array( 0x20 => "\x20", 0x2701 => "\x21", 0x2702 => "\x22", 0x2703 => "\x23", 0x2704 => "\x24", 0x260e => "\x25", 0x2706 => "\x26", 0x2707 => "\x27", 0x2708 => "\x28", 0x2709 => "\x29", 0x261b => "\x2a", 0x261e => "\x2b", 0x270c => "\x2c", 0x270d => "\x2d", 0x270e => "\x2e", 0x270f => "\x2f", 0x2710 => "\x30", 0x2711 => "\x31", 0x2712 => "\x32", 0x2713 => "\x33", 0x2714 => "\x34", 0x2715 => "\x35", 0x2716 => "\x36", 0x2717 => "\x37", 0x2718 => "\x38", 0x2719 => "\x39", 0x271a => "\x3a", 0x271b => "\x3b", 0x271c => "\x3c", 0x271d => "\x3d", 0x271e => "\x3e", 0x271f => "\x3f", 0x2720 => "\x40", 0x2721 => "\x41", 0x2722 => "\x42", 0x2723 => "\x43", 0x2724 => "\x44", 0x2725 => "\x45", 0x2726 => "\x46", 0x2727 => "\x47", 0x2605 => "\x48", 0x2729 => "\x49", 0x272a => "\x4a", 0x272b => "\x4b", 0x272c => "\x4c", 0x272d => "\x4d", 0x272e => "\x4e", 0x272f => "\x4f", 0x2730 => "\x50", 0x2731 => "\x51", 0x2732 => "\x52", 0x2733 => "\x53", 0x2734 => "\x54", 0x2735 => "\x55", 0x2736 => "\x56", 0x2737 => "\x57", 0x2738 => "\x58", 0x2739 => "\x59", 0x273a => "\x5a", 0x273b => "\x5b", 0x273c => "\x5c", 0x273d => "\x5d", 0x273e => "\x5e", 0x273f => "\x5f", 0x2740 => "\x60", 0x2741 => "\x61", 0x2742 => "\x62", 0x2743 => "\x63", 0x2744 => "\x64", 0x2745 => "\x65", 0x2746 => "\x66", 0x2747 => "\x67", 0x2748 => "\x68", 0x2749 => "\x69", 0x274a => "\x6a", 0x274b => "\x6b", 0x25cf => "\x6c", 0x274d => "\x6d", 0x25a0 => "\x6e", 0x274f => "\x6f", 0x2750 => "\x70", 0x2751 => "\x71", 0x2752 => "\x72", 0x25b2 => "\x73", 0x25bc => "\x74", 0x25c6 => "\x75", 0x2756 => "\x76", 0x25d7 => "\x77", 0x2758 => "\x78", 0x2759 => "\x79", 0x275a => "\x7a", 0x275b => "\x7b", 0x275c => "\x7c", 0x275d => "\x7d", 0x275e => "\x7e", 0x2768 => "\x80", 0x2769 => "\x81", 0x276a => "\x82", 0x276b => "\x83", 0x276c => "\x84", 0x276d => "\x85", 0x276e => "\x86", 0x276f => "\x87", 0x2770 => "\x88", 0x2771 => "\x89", 0x2772 => "\x8a", 0x2773 => "\x8b", 0x2774 => "\x8c", 0x2775 => "\x8d", 0x2761 => "\xa1", 0x2762 => "\xa2", 0x2763 => "\xa3", 0x2764 => "\xa4", 0x2765 => "\xa5", 0x2766 => "\xa6", 0x2767 => "\xa7", 0x2663 => "\xa8", 0x2666 => "\xa9", 0x2665 => "\xaa", 0x2660 => "\xab", 0x2460 => "\xac", 0x2461 => "\xad", 0x2462 => "\xae", 0x2463 => "\xaf", 0x2464 => "\xb0", 0x2465 => "\xb1", 0x2466 => "\xb2", 0x2467 => "\xb3", 0x2468 => "\xb4", 0x2469 => "\xb5", 0x2776 => "\xb6", 0x2777 => "\xb7", 0x2778 => "\xb8", 0x2779 => "\xb9", 0x277a => "\xba", 0x277b => "\xbb", 0x277c => "\xbc", 0x277d => "\xbd", 0x277e => "\xbe", 0x277f => "\xbf", 0x2780 => "\xc0", 0x2781 => "\xc1", 0x2782 => "\xc2", 0x2783 => "\xc3", 0x2784 => "\xc4", 0x2785 => "\xc5", 0x2786 => "\xc6", 0x2787 => "\xc7", 0x2788 => "\xc8", 0x2789 => "\xc9", 0x278a => "\xca", 0x278b => "\xcb", 0x278c => "\xcc", 0x278d => "\xcd", 0x278e => "\xce", 0x278f => "\xcf", 0x2790 => "\xd0", 0x2791 => "\xd1", 0x2792 => "\xd2", 0x2793 => "\xd3", 0x2794 => "\xd4", 0x2192 => "\xd5", 0x2194 => "\xd6", 0x2195 => "\xd7", 0x2798 => "\xd8", 0x2799 => "\xd9", 0x279a => "\xda", 0x279b => "\xdb", 0x279c => "\xdc", 0x279d => "\xdd", 0x279e => "\xde", 0x279f => "\xdf", 0x27a0 => "\xe0", 0x27a1 => "\xe1", 0x27a2 => "\xe2", 0x27a3 => "\xe3", 0x27a4 => "\xe4", 0x27a5 => "\xe5", 0x27a6 => "\xe6", 0x27a7 => "\xe7", 0x27a8 => "\xe8", 0x27a9 => "\xe9", 0x27aa => "\xea", 0x27ab => "\xeb", 0x27ac => "\xec", 0x27ad => "\xed", 0x27ae => "\xee", 0x27af => "\xef", 0x27b1 => "\xf1", 0x27b2 => "\xf2", 0x27b3 => "\xf3", 0x27b4 => "\xf4", 0x27b5 => "\xf5", 0x27b6 => "\xf6", 0x27b7 => "\xf7", 0x27b8 => "\xf8", 0x27b9 => "\xf9", 0x27ba => "\xfa", 0x27bb => "\xfb", 0x27bc => "\xfc", 0x27bd => "\xfd", 0x27be => "\xfe"); protected $_fromFontEncoding = array( 0x20 => "\x00\x20", 0x21 => "\x27\x01", 0x22 => "\x27\x02", 0x23 => "\x27\x03", 0x24 => "\x27\x04", 0x25 => "\x26\x0e", 0x26 => "\x27\x06", 0x27 => "\x27\x07", 0x28 => "\x27\x08", 0x29 => "\x27\x09", 0x2a => "\x26\x1b", 0x2b => "\x26\x1e", 0x2c => "\x27\x0c", 0x2d => "\x27\x0d", 0x2e => "\x27\x0e", 0x2f => "\x27\x0f", 0x30 => "\x27\x10", 0x31 => "\x27\x11", 0x32 => "\x27\x12", 0x33 => "\x27\x13", 0x34 => "\x27\x14", 0x35 => "\x27\x15", 0x36 => "\x27\x16", 0x37 => "\x27\x17", 0x38 => "\x27\x18", 0x39 => "\x27\x19", 0x3a => "\x27\x1a", 0x3b => "\x27\x1b", 0x3c => "\x27\x1c", 0x3d => "\x27\x1d", 0x3e => "\x27\x1e", 0x3f => "\x27\x1f", 0x40 => "\x27\x20", 0x41 => "\x27\x21", 0x42 => "\x27\x22", 0x43 => "\x27\x23", 0x44 => "\x27\x24", 0x45 => "\x27\x25", 0x46 => "\x27\x26", 0x47 => "\x27\x27", 0x48 => "\x26\x05", 0x49 => "\x27\x29", 0x4a => "\x27\x2a", 0x4b => "\x27\x2b", 0x4c => "\x27\x2c", 0x4d => "\x27\x2d", 0x4e => "\x27\x2e", 0x4f => "\x27\x2f", 0x50 => "\x27\x30", 0x51 => "\x27\x31", 0x52 => "\x27\x32", 0x53 => "\x27\x33", 0x54 => "\x27\x34", 0x55 => "\x27\x35", 0x56 => "\x27\x36", 0x57 => "\x27\x37", 0x58 => "\x27\x38", 0x59 => "\x27\x39", 0x5a => "\x27\x3a", 0x5b => "\x27\x3b", 0x5c => "\x27\x3c", 0x5d => "\x27\x3d", 0x5e => "\x27\x3e", 0x5f => "\x27\x3f", 0x60 => "\x27\x40", 0x61 => "\x27\x41", 0x62 => "\x27\x42", 0x63 => "\x27\x43", 0x64 => "\x27\x44", 0x65 => "\x27\x45", 0x66 => "\x27\x46", 0x67 => "\x27\x47", 0x68 => "\x27\x48", 0x69 => "\x27\x49", 0x6a => "\x27\x4a", 0x6b => "\x27\x4b", 0x6c => "\x25\xcf", 0x6d => "\x27\x4d", 0x6e => "\x25\xa0", 0x6f => "\x27\x4f", 0x70 => "\x27\x50", 0x71 => "\x27\x51", 0x72 => "\x27\x52", 0x73 => "\x25\xb2", 0x74 => "\x25\xbc", 0x75 => "\x25\xc6", 0x76 => "\x27\x56", 0x77 => "\x25\xd7", 0x78 => "\x27\x58", 0x79 => "\x27\x59", 0x7a => "\x27\x5a", 0x7b => "\x27\x5b", 0x7c => "\x27\x5c", 0x7d => "\x27\x5d", 0x7e => "\x27\x5e", 0x80 => "\x27\x68", 0x81 => "\x27\x69", 0x82 => "\x27\x6a", 0x83 => "\x27\x6b", 0x84 => "\x27\x6c", 0x85 => "\x27\x6d", 0x86 => "\x27\x6e", 0x87 => "\x27\x6f", 0x88 => "\x27\x70", 0x89 => "\x27\x71", 0x8a => "\x27\x72", 0x8b => "\x27\x73", 0x8c => "\x27\x74", 0x8d => "\x27\x75", 0xa1 => "\x27\x61", 0xa2 => "\x27\x62", 0xa3 => "\x27\x63", 0xa4 => "\x27\x64", 0xa5 => "\x27\x65", 0xa6 => "\x27\x66", 0xa7 => "\x27\x67", 0xa8 => "\x26\x63", 0xa9 => "\x26\x66", 0xaa => "\x26\x65", 0xab => "\x26\x60", 0xac => "\x24\x60", 0xad => "\x24\x61", 0xae => "\x24\x62", 0xaf => "\x24\x63", 0xb0 => "\x24\x64", 0xb1 => "\x24\x65", 0xb2 => "\x24\x66", 0xb3 => "\x24\x67", 0xb4 => "\x24\x68", 0xb5 => "\x24\x69", 0xb6 => "\x27\x76", 0xb7 => "\x27\x77", 0xb8 => "\x27\x78", 0xb9 => "\x27\x79", 0xba => "\x27\x7a", 0xbb => "\x27\x7b", 0xbc => "\x27\x7c", 0xbd => "\x27\x7d", 0xbe => "\x27\x7e", 0xbf => "\x27\x7f", 0xc0 => "\x27\x80", 0xc1 => "\x27\x81", 0xc2 => "\x27\x82", 0xc3 => "\x27\x83", 0xc4 => "\x27\x84", 0xc5 => "\x27\x85", 0xc6 => "\x27\x86", 0xc7 => "\x27\x87", 0xc8 => "\x27\x88", 0xc9 => "\x27\x89", 0xca => "\x27\x8a", 0xcb => "\x27\x8b", 0xcc => "\x27\x8c", 0xcd => "\x27\x8d", 0xce => "\x27\x8e", 0xcf => "\x27\x8f", 0xd0 => "\x27\x90", 0xd1 => "\x27\x91", 0xd2 => "\x27\x92", 0xd3 => "\x27\x93", 0xd4 => "\x27\x94", 0xd5 => "\x21\x92", 0xd6 => "\x21\x94", 0xd7 => "\x21\x95", 0xd8 => "\x27\x98", 0xd9 => "\x27\x99", 0xda => "\x27\x9a", 0xdb => "\x27\x9b", 0xdc => "\x27\x9c", 0xdd => "\x27\x9d", 0xde => "\x27\x9e", 0xdf => "\x27\x9f", 0xe0 => "\x27\xa0", 0xe1 => "\x27\xa1", 0xe2 => "\x27\xa2", 0xe3 => "\x27\xa3", 0xe4 => "\x27\xa4", 0xe5 => "\x27\xa5", 0xe6 => "\x27\xa6", 0xe7 => "\x27\xa7", 0xe8 => "\x27\xa8", 0xe9 => "\x27\xa9", 0xea => "\x27\xaa", 0xeb => "\x27\xab", 0xec => "\x27\xac", 0xed => "\x27\xad", 0xee => "\x27\xae", 0xef => "\x27\xaf", 0xf1 => "\x27\xb1", 0xf2 => "\x27\xb2", 0xf3 => "\x27\xb3", 0xf4 => "\x27\xb4", 0xf5 => "\x27\xb5", 0xf6 => "\x27\xb6", 0xf7 => "\x27\xb7", 0xf8 => "\x27\xb8", 0xf9 => "\x27\xb9", 0xfa => "\x27\xba", 0xfb => "\x27\xbb", 0xfc => "\x27\xbc", 0xfd => "\x27\xbd", 0xfe => "\x27\xbe"); public function __construct() { parent::__construct(); $this->_fontNames[Zend_Pdf_Font::NAME_COPYRIGHT]['en'] = "\x00\x43\x00\x6f\x00\x70\x00\x79\x00\x72\x00\x69\x00\x67\x00\x68\x00" . "\x74\x00\x20\x00\x28\x00\x63\x00\x29\x00\x20\x00\x31\x00\x39\x00" . "\x38\x00\x35\x00\x2c\x00\x20\x00\x31\x00\x39\x00\x38\x00\x37\x00" . "\x2c\x00\x20\x00\x31\x00\x39\x00\x38\x00\x38\x00\x2c\x00\x20\x00" . "\x31\x00\x39\x00\x38\x00\x39\x00\x2c\x00\x20\x00\x31\x00\x39\x00" . "\x39\x00\x37\x00\x20\x00\x41\x00\x64\x00\x6f\x00\x62\x00\x65\x00" . "\x20\x00\x53\x00\x79\x00\x73\x00\x74\x00\x65\x00\x6d\x00\x73\x00" . "\x20\x00\x49\x00\x6e\x00\x63\x00\x6f\x00\x72\x00\x70\x00\x6f\x00" . "\x72\x00\x61\x00\x74\x00\x65\x00\x64\x00\x2e\x00\x20\x00\x41\x00" . "\x6c\x00\x6c\x00\x20\x00\x52\x00\x69\x00\x67\x00\x68\x00\x74\x00" . "\x73\x00\x20\x00\x52\x00\x65\x00\x73\x00\x65\x00\x72\x00\x76\x00" . "\x65\x00\x64\x00\x2e\x00\x49\x00\x54\x00\x43\x00\x20\x00\x5a\x00" . "\x61\x00\x70\x00\x66\x00\x20\x00\x44\x00\x69\x00\x6e\x00\x67\x00" . "\x62\x00\x61\x00\x74\x00\x73\x00\x20\x00\x69\x00\x73\x00\x20\x00" . "\x61\x00\x20\x00\x72\x00\x65\x00\x67\x00\x69\x00\x73\x00\x74\x00" . "\x65\x00\x72\x00\x65\x00\x64\x00\x20\x00\x74\x00\x72\x00\x61\x00" . "\x64\x00\x65\x00\x6d\x00\x61\x00\x72\x00\x6b\x00\x20\x00\x6f\x00" . "\x66\x00\x20\x00\x49\x00\x6e\x00\x74\x00\x65\x00\x72\x00\x6e\x00" . "\x61\x00\x74\x00\x69\x00\x6f\x00\x6e\x00\x61\x00\x6c\x00\x20\x00" . "\x54\x00\x79\x00\x70\x00\x65\x00\x66\x00\x61\x00\x63\x00\x65\x00" . "\x20\x00\x43\x00\x6f\x00\x72\x00\x70\x00\x6f\x00\x72\x00\x61\x00" . "\x74\x00\x69\x00\x6f\x00\x6e\x00\x2e"; $this->_fontNames[Zend_Pdf_Font::NAME_FAMILY]['en'] = "\x00\x5a\x00\x61\x00\x70\x00\x66\x00\x44\x00\x69\x00\x6e\x00\x67\x00" . "\x62\x00\x61\x00\x74\x00\x73"; $this->_fontNames[Zend_Pdf_Font::NAME_STYLE]['en'] = "\x00\x4d\x00\x65\x00\x64\x00\x69\x00\x75\x00\x6d"; $this->_fontNames[Zend_Pdf_Font::NAME_ID]['en'] = "\x00\x34\x00\x33\x00\x30\x00\x38\x00\x32"; $this->_fontNames[Zend_Pdf_Font::NAME_FULL]['en'] = "\x00\x5a\x00\x61\x00\x70\x00\x66\x00\x44\x00\x69\x00\x6e\x00\x67\x00" . "\x62\x00\x61\x00\x74\x00\x73\x00\x20\x00\x4d\x00\x65\x00\x64\x00" . "\x69\x00\x75\x00\x6d"; $this->_fontNames[Zend_Pdf_Font::NAME_VERSION]['en'] = "\x00\x30\x00\x30\x00\x32\x00\x2e\x00\x30\x00\x30\x00\x30"; $this->_fontNames[Zend_Pdf_Font::NAME_POSTSCRIPT]['en'] = "\x00\x5a\x00\x61\x00\x70\x00\x66\x00\x44\x00\x69\x00\x6e\x00\x67\x00" . "\x62\x00\x61\x00\x74\x00\x73"; $this->_isBold = false; $this->_isItalic = false; $this->_isMonospaced = false; $this->_underlinePosition = -100; $this->_underlineThickness = 50; $this->_strikePosition = 225; $this->_strikeThickness = 50; $this->_unitsPerEm = 1000; $this->_ascent = 1000; $this->_descent = 0; $this->_lineGap = 200; $this->_glyphWidths = array( 0x00 => 0x01f4, 0x01 => 0x0116, 0x02 => 0x03ce, 0x03 => 0x03c1, 0x04 => 0x03ce, 0x05 => 0x03d4, 0x06 => 0x02cf, 0x07 => 0x0315, 0x08 => 0x0316, 0x09 => 0x0317, 0x0a => 0x02b2, 0x0b => 0x03c0, 0x0c => 0x03ab, 0x0d => 0x0225, 0x0e => 0x0357, 0x0f => 0x038f, 0x10 => 0x03a5, 0x11 => 0x038f, 0x12 => 0x03b1, 0x13 => 0x03ce, 0x14 => 0x02f3, 0x15 => 0x034e, 0x16 => 0x02fa, 0x17 => 0x02f9, 0x18 => 0x023b, 0x19 => 0x02a5, 0x1a => 0x02fb, 0x1b => 0x02f8, 0x1c => 0x02f7, 0x1d => 0x02f2, 0x1e => 0x01ee, 0x1f => 0x0228, 0x20 => 0x0219, 0x21 => 0x0241, 0x22 => 0x02b4, 0x23 => 0x0312, 0x24 => 0x0314, 0x25 => 0x0314, 0x26 => 0x0316, 0x27 => 0x0319, 0x28 => 0x031a, 0x29 => 0x0330, 0x2a => 0x0337, 0x2b => 0x0315, 0x2c => 0x0349, 0x2d => 0x0337, 0x2e => 0x0341, 0x2f => 0x0330, 0x30 => 0x033f, 0x31 => 0x039b, 0x32 => 0x02e8, 0x33 => 0x02d3, 0x34 => 0x02ed, 0x35 => 0x0316, 0x36 => 0x0318, 0x37 => 0x02b7, 0x38 => 0x0308, 0x39 => 0x0300, 0x3a => 0x0318, 0x3b => 0x02f7, 0x3c => 0x02c3, 0x3d => 0x02c4, 0x3e => 0x02aa, 0x3f => 0x02bd, 0x40 => 0x033a, 0x41 => 0x032f, 0x42 => 0x0315, 0x43 => 0x0315, 0x44 => 0x02c3, 0x45 => 0x02af, 0x46 => 0x02b8, 0x47 => 0x02b1, 0x48 => 0x0312, 0x49 => 0x0313, 0x4a => 0x02c9, 0x4b => 0x0317, 0x4c => 0x0311, 0x4d => 0x0317, 0x4e => 0x0369, 0x4f => 0x02f9, 0x50 => 0x02fa, 0x51 => 0x02fa, 0x52 => 0x02f7, 0x53 => 0x02f7, 0x54 => 0x037c, 0x55 => 0x037c, 0x56 => 0x0314, 0x57 => 0x0310, 0x58 => 0x01b6, 0x59 => 0x8a, 0x5a => 0x0115, 0x5b => 0x019f, 0x5c => 0x0188, 0x5d => 0x0188, 0x5e => 0x029c, 0x5f => 0x029c, 0x60 => 0x0186, 0x61 => 0x0186, 0x62 => 0x013d, 0x63 => 0x013d, 0x64 => 0x0114, 0x65 => 0x0114, 0x66 => 0x01fd, 0x67 => 0x01fd, 0x68 => 0x019a, 0x69 => 0x019a, 0x6a => 0xea, 0x6b => 0xea, 0x6c => 0x014e, 0x6d => 0x014e, 0x6e => 0x02dc, 0x6f => 0x0220, 0x70 => 0x0220, 0x71 => 0x038e, 0x72 => 0x029b, 0x73 => 0x02f8, 0x74 => 0x02f8, 0x75 => 0x0308, 0x76 => 0x0253, 0x77 => 0x02b6, 0x78 => 0x0272, 0x79 => 0x0314, 0x7a => 0x0314, 0x7b => 0x0314, 0x7c => 0x0314, 0x7d => 0x0314, 0x7e => 0x0314, 0x7f => 0x0314, 0x80 => 0x0314, 0x81 => 0x0314, 0x82 => 0x0314, 0x83 => 0x0314, 0x84 => 0x0314, 0x85 => 0x0314, 0x86 => 0x0314, 0x87 => 0x0314, 0x88 => 0x0314, 0x89 => 0x0314, 0x8a => 0x0314, 0x8b => 0x0314, 0x8c => 0x0314, 0x8d => 0x0314, 0x8e => 0x0314, 0x8f => 0x0314, 0x90 => 0x0314, 0x91 => 0x0314, 0x92 => 0x0314, 0x93 => 0x0314, 0x94 => 0x0314, 0x95 => 0x0314, 0x96 => 0x0314, 0x97 => 0x0314, 0x98 => 0x0314, 0x99 => 0x0314, 0x9a => 0x0314, 0x9b => 0x0314, 0x9c => 0x0314, 0x9d => 0x0314, 0x9e => 0x0314, 0x9f => 0x0314, 0xa0 => 0x0314, 0xa1 => 0x037e, 0xa2 => 0x0346, 0xa3 => 0x03f8, 0xa4 => 0x01ca, 0xa5 => 0x02ec, 0xa6 => 0x039c, 0xa7 => 0x02ec, 0xa8 => 0x0396, 0xa9 => 0x039f, 0xaa => 0x03a0, 0xab => 0x03a0, 0xac => 0x0342, 0xad => 0x0369, 0xae => 0x033c, 0xaf => 0x039c, 0xb0 => 0x039c, 0xb1 => 0x0395, 0xb2 => 0x03a2, 0xb3 => 0x03a3, 0xb4 => 0x01cf, 0xb5 => 0x0373, 0xb6 => 0x0344, 0xb7 => 0x0344, 0xb8 => 0x0363, 0xb9 => 0x0363, 0xba => 0x02b8, 0xbb => 0x02b8, 0xbc => 0x036a, 0xbd => 0x036a, 0xbe => 0x02f8, 0xbf => 0x03b2, 0xc0 => 0x0303, 0xc1 => 0x0361, 0xc2 => 0x0303, 0xc3 => 0x0378, 0xc4 => 0x03c7, 0xc5 => 0x0378, 0xc6 => 0x033f, 0xc7 => 0x0369, 0xc8 => 0x039f, 0xc9 => 0x03ca, 0xca => 0x0396); $cmapData = array( 0x20 => 0x01, 0x2701 => 0x02, 0x2702 => 0x03, 0x2703 => 0x04, 0x2704 => 0x05, 0x260e => 0x06, 0x2706 => 0x07, 0x2707 => 0x08, 0x2708 => 0x09, 0x2709 => 0x0a, 0x261b => 0x0b, 0x261e => 0x0c, 0x270c => 0x0d, 0x270d => 0x0e, 0x270e => 0x0f, 0x270f => 0x10, 0x2710 => 0x11, 0x2711 => 0x12, 0x2712 => 0x13, 0x2713 => 0x14, 0x2714 => 0x15, 0x2715 => 0x16, 0x2716 => 0x17, 0x2717 => 0x18, 0x2718 => 0x19, 0x2719 => 0x1a, 0x271a => 0x1b, 0x271b => 0x1c, 0x271c => 0x1d, 0x271d => 0x1e, 0x271e => 0x1f, 0x271f => 0x20, 0x2720 => 0x21, 0x2721 => 0x22, 0x2722 => 0x23, 0x2723 => 0x24, 0x2724 => 0x25, 0x2725 => 0x26, 0x2726 => 0x27, 0x2727 => 0x28, 0x2605 => 0x29, 0x2729 => 0x2a, 0x272a => 0x2b, 0x272b => 0x2c, 0x272c => 0x2d, 0x272d => 0x2e, 0x272e => 0x2f, 0x272f => 0x30, 0x2730 => 0x31, 0x2731 => 0x32, 0x2732 => 0x33, 0x2733 => 0x34, 0x2734 => 0x35, 0x2735 => 0x36, 0x2736 => 0x37, 0x2737 => 0x38, 0x2738 => 0x39, 0x2739 => 0x3a, 0x273a => 0x3b, 0x273b => 0x3c, 0x273c => 0x3d, 0x273d => 0x3e, 0x273e => 0x3f, 0x273f => 0x40, 0x2740 => 0x41, 0x2741 => 0x42, 0x2742 => 0x43, 0x2743 => 0x44, 0x2744 => 0x45, 0x2745 => 0x46, 0x2746 => 0x47, 0x2747 => 0x48, 0x2748 => 0x49, 0x2749 => 0x4a, 0x274a => 0x4b, 0x274b => 0x4c, 0x25cf => 0x4d, 0x274d => 0x4e, 0x25a0 => 0x4f, 0x274f => 0x50, 0x2750 => 0x51, 0x2751 => 0x52, 0x2752 => 0x53, 0x25b2 => 0x54, 0x25bc => 0x55, 0x25c6 => 0x56, 0x2756 => 0x57, 0x25d7 => 0x58, 0x2758 => 0x59, 0x2759 => 0x5a, 0x275a => 0x5b, 0x275b => 0x5c, 0x275c => 0x5d, 0x275d => 0x5e, 0x275e => 0x5f, 0x2768 => 0x60, 0x2769 => 0x61, 0x276a => 0x62, 0x276b => 0x63, 0x276c => 0x64, 0x276d => 0x65, 0x276e => 0x66, 0x276f => 0x67, 0x2770 => 0x68, 0x2771 => 0x69, 0x2772 => 0x6a, 0x2773 => 0x6b, 0x2774 => 0x6c, 0x2775 => 0x6d, 0x2761 => 0x6e, 0x2762 => 0x6f, 0x2763 => 0x70, 0x2764 => 0x71, 0x2765 => 0x72, 0x2766 => 0x73, 0x2767 => 0x74, 0x2663 => 0x75, 0x2666 => 0x76, 0x2665 => 0x77, 0x2660 => 0x78, 0x2460 => 0x79, 0x2461 => 0x7a, 0x2462 => 0x7b, 0x2463 => 0x7c, 0x2464 => 0x7d, 0x2465 => 0x7e, 0x2466 => 0x7f, 0x2467 => 0x80, 0x2468 => 0x81, 0x2469 => 0x82, 0x2776 => 0x83, 0x2777 => 0x84, 0x2778 => 0x85, 0x2779 => 0x86, 0x277a => 0x87, 0x277b => 0x88, 0x277c => 0x89, 0x277d => 0x8a, 0x277e => 0x8b, 0x277f => 0x8c, 0x2780 => 0x8d, 0x2781 => 0x8e, 0x2782 => 0x8f, 0x2783 => 0x90, 0x2784 => 0x91, 0x2785 => 0x92, 0x2786 => 0x93, 0x2787 => 0x94, 0x2788 => 0x95, 0x2789 => 0x96, 0x278a => 0x97, 0x278b => 0x98, 0x278c => 0x99, 0x278d => 0x9a, 0x278e => 0x9b, 0x278f => 0x9c, 0x2790 => 0x9d, 0x2791 => 0x9e, 0x2792 => 0x9f, 0x2793 => 0xa0, 0x2794 => 0xa1, 0x2192 => 0xa2, 0x2194 => 0xa3, 0x2195 => 0xa4, 0x2798 => 0xa5, 0x2799 => 0xa6, 0x279a => 0xa7, 0x279b => 0xa8, 0x279c => 0xa9, 0x279d => 0xaa, 0x279e => 0xab, 0x279f => 0xac, 0x27a0 => 0xad, 0x27a1 => 0xae, 0x27a2 => 0xaf, 0x27a3 => 0xb0, 0x27a4 => 0xb1, 0x27a5 => 0xb2, 0x27a6 => 0xb3, 0x27a7 => 0xb4, 0x27a8 => 0xb5, 0x27a9 => 0xb6, 0x27aa => 0xb7, 0x27ab => 0xb8, 0x27ac => 0xb9, 0x27ad => 0xba, 0x27ae => 0xbb, 0x27af => 0xbc, 0x27b1 => 0xbd, 0x27b2 => 0xbe, 0x27b3 => 0xbf, 0x27b4 => 0xc0, 0x27b5 => 0xc1, 0x27b6 => 0xc2, 0x27b7 => 0xc3, 0x27b8 => 0xc4, 0x27b9 => 0xc5, 0x27ba => 0xc6, 0x27bb => 0xc7, 0x27bc => 0xc8, 0x27bd => 0xc9, 0x27be => 0xca); $this->_cmap = Zend_Pdf_Cmap::cmapWithTypeData( Zend_Pdf_Cmap::TYPE_BYTE_ENCODING_STATIC, $cmapData); $this->_resource->BaseFont = new Zend_Pdf_Element_Name('ZapfDingbats'); $this->_resource->Encoding = null; } public function encodeString($string, $charEncoding) { if ($charEncoding != 'UTF-16BE') { $string = iconv($charEncoding, 'UTF-16BE', $string); } $encodedString = ''; for ($i = 0; $i < strlen($string); $i++) { $characterCode = (ord($string[$i++]) << 8) | ord($string[$i]); if (isset($this->_toFontEncoding[$characterCode])) { $encodedString .= $this->_toFontEncoding[$characterCode]; } else { } } return $encodedString; } public function decodeString($string, $charEncoding) { $decodedString = ''; for ($i = 0; $i < strlen($string); $i++) { $characterCode = ord($string[$i]); if (isset($this->_fromFontEncoding[$characterCode])) { $decodedString .= $this->_fromFontEncoding[$characterCode]; } else { } } if ($charEncoding != 'UTF-16BE') { $decodedString = iconv('UTF-16BE', $charEncoding, $decodedString); } return $decodedString; } public function toUnicode($string, $charEncoding = '') { if ($charEncoding != 'ISO-8859-1') { $string = iconv($charEncoding, 'ISO-8859-1', $string); } return $this->decodeString($string, 'UTF-16BE'); } }

