<?php

class AbSignup_AdminCampaignController extends Am_Mvc_Controller_Grid
{
    function checkAdminPermissions(Admin $admin)
    {
        return true;
    }

    function createGrid()
    {
        $ds = new Am_Query($this->getDi()->absignupCampaignTable);
        $ds->setOrder('title');

        $grid = new Am_Grid_Editable('_ab', ___('A/B Signup Campaign'), $ds, $this->getRequest(), $this->view, $this->getDi());
        $grid->setRecordTitle(___('Campaign'));

        $this->view->headScript()
            ->appendScript($this->getJs());

        $grid->addField('is_active', ___('Active'), false)
            ->setWidth('5%')
            ->setRenderFunction([$this, 'renderActive']);

        $grid->addField('campaign_type', ___('Type'), true, null, [$this, 'renderCampaignType'], '1%');
        $grid->addField('title', ___('Title'));
        $grid->addField('type', ___('Form Type'))
            ->setRenderFunction(function($r, $fn, $g, $fo) {
                if ($r->campaign_type == Bootstrap_AbSignup::CAMPAIGN_SAVEDFORM_CUSTOM) {
                    return $g->renderTd(sprintf('<a href="%s" target="_top">%s</a>', $this->getDi()->surl("signup/{$r->code}"), ___('link')), false);
                } else {
                    return $g->renderTd($r->$fn);
                }
            });
        $grid->addField(new Am_Grid_Field_Date('begin_date', ___('Begin Date')))->setFormatDate();
        $grid->addField(new Am_Grid_Field_Date('expire_date', ___('Expire Date')))->setFormatDate();

        $grid->setFormValueCallback('roster', ['RECORD', 'unserializeList'], ['RECORD', 'serializeList']);

        $grid->setForm([$this, 'createForm']);
        $grid->addCallback(Am_Grid_ReadOnly::CB_RENDER_TABLE, [$this, 'onRenderGridContent']);

        $grid->actionDelete('insert');

        $grid->actionAdd($_ = new Am_Grid_Action_Insert('insert-' . Bootstrap_AbSignup::CAMPAIGN_SAVEDFORM, ___('New Default Form Campaign')));
        $_->addUrlParam('campaign_type', Bootstrap_AbSignup::CAMPAIGN_SAVEDFORM);

        $grid->actionAdd($_ = new Am_Grid_Action_Insert('insert-' . Bootstrap_AbSignup::CAMPAIGN_SAVEDFORM_CUSTOM, ___('New Custom Form Campaign')));
        $_->addUrlParam('campaign_type', Bootstrap_AbSignup::CAMPAIGN_SAVEDFORM_CUSTOM);

        $grid->actionAdd($_ = new Am_Grid_Action_Insert('insert-' . Bootstrap_AbSignup::CAMPAIGN_THEME, ___('New Theme Campaign')));
        $_->addUrlParam('campaign_type', Bootstrap_AbSignup::CAMPAIGN_THEME);

        return $grid;
    }

    public function renderCampaignType(Am_Record $r, $fn, $g, $fo)
    {
        static $colors = ['#a5d6a7', '#ffffcf', '#a1b2c0', '#ee8879', '#b786c7', '#addbec', '#dedede'],
            $map = [];
        if (!isset($map[$r->$fn])) {
            $map[$r->$fn] = $colors ? array_shift($colors) : '#dedede';
        }
        switch ($r->$fn) {
            case Bootstrap_AbSignup::CAMPAIGN_THEME:
                $t = ___('THEME');
                break;
            case Bootstrap_AbSignup::CAMPAIGN_SAVEDFORM:
                $t = ___('DEFAULT FORM');
                break;
            case Bootstrap_AbSignup::CAMPAIGN_SAVEDFORM_CUSTOM:
                $t = ___('CUSTOM FORM');
                break;
        }

        $c = $map[$r->$fn];
        return $g->renderTd(<<<CUT
<span style="text-transform: lowercase;
    letter-spacing: .8px;
    padding: 0.2em 0.5em;
    font-size: 80%;
    background:$c;
    white-space: nowrap;">{$t}</span>
CUT
            , false);
    }

    function createForm()
    {
        $form = new Am_Form_Admin;
        $record = $this->grid->getRecord();

        $form->addText('title', ['class' => 'am-el-wide'])
            ->setLabel(___("Campaign Title\n" .
                    "for admin reference"))
            ->addRule('required');

        $campaign_type = empty($record->campaign_type) ?
            $this->grid->getCompleteRequest()->getFiltered('campaign_type') :
            $record->campaign_type;

        $form->addHidden('campaign_type', ['value' => $campaign_type]);

        if($campaign_type == Bootstrap_AbSignup::CAMPAIGN_SAVEDFORM)
        {
            $form->addAdvRadio('type')
                ->setLabel(___('Type'))
                ->loadOptions([
                    AbsignupCampaign::T_SIGNUP => ___('Signup Form (signup)'),
                    AbsignupCampaign::T_MEMBER => ___('Renew Form (member)'),
                    AbsignupCampaign::T_BOTH => ___('Both Form (signup & member)'),
                ])->addRule('required');
        }

        if ($campaign_type == Bootstrap_AbSignup::CAMPAIGN_SAVEDFORM_CUSTOM) {
            $form->addText('code', ['id' => 'campaign-path'])
                ->setLabel('Path')
                ->addRule('required')
                ->addRule('regex', ___('Value must be alpha-numeric'), '/[a-zA-Z0-9_]/');

            $root_url = $this->getDi()->surl('signup');

            $form->addStatic()
                ->setLabel(___('Permalink'))
                ->setContent(<<<CUT
<div data-root_url="$root_url" id="campaign-permalink"></div>
CUT
                );

            $form->addScript()
                ->setScript(<<<CUT
jQuery('#campaign-path').bind('keyup', function(){
    jQuery('#campaign-permalink').closest('.am-row').toggle(jQuery(this).val() != '');
    jQuery('#campaign-permalink').html(jQuery('#campaign-permalink').data('root_url') + '/' + encodeURIComponent(jQuery(this).val()))
}).trigger('keyup')
CUT
                );
        }

        $form->addDate('begin_date')
            ->setLabel(___('Begin Date'))
            ->addRule('required');

        $form->addDate('expire_date')
            ->setLabel(___('Expire Date'))
            ->addRule('required');

        if(in_array($campaign_type, [Bootstrap_AbSignup::CAMPAIGN_SAVEDFORM, Bootstrap_AbSignup::CAMPAIGN_SAVEDFORM_CUSTOM]))
        {
            $options = [];

            foreach ($this->getDi()->savedFormTable->findByType(SavedForm::D_SIGNUP) as $f) {
                $options[$f->pk()] = "$f->code: $f->title ($f->comment)";
            }

            $form->addMagicSelect('roster')
                ->setLabel(___('Form to Include to Roster'))
                ->loadOptions($options)
                ->addRule('required');
        } else {
            $form->addMagicSelect('roster')
                ->setLabel(___('Theme to Include to Roster'))
                ->loadOptions(Am_Di::getInstance()->view->getThemes('user'))
                ->addRule('required');
        }
        return $form;
    }

    public function switchStateAction()
    {
        $campaign = $this->getDi()->absignupCampaignTable->load($this->getRequest()->getParam('id'));
        if ($campaign->is_active) {
            $campaign->updateQuick('is_active', 0);
        } else {
            $this->getDi()->absignupCampaignTable->setActive($campaign);
        }

        $state = [];
        foreach($this->getDi()->db->selectCol("SELECT is_active, campaign_id AS ARRAY_KEY FROM ?_absignup_campaign;") as $id => $status) {
            $state[] = [
                'id' => $id,
                'status' => (bool) $status
            ];
        };
        $this->getResponse()->ajaxResponse($state);
    }

    function onRenderGridContent(& $out)
    {
        $out .= <<<CUT
<style type="text/css">
<!--
.am-switch {
  width:60px;
  font-size: .8rem;
}

label.am-switch {
    display: block;
}

.am-switch .am-switch_state1,
.am-switch .am-switch_state2,
.am-switch .am-switch_on {
    width: 30px;
}

.am-switch .am-switch_state2 {
    left:30px;
}

.am-switch.am-switch_on-state2 .am-switch_on {
    left: 30px;
    background: #c2c2c2;
}

-->
</style>
CUT;
    }

    public function renderActive(Am_Record $record, $field)
    {
        return $this->renderTd($this->renderSwitch($record), false);
    }

    public function renderSwitch($record)
    {
        $state = $record->is_active ? 'am-switch_on-state1' : 'am-switch_on-state2';
        return <<<CUT
<label class="am-switch {$state}" id="campaign-{$record->pk()}" data-id="{$record->pk()}">
    <div class="am-switch_on"></div>
    <div class="am-switch_state1">On</div>
    <div class="am-switch_state2">Off</div>
</label>
CUT;

    }

    public function getJs()
    {
        $url = $this->getDi()->surl('ab-signup/admin-campaign/switch-state', false);
        return <<<CUT
jQuery(function(){
    jQuery(document).on('click', ".am-switch", function() {
        fetch(
            '{$url}?id=' + jQuery(this).data('id'),
            {headers: new Headers({"X-Requested-With": "XMLHttpRequest"}), credentials: 'same-origin'}
        )
        .then(r => r.json())
        .then(function(state){
            jQuery('.am-switch').removeClass('am-switch_on-state1 am-switch_on-state2');
            state.forEach(function(c){
                jQuery('#campaign-' + c.id).addClass(c.status ? 'am-switch_on-state1' : 'am-switch_on-state2');
            });
        })
        .catch(err => console.log(err));
    });
});
CUT;
    }
}