<?php
if (!class_exists('WPSE_WC_Attributes_Spreadsheet_Bootstrap')) {

	class WPSE_WC_Attributes_Spreadsheet_Bootstrap extends WP_Sheet_Editor_Bootstrap {

		public function __construct($args) {
			parent::__construct($args);

			if ($this->settings['register_admin_menus']) {
				add_action("woocommerce_before_add_attribute_fields", array($this, '_render_quick_access'), 10, 0);
			}
		}

		function render_quick_access() {
			
		}

		function _render_quick_access() {
			?>
			<hr><p class="wpse-quick-access"><a href="<?php echo VGSE()->helpers->get_editor_url($this->enabled_post_types[0]); ?>" class="button button-primary"><?php _e('Edit in a Spreadsheet', vgse_taxonomy_terms()->textname); ?></a></p><hr>
			<?php
		}

		function _register_columns() {
			$post_types = $this->enabled_post_types;

			foreach ($post_types as $post_type) {
				$this->columns->register_item('ID', $post_type, array(
					'data_type' => 'post_data', //String (post_data,post_meta|meta_data)	
					'unformatted' => array('data' => 'ID', 'renderer' => 'html', 'readOnly' => true), //Array (Valores admitidos por el plugin de handsontable)
					'column_width' => 75, //int (Ancho de la columna)
					'title' => __('ID', vgse_taxonomy_terms()->textname), //String (Titulo de la columna)
					'type' => '', // String (Es para saber si será un boton que abre popup, si no dejar vacio) boton_tiny|boton_gallery|boton_gallery_multiple|(vacio)
					'supports_formulas' => false,
					'allow_to_hide' => false,
					'allow_to_save' => false,
					'allow_to_rename' => false,
					'is_locked' => true,
					'formatted' => array('data' => 'ID', 'renderer' => 'html', 'readOnly' => true),
				));
				$this->columns->register_item('attribute_label', $post_type, array(
					'data_type' => 'post_data', //String (post_data,post_meta|meta_data)	
					'column_width' => 210, //int (Ancho de la columna)
					'title' => __('Label', vgse_taxonomy_terms()->textname), //String (Titulo de la columna)
					'supports_formulas' => true,
				));
				$this->columns->register_item('attribute_name', $post_type, array(
					'data_type' => 'post_data', //String (post_data,post_meta|meta_data)	
					'column_width' => 210, //int (Ancho de la columna)
					'title' => __('Name', vgse_taxonomy_terms()->textname), //String (Titulo de la columna)
					'supports_formulas' => true,
				));
				if (wc_has_custom_attribute_types()) {
					$this->columns->register_item('attribute_type', $post_type, array(
						'data_type' => 'post_data', //String (post_data,post_meta|meta_data)	
						'column_width' => 210, //int (Ancho de la columna)
						'title' => __('Name', vgse_taxonomy_terms()->textname), //String (Titulo de la columna)
						'supports_formulas' => true,
						'formatted' => array(
							'editor' => 'select',
							'selectOptions' => wc_get_attribute_types()
						),
					));
				}
				$this->columns->register_item('attribute_orderby', $post_type, array(
					'data_type' => 'post_data', //String (post_data,post_meta|meta_data)	
					'column_width' => 210, //int (Ancho de la columna)
					'title' => __('Default sort order', vgse_taxonomy_terms()->textname), //String (Titulo de la columna)
					'supports_formulas' => true,
					'formatted' => array(
						'editor' => 'select',
						'selectOptions' => array(
							'menu_order' => __('Custom ordering', 'woocommerce'),
							'name' => __('Name', 'woocommerce'),
							'name_num' => __('Name (numeric)', 'woocommerce'),
							'id' => __('Term ID', 'woocommerce'),
						)
					),
				));
				$this->columns->register_item('attribute_public', $post_type, array(
					'data_type' => 'post_data', //String (post_data,post_meta|meta_data)	
					'column_width' => 130, //int (Ancho de la columna)
					'title' => __('Enable Archives', vgse_taxonomy_terms()->textname), //String (Titulo de la columna)
					'supports_formulas' => true,
					'formatted' => array(
						'type' => 'checkbox',
						'checkedTemplate' => '1',
						'uncheckedTemplate' => '0',
					),
					'default_value' => '0',
				));
				$this->columns->register_item('wpse_status', $post_type, array(
					'data_type' => 'post_data', //String (post_data,post_meta|meta_data)	
					'column_width' => 150, //int (Ancho de la columna)
					'title' => __('Status', vgse_taxonomy_terms()->textname), //String (Titulo de la columna)
					'type' => '', // String (Es para saber si será un boton que abre popup, si no dejar vacio) boton_tiny|boton_gallery|boton_gallery_multiple|(vacio)
					'supports_formulas' => true,
					'allow_to_hide' => false,
					'allow_to_save' => true,
					'allow_to_rename' => true,
					'default_value' => 'active',
					'formatted' => array('data' => 'wpse_status', 'editor' => 'select', 'selectOptions' => array(
							'active',
							'delete',
						)),
					'save_value_callback' => array($this, 'delete_taxonomy'),
				));

				$this->columns->register_item('manage_terms', $post_type, array(
					'data_type' => 'post_data',
					'unformatted' => array('renderer' => 'wp_external_button', 'readOnly' => true),
					'column_width' => 145,
					'title' => __('Manage terms', VGSE()->textname),
					'type' => 'external_button',
					'supports_formulas' => false,
					'formatted' => array('renderer' => 'wp_external_button', 'readOnly' => true),
					'allow_to_hide' => true,
					'allow_to_save' => false,
					'allow_to_rename' => true,
					'get_value_callback' => array($this, 'get_taxonomy_spreadsheet_url_for_cell'),
				));
			}
		}

		function get_taxonomy_spreadsheet_url_for_cell($post, $cell_key, $cell_args) {
			$taxonomy_key = wc_attribute_taxonomy_name_by_id((int) $post->ID);
			$value = $taxonomy_key ? VGSE()->helpers->get_editor_url($taxonomy_key) : '';
			return $value;
		}

		function delete_taxonomy($post_id, $cell_key, $data_to_save, $post_type, $cell_args, $spreadsheet_columns) {
			global $wpdb;
			if ((int) $post_id < 1 || $data_to_save !== 'delete') {
				return;
			}
			// Try to delete with WC first, and delete with direct query as a fallback
			wc_delete_attribute($post_id);
			$wpdb->delete($wpdb->prefix . 'woocommerce_attribute_taxonomies', array('attribute_id' => (int) $post_id));
			WPSE_WC_Attributes_Sheet::clear_caches();

			VGSE()->deleted_rows_ids[] = (int) $post_id;
		}

	}

}